(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3912,         96]*)
(*NotebookOutlinePosition[      4555,        118]*)
(*  CellTagsIndexPosition[      4511,        114]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D10FAGRDSLS
  
Diffraction on an amplitude grating at normal incidence.
Width of openings d, center to center distance of strips a, wavelength \
\[Lambda], distance from grating to screen X and coordinate on Screen Y. 
    
DD(A) is the diffraction factor
II(A) is the interference factor, normalized to 1. 
P(A) is the product of Interference and diffraction factor.

All distances and wavelength in mm, number of lines n.
All parameters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        0.02;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(a\  = \ 
        0.2;\), "\[IndentingNewLine]", \(n\  = \ 
        2;\), "\[IndentingNewLine]", \(X\  = \ 4000;\), "\[IndentingNewLine]",
   
    RowBox[{\(Y\  = \ Range[\(-800\), 800, 1.3];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(DD[
          Y_] := \((Sin[\((Pi*\((d/\[Lambda])\)*\((Y/
                        X)\))\)]/\((Pi*\((d/\[Lambda])\)*\((Y/
                      X)\))\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(DDY\  = \ DD[Y];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(II[
            Y_] := \((Sin[\((Pi*\((a/\[Lambda])\)*\((Y/X)\)*n)\)]/\((n*
                    Sin[Pi*\((a/\[Lambda])\)*\((Y/X)\)])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(P[Y_] := \ 
        DD[Y]*II[Y];\), "\[IndentingNewLine]", 
    RowBox[{\(PY = \ P[Y];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{Y, DDY}], Transpose[{Y, PY}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-600\), 600}, {0, 1}}], {{{Hue[
                1], "\<DDY\>"}, {Hue[0.5], "\<PY\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{510, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2203, 44, 896, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

