(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6296,        140]*)
(*NotebookOutlinePosition[      6941,        162]*)
(*  CellTagsIndexPosition[      6897,        158]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D12FAELGRS
  
Diffraction on an echelette grating.
The graphs for three different values of \[Epsilon].
    
D(\[Theta]) is the diffraction factor, II(\[Theta]) the interfference factor, \
and P(\[Theta]) the product.
The angle in radians of the echelle is \[Epsilon]. Diffraction angle \[Theta] \
in radians, 
wavelength \[Lambda], width of openings d, and separation of openings a in \
mm.

N is the number of lines.
All parameters are defined globally above the graph.
\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        37;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        10;\), "\[IndentingNewLine]", \(a\  = \ 
        40;\), "\[IndentingNewLine]", \(n\  = \ 
        20;\), "\[IndentingNewLine]", \(\[CurlyPhi]\  = \ \(-0.2\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(\[Epsilon]1\  = \ \(-0.25\); \ \[Epsilon]2\  = \ 
        0.25; \ \[Epsilon]3 = \ \(-0.52\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-1.301\), 1.3, 0.002];\), "\[IndentingNewLine]", 
    RowBox[{\(II[\[Theta]_] := \ \((Sin[\((Pi*a*
                      Sin[\[Theta]]*\((n/\[Lambda])\))\)]/\((n*
                    Sin[Pi*a*\((Sin[\[Theta]]/\[Lambda])\)])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(D1[\[Theta]_] := \ \
\((Sin[Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta] + \[Epsilon]1]]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta] + \[Epsilon]1])\))\)^2;\), \
"\[IndentingNewLine]", \(D2[\[Theta]_] := \ \((Sin[
                Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta] + \[Epsilon]2]]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta] + \[Epsilon]2])\))\)^2;\), \
"\[IndentingNewLine]", 
    RowBox[{\(D3[\[Theta]_] := \ \((Sin[
                  Pi*\((d/\[Lambda])\)*
                    Sin[\[Theta] + \[Epsilon]3]]/\((Pi*\((d/\[Lambda])\)*
                    Sin[\[Theta] + \[Epsilon]3])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(P1[\[Theta]]\  = \ 
        D1[\[Theta]]*
          II[\[Theta]];\), "\[IndentingNewLine]", \(P2[\[Theta]]\  = \ 
        D2[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P3[\[Theta]]\  = \ D3[\[Theta]]*II[\[Theta]];\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], D1[\[Theta]]}], 
            Transpose[{\[Theta], II[\[Theta]]}], 
            Transpose[{\[Theta], P1[\[Theta]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 1}}], {{{Hue[
                  1], "\<D1[\[Theta]]\>"}, {Hue[
                  0.5], "\<II[\[Theta]]\>"}, {Hue[
                  0.25], "\<P1[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], D2[\[Theta]]}], 
            Transpose[{\[Theta], II[\[Theta]]}], 
            Transpose[{\[Theta], P2[\[Theta]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 1}}], {{{Hue[
                  1], "\<D2[\[Theta]]\>"}, {Hue[
                  0.5], "\<II[\[Theta]]\>"}, {Hue[
                  0.25], "\<P2[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], D3[\[Theta]]}], 
          Transpose[{\[Theta], II[\[Theta]]}], 
          Transpose[{\[Theta], P3[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 1}}], {{{Hue[
                1], "\<D3[\[Theta]]\>"}, {Hue[0.5], "\<II[\[Theta]]\>"}, {Hue[
                0.25], "\<P3[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{528, 537},
WindowMargins->{{Automatic, 102}, {Automatic, 7}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4587, 88, 1426, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

