(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4545,        105]*)
(*NotebookOutlinePosition[      5188,        127]*)
(*  CellTagsIndexPosition[      5144,        123]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D13FAGRRES
  
Two diffraction pattern of a grating to study resolution.
    
Diffraction on an amplitude grating with width of openings d, center to \
center
distance of strips a, wavelength \[Lambda], distance from grating to screen X \
and
coordinate on screen Y. 
    
All distances and wavelength in mm, number of lines N. Normal incidence.
All parameters are globally defined above the graph.
P(A) is the product of interference and diffraction factor.
The resolution is given as \[Lambda]/\[CapitalDelta]\[Lambda] = N and \
introduced in the formulas of the second grating.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "*)"}], "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        0.0001;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(a\  = \ 
        0.002;\), "\[IndentingNewLine]", \(n\  = \ 
        6;\), "\[IndentingNewLine]", \(\[Lambda]\[Lambda]\  = \ 
        0.0006;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-0.7001\), 0.7, 
          0.0009];\), "\[IndentingNewLine]", \(DD[\[Theta]_] := \ \
\((Sin[\((Pi*\((d/\[Lambda])\)*Sin[\[Theta]])\)]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(DDD[\[Theta]_] := \ \((Sin[\((Pi*\((d/\[Lambda]\[Lambda])\)*
                      Sin[\[Theta]])\)]/\((Pi*\((d/\[Lambda]\[Lambda])\)*
                    Sin[\[Theta]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(II[\[Theta]_] := \ \
\((Sin[Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*n]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \
\(III[\[Theta]_] := \ \((Sin[
                Pi*\((a/\[Lambda]\[Lambda])\)*Sin[\[Theta]]*n]/\((n*
                  Sin[Pi*\((a/\[Lambda]\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \(P[\
\[Theta]_] := \ DD[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(PP[\[Theta]_] := \ DDD[\[Theta]]*III[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], P[\[Theta]]}], 
          Transpose[{\[Theta], PP[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] \ {{\(-0.8\), 0.8}, {0, 1}}], {{{Hue[
                1], "\<P[\[Theta]]\>"}, {Hue[0.5], "\<PP[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", \
}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{486, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2836, 53, 1116, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

