(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4867,        110]*)
(*NotebookOutlinePosition[      5511,        132]*)
(*  CellTagsIndexPosition[      5467,        128]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D15FABAGRS
  
Babinets Theorem. Diffraction on two amplitude gratings, one with width of \
openings d1, the other with width of opening d2, and both have center to \
center distance of strips a = d1 +d2.
        
Wavelength \[Lambda], distance from gratings to screen X and coordinate on \
screen Y. All distances and wavelength in mm, both have number of lines N.
Normal incidence.
    
D1 and D2 are the diffraction factors, I is the interference factor, \
normalized to 1. 
P(A) is the product of Interference and diffraction factor.
    
Diffraction pattern of the two complementary screens, one is a grating of \
width of opening d1 the other of d2, and the periodicity constant is a = d1 + \
d2\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d2\  = \ 
        0.001;\), "\[IndentingNewLine]", \(d1\  = \ 
        0.002;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(n\  = 
        6;\), "\[IndentingNewLine]", \(a\  = \ 
        d1 + d2;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-0.5001\), 0.5, 
          0.0002];\), "\[IndentingNewLine]", \(D1[\[Theta]_] := \ \((Sin[
                Pi*\((d1/\[Lambda])\)*Sin[\[Theta]]]/\((Pi*\((d1/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(D2[\
\[Theta]_] := \ \((Sin[
                Pi*\((d2/\[Lambda])\)*Sin[\[Theta]]]/\((Pi*\((d2/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(II[\
\[Theta]_] := \ \((Sin[
                Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*n]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \(P1[\
\[Theta]_] := \ D1[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P2[\[Theta]_] := \ D2[\[Theta]]*II[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], P1[\[Theta]]}], 
          Transpose[{\[Theta], P2[\[Theta]]}], 
          Transpose[{\[Theta], D1[\[Theta]]}], 
          Transpose[{\[Theta], D2[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.6\), 0.6}, {0, 1}}], {{{Hue[
                1], "\<P1[\[Theta]]\>"}, {Hue[0.5], "\<P2[\[Theta]]\>"}, {Hue[
                0.25], "\<D1[\[Theta]]\>"}, {Hue[0.1], "\<D2[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
We see that the intensity of the diffraction peaks is different for the two \
complementary pattern,but the position of the peaks is the same, and that is \
what Babinets Principle tells us.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{489, 599},
WindowMargins->{{2, Automatic}, {Automatic, 22}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3158, 58, 1290, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

