(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4077,        100]*)
(*NotebookOutlinePosition[      4720,        122]*)
(*  CellTagsIndexPosition[      4676,        118]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D2FASLITS
  
Diffraction on a slit of width d at wavelength \[Lambda].
    
X is distance: Slit-Screen, Y is coordinate on Screen.
For small angles, Y/X is proportional to the diffraction angle \[Theta].
      
Mathematica notice the singularity at 0. For the graph we get around it using \
the range Y = -100.1, -99.1 to 100.1
All length in mm.
    
Three slits with different width d1, d2, and d3\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d1\  = \ 0.08; \ 
    d2\  = \ 0.12; \ 
    d3\  = \ 0.16;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-2\), 2, 
          0.01];\), "\[IndentingNewLine]", \(I1[\[Theta]_]\  = \ \((Sin[
                Pi*\((d1/\[Lambda])\)*
                  Sin[\((\((2*Pi)\)/
                          360)\)*\[Theta]]]/\((Pi*\((d1/\[Lambda])\)*\((\((\((\
2*Pi)\)/360)\)*\[Theta])\))\))\)^2;\), "\[IndentingNewLine]", \(I2[\[Theta]_]\
\  = \ \((Sin[Pi*\((d2/\[Lambda])\)*
                  Sin[\((\((2*Pi)\)/
                          360)\)*\[Theta]]]/\((Pi*\((d2/\[Lambda])\)*\((\((\((\
2*Pi)\)/360)\)*\[Theta])\))\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(I3[\[Theta]_]\  = \ \((Sin[
                  Pi*\((d3/\[Lambda])\)*
                    Sin[\((\((2*Pi)\)/
                            360)\)*\[Theta]]]/\((Pi*\((d3/\[Lambda])\)*\((\((\
\((2*Pi)\)/360)\)*\[Theta])\))\))\)^2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], I1[\[Theta]]}], 
          Transpose[{\[Theta], I2[\[Theta]]}], 
          Transpose[{\[Theta], I3[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<I\>"}, 
          PlotRange \[Rule] {{\(-1\), 1}, {0, 1}}], {{{Hue[
                1], "\<I1[\[Theta]]\>"}, {Hue[0.5], "\<I2[\[Theta]]\>"}, {Hue[
                0.25], "\<I3[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 584},
WindowMargins->{{2, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2368, 48, 856, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

