(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4495,        105]*)
(*NotebookOutlinePosition[      5141,        127]*)
(*  CellTagsIndexPosition[      5097,        123]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F4FASLITFTS
  
Fourier transformation of step function of width 0 to d.
The FT of the FT is also shown\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", " ", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        20;\), "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Range[0, 255, 1];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Original\ Function\ *) \)}], "\[IndentingNewLine]", \(x\_i = \ 
        UnitStep[i] - UnitStep[i - \((d)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, Re[x\_i]}], 
            Transpose[{i, Im[x\_i]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.5\), 1.5}}], {{{Hue[
                  1], \*"\"\<Re[\!\(x\_i\)]\>\""}, {Hue[
                  0.5], \*"\"\<Im[\!\(x\_i\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ Transform\ *) \)}], "\[IndentingNewLine]", \(c\_i\  = \ 
        Fourier[x\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i/255, Re[c\_i]}], 
            Transpose[{i/255, Im[c\_i]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(i\/255\)\>\"", "\<\>"}, 
            PlotRange \[Rule] {{0, 0.6}, {\(-1\), 2}}], {{{Hue[
                  1], \*"\"\<Re[\!\(c\_i\)]\>\""}, {Hue[
                  0.5], \*"\"\<Im[\!\(c\_i\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
      "(*", " ", Cell[
        "Fourier transform - inverse of fourier transformation"], " ", 
        "*)"}]}], "\[IndentingNewLine]", \(z\_i\  = \ 
        InverseFourier[c\_i];\), "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i, Re[z\_i]}], Transpose[{i, Im[z\_i]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {\(-0.5\), 1.5}}], {{{Hue[
                1], \*"\"\<Re[\!\(z\_i\)]\>\""}, {Hue[
                0.5], \*"\"\<Im[\!\(z\_i\)]\>\""}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 596},
WindowMargins->{{Automatic, 124}, {21, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2786, 53, 933, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

