(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2883,         76]*)
(*NotebookOutlinePosition[      3526,         98]*)
(*  CellTagsIndexPosition[      3482,         94]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D5FARECTS
The diffraction pattern of a rectangular aperture.
      
The width in the x-direction is d, in y-direction a.
One may look at the plot from different angles, change colors and make a \
\"Contour Plot\".\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(n\  = \ 
          40;\)}], "\[IndentingNewLine]", \(\[Lambda] = \ 
        4;\), "\[IndentingNewLine]", \(d\  = \ 4;\), "\[IndentingNewLine]", 
    RowBox[{\(a\  = \ 3;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(f[x_, 
          y_] = \ \((\((Sin[
                    2*Pi*d*\((x/\((2*\[Lambda])\))\)]/\((2*Pi*
                      d*\((x/\((2*\[Lambda])\))\))\))\)^2)\)*\((\((Sin[
                    2*Pi*d*\((y/\((2*\[Lambda])\))\)]/\((2*Pi*
                      d*\((y/\((2*\[Lambda])\))\))\))\)^2)\);\), "\
\[IndentingNewLine]", \(M = \ 
        Table[f[\(-4\) + 0.20001*i, \(-4\) + 0.20001*j], {i, 0, n, 1}, {j, 0, 
            n, 1}];\), "\[IndentingNewLine]", \(ListPlot3D[M, 
        PlotRange \[Rule] {{0, 40}, {0, 40}, {0, 1}}, 
        PlotLabel \[Rule] "\<M\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{2, Automatic}, {Automatic, 1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1174, 24, 440, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

