(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3761,         95]*)
(*NotebookOutlinePosition[      4408,        117]*)
(*  CellTagsIndexPosition[      4364,        113]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D6FARONS
Diffraction on a round aperture of radius a, using wavelength \[Lambda]
  
The graph is nor normalized.
X is distance: Slit-Screen, R is coordinate on Screen,
All length in mm, paramaters are globally defined above the graph.
    
    
Three round apertures with different radii a1,a2 and a3.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(a1\  = \ 1.5; \ 
    a2\  = \ 3; \ 
    a3\  = \ 6;\), "\[IndentingNewLine]", \(X\  = \ 
        1000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.01;\), "\[IndentingNewLine]", \(R\  = \ 
        Range[\(-10.01\), 10.01, 0.1];\), "\[IndentingNewLine]", \(I1[
          R_] := \ \((BesselJ[1, 
                2*Pi*a1*\((R/\((\[Lambda]*X)\))\)]/\((2*Pi*
                  a1*\((R/\((\[Lambda]*
                          X)\))\))\))\)^2;\), "\[IndentingNewLine]", \(I2[
          R_] := \ \((BesselJ[1, 
                2*Pi*a2*\((R/\((\[Lambda]*X)\))\)]/\((2*Pi*
                  a2*\((R/\((\[Lambda]*
                          X)\))\))\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(I3[
            R_] := \ \((BesselJ[1, 
                  2*Pi*a3*\((R/\((\[Lambda]*X)\))\)]/\((2*Pi*
                    a3*\((R/\((\[Lambda]*X)\))\))\))\)^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{R, I1[R]}], Transpose[{R, I2[R]}], 
          Transpose[{R, I3[R]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<R\>", "\<I\>"}, 
          PlotRange \[Rule] {{\(-15\), 10}, {0, 0.3}}], {{{Hue[
                1], "\<I1[R]\>"}, {Hue[0.5], "\<I2[R]\>"}, {Hue[
                0.25], "\<I3[R]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{434, 599},
WindowMargins->{{Automatic, 79}, {-266, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2052, 43, 896, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

