(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3070,         84]*)
(*NotebookOutlinePosition[      3714,        106]*)
(*  CellTagsIndexPosition[      3670,        102]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D7FARON3DS
  
3D diffraction pattern of a round aperture as a circular symmetric plot using \
two coordinates.
    
Radius of aperture is a.
The coordinate on the observation screen is R.
Wavelength \[Lambda], distance from aperture to screen is X.
    
One may look at the plot from different angles, change colors and make a \
\"Contour Plot\".\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(n\  = \ 
          30;\)}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(d\  = \ 
        2;\), "\[IndentingNewLine]", \(a\  = \ 
        0.1;\), "\[IndentingNewLine]", \(R[x_, y_] := \ 
        Sqrt[x^2 + y^2];\), "\[IndentingNewLine]", \(g[x_, 
          y_] := \ \((BesselJ[
                1, \((2*Pi*a*\((R[x, y]/\((X*\[Lambda])\))\))\)]/\((2*Pi*
                  a*\((R[x, 
                        y]/\((X*\[Lambda])\))\))\))\)^2;\), "\
\[IndentingNewLine]", 
    RowBox[{\(M\  = \ 
          Table[g[\(-20\)\  + \ 1.5001*i, \(-20\) + 1.5001*j], {i, 0, n, 
              1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListPlot3D[M, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.3}}, 
        PlotLabel -> "\<M\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{410, 549},
WindowMargins->{{8, Automatic}, {Automatic, -4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1361, 32, 700, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

