(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2997,         80]*)
(*NotebookOutlinePosition[      3640,        102]*)
(*  CellTagsIndexPosition[      3596,         98]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D8FARONEXS
  
Graph of part of the diffraction pattern of a round aperture of radius a and \
wavelength \[Lambda].
    
The graph is not normalized.
X is distance; Slit-Screen,
R is coordinate on Screen,
All length in mm, paramaters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(X\  = \ 
        1000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.010;\), "\[IndentingNewLine]", \(a\  = \ 
        1.5;\), "\[IndentingNewLine]", \(R\  = \ 
        Range[3, 10, 0.1];\), "\[IndentingNewLine]", 
    RowBox[{\(II[
            R_] := \ \((BesselJ[
                  1, \((2*Pi*a*\((R/\((\[Lambda]*X)\))\))\)]/\((2*Pi*
                    a*\((R/\((\[Lambda]*X)\))\))\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{R, II[R]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<R\>", "\<II[R]\>"}, 
          PlotRange \[Rule] {{3, 10}, {0, 0.02}}], {{{Hue[1], "\<II[R]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1288, 28, 580, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

