(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5573,        124]*)
(*NotebookOutlinePosition[      6216,        146]*)
(*  CellTagsIndexPosition[      6172,        142]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
DA1FAGRSTEP1S
  
Diffraction on a step grating with width d,center to center distance of steps \
a, height H,wavelength \[Lambda], distance from grating to screen X and \
coordinate on
Screen Y.
    
DD(\[Theta]) is the diffraction factor, II(\[Theta]) is the interference \
factor, normalized to 1.
III(\[Theta]) is the interfernce factor of the gratings with respect to the \
two planes.
P(A) is the product of interference and diffraction factors.
    
The intensity changes of the zeroth order and of the first order depend on \
the height H.
If H is a multiple of \[Lambda], all light is in the zeroth  order, if H is a \
multiple of l/2, all light is in the first order.
    
All distances and wavelength in mm, number of lines N. Normal incidence.
All parameters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(a\  = \ 
        0.002;\), "\[IndentingNewLine]", \(n\  = \ 
        6;\), "\[IndentingNewLine]", \(d\  = \ 
        0.001;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(n1\  = \ 10.25; \ n2\  = \ 10; \ 
    n3\  = \ 10.37; \ 
    n4 = \ 10.5;\), "\[IndentingNewLine]", \(H1\  = \ n1*\[Lambda]; \ 
    H2\  = \ n2*\[Lambda]; \ H3\  = \ n3*\[Lambda]; \ 
    H4\  = \ n4*\[Lambda];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\  = \ Range[\(-0.5001\), 0.5, 0.0009];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(DD[\[Theta]_] := \((\ 
            Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(II[\
\[Theta]_] := \ \((Sin[
                Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*n]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \
\(III1[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda])\)*\((d*Sin[\[Theta]] + 
                  H1)\)]^2;\), "\[IndentingNewLine]", \(III2[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda])\)*\((d*Sin[\[Theta]] + 
                  H2)\)]^2;\), "\[IndentingNewLine]", \(III3[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda])\)*\((d*Sin[\[Theta]] + 
                  H3)\)]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(III4[\[Theta]_] := \ 
          Cos[\((Pi/\[Lambda])\)*\((d*Sin[\[Theta]] + H4)\)]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(P1[\[Theta]_] := \ 
        DD[\[Theta]]*II[\[Theta]]*
          III1[\[Theta]];\), "\[IndentingNewLine]", \(P2[\[Theta]_] := \ 
        DD[\[Theta]]*II[\[Theta]]*
          III2[\[Theta]];\), "\[IndentingNewLine]", \(P3[\[Theta]_] := \ 
        DD[\[Theta]]*II[\[Theta]]*III3[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P4[\[Theta]_] := \ DD[\[Theta]]*II[\[Theta]]*III4[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], P1[\[Theta]]}], 
          Transpose[{\[Theta], P2[\[Theta]]}], 
          Transpose[{\[Theta], P3[\[Theta]]}], 
          Transpose[{\[Theta], P4[\[Theta]]}], 
          Transpose[{\[Theta], DD[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1], 
              Hue[0.45]}, AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.6\), 0.6}, {0, 1}}], {{{Hue[
                1], "\<P1[\[Theta]]\>"}, {Hue[0.5], "\<P2[\[Theta]]\>"}, {Hue[
                0.25], "\<P3[\[Theta]]\>"}, {Hue[
                0.1], "\<P4[\[Theta]]\>"}, {Hue[0.45], "\<DD[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{591, 599},
WindowMargins->{{4, Automatic}, {Automatic, 9}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3864, 72, 1170, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

