(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6446,        140]*)
(*NotebookOutlinePosition[      7091,        162]*)
(*  CellTagsIndexPosition[      7047,        158]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
C1COH2S
  
Intensity of two sources separated by s. Superposition of two double slit \
pattern.
    
The slits have width d and separation a, one pattern is untilted with \
\[CurlyPhi] = 0, the other tilted by \[CurlyPhi] = s/Z , distance from \
sources to slit is Z.
Distance from slit to screen is X, coordinate on screen is Y, Y/X = \[Theta].
      
By enlarging \[CurlyPhi], starting from 0, one finds the first \"fringe \
disappearence\". If \[CurlyPhi] is further enlarged, the fringes reappear, \
but now the minima are not zero.
Another point of view: Fringes may disapear for constant s and changing a.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(d\  = \ 
        0.05;\), "\[IndentingNewLine]", \(a\  = \ 
        1;\), "\[IndentingNewLine]", \(Z\  = \ 
        9000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(s1\  = \ 0; \ s2\  = \ 1.5; \ 
    s3\  = \ 2.25; \ s4\  = \ 2.6;\), "\[IndentingNewLine]", 
    RowBox[{\(\[CurlyPhi]1\  = \ s1/Z; \ \[CurlyPhi]2\  = \ 
        s2/Z; \ \[CurlyPhi]3\  = \ s3/Z; \ \ \[CurlyPhi]4\  = \ s4/Z;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Theta] = Range[\(-0.006\), 0.006, 0.000007];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(I1[\[Theta]_] := \ 
          Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]\^2\/\((Pi*\((d/\[Lambda])\)*\
Sin[\[Theta]])\)\^2*Cos[Pi*\((a/\[Lambda])\)*Sin[\[Theta]]]\^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(II1[\[Theta]_] := \ 
          Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]\^2\/\((Pi*\((d/\[Lambda])\)*\
Sin[\[Theta]])\)\^2*
            Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + Sin[\[CurlyPhi]1])\)]\
\^2;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(II2[\[Theta]_] := \ 
          
          Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]\^2\/\((Pi*\((d/\[Lambda])\)*\
Sin[\[Theta]])\)\^2*
            Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + Sin[\[CurlyPhi]2])\)]\
\^2;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(II3[\[Theta]_] := \ 
          Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]\^2\/\((Pi*\((d/\[Lambda])\)*\
Sin[\[Theta]])\)\^2*
            Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + Sin[\[CurlyPhi]3])\)]\
\^2;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(II4[\[Theta]_] := \ 
          Sin[Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]\^2\/\((Pi*\((d/\[Lambda])\)*\
Sin[\[Theta]])\)\^2*
            Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + Sin[\[CurlyPhi]4])\)]\
\^2;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], I1[\[Theta]] + II1[\[Theta]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.006\), 0.006}, {0, 2}}], {{{Hue[
                  1], "\<I1[\[Theta]]+II1[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], I1[\[Theta]] + II2[\[Theta]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.006\), 0.006}, {0, 2}}], {{{Hue[
                  1], "\<I1[\[Theta]]+II2[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], I1[\[Theta]] + II3[\[Theta]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.006\), 0.006}, {0, 1}}], {{{Hue[
                  1], "\<I1[\[Theta]]+II3[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], I1[\[Theta]] + II4[\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.006\), 0.006}, {0, 1.5}}], {{{Hue[
                1], "\<I1[\[Theta]]+II4[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{587, 537},
WindowMargins->{{163, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4737, 88, 1280, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

