(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3775,         93]*)
(*NotebookOutlinePosition[      4420,        115]*)
(*  CellTagsIndexPosition[      4376,        111]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
C5MICHSTS
  
Michelson's Stellar Interferometer. Diffraction angle Y/X,wavelength \
\[Lambda],angle to be determined is \[CapitalPhi].Interferometer distance of \
Mirror M1 and M4 is h.
      
In the real set-up we change h to go from fringe pattern to no fringe \
pattern.From the difference of these two values we calculate the angle \
\[CapitalPhi].
      
In this simulation we choose an angle \[CapitalPhi] and show that the fringe \
pattern changes for the two values of h we determine. Example h equal 100 and \
95.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(\[CapitalPhi]\  \
= \ 0.00005;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(d\  = \ 
        0.5;\), "\[IndentingNewLine]", \(h\  = \ 
        95;\), "\[IndentingNewLine]", \(Y\  = \ 
        Range[\(-30\), 30, 0.1];\), "\[IndentingNewLine]", \(uI[Y_] := \ 
        Cos[Pi*d*\((Y/\((X*\[Lambda])\))\)]\^2;\), "\[IndentingNewLine]", 
    RowBox[{\(uII[Y_] := \ 
          Cos[Pi*\((\((Y/X)\)*d - h*\[CapitalPhi])\)/\[Lambda]]\^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        This\ is\ an\ indication\ if\ there\ are\ fringes\ or\ not\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{Y, uI[Y] + uII[Y]}], 
          Transpose[{Y, uI[Y]}], Transpose[{Y, uII[Y]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<u\>"}, 
          PlotRange \[Rule] {{\(-30\), 30}, {0, 1.5}}], {{{Hue[
                1], "\<uI[Y]+uII[Y]\>"}, {Hue[0.5], "\<uI[Y]\>"}, {Hue[
                0.25], "\<uII[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{549, 550},
WindowMargins->{{25, Automatic}, {Automatic, 50}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2066, 41, 776, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

