(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7787,        158]*)
(*NotebookOutlinePosition[      8433,        180]*)
(*  CellTagsIndexPosition[      8389,        176]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M11POELIPLIS

Elliptical polarized light.
Similar as discussed in FileFig.M9POELIP we plot cos(-2\[Pi]x/360) on z-axis \
and cos(-2\[Pi]x/360+\[CapitalPhi]) on y-axis.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(\[Phi]1\  = \ 
        0;\), "\[IndentingNewLine]", \(\[Phi]2\  = \ 
        Pi/4;\), "\[IndentingNewLine]", \(\[Phi]3\  = \ 
        Pi/2;\), "\[IndentingNewLine]", \(\[Phi]4\  = \ 
        3*Pi/4;\), "\[IndentingNewLine]", \(\[Phi]5\  = \ 
        Pi;\), "\[IndentingNewLine]", \(\[Phi]6\  = \ 
        5*Pi/4;\), "\[IndentingNewLine]", \(\[Phi]7 = \ 
        3*Pi/2;\), "\[IndentingNewLine]", \(\[Phi]8\  = \ 
        7*Pi/4;\), "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ Range[1, 360, 1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy1[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y2[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy2[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]2];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y3[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy3[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]3];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y4[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy4[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]4];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y5[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy5[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]5];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y6[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy6[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]6];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y7[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy7[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]7];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y8[x_] := \ 
        Cos[\(-2\)*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(yy8[x_] := \ Cos[\(-2\)*Pi*\((x/360)\) + \[Phi]8];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y1[x], yy1[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y1[x]\>", "\<yy1[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y2[x], yy2[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y2[x]\>", "\<yy2[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy2[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y3[x], yy3[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y3[x]\>", "\<yy3[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy3[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y4[x], yy4[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y4[x]\>", "\<yy4[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy4[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y5[x], yy5[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y5[x]\>", "\<yy5[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy5[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y6[x], yy6[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y6[x]\>", "\<yy6[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy6[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y7[x], yy7[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y7[x]\>", "\<yy7[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<yy7[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{y8[x], yy8[x]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<y8[x]\>", "\<yy8[x]\>"}, 
          PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                1], "\<yy8[x]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{493, 599},
WindowMargins->{{Automatic, 109}, {Automatic, -3}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 6078, 106, 1816, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

