(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5394,        122]*)
(*NotebookOutlinePosition[      6038,        144]*)
(*  CellTagsIndexPosition[      5994,        140]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M4SNELL
Snellius Law for real and imaginary angle of refraction.
      
We have n1 sin\[Theta]1=n2 sin\[Theta]2,or \
\[Theta]2=asin((n1/n2)sin\[Theta]1).For n1>n2,after \[Theta]1 is larger than \
the critical angle,\[Theta]2 becomes complex with real an imaginary part.
      
      
1. Graph of \[Theta]2=asin((n1/n2)sin\[Theta]1) from 0 to 90 for n1<n2\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 
        1.5;\), "\[IndentingNewLine]", \(\[Theta]1\  = \ 
        Range[1, 90, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]2[\[Theta]1_] := \ 
          ArcSin[\((n1/n2)\)*Sin[2*\((Pi/360)\)*\[Theta]1]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]1, Re[\[Theta]2[\[Theta]1]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]1\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                  1], "\<Re[\[Theta]2[\[Theta]1]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
2. Graph of \[Theta]2=asin((nn1/nn2)sin\[Theta]1) from 0 to 90 for n1>n2\
\>"], " ", "*)"}]}], "\[IndentingNewLine]", \(nn1\  = \ 
        1.5;\), "\[IndentingNewLine]", \(nn2\  = \ 
        1;\), "\[IndentingNewLine]", \(\[Theta]1\  = \ 
        Range[1, 90, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]2[\[Theta]1] := 
          ArcSin[\((nn1/nn2)\)*Sin[2*\((Pi/360)\)*\[Theta]1]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]1, Re[\[Theta]2[\[Theta]1]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]1\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 60}, {0, 2}}], {{{Hue[
                  1], "\<Re[\[Theta]2[\[Theta]1]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Graphs\ of\ real\ and\ imaginary\ pars\ \(\(separately\)\(.\)\)\ \
*) \), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]1, Re[\[Theta]2[\[Theta]1]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]1\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 2}}], {{{Hue[
                  1], "\<Re[\[Theta]2[\[Theta]1]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]1, Im[\[Theta]2[\[Theta]1]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]1\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-1\), 0}}], {{{Hue[
                  1], "\<Im[\[Theta]2[\[Theta]1]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]c\  = \ 360\/\(2*Pi\)*ArcSin[nn2\/nn1]\ ;\), 
      "   ", \( (*\ \[Theta]c\  = \ 41.81\ *) \)}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{505, 599},
WindowMargins->{{15, Automatic}, {2, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3685, 70, 1176, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

