(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5823,        137]*)
(*NotebookOutlinePosition[      6468,        159]*)
(*  CellTagsIndexPosition[      6424,        155]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M5FRINTN2L
Intensities
    
Fresnel's formulas as function of angle of incidence for n1<n2
for Rp = rp^2, Rs = rs^2, and Tp = 1- Rp, Ts = 1-Rs

      
1. Amplitude reflection coefficients.
\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(n2\  = \ 1.5;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0, 90, 0.4];\), "\[IndentingNewLine]", 
    RowBox[{\(rp[\[Theta]_] := \((\((n2/n1)\)*Cos[2*\((Pi/360)\)*\[Theta]] - 
                Sqrt[1 - \((\((n1/n2)\)*
                          Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\)/\((\((n2/
                      n1)\)*Cos[2*\((Pi/360)\)*\[Theta]] + 
                Sqrt[1 - \((\((n1/n2)\)*
                          Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(rs[\[Theta]_] := \((Cos[2*\((Pi/360)\)*\[Theta]] - \((n2/n1)\)*
                  Sqrt[1 - \((\((n1/n2)\)*
                            Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\)/\((Cos[
                  2*\((Pi/360)\)*\[Theta]] + \((n2/n1)\)*
                  Sqrt[1 - \((\((n1/n2)\)*
                            Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ \(Reflection : \ 
            Intensities\)\ *) \)}], "\[IndentingNewLine]", \(Rp[\[Theta]_] := 
        rp[\[Theta]]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(Rs[\[Theta]_] := rs[\[Theta]]^2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ p - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], rp[\[Theta]]^2}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                  1], \*"\"\<rp[\[Theta]\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ s - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], rs[\[Theta]]^2}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                  1], \*"\"\<rs[\[Theta]\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
3. Transmission: Intensities.
\
\>"], "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(Tp[\[Theta]_] := 
        1 - Rp[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(Ts[\[Theta]_] := 1 - Rs[\[Theta]];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ p - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Tp[\[Theta]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                  1], "\<Tp[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        s - case\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], Ts[\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                1], "\<Ts[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{525, 398},
WindowMargins->{{Automatic, 64}, {81, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4114, 85, 1350, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

