(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4522,        109]*)
(*NotebookOutlinePosition[      5165,        131]*)
(*  CellTagsIndexPosition[      5121,        127]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M7FREVA
Penetration into the less dense medium at total reflection.
Exponential factor for decrease of amplitude into the less
dense medium with-Y for two different refractive indices n1 and nn1 and \
n2=nn2.

\[Theta]c is the critical angle
The value \"a\" is used to \"be off\" the critical angle.
    
 First we set\
\>"], "*)"}], 
      "\[IndentingNewLine]", \(<< 
          Graphics`Legend`;\)}], "\[IndentingNewLine]", \(<< 
        Graphics`MultipleListPlot`;\), "\[IndentingNewLine]", \(a\  = \ 
        2;\), "\[IndentingNewLine]", \(A = \ 
        1;\), "\[IndentingNewLine]", \(n1\  = \ 
        1.5;\), "\[IndentingNewLine]", \(n2\  = \ 
        1;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(nn1\  = \ 
        3.4;\), "\[IndentingNewLine]", \(nn2\  = \ 
        1;\), "\[IndentingNewLine]", \(Y\  = \ 
        Range[\(-0.00005\), \(-0.001\), \(-0.00005\)];\), \
"\[IndentingNewLine]", \(z = \ 
        ArcSin[n2/n1];\), "\[IndentingNewLine]", \(zz = \ 
        ArcSin[nn2/nn1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]1c\  = \ z*\((360/\((2*Pi)\))\);\), 
      " ", \( (*\ \[Theta]1c\  = \ 41.81\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]2c\  = \ 
          zz*\((360/\((2*Pi)\))\);\), \( (*\ \[Theta]2c\  = \ 17.105\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]1 = \ \
\[Theta]1c\  + \ a;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]2 = \ \[Theta]2c\  + \ a;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(k2 = \ 
        2*\((Pi/\[Lambda])\)*n2;\), "\[IndentingNewLine]", 
    RowBox[{\(kk2 = \ 2*\((Pi/\[Lambda])\)*nn2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1[Y_] := 
        A*\[ExponentialE]\^\(Y*k2*\@\(\((n1*Sin[\((\((2*Pi)\)/360)\)*\[Theta]\
1]\/n2)\)\^2 - 1\)\);\), "\[IndentingNewLine]", 
    RowBox[{\(y2[Y_] := 
          A*\[ExponentialE]\^\(Y*kk2*\@\(\((nn1*Sin[\((\((2*Pi)\)/360)\)*\
\[Theta]2]\/nn2)\)\^2 - 1\)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{Y, y1[Y]}], Transpose[{Y, y2[Y]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<Y\>", "\<y\>"}, 
            PlotRange \[Rule] {{\(-1\)*10\^\(-3\), 0}, {0, 1}}], {{{Hue[
                  1], "\<y1[Y]\>"}, {Hue[0.5], "\<y2[Y]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", Cell["\<\
To study different angles,make refractive indices the same for both and \
change \"a\" to values larger than 2.\
\>"], " ", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{499, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2813, 57, 1075, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

