(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3638,         92]*)
(*NotebookOutlinePosition[      4283,        114]*)
(*  CellTagsIndexPosition[      4239,        110]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
N1RECBOX
Modes of the rectangular box in two dimensions Standing sine waves in x and y \
direction. Mode number and constants.
x direction n1 and a
y direction n2 and b
  
The wave in each direction is shown and Contour and surface plots.The square \
is also shown as surface plot.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(n\  = \ 
          20;\)}], "\[IndentingNewLine]", \(n1\  = \ 
        2;\), "\[IndentingNewLine]", \(n2\  = \ 
        2;\), "\[IndentingNewLine]", \(a\  = \ 
        40;\), "\[IndentingNewLine]", \(b\  = \ 
        40;\), "\[IndentingNewLine]", \(\[Lambda]1\  = \ 
        2\ *\ \((a/n1)\);\), "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]2\  = \ 2\ *\ \((b/n2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1[x_] := \ 
        Sin[2*Pi*\((x/\[Lambda]1)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(y2[y_] := \ Sin[2*Pi*\((y/\[Lambda]2)\)];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Amplitude, \ 
        2  D\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(M11\  = \ 
          Table[y1[\(-40\) + 2.001*i]*y2[\(-40\) + 2.001*j], {i, 0, n, 
              1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListContourPlot[M11, 
        PlotLabel -> "\<M11\>"];\), "\[IndentingNewLine]", 
    RowBox[{\(ListPlot3D[M11, PlotLabel -> "\<M11\>"];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Intensity, \ 
        2  D\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(M11\  = \ 
          Table[\((y1[\(-40\) + 2.001*i]*y2[\(-40\) + 2.001*j])\)^2, {i, 0, 
              n, 1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListContourPlot[M11, 
        PlotLabel -> "\<M11\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M11, 
        PlotLabel -> "\<M11\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 537},
WindowMargins->{{Automatic, 30}, {Automatic, 40}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1929, 40, 750, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

