(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5704,        129]*)
(*NotebookOutlinePosition[      6349,        151]*)
(*  CellTagsIndexPosition[      6305,        147]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
N4SYMULANTb
Numerical calculation to N4SYMULANTa

1. Special case, one interface, that is d = 0.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n3 = \ 
        2;\), "\[IndentingNewLine]", \(i\  = \ \@\(-1\);\), "\
\[IndentingNewLine]", \(M11\  = \ 1;\), "\[IndentingNewLine]", \(M12\  = \ 
        0;\), "\[IndentingNewLine]", \(M21\  = \ 
        0;\), "\[IndentingNewLine]", \(M22\  = \ 1;\), "\[IndentingNewLine]", 
  
    RowBox[{\(tt\  = \(\(-2\)*\((n1*\((M21*M12 - M22*M11)\))\)\)\/\(M21 + \
M22*n1 + n3*M11 + n3*M12*n1\)*
            Conjugate[\(\(-2\)*\((n1*\((M21*M12 - M22*M11)\))\)\)\/\(M21 + \
M22*n1 + n3*M11 + n3*M12*n1\)];\), 
      "\[IndentingNewLine]", \( (*\ tt\  = \ 0.444\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(R := \ \((\(-\((\(-n3\)*M12*n1 - M22*n1 + M21 + \
n3*M11)\)\)\/\(M21 + M22*n1 + n3*M11 + n3*M12*n1\))\)\^2;\), 
      "\[IndentingNewLine]", \( (*\ R\  = \ 0.111\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", Cell["\<\
One observes that R+tt is not 1 and tt is not the transmitted power. However \
if n3*tt is the transmitted power T, one has\
\>"], " ", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(T\  = \ n3*tt;\), "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
T = 0.889  And T+R=1 
and if n1 is not 1 we have more generally to write\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(T\  = \ n3\/n1*tt;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2. \ Antireflection\ coating\ *) \), 
      "\[IndentingNewLine]", \( (*\ 
        We\ have\ from\ N4SYMULANTa\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(r\  = \ \(-\((\(-n3\)*M12*n1 - M22*n1 + M21 + \
n3*M11)\)\)\/\((M21\  + \ M22*n1\  + \ n3*\ M11\  + \ n3*M12*n1)\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        and\ with\ MM11\  = \ \(MM22\  = \ 0\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(r\  = \ \((\(-\((\(-n3\)*MM12*n1 + MM21)\)\)\/\((MM21 + \
n3*MM12*n1)\))\);\), "\[IndentingNewLine]", \( (*\ We\ have\ *) \), 
      " "}], "\[IndentingNewLine]", \(MM12[
          nn2_] := \ \(-i\)\/nn2;\), "\[IndentingNewLine]", 
    RowBox[{\(MM21[nn2_] := \ \(-i\)*nn2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        since\  - i\ cancels\ out\ we\ have\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(MM12[nn2_] := \ 
        1\/nn2;\), "\[IndentingNewLine]", 
    RowBox[{\(MM21[nn2_] := \ nn2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        We\ plot\ the\ reflected\ intensity\ as\ function\ of\ nn2\ and\ \
choose\ nn1\ and\ nn3\ *) \)}], "\[IndentingNewLine]", \(nn1\  = \ 
        1;\), "\[IndentingNewLine]", \(nn3\ \  = \ 
        1.5;\), "\[IndentingNewLine]", \(nn2\  = \ 
        Range[1.1, 4, 0.01];\), "\[IndentingNewLine]", 
    RowBox[{\(RR[
            nn2_] := \ \((\(-\((\(-nn3\)*MM12[nn2]*nn1 + \
MM21[nn2])\)\)\/\((MM21[nn2] + nn3*MM12[nn2]*nn1)\))\)\^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Graph\ of\ RR \((nn2)\)\ as\ functoin\ of\ nn2\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn2, RR[nn2]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<nn2\>", "\<\>"}, 
            PlotRange \[Rule] {{1, 3.5}, {0, 0.5}}], {{{Hue[
                  1], "\<RR[nn2]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \( (*\ 
      One\ has\ Sqrt[nn1*nn3]\  = \ 1.225\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 14}, {31, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3995, 77, 1492, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

