(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4964,        115]*)
(*NotebookOutlinePosition[      5608,        137]*)
(*  CellTagsIndexPosition[      5564,        133]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
N8CWGK
Dielectric circular waveguide, determination of k



1. Check for positive values of argument for J0,J1 and K0,K1
    
Since x=(Gamma*a)^2    and   y=(Beta*a)^2
we have for the square of the arguments of the Bessel functions\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(xx[k_] := 
        a\^2*\((\(n1\^2*4*Pi\^2\)\/\[Lambda]\^2 - 
              k\^2)\);\), "\[IndentingNewLine]", 
    RowBox[{\(yy[k_] := a\^2*\((k\^2 - \(no\^2*4*Pi\^2\)\/\[Lambda]\^2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(x[
          k_] := \ \@xx[k];\), "\[IndentingNewLine]", 
    RowBox[{\(y[k_] := \ \@yy[k];\), 
      "\[IndentingNewLine]", \( (*\ 
        We\ try\ the\ interval\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(k = \ Range[2.65, 3.8, 0.03];\), 
      "\[IndentingNewLine]", \( (*\ and\ make\ a\ graph\ *) \), 
      "\[IndentingNewLine]", \( (*\ Input\ \(Data : radius\), 
        wavelength\ and\ refractive\ indices\ *) \)}], "\[IndentingNewLine]", \
\(a\  = \ 3;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        2.39;\), "\[IndentingNewLine]", \(n1\  = \ \ 1.5;\), "\
\[IndentingNewLine]", 
    RowBox[{\(no\  = \ 1;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{k, x[k]}], Transpose[{k, y[k]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange -> {{2.6, 3.8}, {0, 20}}], {{{Hue[1], "\<x[k]\>"}, {Hue[
                  0.5], "\<y[k]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[
            Transpose[{k, \(-BesselJ[1, x[k]]\)\/\(x[k]*BesselJ[0, x[k]]\)}], 
            Transpose[{k, BesselK[1, y[k]]\/\(y[k]*BesselK[0, y[k]]\)}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange -> {{2.6, 3.8}, {\(-40\), 10}}], {{{Hue[
                  1], \*"\"\<\!\(\(-BesselJ[1, x[k]]\)\/\(x[k]*BesselJ[0, \
x[k]]\)\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(BesselK[1, y[k]]\/\(y[k]*BesselK[0, \
y[k]]\)\)\>\""}}, LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]",
       "\[IndentingNewLine]", \( (*\ 
        From\ \(graph : \ 
            First\ intersection\)\ *) \)}], "\[IndentingNewLine]", \(kk\  = \ 
        2.66;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]\[Lambda]\  = \ \((2*Pi)\)/kk;\), 
      " ", \( (*\[Lambda]\[Lambda]\  = \ 2.362\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\( (*\ Side\ calculation . \ If\ *) \), 
      " ", \(\(\[Lambda]\[Lambda]\[Lambda]\  = \ 8\)\(;\)\(\ \)\( (*\ 
        we\ get\ *) \)\(\ \)\(\(kkk\  = \ 
          2\ *\ Pi/\((\[Lambda]\[Lambda]\[Lambda])\)\) \)\(;\)\(\ \)\( (*\ 
        and\ kkk\  = \ 0.785\ *) \)\)}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 0}, {Automatic, 22}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3255, 63, 1273, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

