(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4275,         98]*)
(*NotebookOutlinePosition[      4918,        120]*)
(*  CellTagsIndexPosition[      4874,        116]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L12MOCY1to4S

Cylindircal Coordinates for circular mirrors in confocal resonator.Field \
distribution as contour plot for graph 00,10,01,and 11.
The L(l,p) functions are written out for 00 to 22. The constant in the \
exponential is X.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(xi[i_] := \ \(-3\)\  + \ 
            0.20001*i;\)}], "\[IndentingNewLine]", \(yj[j_] := \ \(-3\)\  + \ 
          0.20001*j;\), "\[IndentingNewLine]", \(n\  = \ 
        30;\), "\[IndentingNewLine]", \(X\  = \ 
        3;\), "\[IndentingNewLine]", \(R[x_, y_] := \ 
        x\^2 + y\^2;\), "\[IndentingNewLine]", \(\[Beta][x_, y_] := \ 
        ArcTan[x\/y];\), "\[IndentingNewLine]", \(q[x_, 
          y_] := \ \[ExponentialE]\^\(\(-\((R[x, y])\)\)\/X\);\), "\
\[IndentingNewLine]", \(u[x_, y_] := \ 4*R[x, y]\/X;\), "\[IndentingNewLine]",
   
    RowBox[{\(g[x_, y_] := \ Cos[0*\[Beta][x, y]];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(L00[x_, y_] := \ 
        1;\), "\[IndentingNewLine]", \(L01[x_, y_] := \ 
        1 - \ u[x, y];\), "\[IndentingNewLine]", \(L10[x_, y_] := \ 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(L11[x_, y_] := \ 2 - u[x, y];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(M00\  = \ 
        Table[\((Cos[0*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L00[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 
            1}];\), "\[IndentingNewLine]", \(M10\  = \ 
        Table[\((Cos[0*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L01[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 
            1}];\), "\[IndentingNewLine]", \(M01\  = \ 
        Table[\((Cos[1*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L10[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 1}];\), "\[IndentingNewLine]", 
    RowBox[{\(M11\  = \ 
          Table[\((Cos[1*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L11[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListPlot3D[M00, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 1}}, 
        PlotLabel -> "\<M00\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M10, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 4}}, 
        PlotLabel -> "\<M10\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M01, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.9}}, 
        PlotLabel -> "\<M01\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M11, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 4}}, 
        PlotLabel -> "\<M11\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{429, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2566, 46, 1190, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

