(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3345,         85]*)
(*NotebookOutlinePosition[      3989,        107]*)
(*  CellTagsIndexPosition[      3945,        103]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L1RJEANS

The Raleigh Jeans. This law gives the emitted radiation as Energy/frequency \
interval and per volume. It is given here as Ws/{(1/s)m^3}\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(c\  = \ 3*10\^8;\), 
      " ", \( (*\ m/s\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(k\  = \ 1.38*10\^\(-23\);\), 
      " ", \( (*\ W*\((s/K)\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\(T\  = \ 1000;\)\(\ \)\( (*\ K\ *) \)\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Nu]\  = \ Range[5*10\^14, 10\^12, \(-0.01\)*10\^14];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(y[\[Nu]] := \ 8*Pi*k*T*\[Nu]\^2\/c\^3;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Nu], y[\[Nu]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Nu]\>", "\<y\>"}, 
            PlotRange -> {{0, 5*10\^14}, {0, 3*10\^\(-15\)}}], {{{Hue[
                  1], "\<y[\[Nu]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
frequency                    frequency
3*10^11 is 1mm               1*10^11 is 3mm
3*10^14 is 1micron           1*10^14 is 3micron
3*10^17 is 1nm is 10A        1*10^17 is 3nm is 30A\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{2, Automatic}, {Automatic, 13}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1636, 33, 637, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

