(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4123,        101]*)
(*NotebookOutlinePosition[      4766,        123]*)
(*  CellTagsIndexPosition[      4722,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L2BBLS
    
1. Black body radiation. Graph of DL/d\[Lambda] and x = \[Lambda]
    
Constants for wavelength dependence\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(T\  = \ 
        1000;\), "\[IndentingNewLine]", \(c1\  = \ 
        1.18*10\^\(-16\);\), "\[IndentingNewLine]", \(c2\  = \ 
        1.43*10\^\(-2\);\), "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ 
          Range[3*10\^\(-5\), 10\^\(-7\), \(-0.01\)*10\^\(-5\)];\), 
      " ", \( (*\ x\ in\ meters\ *) \), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Planck' s\ Law\ depending\ on\ wavelength\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(f[x_] := \ 
          c1\/\(x\^5*\((\[ExponentialE]\^\((c2\/\(x*T\))\) - 1)\)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, f[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 3*10\^\(-5\)}, {0, 5*10\^9}}], {{{Hue[
                  1], "\<f[x]\>"}}, LegendPosition \[Rule] {1.1, \(-0\)}}];\),
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
2. Integration over the wavelength range from 3*10^-6 to 3*10^-5 meters to
obtain the Radiance.\
\>"], " ", "*)"}], "  ", "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(R = \ 
          NIntegrate[\ f[x], {x, \ \ 3*10\^\(-6\), 3*10\^\(-5\)}];\), 
      "\[IndentingNewLine]", \( (*\ Radiance\ \ R\  = \ 1.316*10^4\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
3. Multiplication with area times solid angle to obtain the Radiant energy.
Area A,Solid angle SA\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(A = \ 
        0.1;\), "\[IndentingNewLine]", \(SA\  = \ 4;\), "\[IndentingNewLine]",
   
    RowBox[{\(RR\  = \ A*SA*R;\), 
      " ", \( (*\ Radiant\ energy\ RR\ \ \ RR = \ 
          5.263*10^3\ Watts\ *) \)}], "\[IndentingNewLine]", \( (*\ 
      RR\ has\ the\ same\ value\ as\ the\ corresponding\ value\ when\ \
integrating\ over\ \(\(frequency\)\(.\)\)\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{531, 599},
WindowMargins->{{2, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2414, 49, 910, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

