(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5483,        126]*)
(*NotebookOutlinePosition[      6128,        148]*)
(*  CellTagsIndexPosition[      6084,        144]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O3OSTINS
Graphs of n and K
1. Dielectric function for models with one oscillator in the infrared \
spectral region.
      
The dielectric constant for high frequencies is set arbitrarily to \
\[Epsilon]inf=20.
The model parameters are S,\[Gamma]1,\[Nu]o. We set z=n-iK

S and \[Gamma]1 are dimensionless,
\[Nu]o in cm^-1\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(i\  = \ \@\(-1\);\), "\
\[IndentingNewLine]", \(\[Epsilon]inf\  = \ 
        20;\), "\[IndentingNewLine]", \(S1\  = \ 
        0.09;\), "\[IndentingNewLine]", \(\[Gamma]1\  = \ 
        0.02;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Nu]o1\  = \ 1050;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Nu]\  = \ Range[900, 1200, 1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(z1[\[Nu]_] := \@\(\
\[Epsilon]inf + S1\/\(1 - \((\[Nu]\/\[Nu]o1)\)\^2 - \
\(\[Gamma]1*\[Nu]\)\/\[Nu]o1\)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Nu], Re[z1[\[Nu]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Nu]\>", "\<\>"}, 
            PlotRange \[Rule] {{900, 1200}, {\(-2.5\), 15}}], {{{Hue[
                  1], "\<Re[z1[\[Nu]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Nu], Im[z1[\[Nu]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Nu]\>", "\<\>"}, 
            PlotRange \[Rule] {{900, 1200}, {\(-2.5\), 22.5}}], {{{Hue[
                  1], "\<Im[z1[\[Nu]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
2. For an optical thin medium with little absorption we have the following \
approximations. The parameters must be chosen such that n is close to 1 and K \
is small.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(a\  = \ 
        0.5*10\^\(-5\);\), "\[IndentingNewLine]", \(c\  = \ 
        10\^\(-3\);\), "\[IndentingNewLine]", \(\[Nu]\[Nu]\  = \ 
        Range[0, 2, 0.1];\), "\[IndentingNewLine]", \(n[\[Nu]\[Nu]_] := \ 
        1\  + \ a*\((\(1 - \[Nu]\[Nu]\^2\)\/\(\((1 - \[Nu]\[Nu]\^2)\)\^2 + \
\[Nu]\[Nu]\^2*c\^2\))\);\), "\[IndentingNewLine]", 
    RowBox[{\(k[\[Nu]\[Nu]_] := \ \(a*\((\[Nu]\[Nu]*c)\)\)\/\(\((1 - \[Nu]\
\[Nu]\^2)\)\^2 + \[Nu]\[Nu]\^2*c\^2\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Nu]\[Nu], n[\[Nu]\[Nu]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Nu]\[Nu]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 2}, {0.99995, 1.00005}}], {{{Hue[
                  1], "\<n[\[Nu]\[Nu]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Nu]\[Nu], k[\[Nu]\[Nu]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Nu]\[Nu]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 2}, {0, 0.006}}], {{{Hue[
                1], "\<k[\[Nu]\[Nu]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{36, Automatic}, {23, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3774, 74, 1342, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

