(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7016,        156]*)
(*NotebookOutlinePosition[      7661,        178]*)
(*  CellTagsIndexPosition[      7617,        174]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O5METALS
  
Calculation of n and K for Copper using the Drude model.
Calculation of real and imaginary part. Expression for low and high \
frequencies depending on angular frequency.
    
1. General Expression\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`Graphics`\), "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    RowBox[{\(c\  = \ 3*10\^8;\), 
      " ", \( (*\ m/s\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Sigma]\  = \ 6*10\^7;\), 
      " ", \( (*\ \((OHM\ m)\)^\(-1\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Epsilon]o\  = \ 8.85*10\^\(-12\);\), 
      " ", \( (*\ C^2/Nm\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Tau]\  = \ 1\/\(4.1*10\^11\);\), 
      " ", \( (*\ sec\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Sqrt[\(-1\)];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Angular\ frequency\ for\ 1\ mm\ wavelength\ is\ 2  \[Pi]*300*10^9\n
          see\ below\ *) \), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Omega]\  = \ Range[10^11, 10^18, \(10^18 - 10^11\)\/2000];\), 
      "\[IndentingNewLine]", \( (*\ 
        The\ general\ expression\ for\ n - iK = 
          zm \((w)\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(zm[\[Omega]_] := \ \@\(1 + \((\(i*\[Sigma]\)\/\(\[Epsilon]o*\
\[Omega]\))\)*1\/\(1 - i*\[Omega]*\[Tau]\)\);\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          LogLogListPlot[Transpose[{\[Omega], Re[zm[\[Omega]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
            PlotRange \[Rule] {{10\^11, 10\^18}, {1*10\^\(-4\), 1*10\^5}}, 
            Ticks \[Rule] {\ 
                Table[{10\^k, ToString[N[ScientificForm[10\^k]]]}, {k, 11, 
                    18, 1}], 
                Automatic}], {{{Hue[1], "\<Re[zm[\[Omega]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          LogLogListPlot[Transpose[{\[Omega], Im[zm[\[Omega]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
            PlotRange \[Rule] {{10\^11, 10\^18}, {1*10\^\(-13\), 1*10\^5}}, 
            Ticks \[Rule] {\ 
                Table[{10\^k, ToString[N[ScientificForm[10\^k]]]}, {k, 11, 
                    18, 1}], 
                Automatic}], {{{Hue[1], "\<Im[zm[\[Omega]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ High\ frequency\ limit\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(nh[\[Omega]_] := \ 
          1\  - \ \[Sigma]\/\(\[Epsilon]o*\[Omega]\^2*\[Tau]\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{
      " ", \(ShowLegend[
          MultipleListPlot[\ Transpose[{Log[10, \[Omega]], nh[\[Omega]]}], 
            Transpose[{Log[10, \[Omega]], Re[zm[\[Omega]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
            PlotRange \[Rule] {{14, 18}, {\(-1\), 1}}, 
            Ticks \[Rule] {\ 
                Table[{k, ToString[N[ScientificForm[10\^k]]]}, {k, 14, 18, 
                    1}], Automatic}], {{{Hue[1], "\<nh[\[Omega]]\>"}, {Hue[
                  0.5], "\<Re[zm[\[Omega]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Low\ frequency\ limit\ *) \)}], "\[IndentingNewLine]", \(n1[\
\[Omega]_] := \ \@\(\[Sigma]\/\(2*\[Epsilon]o*\[Omega]\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{
      " ", \(ShowLegend[
          MultipleListPlot[\ Transpose[{Log[10, \[Omega]], n1[\[Omega]]}], 
            Transpose[{Log[10, \[Omega]], Re[zm[\[Omega]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
            PlotRange \[Rule] {{11, 14}, {0, 6000}}, 
            Ticks \[Rule] {\ 
                Table[{k, ToString[N[ScientificForm[10\^k]]]}, {k, 11, 14, 
                    1}], Automatic}], {{{Hue[1], "\<n1[\[Omega]]\>"}, {Hue[
                  0.5], "\<Re[zm[\[Omega]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\)}], "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
frequency                    frequency
3*10^11 is 1mm               1*10^11 is 3mm
3*10^14 is 1micron           1*10^14 is 3micron
3*10^17 is 1nm is 10A        1*10^17 is 3nm is 30A

angular frequency
1*10^11 is 3/2Pi = 0.477 mm
1*10^14 is 0.477 micron
1*10^17 is 0.477nm is 47A\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{754, 610},
WindowMargins->{{95, Automatic}, {Automatic, 20}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5307, 104, 1576, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

