(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4701,        112]*)
(*NotebookOutlinePosition[      5348,        134]*)
(*  CellTagsIndexPosition[      5304,        130]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O6SKINS
Skin Depth
  
1. Skin depth (in meters) for intensity depending on frequency\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`Graphics`\), "\[IndentingNewLine]", 
    RowBox[{\(\[Epsilon]o\  = \ 8.85*10\^\(-12\);\), 
      " ", \( (*\ C^2/Nm\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(c\  = \ 3*10\^8;\), 
      " ", \( (*\ m/s\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Sigma]\  = \ 6*10\^7;\), 
      " ", \( (*\ \((Am)\)^\(-1\)\ *) \)}], "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Omega]\  = \ Range[10\^10, 10\^14, 9*10\^10];\), 
      "\[IndentingNewLine]", \( (*\(\[Omega]\  = \ 
            Table[10\^k, {k, 10, 14, 0.05}];\)*) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(one[\[Omega]_] := \ \@\(\(\[Epsilon]o*c\^2\)\/\(2*\[Omega]*\
\[Sigma]\)\);\), " ", \( (*\ in\ meter\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Omega], one[\[Omega]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1*10\^14}, {1*10\^\(-9\), 
                  1*10\^\(-7\)}}], {{{Hue[1], "\<one[\[Omega]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
2. Skin depth (in meters) for intensity depending on wavelength 
(for checking:For 1 mm wavelength angular frequency is 2p*300*10^9)\
\>"], "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        Range[10\^\(-9\), 10\^\(-3\), 
          55*10\^\(-9\)];\), "\[IndentingNewLine]", 
    RowBox[{\(one[\[Lambda]_] := \@\(\(\[Epsilon]o*c*\[Lambda]\)\/\(4*Pi*\
\[Sigma]\)\);\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          LogLinearListPlot[Transpose[{\[Lambda], one[\[Lambda]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Lambda]\>", "\<\>"}, 
            PlotRange \[Rule] {{1*10\^\(-7\), 1*10\^\(-3\)}, {1*10\^\(-9\), 
                  6*10\^\(-8\)}}], {{{Hue[1], "\<one[\[Lambda]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        1\ 10^\(-9\)\ meter\ is\ 1\ nm = \( .001\ microns = 10  A\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "\[IndentingNewLine]", Cell["\<\
1*10^-7 meter is 0.1 micron
1*10^-6 meter is 1 micron
1*10^-5 meter is 10 micron
1*10^-4 meter is 100 micron
1*10^-3 meter is 10000 micron
\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 532},
WindowMargins->{{Automatic, 104}, {Automatic, -18}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2992, 60, 1085, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

