(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3058,         78]*)
(*NotebookOutlinePosition[      3702,        100]*)
(*  CellTagsIndexPosition[      3658,         96]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O7REFNKS
  
The reflectance R is plotted for normal incidence for fixed
n depending on K.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        0;\), "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 
        10;\), "\[IndentingNewLine]", \(K = \ 
        Table[10\^k, {k, \(-3\), 2, 0.1}];\), "\[IndentingNewLine]", \(z[
          K_] := \ \((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*Pi\/360*\[Theta]] - \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\)/\((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*Pi\/360*\[Theta]] + \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\);\), "\[IndentingNewLine]", \(R[
          K_] := \((z[K]*
            Conjugate[z[K]])\);\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{K, R[K]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<K\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {0.6, 1}}], {{{Hue[1], "\<R[K]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{4, Automatic}, {Automatic, -2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1349, 26, 631, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

