(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7000,        149]*)
(*NotebookOutlinePosition[      7643,        171]*)
(*  CellTagsIndexPosition[      7599,        167]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
OA1DELTAFfS
  
Calculation of ratio of real part r of the parallel (p) and perpendicular (s) \
case,and the difference of the arguments of Fresnel's formulas with \
absorption.
      
For values of K we calculate the absolute values of zp=rp exp i\[Delta]p and \
zs=rs exp ids and the argument as function of \[Theta].\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(n\  = \ 
        2;\), "\[IndentingNewLine]", \(K\  = \ 
        2;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0, 90, 
          1];\), "\[IndentingNewLine]", \(zp[\[Theta]_] := \(\((n - \
i*K)\)*Cos[2*Pi*\[Theta]\/360] - \@\(1 - Sin[2*Pi*\[Theta]\/360]\^2\/\((n - \
i*K)\)\^2\)\)\/\(\((\((n - i*K)\)*Cos[2*Pi*\[Theta]\/360])\) + \@\(1 - \
Sin[2*Pi*\[Theta]\/360]\^2\/\((n - i*K)\)\^2\)\);\), "\[IndentingNewLine]", 
    RowBox[{\(zs[\[Theta]_] := \(Cos[2*Pi*\[Theta]\/360] - \((n - \
i*K)\)*\@\(1 - Sin[2*Pi*\[Theta]\/360]\^2\/\((n - i*K)\)\^2\)\)\/\(Cos[2*Pi*\
\[Theta]\/360] + \((n - i*K)\)*\@\(1 - Sin[2*Pi*\[Theta]\/360]\^2\/\((n - \
i*K)\)\^2\)\);\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[zp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[zp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Arg[zp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {\(-4\), 0}}], {{{Hue[
                  1], "\<Arg[zp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[zs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[zs[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Arg[zs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 4}}], {{{Hue[
                  1], "\<Arg[zs[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
The ratio of the absolute value of zs/zp,that is P=tan\[CurlyPhi] and the \
difference of the arguments of zs and zp,that is \[CapitalDelta].(parallel \
(p),perpendicular (s))\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[
            Transpose[{\[Theta], Abs[zs[\[Theta]]]\/Abs[zp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 3}}], {{{Hue[
                  1], \*"\"\<\!\(Abs[zs[\[Theta]]]\/Abs[zp[\[Theta]]]\)\>\""}}\
, LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], \(-\[CapitalDelta][\[Theta]]\)}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {\(-8\), 0}}], {{{Hue[
                  1], "\<-\[CapitalDelta][\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[CurlyPhi][\[Theta]_] := 
          ArcTan[Abs[zs[\[Theta]]]\/Abs[zp[\[Theta]]]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], \[CurlyPhi][\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 90}, {0, 1.2}}], {{{Hue[
                1], "\<\[CurlyPhi][\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{494, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5291, 97, 1759, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

