(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4085,         95]*)
(*NotebookOutlinePosition[      4730,        117]*)
(*  CellTagsIndexPosition[      4686,        113]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\[IndentingNewLine]F11CONVOS\[IndentingNewLine]Convolution\ integral\
\ for\ functions\ y\ and\ S\[IndentingNewLine]*) \[IndentingNewLine]<< 
      Graphics`Legend`\), "\[IndentingNewLine]", 
    \(<< Graphics`MultipleListPlot`\[IndentingNewLine]\), \
"\[IndentingNewLine]", 
    \(\(X\  = \ 
        Range[0, 1, 0.001];\)\[IndentingNewLine] (*\ \(tol\  = \ 
          0.01;\)\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      function\ y\ *) \), "\[IndentingNewLine]", 
    \(\(b2\  = \ 0.2;\)\), "\[IndentingNewLine]", 
    \(\(y[X_] := \ UnitStep[b2 - X];\)\), "\[IndentingNewLine]", 
    \(\(ShowLegend[
        ListPlot[Transpose[{X, y[X]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<X\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 1}, {0, 1.25}}], {{{Hue[1], "\<y[X]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)\[IndentingNewLine]\
\[IndentingNewLine] (*\ function\ s\ *) \), "\[IndentingNewLine]", 
    \(\(f\  = \ 800;\)\), "\[IndentingNewLine]", 
    \(\(a\  = \ 1;\)\), "\[IndentingNewLine]", 
    \(\(\[Lambda]\  = \ 0.0005;\)\), "\[IndentingNewLine]", 
    \(\(k\  = \ \(2*Pi\)\/\[Lambda];\)\), "\[IndentingNewLine]", 
    \(\(S[X_] := \ Sin[\(k*a*\((X)\)\)\/f];\)\), "\[IndentingNewLine]", 
    \(\(ShowLegend[
        ListPlot[Transpose[{X, S[X]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<X\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 1}, {\(-1\), 1}}], {{{Hue[1], "\<S[X]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(II[X_] := \ 
        2*NIntegrate[
            Evaluate[y[XX]*\((Sin[k*a*\((X - XX)\)\/f])\)], {XX, 0, 0.5}, 
            AccuracyGoal \[Rule] 
              3];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(ShowLegend[
        MultipleListPlot[Transpose[{X, II[X]}], Transpose[{X, S[X]}], 
          PlotJoined \[Rule] True, PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          DisplayFunction \[Rule] Identity, 
          AxesLabel \[Rule] {"\<X\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 1}, {\(-1\), 1}}], {{{Hue[
                1], "\<II[X]\>"}, {Hue[0.5], "\<S[X]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{538, 599},
WindowMargins->{{15, Automatic}, {30, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2376, 43, 833, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

