(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6639,        148]*)
(*NotebookOutlinePosition[      7285,        170]*)
(*  CellTagsIndexPosition[      7241,        166]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F15FOLDS
Folding of the spectrum.For the sampling interval 1/255,highest frequency is \
128,the frequencies are at 65,85,105,all below 127.
  
a.Sample interval i/255\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(i = \ 
        Range[0, 255, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(y1\_i = \ 
          Cos[2*Pi*65*i\/255] + Cos[2*Pi*85*i\/255] + Cos[2*Pi*105*i\/255];\),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i/255, y1\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1}, {\(-2\), 4}}], {{{Hue[
                  1], \*"\"\<\!\(y1\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(c\  = \ 
        Fourier[y1\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[c]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-5\), 10}}], {{{Hue[
                  1], "\<Re[c]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Frequency\ peaks\ are\ at\ 65, \ 85, \ 
        105\ *) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
b. Samle interval 2i/255 
For the sampling interval 2/255,highest frequency is 64,the original \
frequencies are at 65,85,105,they are all larger than 64 and appear folded.\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(y2\_i = \ 
          Cos[2*Pi*65*\(2*i\)\/255] + Cos[2*Pi*85*\(2*i\)\/255] + 
            Cos[2*Pi*105*\(2*i\)\/255];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{2*i/255, y2\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<2*i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 2}, {\(-2\), 4}}], {{{Hue[
                  1], \*"\"\<\!\(y2\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(cc\  = \ 
        Fourier[y2\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[cc]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-5\), 10}}], {{{Hue[
                  1], "\<Re[cc]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
Frequency peaks appear 65 at --> 125
\t\t\t\t\t   85 at --> 85
\t\t\t\t\t  105 at --> 45\
\>"], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
c. Sample interval 4i/255 
For the sampling interval 4/255,highest frequency 32,the frequencies are \
higher than 1 times 32 and 2 times 32.\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(y4\_i = \ 
          Cos[2*Pi*65*\(4*i\)\/255] + Cos[2*Pi*85*\(4*i\)\/255] + 
            Cos[2*Pi*105*\(4*i\)\/255];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{4*i/255, y4\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<4*i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 4}, {\(-2\), 4}}], {{{Hue[
                  1], \*"\"\<\!\(y4\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ccc\  = \ 
        Fourier[y4\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[ccc]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-5\), 10}}], {{{Hue[
                  1], "\<Re[ccc]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", Cell["\<\
Frequency peaks appear 65 at --> 5
\t\t\t\t\t   85 at --> 85
\t\t\t\t\t  105 at --> 90\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{491, 537},
WindowMargins->{{Automatic, 185}, {Automatic, 26}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4930, 96, 1892, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

