(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6133,        132]*)
(*NotebookOutlinePosition[      6777,        154]*)
(*  CellTagsIndexPosition[      6733,        150]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F16APODIS
Fourier transformation of sine-function and Appodization.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Original\ function\ *) \)}], "\[IndentingNewLine]", \(f\  = \ 
        31;\), "\[IndentingNewLine]", \(k = 
        Range[0, 255, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(y\_k = \ \((Cos[2*Pi*f*k\/255])\);\), " ", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k/255, y\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(y\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Step\ function\ *) \)}], "\[IndentingNewLine]", \(d\  = \ 
        255;\), "\[IndentingNewLine]", \(i\  = \ 
        Range[0, 400, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(p\_i = \((\ UnitStep[i] - UnitStep[i - \((d)\)])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i/255, p\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 2}, {\(-0.5\), 1.5}}], {{{Hue[
                  1], \*"\"\<\!\(p\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(yp\_i = \((Cos[2*Pi*f*i\/255])\)*p\_i;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i/255, yp\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1.6}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(yp\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3.  Fourier\ transformation\ of\ y\ times\ p\ *) \)}], "\
\[IndentingNewLine]", \(k\  = \ 
        Range[0, 255, 
          1];\), "\[IndentingNewLine]", \(x\_k = \((Cos[2*Pi*f*k\/255])\)*
            UnitStep[k] - UnitStep[k - \((d)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(c\  = \ Fourier[x\_k];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k, Re[c]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-2\), 8}}], {{{Hue[
                  1], "\<Re[c]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 4.  Triangle\ function\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(q\_k = \ 
        1 - \ k\/255;\), "\[IndentingNewLine]", 
    RowBox[{\(ay\_k = q\_k*y\_k;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k/255, ay\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(ay\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        5. \ Fourier\ transformation\ of\ y\ times\ p\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(c\  = \ Fourier[ay\_k];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{k, Re[c]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 140}, {\(-2\), 8}}], {{{Hue[
                1], "\<Re[c]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 0}, {Automatic, 13}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4424, 80, 1416, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

