(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4306,        101]*)
(*NotebookOutlinePosition[      4949,        123]*)
(*  CellTagsIndexPosition[      4905,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F7FTSTEP183S
The complex FT, step function of width 0 to d and
183 points.The FT(inverse) of the FT is also shown\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(i\  = \ 
        Range[0, 183, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(d\  = \ 20;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Originial\ Function\ *) \)}], "\[IndentingNewLine]", \(x\_i\  = \ 
        UnitStep[i] - UnitStep[i - d];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, Re[x\_i\ ]}], 
            Transpose[{i, Im[x\_i\ ]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 200}, {\(-0.5\), 1.5}}], {{{Hue[
                  1], \*"\"\<Re[\!\(x\_i\)]\>\""}, {Hue[
                  0.5], \*"\"\<Im[\!\(x\_i\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ Transform\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(c = \ Fourier[x\_i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, Re[c\ ]}], Transpose[{i, Im[c]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 200}, {\(-2\), 2}}], {{{Hue[
                  1], "\<Re[c]\>"}, {Hue[0.5], "\<Im[c]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ transform\ \((inverse)\)\ of\ Fourier\ transform\ *) \)}], "\
\[IndentingNewLine]", \(z\  = \ 
        InverseFourier[c];\), "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i/255, Re[z\ ]}], 
          Transpose[{i/255, Im[z]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 0.8}, {\(-0.5\), 1.5}}], {{{Hue[
                1], "\<Re[z]\>"}, {Hue[0.5], "\<Im[z]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{497, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2597, 49, 846, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

