(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    515197,      15502]*)
(*NotebookOutlinePosition[    515841,      15524]*)
(*  CellTagsIndexPosition[    515797,      15520]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F9FTGAUSS
Complex Fourier transformation of Gauss function for two values of a and for \
Fast Fourier Transformation .
The maximum is at i = 0. The FT (inverse) of the FT is also calculated.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(i\  = \ 
        Range[0, 255, 1];\), "\[IndentingNewLine]", \(A\  = \ 
        1;\), "\[IndentingNewLine]", \(a\  = \ 100;\), "\[IndentingNewLine]", 
  
    RowBox[{\(aa\  = \ 50;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Original\ function\ *) \)}], "\[IndentingNewLine]", \(y1\_i = \ 
        A*\[ExponentialE]\^\(\(-a\)*\((\((i\/255)\)\^2)\)\);\), "\
\[IndentingNewLine]", \(y2\_i = \ 
        A*\[ExponentialE]\^\(\(-aa\)*\((\((i\/255)\)\^2)\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i/255, y2\_i}], 
            Transpose[{i/255, y1\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1}, {0, 1}}], {{{Hue[
                  1], \*"\"\<\!\(y2\_i\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(y1\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ transform\ *) \)}], "\[IndentingNewLine]", \(c1\  = \ 
        Fourier[y1\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(c2\  = \ Fourier[y2\_i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, Re[c1]}], Transpose[{i, Re[c2]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {0, 3}}], {{{Hue[
                  1], "\<Re[c1]\>"}, {Hue[0.5], "\<Re[c2]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ transform\ \((inverse)\)\ of\ Fourier\ transform\ *) \)}], "\
\[IndentingNewLine]", \(zf1\  = \ 
        InverseFourier[c1];\), "\[IndentingNewLine]", 
    RowBox[{\(zf2\  = \ InverseFourier[c2];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i/255, zf1}], Transpose[{i/255, zf2}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 0.4}, {0, 1}}], {{{Hue[1], "\<zf1\>"}, {Hue[
                0.5], "\<zf2\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[.2 -0.0125 -9 -9 ]
[.2 -0.0125 9 0 ]
[.4 -0.0125 -9 -9 ]
[.4 -0.0125 9 0 ]
[.6 -0.0125 -9 -9 ]
[.6 -0.0125 9 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 34 6.28125 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 0 m
.2 .00625 L
s
[(0.2)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(0.4)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(0.6)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(0.8)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 12.813 moveto
(\\220) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(255) show
93.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.001 w
0 .61803 m
.00392 .61756 L
.00784 .61614 L
.01176 .61377 L
.01569 .61048 L
.01961 .60627 L
.02353 .60116 L
.02745 .59518 L
.03137 .58836 L
.03529 .58071 L
.03922 .57229 L
.04314 .56313 L
.04706 .55325 L
.05098 .54272 L
.0549 .53157 L
.05882 .51985 L
.06275 .5076 L
.06667 .49488 L
.07059 .48174 L
.07451 .46823 L
.07843 .4544 L
.08235 .44029 L
.08627 .42597 L
.0902 .41149 L
.09412 .39688 L
.09804 .38221 L
.10196 .36751 L
.10588 .35283 L
.1098 .33822 L
.11373 .32372 L
.11765 .30936 L
.12157 .29518 L
.12549 .28122 L
.12941 .26751 L
.13333 .25408 L
.13725 .24095 L
.14118 .22815 L
.1451 .2157 L
.14902 .20361 L
.15294 .1919 L
.15686 .18059 L
.16078 .16969 L
.16471 .1592 L
.16863 .14912 L
.17255 .13947 L
.17647 .13025 L
.18039 .12145 L
.18431 .11307 L
.18824 .1051 L
.19216 .09755 L
Mistroke
.19608 .0904 L
.2 .08364 L
.20392 .07727 L
.20784 .07128 L
.21176 .06565 L
.21569 .06037 L
.21961 .05543 L
.22353 .05082 L
.22745 .04652 L
.23137 .04252 L
.23529 .0388 L
.23922 .03535 L
.24314 .03216 L
.24706 .02921 L
.25098 .0265 L
.2549 .02399 L
.25882 .02169 L
.26275 .01959 L
.26667 .01765 L
.27059 .01589 L
.27451 .01428 L
.27843 .01281 L
.28235 .01148 L
.28627 .01027 L
.2902 .00917 L
.29412 .00818 L
.29804 .00728 L
.30196 .00647 L
.30588 .00575 L
.3098 .00509 L
.31373 .00451 L
.31765 .00398 L
.32157 .00351 L
.32549 .00309 L
.32941 .00272 L
.33333 .00239 L
.33725 .00209 L
.34118 .00183 L
.3451 .0016 L
.34902 .0014 L
.35294 .00122 L
.35686 .00106 L
.36078 .00092 L
.36471 .0008 L
.36863 .00069 L
.37255 .0006 L
.37647 .00052 L
.38039 .00045 L
.38431 .00038 L
.38824 .00033 L
Mistroke
.39216 .00028 L
.39608 .00024 L
.4 .00021 L
.40392 .00018 L
.40784 .00015 L
.41176 .00013 L
.41569 .00011 L
.41961 9e-005 L
.42353 8e-005 L
.42745 7e-005 L
.43137 6e-005 L
.43529 5e-005 L
.43922 4e-005 L
.44314 3e-005 L
.44706 3e-005 L
.45098 2e-005 L
.4549 2e-005 L
.45882 2e-005 L
.46275 1e-005 L
.46667 1e-005 L
.47059 1e-005 L
.47451 1e-005 L
.47843 1e-005 L
.48235 1e-005 L
.48627 0 L
.4902 0 L
.49412 0 L
.49804 0 L
.50196 0 L
.50588 0 L
.5098 0 L
.51373 0 L
.51765 0 L
.52157 0 L
.52549 0 L
.52941 0 L
.53333 0 L
.53725 0 L
.54118 0 L
.5451 0 L
.54902 0 L
.55294 0 L
.55686 0 L
.56078 0 L
.56471 0 L
.56863 0 L
.57255 0 L
.57647 0 L
.58039 0 L
.58431 0 L
Mistroke
.58824 0 L
.59216 0 L
.59608 0 L
.6 0 L
.60392 0 L
.60784 0 L
.61176 0 L
.61569 0 L
.61961 0 L
.62353 0 L
.62745 0 L
.63137 0 L
.63529 0 L
.63922 0 L
.64314 0 L
.64706 0 L
.65098 0 L
.6549 0 L
.65882 0 L
.66275 0 L
.66667 0 L
.67059 0 L
.67451 0 L
.67843 0 L
.68235 0 L
.68627 0 L
.6902 0 L
.69412 0 L
.69804 0 L
.70196 0 L
.70588 0 L
.7098 0 L
.71373 0 L
.71765 0 L
.72157 0 L
.72549 0 L
.72941 0 L
.73333 0 L
.73725 0 L
.74118 0 L
.7451 0 L
.74902 0 L
.75294 0 L
.75686 0 L
.76078 0 L
.76471 0 L
.76863 0 L
.77255 0 L
.77647 0 L
.78039 0 L
Mistroke
.78431 0 L
.78824 0 L
.79216 0 L
.79608 0 L
.8 0 L
.80392 0 L
.80784 0 L
.81176 0 L
.81569 0 L
.81961 0 L
.82353 0 L
.82745 0 L
.83137 0 L
.83529 0 L
.83922 0 L
.84314 0 L
.84706 0 L
.85098 0 L
.8549 0 L
.85882 0 L
.86275 0 L
.86667 0 L
.87059 0 L
.87451 0 L
.87843 0 L
.88235 0 L
.88627 0 L
.8902 0 L
.89412 0 L
.89804 0 L
.90196 0 L
.90588 0 L
.9098 0 L
.91373 0 L
.91765 0 L
.92157 0 L
.92549 0 L
.92941 0 L
.93333 0 L
.93725 0 L
.94118 0 L
.9451 0 L
.94902 0 L
.95294 0 L
.95686 0 L
.96078 0 L
.96471 0 L
.96863 0 L
.97255 0 L
.97647 0 L
Mistroke
.98039 0 L
.98431 0 L
.98824 0 L
.99216 0 L
.99608 0 L
1 0 L
Mfstroke
0 g
.0001 w
0 .61803 -1.875 0 Mabsadd m
0 .61803 0 2.5 Mabsadd L
0 .61803 1.875 0 Mabsadd L
0 .61803 0 -2.5 Mabsadd L
0 .61803 -1.875 0 Mabsadd L closepath F
.00392 .61756 -1.875 0 Mabsadd m
.00392 .61756 0 2.5 Mabsadd L
.00392 .61756 1.875 0 Mabsadd L
.00392 .61756 0 -2.5 Mabsadd L
.00392 .61756 -1.875 0 Mabsadd L closepath F
.00784 .61614 -1.875 0 Mabsadd m
.00784 .61614 0 2.5 Mabsadd L
.00784 .61614 1.875 0 Mabsadd L
.00784 .61614 0 -2.5 Mabsadd L
.00784 .61614 -1.875 0 Mabsadd L closepath F
.01176 .61377 -1.875 0 Mabsadd m
.01176 .61377 0 2.5 Mabsadd L
.01176 .61377 1.875 0 Mabsadd L
.01176 .61377 0 -2.5 Mabsadd L
.01176 .61377 -1.875 0 Mabsadd L closepath F
.01569 .61048 -1.875 0 Mabsadd m
.01569 .61048 0 2.5 Mabsadd L
.01569 .61048 1.875 0 Mabsadd L
.01569 .61048 0 -2.5 Mabsadd L
.01569 .61048 -1.875 0 Mabsadd L closepath F
.01961 .60627 -1.875 0 Mabsadd m
.01961 .60627 0 2.5 Mabsadd L
.01961 .60627 1.875 0 Mabsadd L
.01961 .60627 0 -2.5 Mabsadd L
.01961 .60627 -1.875 0 Mabsadd L closepath F
.02353 .60116 -1.875 0 Mabsadd m
.02353 .60116 0 2.5 Mabsadd L
.02353 .60116 1.875 0 Mabsadd L
.02353 .60116 0 -2.5 Mabsadd L
.02353 .60116 -1.875 0 Mabsadd L closepath F
.02745 .59518 -1.875 0 Mabsadd m
.02745 .59518 0 2.5 Mabsadd L
.02745 .59518 1.875 0 Mabsadd L
.02745 .59518 0 -2.5 Mabsadd L
.02745 .59518 -1.875 0 Mabsadd L closepath F
.03137 .58836 -1.875 0 Mabsadd m
.03137 .58836 0 2.5 Mabsadd L
.03137 .58836 1.875 0 Mabsadd L
.03137 .58836 0 -2.5 Mabsadd L
.03137 .58836 -1.875 0 Mabsadd L closepath F
.03529 .58071 -1.875 0 Mabsadd m
.03529 .58071 0 2.5 Mabsadd L
.03529 .58071 1.875 0 Mabsadd L
.03529 .58071 0 -2.5 Mabsadd L
.03529 .58071 -1.875 0 Mabsadd L closepath F
.03922 .57229 -1.875 0 Mabsadd m
.03922 .57229 0 2.5 Mabsadd L
.03922 .57229 1.875 0 Mabsadd L
.03922 .57229 0 -2.5 Mabsadd L
.03922 .57229 -1.875 0 Mabsadd L closepath F
.04314 .56313 -1.875 0 Mabsadd m
.04314 .56313 0 2.5 Mabsadd L
.04314 .56313 1.875 0 Mabsadd L
.04314 .56313 0 -2.5 Mabsadd L
.04314 .56313 -1.875 0 Mabsadd L closepath F
.04706 .55325 -1.875 0 Mabsadd m
.04706 .55325 0 2.5 Mabsadd L
.04706 .55325 1.875 0 Mabsadd L
.04706 .55325 0 -2.5 Mabsadd L
.04706 .55325 -1.875 0 Mabsadd L closepath F
.05098 .54272 -1.875 0 Mabsadd m
.05098 .54272 0 2.5 Mabsadd L
.05098 .54272 1.875 0 Mabsadd L
.05098 .54272 0 -2.5 Mabsadd L
.05098 .54272 -1.875 0 Mabsadd L closepath F
.0549 .53157 -1.875 0 Mabsadd m
.0549 .53157 0 2.5 Mabsadd L
.0549 .53157 1.875 0 Mabsadd L
.0549 .53157 0 -2.5 Mabsadd L
.0549 .53157 -1.875 0 Mabsadd L closepath F
.05882 .51985 -1.875 0 Mabsadd m
.05882 .51985 0 2.5 Mabsadd L
.05882 .51985 1.875 0 Mabsadd L
.05882 .51985 0 -2.5 Mabsadd L
.05882 .51985 -1.875 0 Mabsadd L closepath F
.06275 .5076 -1.875 0 Mabsadd m
.06275 .5076 0 2.5 Mabsadd L
.06275 .5076 1.875 0 Mabsadd L
.06275 .5076 0 -2.5 Mabsadd L
.06275 .5076 -1.875 0 Mabsadd L closepath F
.06667 .49488 -1.875 0 Mabsadd m
.06667 .49488 0 2.5 Mabsadd L
.06667 .49488 1.875 0 Mabsadd L
.06667 .49488 0 -2.5 Mabsadd L
.06667 .49488 -1.875 0 Mabsadd L closepath F
.07059 .48174 -1.875 0 Mabsadd m
.07059 .48174 0 2.5 Mabsadd L
.07059 .48174 1.875 0 Mabsadd L
.07059 .48174 0 -2.5 Mabsadd L
.07059 .48174 -1.875 0 Mabsadd L closepath F
.07451 .46823 -1.875 0 Mabsadd m
.07451 .46823 0 2.5 Mabsadd L
.07451 .46823 1.875 0 Mabsadd L
.07451 .46823 0 -2.5 Mabsadd L
.07451 .46823 -1.875 0 Mabsadd L closepath F
.07843 .4544 -1.875 0 Mabsadd m
.07843 .4544 0 2.5 Mabsadd L
.07843 .4544 1.875 0 Mabsadd L
.07843 .4544 0 -2.5 Mabsadd L
.07843 .4544 -1.875 0 Mabsadd L closepath F
.08235 .44029 -1.875 0 Mabsadd m
.08235 .44029 0 2.5 Mabsadd L
.08235 .44029 1.875 0 Mabsadd L
.08235 .44029 0 -2.5 Mabsadd L
.08235 .44029 -1.875 0 Mabsadd L closepath F
.08627 .42597 -1.875 0 Mabsadd m
.08627 .42597 0 2.5 Mabsadd L
.08627 .42597 1.875 0 Mabsadd L
.08627 .42597 0 -2.5 Mabsadd L
.08627 .42597 -1.875 0 Mabsadd L closepath F
.0902 .41149 -1.875 0 Mabsadd m
.0902 .41149 0 2.5 Mabsadd L
.0902 .41149 1.875 0 Mabsadd L
.0902 .41149 0 -2.5 Mabsadd L
.0902 .41149 -1.875 0 Mabsadd L closepath F
.09412 .39688 -1.875 0 Mabsadd m
.09412 .39688 0 2.5 Mabsadd L
.09412 .39688 1.875 0 Mabsadd L
.09412 .39688 0 -2.5 Mabsadd L
.09412 .39688 -1.875 0 Mabsadd L closepath F
.09804 .38221 -1.875 0 Mabsadd m
.09804 .38221 0 2.5 Mabsadd L
.09804 .38221 1.875 0 Mabsadd L
.09804 .38221 0 -2.5 Mabsadd L
.09804 .38221 -1.875 0 Mabsadd L closepath F
.10196 .36751 -1.875 0 Mabsadd m
.10196 .36751 0 2.5 Mabsadd L
.10196 .36751 1.875 0 Mabsadd L
.10196 .36751 0 -2.5 Mabsadd L
.10196 .36751 -1.875 0 Mabsadd L closepath F
.10588 .35283 -1.875 0 Mabsadd m
.10588 .35283 0 2.5 Mabsadd L
.10588 .35283 1.875 0 Mabsadd L
.10588 .35283 0 -2.5 Mabsadd L
.10588 .35283 -1.875 0 Mabsadd L closepath F
.1098 .33822 -1.875 0 Mabsadd m
.1098 .33822 0 2.5 Mabsadd L
.1098 .33822 1.875 0 Mabsadd L
.1098 .33822 0 -2.5 Mabsadd L
.1098 .33822 -1.875 0 Mabsadd L closepath F
.11373 .32372 -1.875 0 Mabsadd m
.11373 .32372 0 2.5 Mabsadd L
.11373 .32372 1.875 0 Mabsadd L
.11373 .32372 0 -2.5 Mabsadd L
.11373 .32372 -1.875 0 Mabsadd L closepath F
.11765 .30936 -1.875 0 Mabsadd m
.11765 .30936 0 2.5 Mabsadd L
.11765 .30936 1.875 0 Mabsadd L
.11765 .30936 0 -2.5 Mabsadd L
.11765 .30936 -1.875 0 Mabsadd L closepath F
.12157 .29518 -1.875 0 Mabsadd m
.12157 .29518 0 2.5 Mabsadd L
.12157 .29518 1.875 0 Mabsadd L
.12157 .29518 0 -2.5 Mabsadd L
.12157 .29518 -1.875 0 Mabsadd L closepath F
.12549 .28122 -1.875 0 Mabsadd m
.12549 .28122 0 2.5 Mabsadd L
.12549 .28122 1.875 0 Mabsadd L
.12549 .28122 0 -2.5 Mabsadd L
.12549 .28122 -1.875 0 Mabsadd L closepath F
.12941 .26751 -1.875 0 Mabsadd m
.12941 .26751 0 2.5 Mabsadd L
.12941 .26751 1.875 0 Mabsadd L
.12941 .26751 0 -2.5 Mabsadd L
.12941 .26751 -1.875 0 Mabsadd L closepath F
.13333 .25408 -1.875 0 Mabsadd m
.13333 .25408 0 2.5 Mabsadd L
.13333 .25408 1.875 0 Mabsadd L
.13333 .25408 0 -2.5 Mabsadd L
.13333 .25408 -1.875 0 Mabsadd L closepath F
.13725 .24095 -1.875 0 Mabsadd m
.13725 .24095 0 2.5 Mabsadd L
.13725 .24095 1.875 0 Mabsadd L
.13725 .24095 0 -2.5 Mabsadd L
.13725 .24095 -1.875 0 Mabsadd L closepath F
.14118 .22815 -1.875 0 Mabsadd m
.14118 .22815 0 2.5 Mabsadd L
.14118 .22815 1.875 0 Mabsadd L
.14118 .22815 0 -2.5 Mabsadd L
.14118 .22815 -1.875 0 Mabsadd L closepath F
.1451 .2157 -1.875 0 Mabsadd m
.1451 .2157 0 2.5 Mabsadd L
.1451 .2157 1.875 0 Mabsadd L
.1451 .2157 0 -2.5 Mabsadd L
.1451 .2157 -1.875 0 Mabsadd L closepath F
.14902 .20361 -1.875 0 Mabsadd m
.14902 .20361 0 2.5 Mabsadd L
.14902 .20361 1.875 0 Mabsadd L
.14902 .20361 0 -2.5 Mabsadd L
.14902 .20361 -1.875 0 Mabsadd L closepath F
.15294 .1919 -1.875 0 Mabsadd m
.15294 .1919 0 2.5 Mabsadd L
.15294 .1919 1.875 0 Mabsadd L
.15294 .1919 0 -2.5 Mabsadd L
.15294 .1919 -1.875 0 Mabsadd L closepath F
.15686 .18059 -1.875 0 Mabsadd m
.15686 .18059 0 2.5 Mabsadd L
.15686 .18059 1.875 0 Mabsadd L
.15686 .18059 0 -2.5 Mabsadd L
.15686 .18059 -1.875 0 Mabsadd L closepath F
.16078 .16969 -1.875 0 Mabsadd m
.16078 .16969 0 2.5 Mabsadd L
.16078 .16969 1.875 0 Mabsadd L
.16078 .16969 0 -2.5 Mabsadd L
.16078 .16969 -1.875 0 Mabsadd L closepath F
.16471 .1592 -1.875 0 Mabsadd m
.16471 .1592 0 2.5 Mabsadd L
.16471 .1592 1.875 0 Mabsadd L
.16471 .1592 0 -2.5 Mabsadd L
.16471 .1592 -1.875 0 Mabsadd L closepath F
.16863 .14912 -1.875 0 Mabsadd m
.16863 .14912 0 2.5 Mabsadd L
.16863 .14912 1.875 0 Mabsadd L
.16863 .14912 0 -2.5 Mabsadd L
.16863 .14912 -1.875 0 Mabsadd L closepath F
.17255 .13947 -1.875 0 Mabsadd m
.17255 .13947 0 2.5 Mabsadd L
.17255 .13947 1.875 0 Mabsadd L
.17255 .13947 0 -2.5 Mabsadd L
.17255 .13947 -1.875 0 Mabsadd L closepath F
.17647 .13025 -1.875 0 Mabsadd m
.17647 .13025 0 2.5 Mabsadd L
.17647 .13025 1.875 0 Mabsadd L
.17647 .13025 0 -2.5 Mabsadd L
.17647 .13025 -1.875 0 Mabsadd L closepath F
.18039 .12145 -1.875 0 Mabsadd m
.18039 .12145 0 2.5 Mabsadd L
.18039 .12145 1.875 0 Mabsadd L
.18039 .12145 0 -2.5 Mabsadd L
.18039 .12145 -1.875 0 Mabsadd L closepath F
.18431 .11307 -1.875 0 Mabsadd m
.18431 .11307 0 2.5 Mabsadd L
.18431 .11307 1.875 0 Mabsadd L
.18431 .11307 0 -2.5 Mabsadd L
.18431 .11307 -1.875 0 Mabsadd L closepath F
.18824 .1051 -1.875 0 Mabsadd m
.18824 .1051 0 2.5 Mabsadd L
.18824 .1051 1.875 0 Mabsadd L
.18824 .1051 0 -2.5 Mabsadd L
.18824 .1051 -1.875 0 Mabsadd L closepath F
.19216 .09755 -1.875 0 Mabsadd m
.19216 .09755 0 2.5 Mabsadd L
.19216 .09755 1.875 0 Mabsadd L
.19216 .09755 0 -2.5 Mabsadd L
.19216 .09755 -1.875 0 Mabsadd L closepath F
.19608 .0904 -1.875 0 Mabsadd m
.19608 .0904 0 2.5 Mabsadd L
.19608 .0904 1.875 0 Mabsadd L
.19608 .0904 0 -2.5 Mabsadd L
.19608 .0904 -1.875 0 Mabsadd L closepath F
.2 .08364 -1.875 0 Mabsadd m
.2 .08364 0 2.5 Mabsadd L
.2 .08364 1.875 0 Mabsadd L
.2 .08364 0 -2.5 Mabsadd L
.2 .08364 -1.875 0 Mabsadd L closepath F
.20392 .07727 -1.875 0 Mabsadd m
.20392 .07727 0 2.5 Mabsadd L
.20392 .07727 1.875 0 Mabsadd L
.20392 .07727 0 -2.5 Mabsadd L
.20392 .07727 -1.875 0 Mabsadd L closepath F
.20784 .07128 -1.875 0 Mabsadd m
.20784 .07128 0 2.5 Mabsadd L
.20784 .07128 1.875 0 Mabsadd L
.20784 .07128 0 -2.5 Mabsadd L
.20784 .07128 -1.875 0 Mabsadd L closepath F
.21176 .06565 -1.875 0 Mabsadd m
.21176 .06565 0 2.5 Mabsadd L
.21176 .06565 1.875 0 Mabsadd L
.21176 .06565 0 -2.5 Mabsadd L
.21176 .06565 -1.875 0 Mabsadd L closepath F
.21569 .06037 -1.875 0 Mabsadd m
.21569 .06037 0 2.5 Mabsadd L
.21569 .06037 1.875 0 Mabsadd L
.21569 .06037 0 -2.5 Mabsadd L
.21569 .06037 -1.875 0 Mabsadd L closepath F
.21961 .05543 -1.875 0 Mabsadd m
.21961 .05543 0 2.5 Mabsadd L
.21961 .05543 1.875 0 Mabsadd L
.21961 .05543 0 -2.5 Mabsadd L
.21961 .05543 -1.875 0 Mabsadd L closepath F
.22353 .05082 -1.875 0 Mabsadd m
.22353 .05082 0 2.5 Mabsadd L
.22353 .05082 1.875 0 Mabsadd L
.22353 .05082 0 -2.5 Mabsadd L
.22353 .05082 -1.875 0 Mabsadd L closepath F
.22745 .04652 -1.875 0 Mabsadd m
.22745 .04652 0 2.5 Mabsadd L
.22745 .04652 1.875 0 Mabsadd L
.22745 .04652 0 -2.5 Mabsadd L
.22745 .04652 -1.875 0 Mabsadd L closepath F
.23137 .04252 -1.875 0 Mabsadd m
.23137 .04252 0 2.5 Mabsadd L
.23137 .04252 1.875 0 Mabsadd L
.23137 .04252 0 -2.5 Mabsadd L
.23137 .04252 -1.875 0 Mabsadd L closepath F
.23529 .0388 -1.875 0 Mabsadd m
.23529 .0388 0 2.5 Mabsadd L
.23529 .0388 1.875 0 Mabsadd L
.23529 .0388 0 -2.5 Mabsadd L
.23529 .0388 -1.875 0 Mabsadd L closepath F
.23922 .03535 -1.875 0 Mabsadd m
.23922 .03535 0 2.5 Mabsadd L
.23922 .03535 1.875 0 Mabsadd L
.23922 .03535 0 -2.5 Mabsadd L
.23922 .03535 -1.875 0 Mabsadd L closepath F
.24314 .03216 -1.875 0 Mabsadd m
.24314 .03216 0 2.5 Mabsadd L
.24314 .03216 1.875 0 Mabsadd L
.24314 .03216 0 -2.5 Mabsadd L
.24314 .03216 -1.875 0 Mabsadd L closepath F
.24706 .02921 -1.875 0 Mabsadd m
.24706 .02921 0 2.5 Mabsadd L
.24706 .02921 1.875 0 Mabsadd L
.24706 .02921 0 -2.5 Mabsadd L
.24706 .02921 -1.875 0 Mabsadd L closepath F
.25098 .0265 -1.875 0 Mabsadd m
.25098 .0265 0 2.5 Mabsadd L
.25098 .0265 1.875 0 Mabsadd L
.25098 .0265 0 -2.5 Mabsadd L
.25098 .0265 -1.875 0 Mabsadd L closepath F
.2549 .02399 -1.875 0 Mabsadd m
.2549 .02399 0 2.5 Mabsadd L
.2549 .02399 1.875 0 Mabsadd L
.2549 .02399 0 -2.5 Mabsadd L
.2549 .02399 -1.875 0 Mabsadd L closepath F
.25882 .02169 -1.875 0 Mabsadd m
.25882 .02169 0 2.5 Mabsadd L
.25882 .02169 1.875 0 Mabsadd L
.25882 .02169 0 -2.5 Mabsadd L
.25882 .02169 -1.875 0 Mabsadd L closepath F
.26275 .01959 -1.875 0 Mabsadd m
.26275 .01959 0 2.5 Mabsadd L
.26275 .01959 1.875 0 Mabsadd L
.26275 .01959 0 -2.5 Mabsadd L
.26275 .01959 -1.875 0 Mabsadd L closepath F
.26667 .01765 -1.875 0 Mabsadd m
.26667 .01765 0 2.5 Mabsadd L
.26667 .01765 1.875 0 Mabsadd L
.26667 .01765 0 -2.5 Mabsadd L
.26667 .01765 -1.875 0 Mabsadd L closepath F
.27059 .01589 -1.875 0 Mabsadd m
.27059 .01589 0 2.5 Mabsadd L
.27059 .01589 1.875 0 Mabsadd L
.27059 .01589 0 -2.5 Mabsadd L
.27059 .01589 -1.875 0 Mabsadd L closepath F
.27451 .01428 -1.875 0 Mabsadd m
.27451 .01428 0 2.5 Mabsadd L
.27451 .01428 1.875 0 Mabsadd L
.27451 .01428 0 -2.5 Mabsadd L
.27451 .01428 -1.875 0 Mabsadd L closepath F
.27843 .01281 -1.875 0 Mabsadd m
.27843 .01281 0 2.5 Mabsadd L
.27843 .01281 1.875 0 Mabsadd L
.27843 .01281 0 -2.5 Mabsadd L
.27843 .01281 -1.875 0 Mabsadd L closepath F
.28235 .01148 -1.875 0 Mabsadd m
.28235 .01148 0 2.5 Mabsadd L
.28235 .01148 1.875 0 Mabsadd L
.28235 .01148 0 -2.5 Mabsadd L
.28235 .01148 -1.875 0 Mabsadd L closepath F
.28627 .01027 -1.875 0 Mabsadd m
.28627 .01027 0 2.5 Mabsadd L
.28627 .01027 1.875 0 Mabsadd L
.28627 .01027 0 -2.5 Mabsadd L
.28627 .01027 -1.875 0 Mabsadd L closepath F
.2902 .00917 -1.875 0 Mabsadd m
.2902 .00917 0 2.5 Mabsadd L
.2902 .00917 1.875 0 Mabsadd L
.2902 .00917 0 -2.5 Mabsadd L
.2902 .00917 -1.875 0 Mabsadd L closepath F
.29412 .00818 -1.875 0 Mabsadd m
.29412 .00818 0 2.5 Mabsadd L
.29412 .00818 1.875 0 Mabsadd L
.29412 .00818 0 -2.5 Mabsadd L
.29412 .00818 -1.875 0 Mabsadd L closepath F
.29804 .00728 -1.875 0 Mabsadd m
.29804 .00728 0 2.5 Mabsadd L
.29804 .00728 1.875 0 Mabsadd L
.29804 .00728 0 -2.5 Mabsadd L
.29804 .00728 -1.875 0 Mabsadd L closepath F
.30196 .00647 -1.875 0 Mabsadd m
.30196 .00647 0 2.5 Mabsadd L
.30196 .00647 1.875 0 Mabsadd L
.30196 .00647 0 -2.5 Mabsadd L
.30196 .00647 -1.875 0 Mabsadd L closepath F
.30588 .00575 -1.875 0 Mabsadd m
.30588 .00575 0 2.5 Mabsadd L
.30588 .00575 1.875 0 Mabsadd L
.30588 .00575 0 -2.5 Mabsadd L
.30588 .00575 -1.875 0 Mabsadd L closepath F
.3098 .00509 -1.875 0 Mabsadd m
.3098 .00509 0 2.5 Mabsadd L
.3098 .00509 1.875 0 Mabsadd L
.3098 .00509 0 -2.5 Mabsadd L
.3098 .00509 -1.875 0 Mabsadd L closepath F
.31373 .00451 -1.875 0 Mabsadd m
.31373 .00451 0 2.5 Mabsadd L
.31373 .00451 1.875 0 Mabsadd L
.31373 .00451 0 -2.5 Mabsadd L
.31373 .00451 -1.875 0 Mabsadd L closepath F
.31765 .00398 -1.875 0 Mabsadd m
.31765 .00398 0 2.5 Mabsadd L
.31765 .00398 1.875 0 Mabsadd L
.31765 .00398 0 -2.5 Mabsadd L
.31765 .00398 -1.875 0 Mabsadd L closepath F
.32157 .00351 -1.875 0 Mabsadd m
.32157 .00351 0 2.5 Mabsadd L
.32157 .00351 1.875 0 Mabsadd L
.32157 .00351 0 -2.5 Mabsadd L
.32157 .00351 -1.875 0 Mabsadd L closepath F
.32549 .00309 -1.875 0 Mabsadd m
.32549 .00309 0 2.5 Mabsadd L
.32549 .00309 1.875 0 Mabsadd L
.32549 .00309 0 -2.5 Mabsadd L
.32549 .00309 -1.875 0 Mabsadd L closepath F
.32941 .00272 -1.875 0 Mabsadd m
.32941 .00272 0 2.5 Mabsadd L
.32941 .00272 1.875 0 Mabsadd L
.32941 .00272 0 -2.5 Mabsadd L
.32941 .00272 -1.875 0 Mabsadd L closepath F
.33333 .00239 -1.875 0 Mabsadd m
.33333 .00239 0 2.5 Mabsadd L
.33333 .00239 1.875 0 Mabsadd L
.33333 .00239 0 -2.5 Mabsadd L
.33333 .00239 -1.875 0 Mabsadd L closepath F
.33725 .00209 -1.875 0 Mabsadd m
.33725 .00209 0 2.5 Mabsadd L
.33725 .00209 1.875 0 Mabsadd L
.33725 .00209 0 -2.5 Mabsadd L
.33725 .00209 -1.875 0 Mabsadd L closepath F
.34118 .00183 -1.875 0 Mabsadd m
.34118 .00183 0 2.5 Mabsadd L
.34118 .00183 1.875 0 Mabsadd L
.34118 .00183 0 -2.5 Mabsadd L
.34118 .00183 -1.875 0 Mabsadd L closepath F
.3451 .0016 -1.875 0 Mabsadd m
.3451 .0016 0 2.5 Mabsadd L
.3451 .0016 1.875 0 Mabsadd L
.3451 .0016 0 -2.5 Mabsadd L
.3451 .0016 -1.875 0 Mabsadd L closepath F
.34902 .0014 -1.875 0 Mabsadd m
.34902 .0014 0 2.5 Mabsadd L
.34902 .0014 1.875 0 Mabsadd L
.34902 .0014 0 -2.5 Mabsadd L
.34902 .0014 -1.875 0 Mabsadd L closepath F
.35294 .00122 -1.875 0 Mabsadd m
.35294 .00122 0 2.5 Mabsadd L
.35294 .00122 1.875 0 Mabsadd L
.35294 .00122 0 -2.5 Mabsadd L
.35294 .00122 -1.875 0 Mabsadd L closepath F
.35686 .00106 -1.875 0 Mabsadd m
.35686 .00106 0 2.5 Mabsadd L
.35686 .00106 1.875 0 Mabsadd L
.35686 .00106 0 -2.5 Mabsadd L
.35686 .00106 -1.875 0 Mabsadd L closepath F
.36078 .00092 -1.875 0 Mabsadd m
.36078 .00092 0 2.5 Mabsadd L
.36078 .00092 1.875 0 Mabsadd L
.36078 .00092 0 -2.5 Mabsadd L
.36078 .00092 -1.875 0 Mabsadd L closepath F
.36471 .0008 -1.875 0 Mabsadd m
.36471 .0008 0 2.5 Mabsadd L
.36471 .0008 1.875 0 Mabsadd L
.36471 .0008 0 -2.5 Mabsadd L
.36471 .0008 -1.875 0 Mabsadd L closepath F
.36863 .00069 -1.875 0 Mabsadd m
.36863 .00069 0 2.5 Mabsadd L
.36863 .00069 1.875 0 Mabsadd L
.36863 .00069 0 -2.5 Mabsadd L
.36863 .00069 -1.875 0 Mabsadd L closepath F
.37255 .0006 -1.875 0 Mabsadd m
.37255 .0006 0 2.5 Mabsadd L
.37255 .0006 1.875 0 Mabsadd L
.37255 .0006 0 -2.5 Mabsadd L
.37255 .0006 -1.875 0 Mabsadd L closepath F
.37647 .00052 -1.875 0 Mabsadd m
.37647 .00052 0 2.5 Mabsadd L
.37647 .00052 1.875 0 Mabsadd L
.37647 .00052 0 -2.5 Mabsadd L
.37647 .00052 -1.875 0 Mabsadd L closepath F
.38039 .00045 -1.875 0 Mabsadd m
.38039 .00045 0 2.5 Mabsadd L
.38039 .00045 1.875 0 Mabsadd L
.38039 .00045 0 -2.5 Mabsadd L
.38039 .00045 -1.875 0 Mabsadd L closepath F
.38431 .00038 -1.875 0 Mabsadd m
.38431 .00038 0 2.5 Mabsadd L
.38431 .00038 1.875 0 Mabsadd L
.38431 .00038 0 -2.5 Mabsadd L
.38431 .00038 -1.875 0 Mabsadd L closepath F
.38824 .00033 -1.875 0 Mabsadd m
.38824 .00033 0 2.5 Mabsadd L
.38824 .00033 1.875 0 Mabsadd L
.38824 .00033 0 -2.5 Mabsadd L
.38824 .00033 -1.875 0 Mabsadd L closepath F
.39216 .00028 -1.875 0 Mabsadd m
.39216 .00028 0 2.5 Mabsadd L
.39216 .00028 1.875 0 Mabsadd L
.39216 .00028 0 -2.5 Mabsadd L
.39216 .00028 -1.875 0 Mabsadd L closepath F
.39608 .00024 -1.875 0 Mabsadd m
.39608 .00024 0 2.5 Mabsadd L
.39608 .00024 1.875 0 Mabsadd L
.39608 .00024 0 -2.5 Mabsadd L
.39608 .00024 -1.875 0 Mabsadd L closepath F
.4 .00021 -1.875 0 Mabsadd m
.4 .00021 0 2.5 Mabsadd L
.4 .00021 1.875 0 Mabsadd L
.4 .00021 0 -2.5 Mabsadd L
.4 .00021 -1.875 0 Mabsadd L closepath F
.40392 .00018 -1.875 0 Mabsadd m
.40392 .00018 0 2.5 Mabsadd L
.40392 .00018 1.875 0 Mabsadd L
.40392 .00018 0 -2.5 Mabsadd L
.40392 .00018 -1.875 0 Mabsadd L closepath F
.40784 .00015 -1.875 0 Mabsadd m
.40784 .00015 0 2.5 Mabsadd L
.40784 .00015 1.875 0 Mabsadd L
.40784 .00015 0 -2.5 Mabsadd L
.40784 .00015 -1.875 0 Mabsadd L closepath F
.41176 .00013 -1.875 0 Mabsadd m
.41176 .00013 0 2.5 Mabsadd L
.41176 .00013 1.875 0 Mabsadd L
.41176 .00013 0 -2.5 Mabsadd L
.41176 .00013 -1.875 0 Mabsadd L closepath F
.41569 .00011 -1.875 0 Mabsadd m
.41569 .00011 0 2.5 Mabsadd L
.41569 .00011 1.875 0 Mabsadd L
.41569 .00011 0 -2.5 Mabsadd L
.41569 .00011 -1.875 0 Mabsadd L closepath F
.41961 9e-005 -1.875 0 Mabsadd m
.41961 9e-005 0 2.5 Mabsadd L
.41961 9e-005 1.875 0 Mabsadd L
.41961 9e-005 0 -2.5 Mabsadd L
.41961 9e-005 -1.875 0 Mabsadd L closepath F
.42353 8e-005 -1.875 0 Mabsadd m
.42353 8e-005 0 2.5 Mabsadd L
.42353 8e-005 1.875 0 Mabsadd L
.42353 8e-005 0 -2.5 Mabsadd L
.42353 8e-005 -1.875 0 Mabsadd L closepath F
.42745 7e-005 -1.875 0 Mabsadd m
.42745 7e-005 0 2.5 Mabsadd L
.42745 7e-005 1.875 0 Mabsadd L
.42745 7e-005 0 -2.5 Mabsadd L
.42745 7e-005 -1.875 0 Mabsadd L closepath F
.43137 6e-005 -1.875 0 Mabsadd m
.43137 6e-005 0 2.5 Mabsadd L
.43137 6e-005 1.875 0 Mabsadd L
.43137 6e-005 0 -2.5 Mabsadd L
.43137 6e-005 -1.875 0 Mabsadd L closepath F
.43529 5e-005 -1.875 0 Mabsadd m
.43529 5e-005 0 2.5 Mabsadd L
.43529 5e-005 1.875 0 Mabsadd L
.43529 5e-005 0 -2.5 Mabsadd L
.43529 5e-005 -1.875 0 Mabsadd L closepath F
.43922 4e-005 -1.875 0 Mabsadd m
.43922 4e-005 0 2.5 Mabsadd L
.43922 4e-005 1.875 0 Mabsadd L
.43922 4e-005 0 -2.5 Mabsadd L
.43922 4e-005 -1.875 0 Mabsadd L closepath F
.44314 3e-005 -1.875 0 Mabsadd m
.44314 3e-005 0 2.5 Mabsadd L
.44314 3e-005 1.875 0 Mabsadd L
.44314 3e-005 0 -2.5 Mabsadd L
.44314 3e-005 -1.875 0 Mabsadd L closepath F
.44706 3e-005 -1.875 0 Mabsadd m
.44706 3e-005 0 2.5 Mabsadd L
.44706 3e-005 1.875 0 Mabsadd L
.44706 3e-005 0 -2.5 Mabsadd L
.44706 3e-005 -1.875 0 Mabsadd L closepath F
.45098 2e-005 -1.875 0 Mabsadd m
.45098 2e-005 0 2.5 Mabsadd L
.45098 2e-005 1.875 0 Mabsadd L
.45098 2e-005 0 -2.5 Mabsadd L
.45098 2e-005 -1.875 0 Mabsadd L closepath F
.4549 2e-005 -1.875 0 Mabsadd m
.4549 2e-005 0 2.5 Mabsadd L
.4549 2e-005 1.875 0 Mabsadd L
.4549 2e-005 0 -2.5 Mabsadd L
.4549 2e-005 -1.875 0 Mabsadd L closepath F
.45882 2e-005 -1.875 0 Mabsadd m
.45882 2e-005 0 2.5 Mabsadd L
.45882 2e-005 1.875 0 Mabsadd L
.45882 2e-005 0 -2.5 Mabsadd L
.45882 2e-005 -1.875 0 Mabsadd L closepath F
.46275 1e-005 -1.875 0 Mabsadd m
.46275 1e-005 0 2.5 Mabsadd L
.46275 1e-005 1.875 0 Mabsadd L
.46275 1e-005 0 -2.5 Mabsadd L
.46275 1e-005 -1.875 0 Mabsadd L closepath F
.46667 1e-005 -1.875 0 Mabsadd m
.46667 1e-005 0 2.5 Mabsadd L
.46667 1e-005 1.875 0 Mabsadd L
.46667 1e-005 0 -2.5 Mabsadd L
.46667 1e-005 -1.875 0 Mabsadd L closepath F
.47059 1e-005 -1.875 0 Mabsadd m
.47059 1e-005 0 2.5 Mabsadd L
.47059 1e-005 1.875 0 Mabsadd L
.47059 1e-005 0 -2.5 Mabsadd L
.47059 1e-005 -1.875 0 Mabsadd L closepath F
.47451 1e-005 -1.875 0 Mabsadd m
.47451 1e-005 0 2.5 Mabsadd L
.47451 1e-005 1.875 0 Mabsadd L
.47451 1e-005 0 -2.5 Mabsadd L
.47451 1e-005 -1.875 0 Mabsadd L closepath F
.47843 1e-005 -1.875 0 Mabsadd m
.47843 1e-005 0 2.5 Mabsadd L
.47843 1e-005 1.875 0 Mabsadd L
.47843 1e-005 0 -2.5 Mabsadd L
.47843 1e-005 -1.875 0 Mabsadd L closepath F
.48235 1e-005 -1.875 0 Mabsadd m
.48235 1e-005 0 2.5 Mabsadd L
.48235 1e-005 1.875 0 Mabsadd L
.48235 1e-005 0 -2.5 Mabsadd L
.48235 1e-005 -1.875 0 Mabsadd L closepath F
.48627 0 -1.875 0 Mabsadd m
.48627 0 0 2.5 Mabsadd L
.48627 0 1.875 0 Mabsadd L
.48627 0 0 -2.5 Mabsadd L
.48627 0 -1.875 0 Mabsadd L closepath F
.4902 0 -1.875 0 Mabsadd m
.4902 0 0 2.5 Mabsadd L
.4902 0 1.875 0 Mabsadd L
.4902 0 0 -2.5 Mabsadd L
.4902 0 -1.875 0 Mabsadd L closepath F
.49412 0 -1.875 0 Mabsadd m
.49412 0 0 2.5 Mabsadd L
.49412 0 1.875 0 Mabsadd L
.49412 0 0 -2.5 Mabsadd L
.49412 0 -1.875 0 Mabsadd L closepath F
.49804 0 -1.875 0 Mabsadd m
.49804 0 0 2.5 Mabsadd L
.49804 0 1.875 0 Mabsadd L
.49804 0 0 -2.5 Mabsadd L
.49804 0 -1.875 0 Mabsadd L closepath F
.50196 0 -1.875 0 Mabsadd m
.50196 0 0 2.5 Mabsadd L
.50196 0 1.875 0 Mabsadd L
.50196 0 0 -2.5 Mabsadd L
.50196 0 -1.875 0 Mabsadd L closepath F
.50588 0 -1.875 0 Mabsadd m
.50588 0 0 2.5 Mabsadd L
.50588 0 1.875 0 Mabsadd L
.50588 0 0 -2.5 Mabsadd L
.50588 0 -1.875 0 Mabsadd L closepath F
.5098 0 -1.875 0 Mabsadd m
.5098 0 0 2.5 Mabsadd L
.5098 0 1.875 0 Mabsadd L
.5098 0 0 -2.5 Mabsadd L
.5098 0 -1.875 0 Mabsadd L closepath F
.51373 0 -1.875 0 Mabsadd m
.51373 0 0 2.5 Mabsadd L
.51373 0 1.875 0 Mabsadd L
.51373 0 0 -2.5 Mabsadd L
.51373 0 -1.875 0 Mabsadd L closepath F
.51765 0 -1.875 0 Mabsadd m
.51765 0 0 2.5 Mabsadd L
.51765 0 1.875 0 Mabsadd L
.51765 0 0 -2.5 Mabsadd L
.51765 0 -1.875 0 Mabsadd L closepath F
.52157 0 -1.875 0 Mabsadd m
.52157 0 0 2.5 Mabsadd L
.52157 0 1.875 0 Mabsadd L
.52157 0 0 -2.5 Mabsadd L
.52157 0 -1.875 0 Mabsadd L closepath F
.52549 0 -1.875 0 Mabsadd m
.52549 0 0 2.5 Mabsadd L
.52549 0 1.875 0 Mabsadd L
.52549 0 0 -2.5 Mabsadd L
.52549 0 -1.875 0 Mabsadd L closepath F
.52941 0 -1.875 0 Mabsadd m
.52941 0 0 2.5 Mabsadd L
.52941 0 1.875 0 Mabsadd L
.52941 0 0 -2.5 Mabsadd L
.52941 0 -1.875 0 Mabsadd L closepath F
.53333 0 -1.875 0 Mabsadd m
.53333 0 0 2.5 Mabsadd L
.53333 0 1.875 0 Mabsadd L
.53333 0 0 -2.5 Mabsadd L
.53333 0 -1.875 0 Mabsadd L closepath F
.53725 0 -1.875 0 Mabsadd m
.53725 0 0 2.5 Mabsadd L
.53725 0 1.875 0 Mabsadd L
.53725 0 0 -2.5 Mabsadd L
.53725 0 -1.875 0 Mabsadd L closepath F
.54118 0 -1.875 0 Mabsadd m
.54118 0 0 2.5 Mabsadd L
.54118 0 1.875 0 Mabsadd L
.54118 0 0 -2.5 Mabsadd L
.54118 0 -1.875 0 Mabsadd L closepath F
.5451 0 -1.875 0 Mabsadd m
.5451 0 0 2.5 Mabsadd L
.5451 0 1.875 0 Mabsadd L
.5451 0 0 -2.5 Mabsadd L
.5451 0 -1.875 0 Mabsadd L closepath F
.54902 0 -1.875 0 Mabsadd m
.54902 0 0 2.5 Mabsadd L
.54902 0 1.875 0 Mabsadd L
.54902 0 0 -2.5 Mabsadd L
.54902 0 -1.875 0 Mabsadd L closepath F
.55294 0 -1.875 0 Mabsadd m
.55294 0 0 2.5 Mabsadd L
.55294 0 1.875 0 Mabsadd L
.55294 0 0 -2.5 Mabsadd L
.55294 0 -1.875 0 Mabsadd L closepath F
.55686 0 -1.875 0 Mabsadd m
.55686 0 0 2.5 Mabsadd L
.55686 0 1.875 0 Mabsadd L
.55686 0 0 -2.5 Mabsadd L
.55686 0 -1.875 0 Mabsadd L closepath F
.56078 0 -1.875 0 Mabsadd m
.56078 0 0 2.5 Mabsadd L
.56078 0 1.875 0 Mabsadd L
.56078 0 0 -2.5 Mabsadd L
.56078 0 -1.875 0 Mabsadd L closepath F
.56471 0 -1.875 0 Mabsadd m
.56471 0 0 2.5 Mabsadd L
.56471 0 1.875 0 Mabsadd L
.56471 0 0 -2.5 Mabsadd L
.56471 0 -1.875 0 Mabsadd L closepath F
.56863 0 -1.875 0 Mabsadd m
.56863 0 0 2.5 Mabsadd L
.56863 0 1.875 0 Mabsadd L
.56863 0 0 -2.5 Mabsadd L
.56863 0 -1.875 0 Mabsadd L closepath F
.57255 0 -1.875 0 Mabsadd m
.57255 0 0 2.5 Mabsadd L
.57255 0 1.875 0 Mabsadd L
.57255 0 0 -2.5 Mabsadd L
.57255 0 -1.875 0 Mabsadd L closepath F
.57647 0 -1.875 0 Mabsadd m
.57647 0 0 2.5 Mabsadd L
.57647 0 1.875 0 Mabsadd L
.57647 0 0 -2.5 Mabsadd L
.57647 0 -1.875 0 Mabsadd L closepath F
.58039 0 -1.875 0 Mabsadd m
.58039 0 0 2.5 Mabsadd L
.58039 0 1.875 0 Mabsadd L
.58039 0 0 -2.5 Mabsadd L
.58039 0 -1.875 0 Mabsadd L closepath F
.58431 0 -1.875 0 Mabsadd m
.58431 0 0 2.5 Mabsadd L
.58431 0 1.875 0 Mabsadd L
.58431 0 0 -2.5 Mabsadd L
.58431 0 -1.875 0 Mabsadd L closepath F
.58824 0 -1.875 0 Mabsadd m
.58824 0 0 2.5 Mabsadd L
.58824 0 1.875 0 Mabsadd L
.58824 0 0 -2.5 Mabsadd L
.58824 0 -1.875 0 Mabsadd L closepath F
.59216 0 -1.875 0 Mabsadd m
.59216 0 0 2.5 Mabsadd L
.59216 0 1.875 0 Mabsadd L
.59216 0 0 -2.5 Mabsadd L
.59216 0 -1.875 0 Mabsadd L closepath F
.59608 0 -1.875 0 Mabsadd m
.59608 0 0 2.5 Mabsadd L
.59608 0 1.875 0 Mabsadd L
.59608 0 0 -2.5 Mabsadd L
.59608 0 -1.875 0 Mabsadd L closepath F
.6 0 -1.875 0 Mabsadd m
.6 0 0 2.5 Mabsadd L
.6 0 1.875 0 Mabsadd L
.6 0 0 -2.5 Mabsadd L
.6 0 -1.875 0 Mabsadd L closepath F
.60392 0 -1.875 0 Mabsadd m
.60392 0 0 2.5 Mabsadd L
.60392 0 1.875 0 Mabsadd L
.60392 0 0 -2.5 Mabsadd L
.60392 0 -1.875 0 Mabsadd L closepath F
.60784 0 -1.875 0 Mabsadd m
.60784 0 0 2.5 Mabsadd L
.60784 0 1.875 0 Mabsadd L
.60784 0 0 -2.5 Mabsadd L
.60784 0 -1.875 0 Mabsadd L closepath F
.61176 0 -1.875 0 Mabsadd m
.61176 0 0 2.5 Mabsadd L
.61176 0 1.875 0 Mabsadd L
.61176 0 0 -2.5 Mabsadd L
.61176 0 -1.875 0 Mabsadd L closepath F
.61569 0 -1.875 0 Mabsadd m
.61569 0 0 2.5 Mabsadd L
.61569 0 1.875 0 Mabsadd L
.61569 0 0 -2.5 Mabsadd L
.61569 0 -1.875 0 Mabsadd L closepath F
.61961 0 -1.875 0 Mabsadd m
.61961 0 0 2.5 Mabsadd L
.61961 0 1.875 0 Mabsadd L
.61961 0 0 -2.5 Mabsadd L
.61961 0 -1.875 0 Mabsadd L closepath F
.62353 0 -1.875 0 Mabsadd m
.62353 0 0 2.5 Mabsadd L
.62353 0 1.875 0 Mabsadd L
.62353 0 0 -2.5 Mabsadd L
.62353 0 -1.875 0 Mabsadd L closepath F
.62745 0 -1.875 0 Mabsadd m
.62745 0 0 2.5 Mabsadd L
.62745 0 1.875 0 Mabsadd L
.62745 0 0 -2.5 Mabsadd L
.62745 0 -1.875 0 Mabsadd L closepath F
.63137 0 -1.875 0 Mabsadd m
.63137 0 0 2.5 Mabsadd L
.63137 0 1.875 0 Mabsadd L
.63137 0 0 -2.5 Mabsadd L
.63137 0 -1.875 0 Mabsadd L closepath F
.63529 0 -1.875 0 Mabsadd m
.63529 0 0 2.5 Mabsadd L
.63529 0 1.875 0 Mabsadd L
.63529 0 0 -2.5 Mabsadd L
.63529 0 -1.875 0 Mabsadd L closepath F
.63922 0 -1.875 0 Mabsadd m
.63922 0 0 2.5 Mabsadd L
.63922 0 1.875 0 Mabsadd L
.63922 0 0 -2.5 Mabsadd L
.63922 0 -1.875 0 Mabsadd L closepath F
.64314 0 -1.875 0 Mabsadd m
.64314 0 0 2.5 Mabsadd L
.64314 0 1.875 0 Mabsadd L
.64314 0 0 -2.5 Mabsadd L
.64314 0 -1.875 0 Mabsadd L closepath F
.64706 0 -1.875 0 Mabsadd m
.64706 0 0 2.5 Mabsadd L
.64706 0 1.875 0 Mabsadd L
.64706 0 0 -2.5 Mabsadd L
.64706 0 -1.875 0 Mabsadd L closepath F
.65098 0 -1.875 0 Mabsadd m
.65098 0 0 2.5 Mabsadd L
.65098 0 1.875 0 Mabsadd L
.65098 0 0 -2.5 Mabsadd L
.65098 0 -1.875 0 Mabsadd L closepath F
.6549 0 -1.875 0 Mabsadd m
.6549 0 0 2.5 Mabsadd L
.6549 0 1.875 0 Mabsadd L
.6549 0 0 -2.5 Mabsadd L
.6549 0 -1.875 0 Mabsadd L closepath F
.65882 0 -1.875 0 Mabsadd m
.65882 0 0 2.5 Mabsadd L
.65882 0 1.875 0 Mabsadd L
.65882 0 0 -2.5 Mabsadd L
.65882 0 -1.875 0 Mabsadd L closepath F
.66275 0 -1.875 0 Mabsadd m
.66275 0 0 2.5 Mabsadd L
.66275 0 1.875 0 Mabsadd L
.66275 0 0 -2.5 Mabsadd L
.66275 0 -1.875 0 Mabsadd L closepath F
.66667 0 -1.875 0 Mabsadd m
.66667 0 0 2.5 Mabsadd L
.66667 0 1.875 0 Mabsadd L
.66667 0 0 -2.5 Mabsadd L
.66667 0 -1.875 0 Mabsadd L closepath F
.67059 0 -1.875 0 Mabsadd m
.67059 0 0 2.5 Mabsadd L
.67059 0 1.875 0 Mabsadd L
.67059 0 0 -2.5 Mabsadd L
.67059 0 -1.875 0 Mabsadd L closepath F
.67451 0 -1.875 0 Mabsadd m
.67451 0 0 2.5 Mabsadd L
.67451 0 1.875 0 Mabsadd L
.67451 0 0 -2.5 Mabsadd L
.67451 0 -1.875 0 Mabsadd L closepath F
.67843 0 -1.875 0 Mabsadd m
.67843 0 0 2.5 Mabsadd L
.67843 0 1.875 0 Mabsadd L
.67843 0 0 -2.5 Mabsadd L
.67843 0 -1.875 0 Mabsadd L closepath F
.68235 0 -1.875 0 Mabsadd m
.68235 0 0 2.5 Mabsadd L
.68235 0 1.875 0 Mabsadd L
.68235 0 0 -2.5 Mabsadd L
.68235 0 -1.875 0 Mabsadd L closepath F
.68627 0 -1.875 0 Mabsadd m
.68627 0 0 2.5 Mabsadd L
.68627 0 1.875 0 Mabsadd L
.68627 0 0 -2.5 Mabsadd L
.68627 0 -1.875 0 Mabsadd L closepath F
.6902 0 -1.875 0 Mabsadd m
.6902 0 0 2.5 Mabsadd L
.6902 0 1.875 0 Mabsadd L
.6902 0 0 -2.5 Mabsadd L
.6902 0 -1.875 0 Mabsadd L closepath F
.69412 0 -1.875 0 Mabsadd m
.69412 0 0 2.5 Mabsadd L
.69412 0 1.875 0 Mabsadd L
.69412 0 0 -2.5 Mabsadd L
.69412 0 -1.875 0 Mabsadd L closepath F
.69804 0 -1.875 0 Mabsadd m
.69804 0 0 2.5 Mabsadd L
.69804 0 1.875 0 Mabsadd L
.69804 0 0 -2.5 Mabsadd L
.69804 0 -1.875 0 Mabsadd L closepath F
.70196 0 -1.875 0 Mabsadd m
.70196 0 0 2.5 Mabsadd L
.70196 0 1.875 0 Mabsadd L
.70196 0 0 -2.5 Mabsadd L
.70196 0 -1.875 0 Mabsadd L closepath F
.70588 0 -1.875 0 Mabsadd m
.70588 0 0 2.5 Mabsadd L
.70588 0 1.875 0 Mabsadd L
.70588 0 0 -2.5 Mabsadd L
.70588 0 -1.875 0 Mabsadd L closepath F
.7098 0 -1.875 0 Mabsadd m
.7098 0 0 2.5 Mabsadd L
.7098 0 1.875 0 Mabsadd L
.7098 0 0 -2.5 Mabsadd L
.7098 0 -1.875 0 Mabsadd L closepath F
.71373 0 -1.875 0 Mabsadd m
.71373 0 0 2.5 Mabsadd L
.71373 0 1.875 0 Mabsadd L
.71373 0 0 -2.5 Mabsadd L
.71373 0 -1.875 0 Mabsadd L closepath F
.71765 0 -1.875 0 Mabsadd m
.71765 0 0 2.5 Mabsadd L
.71765 0 1.875 0 Mabsadd L
.71765 0 0 -2.5 Mabsadd L
.71765 0 -1.875 0 Mabsadd L closepath F
.72157 0 -1.875 0 Mabsadd m
.72157 0 0 2.5 Mabsadd L
.72157 0 1.875 0 Mabsadd L
.72157 0 0 -2.5 Mabsadd L
.72157 0 -1.875 0 Mabsadd L closepath F
.72549 0 -1.875 0 Mabsadd m
.72549 0 0 2.5 Mabsadd L
.72549 0 1.875 0 Mabsadd L
.72549 0 0 -2.5 Mabsadd L
.72549 0 -1.875 0 Mabsadd L closepath F
.72941 0 -1.875 0 Mabsadd m
.72941 0 0 2.5 Mabsadd L
.72941 0 1.875 0 Mabsadd L
.72941 0 0 -2.5 Mabsadd L
.72941 0 -1.875 0 Mabsadd L closepath F
.73333 0 -1.875 0 Mabsadd m
.73333 0 0 2.5 Mabsadd L
.73333 0 1.875 0 Mabsadd L
.73333 0 0 -2.5 Mabsadd L
.73333 0 -1.875 0 Mabsadd L closepath F
.73725 0 -1.875 0 Mabsadd m
.73725 0 0 2.5 Mabsadd L
.73725 0 1.875 0 Mabsadd L
.73725 0 0 -2.5 Mabsadd L
.73725 0 -1.875 0 Mabsadd L closepath F
.74118 0 -1.875 0 Mabsadd m
.74118 0 0 2.5 Mabsadd L
.74118 0 1.875 0 Mabsadd L
.74118 0 0 -2.5 Mabsadd L
.74118 0 -1.875 0 Mabsadd L closepath F
.7451 0 -1.875 0 Mabsadd m
.7451 0 0 2.5 Mabsadd L
.7451 0 1.875 0 Mabsadd L
.7451 0 0 -2.5 Mabsadd L
.7451 0 -1.875 0 Mabsadd L closepath F
.74902 0 -1.875 0 Mabsadd m
.74902 0 0 2.5 Mabsadd L
.74902 0 1.875 0 Mabsadd L
.74902 0 0 -2.5 Mabsadd L
.74902 0 -1.875 0 Mabsadd L closepath F
.75294 0 -1.875 0 Mabsadd m
.75294 0 0 2.5 Mabsadd L
.75294 0 1.875 0 Mabsadd L
.75294 0 0 -2.5 Mabsadd L
.75294 0 -1.875 0 Mabsadd L closepath F
.75686 0 -1.875 0 Mabsadd m
.75686 0 0 2.5 Mabsadd L
.75686 0 1.875 0 Mabsadd L
.75686 0 0 -2.5 Mabsadd L
.75686 0 -1.875 0 Mabsadd L closepath F
.76078 0 -1.875 0 Mabsadd m
.76078 0 0 2.5 Mabsadd L
.76078 0 1.875 0 Mabsadd L
.76078 0 0 -2.5 Mabsadd L
.76078 0 -1.875 0 Mabsadd L closepath F
.76471 0 -1.875 0 Mabsadd m
.76471 0 0 2.5 Mabsadd L
.76471 0 1.875 0 Mabsadd L
.76471 0 0 -2.5 Mabsadd L
.76471 0 -1.875 0 Mabsadd L closepath F
.76863 0 -1.875 0 Mabsadd m
.76863 0 0 2.5 Mabsadd L
.76863 0 1.875 0 Mabsadd L
.76863 0 0 -2.5 Mabsadd L
.76863 0 -1.875 0 Mabsadd L closepath F
.77255 0 -1.875 0 Mabsadd m
.77255 0 0 2.5 Mabsadd L
.77255 0 1.875 0 Mabsadd L
.77255 0 0 -2.5 Mabsadd L
.77255 0 -1.875 0 Mabsadd L closepath F
.77647 0 -1.875 0 Mabsadd m
.77647 0 0 2.5 Mabsadd L
.77647 0 1.875 0 Mabsadd L
.77647 0 0 -2.5 Mabsadd L
.77647 0 -1.875 0 Mabsadd L closepath F
.78039 0 -1.875 0 Mabsadd m
.78039 0 0 2.5 Mabsadd L
.78039 0 1.875 0 Mabsadd L
.78039 0 0 -2.5 Mabsadd L
.78039 0 -1.875 0 Mabsadd L closepath F
.78431 0 -1.875 0 Mabsadd m
.78431 0 0 2.5 Mabsadd L
.78431 0 1.875 0 Mabsadd L
.78431 0 0 -2.5 Mabsadd L
.78431 0 -1.875 0 Mabsadd L closepath F
.78824 0 -1.875 0 Mabsadd m
.78824 0 0 2.5 Mabsadd L
.78824 0 1.875 0 Mabsadd L
.78824 0 0 -2.5 Mabsadd L
.78824 0 -1.875 0 Mabsadd L closepath F
.79216 0 -1.875 0 Mabsadd m
.79216 0 0 2.5 Mabsadd L
.79216 0 1.875 0 Mabsadd L
.79216 0 0 -2.5 Mabsadd L
.79216 0 -1.875 0 Mabsadd L closepath F
.79608 0 -1.875 0 Mabsadd m
.79608 0 0 2.5 Mabsadd L
.79608 0 1.875 0 Mabsadd L
.79608 0 0 -2.5 Mabsadd L
.79608 0 -1.875 0 Mabsadd L closepath F
.8 0 -1.875 0 Mabsadd m
.8 0 0 2.5 Mabsadd L
.8 0 1.875 0 Mabsadd L
.8 0 0 -2.5 Mabsadd L
.8 0 -1.875 0 Mabsadd L closepath F
.80392 0 -1.875 0 Mabsadd m
.80392 0 0 2.5 Mabsadd L
.80392 0 1.875 0 Mabsadd L
.80392 0 0 -2.5 Mabsadd L
.80392 0 -1.875 0 Mabsadd L closepath F
.80784 0 -1.875 0 Mabsadd m
.80784 0 0 2.5 Mabsadd L
.80784 0 1.875 0 Mabsadd L
.80784 0 0 -2.5 Mabsadd L
.80784 0 -1.875 0 Mabsadd L closepath F
.81176 0 -1.875 0 Mabsadd m
.81176 0 0 2.5 Mabsadd L
.81176 0 1.875 0 Mabsadd L
.81176 0 0 -2.5 Mabsadd L
.81176 0 -1.875 0 Mabsadd L closepath F
.81569 0 -1.875 0 Mabsadd m
.81569 0 0 2.5 Mabsadd L
.81569 0 1.875 0 Mabsadd L
.81569 0 0 -2.5 Mabsadd L
.81569 0 -1.875 0 Mabsadd L closepath F
.81961 0 -1.875 0 Mabsadd m
.81961 0 0 2.5 Mabsadd L
.81961 0 1.875 0 Mabsadd L
.81961 0 0 -2.5 Mabsadd L
.81961 0 -1.875 0 Mabsadd L closepath F
.82353 0 -1.875 0 Mabsadd m
.82353 0 0 2.5 Mabsadd L
.82353 0 1.875 0 Mabsadd L
.82353 0 0 -2.5 Mabsadd L
.82353 0 -1.875 0 Mabsadd L closepath F
.82745 0 -1.875 0 Mabsadd m
.82745 0 0 2.5 Mabsadd L
.82745 0 1.875 0 Mabsadd L
.82745 0 0 -2.5 Mabsadd L
.82745 0 -1.875 0 Mabsadd L closepath F
.83137 0 -1.875 0 Mabsadd m
.83137 0 0 2.5 Mabsadd L
.83137 0 1.875 0 Mabsadd L
.83137 0 0 -2.5 Mabsadd L
.83137 0 -1.875 0 Mabsadd L closepath F
.83529 0 -1.875 0 Mabsadd m
.83529 0 0 2.5 Mabsadd L
.83529 0 1.875 0 Mabsadd L
.83529 0 0 -2.5 Mabsadd L
.83529 0 -1.875 0 Mabsadd L closepath F
.83922 0 -1.875 0 Mabsadd m
.83922 0 0 2.5 Mabsadd L
.83922 0 1.875 0 Mabsadd L
.83922 0 0 -2.5 Mabsadd L
.83922 0 -1.875 0 Mabsadd L closepath F
.84314 0 -1.875 0 Mabsadd m
.84314 0 0 2.5 Mabsadd L
.84314 0 1.875 0 Mabsadd L
.84314 0 0 -2.5 Mabsadd L
.84314 0 -1.875 0 Mabsadd L closepath F
.84706 0 -1.875 0 Mabsadd m
.84706 0 0 2.5 Mabsadd L
.84706 0 1.875 0 Mabsadd L
.84706 0 0 -2.5 Mabsadd L
.84706 0 -1.875 0 Mabsadd L closepath F
.85098 0 -1.875 0 Mabsadd m
.85098 0 0 2.5 Mabsadd L
.85098 0 1.875 0 Mabsadd L
.85098 0 0 -2.5 Mabsadd L
.85098 0 -1.875 0 Mabsadd L closepath F
.8549 0 -1.875 0 Mabsadd m
.8549 0 0 2.5 Mabsadd L
.8549 0 1.875 0 Mabsadd L
.8549 0 0 -2.5 Mabsadd L
.8549 0 -1.875 0 Mabsadd L closepath F
.85882 0 -1.875 0 Mabsadd m
.85882 0 0 2.5 Mabsadd L
.85882 0 1.875 0 Mabsadd L
.85882 0 0 -2.5 Mabsadd L
.85882 0 -1.875 0 Mabsadd L closepath F
.86275 0 -1.875 0 Mabsadd m
.86275 0 0 2.5 Mabsadd L
.86275 0 1.875 0 Mabsadd L
.86275 0 0 -2.5 Mabsadd L
.86275 0 -1.875 0 Mabsadd L closepath F
.86667 0 -1.875 0 Mabsadd m
.86667 0 0 2.5 Mabsadd L
.86667 0 1.875 0 Mabsadd L
.86667 0 0 -2.5 Mabsadd L
.86667 0 -1.875 0 Mabsadd L closepath F
.87059 0 -1.875 0 Mabsadd m
.87059 0 0 2.5 Mabsadd L
.87059 0 1.875 0 Mabsadd L
.87059 0 0 -2.5 Mabsadd L
.87059 0 -1.875 0 Mabsadd L closepath F
.87451 0 -1.875 0 Mabsadd m
.87451 0 0 2.5 Mabsadd L
.87451 0 1.875 0 Mabsadd L
.87451 0 0 -2.5 Mabsadd L
.87451 0 -1.875 0 Mabsadd L closepath F
.87843 0 -1.875 0 Mabsadd m
.87843 0 0 2.5 Mabsadd L
.87843 0 1.875 0 Mabsadd L
.87843 0 0 -2.5 Mabsadd L
.87843 0 -1.875 0 Mabsadd L closepath F
.88235 0 -1.875 0 Mabsadd m
.88235 0 0 2.5 Mabsadd L
.88235 0 1.875 0 Mabsadd L
.88235 0 0 -2.5 Mabsadd L
.88235 0 -1.875 0 Mabsadd L closepath F
.88627 0 -1.875 0 Mabsadd m
.88627 0 0 2.5 Mabsadd L
.88627 0 1.875 0 Mabsadd L
.88627 0 0 -2.5 Mabsadd L
.88627 0 -1.875 0 Mabsadd L closepath F
.8902 0 -1.875 0 Mabsadd m
.8902 0 0 2.5 Mabsadd L
.8902 0 1.875 0 Mabsadd L
.8902 0 0 -2.5 Mabsadd L
.8902 0 -1.875 0 Mabsadd L closepath F
.89412 0 -1.875 0 Mabsadd m
.89412 0 0 2.5 Mabsadd L
.89412 0 1.875 0 Mabsadd L
.89412 0 0 -2.5 Mabsadd L
.89412 0 -1.875 0 Mabsadd L closepath F
.89804 0 -1.875 0 Mabsadd m
.89804 0 0 2.5 Mabsadd L
.89804 0 1.875 0 Mabsadd L
.89804 0 0 -2.5 Mabsadd L
.89804 0 -1.875 0 Mabsadd L closepath F
.90196 0 -1.875 0 Mabsadd m
.90196 0 0 2.5 Mabsadd L
.90196 0 1.875 0 Mabsadd L
.90196 0 0 -2.5 Mabsadd L
.90196 0 -1.875 0 Mabsadd L closepath F
.90588 0 -1.875 0 Mabsadd m
.90588 0 0 2.5 Mabsadd L
.90588 0 1.875 0 Mabsadd L
.90588 0 0 -2.5 Mabsadd L
.90588 0 -1.875 0 Mabsadd L closepath F
.9098 0 -1.875 0 Mabsadd m
.9098 0 0 2.5 Mabsadd L
.9098 0 1.875 0 Mabsadd L
.9098 0 0 -2.5 Mabsadd L
.9098 0 -1.875 0 Mabsadd L closepath F
.91373 0 -1.875 0 Mabsadd m
.91373 0 0 2.5 Mabsadd L
.91373 0 1.875 0 Mabsadd L
.91373 0 0 -2.5 Mabsadd L
.91373 0 -1.875 0 Mabsadd L closepath F
.91765 0 -1.875 0 Mabsadd m
.91765 0 0 2.5 Mabsadd L
.91765 0 1.875 0 Mabsadd L
.91765 0 0 -2.5 Mabsadd L
.91765 0 -1.875 0 Mabsadd L closepath F
.92157 0 -1.875 0 Mabsadd m
.92157 0 0 2.5 Mabsadd L
.92157 0 1.875 0 Mabsadd L
.92157 0 0 -2.5 Mabsadd L
.92157 0 -1.875 0 Mabsadd L closepath F
.92549 0 -1.875 0 Mabsadd m
.92549 0 0 2.5 Mabsadd L
.92549 0 1.875 0 Mabsadd L
.92549 0 0 -2.5 Mabsadd L
.92549 0 -1.875 0 Mabsadd L closepath F
.92941 0 -1.875 0 Mabsadd m
.92941 0 0 2.5 Mabsadd L
.92941 0 1.875 0 Mabsadd L
.92941 0 0 -2.5 Mabsadd L
.92941 0 -1.875 0 Mabsadd L closepath F
.93333 0 -1.875 0 Mabsadd m
.93333 0 0 2.5 Mabsadd L
.93333 0 1.875 0 Mabsadd L
.93333 0 0 -2.5 Mabsadd L
.93333 0 -1.875 0 Mabsadd L closepath F
.93725 0 -1.875 0 Mabsadd m
.93725 0 0 2.5 Mabsadd L
.93725 0 1.875 0 Mabsadd L
.93725 0 0 -2.5 Mabsadd L
.93725 0 -1.875 0 Mabsadd L closepath F
.94118 0 -1.875 0 Mabsadd m
.94118 0 0 2.5 Mabsadd L
.94118 0 1.875 0 Mabsadd L
.94118 0 0 -2.5 Mabsadd L
.94118 0 -1.875 0 Mabsadd L closepath F
.9451 0 -1.875 0 Mabsadd m
.9451 0 0 2.5 Mabsadd L
.9451 0 1.875 0 Mabsadd L
.9451 0 0 -2.5 Mabsadd L
.9451 0 -1.875 0 Mabsadd L closepath F
.94902 0 -1.875 0 Mabsadd m
.94902 0 0 2.5 Mabsadd L
.94902 0 1.875 0 Mabsadd L
.94902 0 0 -2.5 Mabsadd L
.94902 0 -1.875 0 Mabsadd L closepath F
.95294 0 -1.875 0 Mabsadd m
.95294 0 0 2.5 Mabsadd L
.95294 0 1.875 0 Mabsadd L
.95294 0 0 -2.5 Mabsadd L
.95294 0 -1.875 0 Mabsadd L closepath F
.95686 0 -1.875 0 Mabsadd m
.95686 0 0 2.5 Mabsadd L
.95686 0 1.875 0 Mabsadd L
.95686 0 0 -2.5 Mabsadd L
.95686 0 -1.875 0 Mabsadd L closepath F
.96078 0 -1.875 0 Mabsadd m
.96078 0 0 2.5 Mabsadd L
.96078 0 1.875 0 Mabsadd L
.96078 0 0 -2.5 Mabsadd L
.96078 0 -1.875 0 Mabsadd L closepath F
.96471 0 -1.875 0 Mabsadd m
.96471 0 0 2.5 Mabsadd L
.96471 0 1.875 0 Mabsadd L
.96471 0 0 -2.5 Mabsadd L
.96471 0 -1.875 0 Mabsadd L closepath F
.96863 0 -1.875 0 Mabsadd m
.96863 0 0 2.5 Mabsadd L
.96863 0 1.875 0 Mabsadd L
.96863 0 0 -2.5 Mabsadd L
.96863 0 -1.875 0 Mabsadd L closepath F
.97255 0 -1.875 0 Mabsadd m
.97255 0 0 2.5 Mabsadd L
.97255 0 1.875 0 Mabsadd L
.97255 0 0 -2.5 Mabsadd L
.97255 0 -1.875 0 Mabsadd L closepath F
.97647 0 -1.875 0 Mabsadd m
.97647 0 0 2.5 Mabsadd L
.97647 0 1.875 0 Mabsadd L
.97647 0 0 -2.5 Mabsadd L
.97647 0 -1.875 0 Mabsadd L closepath F
.98039 0 -1.875 0 Mabsadd m
.98039 0 0 2.5 Mabsadd L
.98039 0 1.875 0 Mabsadd L
.98039 0 0 -2.5 Mabsadd L
.98039 0 -1.875 0 Mabsadd L closepath F
.98431 0 -1.875 0 Mabsadd m
.98431 0 0 2.5 Mabsadd L
.98431 0 1.875 0 Mabsadd L
.98431 0 0 -2.5 Mabsadd L
.98431 0 -1.875 0 Mabsadd L closepath F
.98824 0 -1.875 0 Mabsadd m
.98824 0 0 2.5 Mabsadd L
.98824 0 1.875 0 Mabsadd L
.98824 0 0 -2.5 Mabsadd L
.98824 0 -1.875 0 Mabsadd L closepath F
.99216 0 -1.875 0 Mabsadd m
.99216 0 0 2.5 Mabsadd L
.99216 0 1.875 0 Mabsadd L
.99216 0 0 -2.5 Mabsadd L
.99216 0 -1.875 0 Mabsadd L closepath F
.99608 0 -1.875 0 Mabsadd m
.99608 0 0 2.5 Mabsadd L
.99608 0 1.875 0 Mabsadd L
.99608 0 0 -2.5 Mabsadd L
.99608 0 -1.875 0 Mabsadd L closepath F
1 0 -1.875 0 Mabsadd m
1 0 0 2.5 Mabsadd L
1 0 1.875 0 Mabsadd L
1 0 0 -2.5 Mabsadd L
1 0 -1.875 0 Mabsadd L closepath F
0 1 1 r
.001 w
0 .61803 m
.00392 .61708 L
.00784 .61424 L
.01176 .60954 L
.01569 .60301 L
.01961 .59472 L
.02353 .58475 L
.02745 .57317 L
.03137 .5601 L
.03529 .54565 L
.03922 .52994 L
.04314 .5131 L
.04706 .49526 L
.05098 .47658 L
.0549 .4572 L
.05882 .43726 L
.06275 .4169 L
.06667 .39627 L
.07059 .37551 L
.07451 .35474 L
.07843 .33408 L
.08235 .31367 L
.08627 .2936 L
.0902 .27397 L
.09412 .25486 L
.09804 .23636 L
.10196 .21853 L
.10588 .20143 L
.1098 .18509 L
.11373 .16956 L
.11765 .15485 L
.12157 .14098 L
.12549 .12797 L
.12941 .11579 L
.13333 .10446 L
.13725 .09394 L
.14118 .08422 L
.1451 .07528 L
.14902 .06708 L
.15294 .05959 L
.15686 .05277 L
.16078 .04659 L
.16471 .04101 L
.16863 .03598 L
.17255 .03148 L
.17647 .02745 L
.18039 .02386 L
.18431 .02068 L
.18824 .01787 L
.19216 .0154 L
Mistroke
.19608 .01322 L
.2 .01132 L
.20392 .00966 L
.20784 .00822 L
.21176 .00697 L
.21569 .0059 L
.21961 .00497 L
.22353 .00418 L
.22745 .0035 L
.23137 .00292 L
.23529 .00244 L
.23922 .00202 L
.24314 .00167 L
.24706 .00138 L
.25098 .00114 L
.2549 .00093 L
.25882 .00076 L
.26275 .00062 L
.26667 .0005 L
.27059 .00041 L
.27451 .00033 L
.27843 .00027 L
.28235 .00021 L
.28627 .00017 L
.2902 .00014 L
.29412 .00011 L
.29804 9e-005 L
.30196 7e-005 L
.30588 5e-005 L
.3098 4e-005 L
.31373 3e-005 L
.31765 3e-005 L
.32157 2e-005 L
.32549 2e-005 L
.32941 1e-005 L
.33333 1e-005 L
.33725 1e-005 L
.34118 1e-005 L
.3451 0 L
.34902 0 L
.35294 0 L
.35686 0 L
.36078 0 L
.36471 0 L
.36863 0 L
.37255 0 L
.37647 0 L
.38039 0 L
.38431 0 L
.38824 0 L
Mistroke
.39216 0 L
.39608 0 L
.4 0 L
.40392 0 L
.40784 0 L
.41176 0 L
.41569 0 L
.41961 0 L
.42353 0 L
.42745 0 L
.43137 0 L
.43529 0 L
.43922 0 L
.44314 0 L
.44706 0 L
.45098 0 L
.4549 0 L
.45882 0 L
.46275 0 L
.46667 0 L
.47059 0 L
.47451 0 L
.47843 0 L
.48235 0 L
.48627 0 L
.4902 0 L
.49412 0 L
.49804 0 L
.50196 0 L
.50588 0 L
.5098 0 L
.51373 0 L
.51765 0 L
.52157 0 L
.52549 0 L
.52941 0 L
.53333 0 L
.53725 0 L
.54118 0 L
.5451 0 L
.54902 0 L
.55294 0 L
.55686 0 L
.56078 0 L
.56471 0 L
.56863 0 L
.57255 0 L
.57647 0 L
.58039 0 L
.58431 0 L
Mistroke
.58824 0 L
.59216 0 L
.59608 0 L
.6 0 L
.60392 0 L
.60784 0 L
.61176 0 L
.61569 0 L
.61961 0 L
.62353 0 L
.62745 0 L
.63137 0 L
.63529 0 L
.63922 0 L
.64314 0 L
.64706 0 L
.65098 0 L
.6549 0 L
.65882 0 L
.66275 0 L
.66667 0 L
.67059 0 L
.67451 0 L
.67843 0 L
.68235 0 L
.68627 0 L
.6902 0 L
.69412 0 L
.69804 0 L
.70196 0 L
.70588 0 L
.7098 0 L
.71373 0 L
.71765 0 L
.72157 0 L
.72549 0 L
.72941 0 L
.73333 0 L
.73725 0 L
.74118 0 L
.7451 0 L
.74902 0 L
.75294 0 L
.75686 0 L
.76078 0 L
.76471 0 L
.76863 0 L
.77255 0 L
.77647 0 L
.78039 0 L
Mistroke
.78431 0 L
.78824 0 L
.79216 0 L
.79608 0 L
.8 0 L
.80392 0 L
.80784 0 L
.81176 0 L
.81569 0 L
.81961 0 L
.82353 0 L
.82745 0 L
.83137 0 L
.83529 0 L
.83922 0 L
.84314 0 L
.84706 0 L
.85098 0 L
.8549 0 L
.85882 0 L
.86275 0 L
.86667 0 L
.87059 0 L
.87451 0 L
.87843 0 L
.88235 0 L
.88627 0 L
.8902 0 L
.89412 0 L
.89804 0 L
.90196 0 L
.90588 0 L
.9098 0 L
.91373 0 L
.91765 0 L
.92157 0 L
.92549 0 L
.92941 0 L
.93333 0 L
.93725 0 L
.94118 0 L
.9451 0 L
.94902 0 L
.95294 0 L
.95686 0 L
.96078 0 L
.96471 0 L
.96863 0 L
.97255 0 L
.97647 0 L
Mistroke
.98039 0 L
.98431 0 L
.98824 0 L
.99216 0 L
.99608 0 L
1 0 L
Mfstroke
0 g
.0001 w
0 .61803 0 2.5 Mabsadd m
0 .61803 -0.56518 .7779 Mabsadd L
0 .61803 -2.37764 .77254 Mabsadd L
0 .61803 -0.91448 -0.29713 Mabsadd L
0 .61803 -1.46946 -2.02254 Mabsadd L
0 .61803 0 -0.96154 Mabsadd L
0 .61803 1.46946 -2.02254 Mabsadd L
0 .61803 .91448 -0.29713 Mabsadd L
0 .61803 2.37764 .77254 Mabsadd L
0 .61803 .56518 .7779 Mabsadd L
0 .61803 0 2.5 Mabsadd L closepath F
.00392 .61708 0 2.5 Mabsadd m
.00392 .61708 -0.56518 .7779 Mabsadd L
.00392 .61708 -2.37764 .77254 Mabsadd L
.00392 .61708 -0.91448 -0.29713 Mabsadd L
.00392 .61708 -1.46946 -2.02254 Mabsadd L
.00392 .61708 0 -0.96154 Mabsadd L
.00392 .61708 1.46946 -2.02254 Mabsadd L
.00392 .61708 .91448 -0.29713 Mabsadd L
.00392 .61708 2.37764 .77254 Mabsadd L
.00392 .61708 .56518 .7779 Mabsadd L
.00392 .61708 0 2.5 Mabsadd L closepath F
.00784 .61424 0 2.5 Mabsadd m
.00784 .61424 -0.56518 .7779 Mabsadd L
.00784 .61424 -2.37764 .77254 Mabsadd L
.00784 .61424 -0.91448 -0.29713 Mabsadd L
.00784 .61424 -1.46946 -2.02254 Mabsadd L
.00784 .61424 0 -0.96154 Mabsadd L
.00784 .61424 1.46946 -2.02254 Mabsadd L
.00784 .61424 .91448 -0.29713 Mabsadd L
.00784 .61424 2.37764 .77254 Mabsadd L
.00784 .61424 .56518 .7779 Mabsadd L
.00784 .61424 0 2.5 Mabsadd L closepath F
.01176 .60954 0 2.5 Mabsadd m
.01176 .60954 -0.56518 .7779 Mabsadd L
.01176 .60954 -2.37764 .77254 Mabsadd L
.01176 .60954 -0.91448 -0.29713 Mabsadd L
.01176 .60954 -1.46946 -2.02254 Mabsadd L
.01176 .60954 0 -0.96154 Mabsadd L
.01176 .60954 1.46946 -2.02254 Mabsadd L
.01176 .60954 .91448 -0.29713 Mabsadd L
.01176 .60954 2.37764 .77254 Mabsadd L
.01176 .60954 .56518 .7779 Mabsadd L
.01176 .60954 0 2.5 Mabsadd L closepath F
.01569 .60301 0 2.5 Mabsadd m
.01569 .60301 -0.56518 .7779 Mabsadd L
.01569 .60301 -2.37764 .77254 Mabsadd L
.01569 .60301 -0.91448 -0.29713 Mabsadd L
.01569 .60301 -1.46946 -2.02254 Mabsadd L
.01569 .60301 0 -0.96154 Mabsadd L
.01569 .60301 1.46946 -2.02254 Mabsadd L
.01569 .60301 .91448 -0.29713 Mabsadd L
.01569 .60301 2.37764 .77254 Mabsadd L
.01569 .60301 .56518 .7779 Mabsadd L
.01569 .60301 0 2.5 Mabsadd L closepath F
.01961 .59472 0 2.5 Mabsadd m
.01961 .59472 -0.56518 .7779 Mabsadd L
.01961 .59472 -2.37764 .77254 Mabsadd L
.01961 .59472 -0.91448 -0.29713 Mabsadd L
.01961 .59472 -1.46946 -2.02254 Mabsadd L
.01961 .59472 0 -0.96154 Mabsadd L
.01961 .59472 1.46946 -2.02254 Mabsadd L
.01961 .59472 .91448 -0.29713 Mabsadd L
.01961 .59472 2.37764 .77254 Mabsadd L
.01961 .59472 .56518 .7779 Mabsadd L
.01961 .59472 0 2.5 Mabsadd L closepath F
.02353 .58475 0 2.5 Mabsadd m
.02353 .58475 -0.56518 .7779 Mabsadd L
.02353 .58475 -2.37764 .77254 Mabsadd L
.02353 .58475 -0.91448 -0.29713 Mabsadd L
.02353 .58475 -1.46946 -2.02254 Mabsadd L
.02353 .58475 0 -0.96154 Mabsadd L
.02353 .58475 1.46946 -2.02254 Mabsadd L
.02353 .58475 .91448 -0.29713 Mabsadd L
.02353 .58475 2.37764 .77254 Mabsadd L
.02353 .58475 .56518 .7779 Mabsadd L
.02353 .58475 0 2.5 Mabsadd L closepath F
.02745 .57317 0 2.5 Mabsadd m
.02745 .57317 -0.56518 .7779 Mabsadd L
.02745 .57317 -2.37764 .77254 Mabsadd L
.02745 .57317 -0.91448 -0.29713 Mabsadd L
.02745 .57317 -1.46946 -2.02254 Mabsadd L
.02745 .57317 0 -0.96154 Mabsadd L
.02745 .57317 1.46946 -2.02254 Mabsadd L
.02745 .57317 .91448 -0.29713 Mabsadd L
.02745 .57317 2.37764 .77254 Mabsadd L
.02745 .57317 .56518 .7779 Mabsadd L
.02745 .57317 0 2.5 Mabsadd L closepath F
.03137 .5601 0 2.5 Mabsadd m
.03137 .5601 -0.56518 .7779 Mabsadd L
.03137 .5601 -2.37764 .77254 Mabsadd L
.03137 .5601 -0.91448 -0.29713 Mabsadd L
.03137 .5601 -1.46946 -2.02254 Mabsadd L
.03137 .5601 0 -0.96154 Mabsadd L
.03137 .5601 1.46946 -2.02254 Mabsadd L
.03137 .5601 .91448 -0.29713 Mabsadd L
.03137 .5601 2.37764 .77254 Mabsadd L
.03137 .5601 .56518 .7779 Mabsadd L
.03137 .5601 0 2.5 Mabsadd L closepath F
.03529 .54565 0 2.5 Mabsadd m
.03529 .54565 -0.56518 .7779 Mabsadd L
.03529 .54565 -2.37764 .77254 Mabsadd L
.03529 .54565 -0.91448 -0.29713 Mabsadd L
.03529 .54565 -1.46946 -2.02254 Mabsadd L
.03529 .54565 0 -0.96154 Mabsadd L
.03529 .54565 1.46946 -2.02254 Mabsadd L
.03529 .54565 .91448 -0.29713 Mabsadd L
.03529 .54565 2.37764 .77254 Mabsadd L
.03529 .54565 .56518 .7779 Mabsadd L
.03529 .54565 0 2.5 Mabsadd L closepath F
.03922 .52994 0 2.5 Mabsadd m
.03922 .52994 -0.56518 .7779 Mabsadd L
.03922 .52994 -2.37764 .77254 Mabsadd L
.03922 .52994 -0.91448 -0.29713 Mabsadd L
.03922 .52994 -1.46946 -2.02254 Mabsadd L
.03922 .52994 0 -0.96154 Mabsadd L
.03922 .52994 1.46946 -2.02254 Mabsadd L
.03922 .52994 .91448 -0.29713 Mabsadd L
.03922 .52994 2.37764 .77254 Mabsadd L
.03922 .52994 .56518 .7779 Mabsadd L
.03922 .52994 0 2.5 Mabsadd L closepath F
.04314 .5131 0 2.5 Mabsadd m
.04314 .5131 -0.56518 .7779 Mabsadd L
.04314 .5131 -2.37764 .77254 Mabsadd L
.04314 .5131 -0.91448 -0.29713 Mabsadd L
.04314 .5131 -1.46946 -2.02254 Mabsadd L
.04314 .5131 0 -0.96154 Mabsadd L
.04314 .5131 1.46946 -2.02254 Mabsadd L
.04314 .5131 .91448 -0.29713 Mabsadd L
.04314 .5131 2.37764 .77254 Mabsadd L
.04314 .5131 .56518 .7779 Mabsadd L
.04314 .5131 0 2.5 Mabsadd L closepath F
.04706 .49526 0 2.5 Mabsadd m
.04706 .49526 -0.56518 .7779 Mabsadd L
.04706 .49526 -2.37764 .77254 Mabsadd L
.04706 .49526 -0.91448 -0.29713 Mabsadd L
.04706 .49526 -1.46946 -2.02254 Mabsadd L
.04706 .49526 0 -0.96154 Mabsadd L
.04706 .49526 1.46946 -2.02254 Mabsadd L
.04706 .49526 .91448 -0.29713 Mabsadd L
.04706 .49526 2.37764 .77254 Mabsadd L
.04706 .49526 .56518 .7779 Mabsadd L
.04706 .49526 0 2.5 Mabsadd L closepath F
.05098 .47658 0 2.5 Mabsadd m
.05098 .47658 -0.56518 .7779 Mabsadd L
.05098 .47658 -2.37764 .77254 Mabsadd L
.05098 .47658 -0.91448 -0.29713 Mabsadd L
.05098 .47658 -1.46946 -2.02254 Mabsadd L
.05098 .47658 0 -0.96154 Mabsadd L
.05098 .47658 1.46946 -2.02254 Mabsadd L
.05098 .47658 .91448 -0.29713 Mabsadd L
.05098 .47658 2.37764 .77254 Mabsadd L
.05098 .47658 .56518 .7779 Mabsadd L
.05098 .47658 0 2.5 Mabsadd L closepath F
.0549 .4572 0 2.5 Mabsadd m
.0549 .4572 -0.56518 .7779 Mabsadd L
.0549 .4572 -2.37764 .77254 Mabsadd L
.0549 .4572 -0.91448 -0.29713 Mabsadd L
.0549 .4572 -1.46946 -2.02254 Mabsadd L
.0549 .4572 0 -0.96154 Mabsadd L
.0549 .4572 1.46946 -2.02254 Mabsadd L
.0549 .4572 .91448 -0.29713 Mabsadd L
.0549 .4572 2.37764 .77254 Mabsadd L
.0549 .4572 .56518 .7779 Mabsadd L
.0549 .4572 0 2.5 Mabsadd L closepath F
.05882 .43726 0 2.5 Mabsadd m
.05882 .43726 -0.56518 .7779 Mabsadd L
.05882 .43726 -2.37764 .77254 Mabsadd L
.05882 .43726 -0.91448 -0.29713 Mabsadd L
.05882 .43726 -1.46946 -2.02254 Mabsadd L
.05882 .43726 0 -0.96154 Mabsadd L
.05882 .43726 1.46946 -2.02254 Mabsadd L
.05882 .43726 .91448 -0.29713 Mabsadd L
.05882 .43726 2.37764 .77254 Mabsadd L
.05882 .43726 .56518 .7779 Mabsadd L
.05882 .43726 0 2.5 Mabsadd L closepath F
.06275 .4169 0 2.5 Mabsadd m
.06275 .4169 -0.56518 .7779 Mabsadd L
.06275 .4169 -2.37764 .77254 Mabsadd L
.06275 .4169 -0.91448 -0.29713 Mabsadd L
.06275 .4169 -1.46946 -2.02254 Mabsadd L
.06275 .4169 0 -0.96154 Mabsadd L
.06275 .4169 1.46946 -2.02254 Mabsadd L
.06275 .4169 .91448 -0.29713 Mabsadd L
.06275 .4169 2.37764 .77254 Mabsadd L
.06275 .4169 .56518 .7779 Mabsadd L
.06275 .4169 0 2.5 Mabsadd L closepath F
.06667 .39627 0 2.5 Mabsadd m
.06667 .39627 -0.56518 .7779 Mabsadd L
.06667 .39627 -2.37764 .77254 Mabsadd L
.06667 .39627 -0.91448 -0.29713 Mabsadd L
.06667 .39627 -1.46946 -2.02254 Mabsadd L
.06667 .39627 0 -0.96154 Mabsadd L
.06667 .39627 1.46946 -2.02254 Mabsadd L
.06667 .39627 .91448 -0.29713 Mabsadd L
.06667 .39627 2.37764 .77254 Mabsadd L
.06667 .39627 .56518 .7779 Mabsadd L
.06667 .39627 0 2.5 Mabsadd L closepath F
.07059 .37551 0 2.5 Mabsadd m
.07059 .37551 -0.56518 .7779 Mabsadd L
.07059 .37551 -2.37764 .77254 Mabsadd L
.07059 .37551 -0.91448 -0.29713 Mabsadd L
.07059 .37551 -1.46946 -2.02254 Mabsadd L
.07059 .37551 0 -0.96154 Mabsadd L
.07059 .37551 1.46946 -2.02254 Mabsadd L
.07059 .37551 .91448 -0.29713 Mabsadd L
.07059 .37551 2.37764 .77254 Mabsadd L
.07059 .37551 .56518 .7779 Mabsadd L
.07059 .37551 0 2.5 Mabsadd L closepath F
.07451 .35474 0 2.5 Mabsadd m
.07451 .35474 -0.56518 .7779 Mabsadd L
.07451 .35474 -2.37764 .77254 Mabsadd L
.07451 .35474 -0.91448 -0.29713 Mabsadd L
.07451 .35474 -1.46946 -2.02254 Mabsadd L
.07451 .35474 0 -0.96154 Mabsadd L
.07451 .35474 1.46946 -2.02254 Mabsadd L
.07451 .35474 .91448 -0.29713 Mabsadd L
.07451 .35474 2.37764 .77254 Mabsadd L
.07451 .35474 .56518 .7779 Mabsadd L
.07451 .35474 0 2.5 Mabsadd L closepath F
.07843 .33408 0 2.5 Mabsadd m
.07843 .33408 -0.56518 .7779 Mabsadd L
.07843 .33408 -2.37764 .77254 Mabsadd L
.07843 .33408 -0.91448 -0.29713 Mabsadd L
.07843 .33408 -1.46946 -2.02254 Mabsadd L
.07843 .33408 0 -0.96154 Mabsadd L
.07843 .33408 1.46946 -2.02254 Mabsadd L
.07843 .33408 .91448 -0.29713 Mabsadd L
.07843 .33408 2.37764 .77254 Mabsadd L
.07843 .33408 .56518 .7779 Mabsadd L
.07843 .33408 0 2.5 Mabsadd L closepath F
.08235 .31367 0 2.5 Mabsadd m
.08235 .31367 -0.56518 .7779 Mabsadd L
.08235 .31367 -2.37764 .77254 Mabsadd L
.08235 .31367 -0.91448 -0.29713 Mabsadd L
.08235 .31367 -1.46946 -2.02254 Mabsadd L
.08235 .31367 0 -0.96154 Mabsadd L
.08235 .31367 1.46946 -2.02254 Mabsadd L
.08235 .31367 .91448 -0.29713 Mabsadd L
.08235 .31367 2.37764 .77254 Mabsadd L
.08235 .31367 .56518 .7779 Mabsadd L
.08235 .31367 0 2.5 Mabsadd L closepath F
.08627 .2936 0 2.5 Mabsadd m
.08627 .2936 -0.56518 .7779 Mabsadd L
.08627 .2936 -2.37764 .77254 Mabsadd L
.08627 .2936 -0.91448 -0.29713 Mabsadd L
.08627 .2936 -1.46946 -2.02254 Mabsadd L
.08627 .2936 0 -0.96154 Mabsadd L
.08627 .2936 1.46946 -2.02254 Mabsadd L
.08627 .2936 .91448 -0.29713 Mabsadd L
.08627 .2936 2.37764 .77254 Mabsadd L
.08627 .2936 .56518 .7779 Mabsadd L
.08627 .2936 0 2.5 Mabsadd L closepath F
.0902 .27397 0 2.5 Mabsadd m
.0902 .27397 -0.56518 .7779 Mabsadd L
.0902 .27397 -2.37764 .77254 Mabsadd L
.0902 .27397 -0.91448 -0.29713 Mabsadd L
.0902 .27397 -1.46946 -2.02254 Mabsadd L
.0902 .27397 0 -0.96154 Mabsadd L
.0902 .27397 1.46946 -2.02254 Mabsadd L
.0902 .27397 .91448 -0.29713 Mabsadd L
.0902 .27397 2.37764 .77254 Mabsadd L
.0902 .27397 .56518 .7779 Mabsadd L
.0902 .27397 0 2.5 Mabsadd L closepath F
.09412 .25486 0 2.5 Mabsadd m
.09412 .25486 -0.56518 .7779 Mabsadd L
.09412 .25486 -2.37764 .77254 Mabsadd L
.09412 .25486 -0.91448 -0.29713 Mabsadd L
.09412 .25486 -1.46946 -2.02254 Mabsadd L
.09412 .25486 0 -0.96154 Mabsadd L
.09412 .25486 1.46946 -2.02254 Mabsadd L
.09412 .25486 .91448 -0.29713 Mabsadd L
.09412 .25486 2.37764 .77254 Mabsadd L
.09412 .25486 .56518 .7779 Mabsadd L
.09412 .25486 0 2.5 Mabsadd L closepath F
.09804 .23636 0 2.5 Mabsadd m
.09804 .23636 -0.56518 .7779 Mabsadd L
.09804 .23636 -2.37764 .77254 Mabsadd L
.09804 .23636 -0.91448 -0.29713 Mabsadd L
.09804 .23636 -1.46946 -2.02254 Mabsadd L
.09804 .23636 0 -0.96154 Mabsadd L
.09804 .23636 1.46946 -2.02254 Mabsadd L
.09804 .23636 .91448 -0.29713 Mabsadd L
.09804 .23636 2.37764 .77254 Mabsadd L
.09804 .23636 .56518 .7779 Mabsadd L
.09804 .23636 0 2.5 Mabsadd L closepath F
.10196 .21853 0 2.5 Mabsadd m
.10196 .21853 -0.56518 .7779 Mabsadd L
.10196 .21853 -2.37764 .77254 Mabsadd L
.10196 .21853 -0.91448 -0.29713 Mabsadd L
.10196 .21853 -1.46946 -2.02254 Mabsadd L
.10196 .21853 0 -0.96154 Mabsadd L
.10196 .21853 1.46946 -2.02254 Mabsadd L
.10196 .21853 .91448 -0.29713 Mabsadd L
.10196 .21853 2.37764 .77254 Mabsadd L
.10196 .21853 .56518 .7779 Mabsadd L
.10196 .21853 0 2.5 Mabsadd L closepath F
.10588 .20143 0 2.5 Mabsadd m
.10588 .20143 -0.56518 .7779 Mabsadd L
.10588 .20143 -2.37764 .77254 Mabsadd L
.10588 .20143 -0.91448 -0.29713 Mabsadd L
.10588 .20143 -1.46946 -2.02254 Mabsadd L
.10588 .20143 0 -0.96154 Mabsadd L
.10588 .20143 1.46946 -2.02254 Mabsadd L
.10588 .20143 .91448 -0.29713 Mabsadd L
.10588 .20143 2.37764 .77254 Mabsadd L
.10588 .20143 .56518 .7779 Mabsadd L
.10588 .20143 0 2.5 Mabsadd L closepath F
.1098 .18509 0 2.5 Mabsadd m
.1098 .18509 -0.56518 .7779 Mabsadd L
.1098 .18509 -2.37764 .77254 Mabsadd L
.1098 .18509 -0.91448 -0.29713 Mabsadd L
.1098 .18509 -1.46946 -2.02254 Mabsadd L
.1098 .18509 0 -0.96154 Mabsadd L
.1098 .18509 1.46946 -2.02254 Mabsadd L
.1098 .18509 .91448 -0.29713 Mabsadd L
.1098 .18509 2.37764 .77254 Mabsadd L
.1098 .18509 .56518 .7779 Mabsadd L
.1098 .18509 0 2.5 Mabsadd L closepath F
.11373 .16956 0 2.5 Mabsadd m
.11373 .16956 -0.56518 .7779 Mabsadd L
.11373 .16956 -2.37764 .77254 Mabsadd L
.11373 .16956 -0.91448 -0.29713 Mabsadd L
.11373 .16956 -1.46946 -2.02254 Mabsadd L
.11373 .16956 0 -0.96154 Mabsadd L
.11373 .16956 1.46946 -2.02254 Mabsadd L
.11373 .16956 .91448 -0.29713 Mabsadd L
.11373 .16956 2.37764 .77254 Mabsadd L
.11373 .16956 .56518 .7779 Mabsadd L
.11373 .16956 0 2.5 Mabsadd L closepath F
.11765 .15485 0 2.5 Mabsadd m
.11765 .15485 -0.56518 .7779 Mabsadd L
.11765 .15485 -2.37764 .77254 Mabsadd L
.11765 .15485 -0.91448 -0.29713 Mabsadd L
.11765 .15485 -1.46946 -2.02254 Mabsadd L
.11765 .15485 0 -0.96154 Mabsadd L
.11765 .15485 1.46946 -2.02254 Mabsadd L
.11765 .15485 .91448 -0.29713 Mabsadd L
.11765 .15485 2.37764 .77254 Mabsadd L
.11765 .15485 .56518 .7779 Mabsadd L
.11765 .15485 0 2.5 Mabsadd L closepath F
.12157 .14098 0 2.5 Mabsadd m
.12157 .14098 -0.56518 .7779 Mabsadd L
.12157 .14098 -2.37764 .77254 Mabsadd L
.12157 .14098 -0.91448 -0.29713 Mabsadd L
.12157 .14098 -1.46946 -2.02254 Mabsadd L
.12157 .14098 0 -0.96154 Mabsadd L
.12157 .14098 1.46946 -2.02254 Mabsadd L
.12157 .14098 .91448 -0.29713 Mabsadd L
.12157 .14098 2.37764 .77254 Mabsadd L
.12157 .14098 .56518 .7779 Mabsadd L
.12157 .14098 0 2.5 Mabsadd L closepath F
.12549 .12797 0 2.5 Mabsadd m
.12549 .12797 -0.56518 .7779 Mabsadd L
.12549 .12797 -2.37764 .77254 Mabsadd L
.12549 .12797 -0.91448 -0.29713 Mabsadd L
.12549 .12797 -1.46946 -2.02254 Mabsadd L
.12549 .12797 0 -0.96154 Mabsadd L
.12549 .12797 1.46946 -2.02254 Mabsadd L
.12549 .12797 .91448 -0.29713 Mabsadd L
.12549 .12797 2.37764 .77254 Mabsadd L
.12549 .12797 .56518 .7779 Mabsadd L
.12549 .12797 0 2.5 Mabsadd L closepath F
.12941 .11579 0 2.5 Mabsadd m
.12941 .11579 -0.56518 .7779 Mabsadd L
.12941 .11579 -2.37764 .77254 Mabsadd L
.12941 .11579 -0.91448 -0.29713 Mabsadd L
.12941 .11579 -1.46946 -2.02254 Mabsadd L
.12941 .11579 0 -0.96154 Mabsadd L
.12941 .11579 1.46946 -2.02254 Mabsadd L
.12941 .11579 .91448 -0.29713 Mabsadd L
.12941 .11579 2.37764 .77254 Mabsadd L
.12941 .11579 .56518 .7779 Mabsadd L
.12941 .11579 0 2.5 Mabsadd L closepath F
.13333 .10446 0 2.5 Mabsadd m
.13333 .10446 -0.56518 .7779 Mabsadd L
.13333 .10446 -2.37764 .77254 Mabsadd L
.13333 .10446 -0.91448 -0.29713 Mabsadd L
.13333 .10446 -1.46946 -2.02254 Mabsadd L
.13333 .10446 0 -0.96154 Mabsadd L
.13333 .10446 1.46946 -2.02254 Mabsadd L
.13333 .10446 .91448 -0.29713 Mabsadd L
.13333 .10446 2.37764 .77254 Mabsadd L
.13333 .10446 .56518 .7779 Mabsadd L
.13333 .10446 0 2.5 Mabsadd L closepath F
.13725 .09394 0 2.5 Mabsadd m
.13725 .09394 -0.56518 .7779 Mabsadd L
.13725 .09394 -2.37764 .77254 Mabsadd L
.13725 .09394 -0.91448 -0.29713 Mabsadd L
.13725 .09394 -1.46946 -2.02254 Mabsadd L
.13725 .09394 0 -0.96154 Mabsadd L
.13725 .09394 1.46946 -2.02254 Mabsadd L
.13725 .09394 .91448 -0.29713 Mabsadd L
.13725 .09394 2.37764 .77254 Mabsadd L
.13725 .09394 .56518 .7779 Mabsadd L
.13725 .09394 0 2.5 Mabsadd L closepath F
.14118 .08422 0 2.5 Mabsadd m
.14118 .08422 -0.56518 .7779 Mabsadd L
.14118 .08422 -2.37764 .77254 Mabsadd L
.14118 .08422 -0.91448 -0.29713 Mabsadd L
.14118 .08422 -1.46946 -2.02254 Mabsadd L
.14118 .08422 0 -0.96154 Mabsadd L
.14118 .08422 1.46946 -2.02254 Mabsadd L
.14118 .08422 .91448 -0.29713 Mabsadd L
.14118 .08422 2.37764 .77254 Mabsadd L
.14118 .08422 .56518 .7779 Mabsadd L
.14118 .08422 0 2.5 Mabsadd L closepath F
.1451 .07528 0 2.5 Mabsadd m
.1451 .07528 -0.56518 .7779 Mabsadd L
.1451 .07528 -2.37764 .77254 Mabsadd L
.1451 .07528 -0.91448 -0.29713 Mabsadd L
.1451 .07528 -1.46946 -2.02254 Mabsadd L
.1451 .07528 0 -0.96154 Mabsadd L
.1451 .07528 1.46946 -2.02254 Mabsadd L
.1451 .07528 .91448 -0.29713 Mabsadd L
.1451 .07528 2.37764 .77254 Mabsadd L
.1451 .07528 .56518 .7779 Mabsadd L
.1451 .07528 0 2.5 Mabsadd L closepath F
.14902 .06708 0 2.5 Mabsadd m
.14902 .06708 -0.56518 .7779 Mabsadd L
.14902 .06708 -2.37764 .77254 Mabsadd L
.14902 .06708 -0.91448 -0.29713 Mabsadd L
.14902 .06708 -1.46946 -2.02254 Mabsadd L
.14902 .06708 0 -0.96154 Mabsadd L
.14902 .06708 1.46946 -2.02254 Mabsadd L
.14902 .06708 .91448 -0.29713 Mabsadd L
.14902 .06708 2.37764 .77254 Mabsadd L
.14902 .06708 .56518 .7779 Mabsadd L
.14902 .06708 0 2.5 Mabsadd L closepath F
.15294 .05959 0 2.5 Mabsadd m
.15294 .05959 -0.56518 .7779 Mabsadd L
.15294 .05959 -2.37764 .77254 Mabsadd L
.15294 .05959 -0.91448 -0.29713 Mabsadd L
.15294 .05959 -1.46946 -2.02254 Mabsadd L
.15294 .05959 0 -0.96154 Mabsadd L
.15294 .05959 1.46946 -2.02254 Mabsadd L
.15294 .05959 .91448 -0.29713 Mabsadd L
.15294 .05959 2.37764 .77254 Mabsadd L
.15294 .05959 .56518 .7779 Mabsadd L
.15294 .05959 0 2.5 Mabsadd L closepath F
.15686 .05277 0 2.5 Mabsadd m
.15686 .05277 -0.56518 .7779 Mabsadd L
.15686 .05277 -2.37764 .77254 Mabsadd L
.15686 .05277 -0.91448 -0.29713 Mabsadd L
.15686 .05277 -1.46946 -2.02254 Mabsadd L
.15686 .05277 0 -0.96154 Mabsadd L
.15686 .05277 1.46946 -2.02254 Mabsadd L
.15686 .05277 .91448 -0.29713 Mabsadd L
.15686 .05277 2.37764 .77254 Mabsadd L
.15686 .05277 .56518 .7779 Mabsadd L
.15686 .05277 0 2.5 Mabsadd L closepath F
.16078 .04659 0 2.5 Mabsadd m
.16078 .04659 -0.56518 .7779 Mabsadd L
.16078 .04659 -2.37764 .77254 Mabsadd L
.16078 .04659 -0.91448 -0.29713 Mabsadd L
.16078 .04659 -1.46946 -2.02254 Mabsadd L
.16078 .04659 0 -0.96154 Mabsadd L
.16078 .04659 1.46946 -2.02254 Mabsadd L
.16078 .04659 .91448 -0.29713 Mabsadd L
.16078 .04659 2.37764 .77254 Mabsadd L
.16078 .04659 .56518 .7779 Mabsadd L
.16078 .04659 0 2.5 Mabsadd L closepath F
.16471 .04101 0 2.5 Mabsadd m
.16471 .04101 -0.56518 .7779 Mabsadd L
.16471 .04101 -2.37764 .77254 Mabsadd L
.16471 .04101 -0.91448 -0.29713 Mabsadd L
.16471 .04101 -1.46946 -2.02254 Mabsadd L
.16471 .04101 0 -0.96154 Mabsadd L
.16471 .04101 1.46946 -2.02254 Mabsadd L
.16471 .04101 .91448 -0.29713 Mabsadd L
.16471 .04101 2.37764 .77254 Mabsadd L
.16471 .04101 .56518 .7779 Mabsadd L
.16471 .04101 0 2.5 Mabsadd L closepath F
.16863 .03598 0 2.5 Mabsadd m
.16863 .03598 -0.56518 .7779 Mabsadd L
.16863 .03598 -2.37764 .77254 Mabsadd L
.16863 .03598 -0.91448 -0.29713 Mabsadd L
.16863 .03598 -1.46946 -2.02254 Mabsadd L
.16863 .03598 0 -0.96154 Mabsadd L
.16863 .03598 1.46946 -2.02254 Mabsadd L
.16863 .03598 .91448 -0.29713 Mabsadd L
.16863 .03598 2.37764 .77254 Mabsadd L
.16863 .03598 .56518 .7779 Mabsadd L
.16863 .03598 0 2.5 Mabsadd L closepath F
.17255 .03148 0 2.5 Mabsadd m
.17255 .03148 -0.56518 .7779 Mabsadd L
.17255 .03148 -2.37764 .77254 Mabsadd L
.17255 .03148 -0.91448 -0.29713 Mabsadd L
.17255 .03148 -1.46946 -2.02254 Mabsadd L
.17255 .03148 0 -0.96154 Mabsadd L
.17255 .03148 1.46946 -2.02254 Mabsadd L
.17255 .03148 .91448 -0.29713 Mabsadd L
.17255 .03148 2.37764 .77254 Mabsadd L
.17255 .03148 .56518 .7779 Mabsadd L
.17255 .03148 0 2.5 Mabsadd L closepath F
.17647 .02745 0 2.5 Mabsadd m
.17647 .02745 -0.56518 .7779 Mabsadd L
.17647 .02745 -2.37764 .77254 Mabsadd L
.17647 .02745 -0.91448 -0.29713 Mabsadd L
.17647 .02745 -1.46946 -2.02254 Mabsadd L
.17647 .02745 0 -0.96154 Mabsadd L
.17647 .02745 1.46946 -2.02254 Mabsadd L
.17647 .02745 .91448 -0.29713 Mabsadd L
.17647 .02745 2.37764 .77254 Mabsadd L
.17647 .02745 .56518 .7779 Mabsadd L
.17647 .02745 0 2.5 Mabsadd L closepath F
.18039 .02386 0 2.5 Mabsadd m
.18039 .02386 -0.56518 .7779 Mabsadd L
.18039 .02386 -2.37764 .77254 Mabsadd L
.18039 .02386 -0.91448 -0.29713 Mabsadd L
.18039 .02386 -1.46946 -2.02254 Mabsadd L
.18039 .02386 0 -0.96154 Mabsadd L
.18039 .02386 1.46946 -2.02254 Mabsadd L
.18039 .02386 .91448 -0.29713 Mabsadd L
.18039 .02386 2.37764 .77254 Mabsadd L
.18039 .02386 .56518 .7779 Mabsadd L
.18039 .02386 0 2.5 Mabsadd L closepath F
.18431 .02068 0 2.5 Mabsadd m
.18431 .02068 -0.56518 .7779 Mabsadd L
.18431 .02068 -2.37764 .77254 Mabsadd L
.18431 .02068 -0.91448 -0.29713 Mabsadd L
.18431 .02068 -1.46946 -2.02254 Mabsadd L
.18431 .02068 0 -0.96154 Mabsadd L
.18431 .02068 1.46946 -2.02254 Mabsadd L
.18431 .02068 .91448 -0.29713 Mabsadd L
.18431 .02068 2.37764 .77254 Mabsadd L
.18431 .02068 .56518 .7779 Mabsadd L
.18431 .02068 0 2.5 Mabsadd L closepath F
.18824 .01787 0 2.5 Mabsadd m
.18824 .01787 -0.56518 .7779 Mabsadd L
.18824 .01787 -2.37764 .77254 Mabsadd L
.18824 .01787 -0.91448 -0.29713 Mabsadd L
.18824 .01787 -1.46946 -2.02254 Mabsadd L
.18824 .01787 0 -0.96154 Mabsadd L
.18824 .01787 1.46946 -2.02254 Mabsadd L
.18824 .01787 .91448 -0.29713 Mabsadd L
.18824 .01787 2.37764 .77254 Mabsadd L
.18824 .01787 .56518 .7779 Mabsadd L
.18824 .01787 0 2.5 Mabsadd L closepath F
.19216 .0154 0 2.5 Mabsadd m
.19216 .0154 -0.56518 .7779 Mabsadd L
.19216 .0154 -2.37764 .77254 Mabsadd L
.19216 .0154 -0.91448 -0.29713 Mabsadd L
.19216 .0154 -1.46946 -2.02254 Mabsadd L
.19216 .0154 0 -0.96154 Mabsadd L
.19216 .0154 1.46946 -2.02254 Mabsadd L
.19216 .0154 .91448 -0.29713 Mabsadd L
.19216 .0154 2.37764 .77254 Mabsadd L
.19216 .0154 .56518 .7779 Mabsadd L
.19216 .0154 0 2.5 Mabsadd L closepath F
.19608 .01322 0 2.5 Mabsadd m
.19608 .01322 -0.56518 .7779 Mabsadd L
.19608 .01322 -2.37764 .77254 Mabsadd L
.19608 .01322 -0.91448 -0.29713 Mabsadd L
.19608 .01322 -1.46946 -2.02254 Mabsadd L
.19608 .01322 0 -0.96154 Mabsadd L
.19608 .01322 1.46946 -2.02254 Mabsadd L
.19608 .01322 .91448 -0.29713 Mabsadd L
.19608 .01322 2.37764 .77254 Mabsadd L
.19608 .01322 .56518 .7779 Mabsadd L
.19608 .01322 0 2.5 Mabsadd L closepath F
.2 .01132 0 2.5 Mabsadd m
.2 .01132 -0.56518 .7779 Mabsadd L
.2 .01132 -2.37764 .77254 Mabsadd L
.2 .01132 -0.91448 -0.29713 Mabsadd L
.2 .01132 -1.46946 -2.02254 Mabsadd L
.2 .01132 0 -0.96154 Mabsadd L
.2 .01132 1.46946 -2.02254 Mabsadd L
.2 .01132 .91448 -0.29713 Mabsadd L
.2 .01132 2.37764 .77254 Mabsadd L
.2 .01132 .56518 .7779 Mabsadd L
.2 .01132 0 2.5 Mabsadd L closepath F
.20392 .00966 0 2.5 Mabsadd m
.20392 .00966 -0.56518 .7779 Mabsadd L
.20392 .00966 -2.37764 .77254 Mabsadd L
.20392 .00966 -0.91448 -0.29713 Mabsadd L
.20392 .00966 -1.46946 -2.02254 Mabsadd L
.20392 .00966 0 -0.96154 Mabsadd L
.20392 .00966 1.46946 -2.02254 Mabsadd L
.20392 .00966 .91448 -0.29713 Mabsadd L
.20392 .00966 2.37764 .77254 Mabsadd L
.20392 .00966 .56518 .7779 Mabsadd L
.20392 .00966 0 2.5 Mabsadd L closepath F
.20784 .00822 0 2.5 Mabsadd m
.20784 .00822 -0.56518 .7779 Mabsadd L
.20784 .00822 -2.37764 .77254 Mabsadd L
.20784 .00822 -0.91448 -0.29713 Mabsadd L
.20784 .00822 -1.46946 -2.02254 Mabsadd L
.20784 .00822 0 -0.96154 Mabsadd L
.20784 .00822 1.46946 -2.02254 Mabsadd L
.20784 .00822 .91448 -0.29713 Mabsadd L
.20784 .00822 2.37764 .77254 Mabsadd L
.20784 .00822 .56518 .7779 Mabsadd L
.20784 .00822 0 2.5 Mabsadd L closepath F
.21176 .00697 0 2.5 Mabsadd m
.21176 .00697 -0.56518 .7779 Mabsadd L
.21176 .00697 -2.37764 .77254 Mabsadd L
.21176 .00697 -0.91448 -0.29713 Mabsadd L
.21176 .00697 -1.46946 -2.02254 Mabsadd L
.21176 .00697 0 -0.96154 Mabsadd L
.21176 .00697 1.46946 -2.02254 Mabsadd L
.21176 .00697 .91448 -0.29713 Mabsadd L
.21176 .00697 2.37764 .77254 Mabsadd L
.21176 .00697 .56518 .7779 Mabsadd L
.21176 .00697 0 2.5 Mabsadd L closepath F
.21569 .0059 0 2.5 Mabsadd m
.21569 .0059 -0.56518 .7779 Mabsadd L
.21569 .0059 -2.37764 .77254 Mabsadd L
.21569 .0059 -0.91448 -0.29713 Mabsadd L
.21569 .0059 -1.46946 -2.02254 Mabsadd L
.21569 .0059 0 -0.96154 Mabsadd L
.21569 .0059 1.46946 -2.02254 Mabsadd L
.21569 .0059 .91448 -0.29713 Mabsadd L
.21569 .0059 2.37764 .77254 Mabsadd L
.21569 .0059 .56518 .7779 Mabsadd L
.21569 .0059 0 2.5 Mabsadd L closepath F
.21961 .00497 0 2.5 Mabsadd m
.21961 .00497 -0.56518 .7779 Mabsadd L
.21961 .00497 -2.37764 .77254 Mabsadd L
.21961 .00497 -0.91448 -0.29713 Mabsadd L
.21961 .00497 -1.46946 -2.02254 Mabsadd L
.21961 .00497 0 -0.96154 Mabsadd L
.21961 .00497 1.46946 -2.02254 Mabsadd L
.21961 .00497 .91448 -0.29713 Mabsadd L
.21961 .00497 2.37764 .77254 Mabsadd L
.21961 .00497 .56518 .7779 Mabsadd L
.21961 .00497 0 2.5 Mabsadd L closepath F
.22353 .00418 0 2.5 Mabsadd m
.22353 .00418 -0.56518 .7779 Mabsadd L
.22353 .00418 -2.37764 .77254 Mabsadd L
.22353 .00418 -0.91448 -0.29713 Mabsadd L
.22353 .00418 -1.46946 -2.02254 Mabsadd L
.22353 .00418 0 -0.96154 Mabsadd L
.22353 .00418 1.46946 -2.02254 Mabsadd L
.22353 .00418 .91448 -0.29713 Mabsadd L
.22353 .00418 2.37764 .77254 Mabsadd L
.22353 .00418 .56518 .7779 Mabsadd L
.22353 .00418 0 2.5 Mabsadd L closepath F
.22745 .0035 0 2.5 Mabsadd m
.22745 .0035 -0.56518 .7779 Mabsadd L
.22745 .0035 -2.37764 .77254 Mabsadd L
.22745 .0035 -0.91448 -0.29713 Mabsadd L
.22745 .0035 -1.46946 -2.02254 Mabsadd L
.22745 .0035 0 -0.96154 Mabsadd L
.22745 .0035 1.46946 -2.02254 Mabsadd L
.22745 .0035 .91448 -0.29713 Mabsadd L
.22745 .0035 2.37764 .77254 Mabsadd L
.22745 .0035 .56518 .7779 Mabsadd L
.22745 .0035 0 2.5 Mabsadd L closepath F
.23137 .00292 0 2.5 Mabsadd m
.23137 .00292 -0.56518 .7779 Mabsadd L
.23137 .00292 -2.37764 .77254 Mabsadd L
.23137 .00292 -0.91448 -0.29713 Mabsadd L
.23137 .00292 -1.46946 -2.02254 Mabsadd L
.23137 .00292 0 -0.96154 Mabsadd L
.23137 .00292 1.46946 -2.02254 Mabsadd L
.23137 .00292 .91448 -0.29713 Mabsadd L
.23137 .00292 2.37764 .77254 Mabsadd L
.23137 .00292 .56518 .7779 Mabsadd L
.23137 .00292 0 2.5 Mabsadd L closepath F
.23529 .00244 0 2.5 Mabsadd m
.23529 .00244 -0.56518 .7779 Mabsadd L
.23529 .00244 -2.37764 .77254 Mabsadd L
.23529 .00244 -0.91448 -0.29713 Mabsadd L
.23529 .00244 -1.46946 -2.02254 Mabsadd L
.23529 .00244 0 -0.96154 Mabsadd L
.23529 .00244 1.46946 -2.02254 Mabsadd L
.23529 .00244 .91448 -0.29713 Mabsadd L
.23529 .00244 2.37764 .77254 Mabsadd L
.23529 .00244 .56518 .7779 Mabsadd L
.23529 .00244 0 2.5 Mabsadd L closepath F
.23922 .00202 0 2.5 Mabsadd m
.23922 .00202 -0.56518 .7779 Mabsadd L
.23922 .00202 -2.37764 .77254 Mabsadd L
.23922 .00202 -0.91448 -0.29713 Mabsadd L
.23922 .00202 -1.46946 -2.02254 Mabsadd L
.23922 .00202 0 -0.96154 Mabsadd L
.23922 .00202 1.46946 -2.02254 Mabsadd L
.23922 .00202 .91448 -0.29713 Mabsadd L
.23922 .00202 2.37764 .77254 Mabsadd L
.23922 .00202 .56518 .7779 Mabsadd L
.23922 .00202 0 2.5 Mabsadd L closepath F
.24314 .00167 0 2.5 Mabsadd m
.24314 .00167 -0.56518 .7779 Mabsadd L
.24314 .00167 -2.37764 .77254 Mabsadd L
.24314 .00167 -0.91448 -0.29713 Mabsadd L
.24314 .00167 -1.46946 -2.02254 Mabsadd L
.24314 .00167 0 -0.96154 Mabsadd L
.24314 .00167 1.46946 -2.02254 Mabsadd L
.24314 .00167 .91448 -0.29713 Mabsadd L
.24314 .00167 2.37764 .77254 Mabsadd L
.24314 .00167 .56518 .7779 Mabsadd L
.24314 .00167 0 2.5 Mabsadd L closepath F
.24706 .00138 0 2.5 Mabsadd m
.24706 .00138 -0.56518 .7779 Mabsadd L
.24706 .00138 -2.37764 .77254 Mabsadd L
.24706 .00138 -0.91448 -0.29713 Mabsadd L
.24706 .00138 -1.46946 -2.02254 Mabsadd L
.24706 .00138 0 -0.96154 Mabsadd L
.24706 .00138 1.46946 -2.02254 Mabsadd L
.24706 .00138 .91448 -0.29713 Mabsadd L
.24706 .00138 2.37764 .77254 Mabsadd L
.24706 .00138 .56518 .7779 Mabsadd L
.24706 .00138 0 2.5 Mabsadd L closepath F
.25098 .00114 0 2.5 Mabsadd m
.25098 .00114 -0.56518 .7779 Mabsadd L
.25098 .00114 -2.37764 .77254 Mabsadd L
.25098 .00114 -0.91448 -0.29713 Mabsadd L
.25098 .00114 -1.46946 -2.02254 Mabsadd L
.25098 .00114 0 -0.96154 Mabsadd L
.25098 .00114 1.46946 -2.02254 Mabsadd L
.25098 .00114 .91448 -0.29713 Mabsadd L
.25098 .00114 2.37764 .77254 Mabsadd L
.25098 .00114 .56518 .7779 Mabsadd L
.25098 .00114 0 2.5 Mabsadd L closepath F
.2549 .00093 0 2.5 Mabsadd m
.2549 .00093 -0.56518 .7779 Mabsadd L
.2549 .00093 -2.37764 .77254 Mabsadd L
.2549 .00093 -0.91448 -0.29713 Mabsadd L
.2549 .00093 -1.46946 -2.02254 Mabsadd L
.2549 .00093 0 -0.96154 Mabsadd L
.2549 .00093 1.46946 -2.02254 Mabsadd L
.2549 .00093 .91448 -0.29713 Mabsadd L
.2549 .00093 2.37764 .77254 Mabsadd L
.2549 .00093 .56518 .7779 Mabsadd L
.2549 .00093 0 2.5 Mabsadd L closepath F
.25882 .00076 0 2.5 Mabsadd m
.25882 .00076 -0.56518 .7779 Mabsadd L
.25882 .00076 -2.37764 .77254 Mabsadd L
.25882 .00076 -0.91448 -0.29713 Mabsadd L
.25882 .00076 -1.46946 -2.02254 Mabsadd L
.25882 .00076 0 -0.96154 Mabsadd L
.25882 .00076 1.46946 -2.02254 Mabsadd L
.25882 .00076 .91448 -0.29713 Mabsadd L
.25882 .00076 2.37764 .77254 Mabsadd L
.25882 .00076 .56518 .7779 Mabsadd L
.25882 .00076 0 2.5 Mabsadd L closepath F
.26275 .00062 0 2.5 Mabsadd m
.26275 .00062 -0.56518 .7779 Mabsadd L
.26275 .00062 -2.37764 .77254 Mabsadd L
.26275 .00062 -0.91448 -0.29713 Mabsadd L
.26275 .00062 -1.46946 -2.02254 Mabsadd L
.26275 .00062 0 -0.96154 Mabsadd L
.26275 .00062 1.46946 -2.02254 Mabsadd L
.26275 .00062 .91448 -0.29713 Mabsadd L
.26275 .00062 2.37764 .77254 Mabsadd L
.26275 .00062 .56518 .7779 Mabsadd L
.26275 .00062 0 2.5 Mabsadd L closepath F
.26667 .0005 0 2.5 Mabsadd m
.26667 .0005 -0.56518 .7779 Mabsadd L
.26667 .0005 -2.37764 .77254 Mabsadd L
.26667 .0005 -0.91448 -0.29713 Mabsadd L
.26667 .0005 -1.46946 -2.02254 Mabsadd L
.26667 .0005 0 -0.96154 Mabsadd L
.26667 .0005 1.46946 -2.02254 Mabsadd L
.26667 .0005 .91448 -0.29713 Mabsadd L
.26667 .0005 2.37764 .77254 Mabsadd L
.26667 .0005 .56518 .7779 Mabsadd L
.26667 .0005 0 2.5 Mabsadd L closepath F
.27059 .00041 0 2.5 Mabsadd m
.27059 .00041 -0.56518 .7779 Mabsadd L
.27059 .00041 -2.37764 .77254 Mabsadd L
.27059 .00041 -0.91448 -0.29713 Mabsadd L
.27059 .00041 -1.46946 -2.02254 Mabsadd L
.27059 .00041 0 -0.96154 Mabsadd L
.27059 .00041 1.46946 -2.02254 Mabsadd L
.27059 .00041 .91448 -0.29713 Mabsadd L
.27059 .00041 2.37764 .77254 Mabsadd L
.27059 .00041 .56518 .7779 Mabsadd L
.27059 .00041 0 2.5 Mabsadd L closepath F
.27451 .00033 0 2.5 Mabsadd m
.27451 .00033 -0.56518 .7779 Mabsadd L
.27451 .00033 -2.37764 .77254 Mabsadd L
.27451 .00033 -0.91448 -0.29713 Mabsadd L
.27451 .00033 -1.46946 -2.02254 Mabsadd L
.27451 .00033 0 -0.96154 Mabsadd L
.27451 .00033 1.46946 -2.02254 Mabsadd L
.27451 .00033 .91448 -0.29713 Mabsadd L
.27451 .00033 2.37764 .77254 Mabsadd L
.27451 .00033 .56518 .7779 Mabsadd L
.27451 .00033 0 2.5 Mabsadd L closepath F
.27843 .00027 0 2.5 Mabsadd m
.27843 .00027 -0.56518 .7779 Mabsadd L
.27843 .00027 -2.37764 .77254 Mabsadd L
.27843 .00027 -0.91448 -0.29713 Mabsadd L
.27843 .00027 -1.46946 -2.02254 Mabsadd L
.27843 .00027 0 -0.96154 Mabsadd L
.27843 .00027 1.46946 -2.02254 Mabsadd L
.27843 .00027 .91448 -0.29713 Mabsadd L
.27843 .00027 2.37764 .77254 Mabsadd L
.27843 .00027 .56518 .7779 Mabsadd L
.27843 .00027 0 2.5 Mabsadd L closepath F
.28235 .00021 0 2.5 Mabsadd m
.28235 .00021 -0.56518 .7779 Mabsadd L
.28235 .00021 -2.37764 .77254 Mabsadd L
.28235 .00021 -0.91448 -0.29713 Mabsadd L
.28235 .00021 -1.46946 -2.02254 Mabsadd L
.28235 .00021 0 -0.96154 Mabsadd L
.28235 .00021 1.46946 -2.02254 Mabsadd L
.28235 .00021 .91448 -0.29713 Mabsadd L
.28235 .00021 2.37764 .77254 Mabsadd L
.28235 .00021 .56518 .7779 Mabsadd L
.28235 .00021 0 2.5 Mabsadd L closepath F
.28627 .00017 0 2.5 Mabsadd m
.28627 .00017 -0.56518 .7779 Mabsadd L
.28627 .00017 -2.37764 .77254 Mabsadd L
.28627 .00017 -0.91448 -0.29713 Mabsadd L
.28627 .00017 -1.46946 -2.02254 Mabsadd L
.28627 .00017 0 -0.96154 Mabsadd L
.28627 .00017 1.46946 -2.02254 Mabsadd L
.28627 .00017 .91448 -0.29713 Mabsadd L
.28627 .00017 2.37764 .77254 Mabsadd L
.28627 .00017 .56518 .7779 Mabsadd L
.28627 .00017 0 2.5 Mabsadd L closepath F
.2902 .00014 0 2.5 Mabsadd m
.2902 .00014 -0.56518 .7779 Mabsadd L
.2902 .00014 -2.37764 .77254 Mabsadd L
.2902 .00014 -0.91448 -0.29713 Mabsadd L
.2902 .00014 -1.46946 -2.02254 Mabsadd L
.2902 .00014 0 -0.96154 Mabsadd L
.2902 .00014 1.46946 -2.02254 Mabsadd L
.2902 .00014 .91448 -0.29713 Mabsadd L
.2902 .00014 2.37764 .77254 Mabsadd L
.2902 .00014 .56518 .7779 Mabsadd L
.2902 .00014 0 2.5 Mabsadd L closepath F
.29412 .00011 0 2.5 Mabsadd m
.29412 .00011 -0.56518 .7779 Mabsadd L
.29412 .00011 -2.37764 .77254 Mabsadd L
.29412 .00011 -0.91448 -0.29713 Mabsadd L
.29412 .00011 -1.46946 -2.02254 Mabsadd L
.29412 .00011 0 -0.96154 Mabsadd L
.29412 .00011 1.46946 -2.02254 Mabsadd L
.29412 .00011 .91448 -0.29713 Mabsadd L
.29412 .00011 2.37764 .77254 Mabsadd L
.29412 .00011 .56518 .7779 Mabsadd L
.29412 .00011 0 2.5 Mabsadd L closepath F
.29804 9e-005 0 2.5 Mabsadd m
.29804 9e-005 -0.56518 .7779 Mabsadd L
.29804 9e-005 -2.37764 .77254 Mabsadd L
.29804 9e-005 -0.91448 -0.29713 Mabsadd L
.29804 9e-005 -1.46946 -2.02254 Mabsadd L
.29804 9e-005 0 -0.96154 Mabsadd L
.29804 9e-005 1.46946 -2.02254 Mabsadd L
.29804 9e-005 .91448 -0.29713 Mabsadd L
.29804 9e-005 2.37764 .77254 Mabsadd L
.29804 9e-005 .56518 .7779 Mabsadd L
.29804 9e-005 0 2.5 Mabsadd L closepath F
.30196 7e-005 0 2.5 Mabsadd m
.30196 7e-005 -0.56518 .7779 Mabsadd L
.30196 7e-005 -2.37764 .77254 Mabsadd L
.30196 7e-005 -0.91448 -0.29713 Mabsadd L
.30196 7e-005 -1.46946 -2.02254 Mabsadd L
.30196 7e-005 0 -0.96154 Mabsadd L
.30196 7e-005 1.46946 -2.02254 Mabsadd L
.30196 7e-005 .91448 -0.29713 Mabsadd L
.30196 7e-005 2.37764 .77254 Mabsadd L
.30196 7e-005 .56518 .7779 Mabsadd L
.30196 7e-005 0 2.5 Mabsadd L closepath F
.30588 5e-005 0 2.5 Mabsadd m
.30588 5e-005 -0.56518 .7779 Mabsadd L
.30588 5e-005 -2.37764 .77254 Mabsadd L
.30588 5e-005 -0.91448 -0.29713 Mabsadd L
.30588 5e-005 -1.46946 -2.02254 Mabsadd L
.30588 5e-005 0 -0.96154 Mabsadd L
.30588 5e-005 1.46946 -2.02254 Mabsadd L
.30588 5e-005 .91448 -0.29713 Mabsadd L
.30588 5e-005 2.37764 .77254 Mabsadd L
.30588 5e-005 .56518 .7779 Mabsadd L
.30588 5e-005 0 2.5 Mabsadd L closepath F
.3098 4e-005 0 2.5 Mabsadd m
.3098 4e-005 -0.56518 .7779 Mabsadd L
.3098 4e-005 -2.37764 .77254 Mabsadd L
.3098 4e-005 -0.91448 -0.29713 Mabsadd L
.3098 4e-005 -1.46946 -2.02254 Mabsadd L
.3098 4e-005 0 -0.96154 Mabsadd L
.3098 4e-005 1.46946 -2.02254 Mabsadd L
.3098 4e-005 .91448 -0.29713 Mabsadd L
.3098 4e-005 2.37764 .77254 Mabsadd L
.3098 4e-005 .56518 .7779 Mabsadd L
.3098 4e-005 0 2.5 Mabsadd L closepath F
.31373 3e-005 0 2.5 Mabsadd m
.31373 3e-005 -0.56518 .7779 Mabsadd L
.31373 3e-005 -2.37764 .77254 Mabsadd L
.31373 3e-005 -0.91448 -0.29713 Mabsadd L
.31373 3e-005 -1.46946 -2.02254 Mabsadd L
.31373 3e-005 0 -0.96154 Mabsadd L
.31373 3e-005 1.46946 -2.02254 Mabsadd L
.31373 3e-005 .91448 -0.29713 Mabsadd L
.31373 3e-005 2.37764 .77254 Mabsadd L
.31373 3e-005 .56518 .7779 Mabsadd L
.31373 3e-005 0 2.5 Mabsadd L closepath F
.31765 3e-005 0 2.5 Mabsadd m
.31765 3e-005 -0.56518 .7779 Mabsadd L
.31765 3e-005 -2.37764 .77254 Mabsadd L
.31765 3e-005 -0.91448 -0.29713 Mabsadd L
.31765 3e-005 -1.46946 -2.02254 Mabsadd L
.31765 3e-005 0 -0.96154 Mabsadd L
.31765 3e-005 1.46946 -2.02254 Mabsadd L
.31765 3e-005 .91448 -0.29713 Mabsadd L
.31765 3e-005 2.37764 .77254 Mabsadd L
.31765 3e-005 .56518 .7779 Mabsadd L
.31765 3e-005 0 2.5 Mabsadd L closepath F
.32157 2e-005 0 2.5 Mabsadd m
.32157 2e-005 -0.56518 .7779 Mabsadd L
.32157 2e-005 -2.37764 .77254 Mabsadd L
.32157 2e-005 -0.91448 -0.29713 Mabsadd L
.32157 2e-005 -1.46946 -2.02254 Mabsadd L
.32157 2e-005 0 -0.96154 Mabsadd L
.32157 2e-005 1.46946 -2.02254 Mabsadd L
.32157 2e-005 .91448 -0.29713 Mabsadd L
.32157 2e-005 2.37764 .77254 Mabsadd L
.32157 2e-005 .56518 .7779 Mabsadd L
.32157 2e-005 0 2.5 Mabsadd L closepath F
.32549 2e-005 0 2.5 Mabsadd m
.32549 2e-005 -0.56518 .7779 Mabsadd L
.32549 2e-005 -2.37764 .77254 Mabsadd L
.32549 2e-005 -0.91448 -0.29713 Mabsadd L
.32549 2e-005 -1.46946 -2.02254 Mabsadd L
.32549 2e-005 0 -0.96154 Mabsadd L
.32549 2e-005 1.46946 -2.02254 Mabsadd L
.32549 2e-005 .91448 -0.29713 Mabsadd L
.32549 2e-005 2.37764 .77254 Mabsadd L
.32549 2e-005 .56518 .7779 Mabsadd L
.32549 2e-005 0 2.5 Mabsadd L closepath F
.32941 1e-005 0 2.5 Mabsadd m
.32941 1e-005 -0.56518 .7779 Mabsadd L
.32941 1e-005 -2.37764 .77254 Mabsadd L
.32941 1e-005 -0.91448 -0.29713 Mabsadd L
.32941 1e-005 -1.46946 -2.02254 Mabsadd L
.32941 1e-005 0 -0.96154 Mabsadd L
.32941 1e-005 1.46946 -2.02254 Mabsadd L
.32941 1e-005 .91448 -0.29713 Mabsadd L
.32941 1e-005 2.37764 .77254 Mabsadd L
.32941 1e-005 .56518 .7779 Mabsadd L
.32941 1e-005 0 2.5 Mabsadd L closepath F
.33333 1e-005 0 2.5 Mabsadd m
.33333 1e-005 -0.56518 .7779 Mabsadd L
.33333 1e-005 -2.37764 .77254 Mabsadd L
.33333 1e-005 -0.91448 -0.29713 Mabsadd L
.33333 1e-005 -1.46946 -2.02254 Mabsadd L
.33333 1e-005 0 -0.96154 Mabsadd L
.33333 1e-005 1.46946 -2.02254 Mabsadd L
.33333 1e-005 .91448 -0.29713 Mabsadd L
.33333 1e-005 2.37764 .77254 Mabsadd L
.33333 1e-005 .56518 .7779 Mabsadd L
.33333 1e-005 0 2.5 Mabsadd L closepath F
.33725 1e-005 0 2.5 Mabsadd m
.33725 1e-005 -0.56518 .7779 Mabsadd L
.33725 1e-005 -2.37764 .77254 Mabsadd L
.33725 1e-005 -0.91448 -0.29713 Mabsadd L
.33725 1e-005 -1.46946 -2.02254 Mabsadd L
.33725 1e-005 0 -0.96154 Mabsadd L
.33725 1e-005 1.46946 -2.02254 Mabsadd L
.33725 1e-005 .91448 -0.29713 Mabsadd L
.33725 1e-005 2.37764 .77254 Mabsadd L
.33725 1e-005 .56518 .7779 Mabsadd L
.33725 1e-005 0 2.5 Mabsadd L closepath F
.34118 1e-005 0 2.5 Mabsadd m
.34118 1e-005 -0.56518 .7779 Mabsadd L
.34118 1e-005 -2.37764 .77254 Mabsadd L
.34118 1e-005 -0.91448 -0.29713 Mabsadd L
.34118 1e-005 -1.46946 -2.02254 Mabsadd L
.34118 1e-005 0 -0.96154 Mabsadd L
.34118 1e-005 1.46946 -2.02254 Mabsadd L
.34118 1e-005 .91448 -0.29713 Mabsadd L
.34118 1e-005 2.37764 .77254 Mabsadd L
.34118 1e-005 .56518 .7779 Mabsadd L
.34118 1e-005 0 2.5 Mabsadd L closepath F
.3451 0 0 2.5 Mabsadd m
.3451 0 -0.56518 .7779 Mabsadd L
.3451 0 -2.37764 .77254 Mabsadd L
.3451 0 -0.91448 -0.29713 Mabsadd L
.3451 0 -1.46946 -2.02254 Mabsadd L
.3451 0 0 -0.96154 Mabsadd L
.3451 0 1.46946 -2.02254 Mabsadd L
.3451 0 .91448 -0.29713 Mabsadd L
.3451 0 2.37764 .77254 Mabsadd L
.3451 0 .56518 .7779 Mabsadd L
.3451 0 0 2.5 Mabsadd L closepath F
.34902 0 0 2.5 Mabsadd m
.34902 0 -0.56518 .7779 Mabsadd L
.34902 0 -2.37764 .77254 Mabsadd L
.34902 0 -0.91448 -0.29713 Mabsadd L
.34902 0 -1.46946 -2.02254 Mabsadd L
.34902 0 0 -0.96154 Mabsadd L
.34902 0 1.46946 -2.02254 Mabsadd L
.34902 0 .91448 -0.29713 Mabsadd L
.34902 0 2.37764 .77254 Mabsadd L
.34902 0 .56518 .7779 Mabsadd L
.34902 0 0 2.5 Mabsadd L closepath F
.35294 0 0 2.5 Mabsadd m
.35294 0 -0.56518 .7779 Mabsadd L
.35294 0 -2.37764 .77254 Mabsadd L
.35294 0 -0.91448 -0.29713 Mabsadd L
.35294 0 -1.46946 -2.02254 Mabsadd L
.35294 0 0 -0.96154 Mabsadd L
.35294 0 1.46946 -2.02254 Mabsadd L
.35294 0 .91448 -0.29713 Mabsadd L
.35294 0 2.37764 .77254 Mabsadd L
.35294 0 .56518 .7779 Mabsadd L
.35294 0 0 2.5 Mabsadd L closepath F
.35686 0 0 2.5 Mabsadd m
.35686 0 -0.56518 .7779 Mabsadd L
.35686 0 -2.37764 .77254 Mabsadd L
.35686 0 -0.91448 -0.29713 Mabsadd L
.35686 0 -1.46946 -2.02254 Mabsadd L
.35686 0 0 -0.96154 Mabsadd L
.35686 0 1.46946 -2.02254 Mabsadd L
.35686 0 .91448 -0.29713 Mabsadd L
.35686 0 2.37764 .77254 Mabsadd L
.35686 0 .56518 .7779 Mabsadd L
.35686 0 0 2.5 Mabsadd L closepath F
.36078 0 0 2.5 Mabsadd m
.36078 0 -0.56518 .7779 Mabsadd L
.36078 0 -2.37764 .77254 Mabsadd L
.36078 0 -0.91448 -0.29713 Mabsadd L
.36078 0 -1.46946 -2.02254 Mabsadd L
.36078 0 0 -0.96154 Mabsadd L
.36078 0 1.46946 -2.02254 Mabsadd L
.36078 0 .91448 -0.29713 Mabsadd L
.36078 0 2.37764 .77254 Mabsadd L
.36078 0 .56518 .7779 Mabsadd L
.36078 0 0 2.5 Mabsadd L closepath F
.36471 0 0 2.5 Mabsadd m
.36471 0 -0.56518 .7779 Mabsadd L
.36471 0 -2.37764 .77254 Mabsadd L
.36471 0 -0.91448 -0.29713 Mabsadd L
.36471 0 -1.46946 -2.02254 Mabsadd L
.36471 0 0 -0.96154 Mabsadd L
.36471 0 1.46946 -2.02254 Mabsadd L
.36471 0 .91448 -0.29713 Mabsadd L
.36471 0 2.37764 .77254 Mabsadd L
.36471 0 .56518 .7779 Mabsadd L
.36471 0 0 2.5 Mabsadd L closepath F
.36863 0 0 2.5 Mabsadd m
.36863 0 -0.56518 .7779 Mabsadd L
.36863 0 -2.37764 .77254 Mabsadd L
.36863 0 -0.91448 -0.29713 Mabsadd L
.36863 0 -1.46946 -2.02254 Mabsadd L
.36863 0 0 -0.96154 Mabsadd L
.36863 0 1.46946 -2.02254 Mabsadd L
.36863 0 .91448 -0.29713 Mabsadd L
.36863 0 2.37764 .77254 Mabsadd L
.36863 0 .56518 .7779 Mabsadd L
.36863 0 0 2.5 Mabsadd L closepath F
.37255 0 0 2.5 Mabsadd m
.37255 0 -0.56518 .7779 Mabsadd L
.37255 0 -2.37764 .77254 Mabsadd L
.37255 0 -0.91448 -0.29713 Mabsadd L
.37255 0 -1.46946 -2.02254 Mabsadd L
.37255 0 0 -0.96154 Mabsadd L
.37255 0 1.46946 -2.02254 Mabsadd L
.37255 0 .91448 -0.29713 Mabsadd L
.37255 0 2.37764 .77254 Mabsadd L
.37255 0 .56518 .7779 Mabsadd L
.37255 0 0 2.5 Mabsadd L closepath F
.37647 0 0 2.5 Mabsadd m
.37647 0 -0.56518 .7779 Mabsadd L
.37647 0 -2.37764 .77254 Mabsadd L
.37647 0 -0.91448 -0.29713 Mabsadd L
.37647 0 -1.46946 -2.02254 Mabsadd L
.37647 0 0 -0.96154 Mabsadd L
.37647 0 1.46946 -2.02254 Mabsadd L
.37647 0 .91448 -0.29713 Mabsadd L
.37647 0 2.37764 .77254 Mabsadd L
.37647 0 .56518 .7779 Mabsadd L
.37647 0 0 2.5 Mabsadd L closepath F
.38039 0 0 2.5 Mabsadd m
.38039 0 -0.56518 .7779 Mabsadd L
.38039 0 -2.37764 .77254 Mabsadd L
.38039 0 -0.91448 -0.29713 Mabsadd L
.38039 0 -1.46946 -2.02254 Mabsadd L
.38039 0 0 -0.96154 Mabsadd L
.38039 0 1.46946 -2.02254 Mabsadd L
.38039 0 .91448 -0.29713 Mabsadd L
.38039 0 2.37764 .77254 Mabsadd L
.38039 0 .56518 .7779 Mabsadd L
.38039 0 0 2.5 Mabsadd L closepath F
.38431 0 0 2.5 Mabsadd m
.38431 0 -0.56518 .7779 Mabsadd L
.38431 0 -2.37764 .77254 Mabsadd L
.38431 0 -0.91448 -0.29713 Mabsadd L
.38431 0 -1.46946 -2.02254 Mabsadd L
.38431 0 0 -0.96154 Mabsadd L
.38431 0 1.46946 -2.02254 Mabsadd L
.38431 0 .91448 -0.29713 Mabsadd L
.38431 0 2.37764 .77254 Mabsadd L
.38431 0 .56518 .7779 Mabsadd L
.38431 0 0 2.5 Mabsadd L closepath F
.38824 0 0 2.5 Mabsadd m
.38824 0 -0.56518 .7779 Mabsadd L
.38824 0 -2.37764 .77254 Mabsadd L
.38824 0 -0.91448 -0.29713 Mabsadd L
.38824 0 -1.46946 -2.02254 Mabsadd L
.38824 0 0 -0.96154 Mabsadd L
.38824 0 1.46946 -2.02254 Mabsadd L
.38824 0 .91448 -0.29713 Mabsadd L
.38824 0 2.37764 .77254 Mabsadd L
.38824 0 .56518 .7779 Mabsadd L
.38824 0 0 2.5 Mabsadd L closepath F
.39216 0 0 2.5 Mabsadd m
.39216 0 -0.56518 .7779 Mabsadd L
.39216 0 -2.37764 .77254 Mabsadd L
.39216 0 -0.91448 -0.29713 Mabsadd L
.39216 0 -1.46946 -2.02254 Mabsadd L
.39216 0 0 -0.96154 Mabsadd L
.39216 0 1.46946 -2.02254 Mabsadd L
.39216 0 .91448 -0.29713 Mabsadd L
.39216 0 2.37764 .77254 Mabsadd L
.39216 0 .56518 .7779 Mabsadd L
.39216 0 0 2.5 Mabsadd L closepath F
.39608 0 0 2.5 Mabsadd m
.39608 0 -0.56518 .7779 Mabsadd L
.39608 0 -2.37764 .77254 Mabsadd L
.39608 0 -0.91448 -0.29713 Mabsadd L
.39608 0 -1.46946 -2.02254 Mabsadd L
.39608 0 0 -0.96154 Mabsadd L
.39608 0 1.46946 -2.02254 Mabsadd L
.39608 0 .91448 -0.29713 Mabsadd L
.39608 0 2.37764 .77254 Mabsadd L
.39608 0 .56518 .7779 Mabsadd L
.39608 0 0 2.5 Mabsadd L closepath F
.4 0 0 2.5 Mabsadd m
.4 0 -0.56518 .7779 Mabsadd L
.4 0 -2.37764 .77254 Mabsadd L
.4 0 -0.91448 -0.29713 Mabsadd L
.4 0 -1.46946 -2.02254 Mabsadd L
.4 0 0 -0.96154 Mabsadd L
.4 0 1.46946 -2.02254 Mabsadd L
.4 0 .91448 -0.29713 Mabsadd L
.4 0 2.37764 .77254 Mabsadd L
.4 0 .56518 .7779 Mabsadd L
.4 0 0 2.5 Mabsadd L closepath F
.40392 0 0 2.5 Mabsadd m
.40392 0 -0.56518 .7779 Mabsadd L
.40392 0 -2.37764 .77254 Mabsadd L
.40392 0 -0.91448 -0.29713 Mabsadd L
.40392 0 -1.46946 -2.02254 Mabsadd L
.40392 0 0 -0.96154 Mabsadd L
.40392 0 1.46946 -2.02254 Mabsadd L
.40392 0 .91448 -0.29713 Mabsadd L
.40392 0 2.37764 .77254 Mabsadd L
.40392 0 .56518 .7779 Mabsadd L
.40392 0 0 2.5 Mabsadd L closepath F
.40784 0 0 2.5 Mabsadd m
.40784 0 -0.56518 .7779 Mabsadd L
.40784 0 -2.37764 .77254 Mabsadd L
.40784 0 -0.91448 -0.29713 Mabsadd L
.40784 0 -1.46946 -2.02254 Mabsadd L
.40784 0 0 -0.96154 Mabsadd L
.40784 0 1.46946 -2.02254 Mabsadd L
.40784 0 .91448 -0.29713 Mabsadd L
.40784 0 2.37764 .77254 Mabsadd L
.40784 0 .56518 .7779 Mabsadd L
.40784 0 0 2.5 Mabsadd L closepath F
.41176 0 0 2.5 Mabsadd m
.41176 0 -0.56518 .7779 Mabsadd L
.41176 0 -2.37764 .77254 Mabsadd L
.41176 0 -0.91448 -0.29713 Mabsadd L
.41176 0 -1.46946 -2.02254 Mabsadd L
.41176 0 0 -0.96154 Mabsadd L
.41176 0 1.46946 -2.02254 Mabsadd L
.41176 0 .91448 -0.29713 Mabsadd L
.41176 0 2.37764 .77254 Mabsadd L
.41176 0 .56518 .7779 Mabsadd L
.41176 0 0 2.5 Mabsadd L closepath F
.41569 0 0 2.5 Mabsadd m
.41569 0 -0.56518 .7779 Mabsadd L
.41569 0 -2.37764 .77254 Mabsadd L
.41569 0 -0.91448 -0.29713 Mabsadd L
.41569 0 -1.46946 -2.02254 Mabsadd L
.41569 0 0 -0.96154 Mabsadd L
.41569 0 1.46946 -2.02254 Mabsadd L
.41569 0 .91448 -0.29713 Mabsadd L
.41569 0 2.37764 .77254 Mabsadd L
.41569 0 .56518 .7779 Mabsadd L
.41569 0 0 2.5 Mabsadd L closepath F
.41961 0 0 2.5 Mabsadd m
.41961 0 -0.56518 .7779 Mabsadd L
.41961 0 -2.37764 .77254 Mabsadd L
.41961 0 -0.91448 -0.29713 Mabsadd L
.41961 0 -1.46946 -2.02254 Mabsadd L
.41961 0 0 -0.96154 Mabsadd L
.41961 0 1.46946 -2.02254 Mabsadd L
.41961 0 .91448 -0.29713 Mabsadd L
.41961 0 2.37764 .77254 Mabsadd L
.41961 0 .56518 .7779 Mabsadd L
.41961 0 0 2.5 Mabsadd L closepath F
.42353 0 0 2.5 Mabsadd m
.42353 0 -0.56518 .7779 Mabsadd L
.42353 0 -2.37764 .77254 Mabsadd L
.42353 0 -0.91448 -0.29713 Mabsadd L
.42353 0 -1.46946 -2.02254 Mabsadd L
.42353 0 0 -0.96154 Mabsadd L
.42353 0 1.46946 -2.02254 Mabsadd L
.42353 0 .91448 -0.29713 Mabsadd L
.42353 0 2.37764 .77254 Mabsadd L
.42353 0 .56518 .7779 Mabsadd L
.42353 0 0 2.5 Mabsadd L closepath F
.42745 0 0 2.5 Mabsadd m
.42745 0 -0.56518 .7779 Mabsadd L
.42745 0 -2.37764 .77254 Mabsadd L
.42745 0 -0.91448 -0.29713 Mabsadd L
.42745 0 -1.46946 -2.02254 Mabsadd L
.42745 0 0 -0.96154 Mabsadd L
.42745 0 1.46946 -2.02254 Mabsadd L
.42745 0 .91448 -0.29713 Mabsadd L
.42745 0 2.37764 .77254 Mabsadd L
.42745 0 .56518 .7779 Mabsadd L
.42745 0 0 2.5 Mabsadd L closepath F
.43137 0 0 2.5 Mabsadd m
.43137 0 -0.56518 .7779 Mabsadd L
.43137 0 -2.37764 .77254 Mabsadd L
.43137 0 -0.91448 -0.29713 Mabsadd L
.43137 0 -1.46946 -2.02254 Mabsadd L
.43137 0 0 -0.96154 Mabsadd L
.43137 0 1.46946 -2.02254 Mabsadd L
.43137 0 .91448 -0.29713 Mabsadd L
.43137 0 2.37764 .77254 Mabsadd L
.43137 0 .56518 .7779 Mabsadd L
.43137 0 0 2.5 Mabsadd L closepath F
.43529 0 0 2.5 Mabsadd m
.43529 0 -0.56518 .7779 Mabsadd L
.43529 0 -2.37764 .77254 Mabsadd L
.43529 0 -0.91448 -0.29713 Mabsadd L
.43529 0 -1.46946 -2.02254 Mabsadd L
.43529 0 0 -0.96154 Mabsadd L
.43529 0 1.46946 -2.02254 Mabsadd L
.43529 0 .91448 -0.29713 Mabsadd L
.43529 0 2.37764 .77254 Mabsadd L
.43529 0 .56518 .7779 Mabsadd L
.43529 0 0 2.5 Mabsadd L closepath F
.43922 0 0 2.5 Mabsadd m
.43922 0 -0.56518 .7779 Mabsadd L
.43922 0 -2.37764 .77254 Mabsadd L
.43922 0 -0.91448 -0.29713 Mabsadd L
.43922 0 -1.46946 -2.02254 Mabsadd L
.43922 0 0 -0.96154 Mabsadd L
.43922 0 1.46946 -2.02254 Mabsadd L
.43922 0 .91448 -0.29713 Mabsadd L
.43922 0 2.37764 .77254 Mabsadd L
.43922 0 .56518 .7779 Mabsadd L
.43922 0 0 2.5 Mabsadd L closepath F
.44314 0 0 2.5 Mabsadd m
.44314 0 -0.56518 .7779 Mabsadd L
.44314 0 -2.37764 .77254 Mabsadd L
.44314 0 -0.91448 -0.29713 Mabsadd L
.44314 0 -1.46946 -2.02254 Mabsadd L
.44314 0 0 -0.96154 Mabsadd L
.44314 0 1.46946 -2.02254 Mabsadd L
.44314 0 .91448 -0.29713 Mabsadd L
.44314 0 2.37764 .77254 Mabsadd L
.44314 0 .56518 .7779 Mabsadd L
.44314 0 0 2.5 Mabsadd L closepath F
.44706 0 0 2.5 Mabsadd m
.44706 0 -0.56518 .7779 Mabsadd L
.44706 0 -2.37764 .77254 Mabsadd L
.44706 0 -0.91448 -0.29713 Mabsadd L
.44706 0 -1.46946 -2.02254 Mabsadd L
.44706 0 0 -0.96154 Mabsadd L
.44706 0 1.46946 -2.02254 Mabsadd L
.44706 0 .91448 -0.29713 Mabsadd L
.44706 0 2.37764 .77254 Mabsadd L
.44706 0 .56518 .7779 Mabsadd L
.44706 0 0 2.5 Mabsadd L closepath F
.45098 0 0 2.5 Mabsadd m
.45098 0 -0.56518 .7779 Mabsadd L
.45098 0 -2.37764 .77254 Mabsadd L
.45098 0 -0.91448 -0.29713 Mabsadd L
.45098 0 -1.46946 -2.02254 Mabsadd L
.45098 0 0 -0.96154 Mabsadd L
.45098 0 1.46946 -2.02254 Mabsadd L
.45098 0 .91448 -0.29713 Mabsadd L
.45098 0 2.37764 .77254 Mabsadd L
.45098 0 .56518 .7779 Mabsadd L
.45098 0 0 2.5 Mabsadd L closepath F
.4549 0 0 2.5 Mabsadd m
.4549 0 -0.56518 .7779 Mabsadd L
.4549 0 -2.37764 .77254 Mabsadd L
.4549 0 -0.91448 -0.29713 Mabsadd L
.4549 0 -1.46946 -2.02254 Mabsadd L
.4549 0 0 -0.96154 Mabsadd L
.4549 0 1.46946 -2.02254 Mabsadd L
.4549 0 .91448 -0.29713 Mabsadd L
.4549 0 2.37764 .77254 Mabsadd L
.4549 0 .56518 .7779 Mabsadd L
.4549 0 0 2.5 Mabsadd L closepath F
.45882 0 0 2.5 Mabsadd m
.45882 0 -0.56518 .7779 Mabsadd L
.45882 0 -2.37764 .77254 Mabsadd L
.45882 0 -0.91448 -0.29713 Mabsadd L
.45882 0 -1.46946 -2.02254 Mabsadd L
.45882 0 0 -0.96154 Mabsadd L
.45882 0 1.46946 -2.02254 Mabsadd L
.45882 0 .91448 -0.29713 Mabsadd L
.45882 0 2.37764 .77254 Mabsadd L
.45882 0 .56518 .7779 Mabsadd L
.45882 0 0 2.5 Mabsadd L closepath F
.46275 0 0 2.5 Mabsadd m
.46275 0 -0.56518 .7779 Mabsadd L
.46275 0 -2.37764 .77254 Mabsadd L
.46275 0 -0.91448 -0.29713 Mabsadd L
.46275 0 -1.46946 -2.02254 Mabsadd L
.46275 0 0 -0.96154 Mabsadd L
.46275 0 1.46946 -2.02254 Mabsadd L
.46275 0 .91448 -0.29713 Mabsadd L
.46275 0 2.37764 .77254 Mabsadd L
.46275 0 .56518 .7779 Mabsadd L
.46275 0 0 2.5 Mabsadd L closepath F
.46667 0 0 2.5 Mabsadd m
.46667 0 -0.56518 .7779 Mabsadd L
.46667 0 -2.37764 .77254 Mabsadd L
.46667 0 -0.91448 -0.29713 Mabsadd L
.46667 0 -1.46946 -2.02254 Mabsadd L
.46667 0 0 -0.96154 Mabsadd L
.46667 0 1.46946 -2.02254 Mabsadd L
.46667 0 .91448 -0.29713 Mabsadd L
.46667 0 2.37764 .77254 Mabsadd L
.46667 0 .56518 .7779 Mabsadd L
.46667 0 0 2.5 Mabsadd L closepath F
.47059 0 0 2.5 Mabsadd m
.47059 0 -0.56518 .7779 Mabsadd L
.47059 0 -2.37764 .77254 Mabsadd L
.47059 0 -0.91448 -0.29713 Mabsadd L
.47059 0 -1.46946 -2.02254 Mabsadd L
.47059 0 0 -0.96154 Mabsadd L
.47059 0 1.46946 -2.02254 Mabsadd L
.47059 0 .91448 -0.29713 Mabsadd L
.47059 0 2.37764 .77254 Mabsadd L
.47059 0 .56518 .7779 Mabsadd L
.47059 0 0 2.5 Mabsadd L closepath F
.47451 0 0 2.5 Mabsadd m
.47451 0 -0.56518 .7779 Mabsadd L
.47451 0 -2.37764 .77254 Mabsadd L
.47451 0 -0.91448 -0.29713 Mabsadd L
.47451 0 -1.46946 -2.02254 Mabsadd L
.47451 0 0 -0.96154 Mabsadd L
.47451 0 1.46946 -2.02254 Mabsadd L
.47451 0 .91448 -0.29713 Mabsadd L
.47451 0 2.37764 .77254 Mabsadd L
.47451 0 .56518 .7779 Mabsadd L
.47451 0 0 2.5 Mabsadd L closepath F
.47843 0 0 2.5 Mabsadd m
.47843 0 -0.56518 .7779 Mabsadd L
.47843 0 -2.37764 .77254 Mabsadd L
.47843 0 -0.91448 -0.29713 Mabsadd L
.47843 0 -1.46946 -2.02254 Mabsadd L
.47843 0 0 -0.96154 Mabsadd L
.47843 0 1.46946 -2.02254 Mabsadd L
.47843 0 .91448 -0.29713 Mabsadd L
.47843 0 2.37764 .77254 Mabsadd L
.47843 0 .56518 .7779 Mabsadd L
.47843 0 0 2.5 Mabsadd L closepath F
.48235 0 0 2.5 Mabsadd m
.48235 0 -0.56518 .7779 Mabsadd L
.48235 0 -2.37764 .77254 Mabsadd L
.48235 0 -0.91448 -0.29713 Mabsadd L
.48235 0 -1.46946 -2.02254 Mabsadd L
.48235 0 0 -0.96154 Mabsadd L
.48235 0 1.46946 -2.02254 Mabsadd L
.48235 0 .91448 -0.29713 Mabsadd L
.48235 0 2.37764 .77254 Mabsadd L
.48235 0 .56518 .7779 Mabsadd L
.48235 0 0 2.5 Mabsadd L closepath F
.48627 0 0 2.5 Mabsadd m
.48627 0 -0.56518 .7779 Mabsadd L
.48627 0 -2.37764 .77254 Mabsadd L
.48627 0 -0.91448 -0.29713 Mabsadd L
.48627 0 -1.46946 -2.02254 Mabsadd L
.48627 0 0 -0.96154 Mabsadd L
.48627 0 1.46946 -2.02254 Mabsadd L
.48627 0 .91448 -0.29713 Mabsadd L
.48627 0 2.37764 .77254 Mabsadd L
.48627 0 .56518 .7779 Mabsadd L
.48627 0 0 2.5 Mabsadd L closepath F
.4902 0 0 2.5 Mabsadd m
.4902 0 -0.56518 .7779 Mabsadd L
.4902 0 -2.37764 .77254 Mabsadd L
.4902 0 -0.91448 -0.29713 Mabsadd L
.4902 0 -1.46946 -2.02254 Mabsadd L
.4902 0 0 -0.96154 Mabsadd L
.4902 0 1.46946 -2.02254 Mabsadd L
.4902 0 .91448 -0.29713 Mabsadd L
.4902 0 2.37764 .77254 Mabsadd L
.4902 0 .56518 .7779 Mabsadd L
.4902 0 0 2.5 Mabsadd L closepath F
.49412 0 0 2.5 Mabsadd m
.49412 0 -0.56518 .7779 Mabsadd L
.49412 0 -2.37764 .77254 Mabsadd L
.49412 0 -0.91448 -0.29713 Mabsadd L
.49412 0 -1.46946 -2.02254 Mabsadd L
.49412 0 0 -0.96154 Mabsadd L
.49412 0 1.46946 -2.02254 Mabsadd L
.49412 0 .91448 -0.29713 Mabsadd L
.49412 0 2.37764 .77254 Mabsadd L
.49412 0 .56518 .7779 Mabsadd L
.49412 0 0 2.5 Mabsadd L closepath F
.49804 0 0 2.5 Mabsadd m
.49804 0 -0.56518 .7779 Mabsadd L
.49804 0 -2.37764 .77254 Mabsadd L
.49804 0 -0.91448 -0.29713 Mabsadd L
.49804 0 -1.46946 -2.02254 Mabsadd L
.49804 0 0 -0.96154 Mabsadd L
.49804 0 1.46946 -2.02254 Mabsadd L
.49804 0 .91448 -0.29713 Mabsadd L
.49804 0 2.37764 .77254 Mabsadd L
.49804 0 .56518 .7779 Mabsadd L
.49804 0 0 2.5 Mabsadd L closepath F
.50196 0 0 2.5 Mabsadd m
.50196 0 -0.56518 .7779 Mabsadd L
.50196 0 -2.37764 .77254 Mabsadd L
.50196 0 -0.91448 -0.29713 Mabsadd L
.50196 0 -1.46946 -2.02254 Mabsadd L
.50196 0 0 -0.96154 Mabsadd L
.50196 0 1.46946 -2.02254 Mabsadd L
.50196 0 .91448 -0.29713 Mabsadd L
.50196 0 2.37764 .77254 Mabsadd L
.50196 0 .56518 .7779 Mabsadd L
.50196 0 0 2.5 Mabsadd L closepath F
.50588 0 0 2.5 Mabsadd m
.50588 0 -0.56518 .7779 Mabsadd L
.50588 0 -2.37764 .77254 Mabsadd L
.50588 0 -0.91448 -0.29713 Mabsadd L
.50588 0 -1.46946 -2.02254 Mabsadd L
.50588 0 0 -0.96154 Mabsadd L
.50588 0 1.46946 -2.02254 Mabsadd L
.50588 0 .91448 -0.29713 Mabsadd L
.50588 0 2.37764 .77254 Mabsadd L
.50588 0 .56518 .7779 Mabsadd L
.50588 0 0 2.5 Mabsadd L closepath F
.5098 0 0 2.5 Mabsadd m
.5098 0 -0.56518 .7779 Mabsadd L
.5098 0 -2.37764 .77254 Mabsadd L
.5098 0 -0.91448 -0.29713 Mabsadd L
.5098 0 -1.46946 -2.02254 Mabsadd L
.5098 0 0 -0.96154 Mabsadd L
.5098 0 1.46946 -2.02254 Mabsadd L
.5098 0 .91448 -0.29713 Mabsadd L
.5098 0 2.37764 .77254 Mabsadd L
.5098 0 .56518 .7779 Mabsadd L
.5098 0 0 2.5 Mabsadd L closepath F
.51373 0 0 2.5 Mabsadd m
.51373 0 -0.56518 .7779 Mabsadd L
.51373 0 -2.37764 .77254 Mabsadd L
.51373 0 -0.91448 -0.29713 Mabsadd L
.51373 0 -1.46946 -2.02254 Mabsadd L
.51373 0 0 -0.96154 Mabsadd L
.51373 0 1.46946 -2.02254 Mabsadd L
.51373 0 .91448 -0.29713 Mabsadd L
.51373 0 2.37764 .77254 Mabsadd L
.51373 0 .56518 .7779 Mabsadd L
.51373 0 0 2.5 Mabsadd L closepath F
.51765 0 0 2.5 Mabsadd m
.51765 0 -0.56518 .7779 Mabsadd L
.51765 0 -2.37764 .77254 Mabsadd L
.51765 0 -0.91448 -0.29713 Mabsadd L
.51765 0 -1.46946 -2.02254 Mabsadd L
.51765 0 0 -0.96154 Mabsadd L
.51765 0 1.46946 -2.02254 Mabsadd L
.51765 0 .91448 -0.29713 Mabsadd L
.51765 0 2.37764 .77254 Mabsadd L
.51765 0 .56518 .7779 Mabsadd L
.51765 0 0 2.5 Mabsadd L closepath F
.52157 0 0 2.5 Mabsadd m
.52157 0 -0.56518 .7779 Mabsadd L
.52157 0 -2.37764 .77254 Mabsadd L
.52157 0 -0.91448 -0.29713 Mabsadd L
.52157 0 -1.46946 -2.02254 Mabsadd L
.52157 0 0 -0.96154 Mabsadd L
.52157 0 1.46946 -2.02254 Mabsadd L
.52157 0 .91448 -0.29713 Mabsadd L
.52157 0 2.37764 .77254 Mabsadd L
.52157 0 .56518 .7779 Mabsadd L
.52157 0 0 2.5 Mabsadd L closepath F
.52549 0 0 2.5 Mabsadd m
.52549 0 -0.56518 .7779 Mabsadd L
.52549 0 -2.37764 .77254 Mabsadd L
.52549 0 -0.91448 -0.29713 Mabsadd L
.52549 0 -1.46946 -2.02254 Mabsadd L
.52549 0 0 -0.96154 Mabsadd L
.52549 0 1.46946 -2.02254 Mabsadd L
.52549 0 .91448 -0.29713 Mabsadd L
.52549 0 2.37764 .77254 Mabsadd L
.52549 0 .56518 .7779 Mabsadd L
.52549 0 0 2.5 Mabsadd L closepath F
.52941 0 0 2.5 Mabsadd m
.52941 0 -0.56518 .7779 Mabsadd L
.52941 0 -2.37764 .77254 Mabsadd L
.52941 0 -0.91448 -0.29713 Mabsadd L
.52941 0 -1.46946 -2.02254 Mabsadd L
.52941 0 0 -0.96154 Mabsadd L
.52941 0 1.46946 -2.02254 Mabsadd L
.52941 0 .91448 -0.29713 Mabsadd L
.52941 0 2.37764 .77254 Mabsadd L
.52941 0 .56518 .7779 Mabsadd L
.52941 0 0 2.5 Mabsadd L closepath F
.53333 0 0 2.5 Mabsadd m
.53333 0 -0.56518 .7779 Mabsadd L
.53333 0 -2.37764 .77254 Mabsadd L
.53333 0 -0.91448 -0.29713 Mabsadd L
.53333 0 -1.46946 -2.02254 Mabsadd L
.53333 0 0 -0.96154 Mabsadd L
.53333 0 1.46946 -2.02254 Mabsadd L
.53333 0 .91448 -0.29713 Mabsadd L
.53333 0 2.37764 .77254 Mabsadd L
.53333 0 .56518 .7779 Mabsadd L
.53333 0 0 2.5 Mabsadd L closepath F
.53725 0 0 2.5 Mabsadd m
.53725 0 -0.56518 .7779 Mabsadd L
.53725 0 -2.37764 .77254 Mabsadd L
.53725 0 -0.91448 -0.29713 Mabsadd L
.53725 0 -1.46946 -2.02254 Mabsadd L
.53725 0 0 -0.96154 Mabsadd L
.53725 0 1.46946 -2.02254 Mabsadd L
.53725 0 .91448 -0.29713 Mabsadd L
.53725 0 2.37764 .77254 Mabsadd L
.53725 0 .56518 .7779 Mabsadd L
.53725 0 0 2.5 Mabsadd L closepath F
.54118 0 0 2.5 Mabsadd m
.54118 0 -0.56518 .7779 Mabsadd L
.54118 0 -2.37764 .77254 Mabsadd L
.54118 0 -0.91448 -0.29713 Mabsadd L
.54118 0 -1.46946 -2.02254 Mabsadd L
.54118 0 0 -0.96154 Mabsadd L
.54118 0 1.46946 -2.02254 Mabsadd L
.54118 0 .91448 -0.29713 Mabsadd L
.54118 0 2.37764 .77254 Mabsadd L
.54118 0 .56518 .7779 Mabsadd L
.54118 0 0 2.5 Mabsadd L closepath F
.5451 0 0 2.5 Mabsadd m
.5451 0 -0.56518 .7779 Mabsadd L
.5451 0 -2.37764 .77254 Mabsadd L
.5451 0 -0.91448 -0.29713 Mabsadd L
.5451 0 -1.46946 -2.02254 Mabsadd L
.5451 0 0 -0.96154 Mabsadd L
.5451 0 1.46946 -2.02254 Mabsadd L
.5451 0 .91448 -0.29713 Mabsadd L
.5451 0 2.37764 .77254 Mabsadd L
.5451 0 .56518 .7779 Mabsadd L
.5451 0 0 2.5 Mabsadd L closepath F
.54902 0 0 2.5 Mabsadd m
.54902 0 -0.56518 .7779 Mabsadd L
.54902 0 -2.37764 .77254 Mabsadd L
.54902 0 -0.91448 -0.29713 Mabsadd L
.54902 0 -1.46946 -2.02254 Mabsadd L
.54902 0 0 -0.96154 Mabsadd L
.54902 0 1.46946 -2.02254 Mabsadd L
.54902 0 .91448 -0.29713 Mabsadd L
.54902 0 2.37764 .77254 Mabsadd L
.54902 0 .56518 .7779 Mabsadd L
.54902 0 0 2.5 Mabsadd L closepath F
.55294 0 0 2.5 Mabsadd m
.55294 0 -0.56518 .7779 Mabsadd L
.55294 0 -2.37764 .77254 Mabsadd L
.55294 0 -0.91448 -0.29713 Mabsadd L
.55294 0 -1.46946 -2.02254 Mabsadd L
.55294 0 0 -0.96154 Mabsadd L
.55294 0 1.46946 -2.02254 Mabsadd L
.55294 0 .91448 -0.29713 Mabsadd L
.55294 0 2.37764 .77254 Mabsadd L
.55294 0 .56518 .7779 Mabsadd L
.55294 0 0 2.5 Mabsadd L closepath F
.55686 0 0 2.5 Mabsadd m
.55686 0 -0.56518 .7779 Mabsadd L
.55686 0 -2.37764 .77254 Mabsadd L
.55686 0 -0.91448 -0.29713 Mabsadd L
.55686 0 -1.46946 -2.02254 Mabsadd L
.55686 0 0 -0.96154 Mabsadd L
.55686 0 1.46946 -2.02254 Mabsadd L
.55686 0 .91448 -0.29713 Mabsadd L
.55686 0 2.37764 .77254 Mabsadd L
.55686 0 .56518 .7779 Mabsadd L
.55686 0 0 2.5 Mabsadd L closepath F
.56078 0 0 2.5 Mabsadd m
.56078 0 -0.56518 .7779 Mabsadd L
.56078 0 -2.37764 .77254 Mabsadd L
.56078 0 -0.91448 -0.29713 Mabsadd L
.56078 0 -1.46946 -2.02254 Mabsadd L
.56078 0 0 -0.96154 Mabsadd L
.56078 0 1.46946 -2.02254 Mabsadd L
.56078 0 .91448 -0.29713 Mabsadd L
.56078 0 2.37764 .77254 Mabsadd L
.56078 0 .56518 .7779 Mabsadd L
.56078 0 0 2.5 Mabsadd L closepath F
.56471 0 0 2.5 Mabsadd m
.56471 0 -0.56518 .7779 Mabsadd L
.56471 0 -2.37764 .77254 Mabsadd L
.56471 0 -0.91448 -0.29713 Mabsadd L
.56471 0 -1.46946 -2.02254 Mabsadd L
.56471 0 0 -0.96154 Mabsadd L
.56471 0 1.46946 -2.02254 Mabsadd L
.56471 0 .91448 -0.29713 Mabsadd L
.56471 0 2.37764 .77254 Mabsadd L
.56471 0 .56518 .7779 Mabsadd L
.56471 0 0 2.5 Mabsadd L closepath F
.56863 0 0 2.5 Mabsadd m
.56863 0 -0.56518 .7779 Mabsadd L
.56863 0 -2.37764 .77254 Mabsadd L
.56863 0 -0.91448 -0.29713 Mabsadd L
.56863 0 -1.46946 -2.02254 Mabsadd L
.56863 0 0 -0.96154 Mabsadd L
.56863 0 1.46946 -2.02254 Mabsadd L
.56863 0 .91448 -0.29713 Mabsadd L
.56863 0 2.37764 .77254 Mabsadd L
.56863 0 .56518 .7779 Mabsadd L
.56863 0 0 2.5 Mabsadd L closepath F
.57255 0 0 2.5 Mabsadd m
.57255 0 -0.56518 .7779 Mabsadd L
.57255 0 -2.37764 .77254 Mabsadd L
.57255 0 -0.91448 -0.29713 Mabsadd L
.57255 0 -1.46946 -2.02254 Mabsadd L
.57255 0 0 -0.96154 Mabsadd L
.57255 0 1.46946 -2.02254 Mabsadd L
.57255 0 .91448 -0.29713 Mabsadd L
.57255 0 2.37764 .77254 Mabsadd L
.57255 0 .56518 .7779 Mabsadd L
.57255 0 0 2.5 Mabsadd L closepath F
.57647 0 0 2.5 Mabsadd m
.57647 0 -0.56518 .7779 Mabsadd L
.57647 0 -2.37764 .77254 Mabsadd L
.57647 0 -0.91448 -0.29713 Mabsadd L
.57647 0 -1.46946 -2.02254 Mabsadd L
.57647 0 0 -0.96154 Mabsadd L
.57647 0 1.46946 -2.02254 Mabsadd L
.57647 0 .91448 -0.29713 Mabsadd L
.57647 0 2.37764 .77254 Mabsadd L
.57647 0 .56518 .7779 Mabsadd L
.57647 0 0 2.5 Mabsadd L closepath F
.58039 0 0 2.5 Mabsadd m
.58039 0 -0.56518 .7779 Mabsadd L
.58039 0 -2.37764 .77254 Mabsadd L
.58039 0 -0.91448 -0.29713 Mabsadd L
.58039 0 -1.46946 -2.02254 Mabsadd L
.58039 0 0 -0.96154 Mabsadd L
.58039 0 1.46946 -2.02254 Mabsadd L
.58039 0 .91448 -0.29713 Mabsadd L
.58039 0 2.37764 .77254 Mabsadd L
.58039 0 .56518 .7779 Mabsadd L
.58039 0 0 2.5 Mabsadd L closepath F
.58431 0 0 2.5 Mabsadd m
.58431 0 -0.56518 .7779 Mabsadd L
.58431 0 -2.37764 .77254 Mabsadd L
.58431 0 -0.91448 -0.29713 Mabsadd L
.58431 0 -1.46946 -2.02254 Mabsadd L
.58431 0 0 -0.96154 Mabsadd L
.58431 0 1.46946 -2.02254 Mabsadd L
.58431 0 .91448 -0.29713 Mabsadd L
.58431 0 2.37764 .77254 Mabsadd L
.58431 0 .56518 .7779 Mabsadd L
.58431 0 0 2.5 Mabsadd L closepath F
.58824 0 0 2.5 Mabsadd m
.58824 0 -0.56518 .7779 Mabsadd L
.58824 0 -2.37764 .77254 Mabsadd L
.58824 0 -0.91448 -0.29713 Mabsadd L
.58824 0 -1.46946 -2.02254 Mabsadd L
.58824 0 0 -0.96154 Mabsadd L
.58824 0 1.46946 -2.02254 Mabsadd L
.58824 0 .91448 -0.29713 Mabsadd L
.58824 0 2.37764 .77254 Mabsadd L
.58824 0 .56518 .7779 Mabsadd L
.58824 0 0 2.5 Mabsadd L closepath F
.59216 0 0 2.5 Mabsadd m
.59216 0 -0.56518 .7779 Mabsadd L
.59216 0 -2.37764 .77254 Mabsadd L
.59216 0 -0.91448 -0.29713 Mabsadd L
.59216 0 -1.46946 -2.02254 Mabsadd L
.59216 0 0 -0.96154 Mabsadd L
.59216 0 1.46946 -2.02254 Mabsadd L
.59216 0 .91448 -0.29713 Mabsadd L
.59216 0 2.37764 .77254 Mabsadd L
.59216 0 .56518 .7779 Mabsadd L
.59216 0 0 2.5 Mabsadd L closepath F
.59608 0 0 2.5 Mabsadd m
.59608 0 -0.56518 .7779 Mabsadd L
.59608 0 -2.37764 .77254 Mabsadd L
.59608 0 -0.91448 -0.29713 Mabsadd L
.59608 0 -1.46946 -2.02254 Mabsadd L
.59608 0 0 -0.96154 Mabsadd L
.59608 0 1.46946 -2.02254 Mabsadd L
.59608 0 .91448 -0.29713 Mabsadd L
.59608 0 2.37764 .77254 Mabsadd L
.59608 0 .56518 .7779 Mabsadd L
.59608 0 0 2.5 Mabsadd L closepath F
.6 0 0 2.5 Mabsadd m
.6 0 -0.56518 .7779 Mabsadd L
.6 0 -2.37764 .77254 Mabsadd L
.6 0 -0.91448 -0.29713 Mabsadd L
.6 0 -1.46946 -2.02254 Mabsadd L
.6 0 0 -0.96154 Mabsadd L
.6 0 1.46946 -2.02254 Mabsadd L
.6 0 .91448 -0.29713 Mabsadd L
.6 0 2.37764 .77254 Mabsadd L
.6 0 .56518 .7779 Mabsadd L
.6 0 0 2.5 Mabsadd L closepath F
.60392 0 0 2.5 Mabsadd m
.60392 0 -0.56518 .7779 Mabsadd L
.60392 0 -2.37764 .77254 Mabsadd L
.60392 0 -0.91448 -0.29713 Mabsadd L
.60392 0 -1.46946 -2.02254 Mabsadd L
.60392 0 0 -0.96154 Mabsadd L
.60392 0 1.46946 -2.02254 Mabsadd L
.60392 0 .91448 -0.29713 Mabsadd L
.60392 0 2.37764 .77254 Mabsadd L
.60392 0 .56518 .7779 Mabsadd L
.60392 0 0 2.5 Mabsadd L closepath F
.60784 0 0 2.5 Mabsadd m
.60784 0 -0.56518 .7779 Mabsadd L
.60784 0 -2.37764 .77254 Mabsadd L
.60784 0 -0.91448 -0.29713 Mabsadd L
.60784 0 -1.46946 -2.02254 Mabsadd L
.60784 0 0 -0.96154 Mabsadd L
.60784 0 1.46946 -2.02254 Mabsadd L
.60784 0 .91448 -0.29713 Mabsadd L
.60784 0 2.37764 .77254 Mabsadd L
.60784 0 .56518 .7779 Mabsadd L
.60784 0 0 2.5 Mabsadd L closepath F
.61176 0 0 2.5 Mabsadd m
.61176 0 -0.56518 .7779 Mabsadd L
.61176 0 -2.37764 .77254 Mabsadd L
.61176 0 -0.91448 -0.29713 Mabsadd L
.61176 0 -1.46946 -2.02254 Mabsadd L
.61176 0 0 -0.96154 Mabsadd L
.61176 0 1.46946 -2.02254 Mabsadd L
.61176 0 .91448 -0.29713 Mabsadd L
.61176 0 2.37764 .77254 Mabsadd L
.61176 0 .56518 .7779 Mabsadd L
.61176 0 0 2.5 Mabsadd L closepath F
.61569 0 0 2.5 Mabsadd m
.61569 0 -0.56518 .7779 Mabsadd L
.61569 0 -2.37764 .77254 Mabsadd L
.61569 0 -0.91448 -0.29713 Mabsadd L
.61569 0 -1.46946 -2.02254 Mabsadd L
.61569 0 0 -0.96154 Mabsadd L
.61569 0 1.46946 -2.02254 Mabsadd L
.61569 0 .91448 -0.29713 Mabsadd L
.61569 0 2.37764 .77254 Mabsadd L
.61569 0 .56518 .7779 Mabsadd L
.61569 0 0 2.5 Mabsadd L closepath F
.61961 0 0 2.5 Mabsadd m
.61961 0 -0.56518 .7779 Mabsadd L
.61961 0 -2.37764 .77254 Mabsadd L
.61961 0 -0.91448 -0.29713 Mabsadd L
.61961 0 -1.46946 -2.02254 Mabsadd L
.61961 0 0 -0.96154 Mabsadd L
.61961 0 1.46946 -2.02254 Mabsadd L
.61961 0 .91448 -0.29713 Mabsadd L
.61961 0 2.37764 .77254 Mabsadd L
.61961 0 .56518 .7779 Mabsadd L
.61961 0 0 2.5 Mabsadd L closepath F
.62353 0 0 2.5 Mabsadd m
.62353 0 -0.56518 .7779 Mabsadd L
.62353 0 -2.37764 .77254 Mabsadd L
.62353 0 -0.91448 -0.29713 Mabsadd L
.62353 0 -1.46946 -2.02254 Mabsadd L
.62353 0 0 -0.96154 Mabsadd L
.62353 0 1.46946 -2.02254 Mabsadd L
.62353 0 .91448 -0.29713 Mabsadd L
.62353 0 2.37764 .77254 Mabsadd L
.62353 0 .56518 .7779 Mabsadd L
.62353 0 0 2.5 Mabsadd L closepath F
.62745 0 0 2.5 Mabsadd m
.62745 0 -0.56518 .7779 Mabsadd L
.62745 0 -2.37764 .77254 Mabsadd L
.62745 0 -0.91448 -0.29713 Mabsadd L
.62745 0 -1.46946 -2.02254 Mabsadd L
.62745 0 0 -0.96154 Mabsadd L
.62745 0 1.46946 -2.02254 Mabsadd L
.62745 0 .91448 -0.29713 Mabsadd L
.62745 0 2.37764 .77254 Mabsadd L
.62745 0 .56518 .7779 Mabsadd L
.62745 0 0 2.5 Mabsadd L closepath F
.63137 0 0 2.5 Mabsadd m
.63137 0 -0.56518 .7779 Mabsadd L
.63137 0 -2.37764 .77254 Mabsadd L
.63137 0 -0.91448 -0.29713 Mabsadd L
.63137 0 -1.46946 -2.02254 Mabsadd L
.63137 0 0 -0.96154 Mabsadd L
.63137 0 1.46946 -2.02254 Mabsadd L
.63137 0 .91448 -0.29713 Mabsadd L
.63137 0 2.37764 .77254 Mabsadd L
.63137 0 .56518 .7779 Mabsadd L
.63137 0 0 2.5 Mabsadd L closepath F
.63529 0 0 2.5 Mabsadd m
.63529 0 -0.56518 .7779 Mabsadd L
.63529 0 -2.37764 .77254 Mabsadd L
.63529 0 -0.91448 -0.29713 Mabsadd L
.63529 0 -1.46946 -2.02254 Mabsadd L
.63529 0 0 -0.96154 Mabsadd L
.63529 0 1.46946 -2.02254 Mabsadd L
.63529 0 .91448 -0.29713 Mabsadd L
.63529 0 2.37764 .77254 Mabsadd L
.63529 0 .56518 .7779 Mabsadd L
.63529 0 0 2.5 Mabsadd L closepath F
.63922 0 0 2.5 Mabsadd m
.63922 0 -0.56518 .7779 Mabsadd L
.63922 0 -2.37764 .77254 Mabsadd L
.63922 0 -0.91448 -0.29713 Mabsadd L
.63922 0 -1.46946 -2.02254 Mabsadd L
.63922 0 0 -0.96154 Mabsadd L
.63922 0 1.46946 -2.02254 Mabsadd L
.63922 0 .91448 -0.29713 Mabsadd L
.63922 0 2.37764 .77254 Mabsadd L
.63922 0 .56518 .7779 Mabsadd L
.63922 0 0 2.5 Mabsadd L closepath F
.64314 0 0 2.5 Mabsadd m
.64314 0 -0.56518 .7779 Mabsadd L
.64314 0 -2.37764 .77254 Mabsadd L
.64314 0 -0.91448 -0.29713 Mabsadd L
.64314 0 -1.46946 -2.02254 Mabsadd L
.64314 0 0 -0.96154 Mabsadd L
.64314 0 1.46946 -2.02254 Mabsadd L
.64314 0 .91448 -0.29713 Mabsadd L
.64314 0 2.37764 .77254 Mabsadd L
.64314 0 .56518 .7779 Mabsadd L
.64314 0 0 2.5 Mabsadd L closepath F
.64706 0 0 2.5 Mabsadd m
.64706 0 -0.56518 .7779 Mabsadd L
.64706 0 -2.37764 .77254 Mabsadd L
.64706 0 -0.91448 -0.29713 Mabsadd L
.64706 0 -1.46946 -2.02254 Mabsadd L
.64706 0 0 -0.96154 Mabsadd L
.64706 0 1.46946 -2.02254 Mabsadd L
.64706 0 .91448 -0.29713 Mabsadd L
.64706 0 2.37764 .77254 Mabsadd L
.64706 0 .56518 .7779 Mabsadd L
.64706 0 0 2.5 Mabsadd L closepath F
.65098 0 0 2.5 Mabsadd m
.65098 0 -0.56518 .7779 Mabsadd L
.65098 0 -2.37764 .77254 Mabsadd L
.65098 0 -0.91448 -0.29713 Mabsadd L
.65098 0 -1.46946 -2.02254 Mabsadd L
.65098 0 0 -0.96154 Mabsadd L
.65098 0 1.46946 -2.02254 Mabsadd L
.65098 0 .91448 -0.29713 Mabsadd L
.65098 0 2.37764 .77254 Mabsadd L
.65098 0 .56518 .7779 Mabsadd L
.65098 0 0 2.5 Mabsadd L closepath F
.6549 0 0 2.5 Mabsadd m
.6549 0 -0.56518 .7779 Mabsadd L
.6549 0 -2.37764 .77254 Mabsadd L
.6549 0 -0.91448 -0.29713 Mabsadd L
.6549 0 -1.46946 -2.02254 Mabsadd L
.6549 0 0 -0.96154 Mabsadd L
.6549 0 1.46946 -2.02254 Mabsadd L
.6549 0 .91448 -0.29713 Mabsadd L
.6549 0 2.37764 .77254 Mabsadd L
.6549 0 .56518 .7779 Mabsadd L
.6549 0 0 2.5 Mabsadd L closepath F
.65882 0 0 2.5 Mabsadd m
.65882 0 -0.56518 .7779 Mabsadd L
.65882 0 -2.37764 .77254 Mabsadd L
.65882 0 -0.91448 -0.29713 Mabsadd L
.65882 0 -1.46946 -2.02254 Mabsadd L
.65882 0 0 -0.96154 Mabsadd L
.65882 0 1.46946 -2.02254 Mabsadd L
.65882 0 .91448 -0.29713 Mabsadd L
.65882 0 2.37764 .77254 Mabsadd L
.65882 0 .56518 .7779 Mabsadd L
.65882 0 0 2.5 Mabsadd L closepath F
.66275 0 0 2.5 Mabsadd m
.66275 0 -0.56518 .7779 Mabsadd L
.66275 0 -2.37764 .77254 Mabsadd L
.66275 0 -0.91448 -0.29713 Mabsadd L
.66275 0 -1.46946 -2.02254 Mabsadd L
.66275 0 0 -0.96154 Mabsadd L
.66275 0 1.46946 -2.02254 Mabsadd L
.66275 0 .91448 -0.29713 Mabsadd L
.66275 0 2.37764 .77254 Mabsadd L
.66275 0 .56518 .7779 Mabsadd L
.66275 0 0 2.5 Mabsadd L closepath F
.66667 0 0 2.5 Mabsadd m
.66667 0 -0.56518 .7779 Mabsadd L
.66667 0 -2.37764 .77254 Mabsadd L
.66667 0 -0.91448 -0.29713 Mabsadd L
.66667 0 -1.46946 -2.02254 Mabsadd L
.66667 0 0 -0.96154 Mabsadd L
.66667 0 1.46946 -2.02254 Mabsadd L
.66667 0 .91448 -0.29713 Mabsadd L
.66667 0 2.37764 .77254 Mabsadd L
.66667 0 .56518 .7779 Mabsadd L
.66667 0 0 2.5 Mabsadd L closepath F
.67059 0 0 2.5 Mabsadd m
.67059 0 -0.56518 .7779 Mabsadd L
.67059 0 -2.37764 .77254 Mabsadd L
.67059 0 -0.91448 -0.29713 Mabsadd L
.67059 0 -1.46946 -2.02254 Mabsadd L
.67059 0 0 -0.96154 Mabsadd L
.67059 0 1.46946 -2.02254 Mabsadd L
.67059 0 .91448 -0.29713 Mabsadd L
.67059 0 2.37764 .77254 Mabsadd L
.67059 0 .56518 .7779 Mabsadd L
.67059 0 0 2.5 Mabsadd L closepath F
.67451 0 0 2.5 Mabsadd m
.67451 0 -0.56518 .7779 Mabsadd L
.67451 0 -2.37764 .77254 Mabsadd L
.67451 0 -0.91448 -0.29713 Mabsadd L
.67451 0 -1.46946 -2.02254 Mabsadd L
.67451 0 0 -0.96154 Mabsadd L
.67451 0 1.46946 -2.02254 Mabsadd L
.67451 0 .91448 -0.29713 Mabsadd L
.67451 0 2.37764 .77254 Mabsadd L
.67451 0 .56518 .7779 Mabsadd L
.67451 0 0 2.5 Mabsadd L closepath F
.67843 0 0 2.5 Mabsadd m
.67843 0 -0.56518 .7779 Mabsadd L
.67843 0 -2.37764 .77254 Mabsadd L
.67843 0 -0.91448 -0.29713 Mabsadd L
.67843 0 -1.46946 -2.02254 Mabsadd L
.67843 0 0 -0.96154 Mabsadd L
.67843 0 1.46946 -2.02254 Mabsadd L
.67843 0 .91448 -0.29713 Mabsadd L
.67843 0 2.37764 .77254 Mabsadd L
.67843 0 .56518 .7779 Mabsadd L
.67843 0 0 2.5 Mabsadd L closepath F
.68235 0 0 2.5 Mabsadd m
.68235 0 -0.56518 .7779 Mabsadd L
.68235 0 -2.37764 .77254 Mabsadd L
.68235 0 -0.91448 -0.29713 Mabsadd L
.68235 0 -1.46946 -2.02254 Mabsadd L
.68235 0 0 -0.96154 Mabsadd L
.68235 0 1.46946 -2.02254 Mabsadd L
.68235 0 .91448 -0.29713 Mabsadd L
.68235 0 2.37764 .77254 Mabsadd L
.68235 0 .56518 .7779 Mabsadd L
.68235 0 0 2.5 Mabsadd L closepath F
.68627 0 0 2.5 Mabsadd m
.68627 0 -0.56518 .7779 Mabsadd L
.68627 0 -2.37764 .77254 Mabsadd L
.68627 0 -0.91448 -0.29713 Mabsadd L
.68627 0 -1.46946 -2.02254 Mabsadd L
.68627 0 0 -0.96154 Mabsadd L
.68627 0 1.46946 -2.02254 Mabsadd L
.68627 0 .91448 -0.29713 Mabsadd L
.68627 0 2.37764 .77254 Mabsadd L
.68627 0 .56518 .7779 Mabsadd L
.68627 0 0 2.5 Mabsadd L closepath F
.6902 0 0 2.5 Mabsadd m
.6902 0 -0.56518 .7779 Mabsadd L
.6902 0 -2.37764 .77254 Mabsadd L
.6902 0 -0.91448 -0.29713 Mabsadd L
.6902 0 -1.46946 -2.02254 Mabsadd L
.6902 0 0 -0.96154 Mabsadd L
.6902 0 1.46946 -2.02254 Mabsadd L
.6902 0 .91448 -0.29713 Mabsadd L
.6902 0 2.37764 .77254 Mabsadd L
.6902 0 .56518 .7779 Mabsadd L
.6902 0 0 2.5 Mabsadd L closepath F
.69412 0 0 2.5 Mabsadd m
.69412 0 -0.56518 .7779 Mabsadd L
.69412 0 -2.37764 .77254 Mabsadd L
.69412 0 -0.91448 -0.29713 Mabsadd L
.69412 0 -1.46946 -2.02254 Mabsadd L
.69412 0 0 -0.96154 Mabsadd L
.69412 0 1.46946 -2.02254 Mabsadd L
.69412 0 .91448 -0.29713 Mabsadd L
.69412 0 2.37764 .77254 Mabsadd L
.69412 0 .56518 .7779 Mabsadd L
.69412 0 0 2.5 Mabsadd L closepath F
.69804 0 0 2.5 Mabsadd m
.69804 0 -0.56518 .7779 Mabsadd L
.69804 0 -2.37764 .77254 Mabsadd L
.69804 0 -0.91448 -0.29713 Mabsadd L
.69804 0 -1.46946 -2.02254 Mabsadd L
.69804 0 0 -0.96154 Mabsadd L
.69804 0 1.46946 -2.02254 Mabsadd L
.69804 0 .91448 -0.29713 Mabsadd L
.69804 0 2.37764 .77254 Mabsadd L
.69804 0 .56518 .7779 Mabsadd L
.69804 0 0 2.5 Mabsadd L closepath F
.70196 0 0 2.5 Mabsadd m
.70196 0 -0.56518 .7779 Mabsadd L
.70196 0 -2.37764 .77254 Mabsadd L
.70196 0 -0.91448 -0.29713 Mabsadd L
.70196 0 -1.46946 -2.02254 Mabsadd L
.70196 0 0 -0.96154 Mabsadd L
.70196 0 1.46946 -2.02254 Mabsadd L
.70196 0 .91448 -0.29713 Mabsadd L
.70196 0 2.37764 .77254 Mabsadd L
.70196 0 .56518 .7779 Mabsadd L
.70196 0 0 2.5 Mabsadd L closepath F
.70588 0 0 2.5 Mabsadd m
.70588 0 -0.56518 .7779 Mabsadd L
.70588 0 -2.37764 .77254 Mabsadd L
.70588 0 -0.91448 -0.29713 Mabsadd L
.70588 0 -1.46946 -2.02254 Mabsadd L
.70588 0 0 -0.96154 Mabsadd L
.70588 0 1.46946 -2.02254 Mabsadd L
.70588 0 .91448 -0.29713 Mabsadd L
.70588 0 2.37764 .77254 Mabsadd L
.70588 0 .56518 .7779 Mabsadd L
.70588 0 0 2.5 Mabsadd L closepath F
.7098 0 0 2.5 Mabsadd m
.7098 0 -0.56518 .7779 Mabsadd L
.7098 0 -2.37764 .77254 Mabsadd L
.7098 0 -0.91448 -0.29713 Mabsadd L
.7098 0 -1.46946 -2.02254 Mabsadd L
.7098 0 0 -0.96154 Mabsadd L
.7098 0 1.46946 -2.02254 Mabsadd L
.7098 0 .91448 -0.29713 Mabsadd L
.7098 0 2.37764 .77254 Mabsadd L
.7098 0 .56518 .7779 Mabsadd L
.7098 0 0 2.5 Mabsadd L closepath F
.71373 0 0 2.5 Mabsadd m
.71373 0 -0.56518 .7779 Mabsadd L
.71373 0 -2.37764 .77254 Mabsadd L
.71373 0 -0.91448 -0.29713 Mabsadd L
.71373 0 -1.46946 -2.02254 Mabsadd L
.71373 0 0 -0.96154 Mabsadd L
.71373 0 1.46946 -2.02254 Mabsadd L
.71373 0 .91448 -0.29713 Mabsadd L
.71373 0 2.37764 .77254 Mabsadd L
.71373 0 .56518 .7779 Mabsadd L
.71373 0 0 2.5 Mabsadd L closepath F
.71765 0 0 2.5 Mabsadd m
.71765 0 -0.56518 .7779 Mabsadd L
.71765 0 -2.37764 .77254 Mabsadd L
.71765 0 -0.91448 -0.29713 Mabsadd L
.71765 0 -1.46946 -2.02254 Mabsadd L
.71765 0 0 -0.96154 Mabsadd L
.71765 0 1.46946 -2.02254 Mabsadd L
.71765 0 .91448 -0.29713 Mabsadd L
.71765 0 2.37764 .77254 Mabsadd L
.71765 0 .56518 .7779 Mabsadd L
.71765 0 0 2.5 Mabsadd L closepath F
.72157 0 0 2.5 Mabsadd m
.72157 0 -0.56518 .7779 Mabsadd L
.72157 0 -2.37764 .77254 Mabsadd L
.72157 0 -0.91448 -0.29713 Mabsadd L
.72157 0 -1.46946 -2.02254 Mabsadd L
.72157 0 0 -0.96154 Mabsadd L
.72157 0 1.46946 -2.02254 Mabsadd L
.72157 0 .91448 -0.29713 Mabsadd L
.72157 0 2.37764 .77254 Mabsadd L
.72157 0 .56518 .7779 Mabsadd L
.72157 0 0 2.5 Mabsadd L closepath F
.72549 0 0 2.5 Mabsadd m
.72549 0 -0.56518 .7779 Mabsadd L
.72549 0 -2.37764 .77254 Mabsadd L
.72549 0 -0.91448 -0.29713 Mabsadd L
.72549 0 -1.46946 -2.02254 Mabsadd L
.72549 0 0 -0.96154 Mabsadd L
.72549 0 1.46946 -2.02254 Mabsadd L
.72549 0 .91448 -0.29713 Mabsadd L
.72549 0 2.37764 .77254 Mabsadd L
.72549 0 .56518 .7779 Mabsadd L
.72549 0 0 2.5 Mabsadd L closepath F
.72941 0 0 2.5 Mabsadd m
.72941 0 -0.56518 .7779 Mabsadd L
.72941 0 -2.37764 .77254 Mabsadd L
.72941 0 -0.91448 -0.29713 Mabsadd L
.72941 0 -1.46946 -2.02254 Mabsadd L
.72941 0 0 -0.96154 Mabsadd L
.72941 0 1.46946 -2.02254 Mabsadd L
.72941 0 .91448 -0.29713 Mabsadd L
.72941 0 2.37764 .77254 Mabsadd L
.72941 0 .56518 .7779 Mabsadd L
.72941 0 0 2.5 Mabsadd L closepath F
.73333 0 0 2.5 Mabsadd m
.73333 0 -0.56518 .7779 Mabsadd L
.73333 0 -2.37764 .77254 Mabsadd L
.73333 0 -0.91448 -0.29713 Mabsadd L
.73333 0 -1.46946 -2.02254 Mabsadd L
.73333 0 0 -0.96154 Mabsadd L
.73333 0 1.46946 -2.02254 Mabsadd L
.73333 0 .91448 -0.29713 Mabsadd L
.73333 0 2.37764 .77254 Mabsadd L
.73333 0 .56518 .7779 Mabsadd L
.73333 0 0 2.5 Mabsadd L closepath F
.73725 0 0 2.5 Mabsadd m
.73725 0 -0.56518 .7779 Mabsadd L
.73725 0 -2.37764 .77254 Mabsadd L
.73725 0 -0.91448 -0.29713 Mabsadd L
.73725 0 -1.46946 -2.02254 Mabsadd L
.73725 0 0 -0.96154 Mabsadd L
.73725 0 1.46946 -2.02254 Mabsadd L
.73725 0 .91448 -0.29713 Mabsadd L
.73725 0 2.37764 .77254 Mabsadd L
.73725 0 .56518 .7779 Mabsadd L
.73725 0 0 2.5 Mabsadd L closepath F
.74118 0 0 2.5 Mabsadd m
.74118 0 -0.56518 .7779 Mabsadd L
.74118 0 -2.37764 .77254 Mabsadd L
.74118 0 -0.91448 -0.29713 Mabsadd L
.74118 0 -1.46946 -2.02254 Mabsadd L
.74118 0 0 -0.96154 Mabsadd L
.74118 0 1.46946 -2.02254 Mabsadd L
.74118 0 .91448 -0.29713 Mabsadd L
.74118 0 2.37764 .77254 Mabsadd L
.74118 0 .56518 .7779 Mabsadd L
.74118 0 0 2.5 Mabsadd L closepath F
.7451 0 0 2.5 Mabsadd m
.7451 0 -0.56518 .7779 Mabsadd L
.7451 0 -2.37764 .77254 Mabsadd L
.7451 0 -0.91448 -0.29713 Mabsadd L
.7451 0 -1.46946 -2.02254 Mabsadd L
.7451 0 0 -0.96154 Mabsadd L
.7451 0 1.46946 -2.02254 Mabsadd L
.7451 0 .91448 -0.29713 Mabsadd L
.7451 0 2.37764 .77254 Mabsadd L
.7451 0 .56518 .7779 Mabsadd L
.7451 0 0 2.5 Mabsadd L closepath F
.74902 0 0 2.5 Mabsadd m
.74902 0 -0.56518 .7779 Mabsadd L
.74902 0 -2.37764 .77254 Mabsadd L
.74902 0 -0.91448 -0.29713 Mabsadd L
.74902 0 -1.46946 -2.02254 Mabsadd L
.74902 0 0 -0.96154 Mabsadd L
.74902 0 1.46946 -2.02254 Mabsadd L
.74902 0 .91448 -0.29713 Mabsadd L
.74902 0 2.37764 .77254 Mabsadd L
.74902 0 .56518 .7779 Mabsadd L
.74902 0 0 2.5 Mabsadd L closepath F
.75294 0 0 2.5 Mabsadd m
.75294 0 -0.56518 .7779 Mabsadd L
.75294 0 -2.37764 .77254 Mabsadd L
.75294 0 -0.91448 -0.29713 Mabsadd L
.75294 0 -1.46946 -2.02254 Mabsadd L
.75294 0 0 -0.96154 Mabsadd L
.75294 0 1.46946 -2.02254 Mabsadd L
.75294 0 .91448 -0.29713 Mabsadd L
.75294 0 2.37764 .77254 Mabsadd L
.75294 0 .56518 .7779 Mabsadd L
.75294 0 0 2.5 Mabsadd L closepath F
.75686 0 0 2.5 Mabsadd m
.75686 0 -0.56518 .7779 Mabsadd L
.75686 0 -2.37764 .77254 Mabsadd L
.75686 0 -0.91448 -0.29713 Mabsadd L
.75686 0 -1.46946 -2.02254 Mabsadd L
.75686 0 0 -0.96154 Mabsadd L
.75686 0 1.46946 -2.02254 Mabsadd L
.75686 0 .91448 -0.29713 Mabsadd L
.75686 0 2.37764 .77254 Mabsadd L
.75686 0 .56518 .7779 Mabsadd L
.75686 0 0 2.5 Mabsadd L closepath F
.76078 0 0 2.5 Mabsadd m
.76078 0 -0.56518 .7779 Mabsadd L
.76078 0 -2.37764 .77254 Mabsadd L
.76078 0 -0.91448 -0.29713 Mabsadd L
.76078 0 -1.46946 -2.02254 Mabsadd L
.76078 0 0 -0.96154 Mabsadd L
.76078 0 1.46946 -2.02254 Mabsadd L
.76078 0 .91448 -0.29713 Mabsadd L
.76078 0 2.37764 .77254 Mabsadd L
.76078 0 .56518 .7779 Mabsadd L
.76078 0 0 2.5 Mabsadd L closepath F
.76471 0 0 2.5 Mabsadd m
.76471 0 -0.56518 .7779 Mabsadd L
.76471 0 -2.37764 .77254 Mabsadd L
.76471 0 -0.91448 -0.29713 Mabsadd L
.76471 0 -1.46946 -2.02254 Mabsadd L
.76471 0 0 -0.96154 Mabsadd L
.76471 0 1.46946 -2.02254 Mabsadd L
.76471 0 .91448 -0.29713 Mabsadd L
.76471 0 2.37764 .77254 Mabsadd L
.76471 0 .56518 .7779 Mabsadd L
.76471 0 0 2.5 Mabsadd L closepath F
.76863 0 0 2.5 Mabsadd m
.76863 0 -0.56518 .7779 Mabsadd L
.76863 0 -2.37764 .77254 Mabsadd L
.76863 0 -0.91448 -0.29713 Mabsadd L
.76863 0 -1.46946 -2.02254 Mabsadd L
.76863 0 0 -0.96154 Mabsadd L
.76863 0 1.46946 -2.02254 Mabsadd L
.76863 0 .91448 -0.29713 Mabsadd L
.76863 0 2.37764 .77254 Mabsadd L
.76863 0 .56518 .7779 Mabsadd L
.76863 0 0 2.5 Mabsadd L closepath F
.77255 0 0 2.5 Mabsadd m
.77255 0 -0.56518 .7779 Mabsadd L
.77255 0 -2.37764 .77254 Mabsadd L
.77255 0 -0.91448 -0.29713 Mabsadd L
.77255 0 -1.46946 -2.02254 Mabsadd L
.77255 0 0 -0.96154 Mabsadd L
.77255 0 1.46946 -2.02254 Mabsadd L
.77255 0 .91448 -0.29713 Mabsadd L
.77255 0 2.37764 .77254 Mabsadd L
.77255 0 .56518 .7779 Mabsadd L
.77255 0 0 2.5 Mabsadd L closepath F
.77647 0 0 2.5 Mabsadd m
.77647 0 -0.56518 .7779 Mabsadd L
.77647 0 -2.37764 .77254 Mabsadd L
.77647 0 -0.91448 -0.29713 Mabsadd L
.77647 0 -1.46946 -2.02254 Mabsadd L
.77647 0 0 -0.96154 Mabsadd L
.77647 0 1.46946 -2.02254 Mabsadd L
.77647 0 .91448 -0.29713 Mabsadd L
.77647 0 2.37764 .77254 Mabsadd L
.77647 0 .56518 .7779 Mabsadd L
.77647 0 0 2.5 Mabsadd L closepath F
.78039 0 0 2.5 Mabsadd m
.78039 0 -0.56518 .7779 Mabsadd L
.78039 0 -2.37764 .77254 Mabsadd L
.78039 0 -0.91448 -0.29713 Mabsadd L
.78039 0 -1.46946 -2.02254 Mabsadd L
.78039 0 0 -0.96154 Mabsadd L
.78039 0 1.46946 -2.02254 Mabsadd L
.78039 0 .91448 -0.29713 Mabsadd L
.78039 0 2.37764 .77254 Mabsadd L
.78039 0 .56518 .7779 Mabsadd L
.78039 0 0 2.5 Mabsadd L closepath F
.78431 0 0 2.5 Mabsadd m
.78431 0 -0.56518 .7779 Mabsadd L
.78431 0 -2.37764 .77254 Mabsadd L
.78431 0 -0.91448 -0.29713 Mabsadd L
.78431 0 -1.46946 -2.02254 Mabsadd L
.78431 0 0 -0.96154 Mabsadd L
.78431 0 1.46946 -2.02254 Mabsadd L
.78431 0 .91448 -0.29713 Mabsadd L
.78431 0 2.37764 .77254 Mabsadd L
.78431 0 .56518 .7779 Mabsadd L
.78431 0 0 2.5 Mabsadd L closepath F
.78824 0 0 2.5 Mabsadd m
.78824 0 -0.56518 .7779 Mabsadd L
.78824 0 -2.37764 .77254 Mabsadd L
.78824 0 -0.91448 -0.29713 Mabsadd L
.78824 0 -1.46946 -2.02254 Mabsadd L
.78824 0 0 -0.96154 Mabsadd L
.78824 0 1.46946 -2.02254 Mabsadd L
.78824 0 .91448 -0.29713 Mabsadd L
.78824 0 2.37764 .77254 Mabsadd L
.78824 0 .56518 .7779 Mabsadd L
.78824 0 0 2.5 Mabsadd L closepath F
.79216 0 0 2.5 Mabsadd m
.79216 0 -0.56518 .7779 Mabsadd L
.79216 0 -2.37764 .77254 Mabsadd L
.79216 0 -0.91448 -0.29713 Mabsadd L
.79216 0 -1.46946 -2.02254 Mabsadd L
.79216 0 0 -0.96154 Mabsadd L
.79216 0 1.46946 -2.02254 Mabsadd L
.79216 0 .91448 -0.29713 Mabsadd L
.79216 0 2.37764 .77254 Mabsadd L
.79216 0 .56518 .7779 Mabsadd L
.79216 0 0 2.5 Mabsadd L closepath F
.79608 0 0 2.5 Mabsadd m
.79608 0 -0.56518 .7779 Mabsadd L
.79608 0 -2.37764 .77254 Mabsadd L
.79608 0 -0.91448 -0.29713 Mabsadd L
.79608 0 -1.46946 -2.02254 Mabsadd L
.79608 0 0 -0.96154 Mabsadd L
.79608 0 1.46946 -2.02254 Mabsadd L
.79608 0 .91448 -0.29713 Mabsadd L
.79608 0 2.37764 .77254 Mabsadd L
.79608 0 .56518 .7779 Mabsadd L
.79608 0 0 2.5 Mabsadd L closepath F
.8 0 0 2.5 Mabsadd m
.8 0 -0.56518 .7779 Mabsadd L
.8 0 -2.37764 .77254 Mabsadd L
.8 0 -0.91448 -0.29713 Mabsadd L
.8 0 -1.46946 -2.02254 Mabsadd L
.8 0 0 -0.96154 Mabsadd L
.8 0 1.46946 -2.02254 Mabsadd L
.8 0 .91448 -0.29713 Mabsadd L
.8 0 2.37764 .77254 Mabsadd L
.8 0 .56518 .7779 Mabsadd L
.8 0 0 2.5 Mabsadd L closepath F
.80392 0 0 2.5 Mabsadd m
.80392 0 -0.56518 .7779 Mabsadd L
.80392 0 -2.37764 .77254 Mabsadd L
.80392 0 -0.91448 -0.29713 Mabsadd L
.80392 0 -1.46946 -2.02254 Mabsadd L
.80392 0 0 -0.96154 Mabsadd L
.80392 0 1.46946 -2.02254 Mabsadd L
.80392 0 .91448 -0.29713 Mabsadd L
.80392 0 2.37764 .77254 Mabsadd L
.80392 0 .56518 .7779 Mabsadd L
.80392 0 0 2.5 Mabsadd L closepath F
.80784 0 0 2.5 Mabsadd m
.80784 0 -0.56518 .7779 Mabsadd L
.80784 0 -2.37764 .77254 Mabsadd L
.80784 0 -0.91448 -0.29713 Mabsadd L
.80784 0 -1.46946 -2.02254 Mabsadd L
.80784 0 0 -0.96154 Mabsadd L
.80784 0 1.46946 -2.02254 Mabsadd L
.80784 0 .91448 -0.29713 Mabsadd L
.80784 0 2.37764 .77254 Mabsadd L
.80784 0 .56518 .7779 Mabsadd L
.80784 0 0 2.5 Mabsadd L closepath F
.81176 0 0 2.5 Mabsadd m
.81176 0 -0.56518 .7779 Mabsadd L
.81176 0 -2.37764 .77254 Mabsadd L
.81176 0 -0.91448 -0.29713 Mabsadd L
.81176 0 -1.46946 -2.02254 Mabsadd L
.81176 0 0 -0.96154 Mabsadd L
.81176 0 1.46946 -2.02254 Mabsadd L
.81176 0 .91448 -0.29713 Mabsadd L
.81176 0 2.37764 .77254 Mabsadd L
.81176 0 .56518 .7779 Mabsadd L
.81176 0 0 2.5 Mabsadd L closepath F
.81569 0 0 2.5 Mabsadd m
.81569 0 -0.56518 .7779 Mabsadd L
.81569 0 -2.37764 .77254 Mabsadd L
.81569 0 -0.91448 -0.29713 Mabsadd L
.81569 0 -1.46946 -2.02254 Mabsadd L
.81569 0 0 -0.96154 Mabsadd L
.81569 0 1.46946 -2.02254 Mabsadd L
.81569 0 .91448 -0.29713 Mabsadd L
.81569 0 2.37764 .77254 Mabsadd L
.81569 0 .56518 .7779 Mabsadd L
.81569 0 0 2.5 Mabsadd L closepath F
.81961 0 0 2.5 Mabsadd m
.81961 0 -0.56518 .7779 Mabsadd L
.81961 0 -2.37764 .77254 Mabsadd L
.81961 0 -0.91448 -0.29713 Mabsadd L
.81961 0 -1.46946 -2.02254 Mabsadd L
.81961 0 0 -0.96154 Mabsadd L
.81961 0 1.46946 -2.02254 Mabsadd L
.81961 0 .91448 -0.29713 Mabsadd L
.81961 0 2.37764 .77254 Mabsadd L
.81961 0 .56518 .7779 Mabsadd L
.81961 0 0 2.5 Mabsadd L closepath F
.82353 0 0 2.5 Mabsadd m
.82353 0 -0.56518 .7779 Mabsadd L
.82353 0 -2.37764 .77254 Mabsadd L
.82353 0 -0.91448 -0.29713 Mabsadd L
.82353 0 -1.46946 -2.02254 Mabsadd L
.82353 0 0 -0.96154 Mabsadd L
.82353 0 1.46946 -2.02254 Mabsadd L
.82353 0 .91448 -0.29713 Mabsadd L
.82353 0 2.37764 .77254 Mabsadd L
.82353 0 .56518 .7779 Mabsadd L
.82353 0 0 2.5 Mabsadd L closepath F
.82745 0 0 2.5 Mabsadd m
.82745 0 -0.56518 .7779 Mabsadd L
.82745 0 -2.37764 .77254 Mabsadd L
.82745 0 -0.91448 -0.29713 Mabsadd L
.82745 0 -1.46946 -2.02254 Mabsadd L
.82745 0 0 -0.96154 Mabsadd L
.82745 0 1.46946 -2.02254 Mabsadd L
.82745 0 .91448 -0.29713 Mabsadd L
.82745 0 2.37764 .77254 Mabsadd L
.82745 0 .56518 .7779 Mabsadd L
.82745 0 0 2.5 Mabsadd L closepath F
.83137 0 0 2.5 Mabsadd m
.83137 0 -0.56518 .7779 Mabsadd L
.83137 0 -2.37764 .77254 Mabsadd L
.83137 0 -0.91448 -0.29713 Mabsadd L
.83137 0 -1.46946 -2.02254 Mabsadd L
.83137 0 0 -0.96154 Mabsadd L
.83137 0 1.46946 -2.02254 Mabsadd L
.83137 0 .91448 -0.29713 Mabsadd L
.83137 0 2.37764 .77254 Mabsadd L
.83137 0 .56518 .7779 Mabsadd L
.83137 0 0 2.5 Mabsadd L closepath F
.83529 0 0 2.5 Mabsadd m
.83529 0 -0.56518 .7779 Mabsadd L
.83529 0 -2.37764 .77254 Mabsadd L
.83529 0 -0.91448 -0.29713 Mabsadd L
.83529 0 -1.46946 -2.02254 Mabsadd L
.83529 0 0 -0.96154 Mabsadd L
.83529 0 1.46946 -2.02254 Mabsadd L
.83529 0 .91448 -0.29713 Mabsadd L
.83529 0 2.37764 .77254 Mabsadd L
.83529 0 .56518 .7779 Mabsadd L
.83529 0 0 2.5 Mabsadd L closepath F
.83922 0 0 2.5 Mabsadd m
.83922 0 -0.56518 .7779 Mabsadd L
.83922 0 -2.37764 .77254 Mabsadd L
.83922 0 -0.91448 -0.29713 Mabsadd L
.83922 0 -1.46946 -2.02254 Mabsadd L
.83922 0 0 -0.96154 Mabsadd L
.83922 0 1.46946 -2.02254 Mabsadd L
.83922 0 .91448 -0.29713 Mabsadd L
.83922 0 2.37764 .77254 Mabsadd L
.83922 0 .56518 .7779 Mabsadd L
.83922 0 0 2.5 Mabsadd L closepath F
.84314 0 0 2.5 Mabsadd m
.84314 0 -0.56518 .7779 Mabsadd L
.84314 0 -2.37764 .77254 Mabsadd L
.84314 0 -0.91448 -0.29713 Mabsadd L
.84314 0 -1.46946 -2.02254 Mabsadd L
.84314 0 0 -0.96154 Mabsadd L
.84314 0 1.46946 -2.02254 Mabsadd L
.84314 0 .91448 -0.29713 Mabsadd L
.84314 0 2.37764 .77254 Mabsadd L
.84314 0 .56518 .7779 Mabsadd L
.84314 0 0 2.5 Mabsadd L closepath F
.84706 0 0 2.5 Mabsadd m
.84706 0 -0.56518 .7779 Mabsadd L
.84706 0 -2.37764 .77254 Mabsadd L
.84706 0 -0.91448 -0.29713 Mabsadd L
.84706 0 -1.46946 -2.02254 Mabsadd L
.84706 0 0 -0.96154 Mabsadd L
.84706 0 1.46946 -2.02254 Mabsadd L
.84706 0 .91448 -0.29713 Mabsadd L
.84706 0 2.37764 .77254 Mabsadd L
.84706 0 .56518 .7779 Mabsadd L
.84706 0 0 2.5 Mabsadd L closepath F
.85098 0 0 2.5 Mabsadd m
.85098 0 -0.56518 .7779 Mabsadd L
.85098 0 -2.37764 .77254 Mabsadd L
.85098 0 -0.91448 -0.29713 Mabsadd L
.85098 0 -1.46946 -2.02254 Mabsadd L
.85098 0 0 -0.96154 Mabsadd L
.85098 0 1.46946 -2.02254 Mabsadd L
.85098 0 .91448 -0.29713 Mabsadd L
.85098 0 2.37764 .77254 Mabsadd L
.85098 0 .56518 .7779 Mabsadd L
.85098 0 0 2.5 Mabsadd L closepath F
.8549 0 0 2.5 Mabsadd m
.8549 0 -0.56518 .7779 Mabsadd L
.8549 0 -2.37764 .77254 Mabsadd L
.8549 0 -0.91448 -0.29713 Mabsadd L
.8549 0 -1.46946 -2.02254 Mabsadd L
.8549 0 0 -0.96154 Mabsadd L
.8549 0 1.46946 -2.02254 Mabsadd L
.8549 0 .91448 -0.29713 Mabsadd L
.8549 0 2.37764 .77254 Mabsadd L
.8549 0 .56518 .7779 Mabsadd L
.8549 0 0 2.5 Mabsadd L closepath F
.85882 0 0 2.5 Mabsadd m
.85882 0 -0.56518 .7779 Mabsadd L
.85882 0 -2.37764 .77254 Mabsadd L
.85882 0 -0.91448 -0.29713 Mabsadd L
.85882 0 -1.46946 -2.02254 Mabsadd L
.85882 0 0 -0.96154 Mabsadd L
.85882 0 1.46946 -2.02254 Mabsadd L
.85882 0 .91448 -0.29713 Mabsadd L
.85882 0 2.37764 .77254 Mabsadd L
.85882 0 .56518 .7779 Mabsadd L
.85882 0 0 2.5 Mabsadd L closepath F
.86275 0 0 2.5 Mabsadd m
.86275 0 -0.56518 .7779 Mabsadd L
.86275 0 -2.37764 .77254 Mabsadd L
.86275 0 -0.91448 -0.29713 Mabsadd L
.86275 0 -1.46946 -2.02254 Mabsadd L
.86275 0 0 -0.96154 Mabsadd L
.86275 0 1.46946 -2.02254 Mabsadd L
.86275 0 .91448 -0.29713 Mabsadd L
.86275 0 2.37764 .77254 Mabsadd L
.86275 0 .56518 .7779 Mabsadd L
.86275 0 0 2.5 Mabsadd L closepath F
.86667 0 0 2.5 Mabsadd m
.86667 0 -0.56518 .7779 Mabsadd L
.86667 0 -2.37764 .77254 Mabsadd L
.86667 0 -0.91448 -0.29713 Mabsadd L
.86667 0 -1.46946 -2.02254 Mabsadd L
.86667 0 0 -0.96154 Mabsadd L
.86667 0 1.46946 -2.02254 Mabsadd L
.86667 0 .91448 -0.29713 Mabsadd L
.86667 0 2.37764 .77254 Mabsadd L
.86667 0 .56518 .7779 Mabsadd L
.86667 0 0 2.5 Mabsadd L closepath F
.87059 0 0 2.5 Mabsadd m
.87059 0 -0.56518 .7779 Mabsadd L
.87059 0 -2.37764 .77254 Mabsadd L
.87059 0 -0.91448 -0.29713 Mabsadd L
.87059 0 -1.46946 -2.02254 Mabsadd L
.87059 0 0 -0.96154 Mabsadd L
.87059 0 1.46946 -2.02254 Mabsadd L
.87059 0 .91448 -0.29713 Mabsadd L
.87059 0 2.37764 .77254 Mabsadd L
.87059 0 .56518 .7779 Mabsadd L
.87059 0 0 2.5 Mabsadd L closepath F
.87451 0 0 2.5 Mabsadd m
.87451 0 -0.56518 .7779 Mabsadd L
.87451 0 -2.37764 .77254 Mabsadd L
.87451 0 -0.91448 -0.29713 Mabsadd L
.87451 0 -1.46946 -2.02254 Mabsadd L
.87451 0 0 -0.96154 Mabsadd L
.87451 0 1.46946 -2.02254 Mabsadd L
.87451 0 .91448 -0.29713 Mabsadd L
.87451 0 2.37764 .77254 Mabsadd L
.87451 0 .56518 .7779 Mabsadd L
.87451 0 0 2.5 Mabsadd L closepath F
.87843 0 0 2.5 Mabsadd m
.87843 0 -0.56518 .7779 Mabsadd L
.87843 0 -2.37764 .77254 Mabsadd L
.87843 0 -0.91448 -0.29713 Mabsadd L
.87843 0 -1.46946 -2.02254 Mabsadd L
.87843 0 0 -0.96154 Mabsadd L
.87843 0 1.46946 -2.02254 Mabsadd L
.87843 0 .91448 -0.29713 Mabsadd L
.87843 0 2.37764 .77254 Mabsadd L
.87843 0 .56518 .7779 Mabsadd L
.87843 0 0 2.5 Mabsadd L closepath F
.88235 0 0 2.5 Mabsadd m
.88235 0 -0.56518 .7779 Mabsadd L
.88235 0 -2.37764 .77254 Mabsadd L
.88235 0 -0.91448 -0.29713 Mabsadd L
.88235 0 -1.46946 -2.02254 Mabsadd L
.88235 0 0 -0.96154 Mabsadd L
.88235 0 1.46946 -2.02254 Mabsadd L
.88235 0 .91448 -0.29713 Mabsadd L
.88235 0 2.37764 .77254 Mabsadd L
.88235 0 .56518 .7779 Mabsadd L
.88235 0 0 2.5 Mabsadd L closepath F
.88627 0 0 2.5 Mabsadd m
.88627 0 -0.56518 .7779 Mabsadd L
.88627 0 -2.37764 .77254 Mabsadd L
.88627 0 -0.91448 -0.29713 Mabsadd L
.88627 0 -1.46946 -2.02254 Mabsadd L
.88627 0 0 -0.96154 Mabsadd L
.88627 0 1.46946 -2.02254 Mabsadd L
.88627 0 .91448 -0.29713 Mabsadd L
.88627 0 2.37764 .77254 Mabsadd L
.88627 0 .56518 .7779 Mabsadd L
.88627 0 0 2.5 Mabsadd L closepath F
.8902 0 0 2.5 Mabsadd m
.8902 0 -0.56518 .7779 Mabsadd L
.8902 0 -2.37764 .77254 Mabsadd L
.8902 0 -0.91448 -0.29713 Mabsadd L
.8902 0 -1.46946 -2.02254 Mabsadd L
.8902 0 0 -0.96154 Mabsadd L
.8902 0 1.46946 -2.02254 Mabsadd L
.8902 0 .91448 -0.29713 Mabsadd L
.8902 0 2.37764 .77254 Mabsadd L
.8902 0 .56518 .7779 Mabsadd L
.8902 0 0 2.5 Mabsadd L closepath F
.89412 0 0 2.5 Mabsadd m
.89412 0 -0.56518 .7779 Mabsadd L
.89412 0 -2.37764 .77254 Mabsadd L
.89412 0 -0.91448 -0.29713 Mabsadd L
.89412 0 -1.46946 -2.02254 Mabsadd L
.89412 0 0 -0.96154 Mabsadd L
.89412 0 1.46946 -2.02254 Mabsadd L
.89412 0 .91448 -0.29713 Mabsadd L
.89412 0 2.37764 .77254 Mabsadd L
.89412 0 .56518 .7779 Mabsadd L
.89412 0 0 2.5 Mabsadd L closepath F
.89804 0 0 2.5 Mabsadd m
.89804 0 -0.56518 .7779 Mabsadd L
.89804 0 -2.37764 .77254 Mabsadd L
.89804 0 -0.91448 -0.29713 Mabsadd L
.89804 0 -1.46946 -2.02254 Mabsadd L
.89804 0 0 -0.96154 Mabsadd L
.89804 0 1.46946 -2.02254 Mabsadd L
.89804 0 .91448 -0.29713 Mabsadd L
.89804 0 2.37764 .77254 Mabsadd L
.89804 0 .56518 .7779 Mabsadd L
.89804 0 0 2.5 Mabsadd L closepath F
.90196 0 0 2.5 Mabsadd m
.90196 0 -0.56518 .7779 Mabsadd L
.90196 0 -2.37764 .77254 Mabsadd L
.90196 0 -0.91448 -0.29713 Mabsadd L
.90196 0 -1.46946 -2.02254 Mabsadd L
.90196 0 0 -0.96154 Mabsadd L
.90196 0 1.46946 -2.02254 Mabsadd L
.90196 0 .91448 -0.29713 Mabsadd L
.90196 0 2.37764 .77254 Mabsadd L
.90196 0 .56518 .7779 Mabsadd L
.90196 0 0 2.5 Mabsadd L closepath F
.90588 0 0 2.5 Mabsadd m
.90588 0 -0.56518 .7779 Mabsadd L
.90588 0 -2.37764 .77254 Mabsadd L
.90588 0 -0.91448 -0.29713 Mabsadd L
.90588 0 -1.46946 -2.02254 Mabsadd L
.90588 0 0 -0.96154 Mabsadd L
.90588 0 1.46946 -2.02254 Mabsadd L
.90588 0 .91448 -0.29713 Mabsadd L
.90588 0 2.37764 .77254 Mabsadd L
.90588 0 .56518 .7779 Mabsadd L
.90588 0 0 2.5 Mabsadd L closepath F
.9098 0 0 2.5 Mabsadd m
.9098 0 -0.56518 .7779 Mabsadd L
.9098 0 -2.37764 .77254 Mabsadd L
.9098 0 -0.91448 -0.29713 Mabsadd L
.9098 0 -1.46946 -2.02254 Mabsadd L
.9098 0 0 -0.96154 Mabsadd L
.9098 0 1.46946 -2.02254 Mabsadd L
.9098 0 .91448 -0.29713 Mabsadd L
.9098 0 2.37764 .77254 Mabsadd L
.9098 0 .56518 .7779 Mabsadd L
.9098 0 0 2.5 Mabsadd L closepath F
.91373 0 0 2.5 Mabsadd m
.91373 0 -0.56518 .7779 Mabsadd L
.91373 0 -2.37764 .77254 Mabsadd L
.91373 0 -0.91448 -0.29713 Mabsadd L
.91373 0 -1.46946 -2.02254 Mabsadd L
.91373 0 0 -0.96154 Mabsadd L
.91373 0 1.46946 -2.02254 Mabsadd L
.91373 0 .91448 -0.29713 Mabsadd L
.91373 0 2.37764 .77254 Mabsadd L
.91373 0 .56518 .7779 Mabsadd L
.91373 0 0 2.5 Mabsadd L closepath F
.91765 0 0 2.5 Mabsadd m
.91765 0 -0.56518 .7779 Mabsadd L
.91765 0 -2.37764 .77254 Mabsadd L
.91765 0 -0.91448 -0.29713 Mabsadd L
.91765 0 -1.46946 -2.02254 Mabsadd L
.91765 0 0 -0.96154 Mabsadd L
.91765 0 1.46946 -2.02254 Mabsadd L
.91765 0 .91448 -0.29713 Mabsadd L
.91765 0 2.37764 .77254 Mabsadd L
.91765 0 .56518 .7779 Mabsadd L
.91765 0 0 2.5 Mabsadd L closepath F
.92157 0 0 2.5 Mabsadd m
.92157 0 -0.56518 .7779 Mabsadd L
.92157 0 -2.37764 .77254 Mabsadd L
.92157 0 -0.91448 -0.29713 Mabsadd L
.92157 0 -1.46946 -2.02254 Mabsadd L
.92157 0 0 -0.96154 Mabsadd L
.92157 0 1.46946 -2.02254 Mabsadd L
.92157 0 .91448 -0.29713 Mabsadd L
.92157 0 2.37764 .77254 Mabsadd L
.92157 0 .56518 .7779 Mabsadd L
.92157 0 0 2.5 Mabsadd L closepath F
.92549 0 0 2.5 Mabsadd m
.92549 0 -0.56518 .7779 Mabsadd L
.92549 0 -2.37764 .77254 Mabsadd L
.92549 0 -0.91448 -0.29713 Mabsadd L
.92549 0 -1.46946 -2.02254 Mabsadd L
.92549 0 0 -0.96154 Mabsadd L
.92549 0 1.46946 -2.02254 Mabsadd L
.92549 0 .91448 -0.29713 Mabsadd L
.92549 0 2.37764 .77254 Mabsadd L
.92549 0 .56518 .7779 Mabsadd L
.92549 0 0 2.5 Mabsadd L closepath F
.92941 0 0 2.5 Mabsadd m
.92941 0 -0.56518 .7779 Mabsadd L
.92941 0 -2.37764 .77254 Mabsadd L
.92941 0 -0.91448 -0.29713 Mabsadd L
.92941 0 -1.46946 -2.02254 Mabsadd L
.92941 0 0 -0.96154 Mabsadd L
.92941 0 1.46946 -2.02254 Mabsadd L
.92941 0 .91448 -0.29713 Mabsadd L
.92941 0 2.37764 .77254 Mabsadd L
.92941 0 .56518 .7779 Mabsadd L
.92941 0 0 2.5 Mabsadd L closepath F
.93333 0 0 2.5 Mabsadd m
.93333 0 -0.56518 .7779 Mabsadd L
.93333 0 -2.37764 .77254 Mabsadd L
.93333 0 -0.91448 -0.29713 Mabsadd L
.93333 0 -1.46946 -2.02254 Mabsadd L
.93333 0 0 -0.96154 Mabsadd L
.93333 0 1.46946 -2.02254 Mabsadd L
.93333 0 .91448 -0.29713 Mabsadd L
.93333 0 2.37764 .77254 Mabsadd L
.93333 0 .56518 .7779 Mabsadd L
.93333 0 0 2.5 Mabsadd L closepath F
.93725 0 0 2.5 Mabsadd m
.93725 0 -0.56518 .7779 Mabsadd L
.93725 0 -2.37764 .77254 Mabsadd L
.93725 0 -0.91448 -0.29713 Mabsadd L
.93725 0 -1.46946 -2.02254 Mabsadd L
.93725 0 0 -0.96154 Mabsadd L
.93725 0 1.46946 -2.02254 Mabsadd L
.93725 0 .91448 -0.29713 Mabsadd L
.93725 0 2.37764 .77254 Mabsadd L
.93725 0 .56518 .7779 Mabsadd L
.93725 0 0 2.5 Mabsadd L closepath F
.94118 0 0 2.5 Mabsadd m
.94118 0 -0.56518 .7779 Mabsadd L
.94118 0 -2.37764 .77254 Mabsadd L
.94118 0 -0.91448 -0.29713 Mabsadd L
.94118 0 -1.46946 -2.02254 Mabsadd L
.94118 0 0 -0.96154 Mabsadd L
.94118 0 1.46946 -2.02254 Mabsadd L
.94118 0 .91448 -0.29713 Mabsadd L
.94118 0 2.37764 .77254 Mabsadd L
.94118 0 .56518 .7779 Mabsadd L
.94118 0 0 2.5 Mabsadd L closepath F
.9451 0 0 2.5 Mabsadd m
.9451 0 -0.56518 .7779 Mabsadd L
.9451 0 -2.37764 .77254 Mabsadd L
.9451 0 -0.91448 -0.29713 Mabsadd L
.9451 0 -1.46946 -2.02254 Mabsadd L
.9451 0 0 -0.96154 Mabsadd L
.9451 0 1.46946 -2.02254 Mabsadd L
.9451 0 .91448 -0.29713 Mabsadd L
.9451 0 2.37764 .77254 Mabsadd L
.9451 0 .56518 .7779 Mabsadd L
.9451 0 0 2.5 Mabsadd L closepath F
.94902 0 0 2.5 Mabsadd m
.94902 0 -0.56518 .7779 Mabsadd L
.94902 0 -2.37764 .77254 Mabsadd L
.94902 0 -0.91448 -0.29713 Mabsadd L
.94902 0 -1.46946 -2.02254 Mabsadd L
.94902 0 0 -0.96154 Mabsadd L
.94902 0 1.46946 -2.02254 Mabsadd L
.94902 0 .91448 -0.29713 Mabsadd L
.94902 0 2.37764 .77254 Mabsadd L
.94902 0 .56518 .7779 Mabsadd L
.94902 0 0 2.5 Mabsadd L closepath F
.95294 0 0 2.5 Mabsadd m
.95294 0 -0.56518 .7779 Mabsadd L
.95294 0 -2.37764 .77254 Mabsadd L
.95294 0 -0.91448 -0.29713 Mabsadd L
.95294 0 -1.46946 -2.02254 Mabsadd L
.95294 0 0 -0.96154 Mabsadd L
.95294 0 1.46946 -2.02254 Mabsadd L
.95294 0 .91448 -0.29713 Mabsadd L
.95294 0 2.37764 .77254 Mabsadd L
.95294 0 .56518 .7779 Mabsadd L
.95294 0 0 2.5 Mabsadd L closepath F
.95686 0 0 2.5 Mabsadd m
.95686 0 -0.56518 .7779 Mabsadd L
.95686 0 -2.37764 .77254 Mabsadd L
.95686 0 -0.91448 -0.29713 Mabsadd L
.95686 0 -1.46946 -2.02254 Mabsadd L
.95686 0 0 -0.96154 Mabsadd L
.95686 0 1.46946 -2.02254 Mabsadd L
.95686 0 .91448 -0.29713 Mabsadd L
.95686 0 2.37764 .77254 Mabsadd L
.95686 0 .56518 .7779 Mabsadd L
.95686 0 0 2.5 Mabsadd L closepath F
.96078 0 0 2.5 Mabsadd m
.96078 0 -0.56518 .7779 Mabsadd L
.96078 0 -2.37764 .77254 Mabsadd L
.96078 0 -0.91448 -0.29713 Mabsadd L
.96078 0 -1.46946 -2.02254 Mabsadd L
.96078 0 0 -0.96154 Mabsadd L
.96078 0 1.46946 -2.02254 Mabsadd L
.96078 0 .91448 -0.29713 Mabsadd L
.96078 0 2.37764 .77254 Mabsadd L
.96078 0 .56518 .7779 Mabsadd L
.96078 0 0 2.5 Mabsadd L closepath F
.96471 0 0 2.5 Mabsadd m
.96471 0 -0.56518 .7779 Mabsadd L
.96471 0 -2.37764 .77254 Mabsadd L
.96471 0 -0.91448 -0.29713 Mabsadd L
.96471 0 -1.46946 -2.02254 Mabsadd L
.96471 0 0 -0.96154 Mabsadd L
.96471 0 1.46946 -2.02254 Mabsadd L
.96471 0 .91448 -0.29713 Mabsadd L
.96471 0 2.37764 .77254 Mabsadd L
.96471 0 .56518 .7779 Mabsadd L
.96471 0 0 2.5 Mabsadd L closepath F
.96863 0 0 2.5 Mabsadd m
.96863 0 -0.56518 .7779 Mabsadd L
.96863 0 -2.37764 .77254 Mabsadd L
.96863 0 -0.91448 -0.29713 Mabsadd L
.96863 0 -1.46946 -2.02254 Mabsadd L
.96863 0 0 -0.96154 Mabsadd L
.96863 0 1.46946 -2.02254 Mabsadd L
.96863 0 .91448 -0.29713 Mabsadd L
.96863 0 2.37764 .77254 Mabsadd L
.96863 0 .56518 .7779 Mabsadd L
.96863 0 0 2.5 Mabsadd L closepath F
.97255 0 0 2.5 Mabsadd m
.97255 0 -0.56518 .7779 Mabsadd L
.97255 0 -2.37764 .77254 Mabsadd L
.97255 0 -0.91448 -0.29713 Mabsadd L
.97255 0 -1.46946 -2.02254 Mabsadd L
.97255 0 0 -0.96154 Mabsadd L
.97255 0 1.46946 -2.02254 Mabsadd L
.97255 0 .91448 -0.29713 Mabsadd L
.97255 0 2.37764 .77254 Mabsadd L
.97255 0 .56518 .7779 Mabsadd L
.97255 0 0 2.5 Mabsadd L closepath F
.97647 0 0 2.5 Mabsadd m
.97647 0 -0.56518 .7779 Mabsadd L
.97647 0 -2.37764 .77254 Mabsadd L
.97647 0 -0.91448 -0.29713 Mabsadd L
.97647 0 -1.46946 -2.02254 Mabsadd L
.97647 0 0 -0.96154 Mabsadd L
.97647 0 1.46946 -2.02254 Mabsadd L
.97647 0 .91448 -0.29713 Mabsadd L
.97647 0 2.37764 .77254 Mabsadd L
.97647 0 .56518 .7779 Mabsadd L
.97647 0 0 2.5 Mabsadd L closepath F
.98039 0 0 2.5 Mabsadd m
.98039 0 -0.56518 .7779 Mabsadd L
.98039 0 -2.37764 .77254 Mabsadd L
.98039 0 -0.91448 -0.29713 Mabsadd L
.98039 0 -1.46946 -2.02254 Mabsadd L
.98039 0 0 -0.96154 Mabsadd L
.98039 0 1.46946 -2.02254 Mabsadd L
.98039 0 .91448 -0.29713 Mabsadd L
.98039 0 2.37764 .77254 Mabsadd L
.98039 0 .56518 .7779 Mabsadd L
.98039 0 0 2.5 Mabsadd L closepath F
.98431 0 0 2.5 Mabsadd m
.98431 0 -0.56518 .7779 Mabsadd L
.98431 0 -2.37764 .77254 Mabsadd L
.98431 0 -0.91448 -0.29713 Mabsadd L
.98431 0 -1.46946 -2.02254 Mabsadd L
.98431 0 0 -0.96154 Mabsadd L
.98431 0 1.46946 -2.02254 Mabsadd L
.98431 0 .91448 -0.29713 Mabsadd L
.98431 0 2.37764 .77254 Mabsadd L
.98431 0 .56518 .7779 Mabsadd L
.98431 0 0 2.5 Mabsadd L closepath F
.98824 0 0 2.5 Mabsadd m
.98824 0 -0.56518 .7779 Mabsadd L
.98824 0 -2.37764 .77254 Mabsadd L
.98824 0 -0.91448 -0.29713 Mabsadd L
.98824 0 -1.46946 -2.02254 Mabsadd L
.98824 0 0 -0.96154 Mabsadd L
.98824 0 1.46946 -2.02254 Mabsadd L
.98824 0 .91448 -0.29713 Mabsadd L
.98824 0 2.37764 .77254 Mabsadd L
.98824 0 .56518 .7779 Mabsadd L
.98824 0 0 2.5 Mabsadd L closepath F
.99216 0 0 2.5 Mabsadd m
.99216 0 -0.56518 .7779 Mabsadd L
.99216 0 -2.37764 .77254 Mabsadd L
.99216 0 -0.91448 -0.29713 Mabsadd L
.99216 0 -1.46946 -2.02254 Mabsadd L
.99216 0 0 -0.96154 Mabsadd L
.99216 0 1.46946 -2.02254 Mabsadd L
.99216 0 .91448 -0.29713 Mabsadd L
.99216 0 2.37764 .77254 Mabsadd L
.99216 0 .56518 .7779 Mabsadd L
.99216 0 0 2.5 Mabsadd L closepath F
.99608 0 0 2.5 Mabsadd m
.99608 0 -0.56518 .7779 Mabsadd L
.99608 0 -2.37764 .77254 Mabsadd L
.99608 0 -0.91448 -0.29713 Mabsadd L
.99608 0 -1.46946 -2.02254 Mabsadd L
.99608 0 0 -0.96154 Mabsadd L
.99608 0 1.46946 -2.02254 Mabsadd L
.99608 0 .91448 -0.29713 Mabsadd L
.99608 0 2.37764 .77254 Mabsadd L
.99608 0 .56518 .7779 Mabsadd L
.99608 0 0 2.5 Mabsadd L closepath F
1 0 0 2.5 Mabsadd m
1 0 -0.56518 .7779 Mabsadd L
1 0 -2.37764 .77254 Mabsadd L
1 0 -0.91448 -0.29713 Mabsadd L
1 0 -1.46946 -2.02254 Mabsadd L
1 0 0 -0.96154 Mabsadd L
1 0 1.46946 -2.02254 Mabsadd L
1 0 .91448 -0.29713 Mabsadd L
1 0 2.37764 .77254 Mabsadd L
1 0 .56518 .7779 Mabsadd L
1 0 0 2.5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .38707 L
.97619 .38707 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .40321 L
.96005 .40321 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .40321 L
.70178 .40321 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.403208 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
0 1 1 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y1) show
75.000 15.188 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
79.688 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 0 r
.05357 .39881 m
.05357 .69643 L
.35119 .69643 L
.35119 .39881 L
F
0 g
gsave
.38988 .54762 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y2) show
75.000 15.188 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
79.688 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00;@3oool2000000@0oooo0P00
00030?ooo`@000002`3oool2000000@0oooo0P0000050?ooo`<000002@3oool2000000@0oooo0P00
00030?ooo`<00000303oool2000000@0oooo0P0000040?ooo`800000403oool5000008<0oooo000/
0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool02`3oool010000000oooo0?oo
o`00000;0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`00000:0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000004@3o
ool00`000000oooo0?ooo`230?ooo`00;03oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00X0oooo00@000000?ooo`3oool00000203oool5000000P0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000:0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000004@3oool00`000000oooo0?ooo`230?ooo`00;03oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000090?ooo`040000003oool0oooo000000P0oooo0`00000;0?ooo`040000003oool0oooo
000000T0oooo0P00000B0?ooo`030000003oool0oooo08<0oooo000/0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000002P3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0000000T0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000004@3oool00`000000oooo0?ooo`23
0?ooo`00;@3oool2000000X0oooo0P00000<0?ooo`8000002`3oool2000000X0oooo0P00000:0?oo
o`<000002`3oool2000000X0oooo0P00000A0?ooo`800000Q@3oool00?l0oooo8@3oool00:H0oooo
00<000000?ooo`3oool0M`3oool003T0ooooH`0000050?ooo`<000000`3oool00`000000oooo0?oo
o`020?ooo`@000000`3oool2000000@0oooo0P00001U0?ooo`006`3ooon1000000H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`00001T0?ooo`006`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool010000000oooo0?oo
o`3ooom[000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1R0?ooo`006`3o
ool00`000000oooo0?ooo`0C0?ooofX000001P3oool2000000D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`800000103oool2000006D0oooo000K0?ooo`030000003oool0
oooo0180oooo1`0000020?ooo`X00000I@3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo06@0oooo000K0?ooo`030000003o
ool0oooo0140oooo1@0000040?ooo`L00000H`3oool00`000000oooo0?ooo`040?ooo`040000003o
ool0oooo0?ooo`800000103oool3000000<0oooo0`00001T0?ooo`006`3oool00`000000oooo0?oo
o`0@0?ooo`D00000103oool600000><0oooo000K0?ooo`030000003oool0oooo00l0oooo1@000004
0?ooo`D00000i@3oool001/0oooo00<000000?ooo`3oool03`3oool4000000@0oooo1@00003V0?oo
o`006`3oool00`000000oooo0?ooo`0>0?ooo`D000000`3oool500000>L0oooo000K0?ooo`030000
003oool0oooo00h0oooo100000030?ooo`D00000j03oool001/0oooo00<000000?ooo`3oool03@3o
ool5000000<0oooo1000003Y0?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`@000000`3oool4
00000>X0oooo000K0?ooo`030000003oool0oooo00`0oooo1@0000030?ooo`@00000jP3oool001/0
oooo00<000000?ooo`3oool0303oool4000000<0oooo1000003[0?ooo`002@3oool2000000@0oooo
0P0000030?ooo`@000000`3oool00`000000oooo0?ooo`0;0?ooo`D000000`3oool300000>`0oooo
00080?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0<0?ooo`800000103oool400000>`0oooo00080?ooo`040000003oool0oooo000000T0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`@000000`3oool300000>d0oooo
00080?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0:0?ooo`D000000P3oool400000>d0oooo00080?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0;0?ooo`800000103oool300000>h0
oooo00090?ooo`8000002P3oool2000000@0oooo00<000000?ooo`3oool02P3oool400000080oooo
1000003^0?ooo`006`3oool00`000000oooo0?ooo`0;0?ooo`800000103oool300000>h0oooo000K
0?ooo`030000003oool0oooo00T0oooo1@0000020?ooo`<00000k`3oool001/0oooo00<000000?oo
o`3oool02P3oool2000000<0oooo1000003_0?ooo`006`3oool00`000000oooo0?ooo`090?ooo`@0
00000P3oool300000?00oooo000K0?ooo`030000003oool0oooo00X0oooo0P0000030?ooo`<00000
l03oool001/0oooo00<000000?ooo`3oool0203oool5000000030?ooo`000000000000800000l03o
ool001/0oooo00<000000?ooo`3oool02@3oool2000000<0oooo0`00003a0?ooo`006`3oool00`00
0000oooo0?ooo`080?ooo`@000000P3oool300000?40oooo000K0?ooo`030000003oool0oooo00T0
oooo0P0000020?ooo`@00000l@3oool001/0oooo00<000000?ooo`3oool01`3oool5000000040?oo
o`000000000000000?80oooo00090?ooo`800000103oool2000000D0oooo0`0000020?ooo`030000
003oool0oooo00P0oooo0P0000030?ooo`<00000lP3oool000P0oooo00@000000?ooo`3oool00000
2`3oool01@000000oooo0?ooo`3oool0000000T0oooo100000000`3oool000000000000200000?80
oooo00080?ooo`040000003oool0oooo000000P0oooo1@0000020?ooo`030000003oool0oooo00P0
oooo0P0000030?ooo`<00000lP3oool000P0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo0P0000020?ooo`<00000X03ooom:0000
00T0oooo00080?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`060?ooo`T00000X03ooom:000000T0oooo00090?ooo`8000002`3oool2000000<0
oooo00<000000?ooo`3oool01`3oool2000000<0oooo0`00002P0?ooodX000002@3oool001/0oooo
00<000000?ooo`3oool01P3oool4000000040?ooo`000000000000000:40ooooBP0000090?ooo`00
6`3oool00`000000oooo0?ooo`070?ooo`8000000P3oool3000009d0ooooCP0000090?ooo`006`3o
ool00`000000oooo0?ooo`070?ooo`80000000<0oooo0000000000000P00002M0?ooo`030000003o
ool0oooo04H0oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`050?ooo`D0000000<0oooo
000000000000WP3oool00`000000oooo0?ooo`160?ooo`D000002@3oool001/0oooo00<000000?oo
o`3oool01P3oool200000080oooo0`00002N0?ooo`030000003oool0oooo04H0oooo1@0000090?oo
o`006`3oool00`000000oooo0?ooo`050?ooo`@0000000@0oooo0000000000000000WP3oool00`00
0000oooo0?ooo`160?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool01P3oool200000003
0?ooo`000000000000800000WP3oool010000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?oo
o`006`3oool00`000000oooo0?ooo`060?ooo`80000000@0oooo0000000000000000W`3oool01000
0000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`040?oo
o`P00000W`3oool010000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`006`3oool00`00
0000oooo0?ooo`050?ooo`80000000<0oooo0000000000000P00002O0?ooo`040000003oool0oooo
0?oooaD00?oo<03oool5000000T0oooo00090?ooo`800000103oool2000000<0oooo0`0000040?oo
o`030000003oool0oooo00@0oooo10000000103oool0000000000000002O0?ooo`040000003oool0
oooo0?oooaD00?oo<03oool5000000T0oooo00080?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`80000000@0oooo000000000000
0000X03oool010000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`00203oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool2
000000040?ooo`000000000000000:00oooo00@000000?ooo`3oool0oooo5@00ool60?ooo`800000
2P3oool3000001/0oooo1@0000090?ooo`00203oool010000000oooo0?ooo`0000080?ooo`<00000
103oool00`000000oooo0?ooo`030?ooo`P00000X03oool010000000oooo0?ooo`3ooolE003oo`L0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0J0?ooo`D000002@3oool000P0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo0`000000103oool0000000000000002P0?ooo`040000003oool0oooo0?oooaD00?oo203oool0
10000000oooo0?ooo`3oool5000000030?ooo`000000000001`0oooo1@0000090?ooo`002@3oool2
000000X0oooo0`0000030?ooo`030000003oool0oooo00@0oooo0P000000103oool0000000000000
002Q0?ooo`040000003oool0oooo0?oooaD00?oo1`3oool00`000000oooo000000040?ooo`030000
003oool0oooo01l0oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`030?ooo`L00000X@3o
ool010000000oooo0?ooo`3ooolE003oo`H0oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`0O0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0103oool600000:40oooo
00@000000?ooo`3oool0oooo5@00ool50?ooo`<0000000<0oooo0000000000000`3oool00`000000
oooo0?ooo`0O0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool00P3oool700000:80oooo
00@000000?ooo`3oool0oooo5@00ool>0?ooo`030000003oool0oooo01l0oooo1@0000090?ooo`00
6`3oool00`000000oooo0?ooo`030?ooo`H00000XP3oool010000000oooo0?ooo`3ooolE003oo`d0
oooo0P00000Q0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool00`3oool2000000040?oo
o`000000000000000:80oooo00@000000?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool001/0
oooo00<000000?ooo`3oool00P3oool700000:80oooo00@000000?ooo`3oool0oooo5@00ool`0?oo
o`D000002@3oool001/0oooo00<000000?ooo`3oool00`3oool500000:<0oooo00@000000?ooo`3o
ool0oooo5@00ool`0?ooo`D000002@3oool001/0oooo00@000000?ooo`3oool0oooo1`00002S0?oo
o`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo000K0?ooo`030000003oool0oooo
0080oooo1P00002S0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo00090?oo
o`800000103oool2000000@0oooo0P0000040?ooo`030000003oool0oooo0080oooo0P000000103o
ool0000000000000002S0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo0008
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool010000000oooo
0?ooo`3oool600000:@0oooo00@000000?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool000P0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo0080oooo1@00002T0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo0008
0?ooo`040000003oool0oooo000000T0oooo0P0000040?ooo`030000003oool0oooo00L00000Y03o
ool00`000000oooo0?ooo`160?ooo`D000002@3oool000P0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0?ooo`D00000Y@3oool00`000000
oooo0?ooo`160?ooo`D000002@3oool000T0oooo0P00000:0?ooo`800000103oool010000000oooo
0?ooo`3oool500000:D0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo000K0?ooo`030000
003oool0oooo00H00000Y@3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00
6`3oool010000000oooo0?ooo`3oool400000:H0oooo00@000000?ooo`3oool0oooo5@3o000`0?oo
o`D000002@3oool001/0oooo00<000000?ooo`0000001@00002V0?ooo`040000003oool0oooo0?oo
oaD0o`00<03oool5000000T0oooo000K0?ooo`030000003oool0oooo00D00000YP3oool010000000
oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`006`3oool00`000000oooo0000000400000:L0
oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool001/0oooo00<000000?ooo`00
00001000002W0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000K0?ooo`L0
0000Y`3oool010000000oooo0?ooo`3ooolE0?l00180oooo0`00000K0?ooo`D000002@3oool001/0
oooo1P00002X0?ooo`040000003oool0oooo0?oooaD0o`001P3oool2000000/0oooo00<000000?oo
o`3oool06P3oool5000000T0oooo000K0?ooo`H00000Z03oool010000000oooo0?ooo`3ooolE0?l0
00L0oooo00<000000?ooo`3oool0203oool2000001`0oooo1@0000090?ooo`006`3oool500000:T0
oooo00@000000?ooo`3oool0oooo5@3o00080?ooo`040000003oool0oooo0?ooo`@00000803oool5
000000T0oooo000D0?ooo`D000000P3oool500000:T0oooo00@000000?ooo`3oool0oooo5@3o0007
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool08@3oool5000000T0oooo000F0?oo
o`040000003oool0oooo0?ooo`D00000ZP3oool010000000oooo0?ooo`3ooolE0?l000H0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`0P0?ooo`D000002@3oool001H0oooo00<0
00000?ooo`3oool01P00002Z0?ooo`040000003oool0oooo0?oooaD0o`001@3oool3000000030?oo
o`000000000000<0oooo00<000000?ooo`3oool07`3oool5000000T0oooo000F0?ooo`030000003o
ool0000000D00000Z`3oool010000000oooo0?ooo`3ooolE0?l000`0oooo00@000000?ooo`3oool0
0000803oool5000000T0oooo000F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
Z`3oool010000000oooo0?ooo`3ooolE0?l000d0oooo0P00000Q0?ooo`D000002@3oool001D0oooo
0P00002b0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00390?ooo`040000
003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00390?ooo`040000003oool0oooo0?oooaD0
o`00<03oool5000000T0oooo00390?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0
oooo00390?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00390?ooo`040000
003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00390?ooo`040000003oool0oooo0?oooaD0
o`00<03oool00`000000oooo0?ooo`0;0?ooo`00b@3oool00`000000oooo0?ooo`160?ooo`030000
003oool0oooo00/0oooo00390?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool02`3o
ool00<T0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0;0?ooo`00b@3ooom:0000
00d0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-0.212366, \
-0.297564, 0.00783766, 0.0126816}, {{201.063, 274.813}, {59.8125, 4.5}} -> \
{-9.26038, -2.82506, 0.0455598, 0.0455598}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.20924e-017 0.00333333 0 0.206011 [
[.16667 -0.0125 -6 -9 ]
[.16667 -0.0125 6 0 ]
[.33333 -0.0125 -9 -9 ]
[.33333 -0.0125 9 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.66667 -0.0125 -9 -9 ]
[.66667 -0.0125 9 0 ]
[.83333 -0.0125 -9 -9 ]
[.83333 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 10 6.28125 ]
[-0.0125 .10301 -18 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 0 m
.16667 .00625 L
s
[(50)] .16667 -0.0125 0 1 Mshowa
.33333 0 m
.33333 .00625 L
s
[(100)] .33333 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(150)] .5 -0.0125 0 1 Mshowa
.66667 0 m
.66667 .00625 L
s
[(200)] .66667 -0.0125 0 1 Mshowa
.83333 0 m
.83333 .00625 L
s
[(250)] .83333 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(300)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.03333 0 m
.03333 .00375 L
s
.06667 0 m
.06667 .00375 L
s
.1 0 m
.1 .00375 L
s
.13333 0 m
.13333 .00375 L
s
.2 0 m
.2 .00375 L
s
.23333 0 m
.23333 .00375 L
s
.26667 0 m
.26667 .00375 L
s
.3 0 m
.3 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.4 0 m
.4 .00375 L
s
.43333 0 m
.43333 .00375 L
s
.46667 0 m
.46667 .00375 L
s
.53333 0 m
.53333 .00375 L
s
.56667 0 m
.56667 .00375 L
s
.6 0 m
.6 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.7 0 m
.7 .00375 L
s
.73333 0 m
.73333 .00375 L
s
.76667 0 m
.76667 .00375 L
s
.8 0 m
.8 .00375 L
s
.86667 0 m
.86667 .00375 L
s
.9 0 m
.9 .00375 L
s
.93333 0 m
.93333 .00375 L
s
.96667 0 m
.96667 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .10301 m
.00625 .10301 L
s
[(0.5)] -0.0125 .10301 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(1)] -0.0125 .20601 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(1.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(2)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(2.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(3)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.001 w
0 .29741 m
.00333 .27027 L
.00667 .20311 L
.01 .12697 L
.01333 .06717 L
.01667 .03159 L
.02 .015 L
.02333 .00884 L
.02667 .00699 L
.03 .00654 L
.03333 .00645 L
.03667 .00644 L
.04 .00644 L
.04333 .00644 L
.04667 .00644 L
.05 .00644 L
.05333 .00644 L
.05667 .00644 L
.06 .00644 L
.06333 .00644 L
.06667 .00644 L
.07 .00644 L
.07333 .00644 L
.07667 .00644 L
.08 .00644 L
.08333 .00644 L
.08667 .00644 L
.09 .00644 L
.09333 .00644 L
.09667 .00644 L
.1 .00644 L
.10333 .00644 L
.10667 .00644 L
.11 .00644 L
.11333 .00644 L
.11667 .00644 L
.12 .00644 L
.12333 .00644 L
.12667 .00644 L
.13 .00644 L
.13333 .00644 L
.13667 .00644 L
.14 .00644 L
.14333 .00644 L
.14667 .00644 L
.15 .00644 L
.15333 .00644 L
.15667 .00644 L
.16 .00644 L
.16333 .00644 L
Mistroke
.16667 .00644 L
.17 .00644 L
.17333 .00644 L
.17667 .00644 L
.18 .00644 L
.18333 .00644 L
.18667 .00644 L
.19 .00644 L
.19333 .00644 L
.19667 .00644 L
.2 .00644 L
.20333 .00644 L
.20667 .00644 L
.21 .00644 L
.21333 .00644 L
.21667 .00644 L
.22 .00644 L
.22333 .00644 L
.22667 .00644 L
.23 .00644 L
.23333 .00644 L
.23667 .00644 L
.24 .00644 L
.24333 .00644 L
.24667 .00644 L
.25 .00644 L
.25333 .00644 L
.25667 .00644 L
.26 .00644 L
.26333 .00644 L
.26667 .00644 L
.27 .00644 L
.27333 .00644 L
.27667 .00644 L
.28 .00644 L
.28333 .00644 L
.28667 .00644 L
.29 .00644 L
.29333 .00644 L
.29667 .00644 L
.3 .00644 L
.30333 .00644 L
.30667 .00644 L
.31 .00644 L
.31333 .00644 L
.31667 .00644 L
.32 .00644 L
.32333 .00644 L
.32667 .00644 L
.33 .00644 L
Mistroke
.33333 .00644 L
.33667 .00644 L
.34 .00644 L
.34333 .00644 L
.34667 .00644 L
.35 .00644 L
.35333 .00644 L
.35667 .00644 L
.36 .00644 L
.36333 .00644 L
.36667 .00644 L
.37 .00644 L
.37333 .00644 L
.37667 .00644 L
.38 .00644 L
.38333 .00644 L
.38667 .00644 L
.39 .00644 L
.39333 .00644 L
.39667 .00644 L
.4 .00644 L
.40333 .00644 L
.40667 .00644 L
.41 .00644 L
.41333 .00644 L
.41667 .00644 L
.42 .00644 L
.42333 .00644 L
.42667 .00644 L
.43 .00644 L
.43333 .00644 L
.43667 .00644 L
.44 .00644 L
.44333 .00644 L
.44667 .00644 L
.45 .00644 L
.45333 .00644 L
.45667 .00644 L
.46 .00644 L
.46333 .00644 L
.46667 .00644 L
.47 .00644 L
.47333 .00644 L
.47667 .00644 L
.48 .00644 L
.48333 .00644 L
.48667 .00644 L
.49 .00644 L
.49333 .00644 L
.49667 .00644 L
Mistroke
.5 .00644 L
.50333 .00644 L
.50667 .00644 L
.51 .00644 L
.51333 .00644 L
.51667 .00644 L
.52 .00644 L
.52333 .00644 L
.52667 .00644 L
.53 .00644 L
.53333 .00644 L
.53667 .00644 L
.54 .00644 L
.54333 .00644 L
.54667 .00644 L
.55 .00644 L
.55333 .00644 L
.55667 .00644 L
.56 .00644 L
.56333 .00644 L
.56667 .00644 L
.57 .00644 L
.57333 .00644 L
.57667 .00644 L
.58 .00644 L
.58333 .00644 L
.58667 .00644 L
.59 .00644 L
.59333 .00644 L
.59667 .00644 L
.6 .00644 L
.60333 .00644 L
.60667 .00644 L
.61 .00644 L
.61333 .00644 L
.61667 .00644 L
.62 .00644 L
.62333 .00644 L
.62667 .00644 L
.63 .00644 L
.63333 .00644 L
.63667 .00644 L
.64 .00644 L
.64333 .00644 L
.64667 .00644 L
.65 .00644 L
.65333 .00644 L
.65667 .00644 L
.66 .00644 L
.66333 .00644 L
Mistroke
.66667 .00644 L
.67 .00644 L
.67333 .00644 L
.67667 .00644 L
.68 .00644 L
.68333 .00644 L
.68667 .00644 L
.69 .00644 L
.69333 .00644 L
.69667 .00644 L
.7 .00644 L
.70333 .00644 L
.70667 .00644 L
.71 .00644 L
.71333 .00644 L
.71667 .00644 L
.72 .00644 L
.72333 .00644 L
.72667 .00644 L
.73 .00644 L
.73333 .00644 L
.73667 .00644 L
.74 .00644 L
.74333 .00644 L
.74667 .00644 L
.75 .00644 L
.75333 .00644 L
.75667 .00644 L
.76 .00644 L
.76333 .00644 L
.76667 .00644 L
.77 .00644 L
.77333 .00644 L
.77667 .00644 L
.78 .00644 L
.78333 .00644 L
.78667 .00644 L
.79 .00644 L
.79333 .00644 L
.79667 .00644 L
.8 .00644 L
.80333 .00644 L
.80667 .00644 L
.81 .00644 L
.81333 .00644 L
.81667 .00644 L
.82 .00645 L
.82333 .00654 L
.82667 .00699 L
.83 .00884 L
Mistroke
.83333 .015 L
.83667 .03159 L
.84 .06717 L
.84333 .12697 L
.84667 .20311 L
.85 .27027 L
Mfstroke
0 g
.0001 w
0 .29741 -1.875 0 Mabsadd m
0 .29741 0 2.5 Mabsadd L
0 .29741 1.875 0 Mabsadd L
0 .29741 0 -2.5 Mabsadd L
0 .29741 -1.875 0 Mabsadd L closepath F
.00333 .27027 -1.875 0 Mabsadd m
.00333 .27027 0 2.5 Mabsadd L
.00333 .27027 1.875 0 Mabsadd L
.00333 .27027 0 -2.5 Mabsadd L
.00333 .27027 -1.875 0 Mabsadd L closepath F
.00667 .20311 -1.875 0 Mabsadd m
.00667 .20311 0 2.5 Mabsadd L
.00667 .20311 1.875 0 Mabsadd L
.00667 .20311 0 -2.5 Mabsadd L
.00667 .20311 -1.875 0 Mabsadd L closepath F
.01 .12697 -1.875 0 Mabsadd m
.01 .12697 0 2.5 Mabsadd L
.01 .12697 1.875 0 Mabsadd L
.01 .12697 0 -2.5 Mabsadd L
.01 .12697 -1.875 0 Mabsadd L closepath F
.01333 .06717 -1.875 0 Mabsadd m
.01333 .06717 0 2.5 Mabsadd L
.01333 .06717 1.875 0 Mabsadd L
.01333 .06717 0 -2.5 Mabsadd L
.01333 .06717 -1.875 0 Mabsadd L closepath F
.01667 .03159 -1.875 0 Mabsadd m
.01667 .03159 0 2.5 Mabsadd L
.01667 .03159 1.875 0 Mabsadd L
.01667 .03159 0 -2.5 Mabsadd L
.01667 .03159 -1.875 0 Mabsadd L closepath F
.02 .015 -1.875 0 Mabsadd m
.02 .015 0 2.5 Mabsadd L
.02 .015 1.875 0 Mabsadd L
.02 .015 0 -2.5 Mabsadd L
.02 .015 -1.875 0 Mabsadd L closepath F
.02333 .00884 -1.875 0 Mabsadd m
.02333 .00884 0 2.5 Mabsadd L
.02333 .00884 1.875 0 Mabsadd L
.02333 .00884 0 -2.5 Mabsadd L
.02333 .00884 -1.875 0 Mabsadd L closepath F
.02667 .00699 -1.875 0 Mabsadd m
.02667 .00699 0 2.5 Mabsadd L
.02667 .00699 1.875 0 Mabsadd L
.02667 .00699 0 -2.5 Mabsadd L
.02667 .00699 -1.875 0 Mabsadd L closepath F
.03 .00654 -1.875 0 Mabsadd m
.03 .00654 0 2.5 Mabsadd L
.03 .00654 1.875 0 Mabsadd L
.03 .00654 0 -2.5 Mabsadd L
.03 .00654 -1.875 0 Mabsadd L closepath F
.03333 .00645 -1.875 0 Mabsadd m
.03333 .00645 0 2.5 Mabsadd L
.03333 .00645 1.875 0 Mabsadd L
.03333 .00645 0 -2.5 Mabsadd L
.03333 .00645 -1.875 0 Mabsadd L closepath F
.03667 .00644 -1.875 0 Mabsadd m
.03667 .00644 0 2.5 Mabsadd L
.03667 .00644 1.875 0 Mabsadd L
.03667 .00644 0 -2.5 Mabsadd L
.03667 .00644 -1.875 0 Mabsadd L closepath F
.04 .00644 -1.875 0 Mabsadd m
.04 .00644 0 2.5 Mabsadd L
.04 .00644 1.875 0 Mabsadd L
.04 .00644 0 -2.5 Mabsadd L
.04 .00644 -1.875 0 Mabsadd L closepath F
.04333 .00644 -1.875 0 Mabsadd m
.04333 .00644 0 2.5 Mabsadd L
.04333 .00644 1.875 0 Mabsadd L
.04333 .00644 0 -2.5 Mabsadd L
.04333 .00644 -1.875 0 Mabsadd L closepath F
.04667 .00644 -1.875 0 Mabsadd m
.04667 .00644 0 2.5 Mabsadd L
.04667 .00644 1.875 0 Mabsadd L
.04667 .00644 0 -2.5 Mabsadd L
.04667 .00644 -1.875 0 Mabsadd L closepath F
.05 .00644 -1.875 0 Mabsadd m
.05 .00644 0 2.5 Mabsadd L
.05 .00644 1.875 0 Mabsadd L
.05 .00644 0 -2.5 Mabsadd L
.05 .00644 -1.875 0 Mabsadd L closepath F
.05333 .00644 -1.875 0 Mabsadd m
.05333 .00644 0 2.5 Mabsadd L
.05333 .00644 1.875 0 Mabsadd L
.05333 .00644 0 -2.5 Mabsadd L
.05333 .00644 -1.875 0 Mabsadd L closepath F
.05667 .00644 -1.875 0 Mabsadd m
.05667 .00644 0 2.5 Mabsadd L
.05667 .00644 1.875 0 Mabsadd L
.05667 .00644 0 -2.5 Mabsadd L
.05667 .00644 -1.875 0 Mabsadd L closepath F
.06 .00644 -1.875 0 Mabsadd m
.06 .00644 0 2.5 Mabsadd L
.06 .00644 1.875 0 Mabsadd L
.06 .00644 0 -2.5 Mabsadd L
.06 .00644 -1.875 0 Mabsadd L closepath F
.06333 .00644 -1.875 0 Mabsadd m
.06333 .00644 0 2.5 Mabsadd L
.06333 .00644 1.875 0 Mabsadd L
.06333 .00644 0 -2.5 Mabsadd L
.06333 .00644 -1.875 0 Mabsadd L closepath F
.06667 .00644 -1.875 0 Mabsadd m
.06667 .00644 0 2.5 Mabsadd L
.06667 .00644 1.875 0 Mabsadd L
.06667 .00644 0 -2.5 Mabsadd L
.06667 .00644 -1.875 0 Mabsadd L closepath F
.07 .00644 -1.875 0 Mabsadd m
.07 .00644 0 2.5 Mabsadd L
.07 .00644 1.875 0 Mabsadd L
.07 .00644 0 -2.5 Mabsadd L
.07 .00644 -1.875 0 Mabsadd L closepath F
.07333 .00644 -1.875 0 Mabsadd m
.07333 .00644 0 2.5 Mabsadd L
.07333 .00644 1.875 0 Mabsadd L
.07333 .00644 0 -2.5 Mabsadd L
.07333 .00644 -1.875 0 Mabsadd L closepath F
.07667 .00644 -1.875 0 Mabsadd m
.07667 .00644 0 2.5 Mabsadd L
.07667 .00644 1.875 0 Mabsadd L
.07667 .00644 0 -2.5 Mabsadd L
.07667 .00644 -1.875 0 Mabsadd L closepath F
.08 .00644 -1.875 0 Mabsadd m
.08 .00644 0 2.5 Mabsadd L
.08 .00644 1.875 0 Mabsadd L
.08 .00644 0 -2.5 Mabsadd L
.08 .00644 -1.875 0 Mabsadd L closepath F
.08333 .00644 -1.875 0 Mabsadd m
.08333 .00644 0 2.5 Mabsadd L
.08333 .00644 1.875 0 Mabsadd L
.08333 .00644 0 -2.5 Mabsadd L
.08333 .00644 -1.875 0 Mabsadd L closepath F
.08667 .00644 -1.875 0 Mabsadd m
.08667 .00644 0 2.5 Mabsadd L
.08667 .00644 1.875 0 Mabsadd L
.08667 .00644 0 -2.5 Mabsadd L
.08667 .00644 -1.875 0 Mabsadd L closepath F
.09 .00644 -1.875 0 Mabsadd m
.09 .00644 0 2.5 Mabsadd L
.09 .00644 1.875 0 Mabsadd L
.09 .00644 0 -2.5 Mabsadd L
.09 .00644 -1.875 0 Mabsadd L closepath F
.09333 .00644 -1.875 0 Mabsadd m
.09333 .00644 0 2.5 Mabsadd L
.09333 .00644 1.875 0 Mabsadd L
.09333 .00644 0 -2.5 Mabsadd L
.09333 .00644 -1.875 0 Mabsadd L closepath F
.09667 .00644 -1.875 0 Mabsadd m
.09667 .00644 0 2.5 Mabsadd L
.09667 .00644 1.875 0 Mabsadd L
.09667 .00644 0 -2.5 Mabsadd L
.09667 .00644 -1.875 0 Mabsadd L closepath F
.1 .00644 -1.875 0 Mabsadd m
.1 .00644 0 2.5 Mabsadd L
.1 .00644 1.875 0 Mabsadd L
.1 .00644 0 -2.5 Mabsadd L
.1 .00644 -1.875 0 Mabsadd L closepath F
.10333 .00644 -1.875 0 Mabsadd m
.10333 .00644 0 2.5 Mabsadd L
.10333 .00644 1.875 0 Mabsadd L
.10333 .00644 0 -2.5 Mabsadd L
.10333 .00644 -1.875 0 Mabsadd L closepath F
.10667 .00644 -1.875 0 Mabsadd m
.10667 .00644 0 2.5 Mabsadd L
.10667 .00644 1.875 0 Mabsadd L
.10667 .00644 0 -2.5 Mabsadd L
.10667 .00644 -1.875 0 Mabsadd L closepath F
.11 .00644 -1.875 0 Mabsadd m
.11 .00644 0 2.5 Mabsadd L
.11 .00644 1.875 0 Mabsadd L
.11 .00644 0 -2.5 Mabsadd L
.11 .00644 -1.875 0 Mabsadd L closepath F
.11333 .00644 -1.875 0 Mabsadd m
.11333 .00644 0 2.5 Mabsadd L
.11333 .00644 1.875 0 Mabsadd L
.11333 .00644 0 -2.5 Mabsadd L
.11333 .00644 -1.875 0 Mabsadd L closepath F
.11667 .00644 -1.875 0 Mabsadd m
.11667 .00644 0 2.5 Mabsadd L
.11667 .00644 1.875 0 Mabsadd L
.11667 .00644 0 -2.5 Mabsadd L
.11667 .00644 -1.875 0 Mabsadd L closepath F
.12 .00644 -1.875 0 Mabsadd m
.12 .00644 0 2.5 Mabsadd L
.12 .00644 1.875 0 Mabsadd L
.12 .00644 0 -2.5 Mabsadd L
.12 .00644 -1.875 0 Mabsadd L closepath F
.12333 .00644 -1.875 0 Mabsadd m
.12333 .00644 0 2.5 Mabsadd L
.12333 .00644 1.875 0 Mabsadd L
.12333 .00644 0 -2.5 Mabsadd L
.12333 .00644 -1.875 0 Mabsadd L closepath F
.12667 .00644 -1.875 0 Mabsadd m
.12667 .00644 0 2.5 Mabsadd L
.12667 .00644 1.875 0 Mabsadd L
.12667 .00644 0 -2.5 Mabsadd L
.12667 .00644 -1.875 0 Mabsadd L closepath F
.13 .00644 -1.875 0 Mabsadd m
.13 .00644 0 2.5 Mabsadd L
.13 .00644 1.875 0 Mabsadd L
.13 .00644 0 -2.5 Mabsadd L
.13 .00644 -1.875 0 Mabsadd L closepath F
.13333 .00644 -1.875 0 Mabsadd m
.13333 .00644 0 2.5 Mabsadd L
.13333 .00644 1.875 0 Mabsadd L
.13333 .00644 0 -2.5 Mabsadd L
.13333 .00644 -1.875 0 Mabsadd L closepath F
.13667 .00644 -1.875 0 Mabsadd m
.13667 .00644 0 2.5 Mabsadd L
.13667 .00644 1.875 0 Mabsadd L
.13667 .00644 0 -2.5 Mabsadd L
.13667 .00644 -1.875 0 Mabsadd L closepath F
.14 .00644 -1.875 0 Mabsadd m
.14 .00644 0 2.5 Mabsadd L
.14 .00644 1.875 0 Mabsadd L
.14 .00644 0 -2.5 Mabsadd L
.14 .00644 -1.875 0 Mabsadd L closepath F
.14333 .00644 -1.875 0 Mabsadd m
.14333 .00644 0 2.5 Mabsadd L
.14333 .00644 1.875 0 Mabsadd L
.14333 .00644 0 -2.5 Mabsadd L
.14333 .00644 -1.875 0 Mabsadd L closepath F
.14667 .00644 -1.875 0 Mabsadd m
.14667 .00644 0 2.5 Mabsadd L
.14667 .00644 1.875 0 Mabsadd L
.14667 .00644 0 -2.5 Mabsadd L
.14667 .00644 -1.875 0 Mabsadd L closepath F
.15 .00644 -1.875 0 Mabsadd m
.15 .00644 0 2.5 Mabsadd L
.15 .00644 1.875 0 Mabsadd L
.15 .00644 0 -2.5 Mabsadd L
.15 .00644 -1.875 0 Mabsadd L closepath F
.15333 .00644 -1.875 0 Mabsadd m
.15333 .00644 0 2.5 Mabsadd L
.15333 .00644 1.875 0 Mabsadd L
.15333 .00644 0 -2.5 Mabsadd L
.15333 .00644 -1.875 0 Mabsadd L closepath F
.15667 .00644 -1.875 0 Mabsadd m
.15667 .00644 0 2.5 Mabsadd L
.15667 .00644 1.875 0 Mabsadd L
.15667 .00644 0 -2.5 Mabsadd L
.15667 .00644 -1.875 0 Mabsadd L closepath F
.16 .00644 -1.875 0 Mabsadd m
.16 .00644 0 2.5 Mabsadd L
.16 .00644 1.875 0 Mabsadd L
.16 .00644 0 -2.5 Mabsadd L
.16 .00644 -1.875 0 Mabsadd L closepath F
.16333 .00644 -1.875 0 Mabsadd m
.16333 .00644 0 2.5 Mabsadd L
.16333 .00644 1.875 0 Mabsadd L
.16333 .00644 0 -2.5 Mabsadd L
.16333 .00644 -1.875 0 Mabsadd L closepath F
.16667 .00644 -1.875 0 Mabsadd m
.16667 .00644 0 2.5 Mabsadd L
.16667 .00644 1.875 0 Mabsadd L
.16667 .00644 0 -2.5 Mabsadd L
.16667 .00644 -1.875 0 Mabsadd L closepath F
.17 .00644 -1.875 0 Mabsadd m
.17 .00644 0 2.5 Mabsadd L
.17 .00644 1.875 0 Mabsadd L
.17 .00644 0 -2.5 Mabsadd L
.17 .00644 -1.875 0 Mabsadd L closepath F
.17333 .00644 -1.875 0 Mabsadd m
.17333 .00644 0 2.5 Mabsadd L
.17333 .00644 1.875 0 Mabsadd L
.17333 .00644 0 -2.5 Mabsadd L
.17333 .00644 -1.875 0 Mabsadd L closepath F
.17667 .00644 -1.875 0 Mabsadd m
.17667 .00644 0 2.5 Mabsadd L
.17667 .00644 1.875 0 Mabsadd L
.17667 .00644 0 -2.5 Mabsadd L
.17667 .00644 -1.875 0 Mabsadd L closepath F
.18 .00644 -1.875 0 Mabsadd m
.18 .00644 0 2.5 Mabsadd L
.18 .00644 1.875 0 Mabsadd L
.18 .00644 0 -2.5 Mabsadd L
.18 .00644 -1.875 0 Mabsadd L closepath F
.18333 .00644 -1.875 0 Mabsadd m
.18333 .00644 0 2.5 Mabsadd L
.18333 .00644 1.875 0 Mabsadd L
.18333 .00644 0 -2.5 Mabsadd L
.18333 .00644 -1.875 0 Mabsadd L closepath F
.18667 .00644 -1.875 0 Mabsadd m
.18667 .00644 0 2.5 Mabsadd L
.18667 .00644 1.875 0 Mabsadd L
.18667 .00644 0 -2.5 Mabsadd L
.18667 .00644 -1.875 0 Mabsadd L closepath F
.19 .00644 -1.875 0 Mabsadd m
.19 .00644 0 2.5 Mabsadd L
.19 .00644 1.875 0 Mabsadd L
.19 .00644 0 -2.5 Mabsadd L
.19 .00644 -1.875 0 Mabsadd L closepath F
.19333 .00644 -1.875 0 Mabsadd m
.19333 .00644 0 2.5 Mabsadd L
.19333 .00644 1.875 0 Mabsadd L
.19333 .00644 0 -2.5 Mabsadd L
.19333 .00644 -1.875 0 Mabsadd L closepath F
.19667 .00644 -1.875 0 Mabsadd m
.19667 .00644 0 2.5 Mabsadd L
.19667 .00644 1.875 0 Mabsadd L
.19667 .00644 0 -2.5 Mabsadd L
.19667 .00644 -1.875 0 Mabsadd L closepath F
.2 .00644 -1.875 0 Mabsadd m
.2 .00644 0 2.5 Mabsadd L
.2 .00644 1.875 0 Mabsadd L
.2 .00644 0 -2.5 Mabsadd L
.2 .00644 -1.875 0 Mabsadd L closepath F
.20333 .00644 -1.875 0 Mabsadd m
.20333 .00644 0 2.5 Mabsadd L
.20333 .00644 1.875 0 Mabsadd L
.20333 .00644 0 -2.5 Mabsadd L
.20333 .00644 -1.875 0 Mabsadd L closepath F
.20667 .00644 -1.875 0 Mabsadd m
.20667 .00644 0 2.5 Mabsadd L
.20667 .00644 1.875 0 Mabsadd L
.20667 .00644 0 -2.5 Mabsadd L
.20667 .00644 -1.875 0 Mabsadd L closepath F
.21 .00644 -1.875 0 Mabsadd m
.21 .00644 0 2.5 Mabsadd L
.21 .00644 1.875 0 Mabsadd L
.21 .00644 0 -2.5 Mabsadd L
.21 .00644 -1.875 0 Mabsadd L closepath F
.21333 .00644 -1.875 0 Mabsadd m
.21333 .00644 0 2.5 Mabsadd L
.21333 .00644 1.875 0 Mabsadd L
.21333 .00644 0 -2.5 Mabsadd L
.21333 .00644 -1.875 0 Mabsadd L closepath F
.21667 .00644 -1.875 0 Mabsadd m
.21667 .00644 0 2.5 Mabsadd L
.21667 .00644 1.875 0 Mabsadd L
.21667 .00644 0 -2.5 Mabsadd L
.21667 .00644 -1.875 0 Mabsadd L closepath F
.22 .00644 -1.875 0 Mabsadd m
.22 .00644 0 2.5 Mabsadd L
.22 .00644 1.875 0 Mabsadd L
.22 .00644 0 -2.5 Mabsadd L
.22 .00644 -1.875 0 Mabsadd L closepath F
.22333 .00644 -1.875 0 Mabsadd m
.22333 .00644 0 2.5 Mabsadd L
.22333 .00644 1.875 0 Mabsadd L
.22333 .00644 0 -2.5 Mabsadd L
.22333 .00644 -1.875 0 Mabsadd L closepath F
.22667 .00644 -1.875 0 Mabsadd m
.22667 .00644 0 2.5 Mabsadd L
.22667 .00644 1.875 0 Mabsadd L
.22667 .00644 0 -2.5 Mabsadd L
.22667 .00644 -1.875 0 Mabsadd L closepath F
.23 .00644 -1.875 0 Mabsadd m
.23 .00644 0 2.5 Mabsadd L
.23 .00644 1.875 0 Mabsadd L
.23 .00644 0 -2.5 Mabsadd L
.23 .00644 -1.875 0 Mabsadd L closepath F
.23333 .00644 -1.875 0 Mabsadd m
.23333 .00644 0 2.5 Mabsadd L
.23333 .00644 1.875 0 Mabsadd L
.23333 .00644 0 -2.5 Mabsadd L
.23333 .00644 -1.875 0 Mabsadd L closepath F
.23667 .00644 -1.875 0 Mabsadd m
.23667 .00644 0 2.5 Mabsadd L
.23667 .00644 1.875 0 Mabsadd L
.23667 .00644 0 -2.5 Mabsadd L
.23667 .00644 -1.875 0 Mabsadd L closepath F
.24 .00644 -1.875 0 Mabsadd m
.24 .00644 0 2.5 Mabsadd L
.24 .00644 1.875 0 Mabsadd L
.24 .00644 0 -2.5 Mabsadd L
.24 .00644 -1.875 0 Mabsadd L closepath F
.24333 .00644 -1.875 0 Mabsadd m
.24333 .00644 0 2.5 Mabsadd L
.24333 .00644 1.875 0 Mabsadd L
.24333 .00644 0 -2.5 Mabsadd L
.24333 .00644 -1.875 0 Mabsadd L closepath F
.24667 .00644 -1.875 0 Mabsadd m
.24667 .00644 0 2.5 Mabsadd L
.24667 .00644 1.875 0 Mabsadd L
.24667 .00644 0 -2.5 Mabsadd L
.24667 .00644 -1.875 0 Mabsadd L closepath F
.25 .00644 -1.875 0 Mabsadd m
.25 .00644 0 2.5 Mabsadd L
.25 .00644 1.875 0 Mabsadd L
.25 .00644 0 -2.5 Mabsadd L
.25 .00644 -1.875 0 Mabsadd L closepath F
.25333 .00644 -1.875 0 Mabsadd m
.25333 .00644 0 2.5 Mabsadd L
.25333 .00644 1.875 0 Mabsadd L
.25333 .00644 0 -2.5 Mabsadd L
.25333 .00644 -1.875 0 Mabsadd L closepath F
.25667 .00644 -1.875 0 Mabsadd m
.25667 .00644 0 2.5 Mabsadd L
.25667 .00644 1.875 0 Mabsadd L
.25667 .00644 0 -2.5 Mabsadd L
.25667 .00644 -1.875 0 Mabsadd L closepath F
.26 .00644 -1.875 0 Mabsadd m
.26 .00644 0 2.5 Mabsadd L
.26 .00644 1.875 0 Mabsadd L
.26 .00644 0 -2.5 Mabsadd L
.26 .00644 -1.875 0 Mabsadd L closepath F
.26333 .00644 -1.875 0 Mabsadd m
.26333 .00644 0 2.5 Mabsadd L
.26333 .00644 1.875 0 Mabsadd L
.26333 .00644 0 -2.5 Mabsadd L
.26333 .00644 -1.875 0 Mabsadd L closepath F
.26667 .00644 -1.875 0 Mabsadd m
.26667 .00644 0 2.5 Mabsadd L
.26667 .00644 1.875 0 Mabsadd L
.26667 .00644 0 -2.5 Mabsadd L
.26667 .00644 -1.875 0 Mabsadd L closepath F
.27 .00644 -1.875 0 Mabsadd m
.27 .00644 0 2.5 Mabsadd L
.27 .00644 1.875 0 Mabsadd L
.27 .00644 0 -2.5 Mabsadd L
.27 .00644 -1.875 0 Mabsadd L closepath F
.27333 .00644 -1.875 0 Mabsadd m
.27333 .00644 0 2.5 Mabsadd L
.27333 .00644 1.875 0 Mabsadd L
.27333 .00644 0 -2.5 Mabsadd L
.27333 .00644 -1.875 0 Mabsadd L closepath F
.27667 .00644 -1.875 0 Mabsadd m
.27667 .00644 0 2.5 Mabsadd L
.27667 .00644 1.875 0 Mabsadd L
.27667 .00644 0 -2.5 Mabsadd L
.27667 .00644 -1.875 0 Mabsadd L closepath F
.28 .00644 -1.875 0 Mabsadd m
.28 .00644 0 2.5 Mabsadd L
.28 .00644 1.875 0 Mabsadd L
.28 .00644 0 -2.5 Mabsadd L
.28 .00644 -1.875 0 Mabsadd L closepath F
.28333 .00644 -1.875 0 Mabsadd m
.28333 .00644 0 2.5 Mabsadd L
.28333 .00644 1.875 0 Mabsadd L
.28333 .00644 0 -2.5 Mabsadd L
.28333 .00644 -1.875 0 Mabsadd L closepath F
.28667 .00644 -1.875 0 Mabsadd m
.28667 .00644 0 2.5 Mabsadd L
.28667 .00644 1.875 0 Mabsadd L
.28667 .00644 0 -2.5 Mabsadd L
.28667 .00644 -1.875 0 Mabsadd L closepath F
.29 .00644 -1.875 0 Mabsadd m
.29 .00644 0 2.5 Mabsadd L
.29 .00644 1.875 0 Mabsadd L
.29 .00644 0 -2.5 Mabsadd L
.29 .00644 -1.875 0 Mabsadd L closepath F
.29333 .00644 -1.875 0 Mabsadd m
.29333 .00644 0 2.5 Mabsadd L
.29333 .00644 1.875 0 Mabsadd L
.29333 .00644 0 -2.5 Mabsadd L
.29333 .00644 -1.875 0 Mabsadd L closepath F
.29667 .00644 -1.875 0 Mabsadd m
.29667 .00644 0 2.5 Mabsadd L
.29667 .00644 1.875 0 Mabsadd L
.29667 .00644 0 -2.5 Mabsadd L
.29667 .00644 -1.875 0 Mabsadd L closepath F
.3 .00644 -1.875 0 Mabsadd m
.3 .00644 0 2.5 Mabsadd L
.3 .00644 1.875 0 Mabsadd L
.3 .00644 0 -2.5 Mabsadd L
.3 .00644 -1.875 0 Mabsadd L closepath F
.30333 .00644 -1.875 0 Mabsadd m
.30333 .00644 0 2.5 Mabsadd L
.30333 .00644 1.875 0 Mabsadd L
.30333 .00644 0 -2.5 Mabsadd L
.30333 .00644 -1.875 0 Mabsadd L closepath F
.30667 .00644 -1.875 0 Mabsadd m
.30667 .00644 0 2.5 Mabsadd L
.30667 .00644 1.875 0 Mabsadd L
.30667 .00644 0 -2.5 Mabsadd L
.30667 .00644 -1.875 0 Mabsadd L closepath F
.31 .00644 -1.875 0 Mabsadd m
.31 .00644 0 2.5 Mabsadd L
.31 .00644 1.875 0 Mabsadd L
.31 .00644 0 -2.5 Mabsadd L
.31 .00644 -1.875 0 Mabsadd L closepath F
.31333 .00644 -1.875 0 Mabsadd m
.31333 .00644 0 2.5 Mabsadd L
.31333 .00644 1.875 0 Mabsadd L
.31333 .00644 0 -2.5 Mabsadd L
.31333 .00644 -1.875 0 Mabsadd L closepath F
.31667 .00644 -1.875 0 Mabsadd m
.31667 .00644 0 2.5 Mabsadd L
.31667 .00644 1.875 0 Mabsadd L
.31667 .00644 0 -2.5 Mabsadd L
.31667 .00644 -1.875 0 Mabsadd L closepath F
.32 .00644 -1.875 0 Mabsadd m
.32 .00644 0 2.5 Mabsadd L
.32 .00644 1.875 0 Mabsadd L
.32 .00644 0 -2.5 Mabsadd L
.32 .00644 -1.875 0 Mabsadd L closepath F
.32333 .00644 -1.875 0 Mabsadd m
.32333 .00644 0 2.5 Mabsadd L
.32333 .00644 1.875 0 Mabsadd L
.32333 .00644 0 -2.5 Mabsadd L
.32333 .00644 -1.875 0 Mabsadd L closepath F
.32667 .00644 -1.875 0 Mabsadd m
.32667 .00644 0 2.5 Mabsadd L
.32667 .00644 1.875 0 Mabsadd L
.32667 .00644 0 -2.5 Mabsadd L
.32667 .00644 -1.875 0 Mabsadd L closepath F
.33 .00644 -1.875 0 Mabsadd m
.33 .00644 0 2.5 Mabsadd L
.33 .00644 1.875 0 Mabsadd L
.33 .00644 0 -2.5 Mabsadd L
.33 .00644 -1.875 0 Mabsadd L closepath F
.33333 .00644 -1.875 0 Mabsadd m
.33333 .00644 0 2.5 Mabsadd L
.33333 .00644 1.875 0 Mabsadd L
.33333 .00644 0 -2.5 Mabsadd L
.33333 .00644 -1.875 0 Mabsadd L closepath F
.33667 .00644 -1.875 0 Mabsadd m
.33667 .00644 0 2.5 Mabsadd L
.33667 .00644 1.875 0 Mabsadd L
.33667 .00644 0 -2.5 Mabsadd L
.33667 .00644 -1.875 0 Mabsadd L closepath F
.34 .00644 -1.875 0 Mabsadd m
.34 .00644 0 2.5 Mabsadd L
.34 .00644 1.875 0 Mabsadd L
.34 .00644 0 -2.5 Mabsadd L
.34 .00644 -1.875 0 Mabsadd L closepath F
.34333 .00644 -1.875 0 Mabsadd m
.34333 .00644 0 2.5 Mabsadd L
.34333 .00644 1.875 0 Mabsadd L
.34333 .00644 0 -2.5 Mabsadd L
.34333 .00644 -1.875 0 Mabsadd L closepath F
.34667 .00644 -1.875 0 Mabsadd m
.34667 .00644 0 2.5 Mabsadd L
.34667 .00644 1.875 0 Mabsadd L
.34667 .00644 0 -2.5 Mabsadd L
.34667 .00644 -1.875 0 Mabsadd L closepath F
.35 .00644 -1.875 0 Mabsadd m
.35 .00644 0 2.5 Mabsadd L
.35 .00644 1.875 0 Mabsadd L
.35 .00644 0 -2.5 Mabsadd L
.35 .00644 -1.875 0 Mabsadd L closepath F
.35333 .00644 -1.875 0 Mabsadd m
.35333 .00644 0 2.5 Mabsadd L
.35333 .00644 1.875 0 Mabsadd L
.35333 .00644 0 -2.5 Mabsadd L
.35333 .00644 -1.875 0 Mabsadd L closepath F
.35667 .00644 -1.875 0 Mabsadd m
.35667 .00644 0 2.5 Mabsadd L
.35667 .00644 1.875 0 Mabsadd L
.35667 .00644 0 -2.5 Mabsadd L
.35667 .00644 -1.875 0 Mabsadd L closepath F
.36 .00644 -1.875 0 Mabsadd m
.36 .00644 0 2.5 Mabsadd L
.36 .00644 1.875 0 Mabsadd L
.36 .00644 0 -2.5 Mabsadd L
.36 .00644 -1.875 0 Mabsadd L closepath F
.36333 .00644 -1.875 0 Mabsadd m
.36333 .00644 0 2.5 Mabsadd L
.36333 .00644 1.875 0 Mabsadd L
.36333 .00644 0 -2.5 Mabsadd L
.36333 .00644 -1.875 0 Mabsadd L closepath F
.36667 .00644 -1.875 0 Mabsadd m
.36667 .00644 0 2.5 Mabsadd L
.36667 .00644 1.875 0 Mabsadd L
.36667 .00644 0 -2.5 Mabsadd L
.36667 .00644 -1.875 0 Mabsadd L closepath F
.37 .00644 -1.875 0 Mabsadd m
.37 .00644 0 2.5 Mabsadd L
.37 .00644 1.875 0 Mabsadd L
.37 .00644 0 -2.5 Mabsadd L
.37 .00644 -1.875 0 Mabsadd L closepath F
.37333 .00644 -1.875 0 Mabsadd m
.37333 .00644 0 2.5 Mabsadd L
.37333 .00644 1.875 0 Mabsadd L
.37333 .00644 0 -2.5 Mabsadd L
.37333 .00644 -1.875 0 Mabsadd L closepath F
.37667 .00644 -1.875 0 Mabsadd m
.37667 .00644 0 2.5 Mabsadd L
.37667 .00644 1.875 0 Mabsadd L
.37667 .00644 0 -2.5 Mabsadd L
.37667 .00644 -1.875 0 Mabsadd L closepath F
.38 .00644 -1.875 0 Mabsadd m
.38 .00644 0 2.5 Mabsadd L
.38 .00644 1.875 0 Mabsadd L
.38 .00644 0 -2.5 Mabsadd L
.38 .00644 -1.875 0 Mabsadd L closepath F
.38333 .00644 -1.875 0 Mabsadd m
.38333 .00644 0 2.5 Mabsadd L
.38333 .00644 1.875 0 Mabsadd L
.38333 .00644 0 -2.5 Mabsadd L
.38333 .00644 -1.875 0 Mabsadd L closepath F
.38667 .00644 -1.875 0 Mabsadd m
.38667 .00644 0 2.5 Mabsadd L
.38667 .00644 1.875 0 Mabsadd L
.38667 .00644 0 -2.5 Mabsadd L
.38667 .00644 -1.875 0 Mabsadd L closepath F
.39 .00644 -1.875 0 Mabsadd m
.39 .00644 0 2.5 Mabsadd L
.39 .00644 1.875 0 Mabsadd L
.39 .00644 0 -2.5 Mabsadd L
.39 .00644 -1.875 0 Mabsadd L closepath F
.39333 .00644 -1.875 0 Mabsadd m
.39333 .00644 0 2.5 Mabsadd L
.39333 .00644 1.875 0 Mabsadd L
.39333 .00644 0 -2.5 Mabsadd L
.39333 .00644 -1.875 0 Mabsadd L closepath F
.39667 .00644 -1.875 0 Mabsadd m
.39667 .00644 0 2.5 Mabsadd L
.39667 .00644 1.875 0 Mabsadd L
.39667 .00644 0 -2.5 Mabsadd L
.39667 .00644 -1.875 0 Mabsadd L closepath F
.4 .00644 -1.875 0 Mabsadd m
.4 .00644 0 2.5 Mabsadd L
.4 .00644 1.875 0 Mabsadd L
.4 .00644 0 -2.5 Mabsadd L
.4 .00644 -1.875 0 Mabsadd L closepath F
.40333 .00644 -1.875 0 Mabsadd m
.40333 .00644 0 2.5 Mabsadd L
.40333 .00644 1.875 0 Mabsadd L
.40333 .00644 0 -2.5 Mabsadd L
.40333 .00644 -1.875 0 Mabsadd L closepath F
.40667 .00644 -1.875 0 Mabsadd m
.40667 .00644 0 2.5 Mabsadd L
.40667 .00644 1.875 0 Mabsadd L
.40667 .00644 0 -2.5 Mabsadd L
.40667 .00644 -1.875 0 Mabsadd L closepath F
.41 .00644 -1.875 0 Mabsadd m
.41 .00644 0 2.5 Mabsadd L
.41 .00644 1.875 0 Mabsadd L
.41 .00644 0 -2.5 Mabsadd L
.41 .00644 -1.875 0 Mabsadd L closepath F
.41333 .00644 -1.875 0 Mabsadd m
.41333 .00644 0 2.5 Mabsadd L
.41333 .00644 1.875 0 Mabsadd L
.41333 .00644 0 -2.5 Mabsadd L
.41333 .00644 -1.875 0 Mabsadd L closepath F
.41667 .00644 -1.875 0 Mabsadd m
.41667 .00644 0 2.5 Mabsadd L
.41667 .00644 1.875 0 Mabsadd L
.41667 .00644 0 -2.5 Mabsadd L
.41667 .00644 -1.875 0 Mabsadd L closepath F
.42 .00644 -1.875 0 Mabsadd m
.42 .00644 0 2.5 Mabsadd L
.42 .00644 1.875 0 Mabsadd L
.42 .00644 0 -2.5 Mabsadd L
.42 .00644 -1.875 0 Mabsadd L closepath F
.42333 .00644 -1.875 0 Mabsadd m
.42333 .00644 0 2.5 Mabsadd L
.42333 .00644 1.875 0 Mabsadd L
.42333 .00644 0 -2.5 Mabsadd L
.42333 .00644 -1.875 0 Mabsadd L closepath F
.42667 .00644 -1.875 0 Mabsadd m
.42667 .00644 0 2.5 Mabsadd L
.42667 .00644 1.875 0 Mabsadd L
.42667 .00644 0 -2.5 Mabsadd L
.42667 .00644 -1.875 0 Mabsadd L closepath F
.43 .00644 -1.875 0 Mabsadd m
.43 .00644 0 2.5 Mabsadd L
.43 .00644 1.875 0 Mabsadd L
.43 .00644 0 -2.5 Mabsadd L
.43 .00644 -1.875 0 Mabsadd L closepath F
.43333 .00644 -1.875 0 Mabsadd m
.43333 .00644 0 2.5 Mabsadd L
.43333 .00644 1.875 0 Mabsadd L
.43333 .00644 0 -2.5 Mabsadd L
.43333 .00644 -1.875 0 Mabsadd L closepath F
.43667 .00644 -1.875 0 Mabsadd m
.43667 .00644 0 2.5 Mabsadd L
.43667 .00644 1.875 0 Mabsadd L
.43667 .00644 0 -2.5 Mabsadd L
.43667 .00644 -1.875 0 Mabsadd L closepath F
.44 .00644 -1.875 0 Mabsadd m
.44 .00644 0 2.5 Mabsadd L
.44 .00644 1.875 0 Mabsadd L
.44 .00644 0 -2.5 Mabsadd L
.44 .00644 -1.875 0 Mabsadd L closepath F
.44333 .00644 -1.875 0 Mabsadd m
.44333 .00644 0 2.5 Mabsadd L
.44333 .00644 1.875 0 Mabsadd L
.44333 .00644 0 -2.5 Mabsadd L
.44333 .00644 -1.875 0 Mabsadd L closepath F
.44667 .00644 -1.875 0 Mabsadd m
.44667 .00644 0 2.5 Mabsadd L
.44667 .00644 1.875 0 Mabsadd L
.44667 .00644 0 -2.5 Mabsadd L
.44667 .00644 -1.875 0 Mabsadd L closepath F
.45 .00644 -1.875 0 Mabsadd m
.45 .00644 0 2.5 Mabsadd L
.45 .00644 1.875 0 Mabsadd L
.45 .00644 0 -2.5 Mabsadd L
.45 .00644 -1.875 0 Mabsadd L closepath F
.45333 .00644 -1.875 0 Mabsadd m
.45333 .00644 0 2.5 Mabsadd L
.45333 .00644 1.875 0 Mabsadd L
.45333 .00644 0 -2.5 Mabsadd L
.45333 .00644 -1.875 0 Mabsadd L closepath F
.45667 .00644 -1.875 0 Mabsadd m
.45667 .00644 0 2.5 Mabsadd L
.45667 .00644 1.875 0 Mabsadd L
.45667 .00644 0 -2.5 Mabsadd L
.45667 .00644 -1.875 0 Mabsadd L closepath F
.46 .00644 -1.875 0 Mabsadd m
.46 .00644 0 2.5 Mabsadd L
.46 .00644 1.875 0 Mabsadd L
.46 .00644 0 -2.5 Mabsadd L
.46 .00644 -1.875 0 Mabsadd L closepath F
.46333 .00644 -1.875 0 Mabsadd m
.46333 .00644 0 2.5 Mabsadd L
.46333 .00644 1.875 0 Mabsadd L
.46333 .00644 0 -2.5 Mabsadd L
.46333 .00644 -1.875 0 Mabsadd L closepath F
.46667 .00644 -1.875 0 Mabsadd m
.46667 .00644 0 2.5 Mabsadd L
.46667 .00644 1.875 0 Mabsadd L
.46667 .00644 0 -2.5 Mabsadd L
.46667 .00644 -1.875 0 Mabsadd L closepath F
.47 .00644 -1.875 0 Mabsadd m
.47 .00644 0 2.5 Mabsadd L
.47 .00644 1.875 0 Mabsadd L
.47 .00644 0 -2.5 Mabsadd L
.47 .00644 -1.875 0 Mabsadd L closepath F
.47333 .00644 -1.875 0 Mabsadd m
.47333 .00644 0 2.5 Mabsadd L
.47333 .00644 1.875 0 Mabsadd L
.47333 .00644 0 -2.5 Mabsadd L
.47333 .00644 -1.875 0 Mabsadd L closepath F
.47667 .00644 -1.875 0 Mabsadd m
.47667 .00644 0 2.5 Mabsadd L
.47667 .00644 1.875 0 Mabsadd L
.47667 .00644 0 -2.5 Mabsadd L
.47667 .00644 -1.875 0 Mabsadd L closepath F
.48 .00644 -1.875 0 Mabsadd m
.48 .00644 0 2.5 Mabsadd L
.48 .00644 1.875 0 Mabsadd L
.48 .00644 0 -2.5 Mabsadd L
.48 .00644 -1.875 0 Mabsadd L closepath F
.48333 .00644 -1.875 0 Mabsadd m
.48333 .00644 0 2.5 Mabsadd L
.48333 .00644 1.875 0 Mabsadd L
.48333 .00644 0 -2.5 Mabsadd L
.48333 .00644 -1.875 0 Mabsadd L closepath F
.48667 .00644 -1.875 0 Mabsadd m
.48667 .00644 0 2.5 Mabsadd L
.48667 .00644 1.875 0 Mabsadd L
.48667 .00644 0 -2.5 Mabsadd L
.48667 .00644 -1.875 0 Mabsadd L closepath F
.49 .00644 -1.875 0 Mabsadd m
.49 .00644 0 2.5 Mabsadd L
.49 .00644 1.875 0 Mabsadd L
.49 .00644 0 -2.5 Mabsadd L
.49 .00644 -1.875 0 Mabsadd L closepath F
.49333 .00644 -1.875 0 Mabsadd m
.49333 .00644 0 2.5 Mabsadd L
.49333 .00644 1.875 0 Mabsadd L
.49333 .00644 0 -2.5 Mabsadd L
.49333 .00644 -1.875 0 Mabsadd L closepath F
.49667 .00644 -1.875 0 Mabsadd m
.49667 .00644 0 2.5 Mabsadd L
.49667 .00644 1.875 0 Mabsadd L
.49667 .00644 0 -2.5 Mabsadd L
.49667 .00644 -1.875 0 Mabsadd L closepath F
.5 .00644 -1.875 0 Mabsadd m
.5 .00644 0 2.5 Mabsadd L
.5 .00644 1.875 0 Mabsadd L
.5 .00644 0 -2.5 Mabsadd L
.5 .00644 -1.875 0 Mabsadd L closepath F
.50333 .00644 -1.875 0 Mabsadd m
.50333 .00644 0 2.5 Mabsadd L
.50333 .00644 1.875 0 Mabsadd L
.50333 .00644 0 -2.5 Mabsadd L
.50333 .00644 -1.875 0 Mabsadd L closepath F
.50667 .00644 -1.875 0 Mabsadd m
.50667 .00644 0 2.5 Mabsadd L
.50667 .00644 1.875 0 Mabsadd L
.50667 .00644 0 -2.5 Mabsadd L
.50667 .00644 -1.875 0 Mabsadd L closepath F
.51 .00644 -1.875 0 Mabsadd m
.51 .00644 0 2.5 Mabsadd L
.51 .00644 1.875 0 Mabsadd L
.51 .00644 0 -2.5 Mabsadd L
.51 .00644 -1.875 0 Mabsadd L closepath F
.51333 .00644 -1.875 0 Mabsadd m
.51333 .00644 0 2.5 Mabsadd L
.51333 .00644 1.875 0 Mabsadd L
.51333 .00644 0 -2.5 Mabsadd L
.51333 .00644 -1.875 0 Mabsadd L closepath F
.51667 .00644 -1.875 0 Mabsadd m
.51667 .00644 0 2.5 Mabsadd L
.51667 .00644 1.875 0 Mabsadd L
.51667 .00644 0 -2.5 Mabsadd L
.51667 .00644 -1.875 0 Mabsadd L closepath F
.52 .00644 -1.875 0 Mabsadd m
.52 .00644 0 2.5 Mabsadd L
.52 .00644 1.875 0 Mabsadd L
.52 .00644 0 -2.5 Mabsadd L
.52 .00644 -1.875 0 Mabsadd L closepath F
.52333 .00644 -1.875 0 Mabsadd m
.52333 .00644 0 2.5 Mabsadd L
.52333 .00644 1.875 0 Mabsadd L
.52333 .00644 0 -2.5 Mabsadd L
.52333 .00644 -1.875 0 Mabsadd L closepath F
.52667 .00644 -1.875 0 Mabsadd m
.52667 .00644 0 2.5 Mabsadd L
.52667 .00644 1.875 0 Mabsadd L
.52667 .00644 0 -2.5 Mabsadd L
.52667 .00644 -1.875 0 Mabsadd L closepath F
.53 .00644 -1.875 0 Mabsadd m
.53 .00644 0 2.5 Mabsadd L
.53 .00644 1.875 0 Mabsadd L
.53 .00644 0 -2.5 Mabsadd L
.53 .00644 -1.875 0 Mabsadd L closepath F
.53333 .00644 -1.875 0 Mabsadd m
.53333 .00644 0 2.5 Mabsadd L
.53333 .00644 1.875 0 Mabsadd L
.53333 .00644 0 -2.5 Mabsadd L
.53333 .00644 -1.875 0 Mabsadd L closepath F
.53667 .00644 -1.875 0 Mabsadd m
.53667 .00644 0 2.5 Mabsadd L
.53667 .00644 1.875 0 Mabsadd L
.53667 .00644 0 -2.5 Mabsadd L
.53667 .00644 -1.875 0 Mabsadd L closepath F
.54 .00644 -1.875 0 Mabsadd m
.54 .00644 0 2.5 Mabsadd L
.54 .00644 1.875 0 Mabsadd L
.54 .00644 0 -2.5 Mabsadd L
.54 .00644 -1.875 0 Mabsadd L closepath F
.54333 .00644 -1.875 0 Mabsadd m
.54333 .00644 0 2.5 Mabsadd L
.54333 .00644 1.875 0 Mabsadd L
.54333 .00644 0 -2.5 Mabsadd L
.54333 .00644 -1.875 0 Mabsadd L closepath F
.54667 .00644 -1.875 0 Mabsadd m
.54667 .00644 0 2.5 Mabsadd L
.54667 .00644 1.875 0 Mabsadd L
.54667 .00644 0 -2.5 Mabsadd L
.54667 .00644 -1.875 0 Mabsadd L closepath F
.55 .00644 -1.875 0 Mabsadd m
.55 .00644 0 2.5 Mabsadd L
.55 .00644 1.875 0 Mabsadd L
.55 .00644 0 -2.5 Mabsadd L
.55 .00644 -1.875 0 Mabsadd L closepath F
.55333 .00644 -1.875 0 Mabsadd m
.55333 .00644 0 2.5 Mabsadd L
.55333 .00644 1.875 0 Mabsadd L
.55333 .00644 0 -2.5 Mabsadd L
.55333 .00644 -1.875 0 Mabsadd L closepath F
.55667 .00644 -1.875 0 Mabsadd m
.55667 .00644 0 2.5 Mabsadd L
.55667 .00644 1.875 0 Mabsadd L
.55667 .00644 0 -2.5 Mabsadd L
.55667 .00644 -1.875 0 Mabsadd L closepath F
.56 .00644 -1.875 0 Mabsadd m
.56 .00644 0 2.5 Mabsadd L
.56 .00644 1.875 0 Mabsadd L
.56 .00644 0 -2.5 Mabsadd L
.56 .00644 -1.875 0 Mabsadd L closepath F
.56333 .00644 -1.875 0 Mabsadd m
.56333 .00644 0 2.5 Mabsadd L
.56333 .00644 1.875 0 Mabsadd L
.56333 .00644 0 -2.5 Mabsadd L
.56333 .00644 -1.875 0 Mabsadd L closepath F
.56667 .00644 -1.875 0 Mabsadd m
.56667 .00644 0 2.5 Mabsadd L
.56667 .00644 1.875 0 Mabsadd L
.56667 .00644 0 -2.5 Mabsadd L
.56667 .00644 -1.875 0 Mabsadd L closepath F
.57 .00644 -1.875 0 Mabsadd m
.57 .00644 0 2.5 Mabsadd L
.57 .00644 1.875 0 Mabsadd L
.57 .00644 0 -2.5 Mabsadd L
.57 .00644 -1.875 0 Mabsadd L closepath F
.57333 .00644 -1.875 0 Mabsadd m
.57333 .00644 0 2.5 Mabsadd L
.57333 .00644 1.875 0 Mabsadd L
.57333 .00644 0 -2.5 Mabsadd L
.57333 .00644 -1.875 0 Mabsadd L closepath F
.57667 .00644 -1.875 0 Mabsadd m
.57667 .00644 0 2.5 Mabsadd L
.57667 .00644 1.875 0 Mabsadd L
.57667 .00644 0 -2.5 Mabsadd L
.57667 .00644 -1.875 0 Mabsadd L closepath F
.58 .00644 -1.875 0 Mabsadd m
.58 .00644 0 2.5 Mabsadd L
.58 .00644 1.875 0 Mabsadd L
.58 .00644 0 -2.5 Mabsadd L
.58 .00644 -1.875 0 Mabsadd L closepath F
.58333 .00644 -1.875 0 Mabsadd m
.58333 .00644 0 2.5 Mabsadd L
.58333 .00644 1.875 0 Mabsadd L
.58333 .00644 0 -2.5 Mabsadd L
.58333 .00644 -1.875 0 Mabsadd L closepath F
.58667 .00644 -1.875 0 Mabsadd m
.58667 .00644 0 2.5 Mabsadd L
.58667 .00644 1.875 0 Mabsadd L
.58667 .00644 0 -2.5 Mabsadd L
.58667 .00644 -1.875 0 Mabsadd L closepath F
.59 .00644 -1.875 0 Mabsadd m
.59 .00644 0 2.5 Mabsadd L
.59 .00644 1.875 0 Mabsadd L
.59 .00644 0 -2.5 Mabsadd L
.59 .00644 -1.875 0 Mabsadd L closepath F
.59333 .00644 -1.875 0 Mabsadd m
.59333 .00644 0 2.5 Mabsadd L
.59333 .00644 1.875 0 Mabsadd L
.59333 .00644 0 -2.5 Mabsadd L
.59333 .00644 -1.875 0 Mabsadd L closepath F
.59667 .00644 -1.875 0 Mabsadd m
.59667 .00644 0 2.5 Mabsadd L
.59667 .00644 1.875 0 Mabsadd L
.59667 .00644 0 -2.5 Mabsadd L
.59667 .00644 -1.875 0 Mabsadd L closepath F
.6 .00644 -1.875 0 Mabsadd m
.6 .00644 0 2.5 Mabsadd L
.6 .00644 1.875 0 Mabsadd L
.6 .00644 0 -2.5 Mabsadd L
.6 .00644 -1.875 0 Mabsadd L closepath F
.60333 .00644 -1.875 0 Mabsadd m
.60333 .00644 0 2.5 Mabsadd L
.60333 .00644 1.875 0 Mabsadd L
.60333 .00644 0 -2.5 Mabsadd L
.60333 .00644 -1.875 0 Mabsadd L closepath F
.60667 .00644 -1.875 0 Mabsadd m
.60667 .00644 0 2.5 Mabsadd L
.60667 .00644 1.875 0 Mabsadd L
.60667 .00644 0 -2.5 Mabsadd L
.60667 .00644 -1.875 0 Mabsadd L closepath F
.61 .00644 -1.875 0 Mabsadd m
.61 .00644 0 2.5 Mabsadd L
.61 .00644 1.875 0 Mabsadd L
.61 .00644 0 -2.5 Mabsadd L
.61 .00644 -1.875 0 Mabsadd L closepath F
.61333 .00644 -1.875 0 Mabsadd m
.61333 .00644 0 2.5 Mabsadd L
.61333 .00644 1.875 0 Mabsadd L
.61333 .00644 0 -2.5 Mabsadd L
.61333 .00644 -1.875 0 Mabsadd L closepath F
.61667 .00644 -1.875 0 Mabsadd m
.61667 .00644 0 2.5 Mabsadd L
.61667 .00644 1.875 0 Mabsadd L
.61667 .00644 0 -2.5 Mabsadd L
.61667 .00644 -1.875 0 Mabsadd L closepath F
.62 .00644 -1.875 0 Mabsadd m
.62 .00644 0 2.5 Mabsadd L
.62 .00644 1.875 0 Mabsadd L
.62 .00644 0 -2.5 Mabsadd L
.62 .00644 -1.875 0 Mabsadd L closepath F
.62333 .00644 -1.875 0 Mabsadd m
.62333 .00644 0 2.5 Mabsadd L
.62333 .00644 1.875 0 Mabsadd L
.62333 .00644 0 -2.5 Mabsadd L
.62333 .00644 -1.875 0 Mabsadd L closepath F
.62667 .00644 -1.875 0 Mabsadd m
.62667 .00644 0 2.5 Mabsadd L
.62667 .00644 1.875 0 Mabsadd L
.62667 .00644 0 -2.5 Mabsadd L
.62667 .00644 -1.875 0 Mabsadd L closepath F
.63 .00644 -1.875 0 Mabsadd m
.63 .00644 0 2.5 Mabsadd L
.63 .00644 1.875 0 Mabsadd L
.63 .00644 0 -2.5 Mabsadd L
.63 .00644 -1.875 0 Mabsadd L closepath F
.63333 .00644 -1.875 0 Mabsadd m
.63333 .00644 0 2.5 Mabsadd L
.63333 .00644 1.875 0 Mabsadd L
.63333 .00644 0 -2.5 Mabsadd L
.63333 .00644 -1.875 0 Mabsadd L closepath F
.63667 .00644 -1.875 0 Mabsadd m
.63667 .00644 0 2.5 Mabsadd L
.63667 .00644 1.875 0 Mabsadd L
.63667 .00644 0 -2.5 Mabsadd L
.63667 .00644 -1.875 0 Mabsadd L closepath F
.64 .00644 -1.875 0 Mabsadd m
.64 .00644 0 2.5 Mabsadd L
.64 .00644 1.875 0 Mabsadd L
.64 .00644 0 -2.5 Mabsadd L
.64 .00644 -1.875 0 Mabsadd L closepath F
.64333 .00644 -1.875 0 Mabsadd m
.64333 .00644 0 2.5 Mabsadd L
.64333 .00644 1.875 0 Mabsadd L
.64333 .00644 0 -2.5 Mabsadd L
.64333 .00644 -1.875 0 Mabsadd L closepath F
.64667 .00644 -1.875 0 Mabsadd m
.64667 .00644 0 2.5 Mabsadd L
.64667 .00644 1.875 0 Mabsadd L
.64667 .00644 0 -2.5 Mabsadd L
.64667 .00644 -1.875 0 Mabsadd L closepath F
.65 .00644 -1.875 0 Mabsadd m
.65 .00644 0 2.5 Mabsadd L
.65 .00644 1.875 0 Mabsadd L
.65 .00644 0 -2.5 Mabsadd L
.65 .00644 -1.875 0 Mabsadd L closepath F
.65333 .00644 -1.875 0 Mabsadd m
.65333 .00644 0 2.5 Mabsadd L
.65333 .00644 1.875 0 Mabsadd L
.65333 .00644 0 -2.5 Mabsadd L
.65333 .00644 -1.875 0 Mabsadd L closepath F
.65667 .00644 -1.875 0 Mabsadd m
.65667 .00644 0 2.5 Mabsadd L
.65667 .00644 1.875 0 Mabsadd L
.65667 .00644 0 -2.5 Mabsadd L
.65667 .00644 -1.875 0 Mabsadd L closepath F
.66 .00644 -1.875 0 Mabsadd m
.66 .00644 0 2.5 Mabsadd L
.66 .00644 1.875 0 Mabsadd L
.66 .00644 0 -2.5 Mabsadd L
.66 .00644 -1.875 0 Mabsadd L closepath F
.66333 .00644 -1.875 0 Mabsadd m
.66333 .00644 0 2.5 Mabsadd L
.66333 .00644 1.875 0 Mabsadd L
.66333 .00644 0 -2.5 Mabsadd L
.66333 .00644 -1.875 0 Mabsadd L closepath F
.66667 .00644 -1.875 0 Mabsadd m
.66667 .00644 0 2.5 Mabsadd L
.66667 .00644 1.875 0 Mabsadd L
.66667 .00644 0 -2.5 Mabsadd L
.66667 .00644 -1.875 0 Mabsadd L closepath F
.67 .00644 -1.875 0 Mabsadd m
.67 .00644 0 2.5 Mabsadd L
.67 .00644 1.875 0 Mabsadd L
.67 .00644 0 -2.5 Mabsadd L
.67 .00644 -1.875 0 Mabsadd L closepath F
.67333 .00644 -1.875 0 Mabsadd m
.67333 .00644 0 2.5 Mabsadd L
.67333 .00644 1.875 0 Mabsadd L
.67333 .00644 0 -2.5 Mabsadd L
.67333 .00644 -1.875 0 Mabsadd L closepath F
.67667 .00644 -1.875 0 Mabsadd m
.67667 .00644 0 2.5 Mabsadd L
.67667 .00644 1.875 0 Mabsadd L
.67667 .00644 0 -2.5 Mabsadd L
.67667 .00644 -1.875 0 Mabsadd L closepath F
.68 .00644 -1.875 0 Mabsadd m
.68 .00644 0 2.5 Mabsadd L
.68 .00644 1.875 0 Mabsadd L
.68 .00644 0 -2.5 Mabsadd L
.68 .00644 -1.875 0 Mabsadd L closepath F
.68333 .00644 -1.875 0 Mabsadd m
.68333 .00644 0 2.5 Mabsadd L
.68333 .00644 1.875 0 Mabsadd L
.68333 .00644 0 -2.5 Mabsadd L
.68333 .00644 -1.875 0 Mabsadd L closepath F
.68667 .00644 -1.875 0 Mabsadd m
.68667 .00644 0 2.5 Mabsadd L
.68667 .00644 1.875 0 Mabsadd L
.68667 .00644 0 -2.5 Mabsadd L
.68667 .00644 -1.875 0 Mabsadd L closepath F
.69 .00644 -1.875 0 Mabsadd m
.69 .00644 0 2.5 Mabsadd L
.69 .00644 1.875 0 Mabsadd L
.69 .00644 0 -2.5 Mabsadd L
.69 .00644 -1.875 0 Mabsadd L closepath F
.69333 .00644 -1.875 0 Mabsadd m
.69333 .00644 0 2.5 Mabsadd L
.69333 .00644 1.875 0 Mabsadd L
.69333 .00644 0 -2.5 Mabsadd L
.69333 .00644 -1.875 0 Mabsadd L closepath F
.69667 .00644 -1.875 0 Mabsadd m
.69667 .00644 0 2.5 Mabsadd L
.69667 .00644 1.875 0 Mabsadd L
.69667 .00644 0 -2.5 Mabsadd L
.69667 .00644 -1.875 0 Mabsadd L closepath F
.7 .00644 -1.875 0 Mabsadd m
.7 .00644 0 2.5 Mabsadd L
.7 .00644 1.875 0 Mabsadd L
.7 .00644 0 -2.5 Mabsadd L
.7 .00644 -1.875 0 Mabsadd L closepath F
.70333 .00644 -1.875 0 Mabsadd m
.70333 .00644 0 2.5 Mabsadd L
.70333 .00644 1.875 0 Mabsadd L
.70333 .00644 0 -2.5 Mabsadd L
.70333 .00644 -1.875 0 Mabsadd L closepath F
.70667 .00644 -1.875 0 Mabsadd m
.70667 .00644 0 2.5 Mabsadd L
.70667 .00644 1.875 0 Mabsadd L
.70667 .00644 0 -2.5 Mabsadd L
.70667 .00644 -1.875 0 Mabsadd L closepath F
.71 .00644 -1.875 0 Mabsadd m
.71 .00644 0 2.5 Mabsadd L
.71 .00644 1.875 0 Mabsadd L
.71 .00644 0 -2.5 Mabsadd L
.71 .00644 -1.875 0 Mabsadd L closepath F
.71333 .00644 -1.875 0 Mabsadd m
.71333 .00644 0 2.5 Mabsadd L
.71333 .00644 1.875 0 Mabsadd L
.71333 .00644 0 -2.5 Mabsadd L
.71333 .00644 -1.875 0 Mabsadd L closepath F
.71667 .00644 -1.875 0 Mabsadd m
.71667 .00644 0 2.5 Mabsadd L
.71667 .00644 1.875 0 Mabsadd L
.71667 .00644 0 -2.5 Mabsadd L
.71667 .00644 -1.875 0 Mabsadd L closepath F
.72 .00644 -1.875 0 Mabsadd m
.72 .00644 0 2.5 Mabsadd L
.72 .00644 1.875 0 Mabsadd L
.72 .00644 0 -2.5 Mabsadd L
.72 .00644 -1.875 0 Mabsadd L closepath F
.72333 .00644 -1.875 0 Mabsadd m
.72333 .00644 0 2.5 Mabsadd L
.72333 .00644 1.875 0 Mabsadd L
.72333 .00644 0 -2.5 Mabsadd L
.72333 .00644 -1.875 0 Mabsadd L closepath F
.72667 .00644 -1.875 0 Mabsadd m
.72667 .00644 0 2.5 Mabsadd L
.72667 .00644 1.875 0 Mabsadd L
.72667 .00644 0 -2.5 Mabsadd L
.72667 .00644 -1.875 0 Mabsadd L closepath F
.73 .00644 -1.875 0 Mabsadd m
.73 .00644 0 2.5 Mabsadd L
.73 .00644 1.875 0 Mabsadd L
.73 .00644 0 -2.5 Mabsadd L
.73 .00644 -1.875 0 Mabsadd L closepath F
.73333 .00644 -1.875 0 Mabsadd m
.73333 .00644 0 2.5 Mabsadd L
.73333 .00644 1.875 0 Mabsadd L
.73333 .00644 0 -2.5 Mabsadd L
.73333 .00644 -1.875 0 Mabsadd L closepath F
.73667 .00644 -1.875 0 Mabsadd m
.73667 .00644 0 2.5 Mabsadd L
.73667 .00644 1.875 0 Mabsadd L
.73667 .00644 0 -2.5 Mabsadd L
.73667 .00644 -1.875 0 Mabsadd L closepath F
.74 .00644 -1.875 0 Mabsadd m
.74 .00644 0 2.5 Mabsadd L
.74 .00644 1.875 0 Mabsadd L
.74 .00644 0 -2.5 Mabsadd L
.74 .00644 -1.875 0 Mabsadd L closepath F
.74333 .00644 -1.875 0 Mabsadd m
.74333 .00644 0 2.5 Mabsadd L
.74333 .00644 1.875 0 Mabsadd L
.74333 .00644 0 -2.5 Mabsadd L
.74333 .00644 -1.875 0 Mabsadd L closepath F
.74667 .00644 -1.875 0 Mabsadd m
.74667 .00644 0 2.5 Mabsadd L
.74667 .00644 1.875 0 Mabsadd L
.74667 .00644 0 -2.5 Mabsadd L
.74667 .00644 -1.875 0 Mabsadd L closepath F
.75 .00644 -1.875 0 Mabsadd m
.75 .00644 0 2.5 Mabsadd L
.75 .00644 1.875 0 Mabsadd L
.75 .00644 0 -2.5 Mabsadd L
.75 .00644 -1.875 0 Mabsadd L closepath F
.75333 .00644 -1.875 0 Mabsadd m
.75333 .00644 0 2.5 Mabsadd L
.75333 .00644 1.875 0 Mabsadd L
.75333 .00644 0 -2.5 Mabsadd L
.75333 .00644 -1.875 0 Mabsadd L closepath F
.75667 .00644 -1.875 0 Mabsadd m
.75667 .00644 0 2.5 Mabsadd L
.75667 .00644 1.875 0 Mabsadd L
.75667 .00644 0 -2.5 Mabsadd L
.75667 .00644 -1.875 0 Mabsadd L closepath F
.76 .00644 -1.875 0 Mabsadd m
.76 .00644 0 2.5 Mabsadd L
.76 .00644 1.875 0 Mabsadd L
.76 .00644 0 -2.5 Mabsadd L
.76 .00644 -1.875 0 Mabsadd L closepath F
.76333 .00644 -1.875 0 Mabsadd m
.76333 .00644 0 2.5 Mabsadd L
.76333 .00644 1.875 0 Mabsadd L
.76333 .00644 0 -2.5 Mabsadd L
.76333 .00644 -1.875 0 Mabsadd L closepath F
.76667 .00644 -1.875 0 Mabsadd m
.76667 .00644 0 2.5 Mabsadd L
.76667 .00644 1.875 0 Mabsadd L
.76667 .00644 0 -2.5 Mabsadd L
.76667 .00644 -1.875 0 Mabsadd L closepath F
.77 .00644 -1.875 0 Mabsadd m
.77 .00644 0 2.5 Mabsadd L
.77 .00644 1.875 0 Mabsadd L
.77 .00644 0 -2.5 Mabsadd L
.77 .00644 -1.875 0 Mabsadd L closepath F
.77333 .00644 -1.875 0 Mabsadd m
.77333 .00644 0 2.5 Mabsadd L
.77333 .00644 1.875 0 Mabsadd L
.77333 .00644 0 -2.5 Mabsadd L
.77333 .00644 -1.875 0 Mabsadd L closepath F
.77667 .00644 -1.875 0 Mabsadd m
.77667 .00644 0 2.5 Mabsadd L
.77667 .00644 1.875 0 Mabsadd L
.77667 .00644 0 -2.5 Mabsadd L
.77667 .00644 -1.875 0 Mabsadd L closepath F
.78 .00644 -1.875 0 Mabsadd m
.78 .00644 0 2.5 Mabsadd L
.78 .00644 1.875 0 Mabsadd L
.78 .00644 0 -2.5 Mabsadd L
.78 .00644 -1.875 0 Mabsadd L closepath F
.78333 .00644 -1.875 0 Mabsadd m
.78333 .00644 0 2.5 Mabsadd L
.78333 .00644 1.875 0 Mabsadd L
.78333 .00644 0 -2.5 Mabsadd L
.78333 .00644 -1.875 0 Mabsadd L closepath F
.78667 .00644 -1.875 0 Mabsadd m
.78667 .00644 0 2.5 Mabsadd L
.78667 .00644 1.875 0 Mabsadd L
.78667 .00644 0 -2.5 Mabsadd L
.78667 .00644 -1.875 0 Mabsadd L closepath F
.79 .00644 -1.875 0 Mabsadd m
.79 .00644 0 2.5 Mabsadd L
.79 .00644 1.875 0 Mabsadd L
.79 .00644 0 -2.5 Mabsadd L
.79 .00644 -1.875 0 Mabsadd L closepath F
.79333 .00644 -1.875 0 Mabsadd m
.79333 .00644 0 2.5 Mabsadd L
.79333 .00644 1.875 0 Mabsadd L
.79333 .00644 0 -2.5 Mabsadd L
.79333 .00644 -1.875 0 Mabsadd L closepath F
.79667 .00644 -1.875 0 Mabsadd m
.79667 .00644 0 2.5 Mabsadd L
.79667 .00644 1.875 0 Mabsadd L
.79667 .00644 0 -2.5 Mabsadd L
.79667 .00644 -1.875 0 Mabsadd L closepath F
.8 .00644 -1.875 0 Mabsadd m
.8 .00644 0 2.5 Mabsadd L
.8 .00644 1.875 0 Mabsadd L
.8 .00644 0 -2.5 Mabsadd L
.8 .00644 -1.875 0 Mabsadd L closepath F
.80333 .00644 -1.875 0 Mabsadd m
.80333 .00644 0 2.5 Mabsadd L
.80333 .00644 1.875 0 Mabsadd L
.80333 .00644 0 -2.5 Mabsadd L
.80333 .00644 -1.875 0 Mabsadd L closepath F
.80667 .00644 -1.875 0 Mabsadd m
.80667 .00644 0 2.5 Mabsadd L
.80667 .00644 1.875 0 Mabsadd L
.80667 .00644 0 -2.5 Mabsadd L
.80667 .00644 -1.875 0 Mabsadd L closepath F
.81 .00644 -1.875 0 Mabsadd m
.81 .00644 0 2.5 Mabsadd L
.81 .00644 1.875 0 Mabsadd L
.81 .00644 0 -2.5 Mabsadd L
.81 .00644 -1.875 0 Mabsadd L closepath F
.81333 .00644 -1.875 0 Mabsadd m
.81333 .00644 0 2.5 Mabsadd L
.81333 .00644 1.875 0 Mabsadd L
.81333 .00644 0 -2.5 Mabsadd L
.81333 .00644 -1.875 0 Mabsadd L closepath F
.81667 .00644 -1.875 0 Mabsadd m
.81667 .00644 0 2.5 Mabsadd L
.81667 .00644 1.875 0 Mabsadd L
.81667 .00644 0 -2.5 Mabsadd L
.81667 .00644 -1.875 0 Mabsadd L closepath F
.82 .00645 -1.875 0 Mabsadd m
.82 .00645 0 2.5 Mabsadd L
.82 .00645 1.875 0 Mabsadd L
.82 .00645 0 -2.5 Mabsadd L
.82 .00645 -1.875 0 Mabsadd L closepath F
.82333 .00654 -1.875 0 Mabsadd m
.82333 .00654 0 2.5 Mabsadd L
.82333 .00654 1.875 0 Mabsadd L
.82333 .00654 0 -2.5 Mabsadd L
.82333 .00654 -1.875 0 Mabsadd L closepath F
.82667 .00699 -1.875 0 Mabsadd m
.82667 .00699 0 2.5 Mabsadd L
.82667 .00699 1.875 0 Mabsadd L
.82667 .00699 0 -2.5 Mabsadd L
.82667 .00699 -1.875 0 Mabsadd L closepath F
.83 .00884 -1.875 0 Mabsadd m
.83 .00884 0 2.5 Mabsadd L
.83 .00884 1.875 0 Mabsadd L
.83 .00884 0 -2.5 Mabsadd L
.83 .00884 -1.875 0 Mabsadd L closepath F
.83333 .015 -1.875 0 Mabsadd m
.83333 .015 0 2.5 Mabsadd L
.83333 .015 1.875 0 Mabsadd L
.83333 .015 0 -2.5 Mabsadd L
.83333 .015 -1.875 0 Mabsadd L closepath F
.83667 .03159 -1.875 0 Mabsadd m
.83667 .03159 0 2.5 Mabsadd L
.83667 .03159 1.875 0 Mabsadd L
.83667 .03159 0 -2.5 Mabsadd L
.83667 .03159 -1.875 0 Mabsadd L closepath F
.84 .06717 -1.875 0 Mabsadd m
.84 .06717 0 2.5 Mabsadd L
.84 .06717 1.875 0 Mabsadd L
.84 .06717 0 -2.5 Mabsadd L
.84 .06717 -1.875 0 Mabsadd L closepath F
.84333 .12697 -1.875 0 Mabsadd m
.84333 .12697 0 2.5 Mabsadd L
.84333 .12697 1.875 0 Mabsadd L
.84333 .12697 0 -2.5 Mabsadd L
.84333 .12697 -1.875 0 Mabsadd L closepath F
.84667 .20311 -1.875 0 Mabsadd m
.84667 .20311 0 2.5 Mabsadd L
.84667 .20311 1.875 0 Mabsadd L
.84667 .20311 0 -2.5 Mabsadd L
.84667 .20311 -1.875 0 Mabsadd L closepath F
.85 .27027 -1.875 0 Mabsadd m
.85 .27027 0 2.5 Mabsadd L
.85 .27027 1.875 0 Mabsadd L
.85 .27027 0 -2.5 Mabsadd L
.85 .27027 -1.875 0 Mabsadd L closepath F
0 1 1 r
.001 w
0 .41794 m
.00333 .34475 L
.00667 .19443 L
.01 .07705 L
.01333 .02436 L
.01667 .00951 L
.02 .00679 L
.02333 .00647 L
.02667 .00644 L
.03 .00644 L
.03333 .00644 L
.03667 .00644 L
.04 .00644 L
.04333 .00644 L
.04667 .00644 L
.05 .00644 L
.05333 .00644 L
.05667 .00644 L
.06 .00644 L
.06333 .00644 L
.06667 .00644 L
.07 .00644 L
.07333 .00644 L
.07667 .00644 L
.08 .00644 L
.08333 .00644 L
.08667 .00644 L
.09 .00644 L
.09333 .00644 L
.09667 .00644 L
.1 .00644 L
.10333 .00644 L
.10667 .00644 L
.11 .00644 L
.11333 .00644 L
.11667 .00644 L
.12 .00644 L
.12333 .00644 L
.12667 .00644 L
.13 .00644 L
.13333 .00644 L
.13667 .00644 L
.14 .00644 L
.14333 .00644 L
.14667 .00644 L
.15 .00644 L
.15333 .00644 L
.15667 .00644 L
.16 .00644 L
.16333 .00644 L
Mistroke
.16667 .00644 L
.17 .00644 L
.17333 .00644 L
.17667 .00644 L
.18 .00644 L
.18333 .00644 L
.18667 .00644 L
.19 .00644 L
.19333 .00644 L
.19667 .00644 L
.2 .00644 L
.20333 .00644 L
.20667 .00644 L
.21 .00644 L
.21333 .00644 L
.21667 .00644 L
.22 .00644 L
.22333 .00644 L
.22667 .00644 L
.23 .00644 L
.23333 .00644 L
.23667 .00644 L
.24 .00644 L
.24333 .00644 L
.24667 .00644 L
.25 .00644 L
.25333 .00644 L
.25667 .00644 L
.26 .00644 L
.26333 .00644 L
.26667 .00644 L
.27 .00644 L
.27333 .00644 L
.27667 .00644 L
.28 .00644 L
.28333 .00644 L
.28667 .00644 L
.29 .00644 L
.29333 .00644 L
.29667 .00644 L
.3 .00644 L
.30333 .00644 L
.30667 .00644 L
.31 .00644 L
.31333 .00644 L
.31667 .00644 L
.32 .00644 L
.32333 .00644 L
.32667 .00644 L
.33 .00644 L
Mistroke
.33333 .00644 L
.33667 .00644 L
.34 .00644 L
.34333 .00644 L
.34667 .00644 L
.35 .00644 L
.35333 .00644 L
.35667 .00644 L
.36 .00644 L
.36333 .00644 L
.36667 .00644 L
.37 .00644 L
.37333 .00644 L
.37667 .00644 L
.38 .00644 L
.38333 .00644 L
.38667 .00644 L
.39 .00644 L
.39333 .00644 L
.39667 .00644 L
.4 .00644 L
.40333 .00644 L
.40667 .00644 L
.41 .00644 L
.41333 .00644 L
.41667 .00644 L
.42 .00644 L
.42333 .00644 L
.42667 .00644 L
.43 .00644 L
.43333 .00644 L
.43667 .00644 L
.44 .00644 L
.44333 .00644 L
.44667 .00644 L
.45 .00644 L
.45333 .00644 L
.45667 .00644 L
.46 .00644 L
.46333 .00644 L
.46667 .00644 L
.47 .00644 L
.47333 .00644 L
.47667 .00644 L
.48 .00644 L
.48333 .00644 L
.48667 .00644 L
.49 .00644 L
.49333 .00644 L
.49667 .00644 L
Mistroke
.5 .00644 L
.50333 .00644 L
.50667 .00644 L
.51 .00644 L
.51333 .00644 L
.51667 .00644 L
.52 .00644 L
.52333 .00644 L
.52667 .00644 L
.53 .00644 L
.53333 .00644 L
.53667 .00644 L
.54 .00644 L
.54333 .00644 L
.54667 .00644 L
.55 .00644 L
.55333 .00644 L
.55667 .00644 L
.56 .00644 L
.56333 .00644 L
.56667 .00644 L
.57 .00644 L
.57333 .00644 L
.57667 .00644 L
.58 .00644 L
.58333 .00644 L
.58667 .00644 L
.59 .00644 L
.59333 .00644 L
.59667 .00644 L
.6 .00644 L
.60333 .00644 L
.60667 .00644 L
.61 .00644 L
.61333 .00644 L
.61667 .00644 L
.62 .00644 L
.62333 .00644 L
.62667 .00644 L
.63 .00644 L
.63333 .00644 L
.63667 .00644 L
.64 .00644 L
.64333 .00644 L
.64667 .00644 L
.65 .00644 L
.65333 .00644 L
.65667 .00644 L
.66 .00644 L
.66333 .00644 L
Mistroke
.66667 .00644 L
.67 .00644 L
.67333 .00644 L
.67667 .00644 L
.68 .00644 L
.68333 .00644 L
.68667 .00644 L
.69 .00644 L
.69333 .00644 L
.69667 .00644 L
.7 .00644 L
.70333 .00644 L
.70667 .00644 L
.71 .00644 L
.71333 .00644 L
.71667 .00644 L
.72 .00644 L
.72333 .00644 L
.72667 .00644 L
.73 .00644 L
.73333 .00644 L
.73667 .00644 L
.74 .00644 L
.74333 .00644 L
.74667 .00644 L
.75 .00644 L
.75333 .00644 L
.75667 .00644 L
.76 .00644 L
.76333 .00644 L
.76667 .00644 L
.77 .00644 L
.77333 .00644 L
.77667 .00644 L
.78 .00644 L
.78333 .00644 L
.78667 .00644 L
.79 .00644 L
.79333 .00644 L
.79667 .00644 L
.8 .00644 L
.80333 .00644 L
.80667 .00644 L
.81 .00644 L
.81333 .00644 L
.81667 .00644 L
.82 .00644 L
.82333 .00644 L
.82667 .00644 L
.83 .00647 L
Mistroke
.83333 .00679 L
.83667 .00951 L
.84 .02436 L
.84333 .07705 L
.84667 .19443 L
.85 .34475 L
Mfstroke
0 g
.0001 w
0 .41794 0 2.5 Mabsadd m
0 .41794 -0.56518 .7779 Mabsadd L
0 .41794 -2.37764 .77254 Mabsadd L
0 .41794 -0.91448 -0.29713 Mabsadd L
0 .41794 -1.46946 -2.02254 Mabsadd L
0 .41794 0 -0.96154 Mabsadd L
0 .41794 1.46946 -2.02254 Mabsadd L
0 .41794 .91448 -0.29713 Mabsadd L
0 .41794 2.37764 .77254 Mabsadd L
0 .41794 .56518 .7779 Mabsadd L
0 .41794 0 2.5 Mabsadd L closepath F
.00333 .34475 0 2.5 Mabsadd m
.00333 .34475 -0.56518 .7779 Mabsadd L
.00333 .34475 -2.37764 .77254 Mabsadd L
.00333 .34475 -0.91448 -0.29713 Mabsadd L
.00333 .34475 -1.46946 -2.02254 Mabsadd L
.00333 .34475 0 -0.96154 Mabsadd L
.00333 .34475 1.46946 -2.02254 Mabsadd L
.00333 .34475 .91448 -0.29713 Mabsadd L
.00333 .34475 2.37764 .77254 Mabsadd L
.00333 .34475 .56518 .7779 Mabsadd L
.00333 .34475 0 2.5 Mabsadd L closepath F
.00667 .19443 0 2.5 Mabsadd m
.00667 .19443 -0.56518 .7779 Mabsadd L
.00667 .19443 -2.37764 .77254 Mabsadd L
.00667 .19443 -0.91448 -0.29713 Mabsadd L
.00667 .19443 -1.46946 -2.02254 Mabsadd L
.00667 .19443 0 -0.96154 Mabsadd L
.00667 .19443 1.46946 -2.02254 Mabsadd L
.00667 .19443 .91448 -0.29713 Mabsadd L
.00667 .19443 2.37764 .77254 Mabsadd L
.00667 .19443 .56518 .7779 Mabsadd L
.00667 .19443 0 2.5 Mabsadd L closepath F
.01 .07705 0 2.5 Mabsadd m
.01 .07705 -0.56518 .7779 Mabsadd L
.01 .07705 -2.37764 .77254 Mabsadd L
.01 .07705 -0.91448 -0.29713 Mabsadd L
.01 .07705 -1.46946 -2.02254 Mabsadd L
.01 .07705 0 -0.96154 Mabsadd L
.01 .07705 1.46946 -2.02254 Mabsadd L
.01 .07705 .91448 -0.29713 Mabsadd L
.01 .07705 2.37764 .77254 Mabsadd L
.01 .07705 .56518 .7779 Mabsadd L
.01 .07705 0 2.5 Mabsadd L closepath F
.01333 .02436 0 2.5 Mabsadd m
.01333 .02436 -0.56518 .7779 Mabsadd L
.01333 .02436 -2.37764 .77254 Mabsadd L
.01333 .02436 -0.91448 -0.29713 Mabsadd L
.01333 .02436 -1.46946 -2.02254 Mabsadd L
.01333 .02436 0 -0.96154 Mabsadd L
.01333 .02436 1.46946 -2.02254 Mabsadd L
.01333 .02436 .91448 -0.29713 Mabsadd L
.01333 .02436 2.37764 .77254 Mabsadd L
.01333 .02436 .56518 .7779 Mabsadd L
.01333 .02436 0 2.5 Mabsadd L closepath F
.01667 .00951 0 2.5 Mabsadd m
.01667 .00951 -0.56518 .7779 Mabsadd L
.01667 .00951 -2.37764 .77254 Mabsadd L
.01667 .00951 -0.91448 -0.29713 Mabsadd L
.01667 .00951 -1.46946 -2.02254 Mabsadd L
.01667 .00951 0 -0.96154 Mabsadd L
.01667 .00951 1.46946 -2.02254 Mabsadd L
.01667 .00951 .91448 -0.29713 Mabsadd L
.01667 .00951 2.37764 .77254 Mabsadd L
.01667 .00951 .56518 .7779 Mabsadd L
.01667 .00951 0 2.5 Mabsadd L closepath F
.02 .00679 0 2.5 Mabsadd m
.02 .00679 -0.56518 .7779 Mabsadd L
.02 .00679 -2.37764 .77254 Mabsadd L
.02 .00679 -0.91448 -0.29713 Mabsadd L
.02 .00679 -1.46946 -2.02254 Mabsadd L
.02 .00679 0 -0.96154 Mabsadd L
.02 .00679 1.46946 -2.02254 Mabsadd L
.02 .00679 .91448 -0.29713 Mabsadd L
.02 .00679 2.37764 .77254 Mabsadd L
.02 .00679 .56518 .7779 Mabsadd L
.02 .00679 0 2.5 Mabsadd L closepath F
.02333 .00647 0 2.5 Mabsadd m
.02333 .00647 -0.56518 .7779 Mabsadd L
.02333 .00647 -2.37764 .77254 Mabsadd L
.02333 .00647 -0.91448 -0.29713 Mabsadd L
.02333 .00647 -1.46946 -2.02254 Mabsadd L
.02333 .00647 0 -0.96154 Mabsadd L
.02333 .00647 1.46946 -2.02254 Mabsadd L
.02333 .00647 .91448 -0.29713 Mabsadd L
.02333 .00647 2.37764 .77254 Mabsadd L
.02333 .00647 .56518 .7779 Mabsadd L
.02333 .00647 0 2.5 Mabsadd L closepath F
.02667 .00644 0 2.5 Mabsadd m
.02667 .00644 -0.56518 .7779 Mabsadd L
.02667 .00644 -2.37764 .77254 Mabsadd L
.02667 .00644 -0.91448 -0.29713 Mabsadd L
.02667 .00644 -1.46946 -2.02254 Mabsadd L
.02667 .00644 0 -0.96154 Mabsadd L
.02667 .00644 1.46946 -2.02254 Mabsadd L
.02667 .00644 .91448 -0.29713 Mabsadd L
.02667 .00644 2.37764 .77254 Mabsadd L
.02667 .00644 .56518 .7779 Mabsadd L
.02667 .00644 0 2.5 Mabsadd L closepath F
.03 .00644 0 2.5 Mabsadd m
.03 .00644 -0.56518 .7779 Mabsadd L
.03 .00644 -2.37764 .77254 Mabsadd L
.03 .00644 -0.91448 -0.29713 Mabsadd L
.03 .00644 -1.46946 -2.02254 Mabsadd L
.03 .00644 0 -0.96154 Mabsadd L
.03 .00644 1.46946 -2.02254 Mabsadd L
.03 .00644 .91448 -0.29713 Mabsadd L
.03 .00644 2.37764 .77254 Mabsadd L
.03 .00644 .56518 .7779 Mabsadd L
.03 .00644 0 2.5 Mabsadd L closepath F
.03333 .00644 0 2.5 Mabsadd m
.03333 .00644 -0.56518 .7779 Mabsadd L
.03333 .00644 -2.37764 .77254 Mabsadd L
.03333 .00644 -0.91448 -0.29713 Mabsadd L
.03333 .00644 -1.46946 -2.02254 Mabsadd L
.03333 .00644 0 -0.96154 Mabsadd L
.03333 .00644 1.46946 -2.02254 Mabsadd L
.03333 .00644 .91448 -0.29713 Mabsadd L
.03333 .00644 2.37764 .77254 Mabsadd L
.03333 .00644 .56518 .7779 Mabsadd L
.03333 .00644 0 2.5 Mabsadd L closepath F
.03667 .00644 0 2.5 Mabsadd m
.03667 .00644 -0.56518 .7779 Mabsadd L
.03667 .00644 -2.37764 .77254 Mabsadd L
.03667 .00644 -0.91448 -0.29713 Mabsadd L
.03667 .00644 -1.46946 -2.02254 Mabsadd L
.03667 .00644 0 -0.96154 Mabsadd L
.03667 .00644 1.46946 -2.02254 Mabsadd L
.03667 .00644 .91448 -0.29713 Mabsadd L
.03667 .00644 2.37764 .77254 Mabsadd L
.03667 .00644 .56518 .7779 Mabsadd L
.03667 .00644 0 2.5 Mabsadd L closepath F
.04 .00644 0 2.5 Mabsadd m
.04 .00644 -0.56518 .7779 Mabsadd L
.04 .00644 -2.37764 .77254 Mabsadd L
.04 .00644 -0.91448 -0.29713 Mabsadd L
.04 .00644 -1.46946 -2.02254 Mabsadd L
.04 .00644 0 -0.96154 Mabsadd L
.04 .00644 1.46946 -2.02254 Mabsadd L
.04 .00644 .91448 -0.29713 Mabsadd L
.04 .00644 2.37764 .77254 Mabsadd L
.04 .00644 .56518 .7779 Mabsadd L
.04 .00644 0 2.5 Mabsadd L closepath F
.04333 .00644 0 2.5 Mabsadd m
.04333 .00644 -0.56518 .7779 Mabsadd L
.04333 .00644 -2.37764 .77254 Mabsadd L
.04333 .00644 -0.91448 -0.29713 Mabsadd L
.04333 .00644 -1.46946 -2.02254 Mabsadd L
.04333 .00644 0 -0.96154 Mabsadd L
.04333 .00644 1.46946 -2.02254 Mabsadd L
.04333 .00644 .91448 -0.29713 Mabsadd L
.04333 .00644 2.37764 .77254 Mabsadd L
.04333 .00644 .56518 .7779 Mabsadd L
.04333 .00644 0 2.5 Mabsadd L closepath F
.04667 .00644 0 2.5 Mabsadd m
.04667 .00644 -0.56518 .7779 Mabsadd L
.04667 .00644 -2.37764 .77254 Mabsadd L
.04667 .00644 -0.91448 -0.29713 Mabsadd L
.04667 .00644 -1.46946 -2.02254 Mabsadd L
.04667 .00644 0 -0.96154 Mabsadd L
.04667 .00644 1.46946 -2.02254 Mabsadd L
.04667 .00644 .91448 -0.29713 Mabsadd L
.04667 .00644 2.37764 .77254 Mabsadd L
.04667 .00644 .56518 .7779 Mabsadd L
.04667 .00644 0 2.5 Mabsadd L closepath F
.05 .00644 0 2.5 Mabsadd m
.05 .00644 -0.56518 .7779 Mabsadd L
.05 .00644 -2.37764 .77254 Mabsadd L
.05 .00644 -0.91448 -0.29713 Mabsadd L
.05 .00644 -1.46946 -2.02254 Mabsadd L
.05 .00644 0 -0.96154 Mabsadd L
.05 .00644 1.46946 -2.02254 Mabsadd L
.05 .00644 .91448 -0.29713 Mabsadd L
.05 .00644 2.37764 .77254 Mabsadd L
.05 .00644 .56518 .7779 Mabsadd L
.05 .00644 0 2.5 Mabsadd L closepath F
.05333 .00644 0 2.5 Mabsadd m
.05333 .00644 -0.56518 .7779 Mabsadd L
.05333 .00644 -2.37764 .77254 Mabsadd L
.05333 .00644 -0.91448 -0.29713 Mabsadd L
.05333 .00644 -1.46946 -2.02254 Mabsadd L
.05333 .00644 0 -0.96154 Mabsadd L
.05333 .00644 1.46946 -2.02254 Mabsadd L
.05333 .00644 .91448 -0.29713 Mabsadd L
.05333 .00644 2.37764 .77254 Mabsadd L
.05333 .00644 .56518 .7779 Mabsadd L
.05333 .00644 0 2.5 Mabsadd L closepath F
.05667 .00644 0 2.5 Mabsadd m
.05667 .00644 -0.56518 .7779 Mabsadd L
.05667 .00644 -2.37764 .77254 Mabsadd L
.05667 .00644 -0.91448 -0.29713 Mabsadd L
.05667 .00644 -1.46946 -2.02254 Mabsadd L
.05667 .00644 0 -0.96154 Mabsadd L
.05667 .00644 1.46946 -2.02254 Mabsadd L
.05667 .00644 .91448 -0.29713 Mabsadd L
.05667 .00644 2.37764 .77254 Mabsadd L
.05667 .00644 .56518 .7779 Mabsadd L
.05667 .00644 0 2.5 Mabsadd L closepath F
.06 .00644 0 2.5 Mabsadd m
.06 .00644 -0.56518 .7779 Mabsadd L
.06 .00644 -2.37764 .77254 Mabsadd L
.06 .00644 -0.91448 -0.29713 Mabsadd L
.06 .00644 -1.46946 -2.02254 Mabsadd L
.06 .00644 0 -0.96154 Mabsadd L
.06 .00644 1.46946 -2.02254 Mabsadd L
.06 .00644 .91448 -0.29713 Mabsadd L
.06 .00644 2.37764 .77254 Mabsadd L
.06 .00644 .56518 .7779 Mabsadd L
.06 .00644 0 2.5 Mabsadd L closepath F
.06333 .00644 0 2.5 Mabsadd m
.06333 .00644 -0.56518 .7779 Mabsadd L
.06333 .00644 -2.37764 .77254 Mabsadd L
.06333 .00644 -0.91448 -0.29713 Mabsadd L
.06333 .00644 -1.46946 -2.02254 Mabsadd L
.06333 .00644 0 -0.96154 Mabsadd L
.06333 .00644 1.46946 -2.02254 Mabsadd L
.06333 .00644 .91448 -0.29713 Mabsadd L
.06333 .00644 2.37764 .77254 Mabsadd L
.06333 .00644 .56518 .7779 Mabsadd L
.06333 .00644 0 2.5 Mabsadd L closepath F
.06667 .00644 0 2.5 Mabsadd m
.06667 .00644 -0.56518 .7779 Mabsadd L
.06667 .00644 -2.37764 .77254 Mabsadd L
.06667 .00644 -0.91448 -0.29713 Mabsadd L
.06667 .00644 -1.46946 -2.02254 Mabsadd L
.06667 .00644 0 -0.96154 Mabsadd L
.06667 .00644 1.46946 -2.02254 Mabsadd L
.06667 .00644 .91448 -0.29713 Mabsadd L
.06667 .00644 2.37764 .77254 Mabsadd L
.06667 .00644 .56518 .7779 Mabsadd L
.06667 .00644 0 2.5 Mabsadd L closepath F
.07 .00644 0 2.5 Mabsadd m
.07 .00644 -0.56518 .7779 Mabsadd L
.07 .00644 -2.37764 .77254 Mabsadd L
.07 .00644 -0.91448 -0.29713 Mabsadd L
.07 .00644 -1.46946 -2.02254 Mabsadd L
.07 .00644 0 -0.96154 Mabsadd L
.07 .00644 1.46946 -2.02254 Mabsadd L
.07 .00644 .91448 -0.29713 Mabsadd L
.07 .00644 2.37764 .77254 Mabsadd L
.07 .00644 .56518 .7779 Mabsadd L
.07 .00644 0 2.5 Mabsadd L closepath F
.07333 .00644 0 2.5 Mabsadd m
.07333 .00644 -0.56518 .7779 Mabsadd L
.07333 .00644 -2.37764 .77254 Mabsadd L
.07333 .00644 -0.91448 -0.29713 Mabsadd L
.07333 .00644 -1.46946 -2.02254 Mabsadd L
.07333 .00644 0 -0.96154 Mabsadd L
.07333 .00644 1.46946 -2.02254 Mabsadd L
.07333 .00644 .91448 -0.29713 Mabsadd L
.07333 .00644 2.37764 .77254 Mabsadd L
.07333 .00644 .56518 .7779 Mabsadd L
.07333 .00644 0 2.5 Mabsadd L closepath F
.07667 .00644 0 2.5 Mabsadd m
.07667 .00644 -0.56518 .7779 Mabsadd L
.07667 .00644 -2.37764 .77254 Mabsadd L
.07667 .00644 -0.91448 -0.29713 Mabsadd L
.07667 .00644 -1.46946 -2.02254 Mabsadd L
.07667 .00644 0 -0.96154 Mabsadd L
.07667 .00644 1.46946 -2.02254 Mabsadd L
.07667 .00644 .91448 -0.29713 Mabsadd L
.07667 .00644 2.37764 .77254 Mabsadd L
.07667 .00644 .56518 .7779 Mabsadd L
.07667 .00644 0 2.5 Mabsadd L closepath F
.08 .00644 0 2.5 Mabsadd m
.08 .00644 -0.56518 .7779 Mabsadd L
.08 .00644 -2.37764 .77254 Mabsadd L
.08 .00644 -0.91448 -0.29713 Mabsadd L
.08 .00644 -1.46946 -2.02254 Mabsadd L
.08 .00644 0 -0.96154 Mabsadd L
.08 .00644 1.46946 -2.02254 Mabsadd L
.08 .00644 .91448 -0.29713 Mabsadd L
.08 .00644 2.37764 .77254 Mabsadd L
.08 .00644 .56518 .7779 Mabsadd L
.08 .00644 0 2.5 Mabsadd L closepath F
.08333 .00644 0 2.5 Mabsadd m
.08333 .00644 -0.56518 .7779 Mabsadd L
.08333 .00644 -2.37764 .77254 Mabsadd L
.08333 .00644 -0.91448 -0.29713 Mabsadd L
.08333 .00644 -1.46946 -2.02254 Mabsadd L
.08333 .00644 0 -0.96154 Mabsadd L
.08333 .00644 1.46946 -2.02254 Mabsadd L
.08333 .00644 .91448 -0.29713 Mabsadd L
.08333 .00644 2.37764 .77254 Mabsadd L
.08333 .00644 .56518 .7779 Mabsadd L
.08333 .00644 0 2.5 Mabsadd L closepath F
.08667 .00644 0 2.5 Mabsadd m
.08667 .00644 -0.56518 .7779 Mabsadd L
.08667 .00644 -2.37764 .77254 Mabsadd L
.08667 .00644 -0.91448 -0.29713 Mabsadd L
.08667 .00644 -1.46946 -2.02254 Mabsadd L
.08667 .00644 0 -0.96154 Mabsadd L
.08667 .00644 1.46946 -2.02254 Mabsadd L
.08667 .00644 .91448 -0.29713 Mabsadd L
.08667 .00644 2.37764 .77254 Mabsadd L
.08667 .00644 .56518 .7779 Mabsadd L
.08667 .00644 0 2.5 Mabsadd L closepath F
.09 .00644 0 2.5 Mabsadd m
.09 .00644 -0.56518 .7779 Mabsadd L
.09 .00644 -2.37764 .77254 Mabsadd L
.09 .00644 -0.91448 -0.29713 Mabsadd L
.09 .00644 -1.46946 -2.02254 Mabsadd L
.09 .00644 0 -0.96154 Mabsadd L
.09 .00644 1.46946 -2.02254 Mabsadd L
.09 .00644 .91448 -0.29713 Mabsadd L
.09 .00644 2.37764 .77254 Mabsadd L
.09 .00644 .56518 .7779 Mabsadd L
.09 .00644 0 2.5 Mabsadd L closepath F
.09333 .00644 0 2.5 Mabsadd m
.09333 .00644 -0.56518 .7779 Mabsadd L
.09333 .00644 -2.37764 .77254 Mabsadd L
.09333 .00644 -0.91448 -0.29713 Mabsadd L
.09333 .00644 -1.46946 -2.02254 Mabsadd L
.09333 .00644 0 -0.96154 Mabsadd L
.09333 .00644 1.46946 -2.02254 Mabsadd L
.09333 .00644 .91448 -0.29713 Mabsadd L
.09333 .00644 2.37764 .77254 Mabsadd L
.09333 .00644 .56518 .7779 Mabsadd L
.09333 .00644 0 2.5 Mabsadd L closepath F
.09667 .00644 0 2.5 Mabsadd m
.09667 .00644 -0.56518 .7779 Mabsadd L
.09667 .00644 -2.37764 .77254 Mabsadd L
.09667 .00644 -0.91448 -0.29713 Mabsadd L
.09667 .00644 -1.46946 -2.02254 Mabsadd L
.09667 .00644 0 -0.96154 Mabsadd L
.09667 .00644 1.46946 -2.02254 Mabsadd L
.09667 .00644 .91448 -0.29713 Mabsadd L
.09667 .00644 2.37764 .77254 Mabsadd L
.09667 .00644 .56518 .7779 Mabsadd L
.09667 .00644 0 2.5 Mabsadd L closepath F
.1 .00644 0 2.5 Mabsadd m
.1 .00644 -0.56518 .7779 Mabsadd L
.1 .00644 -2.37764 .77254 Mabsadd L
.1 .00644 -0.91448 -0.29713 Mabsadd L
.1 .00644 -1.46946 -2.02254 Mabsadd L
.1 .00644 0 -0.96154 Mabsadd L
.1 .00644 1.46946 -2.02254 Mabsadd L
.1 .00644 .91448 -0.29713 Mabsadd L
.1 .00644 2.37764 .77254 Mabsadd L
.1 .00644 .56518 .7779 Mabsadd L
.1 .00644 0 2.5 Mabsadd L closepath F
.10333 .00644 0 2.5 Mabsadd m
.10333 .00644 -0.56518 .7779 Mabsadd L
.10333 .00644 -2.37764 .77254 Mabsadd L
.10333 .00644 -0.91448 -0.29713 Mabsadd L
.10333 .00644 -1.46946 -2.02254 Mabsadd L
.10333 .00644 0 -0.96154 Mabsadd L
.10333 .00644 1.46946 -2.02254 Mabsadd L
.10333 .00644 .91448 -0.29713 Mabsadd L
.10333 .00644 2.37764 .77254 Mabsadd L
.10333 .00644 .56518 .7779 Mabsadd L
.10333 .00644 0 2.5 Mabsadd L closepath F
.10667 .00644 0 2.5 Mabsadd m
.10667 .00644 -0.56518 .7779 Mabsadd L
.10667 .00644 -2.37764 .77254 Mabsadd L
.10667 .00644 -0.91448 -0.29713 Mabsadd L
.10667 .00644 -1.46946 -2.02254 Mabsadd L
.10667 .00644 0 -0.96154 Mabsadd L
.10667 .00644 1.46946 -2.02254 Mabsadd L
.10667 .00644 .91448 -0.29713 Mabsadd L
.10667 .00644 2.37764 .77254 Mabsadd L
.10667 .00644 .56518 .7779 Mabsadd L
.10667 .00644 0 2.5 Mabsadd L closepath F
.11 .00644 0 2.5 Mabsadd m
.11 .00644 -0.56518 .7779 Mabsadd L
.11 .00644 -2.37764 .77254 Mabsadd L
.11 .00644 -0.91448 -0.29713 Mabsadd L
.11 .00644 -1.46946 -2.02254 Mabsadd L
.11 .00644 0 -0.96154 Mabsadd L
.11 .00644 1.46946 -2.02254 Mabsadd L
.11 .00644 .91448 -0.29713 Mabsadd L
.11 .00644 2.37764 .77254 Mabsadd L
.11 .00644 .56518 .7779 Mabsadd L
.11 .00644 0 2.5 Mabsadd L closepath F
.11333 .00644 0 2.5 Mabsadd m
.11333 .00644 -0.56518 .7779 Mabsadd L
.11333 .00644 -2.37764 .77254 Mabsadd L
.11333 .00644 -0.91448 -0.29713 Mabsadd L
.11333 .00644 -1.46946 -2.02254 Mabsadd L
.11333 .00644 0 -0.96154 Mabsadd L
.11333 .00644 1.46946 -2.02254 Mabsadd L
.11333 .00644 .91448 -0.29713 Mabsadd L
.11333 .00644 2.37764 .77254 Mabsadd L
.11333 .00644 .56518 .7779 Mabsadd L
.11333 .00644 0 2.5 Mabsadd L closepath F
.11667 .00644 0 2.5 Mabsadd m
.11667 .00644 -0.56518 .7779 Mabsadd L
.11667 .00644 -2.37764 .77254 Mabsadd L
.11667 .00644 -0.91448 -0.29713 Mabsadd L
.11667 .00644 -1.46946 -2.02254 Mabsadd L
.11667 .00644 0 -0.96154 Mabsadd L
.11667 .00644 1.46946 -2.02254 Mabsadd L
.11667 .00644 .91448 -0.29713 Mabsadd L
.11667 .00644 2.37764 .77254 Mabsadd L
.11667 .00644 .56518 .7779 Mabsadd L
.11667 .00644 0 2.5 Mabsadd L closepath F
.12 .00644 0 2.5 Mabsadd m
.12 .00644 -0.56518 .7779 Mabsadd L
.12 .00644 -2.37764 .77254 Mabsadd L
.12 .00644 -0.91448 -0.29713 Mabsadd L
.12 .00644 -1.46946 -2.02254 Mabsadd L
.12 .00644 0 -0.96154 Mabsadd L
.12 .00644 1.46946 -2.02254 Mabsadd L
.12 .00644 .91448 -0.29713 Mabsadd L
.12 .00644 2.37764 .77254 Mabsadd L
.12 .00644 .56518 .7779 Mabsadd L
.12 .00644 0 2.5 Mabsadd L closepath F
.12333 .00644 0 2.5 Mabsadd m
.12333 .00644 -0.56518 .7779 Mabsadd L
.12333 .00644 -2.37764 .77254 Mabsadd L
.12333 .00644 -0.91448 -0.29713 Mabsadd L
.12333 .00644 -1.46946 -2.02254 Mabsadd L
.12333 .00644 0 -0.96154 Mabsadd L
.12333 .00644 1.46946 -2.02254 Mabsadd L
.12333 .00644 .91448 -0.29713 Mabsadd L
.12333 .00644 2.37764 .77254 Mabsadd L
.12333 .00644 .56518 .7779 Mabsadd L
.12333 .00644 0 2.5 Mabsadd L closepath F
.12667 .00644 0 2.5 Mabsadd m
.12667 .00644 -0.56518 .7779 Mabsadd L
.12667 .00644 -2.37764 .77254 Mabsadd L
.12667 .00644 -0.91448 -0.29713 Mabsadd L
.12667 .00644 -1.46946 -2.02254 Mabsadd L
.12667 .00644 0 -0.96154 Mabsadd L
.12667 .00644 1.46946 -2.02254 Mabsadd L
.12667 .00644 .91448 -0.29713 Mabsadd L
.12667 .00644 2.37764 .77254 Mabsadd L
.12667 .00644 .56518 .7779 Mabsadd L
.12667 .00644 0 2.5 Mabsadd L closepath F
.13 .00644 0 2.5 Mabsadd m
.13 .00644 -0.56518 .7779 Mabsadd L
.13 .00644 -2.37764 .77254 Mabsadd L
.13 .00644 -0.91448 -0.29713 Mabsadd L
.13 .00644 -1.46946 -2.02254 Mabsadd L
.13 .00644 0 -0.96154 Mabsadd L
.13 .00644 1.46946 -2.02254 Mabsadd L
.13 .00644 .91448 -0.29713 Mabsadd L
.13 .00644 2.37764 .77254 Mabsadd L
.13 .00644 .56518 .7779 Mabsadd L
.13 .00644 0 2.5 Mabsadd L closepath F
.13333 .00644 0 2.5 Mabsadd m
.13333 .00644 -0.56518 .7779 Mabsadd L
.13333 .00644 -2.37764 .77254 Mabsadd L
.13333 .00644 -0.91448 -0.29713 Mabsadd L
.13333 .00644 -1.46946 -2.02254 Mabsadd L
.13333 .00644 0 -0.96154 Mabsadd L
.13333 .00644 1.46946 -2.02254 Mabsadd L
.13333 .00644 .91448 -0.29713 Mabsadd L
.13333 .00644 2.37764 .77254 Mabsadd L
.13333 .00644 .56518 .7779 Mabsadd L
.13333 .00644 0 2.5 Mabsadd L closepath F
.13667 .00644 0 2.5 Mabsadd m
.13667 .00644 -0.56518 .7779 Mabsadd L
.13667 .00644 -2.37764 .77254 Mabsadd L
.13667 .00644 -0.91448 -0.29713 Mabsadd L
.13667 .00644 -1.46946 -2.02254 Mabsadd L
.13667 .00644 0 -0.96154 Mabsadd L
.13667 .00644 1.46946 -2.02254 Mabsadd L
.13667 .00644 .91448 -0.29713 Mabsadd L
.13667 .00644 2.37764 .77254 Mabsadd L
.13667 .00644 .56518 .7779 Mabsadd L
.13667 .00644 0 2.5 Mabsadd L closepath F
.14 .00644 0 2.5 Mabsadd m
.14 .00644 -0.56518 .7779 Mabsadd L
.14 .00644 -2.37764 .77254 Mabsadd L
.14 .00644 -0.91448 -0.29713 Mabsadd L
.14 .00644 -1.46946 -2.02254 Mabsadd L
.14 .00644 0 -0.96154 Mabsadd L
.14 .00644 1.46946 -2.02254 Mabsadd L
.14 .00644 .91448 -0.29713 Mabsadd L
.14 .00644 2.37764 .77254 Mabsadd L
.14 .00644 .56518 .7779 Mabsadd L
.14 .00644 0 2.5 Mabsadd L closepath F
.14333 .00644 0 2.5 Mabsadd m
.14333 .00644 -0.56518 .7779 Mabsadd L
.14333 .00644 -2.37764 .77254 Mabsadd L
.14333 .00644 -0.91448 -0.29713 Mabsadd L
.14333 .00644 -1.46946 -2.02254 Mabsadd L
.14333 .00644 0 -0.96154 Mabsadd L
.14333 .00644 1.46946 -2.02254 Mabsadd L
.14333 .00644 .91448 -0.29713 Mabsadd L
.14333 .00644 2.37764 .77254 Mabsadd L
.14333 .00644 .56518 .7779 Mabsadd L
.14333 .00644 0 2.5 Mabsadd L closepath F
.14667 .00644 0 2.5 Mabsadd m
.14667 .00644 -0.56518 .7779 Mabsadd L
.14667 .00644 -2.37764 .77254 Mabsadd L
.14667 .00644 -0.91448 -0.29713 Mabsadd L
.14667 .00644 -1.46946 -2.02254 Mabsadd L
.14667 .00644 0 -0.96154 Mabsadd L
.14667 .00644 1.46946 -2.02254 Mabsadd L
.14667 .00644 .91448 -0.29713 Mabsadd L
.14667 .00644 2.37764 .77254 Mabsadd L
.14667 .00644 .56518 .7779 Mabsadd L
.14667 .00644 0 2.5 Mabsadd L closepath F
.15 .00644 0 2.5 Mabsadd m
.15 .00644 -0.56518 .7779 Mabsadd L
.15 .00644 -2.37764 .77254 Mabsadd L
.15 .00644 -0.91448 -0.29713 Mabsadd L
.15 .00644 -1.46946 -2.02254 Mabsadd L
.15 .00644 0 -0.96154 Mabsadd L
.15 .00644 1.46946 -2.02254 Mabsadd L
.15 .00644 .91448 -0.29713 Mabsadd L
.15 .00644 2.37764 .77254 Mabsadd L
.15 .00644 .56518 .7779 Mabsadd L
.15 .00644 0 2.5 Mabsadd L closepath F
.15333 .00644 0 2.5 Mabsadd m
.15333 .00644 -0.56518 .7779 Mabsadd L
.15333 .00644 -2.37764 .77254 Mabsadd L
.15333 .00644 -0.91448 -0.29713 Mabsadd L
.15333 .00644 -1.46946 -2.02254 Mabsadd L
.15333 .00644 0 -0.96154 Mabsadd L
.15333 .00644 1.46946 -2.02254 Mabsadd L
.15333 .00644 .91448 -0.29713 Mabsadd L
.15333 .00644 2.37764 .77254 Mabsadd L
.15333 .00644 .56518 .7779 Mabsadd L
.15333 .00644 0 2.5 Mabsadd L closepath F
.15667 .00644 0 2.5 Mabsadd m
.15667 .00644 -0.56518 .7779 Mabsadd L
.15667 .00644 -2.37764 .77254 Mabsadd L
.15667 .00644 -0.91448 -0.29713 Mabsadd L
.15667 .00644 -1.46946 -2.02254 Mabsadd L
.15667 .00644 0 -0.96154 Mabsadd L
.15667 .00644 1.46946 -2.02254 Mabsadd L
.15667 .00644 .91448 -0.29713 Mabsadd L
.15667 .00644 2.37764 .77254 Mabsadd L
.15667 .00644 .56518 .7779 Mabsadd L
.15667 .00644 0 2.5 Mabsadd L closepath F
.16 .00644 0 2.5 Mabsadd m
.16 .00644 -0.56518 .7779 Mabsadd L
.16 .00644 -2.37764 .77254 Mabsadd L
.16 .00644 -0.91448 -0.29713 Mabsadd L
.16 .00644 -1.46946 -2.02254 Mabsadd L
.16 .00644 0 -0.96154 Mabsadd L
.16 .00644 1.46946 -2.02254 Mabsadd L
.16 .00644 .91448 -0.29713 Mabsadd L
.16 .00644 2.37764 .77254 Mabsadd L
.16 .00644 .56518 .7779 Mabsadd L
.16 .00644 0 2.5 Mabsadd L closepath F
.16333 .00644 0 2.5 Mabsadd m
.16333 .00644 -0.56518 .7779 Mabsadd L
.16333 .00644 -2.37764 .77254 Mabsadd L
.16333 .00644 -0.91448 -0.29713 Mabsadd L
.16333 .00644 -1.46946 -2.02254 Mabsadd L
.16333 .00644 0 -0.96154 Mabsadd L
.16333 .00644 1.46946 -2.02254 Mabsadd L
.16333 .00644 .91448 -0.29713 Mabsadd L
.16333 .00644 2.37764 .77254 Mabsadd L
.16333 .00644 .56518 .7779 Mabsadd L
.16333 .00644 0 2.5 Mabsadd L closepath F
.16667 .00644 0 2.5 Mabsadd m
.16667 .00644 -0.56518 .7779 Mabsadd L
.16667 .00644 -2.37764 .77254 Mabsadd L
.16667 .00644 -0.91448 -0.29713 Mabsadd L
.16667 .00644 -1.46946 -2.02254 Mabsadd L
.16667 .00644 0 -0.96154 Mabsadd L
.16667 .00644 1.46946 -2.02254 Mabsadd L
.16667 .00644 .91448 -0.29713 Mabsadd L
.16667 .00644 2.37764 .77254 Mabsadd L
.16667 .00644 .56518 .7779 Mabsadd L
.16667 .00644 0 2.5 Mabsadd L closepath F
.17 .00644 0 2.5 Mabsadd m
.17 .00644 -0.56518 .7779 Mabsadd L
.17 .00644 -2.37764 .77254 Mabsadd L
.17 .00644 -0.91448 -0.29713 Mabsadd L
.17 .00644 -1.46946 -2.02254 Mabsadd L
.17 .00644 0 -0.96154 Mabsadd L
.17 .00644 1.46946 -2.02254 Mabsadd L
.17 .00644 .91448 -0.29713 Mabsadd L
.17 .00644 2.37764 .77254 Mabsadd L
.17 .00644 .56518 .7779 Mabsadd L
.17 .00644 0 2.5 Mabsadd L closepath F
.17333 .00644 0 2.5 Mabsadd m
.17333 .00644 -0.56518 .7779 Mabsadd L
.17333 .00644 -2.37764 .77254 Mabsadd L
.17333 .00644 -0.91448 -0.29713 Mabsadd L
.17333 .00644 -1.46946 -2.02254 Mabsadd L
.17333 .00644 0 -0.96154 Mabsadd L
.17333 .00644 1.46946 -2.02254 Mabsadd L
.17333 .00644 .91448 -0.29713 Mabsadd L
.17333 .00644 2.37764 .77254 Mabsadd L
.17333 .00644 .56518 .7779 Mabsadd L
.17333 .00644 0 2.5 Mabsadd L closepath F
.17667 .00644 0 2.5 Mabsadd m
.17667 .00644 -0.56518 .7779 Mabsadd L
.17667 .00644 -2.37764 .77254 Mabsadd L
.17667 .00644 -0.91448 -0.29713 Mabsadd L
.17667 .00644 -1.46946 -2.02254 Mabsadd L
.17667 .00644 0 -0.96154 Mabsadd L
.17667 .00644 1.46946 -2.02254 Mabsadd L
.17667 .00644 .91448 -0.29713 Mabsadd L
.17667 .00644 2.37764 .77254 Mabsadd L
.17667 .00644 .56518 .7779 Mabsadd L
.17667 .00644 0 2.5 Mabsadd L closepath F
.18 .00644 0 2.5 Mabsadd m
.18 .00644 -0.56518 .7779 Mabsadd L
.18 .00644 -2.37764 .77254 Mabsadd L
.18 .00644 -0.91448 -0.29713 Mabsadd L
.18 .00644 -1.46946 -2.02254 Mabsadd L
.18 .00644 0 -0.96154 Mabsadd L
.18 .00644 1.46946 -2.02254 Mabsadd L
.18 .00644 .91448 -0.29713 Mabsadd L
.18 .00644 2.37764 .77254 Mabsadd L
.18 .00644 .56518 .7779 Mabsadd L
.18 .00644 0 2.5 Mabsadd L closepath F
.18333 .00644 0 2.5 Mabsadd m
.18333 .00644 -0.56518 .7779 Mabsadd L
.18333 .00644 -2.37764 .77254 Mabsadd L
.18333 .00644 -0.91448 -0.29713 Mabsadd L
.18333 .00644 -1.46946 -2.02254 Mabsadd L
.18333 .00644 0 -0.96154 Mabsadd L
.18333 .00644 1.46946 -2.02254 Mabsadd L
.18333 .00644 .91448 -0.29713 Mabsadd L
.18333 .00644 2.37764 .77254 Mabsadd L
.18333 .00644 .56518 .7779 Mabsadd L
.18333 .00644 0 2.5 Mabsadd L closepath F
.18667 .00644 0 2.5 Mabsadd m
.18667 .00644 -0.56518 .7779 Mabsadd L
.18667 .00644 -2.37764 .77254 Mabsadd L
.18667 .00644 -0.91448 -0.29713 Mabsadd L
.18667 .00644 -1.46946 -2.02254 Mabsadd L
.18667 .00644 0 -0.96154 Mabsadd L
.18667 .00644 1.46946 -2.02254 Mabsadd L
.18667 .00644 .91448 -0.29713 Mabsadd L
.18667 .00644 2.37764 .77254 Mabsadd L
.18667 .00644 .56518 .7779 Mabsadd L
.18667 .00644 0 2.5 Mabsadd L closepath F
.19 .00644 0 2.5 Mabsadd m
.19 .00644 -0.56518 .7779 Mabsadd L
.19 .00644 -2.37764 .77254 Mabsadd L
.19 .00644 -0.91448 -0.29713 Mabsadd L
.19 .00644 -1.46946 -2.02254 Mabsadd L
.19 .00644 0 -0.96154 Mabsadd L
.19 .00644 1.46946 -2.02254 Mabsadd L
.19 .00644 .91448 -0.29713 Mabsadd L
.19 .00644 2.37764 .77254 Mabsadd L
.19 .00644 .56518 .7779 Mabsadd L
.19 .00644 0 2.5 Mabsadd L closepath F
.19333 .00644 0 2.5 Mabsadd m
.19333 .00644 -0.56518 .7779 Mabsadd L
.19333 .00644 -2.37764 .77254 Mabsadd L
.19333 .00644 -0.91448 -0.29713 Mabsadd L
.19333 .00644 -1.46946 -2.02254 Mabsadd L
.19333 .00644 0 -0.96154 Mabsadd L
.19333 .00644 1.46946 -2.02254 Mabsadd L
.19333 .00644 .91448 -0.29713 Mabsadd L
.19333 .00644 2.37764 .77254 Mabsadd L
.19333 .00644 .56518 .7779 Mabsadd L
.19333 .00644 0 2.5 Mabsadd L closepath F
.19667 .00644 0 2.5 Mabsadd m
.19667 .00644 -0.56518 .7779 Mabsadd L
.19667 .00644 -2.37764 .77254 Mabsadd L
.19667 .00644 -0.91448 -0.29713 Mabsadd L
.19667 .00644 -1.46946 -2.02254 Mabsadd L
.19667 .00644 0 -0.96154 Mabsadd L
.19667 .00644 1.46946 -2.02254 Mabsadd L
.19667 .00644 .91448 -0.29713 Mabsadd L
.19667 .00644 2.37764 .77254 Mabsadd L
.19667 .00644 .56518 .7779 Mabsadd L
.19667 .00644 0 2.5 Mabsadd L closepath F
.2 .00644 0 2.5 Mabsadd m
.2 .00644 -0.56518 .7779 Mabsadd L
.2 .00644 -2.37764 .77254 Mabsadd L
.2 .00644 -0.91448 -0.29713 Mabsadd L
.2 .00644 -1.46946 -2.02254 Mabsadd L
.2 .00644 0 -0.96154 Mabsadd L
.2 .00644 1.46946 -2.02254 Mabsadd L
.2 .00644 .91448 -0.29713 Mabsadd L
.2 .00644 2.37764 .77254 Mabsadd L
.2 .00644 .56518 .7779 Mabsadd L
.2 .00644 0 2.5 Mabsadd L closepath F
.20333 .00644 0 2.5 Mabsadd m
.20333 .00644 -0.56518 .7779 Mabsadd L
.20333 .00644 -2.37764 .77254 Mabsadd L
.20333 .00644 -0.91448 -0.29713 Mabsadd L
.20333 .00644 -1.46946 -2.02254 Mabsadd L
.20333 .00644 0 -0.96154 Mabsadd L
.20333 .00644 1.46946 -2.02254 Mabsadd L
.20333 .00644 .91448 -0.29713 Mabsadd L
.20333 .00644 2.37764 .77254 Mabsadd L
.20333 .00644 .56518 .7779 Mabsadd L
.20333 .00644 0 2.5 Mabsadd L closepath F
.20667 .00644 0 2.5 Mabsadd m
.20667 .00644 -0.56518 .7779 Mabsadd L
.20667 .00644 -2.37764 .77254 Mabsadd L
.20667 .00644 -0.91448 -0.29713 Mabsadd L
.20667 .00644 -1.46946 -2.02254 Mabsadd L
.20667 .00644 0 -0.96154 Mabsadd L
.20667 .00644 1.46946 -2.02254 Mabsadd L
.20667 .00644 .91448 -0.29713 Mabsadd L
.20667 .00644 2.37764 .77254 Mabsadd L
.20667 .00644 .56518 .7779 Mabsadd L
.20667 .00644 0 2.5 Mabsadd L closepath F
.21 .00644 0 2.5 Mabsadd m
.21 .00644 -0.56518 .7779 Mabsadd L
.21 .00644 -2.37764 .77254 Mabsadd L
.21 .00644 -0.91448 -0.29713 Mabsadd L
.21 .00644 -1.46946 -2.02254 Mabsadd L
.21 .00644 0 -0.96154 Mabsadd L
.21 .00644 1.46946 -2.02254 Mabsadd L
.21 .00644 .91448 -0.29713 Mabsadd L
.21 .00644 2.37764 .77254 Mabsadd L
.21 .00644 .56518 .7779 Mabsadd L
.21 .00644 0 2.5 Mabsadd L closepath F
.21333 .00644 0 2.5 Mabsadd m
.21333 .00644 -0.56518 .7779 Mabsadd L
.21333 .00644 -2.37764 .77254 Mabsadd L
.21333 .00644 -0.91448 -0.29713 Mabsadd L
.21333 .00644 -1.46946 -2.02254 Mabsadd L
.21333 .00644 0 -0.96154 Mabsadd L
.21333 .00644 1.46946 -2.02254 Mabsadd L
.21333 .00644 .91448 -0.29713 Mabsadd L
.21333 .00644 2.37764 .77254 Mabsadd L
.21333 .00644 .56518 .7779 Mabsadd L
.21333 .00644 0 2.5 Mabsadd L closepath F
.21667 .00644 0 2.5 Mabsadd m
.21667 .00644 -0.56518 .7779 Mabsadd L
.21667 .00644 -2.37764 .77254 Mabsadd L
.21667 .00644 -0.91448 -0.29713 Mabsadd L
.21667 .00644 -1.46946 -2.02254 Mabsadd L
.21667 .00644 0 -0.96154 Mabsadd L
.21667 .00644 1.46946 -2.02254 Mabsadd L
.21667 .00644 .91448 -0.29713 Mabsadd L
.21667 .00644 2.37764 .77254 Mabsadd L
.21667 .00644 .56518 .7779 Mabsadd L
.21667 .00644 0 2.5 Mabsadd L closepath F
.22 .00644 0 2.5 Mabsadd m
.22 .00644 -0.56518 .7779 Mabsadd L
.22 .00644 -2.37764 .77254 Mabsadd L
.22 .00644 -0.91448 -0.29713 Mabsadd L
.22 .00644 -1.46946 -2.02254 Mabsadd L
.22 .00644 0 -0.96154 Mabsadd L
.22 .00644 1.46946 -2.02254 Mabsadd L
.22 .00644 .91448 -0.29713 Mabsadd L
.22 .00644 2.37764 .77254 Mabsadd L
.22 .00644 .56518 .7779 Mabsadd L
.22 .00644 0 2.5 Mabsadd L closepath F
.22333 .00644 0 2.5 Mabsadd m
.22333 .00644 -0.56518 .7779 Mabsadd L
.22333 .00644 -2.37764 .77254 Mabsadd L
.22333 .00644 -0.91448 -0.29713 Mabsadd L
.22333 .00644 -1.46946 -2.02254 Mabsadd L
.22333 .00644 0 -0.96154 Mabsadd L
.22333 .00644 1.46946 -2.02254 Mabsadd L
.22333 .00644 .91448 -0.29713 Mabsadd L
.22333 .00644 2.37764 .77254 Mabsadd L
.22333 .00644 .56518 .7779 Mabsadd L
.22333 .00644 0 2.5 Mabsadd L closepath F
.22667 .00644 0 2.5 Mabsadd m
.22667 .00644 -0.56518 .7779 Mabsadd L
.22667 .00644 -2.37764 .77254 Mabsadd L
.22667 .00644 -0.91448 -0.29713 Mabsadd L
.22667 .00644 -1.46946 -2.02254 Mabsadd L
.22667 .00644 0 -0.96154 Mabsadd L
.22667 .00644 1.46946 -2.02254 Mabsadd L
.22667 .00644 .91448 -0.29713 Mabsadd L
.22667 .00644 2.37764 .77254 Mabsadd L
.22667 .00644 .56518 .7779 Mabsadd L
.22667 .00644 0 2.5 Mabsadd L closepath F
.23 .00644 0 2.5 Mabsadd m
.23 .00644 -0.56518 .7779 Mabsadd L
.23 .00644 -2.37764 .77254 Mabsadd L
.23 .00644 -0.91448 -0.29713 Mabsadd L
.23 .00644 -1.46946 -2.02254 Mabsadd L
.23 .00644 0 -0.96154 Mabsadd L
.23 .00644 1.46946 -2.02254 Mabsadd L
.23 .00644 .91448 -0.29713 Mabsadd L
.23 .00644 2.37764 .77254 Mabsadd L
.23 .00644 .56518 .7779 Mabsadd L
.23 .00644 0 2.5 Mabsadd L closepath F
.23333 .00644 0 2.5 Mabsadd m
.23333 .00644 -0.56518 .7779 Mabsadd L
.23333 .00644 -2.37764 .77254 Mabsadd L
.23333 .00644 -0.91448 -0.29713 Mabsadd L
.23333 .00644 -1.46946 -2.02254 Mabsadd L
.23333 .00644 0 -0.96154 Mabsadd L
.23333 .00644 1.46946 -2.02254 Mabsadd L
.23333 .00644 .91448 -0.29713 Mabsadd L
.23333 .00644 2.37764 .77254 Mabsadd L
.23333 .00644 .56518 .7779 Mabsadd L
.23333 .00644 0 2.5 Mabsadd L closepath F
.23667 .00644 0 2.5 Mabsadd m
.23667 .00644 -0.56518 .7779 Mabsadd L
.23667 .00644 -2.37764 .77254 Mabsadd L
.23667 .00644 -0.91448 -0.29713 Mabsadd L
.23667 .00644 -1.46946 -2.02254 Mabsadd L
.23667 .00644 0 -0.96154 Mabsadd L
.23667 .00644 1.46946 -2.02254 Mabsadd L
.23667 .00644 .91448 -0.29713 Mabsadd L
.23667 .00644 2.37764 .77254 Mabsadd L
.23667 .00644 .56518 .7779 Mabsadd L
.23667 .00644 0 2.5 Mabsadd L closepath F
.24 .00644 0 2.5 Mabsadd m
.24 .00644 -0.56518 .7779 Mabsadd L
.24 .00644 -2.37764 .77254 Mabsadd L
.24 .00644 -0.91448 -0.29713 Mabsadd L
.24 .00644 -1.46946 -2.02254 Mabsadd L
.24 .00644 0 -0.96154 Mabsadd L
.24 .00644 1.46946 -2.02254 Mabsadd L
.24 .00644 .91448 -0.29713 Mabsadd L
.24 .00644 2.37764 .77254 Mabsadd L
.24 .00644 .56518 .7779 Mabsadd L
.24 .00644 0 2.5 Mabsadd L closepath F
.24333 .00644 0 2.5 Mabsadd m
.24333 .00644 -0.56518 .7779 Mabsadd L
.24333 .00644 -2.37764 .77254 Mabsadd L
.24333 .00644 -0.91448 -0.29713 Mabsadd L
.24333 .00644 -1.46946 -2.02254 Mabsadd L
.24333 .00644 0 -0.96154 Mabsadd L
.24333 .00644 1.46946 -2.02254 Mabsadd L
.24333 .00644 .91448 -0.29713 Mabsadd L
.24333 .00644 2.37764 .77254 Mabsadd L
.24333 .00644 .56518 .7779 Mabsadd L
.24333 .00644 0 2.5 Mabsadd L closepath F
.24667 .00644 0 2.5 Mabsadd m
.24667 .00644 -0.56518 .7779 Mabsadd L
.24667 .00644 -2.37764 .77254 Mabsadd L
.24667 .00644 -0.91448 -0.29713 Mabsadd L
.24667 .00644 -1.46946 -2.02254 Mabsadd L
.24667 .00644 0 -0.96154 Mabsadd L
.24667 .00644 1.46946 -2.02254 Mabsadd L
.24667 .00644 .91448 -0.29713 Mabsadd L
.24667 .00644 2.37764 .77254 Mabsadd L
.24667 .00644 .56518 .7779 Mabsadd L
.24667 .00644 0 2.5 Mabsadd L closepath F
.25 .00644 0 2.5 Mabsadd m
.25 .00644 -0.56518 .7779 Mabsadd L
.25 .00644 -2.37764 .77254 Mabsadd L
.25 .00644 -0.91448 -0.29713 Mabsadd L
.25 .00644 -1.46946 -2.02254 Mabsadd L
.25 .00644 0 -0.96154 Mabsadd L
.25 .00644 1.46946 -2.02254 Mabsadd L
.25 .00644 .91448 -0.29713 Mabsadd L
.25 .00644 2.37764 .77254 Mabsadd L
.25 .00644 .56518 .7779 Mabsadd L
.25 .00644 0 2.5 Mabsadd L closepath F
.25333 .00644 0 2.5 Mabsadd m
.25333 .00644 -0.56518 .7779 Mabsadd L
.25333 .00644 -2.37764 .77254 Mabsadd L
.25333 .00644 -0.91448 -0.29713 Mabsadd L
.25333 .00644 -1.46946 -2.02254 Mabsadd L
.25333 .00644 0 -0.96154 Mabsadd L
.25333 .00644 1.46946 -2.02254 Mabsadd L
.25333 .00644 .91448 -0.29713 Mabsadd L
.25333 .00644 2.37764 .77254 Mabsadd L
.25333 .00644 .56518 .7779 Mabsadd L
.25333 .00644 0 2.5 Mabsadd L closepath F
.25667 .00644 0 2.5 Mabsadd m
.25667 .00644 -0.56518 .7779 Mabsadd L
.25667 .00644 -2.37764 .77254 Mabsadd L
.25667 .00644 -0.91448 -0.29713 Mabsadd L
.25667 .00644 -1.46946 -2.02254 Mabsadd L
.25667 .00644 0 -0.96154 Mabsadd L
.25667 .00644 1.46946 -2.02254 Mabsadd L
.25667 .00644 .91448 -0.29713 Mabsadd L
.25667 .00644 2.37764 .77254 Mabsadd L
.25667 .00644 .56518 .7779 Mabsadd L
.25667 .00644 0 2.5 Mabsadd L closepath F
.26 .00644 0 2.5 Mabsadd m
.26 .00644 -0.56518 .7779 Mabsadd L
.26 .00644 -2.37764 .77254 Mabsadd L
.26 .00644 -0.91448 -0.29713 Mabsadd L
.26 .00644 -1.46946 -2.02254 Mabsadd L
.26 .00644 0 -0.96154 Mabsadd L
.26 .00644 1.46946 -2.02254 Mabsadd L
.26 .00644 .91448 -0.29713 Mabsadd L
.26 .00644 2.37764 .77254 Mabsadd L
.26 .00644 .56518 .7779 Mabsadd L
.26 .00644 0 2.5 Mabsadd L closepath F
.26333 .00644 0 2.5 Mabsadd m
.26333 .00644 -0.56518 .7779 Mabsadd L
.26333 .00644 -2.37764 .77254 Mabsadd L
.26333 .00644 -0.91448 -0.29713 Mabsadd L
.26333 .00644 -1.46946 -2.02254 Mabsadd L
.26333 .00644 0 -0.96154 Mabsadd L
.26333 .00644 1.46946 -2.02254 Mabsadd L
.26333 .00644 .91448 -0.29713 Mabsadd L
.26333 .00644 2.37764 .77254 Mabsadd L
.26333 .00644 .56518 .7779 Mabsadd L
.26333 .00644 0 2.5 Mabsadd L closepath F
.26667 .00644 0 2.5 Mabsadd m
.26667 .00644 -0.56518 .7779 Mabsadd L
.26667 .00644 -2.37764 .77254 Mabsadd L
.26667 .00644 -0.91448 -0.29713 Mabsadd L
.26667 .00644 -1.46946 -2.02254 Mabsadd L
.26667 .00644 0 -0.96154 Mabsadd L
.26667 .00644 1.46946 -2.02254 Mabsadd L
.26667 .00644 .91448 -0.29713 Mabsadd L
.26667 .00644 2.37764 .77254 Mabsadd L
.26667 .00644 .56518 .7779 Mabsadd L
.26667 .00644 0 2.5 Mabsadd L closepath F
.27 .00644 0 2.5 Mabsadd m
.27 .00644 -0.56518 .7779 Mabsadd L
.27 .00644 -2.37764 .77254 Mabsadd L
.27 .00644 -0.91448 -0.29713 Mabsadd L
.27 .00644 -1.46946 -2.02254 Mabsadd L
.27 .00644 0 -0.96154 Mabsadd L
.27 .00644 1.46946 -2.02254 Mabsadd L
.27 .00644 .91448 -0.29713 Mabsadd L
.27 .00644 2.37764 .77254 Mabsadd L
.27 .00644 .56518 .7779 Mabsadd L
.27 .00644 0 2.5 Mabsadd L closepath F
.27333 .00644 0 2.5 Mabsadd m
.27333 .00644 -0.56518 .7779 Mabsadd L
.27333 .00644 -2.37764 .77254 Mabsadd L
.27333 .00644 -0.91448 -0.29713 Mabsadd L
.27333 .00644 -1.46946 -2.02254 Mabsadd L
.27333 .00644 0 -0.96154 Mabsadd L
.27333 .00644 1.46946 -2.02254 Mabsadd L
.27333 .00644 .91448 -0.29713 Mabsadd L
.27333 .00644 2.37764 .77254 Mabsadd L
.27333 .00644 .56518 .7779 Mabsadd L
.27333 .00644 0 2.5 Mabsadd L closepath F
.27667 .00644 0 2.5 Mabsadd m
.27667 .00644 -0.56518 .7779 Mabsadd L
.27667 .00644 -2.37764 .77254 Mabsadd L
.27667 .00644 -0.91448 -0.29713 Mabsadd L
.27667 .00644 -1.46946 -2.02254 Mabsadd L
.27667 .00644 0 -0.96154 Mabsadd L
.27667 .00644 1.46946 -2.02254 Mabsadd L
.27667 .00644 .91448 -0.29713 Mabsadd L
.27667 .00644 2.37764 .77254 Mabsadd L
.27667 .00644 .56518 .7779 Mabsadd L
.27667 .00644 0 2.5 Mabsadd L closepath F
.28 .00644 0 2.5 Mabsadd m
.28 .00644 -0.56518 .7779 Mabsadd L
.28 .00644 -2.37764 .77254 Mabsadd L
.28 .00644 -0.91448 -0.29713 Mabsadd L
.28 .00644 -1.46946 -2.02254 Mabsadd L
.28 .00644 0 -0.96154 Mabsadd L
.28 .00644 1.46946 -2.02254 Mabsadd L
.28 .00644 .91448 -0.29713 Mabsadd L
.28 .00644 2.37764 .77254 Mabsadd L
.28 .00644 .56518 .7779 Mabsadd L
.28 .00644 0 2.5 Mabsadd L closepath F
.28333 .00644 0 2.5 Mabsadd m
.28333 .00644 -0.56518 .7779 Mabsadd L
.28333 .00644 -2.37764 .77254 Mabsadd L
.28333 .00644 -0.91448 -0.29713 Mabsadd L
.28333 .00644 -1.46946 -2.02254 Mabsadd L
.28333 .00644 0 -0.96154 Mabsadd L
.28333 .00644 1.46946 -2.02254 Mabsadd L
.28333 .00644 .91448 -0.29713 Mabsadd L
.28333 .00644 2.37764 .77254 Mabsadd L
.28333 .00644 .56518 .7779 Mabsadd L
.28333 .00644 0 2.5 Mabsadd L closepath F
.28667 .00644 0 2.5 Mabsadd m
.28667 .00644 -0.56518 .7779 Mabsadd L
.28667 .00644 -2.37764 .77254 Mabsadd L
.28667 .00644 -0.91448 -0.29713 Mabsadd L
.28667 .00644 -1.46946 -2.02254 Mabsadd L
.28667 .00644 0 -0.96154 Mabsadd L
.28667 .00644 1.46946 -2.02254 Mabsadd L
.28667 .00644 .91448 -0.29713 Mabsadd L
.28667 .00644 2.37764 .77254 Mabsadd L
.28667 .00644 .56518 .7779 Mabsadd L
.28667 .00644 0 2.5 Mabsadd L closepath F
.29 .00644 0 2.5 Mabsadd m
.29 .00644 -0.56518 .7779 Mabsadd L
.29 .00644 -2.37764 .77254 Mabsadd L
.29 .00644 -0.91448 -0.29713 Mabsadd L
.29 .00644 -1.46946 -2.02254 Mabsadd L
.29 .00644 0 -0.96154 Mabsadd L
.29 .00644 1.46946 -2.02254 Mabsadd L
.29 .00644 .91448 -0.29713 Mabsadd L
.29 .00644 2.37764 .77254 Mabsadd L
.29 .00644 .56518 .7779 Mabsadd L
.29 .00644 0 2.5 Mabsadd L closepath F
.29333 .00644 0 2.5 Mabsadd m
.29333 .00644 -0.56518 .7779 Mabsadd L
.29333 .00644 -2.37764 .77254 Mabsadd L
.29333 .00644 -0.91448 -0.29713 Mabsadd L
.29333 .00644 -1.46946 -2.02254 Mabsadd L
.29333 .00644 0 -0.96154 Mabsadd L
.29333 .00644 1.46946 -2.02254 Mabsadd L
.29333 .00644 .91448 -0.29713 Mabsadd L
.29333 .00644 2.37764 .77254 Mabsadd L
.29333 .00644 .56518 .7779 Mabsadd L
.29333 .00644 0 2.5 Mabsadd L closepath F
.29667 .00644 0 2.5 Mabsadd m
.29667 .00644 -0.56518 .7779 Mabsadd L
.29667 .00644 -2.37764 .77254 Mabsadd L
.29667 .00644 -0.91448 -0.29713 Mabsadd L
.29667 .00644 -1.46946 -2.02254 Mabsadd L
.29667 .00644 0 -0.96154 Mabsadd L
.29667 .00644 1.46946 -2.02254 Mabsadd L
.29667 .00644 .91448 -0.29713 Mabsadd L
.29667 .00644 2.37764 .77254 Mabsadd L
.29667 .00644 .56518 .7779 Mabsadd L
.29667 .00644 0 2.5 Mabsadd L closepath F
.3 .00644 0 2.5 Mabsadd m
.3 .00644 -0.56518 .7779 Mabsadd L
.3 .00644 -2.37764 .77254 Mabsadd L
.3 .00644 -0.91448 -0.29713 Mabsadd L
.3 .00644 -1.46946 -2.02254 Mabsadd L
.3 .00644 0 -0.96154 Mabsadd L
.3 .00644 1.46946 -2.02254 Mabsadd L
.3 .00644 .91448 -0.29713 Mabsadd L
.3 .00644 2.37764 .77254 Mabsadd L
.3 .00644 .56518 .7779 Mabsadd L
.3 .00644 0 2.5 Mabsadd L closepath F
.30333 .00644 0 2.5 Mabsadd m
.30333 .00644 -0.56518 .7779 Mabsadd L
.30333 .00644 -2.37764 .77254 Mabsadd L
.30333 .00644 -0.91448 -0.29713 Mabsadd L
.30333 .00644 -1.46946 -2.02254 Mabsadd L
.30333 .00644 0 -0.96154 Mabsadd L
.30333 .00644 1.46946 -2.02254 Mabsadd L
.30333 .00644 .91448 -0.29713 Mabsadd L
.30333 .00644 2.37764 .77254 Mabsadd L
.30333 .00644 .56518 .7779 Mabsadd L
.30333 .00644 0 2.5 Mabsadd L closepath F
.30667 .00644 0 2.5 Mabsadd m
.30667 .00644 -0.56518 .7779 Mabsadd L
.30667 .00644 -2.37764 .77254 Mabsadd L
.30667 .00644 -0.91448 -0.29713 Mabsadd L
.30667 .00644 -1.46946 -2.02254 Mabsadd L
.30667 .00644 0 -0.96154 Mabsadd L
.30667 .00644 1.46946 -2.02254 Mabsadd L
.30667 .00644 .91448 -0.29713 Mabsadd L
.30667 .00644 2.37764 .77254 Mabsadd L
.30667 .00644 .56518 .7779 Mabsadd L
.30667 .00644 0 2.5 Mabsadd L closepath F
.31 .00644 0 2.5 Mabsadd m
.31 .00644 -0.56518 .7779 Mabsadd L
.31 .00644 -2.37764 .77254 Mabsadd L
.31 .00644 -0.91448 -0.29713 Mabsadd L
.31 .00644 -1.46946 -2.02254 Mabsadd L
.31 .00644 0 -0.96154 Mabsadd L
.31 .00644 1.46946 -2.02254 Mabsadd L
.31 .00644 .91448 -0.29713 Mabsadd L
.31 .00644 2.37764 .77254 Mabsadd L
.31 .00644 .56518 .7779 Mabsadd L
.31 .00644 0 2.5 Mabsadd L closepath F
.31333 .00644 0 2.5 Mabsadd m
.31333 .00644 -0.56518 .7779 Mabsadd L
.31333 .00644 -2.37764 .77254 Mabsadd L
.31333 .00644 -0.91448 -0.29713 Mabsadd L
.31333 .00644 -1.46946 -2.02254 Mabsadd L
.31333 .00644 0 -0.96154 Mabsadd L
.31333 .00644 1.46946 -2.02254 Mabsadd L
.31333 .00644 .91448 -0.29713 Mabsadd L
.31333 .00644 2.37764 .77254 Mabsadd L
.31333 .00644 .56518 .7779 Mabsadd L
.31333 .00644 0 2.5 Mabsadd L closepath F
.31667 .00644 0 2.5 Mabsadd m
.31667 .00644 -0.56518 .7779 Mabsadd L
.31667 .00644 -2.37764 .77254 Mabsadd L
.31667 .00644 -0.91448 -0.29713 Mabsadd L
.31667 .00644 -1.46946 -2.02254 Mabsadd L
.31667 .00644 0 -0.96154 Mabsadd L
.31667 .00644 1.46946 -2.02254 Mabsadd L
.31667 .00644 .91448 -0.29713 Mabsadd L
.31667 .00644 2.37764 .77254 Mabsadd L
.31667 .00644 .56518 .7779 Mabsadd L
.31667 .00644 0 2.5 Mabsadd L closepath F
.32 .00644 0 2.5 Mabsadd m
.32 .00644 -0.56518 .7779 Mabsadd L
.32 .00644 -2.37764 .77254 Mabsadd L
.32 .00644 -0.91448 -0.29713 Mabsadd L
.32 .00644 -1.46946 -2.02254 Mabsadd L
.32 .00644 0 -0.96154 Mabsadd L
.32 .00644 1.46946 -2.02254 Mabsadd L
.32 .00644 .91448 -0.29713 Mabsadd L
.32 .00644 2.37764 .77254 Mabsadd L
.32 .00644 .56518 .7779 Mabsadd L
.32 .00644 0 2.5 Mabsadd L closepath F
.32333 .00644 0 2.5 Mabsadd m
.32333 .00644 -0.56518 .7779 Mabsadd L
.32333 .00644 -2.37764 .77254 Mabsadd L
.32333 .00644 -0.91448 -0.29713 Mabsadd L
.32333 .00644 -1.46946 -2.02254 Mabsadd L
.32333 .00644 0 -0.96154 Mabsadd L
.32333 .00644 1.46946 -2.02254 Mabsadd L
.32333 .00644 .91448 -0.29713 Mabsadd L
.32333 .00644 2.37764 .77254 Mabsadd L
.32333 .00644 .56518 .7779 Mabsadd L
.32333 .00644 0 2.5 Mabsadd L closepath F
.32667 .00644 0 2.5 Mabsadd m
.32667 .00644 -0.56518 .7779 Mabsadd L
.32667 .00644 -2.37764 .77254 Mabsadd L
.32667 .00644 -0.91448 -0.29713 Mabsadd L
.32667 .00644 -1.46946 -2.02254 Mabsadd L
.32667 .00644 0 -0.96154 Mabsadd L
.32667 .00644 1.46946 -2.02254 Mabsadd L
.32667 .00644 .91448 -0.29713 Mabsadd L
.32667 .00644 2.37764 .77254 Mabsadd L
.32667 .00644 .56518 .7779 Mabsadd L
.32667 .00644 0 2.5 Mabsadd L closepath F
.33 .00644 0 2.5 Mabsadd m
.33 .00644 -0.56518 .7779 Mabsadd L
.33 .00644 -2.37764 .77254 Mabsadd L
.33 .00644 -0.91448 -0.29713 Mabsadd L
.33 .00644 -1.46946 -2.02254 Mabsadd L
.33 .00644 0 -0.96154 Mabsadd L
.33 .00644 1.46946 -2.02254 Mabsadd L
.33 .00644 .91448 -0.29713 Mabsadd L
.33 .00644 2.37764 .77254 Mabsadd L
.33 .00644 .56518 .7779 Mabsadd L
.33 .00644 0 2.5 Mabsadd L closepath F
.33333 .00644 0 2.5 Mabsadd m
.33333 .00644 -0.56518 .7779 Mabsadd L
.33333 .00644 -2.37764 .77254 Mabsadd L
.33333 .00644 -0.91448 -0.29713 Mabsadd L
.33333 .00644 -1.46946 -2.02254 Mabsadd L
.33333 .00644 0 -0.96154 Mabsadd L
.33333 .00644 1.46946 -2.02254 Mabsadd L
.33333 .00644 .91448 -0.29713 Mabsadd L
.33333 .00644 2.37764 .77254 Mabsadd L
.33333 .00644 .56518 .7779 Mabsadd L
.33333 .00644 0 2.5 Mabsadd L closepath F
.33667 .00644 0 2.5 Mabsadd m
.33667 .00644 -0.56518 .7779 Mabsadd L
.33667 .00644 -2.37764 .77254 Mabsadd L
.33667 .00644 -0.91448 -0.29713 Mabsadd L
.33667 .00644 -1.46946 -2.02254 Mabsadd L
.33667 .00644 0 -0.96154 Mabsadd L
.33667 .00644 1.46946 -2.02254 Mabsadd L
.33667 .00644 .91448 -0.29713 Mabsadd L
.33667 .00644 2.37764 .77254 Mabsadd L
.33667 .00644 .56518 .7779 Mabsadd L
.33667 .00644 0 2.5 Mabsadd L closepath F
.34 .00644 0 2.5 Mabsadd m
.34 .00644 -0.56518 .7779 Mabsadd L
.34 .00644 -2.37764 .77254 Mabsadd L
.34 .00644 -0.91448 -0.29713 Mabsadd L
.34 .00644 -1.46946 -2.02254 Mabsadd L
.34 .00644 0 -0.96154 Mabsadd L
.34 .00644 1.46946 -2.02254 Mabsadd L
.34 .00644 .91448 -0.29713 Mabsadd L
.34 .00644 2.37764 .77254 Mabsadd L
.34 .00644 .56518 .7779 Mabsadd L
.34 .00644 0 2.5 Mabsadd L closepath F
.34333 .00644 0 2.5 Mabsadd m
.34333 .00644 -0.56518 .7779 Mabsadd L
.34333 .00644 -2.37764 .77254 Mabsadd L
.34333 .00644 -0.91448 -0.29713 Mabsadd L
.34333 .00644 -1.46946 -2.02254 Mabsadd L
.34333 .00644 0 -0.96154 Mabsadd L
.34333 .00644 1.46946 -2.02254 Mabsadd L
.34333 .00644 .91448 -0.29713 Mabsadd L
.34333 .00644 2.37764 .77254 Mabsadd L
.34333 .00644 .56518 .7779 Mabsadd L
.34333 .00644 0 2.5 Mabsadd L closepath F
.34667 .00644 0 2.5 Mabsadd m
.34667 .00644 -0.56518 .7779 Mabsadd L
.34667 .00644 -2.37764 .77254 Mabsadd L
.34667 .00644 -0.91448 -0.29713 Mabsadd L
.34667 .00644 -1.46946 -2.02254 Mabsadd L
.34667 .00644 0 -0.96154 Mabsadd L
.34667 .00644 1.46946 -2.02254 Mabsadd L
.34667 .00644 .91448 -0.29713 Mabsadd L
.34667 .00644 2.37764 .77254 Mabsadd L
.34667 .00644 .56518 .7779 Mabsadd L
.34667 .00644 0 2.5 Mabsadd L closepath F
.35 .00644 0 2.5 Mabsadd m
.35 .00644 -0.56518 .7779 Mabsadd L
.35 .00644 -2.37764 .77254 Mabsadd L
.35 .00644 -0.91448 -0.29713 Mabsadd L
.35 .00644 -1.46946 -2.02254 Mabsadd L
.35 .00644 0 -0.96154 Mabsadd L
.35 .00644 1.46946 -2.02254 Mabsadd L
.35 .00644 .91448 -0.29713 Mabsadd L
.35 .00644 2.37764 .77254 Mabsadd L
.35 .00644 .56518 .7779 Mabsadd L
.35 .00644 0 2.5 Mabsadd L closepath F
.35333 .00644 0 2.5 Mabsadd m
.35333 .00644 -0.56518 .7779 Mabsadd L
.35333 .00644 -2.37764 .77254 Mabsadd L
.35333 .00644 -0.91448 -0.29713 Mabsadd L
.35333 .00644 -1.46946 -2.02254 Mabsadd L
.35333 .00644 0 -0.96154 Mabsadd L
.35333 .00644 1.46946 -2.02254 Mabsadd L
.35333 .00644 .91448 -0.29713 Mabsadd L
.35333 .00644 2.37764 .77254 Mabsadd L
.35333 .00644 .56518 .7779 Mabsadd L
.35333 .00644 0 2.5 Mabsadd L closepath F
.35667 .00644 0 2.5 Mabsadd m
.35667 .00644 -0.56518 .7779 Mabsadd L
.35667 .00644 -2.37764 .77254 Mabsadd L
.35667 .00644 -0.91448 -0.29713 Mabsadd L
.35667 .00644 -1.46946 -2.02254 Mabsadd L
.35667 .00644 0 -0.96154 Mabsadd L
.35667 .00644 1.46946 -2.02254 Mabsadd L
.35667 .00644 .91448 -0.29713 Mabsadd L
.35667 .00644 2.37764 .77254 Mabsadd L
.35667 .00644 .56518 .7779 Mabsadd L
.35667 .00644 0 2.5 Mabsadd L closepath F
.36 .00644 0 2.5 Mabsadd m
.36 .00644 -0.56518 .7779 Mabsadd L
.36 .00644 -2.37764 .77254 Mabsadd L
.36 .00644 -0.91448 -0.29713 Mabsadd L
.36 .00644 -1.46946 -2.02254 Mabsadd L
.36 .00644 0 -0.96154 Mabsadd L
.36 .00644 1.46946 -2.02254 Mabsadd L
.36 .00644 .91448 -0.29713 Mabsadd L
.36 .00644 2.37764 .77254 Mabsadd L
.36 .00644 .56518 .7779 Mabsadd L
.36 .00644 0 2.5 Mabsadd L closepath F
.36333 .00644 0 2.5 Mabsadd m
.36333 .00644 -0.56518 .7779 Mabsadd L
.36333 .00644 -2.37764 .77254 Mabsadd L
.36333 .00644 -0.91448 -0.29713 Mabsadd L
.36333 .00644 -1.46946 -2.02254 Mabsadd L
.36333 .00644 0 -0.96154 Mabsadd L
.36333 .00644 1.46946 -2.02254 Mabsadd L
.36333 .00644 .91448 -0.29713 Mabsadd L
.36333 .00644 2.37764 .77254 Mabsadd L
.36333 .00644 .56518 .7779 Mabsadd L
.36333 .00644 0 2.5 Mabsadd L closepath F
.36667 .00644 0 2.5 Mabsadd m
.36667 .00644 -0.56518 .7779 Mabsadd L
.36667 .00644 -2.37764 .77254 Mabsadd L
.36667 .00644 -0.91448 -0.29713 Mabsadd L
.36667 .00644 -1.46946 -2.02254 Mabsadd L
.36667 .00644 0 -0.96154 Mabsadd L
.36667 .00644 1.46946 -2.02254 Mabsadd L
.36667 .00644 .91448 -0.29713 Mabsadd L
.36667 .00644 2.37764 .77254 Mabsadd L
.36667 .00644 .56518 .7779 Mabsadd L
.36667 .00644 0 2.5 Mabsadd L closepath F
.37 .00644 0 2.5 Mabsadd m
.37 .00644 -0.56518 .7779 Mabsadd L
.37 .00644 -2.37764 .77254 Mabsadd L
.37 .00644 -0.91448 -0.29713 Mabsadd L
.37 .00644 -1.46946 -2.02254 Mabsadd L
.37 .00644 0 -0.96154 Mabsadd L
.37 .00644 1.46946 -2.02254 Mabsadd L
.37 .00644 .91448 -0.29713 Mabsadd L
.37 .00644 2.37764 .77254 Mabsadd L
.37 .00644 .56518 .7779 Mabsadd L
.37 .00644 0 2.5 Mabsadd L closepath F
.37333 .00644 0 2.5 Mabsadd m
.37333 .00644 -0.56518 .7779 Mabsadd L
.37333 .00644 -2.37764 .77254 Mabsadd L
.37333 .00644 -0.91448 -0.29713 Mabsadd L
.37333 .00644 -1.46946 -2.02254 Mabsadd L
.37333 .00644 0 -0.96154 Mabsadd L
.37333 .00644 1.46946 -2.02254 Mabsadd L
.37333 .00644 .91448 -0.29713 Mabsadd L
.37333 .00644 2.37764 .77254 Mabsadd L
.37333 .00644 .56518 .7779 Mabsadd L
.37333 .00644 0 2.5 Mabsadd L closepath F
.37667 .00644 0 2.5 Mabsadd m
.37667 .00644 -0.56518 .7779 Mabsadd L
.37667 .00644 -2.37764 .77254 Mabsadd L
.37667 .00644 -0.91448 -0.29713 Mabsadd L
.37667 .00644 -1.46946 -2.02254 Mabsadd L
.37667 .00644 0 -0.96154 Mabsadd L
.37667 .00644 1.46946 -2.02254 Mabsadd L
.37667 .00644 .91448 -0.29713 Mabsadd L
.37667 .00644 2.37764 .77254 Mabsadd L
.37667 .00644 .56518 .7779 Mabsadd L
.37667 .00644 0 2.5 Mabsadd L closepath F
.38 .00644 0 2.5 Mabsadd m
.38 .00644 -0.56518 .7779 Mabsadd L
.38 .00644 -2.37764 .77254 Mabsadd L
.38 .00644 -0.91448 -0.29713 Mabsadd L
.38 .00644 -1.46946 -2.02254 Mabsadd L
.38 .00644 0 -0.96154 Mabsadd L
.38 .00644 1.46946 -2.02254 Mabsadd L
.38 .00644 .91448 -0.29713 Mabsadd L
.38 .00644 2.37764 .77254 Mabsadd L
.38 .00644 .56518 .7779 Mabsadd L
.38 .00644 0 2.5 Mabsadd L closepath F
.38333 .00644 0 2.5 Mabsadd m
.38333 .00644 -0.56518 .7779 Mabsadd L
.38333 .00644 -2.37764 .77254 Mabsadd L
.38333 .00644 -0.91448 -0.29713 Mabsadd L
.38333 .00644 -1.46946 -2.02254 Mabsadd L
.38333 .00644 0 -0.96154 Mabsadd L
.38333 .00644 1.46946 -2.02254 Mabsadd L
.38333 .00644 .91448 -0.29713 Mabsadd L
.38333 .00644 2.37764 .77254 Mabsadd L
.38333 .00644 .56518 .7779 Mabsadd L
.38333 .00644 0 2.5 Mabsadd L closepath F
.38667 .00644 0 2.5 Mabsadd m
.38667 .00644 -0.56518 .7779 Mabsadd L
.38667 .00644 -2.37764 .77254 Mabsadd L
.38667 .00644 -0.91448 -0.29713 Mabsadd L
.38667 .00644 -1.46946 -2.02254 Mabsadd L
.38667 .00644 0 -0.96154 Mabsadd L
.38667 .00644 1.46946 -2.02254 Mabsadd L
.38667 .00644 .91448 -0.29713 Mabsadd L
.38667 .00644 2.37764 .77254 Mabsadd L
.38667 .00644 .56518 .7779 Mabsadd L
.38667 .00644 0 2.5 Mabsadd L closepath F
.39 .00644 0 2.5 Mabsadd m
.39 .00644 -0.56518 .7779 Mabsadd L
.39 .00644 -2.37764 .77254 Mabsadd L
.39 .00644 -0.91448 -0.29713 Mabsadd L
.39 .00644 -1.46946 -2.02254 Mabsadd L
.39 .00644 0 -0.96154 Mabsadd L
.39 .00644 1.46946 -2.02254 Mabsadd L
.39 .00644 .91448 -0.29713 Mabsadd L
.39 .00644 2.37764 .77254 Mabsadd L
.39 .00644 .56518 .7779 Mabsadd L
.39 .00644 0 2.5 Mabsadd L closepath F
.39333 .00644 0 2.5 Mabsadd m
.39333 .00644 -0.56518 .7779 Mabsadd L
.39333 .00644 -2.37764 .77254 Mabsadd L
.39333 .00644 -0.91448 -0.29713 Mabsadd L
.39333 .00644 -1.46946 -2.02254 Mabsadd L
.39333 .00644 0 -0.96154 Mabsadd L
.39333 .00644 1.46946 -2.02254 Mabsadd L
.39333 .00644 .91448 -0.29713 Mabsadd L
.39333 .00644 2.37764 .77254 Mabsadd L
.39333 .00644 .56518 .7779 Mabsadd L
.39333 .00644 0 2.5 Mabsadd L closepath F
.39667 .00644 0 2.5 Mabsadd m
.39667 .00644 -0.56518 .7779 Mabsadd L
.39667 .00644 -2.37764 .77254 Mabsadd L
.39667 .00644 -0.91448 -0.29713 Mabsadd L
.39667 .00644 -1.46946 -2.02254 Mabsadd L
.39667 .00644 0 -0.96154 Mabsadd L
.39667 .00644 1.46946 -2.02254 Mabsadd L
.39667 .00644 .91448 -0.29713 Mabsadd L
.39667 .00644 2.37764 .77254 Mabsadd L
.39667 .00644 .56518 .7779 Mabsadd L
.39667 .00644 0 2.5 Mabsadd L closepath F
.4 .00644 0 2.5 Mabsadd m
.4 .00644 -0.56518 .7779 Mabsadd L
.4 .00644 -2.37764 .77254 Mabsadd L
.4 .00644 -0.91448 -0.29713 Mabsadd L
.4 .00644 -1.46946 -2.02254 Mabsadd L
.4 .00644 0 -0.96154 Mabsadd L
.4 .00644 1.46946 -2.02254 Mabsadd L
.4 .00644 .91448 -0.29713 Mabsadd L
.4 .00644 2.37764 .77254 Mabsadd L
.4 .00644 .56518 .7779 Mabsadd L
.4 .00644 0 2.5 Mabsadd L closepath F
.40333 .00644 0 2.5 Mabsadd m
.40333 .00644 -0.56518 .7779 Mabsadd L
.40333 .00644 -2.37764 .77254 Mabsadd L
.40333 .00644 -0.91448 -0.29713 Mabsadd L
.40333 .00644 -1.46946 -2.02254 Mabsadd L
.40333 .00644 0 -0.96154 Mabsadd L
.40333 .00644 1.46946 -2.02254 Mabsadd L
.40333 .00644 .91448 -0.29713 Mabsadd L
.40333 .00644 2.37764 .77254 Mabsadd L
.40333 .00644 .56518 .7779 Mabsadd L
.40333 .00644 0 2.5 Mabsadd L closepath F
.40667 .00644 0 2.5 Mabsadd m
.40667 .00644 -0.56518 .7779 Mabsadd L
.40667 .00644 -2.37764 .77254 Mabsadd L
.40667 .00644 -0.91448 -0.29713 Mabsadd L
.40667 .00644 -1.46946 -2.02254 Mabsadd L
.40667 .00644 0 -0.96154 Mabsadd L
.40667 .00644 1.46946 -2.02254 Mabsadd L
.40667 .00644 .91448 -0.29713 Mabsadd L
.40667 .00644 2.37764 .77254 Mabsadd L
.40667 .00644 .56518 .7779 Mabsadd L
.40667 .00644 0 2.5 Mabsadd L closepath F
.41 .00644 0 2.5 Mabsadd m
.41 .00644 -0.56518 .7779 Mabsadd L
.41 .00644 -2.37764 .77254 Mabsadd L
.41 .00644 -0.91448 -0.29713 Mabsadd L
.41 .00644 -1.46946 -2.02254 Mabsadd L
.41 .00644 0 -0.96154 Mabsadd L
.41 .00644 1.46946 -2.02254 Mabsadd L
.41 .00644 .91448 -0.29713 Mabsadd L
.41 .00644 2.37764 .77254 Mabsadd L
.41 .00644 .56518 .7779 Mabsadd L
.41 .00644 0 2.5 Mabsadd L closepath F
.41333 .00644 0 2.5 Mabsadd m
.41333 .00644 -0.56518 .7779 Mabsadd L
.41333 .00644 -2.37764 .77254 Mabsadd L
.41333 .00644 -0.91448 -0.29713 Mabsadd L
.41333 .00644 -1.46946 -2.02254 Mabsadd L
.41333 .00644 0 -0.96154 Mabsadd L
.41333 .00644 1.46946 -2.02254 Mabsadd L
.41333 .00644 .91448 -0.29713 Mabsadd L
.41333 .00644 2.37764 .77254 Mabsadd L
.41333 .00644 .56518 .7779 Mabsadd L
.41333 .00644 0 2.5 Mabsadd L closepath F
.41667 .00644 0 2.5 Mabsadd m
.41667 .00644 -0.56518 .7779 Mabsadd L
.41667 .00644 -2.37764 .77254 Mabsadd L
.41667 .00644 -0.91448 -0.29713 Mabsadd L
.41667 .00644 -1.46946 -2.02254 Mabsadd L
.41667 .00644 0 -0.96154 Mabsadd L
.41667 .00644 1.46946 -2.02254 Mabsadd L
.41667 .00644 .91448 -0.29713 Mabsadd L
.41667 .00644 2.37764 .77254 Mabsadd L
.41667 .00644 .56518 .7779 Mabsadd L
.41667 .00644 0 2.5 Mabsadd L closepath F
.42 .00644 0 2.5 Mabsadd m
.42 .00644 -0.56518 .7779 Mabsadd L
.42 .00644 -2.37764 .77254 Mabsadd L
.42 .00644 -0.91448 -0.29713 Mabsadd L
.42 .00644 -1.46946 -2.02254 Mabsadd L
.42 .00644 0 -0.96154 Mabsadd L
.42 .00644 1.46946 -2.02254 Mabsadd L
.42 .00644 .91448 -0.29713 Mabsadd L
.42 .00644 2.37764 .77254 Mabsadd L
.42 .00644 .56518 .7779 Mabsadd L
.42 .00644 0 2.5 Mabsadd L closepath F
.42333 .00644 0 2.5 Mabsadd m
.42333 .00644 -0.56518 .7779 Mabsadd L
.42333 .00644 -2.37764 .77254 Mabsadd L
.42333 .00644 -0.91448 -0.29713 Mabsadd L
.42333 .00644 -1.46946 -2.02254 Mabsadd L
.42333 .00644 0 -0.96154 Mabsadd L
.42333 .00644 1.46946 -2.02254 Mabsadd L
.42333 .00644 .91448 -0.29713 Mabsadd L
.42333 .00644 2.37764 .77254 Mabsadd L
.42333 .00644 .56518 .7779 Mabsadd L
.42333 .00644 0 2.5 Mabsadd L closepath F
.42667 .00644 0 2.5 Mabsadd m
.42667 .00644 -0.56518 .7779 Mabsadd L
.42667 .00644 -2.37764 .77254 Mabsadd L
.42667 .00644 -0.91448 -0.29713 Mabsadd L
.42667 .00644 -1.46946 -2.02254 Mabsadd L
.42667 .00644 0 -0.96154 Mabsadd L
.42667 .00644 1.46946 -2.02254 Mabsadd L
.42667 .00644 .91448 -0.29713 Mabsadd L
.42667 .00644 2.37764 .77254 Mabsadd L
.42667 .00644 .56518 .7779 Mabsadd L
.42667 .00644 0 2.5 Mabsadd L closepath F
.43 .00644 0 2.5 Mabsadd m
.43 .00644 -0.56518 .7779 Mabsadd L
.43 .00644 -2.37764 .77254 Mabsadd L
.43 .00644 -0.91448 -0.29713 Mabsadd L
.43 .00644 -1.46946 -2.02254 Mabsadd L
.43 .00644 0 -0.96154 Mabsadd L
.43 .00644 1.46946 -2.02254 Mabsadd L
.43 .00644 .91448 -0.29713 Mabsadd L
.43 .00644 2.37764 .77254 Mabsadd L
.43 .00644 .56518 .7779 Mabsadd L
.43 .00644 0 2.5 Mabsadd L closepath F
.43333 .00644 0 2.5 Mabsadd m
.43333 .00644 -0.56518 .7779 Mabsadd L
.43333 .00644 -2.37764 .77254 Mabsadd L
.43333 .00644 -0.91448 -0.29713 Mabsadd L
.43333 .00644 -1.46946 -2.02254 Mabsadd L
.43333 .00644 0 -0.96154 Mabsadd L
.43333 .00644 1.46946 -2.02254 Mabsadd L
.43333 .00644 .91448 -0.29713 Mabsadd L
.43333 .00644 2.37764 .77254 Mabsadd L
.43333 .00644 .56518 .7779 Mabsadd L
.43333 .00644 0 2.5 Mabsadd L closepath F
.43667 .00644 0 2.5 Mabsadd m
.43667 .00644 -0.56518 .7779 Mabsadd L
.43667 .00644 -2.37764 .77254 Mabsadd L
.43667 .00644 -0.91448 -0.29713 Mabsadd L
.43667 .00644 -1.46946 -2.02254 Mabsadd L
.43667 .00644 0 -0.96154 Mabsadd L
.43667 .00644 1.46946 -2.02254 Mabsadd L
.43667 .00644 .91448 -0.29713 Mabsadd L
.43667 .00644 2.37764 .77254 Mabsadd L
.43667 .00644 .56518 .7779 Mabsadd L
.43667 .00644 0 2.5 Mabsadd L closepath F
.44 .00644 0 2.5 Mabsadd m
.44 .00644 -0.56518 .7779 Mabsadd L
.44 .00644 -2.37764 .77254 Mabsadd L
.44 .00644 -0.91448 -0.29713 Mabsadd L
.44 .00644 -1.46946 -2.02254 Mabsadd L
.44 .00644 0 -0.96154 Mabsadd L
.44 .00644 1.46946 -2.02254 Mabsadd L
.44 .00644 .91448 -0.29713 Mabsadd L
.44 .00644 2.37764 .77254 Mabsadd L
.44 .00644 .56518 .7779 Mabsadd L
.44 .00644 0 2.5 Mabsadd L closepath F
.44333 .00644 0 2.5 Mabsadd m
.44333 .00644 -0.56518 .7779 Mabsadd L
.44333 .00644 -2.37764 .77254 Mabsadd L
.44333 .00644 -0.91448 -0.29713 Mabsadd L
.44333 .00644 -1.46946 -2.02254 Mabsadd L
.44333 .00644 0 -0.96154 Mabsadd L
.44333 .00644 1.46946 -2.02254 Mabsadd L
.44333 .00644 .91448 -0.29713 Mabsadd L
.44333 .00644 2.37764 .77254 Mabsadd L
.44333 .00644 .56518 .7779 Mabsadd L
.44333 .00644 0 2.5 Mabsadd L closepath F
.44667 .00644 0 2.5 Mabsadd m
.44667 .00644 -0.56518 .7779 Mabsadd L
.44667 .00644 -2.37764 .77254 Mabsadd L
.44667 .00644 -0.91448 -0.29713 Mabsadd L
.44667 .00644 -1.46946 -2.02254 Mabsadd L
.44667 .00644 0 -0.96154 Mabsadd L
.44667 .00644 1.46946 -2.02254 Mabsadd L
.44667 .00644 .91448 -0.29713 Mabsadd L
.44667 .00644 2.37764 .77254 Mabsadd L
.44667 .00644 .56518 .7779 Mabsadd L
.44667 .00644 0 2.5 Mabsadd L closepath F
.45 .00644 0 2.5 Mabsadd m
.45 .00644 -0.56518 .7779 Mabsadd L
.45 .00644 -2.37764 .77254 Mabsadd L
.45 .00644 -0.91448 -0.29713 Mabsadd L
.45 .00644 -1.46946 -2.02254 Mabsadd L
.45 .00644 0 -0.96154 Mabsadd L
.45 .00644 1.46946 -2.02254 Mabsadd L
.45 .00644 .91448 -0.29713 Mabsadd L
.45 .00644 2.37764 .77254 Mabsadd L
.45 .00644 .56518 .7779 Mabsadd L
.45 .00644 0 2.5 Mabsadd L closepath F
.45333 .00644 0 2.5 Mabsadd m
.45333 .00644 -0.56518 .7779 Mabsadd L
.45333 .00644 -2.37764 .77254 Mabsadd L
.45333 .00644 -0.91448 -0.29713 Mabsadd L
.45333 .00644 -1.46946 -2.02254 Mabsadd L
.45333 .00644 0 -0.96154 Mabsadd L
.45333 .00644 1.46946 -2.02254 Mabsadd L
.45333 .00644 .91448 -0.29713 Mabsadd L
.45333 .00644 2.37764 .77254 Mabsadd L
.45333 .00644 .56518 .7779 Mabsadd L
.45333 .00644 0 2.5 Mabsadd L closepath F
.45667 .00644 0 2.5 Mabsadd m
.45667 .00644 -0.56518 .7779 Mabsadd L
.45667 .00644 -2.37764 .77254 Mabsadd L
.45667 .00644 -0.91448 -0.29713 Mabsadd L
.45667 .00644 -1.46946 -2.02254 Mabsadd L
.45667 .00644 0 -0.96154 Mabsadd L
.45667 .00644 1.46946 -2.02254 Mabsadd L
.45667 .00644 .91448 -0.29713 Mabsadd L
.45667 .00644 2.37764 .77254 Mabsadd L
.45667 .00644 .56518 .7779 Mabsadd L
.45667 .00644 0 2.5 Mabsadd L closepath F
.46 .00644 0 2.5 Mabsadd m
.46 .00644 -0.56518 .7779 Mabsadd L
.46 .00644 -2.37764 .77254 Mabsadd L
.46 .00644 -0.91448 -0.29713 Mabsadd L
.46 .00644 -1.46946 -2.02254 Mabsadd L
.46 .00644 0 -0.96154 Mabsadd L
.46 .00644 1.46946 -2.02254 Mabsadd L
.46 .00644 .91448 -0.29713 Mabsadd L
.46 .00644 2.37764 .77254 Mabsadd L
.46 .00644 .56518 .7779 Mabsadd L
.46 .00644 0 2.5 Mabsadd L closepath F
.46333 .00644 0 2.5 Mabsadd m
.46333 .00644 -0.56518 .7779 Mabsadd L
.46333 .00644 -2.37764 .77254 Mabsadd L
.46333 .00644 -0.91448 -0.29713 Mabsadd L
.46333 .00644 -1.46946 -2.02254 Mabsadd L
.46333 .00644 0 -0.96154 Mabsadd L
.46333 .00644 1.46946 -2.02254 Mabsadd L
.46333 .00644 .91448 -0.29713 Mabsadd L
.46333 .00644 2.37764 .77254 Mabsadd L
.46333 .00644 .56518 .7779 Mabsadd L
.46333 .00644 0 2.5 Mabsadd L closepath F
.46667 .00644 0 2.5 Mabsadd m
.46667 .00644 -0.56518 .7779 Mabsadd L
.46667 .00644 -2.37764 .77254 Mabsadd L
.46667 .00644 -0.91448 -0.29713 Mabsadd L
.46667 .00644 -1.46946 -2.02254 Mabsadd L
.46667 .00644 0 -0.96154 Mabsadd L
.46667 .00644 1.46946 -2.02254 Mabsadd L
.46667 .00644 .91448 -0.29713 Mabsadd L
.46667 .00644 2.37764 .77254 Mabsadd L
.46667 .00644 .56518 .7779 Mabsadd L
.46667 .00644 0 2.5 Mabsadd L closepath F
.47 .00644 0 2.5 Mabsadd m
.47 .00644 -0.56518 .7779 Mabsadd L
.47 .00644 -2.37764 .77254 Mabsadd L
.47 .00644 -0.91448 -0.29713 Mabsadd L
.47 .00644 -1.46946 -2.02254 Mabsadd L
.47 .00644 0 -0.96154 Mabsadd L
.47 .00644 1.46946 -2.02254 Mabsadd L
.47 .00644 .91448 -0.29713 Mabsadd L
.47 .00644 2.37764 .77254 Mabsadd L
.47 .00644 .56518 .7779 Mabsadd L
.47 .00644 0 2.5 Mabsadd L closepath F
.47333 .00644 0 2.5 Mabsadd m
.47333 .00644 -0.56518 .7779 Mabsadd L
.47333 .00644 -2.37764 .77254 Mabsadd L
.47333 .00644 -0.91448 -0.29713 Mabsadd L
.47333 .00644 -1.46946 -2.02254 Mabsadd L
.47333 .00644 0 -0.96154 Mabsadd L
.47333 .00644 1.46946 -2.02254 Mabsadd L
.47333 .00644 .91448 -0.29713 Mabsadd L
.47333 .00644 2.37764 .77254 Mabsadd L
.47333 .00644 .56518 .7779 Mabsadd L
.47333 .00644 0 2.5 Mabsadd L closepath F
.47667 .00644 0 2.5 Mabsadd m
.47667 .00644 -0.56518 .7779 Mabsadd L
.47667 .00644 -2.37764 .77254 Mabsadd L
.47667 .00644 -0.91448 -0.29713 Mabsadd L
.47667 .00644 -1.46946 -2.02254 Mabsadd L
.47667 .00644 0 -0.96154 Mabsadd L
.47667 .00644 1.46946 -2.02254 Mabsadd L
.47667 .00644 .91448 -0.29713 Mabsadd L
.47667 .00644 2.37764 .77254 Mabsadd L
.47667 .00644 .56518 .7779 Mabsadd L
.47667 .00644 0 2.5 Mabsadd L closepath F
.48 .00644 0 2.5 Mabsadd m
.48 .00644 -0.56518 .7779 Mabsadd L
.48 .00644 -2.37764 .77254 Mabsadd L
.48 .00644 -0.91448 -0.29713 Mabsadd L
.48 .00644 -1.46946 -2.02254 Mabsadd L
.48 .00644 0 -0.96154 Mabsadd L
.48 .00644 1.46946 -2.02254 Mabsadd L
.48 .00644 .91448 -0.29713 Mabsadd L
.48 .00644 2.37764 .77254 Mabsadd L
.48 .00644 .56518 .7779 Mabsadd L
.48 .00644 0 2.5 Mabsadd L closepath F
.48333 .00644 0 2.5 Mabsadd m
.48333 .00644 -0.56518 .7779 Mabsadd L
.48333 .00644 -2.37764 .77254 Mabsadd L
.48333 .00644 -0.91448 -0.29713 Mabsadd L
.48333 .00644 -1.46946 -2.02254 Mabsadd L
.48333 .00644 0 -0.96154 Mabsadd L
.48333 .00644 1.46946 -2.02254 Mabsadd L
.48333 .00644 .91448 -0.29713 Mabsadd L
.48333 .00644 2.37764 .77254 Mabsadd L
.48333 .00644 .56518 .7779 Mabsadd L
.48333 .00644 0 2.5 Mabsadd L closepath F
.48667 .00644 0 2.5 Mabsadd m
.48667 .00644 -0.56518 .7779 Mabsadd L
.48667 .00644 -2.37764 .77254 Mabsadd L
.48667 .00644 -0.91448 -0.29713 Mabsadd L
.48667 .00644 -1.46946 -2.02254 Mabsadd L
.48667 .00644 0 -0.96154 Mabsadd L
.48667 .00644 1.46946 -2.02254 Mabsadd L
.48667 .00644 .91448 -0.29713 Mabsadd L
.48667 .00644 2.37764 .77254 Mabsadd L
.48667 .00644 .56518 .7779 Mabsadd L
.48667 .00644 0 2.5 Mabsadd L closepath F
.49 .00644 0 2.5 Mabsadd m
.49 .00644 -0.56518 .7779 Mabsadd L
.49 .00644 -2.37764 .77254 Mabsadd L
.49 .00644 -0.91448 -0.29713 Mabsadd L
.49 .00644 -1.46946 -2.02254 Mabsadd L
.49 .00644 0 -0.96154 Mabsadd L
.49 .00644 1.46946 -2.02254 Mabsadd L
.49 .00644 .91448 -0.29713 Mabsadd L
.49 .00644 2.37764 .77254 Mabsadd L
.49 .00644 .56518 .7779 Mabsadd L
.49 .00644 0 2.5 Mabsadd L closepath F
.49333 .00644 0 2.5 Mabsadd m
.49333 .00644 -0.56518 .7779 Mabsadd L
.49333 .00644 -2.37764 .77254 Mabsadd L
.49333 .00644 -0.91448 -0.29713 Mabsadd L
.49333 .00644 -1.46946 -2.02254 Mabsadd L
.49333 .00644 0 -0.96154 Mabsadd L
.49333 .00644 1.46946 -2.02254 Mabsadd L
.49333 .00644 .91448 -0.29713 Mabsadd L
.49333 .00644 2.37764 .77254 Mabsadd L
.49333 .00644 .56518 .7779 Mabsadd L
.49333 .00644 0 2.5 Mabsadd L closepath F
.49667 .00644 0 2.5 Mabsadd m
.49667 .00644 -0.56518 .7779 Mabsadd L
.49667 .00644 -2.37764 .77254 Mabsadd L
.49667 .00644 -0.91448 -0.29713 Mabsadd L
.49667 .00644 -1.46946 -2.02254 Mabsadd L
.49667 .00644 0 -0.96154 Mabsadd L
.49667 .00644 1.46946 -2.02254 Mabsadd L
.49667 .00644 .91448 -0.29713 Mabsadd L
.49667 .00644 2.37764 .77254 Mabsadd L
.49667 .00644 .56518 .7779 Mabsadd L
.49667 .00644 0 2.5 Mabsadd L closepath F
.5 .00644 0 2.5 Mabsadd m
.5 .00644 -0.56518 .7779 Mabsadd L
.5 .00644 -2.37764 .77254 Mabsadd L
.5 .00644 -0.91448 -0.29713 Mabsadd L
.5 .00644 -1.46946 -2.02254 Mabsadd L
.5 .00644 0 -0.96154 Mabsadd L
.5 .00644 1.46946 -2.02254 Mabsadd L
.5 .00644 .91448 -0.29713 Mabsadd L
.5 .00644 2.37764 .77254 Mabsadd L
.5 .00644 .56518 .7779 Mabsadd L
.5 .00644 0 2.5 Mabsadd L closepath F
.50333 .00644 0 2.5 Mabsadd m
.50333 .00644 -0.56518 .7779 Mabsadd L
.50333 .00644 -2.37764 .77254 Mabsadd L
.50333 .00644 -0.91448 -0.29713 Mabsadd L
.50333 .00644 -1.46946 -2.02254 Mabsadd L
.50333 .00644 0 -0.96154 Mabsadd L
.50333 .00644 1.46946 -2.02254 Mabsadd L
.50333 .00644 .91448 -0.29713 Mabsadd L
.50333 .00644 2.37764 .77254 Mabsadd L
.50333 .00644 .56518 .7779 Mabsadd L
.50333 .00644 0 2.5 Mabsadd L closepath F
.50667 .00644 0 2.5 Mabsadd m
.50667 .00644 -0.56518 .7779 Mabsadd L
.50667 .00644 -2.37764 .77254 Mabsadd L
.50667 .00644 -0.91448 -0.29713 Mabsadd L
.50667 .00644 -1.46946 -2.02254 Mabsadd L
.50667 .00644 0 -0.96154 Mabsadd L
.50667 .00644 1.46946 -2.02254 Mabsadd L
.50667 .00644 .91448 -0.29713 Mabsadd L
.50667 .00644 2.37764 .77254 Mabsadd L
.50667 .00644 .56518 .7779 Mabsadd L
.50667 .00644 0 2.5 Mabsadd L closepath F
.51 .00644 0 2.5 Mabsadd m
.51 .00644 -0.56518 .7779 Mabsadd L
.51 .00644 -2.37764 .77254 Mabsadd L
.51 .00644 -0.91448 -0.29713 Mabsadd L
.51 .00644 -1.46946 -2.02254 Mabsadd L
.51 .00644 0 -0.96154 Mabsadd L
.51 .00644 1.46946 -2.02254 Mabsadd L
.51 .00644 .91448 -0.29713 Mabsadd L
.51 .00644 2.37764 .77254 Mabsadd L
.51 .00644 .56518 .7779 Mabsadd L
.51 .00644 0 2.5 Mabsadd L closepath F
.51333 .00644 0 2.5 Mabsadd m
.51333 .00644 -0.56518 .7779 Mabsadd L
.51333 .00644 -2.37764 .77254 Mabsadd L
.51333 .00644 -0.91448 -0.29713 Mabsadd L
.51333 .00644 -1.46946 -2.02254 Mabsadd L
.51333 .00644 0 -0.96154 Mabsadd L
.51333 .00644 1.46946 -2.02254 Mabsadd L
.51333 .00644 .91448 -0.29713 Mabsadd L
.51333 .00644 2.37764 .77254 Mabsadd L
.51333 .00644 .56518 .7779 Mabsadd L
.51333 .00644 0 2.5 Mabsadd L closepath F
.51667 .00644 0 2.5 Mabsadd m
.51667 .00644 -0.56518 .7779 Mabsadd L
.51667 .00644 -2.37764 .77254 Mabsadd L
.51667 .00644 -0.91448 -0.29713 Mabsadd L
.51667 .00644 -1.46946 -2.02254 Mabsadd L
.51667 .00644 0 -0.96154 Mabsadd L
.51667 .00644 1.46946 -2.02254 Mabsadd L
.51667 .00644 .91448 -0.29713 Mabsadd L
.51667 .00644 2.37764 .77254 Mabsadd L
.51667 .00644 .56518 .7779 Mabsadd L
.51667 .00644 0 2.5 Mabsadd L closepath F
.52 .00644 0 2.5 Mabsadd m
.52 .00644 -0.56518 .7779 Mabsadd L
.52 .00644 -2.37764 .77254 Mabsadd L
.52 .00644 -0.91448 -0.29713 Mabsadd L
.52 .00644 -1.46946 -2.02254 Mabsadd L
.52 .00644 0 -0.96154 Mabsadd L
.52 .00644 1.46946 -2.02254 Mabsadd L
.52 .00644 .91448 -0.29713 Mabsadd L
.52 .00644 2.37764 .77254 Mabsadd L
.52 .00644 .56518 .7779 Mabsadd L
.52 .00644 0 2.5 Mabsadd L closepath F
.52333 .00644 0 2.5 Mabsadd m
.52333 .00644 -0.56518 .7779 Mabsadd L
.52333 .00644 -2.37764 .77254 Mabsadd L
.52333 .00644 -0.91448 -0.29713 Mabsadd L
.52333 .00644 -1.46946 -2.02254 Mabsadd L
.52333 .00644 0 -0.96154 Mabsadd L
.52333 .00644 1.46946 -2.02254 Mabsadd L
.52333 .00644 .91448 -0.29713 Mabsadd L
.52333 .00644 2.37764 .77254 Mabsadd L
.52333 .00644 .56518 .7779 Mabsadd L
.52333 .00644 0 2.5 Mabsadd L closepath F
.52667 .00644 0 2.5 Mabsadd m
.52667 .00644 -0.56518 .7779 Mabsadd L
.52667 .00644 -2.37764 .77254 Mabsadd L
.52667 .00644 -0.91448 -0.29713 Mabsadd L
.52667 .00644 -1.46946 -2.02254 Mabsadd L
.52667 .00644 0 -0.96154 Mabsadd L
.52667 .00644 1.46946 -2.02254 Mabsadd L
.52667 .00644 .91448 -0.29713 Mabsadd L
.52667 .00644 2.37764 .77254 Mabsadd L
.52667 .00644 .56518 .7779 Mabsadd L
.52667 .00644 0 2.5 Mabsadd L closepath F
.53 .00644 0 2.5 Mabsadd m
.53 .00644 -0.56518 .7779 Mabsadd L
.53 .00644 -2.37764 .77254 Mabsadd L
.53 .00644 -0.91448 -0.29713 Mabsadd L
.53 .00644 -1.46946 -2.02254 Mabsadd L
.53 .00644 0 -0.96154 Mabsadd L
.53 .00644 1.46946 -2.02254 Mabsadd L
.53 .00644 .91448 -0.29713 Mabsadd L
.53 .00644 2.37764 .77254 Mabsadd L
.53 .00644 .56518 .7779 Mabsadd L
.53 .00644 0 2.5 Mabsadd L closepath F
.53333 .00644 0 2.5 Mabsadd m
.53333 .00644 -0.56518 .7779 Mabsadd L
.53333 .00644 -2.37764 .77254 Mabsadd L
.53333 .00644 -0.91448 -0.29713 Mabsadd L
.53333 .00644 -1.46946 -2.02254 Mabsadd L
.53333 .00644 0 -0.96154 Mabsadd L
.53333 .00644 1.46946 -2.02254 Mabsadd L
.53333 .00644 .91448 -0.29713 Mabsadd L
.53333 .00644 2.37764 .77254 Mabsadd L
.53333 .00644 .56518 .7779 Mabsadd L
.53333 .00644 0 2.5 Mabsadd L closepath F
.53667 .00644 0 2.5 Mabsadd m
.53667 .00644 -0.56518 .7779 Mabsadd L
.53667 .00644 -2.37764 .77254 Mabsadd L
.53667 .00644 -0.91448 -0.29713 Mabsadd L
.53667 .00644 -1.46946 -2.02254 Mabsadd L
.53667 .00644 0 -0.96154 Mabsadd L
.53667 .00644 1.46946 -2.02254 Mabsadd L
.53667 .00644 .91448 -0.29713 Mabsadd L
.53667 .00644 2.37764 .77254 Mabsadd L
.53667 .00644 .56518 .7779 Mabsadd L
.53667 .00644 0 2.5 Mabsadd L closepath F
.54 .00644 0 2.5 Mabsadd m
.54 .00644 -0.56518 .7779 Mabsadd L
.54 .00644 -2.37764 .77254 Mabsadd L
.54 .00644 -0.91448 -0.29713 Mabsadd L
.54 .00644 -1.46946 -2.02254 Mabsadd L
.54 .00644 0 -0.96154 Mabsadd L
.54 .00644 1.46946 -2.02254 Mabsadd L
.54 .00644 .91448 -0.29713 Mabsadd L
.54 .00644 2.37764 .77254 Mabsadd L
.54 .00644 .56518 .7779 Mabsadd L
.54 .00644 0 2.5 Mabsadd L closepath F
.54333 .00644 0 2.5 Mabsadd m
.54333 .00644 -0.56518 .7779 Mabsadd L
.54333 .00644 -2.37764 .77254 Mabsadd L
.54333 .00644 -0.91448 -0.29713 Mabsadd L
.54333 .00644 -1.46946 -2.02254 Mabsadd L
.54333 .00644 0 -0.96154 Mabsadd L
.54333 .00644 1.46946 -2.02254 Mabsadd L
.54333 .00644 .91448 -0.29713 Mabsadd L
.54333 .00644 2.37764 .77254 Mabsadd L
.54333 .00644 .56518 .7779 Mabsadd L
.54333 .00644 0 2.5 Mabsadd L closepath F
.54667 .00644 0 2.5 Mabsadd m
.54667 .00644 -0.56518 .7779 Mabsadd L
.54667 .00644 -2.37764 .77254 Mabsadd L
.54667 .00644 -0.91448 -0.29713 Mabsadd L
.54667 .00644 -1.46946 -2.02254 Mabsadd L
.54667 .00644 0 -0.96154 Mabsadd L
.54667 .00644 1.46946 -2.02254 Mabsadd L
.54667 .00644 .91448 -0.29713 Mabsadd L
.54667 .00644 2.37764 .77254 Mabsadd L
.54667 .00644 .56518 .7779 Mabsadd L
.54667 .00644 0 2.5 Mabsadd L closepath F
.55 .00644 0 2.5 Mabsadd m
.55 .00644 -0.56518 .7779 Mabsadd L
.55 .00644 -2.37764 .77254 Mabsadd L
.55 .00644 -0.91448 -0.29713 Mabsadd L
.55 .00644 -1.46946 -2.02254 Mabsadd L
.55 .00644 0 -0.96154 Mabsadd L
.55 .00644 1.46946 -2.02254 Mabsadd L
.55 .00644 .91448 -0.29713 Mabsadd L
.55 .00644 2.37764 .77254 Mabsadd L
.55 .00644 .56518 .7779 Mabsadd L
.55 .00644 0 2.5 Mabsadd L closepath F
.55333 .00644 0 2.5 Mabsadd m
.55333 .00644 -0.56518 .7779 Mabsadd L
.55333 .00644 -2.37764 .77254 Mabsadd L
.55333 .00644 -0.91448 -0.29713 Mabsadd L
.55333 .00644 -1.46946 -2.02254 Mabsadd L
.55333 .00644 0 -0.96154 Mabsadd L
.55333 .00644 1.46946 -2.02254 Mabsadd L
.55333 .00644 .91448 -0.29713 Mabsadd L
.55333 .00644 2.37764 .77254 Mabsadd L
.55333 .00644 .56518 .7779 Mabsadd L
.55333 .00644 0 2.5 Mabsadd L closepath F
.55667 .00644 0 2.5 Mabsadd m
.55667 .00644 -0.56518 .7779 Mabsadd L
.55667 .00644 -2.37764 .77254 Mabsadd L
.55667 .00644 -0.91448 -0.29713 Mabsadd L
.55667 .00644 -1.46946 -2.02254 Mabsadd L
.55667 .00644 0 -0.96154 Mabsadd L
.55667 .00644 1.46946 -2.02254 Mabsadd L
.55667 .00644 .91448 -0.29713 Mabsadd L
.55667 .00644 2.37764 .77254 Mabsadd L
.55667 .00644 .56518 .7779 Mabsadd L
.55667 .00644 0 2.5 Mabsadd L closepath F
.56 .00644 0 2.5 Mabsadd m
.56 .00644 -0.56518 .7779 Mabsadd L
.56 .00644 -2.37764 .77254 Mabsadd L
.56 .00644 -0.91448 -0.29713 Mabsadd L
.56 .00644 -1.46946 -2.02254 Mabsadd L
.56 .00644 0 -0.96154 Mabsadd L
.56 .00644 1.46946 -2.02254 Mabsadd L
.56 .00644 .91448 -0.29713 Mabsadd L
.56 .00644 2.37764 .77254 Mabsadd L
.56 .00644 .56518 .7779 Mabsadd L
.56 .00644 0 2.5 Mabsadd L closepath F
.56333 .00644 0 2.5 Mabsadd m
.56333 .00644 -0.56518 .7779 Mabsadd L
.56333 .00644 -2.37764 .77254 Mabsadd L
.56333 .00644 -0.91448 -0.29713 Mabsadd L
.56333 .00644 -1.46946 -2.02254 Mabsadd L
.56333 .00644 0 -0.96154 Mabsadd L
.56333 .00644 1.46946 -2.02254 Mabsadd L
.56333 .00644 .91448 -0.29713 Mabsadd L
.56333 .00644 2.37764 .77254 Mabsadd L
.56333 .00644 .56518 .7779 Mabsadd L
.56333 .00644 0 2.5 Mabsadd L closepath F
.56667 .00644 0 2.5 Mabsadd m
.56667 .00644 -0.56518 .7779 Mabsadd L
.56667 .00644 -2.37764 .77254 Mabsadd L
.56667 .00644 -0.91448 -0.29713 Mabsadd L
.56667 .00644 -1.46946 -2.02254 Mabsadd L
.56667 .00644 0 -0.96154 Mabsadd L
.56667 .00644 1.46946 -2.02254 Mabsadd L
.56667 .00644 .91448 -0.29713 Mabsadd L
.56667 .00644 2.37764 .77254 Mabsadd L
.56667 .00644 .56518 .7779 Mabsadd L
.56667 .00644 0 2.5 Mabsadd L closepath F
.57 .00644 0 2.5 Mabsadd m
.57 .00644 -0.56518 .7779 Mabsadd L
.57 .00644 -2.37764 .77254 Mabsadd L
.57 .00644 -0.91448 -0.29713 Mabsadd L
.57 .00644 -1.46946 -2.02254 Mabsadd L
.57 .00644 0 -0.96154 Mabsadd L
.57 .00644 1.46946 -2.02254 Mabsadd L
.57 .00644 .91448 -0.29713 Mabsadd L
.57 .00644 2.37764 .77254 Mabsadd L
.57 .00644 .56518 .7779 Mabsadd L
.57 .00644 0 2.5 Mabsadd L closepath F
.57333 .00644 0 2.5 Mabsadd m
.57333 .00644 -0.56518 .7779 Mabsadd L
.57333 .00644 -2.37764 .77254 Mabsadd L
.57333 .00644 -0.91448 -0.29713 Mabsadd L
.57333 .00644 -1.46946 -2.02254 Mabsadd L
.57333 .00644 0 -0.96154 Mabsadd L
.57333 .00644 1.46946 -2.02254 Mabsadd L
.57333 .00644 .91448 -0.29713 Mabsadd L
.57333 .00644 2.37764 .77254 Mabsadd L
.57333 .00644 .56518 .7779 Mabsadd L
.57333 .00644 0 2.5 Mabsadd L closepath F
.57667 .00644 0 2.5 Mabsadd m
.57667 .00644 -0.56518 .7779 Mabsadd L
.57667 .00644 -2.37764 .77254 Mabsadd L
.57667 .00644 -0.91448 -0.29713 Mabsadd L
.57667 .00644 -1.46946 -2.02254 Mabsadd L
.57667 .00644 0 -0.96154 Mabsadd L
.57667 .00644 1.46946 -2.02254 Mabsadd L
.57667 .00644 .91448 -0.29713 Mabsadd L
.57667 .00644 2.37764 .77254 Mabsadd L
.57667 .00644 .56518 .7779 Mabsadd L
.57667 .00644 0 2.5 Mabsadd L closepath F
.58 .00644 0 2.5 Mabsadd m
.58 .00644 -0.56518 .7779 Mabsadd L
.58 .00644 -2.37764 .77254 Mabsadd L
.58 .00644 -0.91448 -0.29713 Mabsadd L
.58 .00644 -1.46946 -2.02254 Mabsadd L
.58 .00644 0 -0.96154 Mabsadd L
.58 .00644 1.46946 -2.02254 Mabsadd L
.58 .00644 .91448 -0.29713 Mabsadd L
.58 .00644 2.37764 .77254 Mabsadd L
.58 .00644 .56518 .7779 Mabsadd L
.58 .00644 0 2.5 Mabsadd L closepath F
.58333 .00644 0 2.5 Mabsadd m
.58333 .00644 -0.56518 .7779 Mabsadd L
.58333 .00644 -2.37764 .77254 Mabsadd L
.58333 .00644 -0.91448 -0.29713 Mabsadd L
.58333 .00644 -1.46946 -2.02254 Mabsadd L
.58333 .00644 0 -0.96154 Mabsadd L
.58333 .00644 1.46946 -2.02254 Mabsadd L
.58333 .00644 .91448 -0.29713 Mabsadd L
.58333 .00644 2.37764 .77254 Mabsadd L
.58333 .00644 .56518 .7779 Mabsadd L
.58333 .00644 0 2.5 Mabsadd L closepath F
.58667 .00644 0 2.5 Mabsadd m
.58667 .00644 -0.56518 .7779 Mabsadd L
.58667 .00644 -2.37764 .77254 Mabsadd L
.58667 .00644 -0.91448 -0.29713 Mabsadd L
.58667 .00644 -1.46946 -2.02254 Mabsadd L
.58667 .00644 0 -0.96154 Mabsadd L
.58667 .00644 1.46946 -2.02254 Mabsadd L
.58667 .00644 .91448 -0.29713 Mabsadd L
.58667 .00644 2.37764 .77254 Mabsadd L
.58667 .00644 .56518 .7779 Mabsadd L
.58667 .00644 0 2.5 Mabsadd L closepath F
.59 .00644 0 2.5 Mabsadd m
.59 .00644 -0.56518 .7779 Mabsadd L
.59 .00644 -2.37764 .77254 Mabsadd L
.59 .00644 -0.91448 -0.29713 Mabsadd L
.59 .00644 -1.46946 -2.02254 Mabsadd L
.59 .00644 0 -0.96154 Mabsadd L
.59 .00644 1.46946 -2.02254 Mabsadd L
.59 .00644 .91448 -0.29713 Mabsadd L
.59 .00644 2.37764 .77254 Mabsadd L
.59 .00644 .56518 .7779 Mabsadd L
.59 .00644 0 2.5 Mabsadd L closepath F
.59333 .00644 0 2.5 Mabsadd m
.59333 .00644 -0.56518 .7779 Mabsadd L
.59333 .00644 -2.37764 .77254 Mabsadd L
.59333 .00644 -0.91448 -0.29713 Mabsadd L
.59333 .00644 -1.46946 -2.02254 Mabsadd L
.59333 .00644 0 -0.96154 Mabsadd L
.59333 .00644 1.46946 -2.02254 Mabsadd L
.59333 .00644 .91448 -0.29713 Mabsadd L
.59333 .00644 2.37764 .77254 Mabsadd L
.59333 .00644 .56518 .7779 Mabsadd L
.59333 .00644 0 2.5 Mabsadd L closepath F
.59667 .00644 0 2.5 Mabsadd m
.59667 .00644 -0.56518 .7779 Mabsadd L
.59667 .00644 -2.37764 .77254 Mabsadd L
.59667 .00644 -0.91448 -0.29713 Mabsadd L
.59667 .00644 -1.46946 -2.02254 Mabsadd L
.59667 .00644 0 -0.96154 Mabsadd L
.59667 .00644 1.46946 -2.02254 Mabsadd L
.59667 .00644 .91448 -0.29713 Mabsadd L
.59667 .00644 2.37764 .77254 Mabsadd L
.59667 .00644 .56518 .7779 Mabsadd L
.59667 .00644 0 2.5 Mabsadd L closepath F
.6 .00644 0 2.5 Mabsadd m
.6 .00644 -0.56518 .7779 Mabsadd L
.6 .00644 -2.37764 .77254 Mabsadd L
.6 .00644 -0.91448 -0.29713 Mabsadd L
.6 .00644 -1.46946 -2.02254 Mabsadd L
.6 .00644 0 -0.96154 Mabsadd L
.6 .00644 1.46946 -2.02254 Mabsadd L
.6 .00644 .91448 -0.29713 Mabsadd L
.6 .00644 2.37764 .77254 Mabsadd L
.6 .00644 .56518 .7779 Mabsadd L
.6 .00644 0 2.5 Mabsadd L closepath F
.60333 .00644 0 2.5 Mabsadd m
.60333 .00644 -0.56518 .7779 Mabsadd L
.60333 .00644 -2.37764 .77254 Mabsadd L
.60333 .00644 -0.91448 -0.29713 Mabsadd L
.60333 .00644 -1.46946 -2.02254 Mabsadd L
.60333 .00644 0 -0.96154 Mabsadd L
.60333 .00644 1.46946 -2.02254 Mabsadd L
.60333 .00644 .91448 -0.29713 Mabsadd L
.60333 .00644 2.37764 .77254 Mabsadd L
.60333 .00644 .56518 .7779 Mabsadd L
.60333 .00644 0 2.5 Mabsadd L closepath F
.60667 .00644 0 2.5 Mabsadd m
.60667 .00644 -0.56518 .7779 Mabsadd L
.60667 .00644 -2.37764 .77254 Mabsadd L
.60667 .00644 -0.91448 -0.29713 Mabsadd L
.60667 .00644 -1.46946 -2.02254 Mabsadd L
.60667 .00644 0 -0.96154 Mabsadd L
.60667 .00644 1.46946 -2.02254 Mabsadd L
.60667 .00644 .91448 -0.29713 Mabsadd L
.60667 .00644 2.37764 .77254 Mabsadd L
.60667 .00644 .56518 .7779 Mabsadd L
.60667 .00644 0 2.5 Mabsadd L closepath F
.61 .00644 0 2.5 Mabsadd m
.61 .00644 -0.56518 .7779 Mabsadd L
.61 .00644 -2.37764 .77254 Mabsadd L
.61 .00644 -0.91448 -0.29713 Mabsadd L
.61 .00644 -1.46946 -2.02254 Mabsadd L
.61 .00644 0 -0.96154 Mabsadd L
.61 .00644 1.46946 -2.02254 Mabsadd L
.61 .00644 .91448 -0.29713 Mabsadd L
.61 .00644 2.37764 .77254 Mabsadd L
.61 .00644 .56518 .7779 Mabsadd L
.61 .00644 0 2.5 Mabsadd L closepath F
.61333 .00644 0 2.5 Mabsadd m
.61333 .00644 -0.56518 .7779 Mabsadd L
.61333 .00644 -2.37764 .77254 Mabsadd L
.61333 .00644 -0.91448 -0.29713 Mabsadd L
.61333 .00644 -1.46946 -2.02254 Mabsadd L
.61333 .00644 0 -0.96154 Mabsadd L
.61333 .00644 1.46946 -2.02254 Mabsadd L
.61333 .00644 .91448 -0.29713 Mabsadd L
.61333 .00644 2.37764 .77254 Mabsadd L
.61333 .00644 .56518 .7779 Mabsadd L
.61333 .00644 0 2.5 Mabsadd L closepath F
.61667 .00644 0 2.5 Mabsadd m
.61667 .00644 -0.56518 .7779 Mabsadd L
.61667 .00644 -2.37764 .77254 Mabsadd L
.61667 .00644 -0.91448 -0.29713 Mabsadd L
.61667 .00644 -1.46946 -2.02254 Mabsadd L
.61667 .00644 0 -0.96154 Mabsadd L
.61667 .00644 1.46946 -2.02254 Mabsadd L
.61667 .00644 .91448 -0.29713 Mabsadd L
.61667 .00644 2.37764 .77254 Mabsadd L
.61667 .00644 .56518 .7779 Mabsadd L
.61667 .00644 0 2.5 Mabsadd L closepath F
.62 .00644 0 2.5 Mabsadd m
.62 .00644 -0.56518 .7779 Mabsadd L
.62 .00644 -2.37764 .77254 Mabsadd L
.62 .00644 -0.91448 -0.29713 Mabsadd L
.62 .00644 -1.46946 -2.02254 Mabsadd L
.62 .00644 0 -0.96154 Mabsadd L
.62 .00644 1.46946 -2.02254 Mabsadd L
.62 .00644 .91448 -0.29713 Mabsadd L
.62 .00644 2.37764 .77254 Mabsadd L
.62 .00644 .56518 .7779 Mabsadd L
.62 .00644 0 2.5 Mabsadd L closepath F
.62333 .00644 0 2.5 Mabsadd m
.62333 .00644 -0.56518 .7779 Mabsadd L
.62333 .00644 -2.37764 .77254 Mabsadd L
.62333 .00644 -0.91448 -0.29713 Mabsadd L
.62333 .00644 -1.46946 -2.02254 Mabsadd L
.62333 .00644 0 -0.96154 Mabsadd L
.62333 .00644 1.46946 -2.02254 Mabsadd L
.62333 .00644 .91448 -0.29713 Mabsadd L
.62333 .00644 2.37764 .77254 Mabsadd L
.62333 .00644 .56518 .7779 Mabsadd L
.62333 .00644 0 2.5 Mabsadd L closepath F
.62667 .00644 0 2.5 Mabsadd m
.62667 .00644 -0.56518 .7779 Mabsadd L
.62667 .00644 -2.37764 .77254 Mabsadd L
.62667 .00644 -0.91448 -0.29713 Mabsadd L
.62667 .00644 -1.46946 -2.02254 Mabsadd L
.62667 .00644 0 -0.96154 Mabsadd L
.62667 .00644 1.46946 -2.02254 Mabsadd L
.62667 .00644 .91448 -0.29713 Mabsadd L
.62667 .00644 2.37764 .77254 Mabsadd L
.62667 .00644 .56518 .7779 Mabsadd L
.62667 .00644 0 2.5 Mabsadd L closepath F
.63 .00644 0 2.5 Mabsadd m
.63 .00644 -0.56518 .7779 Mabsadd L
.63 .00644 -2.37764 .77254 Mabsadd L
.63 .00644 -0.91448 -0.29713 Mabsadd L
.63 .00644 -1.46946 -2.02254 Mabsadd L
.63 .00644 0 -0.96154 Mabsadd L
.63 .00644 1.46946 -2.02254 Mabsadd L
.63 .00644 .91448 -0.29713 Mabsadd L
.63 .00644 2.37764 .77254 Mabsadd L
.63 .00644 .56518 .7779 Mabsadd L
.63 .00644 0 2.5 Mabsadd L closepath F
.63333 .00644 0 2.5 Mabsadd m
.63333 .00644 -0.56518 .7779 Mabsadd L
.63333 .00644 -2.37764 .77254 Mabsadd L
.63333 .00644 -0.91448 -0.29713 Mabsadd L
.63333 .00644 -1.46946 -2.02254 Mabsadd L
.63333 .00644 0 -0.96154 Mabsadd L
.63333 .00644 1.46946 -2.02254 Mabsadd L
.63333 .00644 .91448 -0.29713 Mabsadd L
.63333 .00644 2.37764 .77254 Mabsadd L
.63333 .00644 .56518 .7779 Mabsadd L
.63333 .00644 0 2.5 Mabsadd L closepath F
.63667 .00644 0 2.5 Mabsadd m
.63667 .00644 -0.56518 .7779 Mabsadd L
.63667 .00644 -2.37764 .77254 Mabsadd L
.63667 .00644 -0.91448 -0.29713 Mabsadd L
.63667 .00644 -1.46946 -2.02254 Mabsadd L
.63667 .00644 0 -0.96154 Mabsadd L
.63667 .00644 1.46946 -2.02254 Mabsadd L
.63667 .00644 .91448 -0.29713 Mabsadd L
.63667 .00644 2.37764 .77254 Mabsadd L
.63667 .00644 .56518 .7779 Mabsadd L
.63667 .00644 0 2.5 Mabsadd L closepath F
.64 .00644 0 2.5 Mabsadd m
.64 .00644 -0.56518 .7779 Mabsadd L
.64 .00644 -2.37764 .77254 Mabsadd L
.64 .00644 -0.91448 -0.29713 Mabsadd L
.64 .00644 -1.46946 -2.02254 Mabsadd L
.64 .00644 0 -0.96154 Mabsadd L
.64 .00644 1.46946 -2.02254 Mabsadd L
.64 .00644 .91448 -0.29713 Mabsadd L
.64 .00644 2.37764 .77254 Mabsadd L
.64 .00644 .56518 .7779 Mabsadd L
.64 .00644 0 2.5 Mabsadd L closepath F
.64333 .00644 0 2.5 Mabsadd m
.64333 .00644 -0.56518 .7779 Mabsadd L
.64333 .00644 -2.37764 .77254 Mabsadd L
.64333 .00644 -0.91448 -0.29713 Mabsadd L
.64333 .00644 -1.46946 -2.02254 Mabsadd L
.64333 .00644 0 -0.96154 Mabsadd L
.64333 .00644 1.46946 -2.02254 Mabsadd L
.64333 .00644 .91448 -0.29713 Mabsadd L
.64333 .00644 2.37764 .77254 Mabsadd L
.64333 .00644 .56518 .7779 Mabsadd L
.64333 .00644 0 2.5 Mabsadd L closepath F
.64667 .00644 0 2.5 Mabsadd m
.64667 .00644 -0.56518 .7779 Mabsadd L
.64667 .00644 -2.37764 .77254 Mabsadd L
.64667 .00644 -0.91448 -0.29713 Mabsadd L
.64667 .00644 -1.46946 -2.02254 Mabsadd L
.64667 .00644 0 -0.96154 Mabsadd L
.64667 .00644 1.46946 -2.02254 Mabsadd L
.64667 .00644 .91448 -0.29713 Mabsadd L
.64667 .00644 2.37764 .77254 Mabsadd L
.64667 .00644 .56518 .7779 Mabsadd L
.64667 .00644 0 2.5 Mabsadd L closepath F
.65 .00644 0 2.5 Mabsadd m
.65 .00644 -0.56518 .7779 Mabsadd L
.65 .00644 -2.37764 .77254 Mabsadd L
.65 .00644 -0.91448 -0.29713 Mabsadd L
.65 .00644 -1.46946 -2.02254 Mabsadd L
.65 .00644 0 -0.96154 Mabsadd L
.65 .00644 1.46946 -2.02254 Mabsadd L
.65 .00644 .91448 -0.29713 Mabsadd L
.65 .00644 2.37764 .77254 Mabsadd L
.65 .00644 .56518 .7779 Mabsadd L
.65 .00644 0 2.5 Mabsadd L closepath F
.65333 .00644 0 2.5 Mabsadd m
.65333 .00644 -0.56518 .7779 Mabsadd L
.65333 .00644 -2.37764 .77254 Mabsadd L
.65333 .00644 -0.91448 -0.29713 Mabsadd L
.65333 .00644 -1.46946 -2.02254 Mabsadd L
.65333 .00644 0 -0.96154 Mabsadd L
.65333 .00644 1.46946 -2.02254 Mabsadd L
.65333 .00644 .91448 -0.29713 Mabsadd L
.65333 .00644 2.37764 .77254 Mabsadd L
.65333 .00644 .56518 .7779 Mabsadd L
.65333 .00644 0 2.5 Mabsadd L closepath F
.65667 .00644 0 2.5 Mabsadd m
.65667 .00644 -0.56518 .7779 Mabsadd L
.65667 .00644 -2.37764 .77254 Mabsadd L
.65667 .00644 -0.91448 -0.29713 Mabsadd L
.65667 .00644 -1.46946 -2.02254 Mabsadd L
.65667 .00644 0 -0.96154 Mabsadd L
.65667 .00644 1.46946 -2.02254 Mabsadd L
.65667 .00644 .91448 -0.29713 Mabsadd L
.65667 .00644 2.37764 .77254 Mabsadd L
.65667 .00644 .56518 .7779 Mabsadd L
.65667 .00644 0 2.5 Mabsadd L closepath F
.66 .00644 0 2.5 Mabsadd m
.66 .00644 -0.56518 .7779 Mabsadd L
.66 .00644 -2.37764 .77254 Mabsadd L
.66 .00644 -0.91448 -0.29713 Mabsadd L
.66 .00644 -1.46946 -2.02254 Mabsadd L
.66 .00644 0 -0.96154 Mabsadd L
.66 .00644 1.46946 -2.02254 Mabsadd L
.66 .00644 .91448 -0.29713 Mabsadd L
.66 .00644 2.37764 .77254 Mabsadd L
.66 .00644 .56518 .7779 Mabsadd L
.66 .00644 0 2.5 Mabsadd L closepath F
.66333 .00644 0 2.5 Mabsadd m
.66333 .00644 -0.56518 .7779 Mabsadd L
.66333 .00644 -2.37764 .77254 Mabsadd L
.66333 .00644 -0.91448 -0.29713 Mabsadd L
.66333 .00644 -1.46946 -2.02254 Mabsadd L
.66333 .00644 0 -0.96154 Mabsadd L
.66333 .00644 1.46946 -2.02254 Mabsadd L
.66333 .00644 .91448 -0.29713 Mabsadd L
.66333 .00644 2.37764 .77254 Mabsadd L
.66333 .00644 .56518 .7779 Mabsadd L
.66333 .00644 0 2.5 Mabsadd L closepath F
.66667 .00644 0 2.5 Mabsadd m
.66667 .00644 -0.56518 .7779 Mabsadd L
.66667 .00644 -2.37764 .77254 Mabsadd L
.66667 .00644 -0.91448 -0.29713 Mabsadd L
.66667 .00644 -1.46946 -2.02254 Mabsadd L
.66667 .00644 0 -0.96154 Mabsadd L
.66667 .00644 1.46946 -2.02254 Mabsadd L
.66667 .00644 .91448 -0.29713 Mabsadd L
.66667 .00644 2.37764 .77254 Mabsadd L
.66667 .00644 .56518 .7779 Mabsadd L
.66667 .00644 0 2.5 Mabsadd L closepath F
.67 .00644 0 2.5 Mabsadd m
.67 .00644 -0.56518 .7779 Mabsadd L
.67 .00644 -2.37764 .77254 Mabsadd L
.67 .00644 -0.91448 -0.29713 Mabsadd L
.67 .00644 -1.46946 -2.02254 Mabsadd L
.67 .00644 0 -0.96154 Mabsadd L
.67 .00644 1.46946 -2.02254 Mabsadd L
.67 .00644 .91448 -0.29713 Mabsadd L
.67 .00644 2.37764 .77254 Mabsadd L
.67 .00644 .56518 .7779 Mabsadd L
.67 .00644 0 2.5 Mabsadd L closepath F
.67333 .00644 0 2.5 Mabsadd m
.67333 .00644 -0.56518 .7779 Mabsadd L
.67333 .00644 -2.37764 .77254 Mabsadd L
.67333 .00644 -0.91448 -0.29713 Mabsadd L
.67333 .00644 -1.46946 -2.02254 Mabsadd L
.67333 .00644 0 -0.96154 Mabsadd L
.67333 .00644 1.46946 -2.02254 Mabsadd L
.67333 .00644 .91448 -0.29713 Mabsadd L
.67333 .00644 2.37764 .77254 Mabsadd L
.67333 .00644 .56518 .7779 Mabsadd L
.67333 .00644 0 2.5 Mabsadd L closepath F
.67667 .00644 0 2.5 Mabsadd m
.67667 .00644 -0.56518 .7779 Mabsadd L
.67667 .00644 -2.37764 .77254 Mabsadd L
.67667 .00644 -0.91448 -0.29713 Mabsadd L
.67667 .00644 -1.46946 -2.02254 Mabsadd L
.67667 .00644 0 -0.96154 Mabsadd L
.67667 .00644 1.46946 -2.02254 Mabsadd L
.67667 .00644 .91448 -0.29713 Mabsadd L
.67667 .00644 2.37764 .77254 Mabsadd L
.67667 .00644 .56518 .7779 Mabsadd L
.67667 .00644 0 2.5 Mabsadd L closepath F
.68 .00644 0 2.5 Mabsadd m
.68 .00644 -0.56518 .7779 Mabsadd L
.68 .00644 -2.37764 .77254 Mabsadd L
.68 .00644 -0.91448 -0.29713 Mabsadd L
.68 .00644 -1.46946 -2.02254 Mabsadd L
.68 .00644 0 -0.96154 Mabsadd L
.68 .00644 1.46946 -2.02254 Mabsadd L
.68 .00644 .91448 -0.29713 Mabsadd L
.68 .00644 2.37764 .77254 Mabsadd L
.68 .00644 .56518 .7779 Mabsadd L
.68 .00644 0 2.5 Mabsadd L closepath F
.68333 .00644 0 2.5 Mabsadd m
.68333 .00644 -0.56518 .7779 Mabsadd L
.68333 .00644 -2.37764 .77254 Mabsadd L
.68333 .00644 -0.91448 -0.29713 Mabsadd L
.68333 .00644 -1.46946 -2.02254 Mabsadd L
.68333 .00644 0 -0.96154 Mabsadd L
.68333 .00644 1.46946 -2.02254 Mabsadd L
.68333 .00644 .91448 -0.29713 Mabsadd L
.68333 .00644 2.37764 .77254 Mabsadd L
.68333 .00644 .56518 .7779 Mabsadd L
.68333 .00644 0 2.5 Mabsadd L closepath F
.68667 .00644 0 2.5 Mabsadd m
.68667 .00644 -0.56518 .7779 Mabsadd L
.68667 .00644 -2.37764 .77254 Mabsadd L
.68667 .00644 -0.91448 -0.29713 Mabsadd L
.68667 .00644 -1.46946 -2.02254 Mabsadd L
.68667 .00644 0 -0.96154 Mabsadd L
.68667 .00644 1.46946 -2.02254 Mabsadd L
.68667 .00644 .91448 -0.29713 Mabsadd L
.68667 .00644 2.37764 .77254 Mabsadd L
.68667 .00644 .56518 .7779 Mabsadd L
.68667 .00644 0 2.5 Mabsadd L closepath F
.69 .00644 0 2.5 Mabsadd m
.69 .00644 -0.56518 .7779 Mabsadd L
.69 .00644 -2.37764 .77254 Mabsadd L
.69 .00644 -0.91448 -0.29713 Mabsadd L
.69 .00644 -1.46946 -2.02254 Mabsadd L
.69 .00644 0 -0.96154 Mabsadd L
.69 .00644 1.46946 -2.02254 Mabsadd L
.69 .00644 .91448 -0.29713 Mabsadd L
.69 .00644 2.37764 .77254 Mabsadd L
.69 .00644 .56518 .7779 Mabsadd L
.69 .00644 0 2.5 Mabsadd L closepath F
.69333 .00644 0 2.5 Mabsadd m
.69333 .00644 -0.56518 .7779 Mabsadd L
.69333 .00644 -2.37764 .77254 Mabsadd L
.69333 .00644 -0.91448 -0.29713 Mabsadd L
.69333 .00644 -1.46946 -2.02254 Mabsadd L
.69333 .00644 0 -0.96154 Mabsadd L
.69333 .00644 1.46946 -2.02254 Mabsadd L
.69333 .00644 .91448 -0.29713 Mabsadd L
.69333 .00644 2.37764 .77254 Mabsadd L
.69333 .00644 .56518 .7779 Mabsadd L
.69333 .00644 0 2.5 Mabsadd L closepath F
.69667 .00644 0 2.5 Mabsadd m
.69667 .00644 -0.56518 .7779 Mabsadd L
.69667 .00644 -2.37764 .77254 Mabsadd L
.69667 .00644 -0.91448 -0.29713 Mabsadd L
.69667 .00644 -1.46946 -2.02254 Mabsadd L
.69667 .00644 0 -0.96154 Mabsadd L
.69667 .00644 1.46946 -2.02254 Mabsadd L
.69667 .00644 .91448 -0.29713 Mabsadd L
.69667 .00644 2.37764 .77254 Mabsadd L
.69667 .00644 .56518 .7779 Mabsadd L
.69667 .00644 0 2.5 Mabsadd L closepath F
.7 .00644 0 2.5 Mabsadd m
.7 .00644 -0.56518 .7779 Mabsadd L
.7 .00644 -2.37764 .77254 Mabsadd L
.7 .00644 -0.91448 -0.29713 Mabsadd L
.7 .00644 -1.46946 -2.02254 Mabsadd L
.7 .00644 0 -0.96154 Mabsadd L
.7 .00644 1.46946 -2.02254 Mabsadd L
.7 .00644 .91448 -0.29713 Mabsadd L
.7 .00644 2.37764 .77254 Mabsadd L
.7 .00644 .56518 .7779 Mabsadd L
.7 .00644 0 2.5 Mabsadd L closepath F
.70333 .00644 0 2.5 Mabsadd m
.70333 .00644 -0.56518 .7779 Mabsadd L
.70333 .00644 -2.37764 .77254 Mabsadd L
.70333 .00644 -0.91448 -0.29713 Mabsadd L
.70333 .00644 -1.46946 -2.02254 Mabsadd L
.70333 .00644 0 -0.96154 Mabsadd L
.70333 .00644 1.46946 -2.02254 Mabsadd L
.70333 .00644 .91448 -0.29713 Mabsadd L
.70333 .00644 2.37764 .77254 Mabsadd L
.70333 .00644 .56518 .7779 Mabsadd L
.70333 .00644 0 2.5 Mabsadd L closepath F
.70667 .00644 0 2.5 Mabsadd m
.70667 .00644 -0.56518 .7779 Mabsadd L
.70667 .00644 -2.37764 .77254 Mabsadd L
.70667 .00644 -0.91448 -0.29713 Mabsadd L
.70667 .00644 -1.46946 -2.02254 Mabsadd L
.70667 .00644 0 -0.96154 Mabsadd L
.70667 .00644 1.46946 -2.02254 Mabsadd L
.70667 .00644 .91448 -0.29713 Mabsadd L
.70667 .00644 2.37764 .77254 Mabsadd L
.70667 .00644 .56518 .7779 Mabsadd L
.70667 .00644 0 2.5 Mabsadd L closepath F
.71 .00644 0 2.5 Mabsadd m
.71 .00644 -0.56518 .7779 Mabsadd L
.71 .00644 -2.37764 .77254 Mabsadd L
.71 .00644 -0.91448 -0.29713 Mabsadd L
.71 .00644 -1.46946 -2.02254 Mabsadd L
.71 .00644 0 -0.96154 Mabsadd L
.71 .00644 1.46946 -2.02254 Mabsadd L
.71 .00644 .91448 -0.29713 Mabsadd L
.71 .00644 2.37764 .77254 Mabsadd L
.71 .00644 .56518 .7779 Mabsadd L
.71 .00644 0 2.5 Mabsadd L closepath F
.71333 .00644 0 2.5 Mabsadd m
.71333 .00644 -0.56518 .7779 Mabsadd L
.71333 .00644 -2.37764 .77254 Mabsadd L
.71333 .00644 -0.91448 -0.29713 Mabsadd L
.71333 .00644 -1.46946 -2.02254 Mabsadd L
.71333 .00644 0 -0.96154 Mabsadd L
.71333 .00644 1.46946 -2.02254 Mabsadd L
.71333 .00644 .91448 -0.29713 Mabsadd L
.71333 .00644 2.37764 .77254 Mabsadd L
.71333 .00644 .56518 .7779 Mabsadd L
.71333 .00644 0 2.5 Mabsadd L closepath F
.71667 .00644 0 2.5 Mabsadd m
.71667 .00644 -0.56518 .7779 Mabsadd L
.71667 .00644 -2.37764 .77254 Mabsadd L
.71667 .00644 -0.91448 -0.29713 Mabsadd L
.71667 .00644 -1.46946 -2.02254 Mabsadd L
.71667 .00644 0 -0.96154 Mabsadd L
.71667 .00644 1.46946 -2.02254 Mabsadd L
.71667 .00644 .91448 -0.29713 Mabsadd L
.71667 .00644 2.37764 .77254 Mabsadd L
.71667 .00644 .56518 .7779 Mabsadd L
.71667 .00644 0 2.5 Mabsadd L closepath F
.72 .00644 0 2.5 Mabsadd m
.72 .00644 -0.56518 .7779 Mabsadd L
.72 .00644 -2.37764 .77254 Mabsadd L
.72 .00644 -0.91448 -0.29713 Mabsadd L
.72 .00644 -1.46946 -2.02254 Mabsadd L
.72 .00644 0 -0.96154 Mabsadd L
.72 .00644 1.46946 -2.02254 Mabsadd L
.72 .00644 .91448 -0.29713 Mabsadd L
.72 .00644 2.37764 .77254 Mabsadd L
.72 .00644 .56518 .7779 Mabsadd L
.72 .00644 0 2.5 Mabsadd L closepath F
.72333 .00644 0 2.5 Mabsadd m
.72333 .00644 -0.56518 .7779 Mabsadd L
.72333 .00644 -2.37764 .77254 Mabsadd L
.72333 .00644 -0.91448 -0.29713 Mabsadd L
.72333 .00644 -1.46946 -2.02254 Mabsadd L
.72333 .00644 0 -0.96154 Mabsadd L
.72333 .00644 1.46946 -2.02254 Mabsadd L
.72333 .00644 .91448 -0.29713 Mabsadd L
.72333 .00644 2.37764 .77254 Mabsadd L
.72333 .00644 .56518 .7779 Mabsadd L
.72333 .00644 0 2.5 Mabsadd L closepath F
.72667 .00644 0 2.5 Mabsadd m
.72667 .00644 -0.56518 .7779 Mabsadd L
.72667 .00644 -2.37764 .77254 Mabsadd L
.72667 .00644 -0.91448 -0.29713 Mabsadd L
.72667 .00644 -1.46946 -2.02254 Mabsadd L
.72667 .00644 0 -0.96154 Mabsadd L
.72667 .00644 1.46946 -2.02254 Mabsadd L
.72667 .00644 .91448 -0.29713 Mabsadd L
.72667 .00644 2.37764 .77254 Mabsadd L
.72667 .00644 .56518 .7779 Mabsadd L
.72667 .00644 0 2.5 Mabsadd L closepath F
.73 .00644 0 2.5 Mabsadd m
.73 .00644 -0.56518 .7779 Mabsadd L
.73 .00644 -2.37764 .77254 Mabsadd L
.73 .00644 -0.91448 -0.29713 Mabsadd L
.73 .00644 -1.46946 -2.02254 Mabsadd L
.73 .00644 0 -0.96154 Mabsadd L
.73 .00644 1.46946 -2.02254 Mabsadd L
.73 .00644 .91448 -0.29713 Mabsadd L
.73 .00644 2.37764 .77254 Mabsadd L
.73 .00644 .56518 .7779 Mabsadd L
.73 .00644 0 2.5 Mabsadd L closepath F
.73333 .00644 0 2.5 Mabsadd m
.73333 .00644 -0.56518 .7779 Mabsadd L
.73333 .00644 -2.37764 .77254 Mabsadd L
.73333 .00644 -0.91448 -0.29713 Mabsadd L
.73333 .00644 -1.46946 -2.02254 Mabsadd L
.73333 .00644 0 -0.96154 Mabsadd L
.73333 .00644 1.46946 -2.02254 Mabsadd L
.73333 .00644 .91448 -0.29713 Mabsadd L
.73333 .00644 2.37764 .77254 Mabsadd L
.73333 .00644 .56518 .7779 Mabsadd L
.73333 .00644 0 2.5 Mabsadd L closepath F
.73667 .00644 0 2.5 Mabsadd m
.73667 .00644 -0.56518 .7779 Mabsadd L
.73667 .00644 -2.37764 .77254 Mabsadd L
.73667 .00644 -0.91448 -0.29713 Mabsadd L
.73667 .00644 -1.46946 -2.02254 Mabsadd L
.73667 .00644 0 -0.96154 Mabsadd L
.73667 .00644 1.46946 -2.02254 Mabsadd L
.73667 .00644 .91448 -0.29713 Mabsadd L
.73667 .00644 2.37764 .77254 Mabsadd L
.73667 .00644 .56518 .7779 Mabsadd L
.73667 .00644 0 2.5 Mabsadd L closepath F
.74 .00644 0 2.5 Mabsadd m
.74 .00644 -0.56518 .7779 Mabsadd L
.74 .00644 -2.37764 .77254 Mabsadd L
.74 .00644 -0.91448 -0.29713 Mabsadd L
.74 .00644 -1.46946 -2.02254 Mabsadd L
.74 .00644 0 -0.96154 Mabsadd L
.74 .00644 1.46946 -2.02254 Mabsadd L
.74 .00644 .91448 -0.29713 Mabsadd L
.74 .00644 2.37764 .77254 Mabsadd L
.74 .00644 .56518 .7779 Mabsadd L
.74 .00644 0 2.5 Mabsadd L closepath F
.74333 .00644 0 2.5 Mabsadd m
.74333 .00644 -0.56518 .7779 Mabsadd L
.74333 .00644 -2.37764 .77254 Mabsadd L
.74333 .00644 -0.91448 -0.29713 Mabsadd L
.74333 .00644 -1.46946 -2.02254 Mabsadd L
.74333 .00644 0 -0.96154 Mabsadd L
.74333 .00644 1.46946 -2.02254 Mabsadd L
.74333 .00644 .91448 -0.29713 Mabsadd L
.74333 .00644 2.37764 .77254 Mabsadd L
.74333 .00644 .56518 .7779 Mabsadd L
.74333 .00644 0 2.5 Mabsadd L closepath F
.74667 .00644 0 2.5 Mabsadd m
.74667 .00644 -0.56518 .7779 Mabsadd L
.74667 .00644 -2.37764 .77254 Mabsadd L
.74667 .00644 -0.91448 -0.29713 Mabsadd L
.74667 .00644 -1.46946 -2.02254 Mabsadd L
.74667 .00644 0 -0.96154 Mabsadd L
.74667 .00644 1.46946 -2.02254 Mabsadd L
.74667 .00644 .91448 -0.29713 Mabsadd L
.74667 .00644 2.37764 .77254 Mabsadd L
.74667 .00644 .56518 .7779 Mabsadd L
.74667 .00644 0 2.5 Mabsadd L closepath F
.75 .00644 0 2.5 Mabsadd m
.75 .00644 -0.56518 .7779 Mabsadd L
.75 .00644 -2.37764 .77254 Mabsadd L
.75 .00644 -0.91448 -0.29713 Mabsadd L
.75 .00644 -1.46946 -2.02254 Mabsadd L
.75 .00644 0 -0.96154 Mabsadd L
.75 .00644 1.46946 -2.02254 Mabsadd L
.75 .00644 .91448 -0.29713 Mabsadd L
.75 .00644 2.37764 .77254 Mabsadd L
.75 .00644 .56518 .7779 Mabsadd L
.75 .00644 0 2.5 Mabsadd L closepath F
.75333 .00644 0 2.5 Mabsadd m
.75333 .00644 -0.56518 .7779 Mabsadd L
.75333 .00644 -2.37764 .77254 Mabsadd L
.75333 .00644 -0.91448 -0.29713 Mabsadd L
.75333 .00644 -1.46946 -2.02254 Mabsadd L
.75333 .00644 0 -0.96154 Mabsadd L
.75333 .00644 1.46946 -2.02254 Mabsadd L
.75333 .00644 .91448 -0.29713 Mabsadd L
.75333 .00644 2.37764 .77254 Mabsadd L
.75333 .00644 .56518 .7779 Mabsadd L
.75333 .00644 0 2.5 Mabsadd L closepath F
.75667 .00644 0 2.5 Mabsadd m
.75667 .00644 -0.56518 .7779 Mabsadd L
.75667 .00644 -2.37764 .77254 Mabsadd L
.75667 .00644 -0.91448 -0.29713 Mabsadd L
.75667 .00644 -1.46946 -2.02254 Mabsadd L
.75667 .00644 0 -0.96154 Mabsadd L
.75667 .00644 1.46946 -2.02254 Mabsadd L
.75667 .00644 .91448 -0.29713 Mabsadd L
.75667 .00644 2.37764 .77254 Mabsadd L
.75667 .00644 .56518 .7779 Mabsadd L
.75667 .00644 0 2.5 Mabsadd L closepath F
.76 .00644 0 2.5 Mabsadd m
.76 .00644 -0.56518 .7779 Mabsadd L
.76 .00644 -2.37764 .77254 Mabsadd L
.76 .00644 -0.91448 -0.29713 Mabsadd L
.76 .00644 -1.46946 -2.02254 Mabsadd L
.76 .00644 0 -0.96154 Mabsadd L
.76 .00644 1.46946 -2.02254 Mabsadd L
.76 .00644 .91448 -0.29713 Mabsadd L
.76 .00644 2.37764 .77254 Mabsadd L
.76 .00644 .56518 .7779 Mabsadd L
.76 .00644 0 2.5 Mabsadd L closepath F
.76333 .00644 0 2.5 Mabsadd m
.76333 .00644 -0.56518 .7779 Mabsadd L
.76333 .00644 -2.37764 .77254 Mabsadd L
.76333 .00644 -0.91448 -0.29713 Mabsadd L
.76333 .00644 -1.46946 -2.02254 Mabsadd L
.76333 .00644 0 -0.96154 Mabsadd L
.76333 .00644 1.46946 -2.02254 Mabsadd L
.76333 .00644 .91448 -0.29713 Mabsadd L
.76333 .00644 2.37764 .77254 Mabsadd L
.76333 .00644 .56518 .7779 Mabsadd L
.76333 .00644 0 2.5 Mabsadd L closepath F
.76667 .00644 0 2.5 Mabsadd m
.76667 .00644 -0.56518 .7779 Mabsadd L
.76667 .00644 -2.37764 .77254 Mabsadd L
.76667 .00644 -0.91448 -0.29713 Mabsadd L
.76667 .00644 -1.46946 -2.02254 Mabsadd L
.76667 .00644 0 -0.96154 Mabsadd L
.76667 .00644 1.46946 -2.02254 Mabsadd L
.76667 .00644 .91448 -0.29713 Mabsadd L
.76667 .00644 2.37764 .77254 Mabsadd L
.76667 .00644 .56518 .7779 Mabsadd L
.76667 .00644 0 2.5 Mabsadd L closepath F
.77 .00644 0 2.5 Mabsadd m
.77 .00644 -0.56518 .7779 Mabsadd L
.77 .00644 -2.37764 .77254 Mabsadd L
.77 .00644 -0.91448 -0.29713 Mabsadd L
.77 .00644 -1.46946 -2.02254 Mabsadd L
.77 .00644 0 -0.96154 Mabsadd L
.77 .00644 1.46946 -2.02254 Mabsadd L
.77 .00644 .91448 -0.29713 Mabsadd L
.77 .00644 2.37764 .77254 Mabsadd L
.77 .00644 .56518 .7779 Mabsadd L
.77 .00644 0 2.5 Mabsadd L closepath F
.77333 .00644 0 2.5 Mabsadd m
.77333 .00644 -0.56518 .7779 Mabsadd L
.77333 .00644 -2.37764 .77254 Mabsadd L
.77333 .00644 -0.91448 -0.29713 Mabsadd L
.77333 .00644 -1.46946 -2.02254 Mabsadd L
.77333 .00644 0 -0.96154 Mabsadd L
.77333 .00644 1.46946 -2.02254 Mabsadd L
.77333 .00644 .91448 -0.29713 Mabsadd L
.77333 .00644 2.37764 .77254 Mabsadd L
.77333 .00644 .56518 .7779 Mabsadd L
.77333 .00644 0 2.5 Mabsadd L closepath F
.77667 .00644 0 2.5 Mabsadd m
.77667 .00644 -0.56518 .7779 Mabsadd L
.77667 .00644 -2.37764 .77254 Mabsadd L
.77667 .00644 -0.91448 -0.29713 Mabsadd L
.77667 .00644 -1.46946 -2.02254 Mabsadd L
.77667 .00644 0 -0.96154 Mabsadd L
.77667 .00644 1.46946 -2.02254 Mabsadd L
.77667 .00644 .91448 -0.29713 Mabsadd L
.77667 .00644 2.37764 .77254 Mabsadd L
.77667 .00644 .56518 .7779 Mabsadd L
.77667 .00644 0 2.5 Mabsadd L closepath F
.78 .00644 0 2.5 Mabsadd m
.78 .00644 -0.56518 .7779 Mabsadd L
.78 .00644 -2.37764 .77254 Mabsadd L
.78 .00644 -0.91448 -0.29713 Mabsadd L
.78 .00644 -1.46946 -2.02254 Mabsadd L
.78 .00644 0 -0.96154 Mabsadd L
.78 .00644 1.46946 -2.02254 Mabsadd L
.78 .00644 .91448 -0.29713 Mabsadd L
.78 .00644 2.37764 .77254 Mabsadd L
.78 .00644 .56518 .7779 Mabsadd L
.78 .00644 0 2.5 Mabsadd L closepath F
.78333 .00644 0 2.5 Mabsadd m
.78333 .00644 -0.56518 .7779 Mabsadd L
.78333 .00644 -2.37764 .77254 Mabsadd L
.78333 .00644 -0.91448 -0.29713 Mabsadd L
.78333 .00644 -1.46946 -2.02254 Mabsadd L
.78333 .00644 0 -0.96154 Mabsadd L
.78333 .00644 1.46946 -2.02254 Mabsadd L
.78333 .00644 .91448 -0.29713 Mabsadd L
.78333 .00644 2.37764 .77254 Mabsadd L
.78333 .00644 .56518 .7779 Mabsadd L
.78333 .00644 0 2.5 Mabsadd L closepath F
.78667 .00644 0 2.5 Mabsadd m
.78667 .00644 -0.56518 .7779 Mabsadd L
.78667 .00644 -2.37764 .77254 Mabsadd L
.78667 .00644 -0.91448 -0.29713 Mabsadd L
.78667 .00644 -1.46946 -2.02254 Mabsadd L
.78667 .00644 0 -0.96154 Mabsadd L
.78667 .00644 1.46946 -2.02254 Mabsadd L
.78667 .00644 .91448 -0.29713 Mabsadd L
.78667 .00644 2.37764 .77254 Mabsadd L
.78667 .00644 .56518 .7779 Mabsadd L
.78667 .00644 0 2.5 Mabsadd L closepath F
.79 .00644 0 2.5 Mabsadd m
.79 .00644 -0.56518 .7779 Mabsadd L
.79 .00644 -2.37764 .77254 Mabsadd L
.79 .00644 -0.91448 -0.29713 Mabsadd L
.79 .00644 -1.46946 -2.02254 Mabsadd L
.79 .00644 0 -0.96154 Mabsadd L
.79 .00644 1.46946 -2.02254 Mabsadd L
.79 .00644 .91448 -0.29713 Mabsadd L
.79 .00644 2.37764 .77254 Mabsadd L
.79 .00644 .56518 .7779 Mabsadd L
.79 .00644 0 2.5 Mabsadd L closepath F
.79333 .00644 0 2.5 Mabsadd m
.79333 .00644 -0.56518 .7779 Mabsadd L
.79333 .00644 -2.37764 .77254 Mabsadd L
.79333 .00644 -0.91448 -0.29713 Mabsadd L
.79333 .00644 -1.46946 -2.02254 Mabsadd L
.79333 .00644 0 -0.96154 Mabsadd L
.79333 .00644 1.46946 -2.02254 Mabsadd L
.79333 .00644 .91448 -0.29713 Mabsadd L
.79333 .00644 2.37764 .77254 Mabsadd L
.79333 .00644 .56518 .7779 Mabsadd L
.79333 .00644 0 2.5 Mabsadd L closepath F
.79667 .00644 0 2.5 Mabsadd m
.79667 .00644 -0.56518 .7779 Mabsadd L
.79667 .00644 -2.37764 .77254 Mabsadd L
.79667 .00644 -0.91448 -0.29713 Mabsadd L
.79667 .00644 -1.46946 -2.02254 Mabsadd L
.79667 .00644 0 -0.96154 Mabsadd L
.79667 .00644 1.46946 -2.02254 Mabsadd L
.79667 .00644 .91448 -0.29713 Mabsadd L
.79667 .00644 2.37764 .77254 Mabsadd L
.79667 .00644 .56518 .7779 Mabsadd L
.79667 .00644 0 2.5 Mabsadd L closepath F
.8 .00644 0 2.5 Mabsadd m
.8 .00644 -0.56518 .7779 Mabsadd L
.8 .00644 -2.37764 .77254 Mabsadd L
.8 .00644 -0.91448 -0.29713 Mabsadd L
.8 .00644 -1.46946 -2.02254 Mabsadd L
.8 .00644 0 -0.96154 Mabsadd L
.8 .00644 1.46946 -2.02254 Mabsadd L
.8 .00644 .91448 -0.29713 Mabsadd L
.8 .00644 2.37764 .77254 Mabsadd L
.8 .00644 .56518 .7779 Mabsadd L
.8 .00644 0 2.5 Mabsadd L closepath F
.80333 .00644 0 2.5 Mabsadd m
.80333 .00644 -0.56518 .7779 Mabsadd L
.80333 .00644 -2.37764 .77254 Mabsadd L
.80333 .00644 -0.91448 -0.29713 Mabsadd L
.80333 .00644 -1.46946 -2.02254 Mabsadd L
.80333 .00644 0 -0.96154 Mabsadd L
.80333 .00644 1.46946 -2.02254 Mabsadd L
.80333 .00644 .91448 -0.29713 Mabsadd L
.80333 .00644 2.37764 .77254 Mabsadd L
.80333 .00644 .56518 .7779 Mabsadd L
.80333 .00644 0 2.5 Mabsadd L closepath F
.80667 .00644 0 2.5 Mabsadd m
.80667 .00644 -0.56518 .7779 Mabsadd L
.80667 .00644 -2.37764 .77254 Mabsadd L
.80667 .00644 -0.91448 -0.29713 Mabsadd L
.80667 .00644 -1.46946 -2.02254 Mabsadd L
.80667 .00644 0 -0.96154 Mabsadd L
.80667 .00644 1.46946 -2.02254 Mabsadd L
.80667 .00644 .91448 -0.29713 Mabsadd L
.80667 .00644 2.37764 .77254 Mabsadd L
.80667 .00644 .56518 .7779 Mabsadd L
.80667 .00644 0 2.5 Mabsadd L closepath F
.81 .00644 0 2.5 Mabsadd m
.81 .00644 -0.56518 .7779 Mabsadd L
.81 .00644 -2.37764 .77254 Mabsadd L
.81 .00644 -0.91448 -0.29713 Mabsadd L
.81 .00644 -1.46946 -2.02254 Mabsadd L
.81 .00644 0 -0.96154 Mabsadd L
.81 .00644 1.46946 -2.02254 Mabsadd L
.81 .00644 .91448 -0.29713 Mabsadd L
.81 .00644 2.37764 .77254 Mabsadd L
.81 .00644 .56518 .7779 Mabsadd L
.81 .00644 0 2.5 Mabsadd L closepath F
.81333 .00644 0 2.5 Mabsadd m
.81333 .00644 -0.56518 .7779 Mabsadd L
.81333 .00644 -2.37764 .77254 Mabsadd L
.81333 .00644 -0.91448 -0.29713 Mabsadd L
.81333 .00644 -1.46946 -2.02254 Mabsadd L
.81333 .00644 0 -0.96154 Mabsadd L
.81333 .00644 1.46946 -2.02254 Mabsadd L
.81333 .00644 .91448 -0.29713 Mabsadd L
.81333 .00644 2.37764 .77254 Mabsadd L
.81333 .00644 .56518 .7779 Mabsadd L
.81333 .00644 0 2.5 Mabsadd L closepath F
.81667 .00644 0 2.5 Mabsadd m
.81667 .00644 -0.56518 .7779 Mabsadd L
.81667 .00644 -2.37764 .77254 Mabsadd L
.81667 .00644 -0.91448 -0.29713 Mabsadd L
.81667 .00644 -1.46946 -2.02254 Mabsadd L
.81667 .00644 0 -0.96154 Mabsadd L
.81667 .00644 1.46946 -2.02254 Mabsadd L
.81667 .00644 .91448 -0.29713 Mabsadd L
.81667 .00644 2.37764 .77254 Mabsadd L
.81667 .00644 .56518 .7779 Mabsadd L
.81667 .00644 0 2.5 Mabsadd L closepath F
.82 .00644 0 2.5 Mabsadd m
.82 .00644 -0.56518 .7779 Mabsadd L
.82 .00644 -2.37764 .77254 Mabsadd L
.82 .00644 -0.91448 -0.29713 Mabsadd L
.82 .00644 -1.46946 -2.02254 Mabsadd L
.82 .00644 0 -0.96154 Mabsadd L
.82 .00644 1.46946 -2.02254 Mabsadd L
.82 .00644 .91448 -0.29713 Mabsadd L
.82 .00644 2.37764 .77254 Mabsadd L
.82 .00644 .56518 .7779 Mabsadd L
.82 .00644 0 2.5 Mabsadd L closepath F
.82333 .00644 0 2.5 Mabsadd m
.82333 .00644 -0.56518 .7779 Mabsadd L
.82333 .00644 -2.37764 .77254 Mabsadd L
.82333 .00644 -0.91448 -0.29713 Mabsadd L
.82333 .00644 -1.46946 -2.02254 Mabsadd L
.82333 .00644 0 -0.96154 Mabsadd L
.82333 .00644 1.46946 -2.02254 Mabsadd L
.82333 .00644 .91448 -0.29713 Mabsadd L
.82333 .00644 2.37764 .77254 Mabsadd L
.82333 .00644 .56518 .7779 Mabsadd L
.82333 .00644 0 2.5 Mabsadd L closepath F
.82667 .00644 0 2.5 Mabsadd m
.82667 .00644 -0.56518 .7779 Mabsadd L
.82667 .00644 -2.37764 .77254 Mabsadd L
.82667 .00644 -0.91448 -0.29713 Mabsadd L
.82667 .00644 -1.46946 -2.02254 Mabsadd L
.82667 .00644 0 -0.96154 Mabsadd L
.82667 .00644 1.46946 -2.02254 Mabsadd L
.82667 .00644 .91448 -0.29713 Mabsadd L
.82667 .00644 2.37764 .77254 Mabsadd L
.82667 .00644 .56518 .7779 Mabsadd L
.82667 .00644 0 2.5 Mabsadd L closepath F
.83 .00647 0 2.5 Mabsadd m
.83 .00647 -0.56518 .7779 Mabsadd L
.83 .00647 -2.37764 .77254 Mabsadd L
.83 .00647 -0.91448 -0.29713 Mabsadd L
.83 .00647 -1.46946 -2.02254 Mabsadd L
.83 .00647 0 -0.96154 Mabsadd L
.83 .00647 1.46946 -2.02254 Mabsadd L
.83 .00647 .91448 -0.29713 Mabsadd L
.83 .00647 2.37764 .77254 Mabsadd L
.83 .00647 .56518 .7779 Mabsadd L
.83 .00647 0 2.5 Mabsadd L closepath F
.83333 .00679 0 2.5 Mabsadd m
.83333 .00679 -0.56518 .7779 Mabsadd L
.83333 .00679 -2.37764 .77254 Mabsadd L
.83333 .00679 -0.91448 -0.29713 Mabsadd L
.83333 .00679 -1.46946 -2.02254 Mabsadd L
.83333 .00679 0 -0.96154 Mabsadd L
.83333 .00679 1.46946 -2.02254 Mabsadd L
.83333 .00679 .91448 -0.29713 Mabsadd L
.83333 .00679 2.37764 .77254 Mabsadd L
.83333 .00679 .56518 .7779 Mabsadd L
.83333 .00679 0 2.5 Mabsadd L closepath F
.83667 .00951 0 2.5 Mabsadd m
.83667 .00951 -0.56518 .7779 Mabsadd L
.83667 .00951 -2.37764 .77254 Mabsadd L
.83667 .00951 -0.91448 -0.29713 Mabsadd L
.83667 .00951 -1.46946 -2.02254 Mabsadd L
.83667 .00951 0 -0.96154 Mabsadd L
.83667 .00951 1.46946 -2.02254 Mabsadd L
.83667 .00951 .91448 -0.29713 Mabsadd L
.83667 .00951 2.37764 .77254 Mabsadd L
.83667 .00951 .56518 .7779 Mabsadd L
.83667 .00951 0 2.5 Mabsadd L closepath F
.84 .02436 0 2.5 Mabsadd m
.84 .02436 -0.56518 .7779 Mabsadd L
.84 .02436 -2.37764 .77254 Mabsadd L
.84 .02436 -0.91448 -0.29713 Mabsadd L
.84 .02436 -1.46946 -2.02254 Mabsadd L
.84 .02436 0 -0.96154 Mabsadd L
.84 .02436 1.46946 -2.02254 Mabsadd L
.84 .02436 .91448 -0.29713 Mabsadd L
.84 .02436 2.37764 .77254 Mabsadd L
.84 .02436 .56518 .7779 Mabsadd L
.84 .02436 0 2.5 Mabsadd L closepath F
.84333 .07705 0 2.5 Mabsadd m
.84333 .07705 -0.56518 .7779 Mabsadd L
.84333 .07705 -2.37764 .77254 Mabsadd L
.84333 .07705 -0.91448 -0.29713 Mabsadd L
.84333 .07705 -1.46946 -2.02254 Mabsadd L
.84333 .07705 0 -0.96154 Mabsadd L
.84333 .07705 1.46946 -2.02254 Mabsadd L
.84333 .07705 .91448 -0.29713 Mabsadd L
.84333 .07705 2.37764 .77254 Mabsadd L
.84333 .07705 .56518 .7779 Mabsadd L
.84333 .07705 0 2.5 Mabsadd L closepath F
.84667 .19443 0 2.5 Mabsadd m
.84667 .19443 -0.56518 .7779 Mabsadd L
.84667 .19443 -2.37764 .77254 Mabsadd L
.84667 .19443 -0.91448 -0.29713 Mabsadd L
.84667 .19443 -1.46946 -2.02254 Mabsadd L
.84667 .19443 0 -0.96154 Mabsadd L
.84667 .19443 1.46946 -2.02254 Mabsadd L
.84667 .19443 .91448 -0.29713 Mabsadd L
.84667 .19443 2.37764 .77254 Mabsadd L
.84667 .19443 .56518 .7779 Mabsadd L
.84667 .19443 0 2.5 Mabsadd L closepath F
.85 .34475 0 2.5 Mabsadd m
.85 .34475 -0.56518 .7779 Mabsadd L
.85 .34475 -2.37764 .77254 Mabsadd L
.85 .34475 -0.91448 -0.29713 Mabsadd L
.85 .34475 -1.46946 -2.02254 Mabsadd L
.85 .34475 0 -0.96154 Mabsadd L
.85 .34475 1.46946 -2.02254 Mabsadd L
.85 .34475 .91448 -0.29713 Mabsadd L
.85 .34475 2.37764 .77254 Mabsadd L
.85 .34475 .56518 .7779 Mabsadd L
.85 .34475 0 2.5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .38707 L
.97619 .38707 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .40321 L
.96005 .40321 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .40321 L
.70178 .40321 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.403208 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
0 1 1 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 12.813 moveto
(D) show
99.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 0 r
.05357 .39881 m
.05357 .69643 L
.35119 .69643 L
.35119 .39881 L
F
0 g
gsave
.38988 .54762 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 12.813 moveto
(D) show
99.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00<03oool2000000@0oooo0P00000=0?ooo`D000000P3oool2000000@0oooo0P00000:0?oo
o`D000000P3oool2000000@0oooo0P00000:0?ooo`@000000`3oool2000000@0oooo0P00000:0?oo
o`@000000`3oool2000000@0oooo0P00000<0?ooo`800000103oool2000000@0oooo0P00001W0?oo
o`00;`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000h0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
2@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`00000:0?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`00001V0?ooo`00<P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo00`0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?oo
o`050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool02P3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1T0?oo
o`00<03oool2000000<0oooo00@000000?ooo`3oool000003P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0080oooo0P0000030?ooo`040000003oool0oooo000000/0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`020?ooo`8000000`3oool010000000oooo0?ooo`00000=0?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1T0?ooo`00<03o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000h0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000002@3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00002@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000002P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool00000IP3oool00300oooo0`0000030?ooo`8000003P3oool2000000@0oooo
0P0000040?ooo`8000002`3oool2000000@0oooo0`0000030?ooo`8000002`3oool2000000@0oooo
0P0000040?ooo`8000002`3oool2000000@0oooo0`0000030?ooo`800000303oool2000000@0oooo
0P0000040?ooo`800000I`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00;T0
oooo0`00001T0?ooo`006`3ooonH000000L0oooo00<000000?ooo`3oool0H`3oool001/0ooooO`00
00040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`1S0?ooo`006`3ooon0000001h0oooo0P00001U0?ooo`006`3ooon0000008D0oooo000K0?ooo`@0
0000N@3oool200000200oooo00<000000?ooo`3oool0H`3oool001/0oooo1000001h0?ooo`D00000
Q03oool001/0oooo00@000000?ooo`00ool00000N@3oool3000008D0oooo000K0?ooo`030000003o
ool00?oo07/0oooo00<00?oo0?ooo`3oool0Q03oool001/0oooo00<00000003oo`3o0000N`3oool0
0`00ool0oooo0?ooo`240?ooo`006`3oool00`0000000?oo0000001k0?ooo`0300000000ool0oooo
08@0oooo000K0?ooo`0400000000ool00000000007T0oooo0P0000000`00ool0oooo0?ooo`230?oo
o`006`3oool4000007X0oooo0P0000250?ooo`006`3oool3000007/0oooo0P0000250?ooo`006P3o
ool5000007T0oooo100000240?ooo`002@3oool2000000@0oooo0P0000040?ooo`800000103oool0
0`0000000?oo0?l0001k0?ooo`030?l00000ool0oooo08@0oooo00080?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000`3oool00`0000000?oo0?ooo`1l0?ooo`03003oo`3o
ool0oooo08<0oooo00080?ooo`040000003oool0oooo000000/0oooo00H000000?ooo`3oool0oooo
00000000oomm0?ooo`03003oo`3oool0oooo08<0oooo00080?ooo`040000003oool0oooo000000T0
oooo0P0000040?ooo`0300000000ool0oooo07`0oooo00<00?oo0?ooo`3oool0P`3oool000P0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`030?ooo`0300000000ool0oooo07/0
oooo00<00000003oo`3oool0Q03oool000T0oooo0P00000:0?ooo`<000000`3oool00`0000000?oo
0000001j0?ooo`80000000<00?oo0000003oool0P`3oool001/0oooo00<00000003oo`000000N`3o
ool00`0000000?oo000000240?ooo`006`3oool00`0000000?oo0?ooo`1l0?ooo`03003oo`3oool0
oooo08<0oooo000K0?ooo`0300000000ool0oooo07`0oooo00<00?oo0?ooo`3oool0P`3oool001/0
oooo00<00000003oo`3oool0O03oool00`00ool0oooo0?ooo`230?ooo`006`3oool00`0000000?oo
0?ooo`1l0?ooo`03003oo`3oool0oooo08<0oooo000K0?ooo`0300000000ool0oooo07`0oooo00<0
0?oo0?ooo`3oool0P`3oool001/0oooo00<00000003oo`3oool0O03oool00`00ool0oooo0?ooo`23
0?ooo`006`3oool00`0000000?oo0?ooo`1l0?ooo`03003oo`3oool0oooo08<0oooo000K0?ooo`03
00000000ool0oooo07`0oooo00<00?oo0?ooo`3oool0P`3oool001@0oooo1@0000020?ooo`800000
O@3oool00`000000oooo0?ooo`230?ooo`005P3oool010000000oooo0?ooo`3oool4000007X0oooo
1@0000230?ooo`005P3oool010000000oooo0?ooo`3oool200000003003oo`000000oooo07X0oooo
0`0000240?ooo`005P3oool00`000000oooo0?ooo`020?ooo`0300000000ool0oooo07`0oooo00<0
0?oo0?ooo`3oool0P`3oool001H0oooo00<000000?ooo`3oool00P3oool00`0000000?oo0?ooo`1l
0?ooo`03003oo`3oool0oooo08<0oooo000E0?ooo`800000103oool00`0000000?oo0?ooo`1l0?oo
o`03003oo`3oool0oooo08<0oooo000K0?ooo`0300000000ool0oooo07`0oooo00<00?oo0?ooo`3o
ool0P`3oool001/0oooo00<0o`00003oo`3oool0O03oool00`00ool0oooo0?ooo`230?ooo`006`3o
ool00`3o00000?oo0?ooo`1l0?ooo`03003oo`3o0000oooo08<0oooo000K0?ooo`030?l00000ool0
oooo07`0oooo00<00?oo0?l0003oool0P`3oool001/0oooo00<0o`00003oo`3oool0O03oool00`00
ool0o`000?ooo`230?ooo`006`3oool00`0000000?oo0?ooo`1l0?ooo`03003oo`000000oooo0300
ooooBP0000090?ooo`006P3oool00`0000000?oo0000001l0?ooo`0400000000ool0000000000300
ooooBP0000090?ooo`006`3oool00`00ool000000?ooo`1l0?ooo`0300000000ool000000300oooo
BP0000090?ooo`006`3oool00`00ool0oooo0?ooo`1m0?ooo`03003oo`3oool0oooo02l0ooooBP00
00090?ooo`006P3oool00`0000000?oo0?ooo`1n0?ooo`03003oo`3oool0oooo02/0ooooCP000009
0?ooo`00203oool500000080oooo0P0000040?ooo`8000000P3oool200000003003oo`000000oooo
07d0oooo00<00?oo0?ooo`3oool0:`3oool00`000000oooo0?ooo`160?ooo`D000002@3oool000X0
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000020?ooo`0300000000ool00000
07h0oooo00<00?oo0?ooo`3oool0:`3oool00`000000oooo0?ooo`160?ooo`D000002@3oool000X0
oooo00<000000?ooo`3oool02P3oool01P000000oooo0?ooo`3oool00?oo000007h0oooo00<00?oo
0?ooo`3oool0:`3oool00`000000oooo0?ooo`160?ooo`D000002@3oool000X0oooo00<000000?oo
o`3oool0203oool2000000@0oooo00<00?oo0?ooo`3oool0O@3oool00`00ool0oooo0?ooo`0[0?oo
o`030000003oool0oooo04H0oooo1@0000090?ooo`002P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00<0oooo00<00?oo0?ooo`3oool0O@3oool00`00ool0oooo0?ooo`0[0?ooo`04
0000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo00090?ooo`8000002P3oool3000000<0
oooo00<00?oo0?ooo`3oool0O@3oool00`00ool0oooo0?ooo`0[0?ooo`040000003oool0oooo0?oo
oaD00?oo<03oool5000000T0oooo000J0?ooo`<00000O@3oool2000002d0oooo00@000000?ooo`3o
ool0oooo5@00ool`0?ooo`D000002@3oool001X0oooo0P00001n0?ooo`800000;@3oool010000000
oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`006@3oool5000007/0oooo1000000/0?ooo`04
0000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo000K0?ooo`030000003oool0oooo07d0
oooo00<000000?ooo`3oool0:`3oool010000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?oo
o`006`3oool00`00ool0oooo0?ooo`2[0?ooo`040000003oool0oooo0?oooaD00?oo503oool20000
00h0oooo0P00000:0?ooo`D000002@3oool001/0oooo00<00?oo0?ooo`3oool0Z`3oool010000000
oooo0?ooo`3ooolE003ooa@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`080?oo
o`D000002@3oool001/0oooo00<00?oo0?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE003o
o`D0oooo0`0000020?ooo`030000003oool0oooo00<00000103oool00`000000oooo0?ooo`020?oo
o`<000000P3oool4000000<0oooo00<000000?ooo`3oool0203oool5000000T0oooo000K0?ooo`03
003oo`3oool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@00ool60?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`D000002@3oool001/0oooo00<00?oo
0?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE003oo`H0oooo0`0000030?ooo`@00000103o
ool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`080?ooo`D000002@3oool001@0oooo100000030?ooo`03003oo`3oool0oooo0:/0oooo00@0
00000?ooo`3oool0oooo5@00ool60?ooo`040000003oool0oooo000000<0oooo0P0000050?ooo`03
0000003oool0oooo0080oooo0`0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0203oool5000000T0oooo000D0?ooo`030000003oool0oooo00@0oooo00<00?oo0?ooo`3oool0
Z`3oool010000000oooo0?ooo`3ooolE003oo`H0oooo00@000000?ooo`3oool000002P3oool00`00
0000oooo0?ooo`070?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0203oool5
000000T0oooo000E0?ooo`030000003oool0oooo0080oooo0`00002/0?ooo`040000003oool0oooo
0?oooaD00?oo1@3oool4000000/0oooo0P0000090?ooo`8000000`3oool2000000X0oooo1@000009
0?ooo`005P3oool010000000oooo0?ooo`3oool200000:d0oooo00@000000?ooo`3oool0oooo5@00
ool`0?ooo`D000002@3oool001@0oooo00D000000?ooo`3oool000000?ooo`0400000:`0oooo00@0
00000?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool001D0oooo0P0000040?ooo`030000003o
ool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool001/0oooo00<0
00000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`006`3o
ool00`000000oooo0?ooo`2[0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo
000K0?ooo`030000003oool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@00ool`0?ooo`D00000
2@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE003ooc00oooo
1@0000090?ooo`006`3oool00`000000oooo0?ooo`2[0?ooo`040000003oool0oooo0?oooaD00?oo
<03oool5000000T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0AP3o
ool5000000T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0AP3oool5
000000T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool0AP3oool50000
00T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@3o000`0?oo
o`D000002@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE0?l0
0300oooo1@0000090?ooo`00203oool4000000<0oooo0P0000040?ooo`800000103oool00`000000
oooo0?ooo`2[0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00080?ooo`03
0000003oool0oooo00T0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`2[0?oo
o`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo00090?ooo`030000003oool0oooo
00/0oooo00@000000?ooo`3oool0oooo0P00002/0?ooo`040000003oool0oooo0?oooaD0o`00<03o
ool5000000T0oooo000:0?ooo`030000003oool0oooo00P0oooo0P0000040?ooo`030000003oool0
oooo0:/0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool000P0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0:/0oooo00@0
00000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool000T0oooo0P00000:0?ooo`<000000`3o
ool00`000000oooo0?ooo`2[0?ooo`040000003oool0oooo0?oooaD0o`00503oool2000000h0oooo
0P00000:0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?oo
o`3ooolE0?l001@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`080?ooo`D00000
2@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE0?l000D0oooo
0`0000020?ooo`030000003oool0oooo00<00000103oool00`000000oooo0?ooo`020?ooo`<00000
0P3oool500000080oooo00<000000?ooo`3oool0203oool5000000T0oooo000K0?ooo`030000003o
ool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@3o00060?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`080?ooo`D000002@3oool001/0oooo00<000000?ooo`3o
ool0Z`3oool010000000oooo0?ooo`3ooolE0?l000H0oooo0`0000030?ooo`@00000103oool01@00
0000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`08
0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE
0?l000H0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`3oool00P3o
ool3000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`D000002@3o
ool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?ooo`3ooolE0?l000H0oooo00@0
00000?ooo`3oool000002P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0203oool5000000T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00@0
00000?ooo`3oool0oooo5@3o00050?ooo`@000002`3oool2000000T0oooo0P0000030?ooo`800000
2P3oool5000000T0oooo000K0?ooo`030000003oool0oooo0:/0oooo00@000000?ooo`3oool0oooo
5@3o000`0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0Z`3oool010000000oooo0?oo
o`3ooolE0?l00300oooo1@0000090?ooo`005@3oool2000000@0oooo00<000000?ooo`3oool0Z`3o
ool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00503oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0:/0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D0
00002@3oool001H0oooo00<000000?ooo`3oool00P3oool200000:`0oooo00@000000?ooo`3oool0
oooo5@3o000`0?ooo`D000002@3oool001L0oooo00<000000?ooo`3oool0[`3oool010000000oooo
0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00503oool010000000oooo0?ooo`00002a0?ooo`04
0000003oool0oooo0?oooaD0o`00<03oool00`000000oooo0?ooo`0;0?ooo`005@3oool200000;80
oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0;0?ooo`00b@3oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo00/0oooo00390?ooo`030000003oool0oooo04H0oooo00<0
00000?ooo`3oool02`3oool00<T0ooooBP00000=0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-54.5075, \
-0.530127, 1.99043, 0.0322058}, {{201.063, 274.813}, {59.8125, 4.5}} -> \
{-9.26038, -2.82506, 0.0455598, 0.0455598}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.77556e-017 2.5 0 0.618034 [
[.25 -0.0125 -9 -9 ]
[.25 -0.0125 9 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.75 -0.0125 -9 -9 ]
[.75 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 34 6.28125 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.25 0 m
.25 .00625 L
s
[(0.1)] .25 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0.2)] .5 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(0.3)] .75 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(0.4)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 12.813 moveto
(\\220) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(255) show
93.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.001 w
0 .61803 m
.0098 .61708 L
.01961 .61424 L
.02941 .60954 L
.03922 .60301 L
.04902 .59472 L
.05882 .58475 L
.06863 .57317 L
.07843 .5601 L
.08824 .54565 L
.09804 .52994 L
.10784 .5131 L
.11765 .49526 L
.12745 .47658 L
.13725 .4572 L
.14706 .43726 L
.15686 .4169 L
.16667 .39627 L
.17647 .37551 L
.18627 .35474 L
.19608 .33408 L
.20588 .31367 L
.21569 .2936 L
.22549 .27397 L
.23529 .25486 L
.2451 .23636 L
.2549 .21853 L
.26471 .20143 L
.27451 .18509 L
.28431 .16956 L
.29412 .15485 L
.30392 .14098 L
.31373 .12797 L
.32353 .11579 L
.33333 .10446 L
.34314 .09394 L
.35294 .08422 L
.36275 .07528 L
.37255 .06708 L
.38235 .05959 L
.39216 .05277 L
.40196 .04659 L
.41176 .04101 L
.42157 .03598 L
.43137 .03148 L
.44118 .02745 L
.45098 .02386 L
.46078 .02068 L
.47059 .01787 L
.48039 .0154 L
Mistroke
.4902 .01322 L
.5 .01132 L
.5098 .00966 L
.51961 .00822 L
.52941 .00697 L
.53922 .0059 L
.54902 .00497 L
.55882 .00418 L
.56863 .0035 L
.57843 .00292 L
.58824 .00244 L
.59804 .00202 L
.60784 .00167 L
.61765 .00138 L
.62745 .00114 L
.63725 .00093 L
.64706 .00076 L
.65686 .00062 L
.66667 .0005 L
.67647 .00041 L
.68627 .00033 L
.69608 .00027 L
.70588 .00021 L
.71569 .00017 L
.72549 .00014 L
.73529 .00011 L
.7451 9e-005 L
.7549 7e-005 L
.76471 5e-005 L
.77451 4e-005 L
.78431 3e-005 L
.79412 3e-005 L
.80392 2e-005 L
.81373 2e-005 L
.82353 1e-005 L
.83333 1e-005 L
.84314 1e-005 L
.85294 1e-005 L
.86275 0 L
.87255 0 L
.88235 0 L
.89216 0 L
.90196 0 L
.91176 0 L
.92157 0 L
.93137 0 L
.94118 0 L
.95098 0 L
.96078 0 L
.97059 0 L
Mistroke
.98039 0 L
.9902 0 L
1 0 L
Mfstroke
1 0 m
1 0 L
s
0 g
.0001 w
0 .61803 -1.875 0 Mabsadd m
0 .61803 0 2.5 Mabsadd L
0 .61803 1.875 0 Mabsadd L
0 .61803 0 -2.5 Mabsadd L
0 .61803 -1.875 0 Mabsadd L closepath F
.0098 .61708 -1.875 0 Mabsadd m
.0098 .61708 0 2.5 Mabsadd L
.0098 .61708 1.875 0 Mabsadd L
.0098 .61708 0 -2.5 Mabsadd L
.0098 .61708 -1.875 0 Mabsadd L closepath F
.01961 .61424 -1.875 0 Mabsadd m
.01961 .61424 0 2.5 Mabsadd L
.01961 .61424 1.875 0 Mabsadd L
.01961 .61424 0 -2.5 Mabsadd L
.01961 .61424 -1.875 0 Mabsadd L closepath F
.02941 .60954 -1.875 0 Mabsadd m
.02941 .60954 0 2.5 Mabsadd L
.02941 .60954 1.875 0 Mabsadd L
.02941 .60954 0 -2.5 Mabsadd L
.02941 .60954 -1.875 0 Mabsadd L closepath F
.03922 .60301 -1.875 0 Mabsadd m
.03922 .60301 0 2.5 Mabsadd L
.03922 .60301 1.875 0 Mabsadd L
.03922 .60301 0 -2.5 Mabsadd L
.03922 .60301 -1.875 0 Mabsadd L closepath F
.04902 .59472 -1.875 0 Mabsadd m
.04902 .59472 0 2.5 Mabsadd L
.04902 .59472 1.875 0 Mabsadd L
.04902 .59472 0 -2.5 Mabsadd L
.04902 .59472 -1.875 0 Mabsadd L closepath F
.05882 .58475 -1.875 0 Mabsadd m
.05882 .58475 0 2.5 Mabsadd L
.05882 .58475 1.875 0 Mabsadd L
.05882 .58475 0 -2.5 Mabsadd L
.05882 .58475 -1.875 0 Mabsadd L closepath F
.06863 .57317 -1.875 0 Mabsadd m
.06863 .57317 0 2.5 Mabsadd L
.06863 .57317 1.875 0 Mabsadd L
.06863 .57317 0 -2.5 Mabsadd L
.06863 .57317 -1.875 0 Mabsadd L closepath F
.07843 .5601 -1.875 0 Mabsadd m
.07843 .5601 0 2.5 Mabsadd L
.07843 .5601 1.875 0 Mabsadd L
.07843 .5601 0 -2.5 Mabsadd L
.07843 .5601 -1.875 0 Mabsadd L closepath F
.08824 .54565 -1.875 0 Mabsadd m
.08824 .54565 0 2.5 Mabsadd L
.08824 .54565 1.875 0 Mabsadd L
.08824 .54565 0 -2.5 Mabsadd L
.08824 .54565 -1.875 0 Mabsadd L closepath F
.09804 .52994 -1.875 0 Mabsadd m
.09804 .52994 0 2.5 Mabsadd L
.09804 .52994 1.875 0 Mabsadd L
.09804 .52994 0 -2.5 Mabsadd L
.09804 .52994 -1.875 0 Mabsadd L closepath F
.10784 .5131 -1.875 0 Mabsadd m
.10784 .5131 0 2.5 Mabsadd L
.10784 .5131 1.875 0 Mabsadd L
.10784 .5131 0 -2.5 Mabsadd L
.10784 .5131 -1.875 0 Mabsadd L closepath F
.11765 .49526 -1.875 0 Mabsadd m
.11765 .49526 0 2.5 Mabsadd L
.11765 .49526 1.875 0 Mabsadd L
.11765 .49526 0 -2.5 Mabsadd L
.11765 .49526 -1.875 0 Mabsadd L closepath F
.12745 .47658 -1.875 0 Mabsadd m
.12745 .47658 0 2.5 Mabsadd L
.12745 .47658 1.875 0 Mabsadd L
.12745 .47658 0 -2.5 Mabsadd L
.12745 .47658 -1.875 0 Mabsadd L closepath F
.13725 .4572 -1.875 0 Mabsadd m
.13725 .4572 0 2.5 Mabsadd L
.13725 .4572 1.875 0 Mabsadd L
.13725 .4572 0 -2.5 Mabsadd L
.13725 .4572 -1.875 0 Mabsadd L closepath F
.14706 .43726 -1.875 0 Mabsadd m
.14706 .43726 0 2.5 Mabsadd L
.14706 .43726 1.875 0 Mabsadd L
.14706 .43726 0 -2.5 Mabsadd L
.14706 .43726 -1.875 0 Mabsadd L closepath F
.15686 .4169 -1.875 0 Mabsadd m
.15686 .4169 0 2.5 Mabsadd L
.15686 .4169 1.875 0 Mabsadd L
.15686 .4169 0 -2.5 Mabsadd L
.15686 .4169 -1.875 0 Mabsadd L closepath F
.16667 .39627 -1.875 0 Mabsadd m
.16667 .39627 0 2.5 Mabsadd L
.16667 .39627 1.875 0 Mabsadd L
.16667 .39627 0 -2.5 Mabsadd L
.16667 .39627 -1.875 0 Mabsadd L closepath F
.17647 .37551 -1.875 0 Mabsadd m
.17647 .37551 0 2.5 Mabsadd L
.17647 .37551 1.875 0 Mabsadd L
.17647 .37551 0 -2.5 Mabsadd L
.17647 .37551 -1.875 0 Mabsadd L closepath F
.18627 .35474 -1.875 0 Mabsadd m
.18627 .35474 0 2.5 Mabsadd L
.18627 .35474 1.875 0 Mabsadd L
.18627 .35474 0 -2.5 Mabsadd L
.18627 .35474 -1.875 0 Mabsadd L closepath F
.19608 .33408 -1.875 0 Mabsadd m
.19608 .33408 0 2.5 Mabsadd L
.19608 .33408 1.875 0 Mabsadd L
.19608 .33408 0 -2.5 Mabsadd L
.19608 .33408 -1.875 0 Mabsadd L closepath F
.20588 .31367 -1.875 0 Mabsadd m
.20588 .31367 0 2.5 Mabsadd L
.20588 .31367 1.875 0 Mabsadd L
.20588 .31367 0 -2.5 Mabsadd L
.20588 .31367 -1.875 0 Mabsadd L closepath F
.21569 .2936 -1.875 0 Mabsadd m
.21569 .2936 0 2.5 Mabsadd L
.21569 .2936 1.875 0 Mabsadd L
.21569 .2936 0 -2.5 Mabsadd L
.21569 .2936 -1.875 0 Mabsadd L closepath F
.22549 .27397 -1.875 0 Mabsadd m
.22549 .27397 0 2.5 Mabsadd L
.22549 .27397 1.875 0 Mabsadd L
.22549 .27397 0 -2.5 Mabsadd L
.22549 .27397 -1.875 0 Mabsadd L closepath F
.23529 .25486 -1.875 0 Mabsadd m
.23529 .25486 0 2.5 Mabsadd L
.23529 .25486 1.875 0 Mabsadd L
.23529 .25486 0 -2.5 Mabsadd L
.23529 .25486 -1.875 0 Mabsadd L closepath F
.2451 .23636 -1.875 0 Mabsadd m
.2451 .23636 0 2.5 Mabsadd L
.2451 .23636 1.875 0 Mabsadd L
.2451 .23636 0 -2.5 Mabsadd L
.2451 .23636 -1.875 0 Mabsadd L closepath F
.2549 .21853 -1.875 0 Mabsadd m
.2549 .21853 0 2.5 Mabsadd L
.2549 .21853 1.875 0 Mabsadd L
.2549 .21853 0 -2.5 Mabsadd L
.2549 .21853 -1.875 0 Mabsadd L closepath F
.26471 .20143 -1.875 0 Mabsadd m
.26471 .20143 0 2.5 Mabsadd L
.26471 .20143 1.875 0 Mabsadd L
.26471 .20143 0 -2.5 Mabsadd L
.26471 .20143 -1.875 0 Mabsadd L closepath F
.27451 .18509 -1.875 0 Mabsadd m
.27451 .18509 0 2.5 Mabsadd L
.27451 .18509 1.875 0 Mabsadd L
.27451 .18509 0 -2.5 Mabsadd L
.27451 .18509 -1.875 0 Mabsadd L closepath F
.28431 .16956 -1.875 0 Mabsadd m
.28431 .16956 0 2.5 Mabsadd L
.28431 .16956 1.875 0 Mabsadd L
.28431 .16956 0 -2.5 Mabsadd L
.28431 .16956 -1.875 0 Mabsadd L closepath F
.29412 .15485 -1.875 0 Mabsadd m
.29412 .15485 0 2.5 Mabsadd L
.29412 .15485 1.875 0 Mabsadd L
.29412 .15485 0 -2.5 Mabsadd L
.29412 .15485 -1.875 0 Mabsadd L closepath F
.30392 .14098 -1.875 0 Mabsadd m
.30392 .14098 0 2.5 Mabsadd L
.30392 .14098 1.875 0 Mabsadd L
.30392 .14098 0 -2.5 Mabsadd L
.30392 .14098 -1.875 0 Mabsadd L closepath F
.31373 .12797 -1.875 0 Mabsadd m
.31373 .12797 0 2.5 Mabsadd L
.31373 .12797 1.875 0 Mabsadd L
.31373 .12797 0 -2.5 Mabsadd L
.31373 .12797 -1.875 0 Mabsadd L closepath F
.32353 .11579 -1.875 0 Mabsadd m
.32353 .11579 0 2.5 Mabsadd L
.32353 .11579 1.875 0 Mabsadd L
.32353 .11579 0 -2.5 Mabsadd L
.32353 .11579 -1.875 0 Mabsadd L closepath F
.33333 .10446 -1.875 0 Mabsadd m
.33333 .10446 0 2.5 Mabsadd L
.33333 .10446 1.875 0 Mabsadd L
.33333 .10446 0 -2.5 Mabsadd L
.33333 .10446 -1.875 0 Mabsadd L closepath F
.34314 .09394 -1.875 0 Mabsadd m
.34314 .09394 0 2.5 Mabsadd L
.34314 .09394 1.875 0 Mabsadd L
.34314 .09394 0 -2.5 Mabsadd L
.34314 .09394 -1.875 0 Mabsadd L closepath F
.35294 .08422 -1.875 0 Mabsadd m
.35294 .08422 0 2.5 Mabsadd L
.35294 .08422 1.875 0 Mabsadd L
.35294 .08422 0 -2.5 Mabsadd L
.35294 .08422 -1.875 0 Mabsadd L closepath F
.36275 .07528 -1.875 0 Mabsadd m
.36275 .07528 0 2.5 Mabsadd L
.36275 .07528 1.875 0 Mabsadd L
.36275 .07528 0 -2.5 Mabsadd L
.36275 .07528 -1.875 0 Mabsadd L closepath F
.37255 .06708 -1.875 0 Mabsadd m
.37255 .06708 0 2.5 Mabsadd L
.37255 .06708 1.875 0 Mabsadd L
.37255 .06708 0 -2.5 Mabsadd L
.37255 .06708 -1.875 0 Mabsadd L closepath F
.38235 .05959 -1.875 0 Mabsadd m
.38235 .05959 0 2.5 Mabsadd L
.38235 .05959 1.875 0 Mabsadd L
.38235 .05959 0 -2.5 Mabsadd L
.38235 .05959 -1.875 0 Mabsadd L closepath F
.39216 .05277 -1.875 0 Mabsadd m
.39216 .05277 0 2.5 Mabsadd L
.39216 .05277 1.875 0 Mabsadd L
.39216 .05277 0 -2.5 Mabsadd L
.39216 .05277 -1.875 0 Mabsadd L closepath F
.40196 .04659 -1.875 0 Mabsadd m
.40196 .04659 0 2.5 Mabsadd L
.40196 .04659 1.875 0 Mabsadd L
.40196 .04659 0 -2.5 Mabsadd L
.40196 .04659 -1.875 0 Mabsadd L closepath F
.41176 .04101 -1.875 0 Mabsadd m
.41176 .04101 0 2.5 Mabsadd L
.41176 .04101 1.875 0 Mabsadd L
.41176 .04101 0 -2.5 Mabsadd L
.41176 .04101 -1.875 0 Mabsadd L closepath F
.42157 .03598 -1.875 0 Mabsadd m
.42157 .03598 0 2.5 Mabsadd L
.42157 .03598 1.875 0 Mabsadd L
.42157 .03598 0 -2.5 Mabsadd L
.42157 .03598 -1.875 0 Mabsadd L closepath F
.43137 .03148 -1.875 0 Mabsadd m
.43137 .03148 0 2.5 Mabsadd L
.43137 .03148 1.875 0 Mabsadd L
.43137 .03148 0 -2.5 Mabsadd L
.43137 .03148 -1.875 0 Mabsadd L closepath F
.44118 .02745 -1.875 0 Mabsadd m
.44118 .02745 0 2.5 Mabsadd L
.44118 .02745 1.875 0 Mabsadd L
.44118 .02745 0 -2.5 Mabsadd L
.44118 .02745 -1.875 0 Mabsadd L closepath F
.45098 .02386 -1.875 0 Mabsadd m
.45098 .02386 0 2.5 Mabsadd L
.45098 .02386 1.875 0 Mabsadd L
.45098 .02386 0 -2.5 Mabsadd L
.45098 .02386 -1.875 0 Mabsadd L closepath F
.46078 .02068 -1.875 0 Mabsadd m
.46078 .02068 0 2.5 Mabsadd L
.46078 .02068 1.875 0 Mabsadd L
.46078 .02068 0 -2.5 Mabsadd L
.46078 .02068 -1.875 0 Mabsadd L closepath F
.47059 .01787 -1.875 0 Mabsadd m
.47059 .01787 0 2.5 Mabsadd L
.47059 .01787 1.875 0 Mabsadd L
.47059 .01787 0 -2.5 Mabsadd L
.47059 .01787 -1.875 0 Mabsadd L closepath F
.48039 .0154 -1.875 0 Mabsadd m
.48039 .0154 0 2.5 Mabsadd L
.48039 .0154 1.875 0 Mabsadd L
.48039 .0154 0 -2.5 Mabsadd L
.48039 .0154 -1.875 0 Mabsadd L closepath F
.4902 .01322 -1.875 0 Mabsadd m
.4902 .01322 0 2.5 Mabsadd L
.4902 .01322 1.875 0 Mabsadd L
.4902 .01322 0 -2.5 Mabsadd L
.4902 .01322 -1.875 0 Mabsadd L closepath F
.5 .01132 -1.875 0 Mabsadd m
.5 .01132 0 2.5 Mabsadd L
.5 .01132 1.875 0 Mabsadd L
.5 .01132 0 -2.5 Mabsadd L
.5 .01132 -1.875 0 Mabsadd L closepath F
.5098 .00966 -1.875 0 Mabsadd m
.5098 .00966 0 2.5 Mabsadd L
.5098 .00966 1.875 0 Mabsadd L
.5098 .00966 0 -2.5 Mabsadd L
.5098 .00966 -1.875 0 Mabsadd L closepath F
.51961 .00822 -1.875 0 Mabsadd m
.51961 .00822 0 2.5 Mabsadd L
.51961 .00822 1.875 0 Mabsadd L
.51961 .00822 0 -2.5 Mabsadd L
.51961 .00822 -1.875 0 Mabsadd L closepath F
.52941 .00697 -1.875 0 Mabsadd m
.52941 .00697 0 2.5 Mabsadd L
.52941 .00697 1.875 0 Mabsadd L
.52941 .00697 0 -2.5 Mabsadd L
.52941 .00697 -1.875 0 Mabsadd L closepath F
.53922 .0059 -1.875 0 Mabsadd m
.53922 .0059 0 2.5 Mabsadd L
.53922 .0059 1.875 0 Mabsadd L
.53922 .0059 0 -2.5 Mabsadd L
.53922 .0059 -1.875 0 Mabsadd L closepath F
.54902 .00497 -1.875 0 Mabsadd m
.54902 .00497 0 2.5 Mabsadd L
.54902 .00497 1.875 0 Mabsadd L
.54902 .00497 0 -2.5 Mabsadd L
.54902 .00497 -1.875 0 Mabsadd L closepath F
.55882 .00418 -1.875 0 Mabsadd m
.55882 .00418 0 2.5 Mabsadd L
.55882 .00418 1.875 0 Mabsadd L
.55882 .00418 0 -2.5 Mabsadd L
.55882 .00418 -1.875 0 Mabsadd L closepath F
.56863 .0035 -1.875 0 Mabsadd m
.56863 .0035 0 2.5 Mabsadd L
.56863 .0035 1.875 0 Mabsadd L
.56863 .0035 0 -2.5 Mabsadd L
.56863 .0035 -1.875 0 Mabsadd L closepath F
.57843 .00292 -1.875 0 Mabsadd m
.57843 .00292 0 2.5 Mabsadd L
.57843 .00292 1.875 0 Mabsadd L
.57843 .00292 0 -2.5 Mabsadd L
.57843 .00292 -1.875 0 Mabsadd L closepath F
.58824 .00244 -1.875 0 Mabsadd m
.58824 .00244 0 2.5 Mabsadd L
.58824 .00244 1.875 0 Mabsadd L
.58824 .00244 0 -2.5 Mabsadd L
.58824 .00244 -1.875 0 Mabsadd L closepath F
.59804 .00202 -1.875 0 Mabsadd m
.59804 .00202 0 2.5 Mabsadd L
.59804 .00202 1.875 0 Mabsadd L
.59804 .00202 0 -2.5 Mabsadd L
.59804 .00202 -1.875 0 Mabsadd L closepath F
.60784 .00167 -1.875 0 Mabsadd m
.60784 .00167 0 2.5 Mabsadd L
.60784 .00167 1.875 0 Mabsadd L
.60784 .00167 0 -2.5 Mabsadd L
.60784 .00167 -1.875 0 Mabsadd L closepath F
.61765 .00138 -1.875 0 Mabsadd m
.61765 .00138 0 2.5 Mabsadd L
.61765 .00138 1.875 0 Mabsadd L
.61765 .00138 0 -2.5 Mabsadd L
.61765 .00138 -1.875 0 Mabsadd L closepath F
.62745 .00114 -1.875 0 Mabsadd m
.62745 .00114 0 2.5 Mabsadd L
.62745 .00114 1.875 0 Mabsadd L
.62745 .00114 0 -2.5 Mabsadd L
.62745 .00114 -1.875 0 Mabsadd L closepath F
.63725 .00093 -1.875 0 Mabsadd m
.63725 .00093 0 2.5 Mabsadd L
.63725 .00093 1.875 0 Mabsadd L
.63725 .00093 0 -2.5 Mabsadd L
.63725 .00093 -1.875 0 Mabsadd L closepath F
.64706 .00076 -1.875 0 Mabsadd m
.64706 .00076 0 2.5 Mabsadd L
.64706 .00076 1.875 0 Mabsadd L
.64706 .00076 0 -2.5 Mabsadd L
.64706 .00076 -1.875 0 Mabsadd L closepath F
.65686 .00062 -1.875 0 Mabsadd m
.65686 .00062 0 2.5 Mabsadd L
.65686 .00062 1.875 0 Mabsadd L
.65686 .00062 0 -2.5 Mabsadd L
.65686 .00062 -1.875 0 Mabsadd L closepath F
.66667 .0005 -1.875 0 Mabsadd m
.66667 .0005 0 2.5 Mabsadd L
.66667 .0005 1.875 0 Mabsadd L
.66667 .0005 0 -2.5 Mabsadd L
.66667 .0005 -1.875 0 Mabsadd L closepath F
.67647 .00041 -1.875 0 Mabsadd m
.67647 .00041 0 2.5 Mabsadd L
.67647 .00041 1.875 0 Mabsadd L
.67647 .00041 0 -2.5 Mabsadd L
.67647 .00041 -1.875 0 Mabsadd L closepath F
.68627 .00033 -1.875 0 Mabsadd m
.68627 .00033 0 2.5 Mabsadd L
.68627 .00033 1.875 0 Mabsadd L
.68627 .00033 0 -2.5 Mabsadd L
.68627 .00033 -1.875 0 Mabsadd L closepath F
.69608 .00027 -1.875 0 Mabsadd m
.69608 .00027 0 2.5 Mabsadd L
.69608 .00027 1.875 0 Mabsadd L
.69608 .00027 0 -2.5 Mabsadd L
.69608 .00027 -1.875 0 Mabsadd L closepath F
.70588 .00021 -1.875 0 Mabsadd m
.70588 .00021 0 2.5 Mabsadd L
.70588 .00021 1.875 0 Mabsadd L
.70588 .00021 0 -2.5 Mabsadd L
.70588 .00021 -1.875 0 Mabsadd L closepath F
.71569 .00017 -1.875 0 Mabsadd m
.71569 .00017 0 2.5 Mabsadd L
.71569 .00017 1.875 0 Mabsadd L
.71569 .00017 0 -2.5 Mabsadd L
.71569 .00017 -1.875 0 Mabsadd L closepath F
.72549 .00014 -1.875 0 Mabsadd m
.72549 .00014 0 2.5 Mabsadd L
.72549 .00014 1.875 0 Mabsadd L
.72549 .00014 0 -2.5 Mabsadd L
.72549 .00014 -1.875 0 Mabsadd L closepath F
.73529 .00011 -1.875 0 Mabsadd m
.73529 .00011 0 2.5 Mabsadd L
.73529 .00011 1.875 0 Mabsadd L
.73529 .00011 0 -2.5 Mabsadd L
.73529 .00011 -1.875 0 Mabsadd L closepath F
.7451 9e-005 -1.875 0 Mabsadd m
.7451 9e-005 0 2.5 Mabsadd L
.7451 9e-005 1.875 0 Mabsadd L
.7451 9e-005 0 -2.5 Mabsadd L
.7451 9e-005 -1.875 0 Mabsadd L closepath F
.7549 7e-005 -1.875 0 Mabsadd m
.7549 7e-005 0 2.5 Mabsadd L
.7549 7e-005 1.875 0 Mabsadd L
.7549 7e-005 0 -2.5 Mabsadd L
.7549 7e-005 -1.875 0 Mabsadd L closepath F
.76471 5e-005 -1.875 0 Mabsadd m
.76471 5e-005 0 2.5 Mabsadd L
.76471 5e-005 1.875 0 Mabsadd L
.76471 5e-005 0 -2.5 Mabsadd L
.76471 5e-005 -1.875 0 Mabsadd L closepath F
.77451 4e-005 -1.875 0 Mabsadd m
.77451 4e-005 0 2.5 Mabsadd L
.77451 4e-005 1.875 0 Mabsadd L
.77451 4e-005 0 -2.5 Mabsadd L
.77451 4e-005 -1.875 0 Mabsadd L closepath F
.78431 3e-005 -1.875 0 Mabsadd m
.78431 3e-005 0 2.5 Mabsadd L
.78431 3e-005 1.875 0 Mabsadd L
.78431 3e-005 0 -2.5 Mabsadd L
.78431 3e-005 -1.875 0 Mabsadd L closepath F
.79412 3e-005 -1.875 0 Mabsadd m
.79412 3e-005 0 2.5 Mabsadd L
.79412 3e-005 1.875 0 Mabsadd L
.79412 3e-005 0 -2.5 Mabsadd L
.79412 3e-005 -1.875 0 Mabsadd L closepath F
.80392 2e-005 -1.875 0 Mabsadd m
.80392 2e-005 0 2.5 Mabsadd L
.80392 2e-005 1.875 0 Mabsadd L
.80392 2e-005 0 -2.5 Mabsadd L
.80392 2e-005 -1.875 0 Mabsadd L closepath F
.81373 2e-005 -1.875 0 Mabsadd m
.81373 2e-005 0 2.5 Mabsadd L
.81373 2e-005 1.875 0 Mabsadd L
.81373 2e-005 0 -2.5 Mabsadd L
.81373 2e-005 -1.875 0 Mabsadd L closepath F
.82353 1e-005 -1.875 0 Mabsadd m
.82353 1e-005 0 2.5 Mabsadd L
.82353 1e-005 1.875 0 Mabsadd L
.82353 1e-005 0 -2.5 Mabsadd L
.82353 1e-005 -1.875 0 Mabsadd L closepath F
.83333 1e-005 -1.875 0 Mabsadd m
.83333 1e-005 0 2.5 Mabsadd L
.83333 1e-005 1.875 0 Mabsadd L
.83333 1e-005 0 -2.5 Mabsadd L
.83333 1e-005 -1.875 0 Mabsadd L closepath F
.84314 1e-005 -1.875 0 Mabsadd m
.84314 1e-005 0 2.5 Mabsadd L
.84314 1e-005 1.875 0 Mabsadd L
.84314 1e-005 0 -2.5 Mabsadd L
.84314 1e-005 -1.875 0 Mabsadd L closepath F
.85294 1e-005 -1.875 0 Mabsadd m
.85294 1e-005 0 2.5 Mabsadd L
.85294 1e-005 1.875 0 Mabsadd L
.85294 1e-005 0 -2.5 Mabsadd L
.85294 1e-005 -1.875 0 Mabsadd L closepath F
.86275 0 -1.875 0 Mabsadd m
.86275 0 0 2.5 Mabsadd L
.86275 0 1.875 0 Mabsadd L
.86275 0 0 -2.5 Mabsadd L
.86275 0 -1.875 0 Mabsadd L closepath F
.87255 0 -1.875 0 Mabsadd m
.87255 0 0 2.5 Mabsadd L
.87255 0 1.875 0 Mabsadd L
.87255 0 0 -2.5 Mabsadd L
.87255 0 -1.875 0 Mabsadd L closepath F
.88235 0 -1.875 0 Mabsadd m
.88235 0 0 2.5 Mabsadd L
.88235 0 1.875 0 Mabsadd L
.88235 0 0 -2.5 Mabsadd L
.88235 0 -1.875 0 Mabsadd L closepath F
.89216 0 -1.875 0 Mabsadd m
.89216 0 0 2.5 Mabsadd L
.89216 0 1.875 0 Mabsadd L
.89216 0 0 -2.5 Mabsadd L
.89216 0 -1.875 0 Mabsadd L closepath F
.90196 0 -1.875 0 Mabsadd m
.90196 0 0 2.5 Mabsadd L
.90196 0 1.875 0 Mabsadd L
.90196 0 0 -2.5 Mabsadd L
.90196 0 -1.875 0 Mabsadd L closepath F
.91176 0 -1.875 0 Mabsadd m
.91176 0 0 2.5 Mabsadd L
.91176 0 1.875 0 Mabsadd L
.91176 0 0 -2.5 Mabsadd L
.91176 0 -1.875 0 Mabsadd L closepath F
.92157 0 -1.875 0 Mabsadd m
.92157 0 0 2.5 Mabsadd L
.92157 0 1.875 0 Mabsadd L
.92157 0 0 -2.5 Mabsadd L
.92157 0 -1.875 0 Mabsadd L closepath F
.93137 0 -1.875 0 Mabsadd m
.93137 0 0 2.5 Mabsadd L
.93137 0 1.875 0 Mabsadd L
.93137 0 0 -2.5 Mabsadd L
.93137 0 -1.875 0 Mabsadd L closepath F
.94118 0 -1.875 0 Mabsadd m
.94118 0 0 2.5 Mabsadd L
.94118 0 1.875 0 Mabsadd L
.94118 0 0 -2.5 Mabsadd L
.94118 0 -1.875 0 Mabsadd L closepath F
.95098 0 -1.875 0 Mabsadd m
.95098 0 0 2.5 Mabsadd L
.95098 0 1.875 0 Mabsadd L
.95098 0 0 -2.5 Mabsadd L
.95098 0 -1.875 0 Mabsadd L closepath F
.96078 0 -1.875 0 Mabsadd m
.96078 0 0 2.5 Mabsadd L
.96078 0 1.875 0 Mabsadd L
.96078 0 0 -2.5 Mabsadd L
.96078 0 -1.875 0 Mabsadd L closepath F
.97059 0 -1.875 0 Mabsadd m
.97059 0 0 2.5 Mabsadd L
.97059 0 1.875 0 Mabsadd L
.97059 0 0 -2.5 Mabsadd L
.97059 0 -1.875 0 Mabsadd L closepath F
.98039 0 -1.875 0 Mabsadd m
.98039 0 0 2.5 Mabsadd L
.98039 0 1.875 0 Mabsadd L
.98039 0 0 -2.5 Mabsadd L
.98039 0 -1.875 0 Mabsadd L closepath F
.9902 0 -1.875 0 Mabsadd m
.9902 0 0 2.5 Mabsadd L
.9902 0 1.875 0 Mabsadd L
.9902 0 0 -2.5 Mabsadd L
.9902 0 -1.875 0 Mabsadd L closepath F
1 0 -1.875 0 Mabsadd m
1 0 0 2.5 Mabsadd L
1 0 1.875 0 Mabsadd L
1 0 0 -2.5 Mabsadd L
1 0 -1.875 0 Mabsadd L closepath F
1.0098 0 -1.875 0 Mabsadd m
1.0098 0 0 2.5 Mabsadd L
1.0098 0 1.875 0 Mabsadd L
1.0098 0 0 -2.5 Mabsadd L
1.0098 0 -1.875 0 Mabsadd L closepath F
1.01961 0 -1.875 0 Mabsadd m
1.01961 0 0 2.5 Mabsadd L
1.01961 0 1.875 0 Mabsadd L
1.01961 0 0 -2.5 Mabsadd L
1.01961 0 -1.875 0 Mabsadd L closepath F
1.02941 0 -1.875 0 Mabsadd m
1.02941 0 0 2.5 Mabsadd L
1.02941 0 1.875 0 Mabsadd L
1.02941 0 0 -2.5 Mabsadd L
1.02941 0 -1.875 0 Mabsadd L closepath F
1.03922 0 -1.875 0 Mabsadd m
1.03922 0 0 2.5 Mabsadd L
1.03922 0 1.875 0 Mabsadd L
1.03922 0 0 -2.5 Mabsadd L
1.03922 0 -1.875 0 Mabsadd L closepath F
1.04902 0 -1.875 0 Mabsadd m
1.04902 0 0 2.5 Mabsadd L
1.04902 0 1.875 0 Mabsadd L
1.04902 0 0 -2.5 Mabsadd L
1.04902 0 -1.875 0 Mabsadd L closepath F
1.05882 0 -1.875 0 Mabsadd m
1.05882 0 0 2.5 Mabsadd L
1.05882 0 1.875 0 Mabsadd L
1.05882 0 0 -2.5 Mabsadd L
1.05882 0 -1.875 0 Mabsadd L closepath F
1.06863 0 -1.875 0 Mabsadd m
1.06863 0 0 2.5 Mabsadd L
1.06863 0 1.875 0 Mabsadd L
1.06863 0 0 -2.5 Mabsadd L
1.06863 0 -1.875 0 Mabsadd L closepath F
1.07843 0 -1.875 0 Mabsadd m
1.07843 0 0 2.5 Mabsadd L
1.07843 0 1.875 0 Mabsadd L
1.07843 0 0 -2.5 Mabsadd L
1.07843 0 -1.875 0 Mabsadd L closepath F
1.08824 0 -1.875 0 Mabsadd m
1.08824 0 0 2.5 Mabsadd L
1.08824 0 1.875 0 Mabsadd L
1.08824 0 0 -2.5 Mabsadd L
1.08824 0 -1.875 0 Mabsadd L closepath F
1.09804 0 -1.875 0 Mabsadd m
1.09804 0 0 2.5 Mabsadd L
1.09804 0 1.875 0 Mabsadd L
1.09804 0 0 -2.5 Mabsadd L
1.09804 0 -1.875 0 Mabsadd L closepath F
1.10784 0 -1.875 0 Mabsadd m
1.10784 0 0 2.5 Mabsadd L
1.10784 0 1.875 0 Mabsadd L
1.10784 0 0 -2.5 Mabsadd L
1.10784 0 -1.875 0 Mabsadd L closepath F
1.11765 0 -1.875 0 Mabsadd m
1.11765 0 0 2.5 Mabsadd L
1.11765 0 1.875 0 Mabsadd L
1.11765 0 0 -2.5 Mabsadd L
1.11765 0 -1.875 0 Mabsadd L closepath F
1.12745 0 -1.875 0 Mabsadd m
1.12745 0 0 2.5 Mabsadd L
1.12745 0 1.875 0 Mabsadd L
1.12745 0 0 -2.5 Mabsadd L
1.12745 0 -1.875 0 Mabsadd L closepath F
1.13725 0 -1.875 0 Mabsadd m
1.13725 0 0 2.5 Mabsadd L
1.13725 0 1.875 0 Mabsadd L
1.13725 0 0 -2.5 Mabsadd L
1.13725 0 -1.875 0 Mabsadd L closepath F
1.14706 0 -1.875 0 Mabsadd m
1.14706 0 0 2.5 Mabsadd L
1.14706 0 1.875 0 Mabsadd L
1.14706 0 0 -2.5 Mabsadd L
1.14706 0 -1.875 0 Mabsadd L closepath F
1.15686 0 -1.875 0 Mabsadd m
1.15686 0 0 2.5 Mabsadd L
1.15686 0 1.875 0 Mabsadd L
1.15686 0 0 -2.5 Mabsadd L
1.15686 0 -1.875 0 Mabsadd L closepath F
1.16667 0 -1.875 0 Mabsadd m
1.16667 0 0 2.5 Mabsadd L
1.16667 0 1.875 0 Mabsadd L
1.16667 0 0 -2.5 Mabsadd L
1.16667 0 -1.875 0 Mabsadd L closepath F
1.17647 0 -1.875 0 Mabsadd m
1.17647 0 0 2.5 Mabsadd L
1.17647 0 1.875 0 Mabsadd L
1.17647 0 0 -2.5 Mabsadd L
1.17647 0 -1.875 0 Mabsadd L closepath F
1.18627 0 -1.875 0 Mabsadd m
1.18627 0 0 2.5 Mabsadd L
1.18627 0 1.875 0 Mabsadd L
1.18627 0 0 -2.5 Mabsadd L
1.18627 0 -1.875 0 Mabsadd L closepath F
1.19608 0 -1.875 0 Mabsadd m
1.19608 0 0 2.5 Mabsadd L
1.19608 0 1.875 0 Mabsadd L
1.19608 0 0 -2.5 Mabsadd L
1.19608 0 -1.875 0 Mabsadd L closepath F
1.20588 0 -1.875 0 Mabsadd m
1.20588 0 0 2.5 Mabsadd L
1.20588 0 1.875 0 Mabsadd L
1.20588 0 0 -2.5 Mabsadd L
1.20588 0 -1.875 0 Mabsadd L closepath F
1.21569 0 -1.875 0 Mabsadd m
1.21569 0 0 2.5 Mabsadd L
1.21569 0 1.875 0 Mabsadd L
1.21569 0 0 -2.5 Mabsadd L
1.21569 0 -1.875 0 Mabsadd L closepath F
1.22549 0 -1.875 0 Mabsadd m
1.22549 0 0 2.5 Mabsadd L
1.22549 0 1.875 0 Mabsadd L
1.22549 0 0 -2.5 Mabsadd L
1.22549 0 -1.875 0 Mabsadd L closepath F
1.23529 0 -1.875 0 Mabsadd m
1.23529 0 0 2.5 Mabsadd L
1.23529 0 1.875 0 Mabsadd L
1.23529 0 0 -2.5 Mabsadd L
1.23529 0 -1.875 0 Mabsadd L closepath F
1.2451 0 -1.875 0 Mabsadd m
1.2451 0 0 2.5 Mabsadd L
1.2451 0 1.875 0 Mabsadd L
1.2451 0 0 -2.5 Mabsadd L
1.2451 0 -1.875 0 Mabsadd L closepath F
1.2549 0 -1.875 0 Mabsadd m
1.2549 0 0 2.5 Mabsadd L
1.2549 0 1.875 0 Mabsadd L
1.2549 0 0 -2.5 Mabsadd L
1.2549 0 -1.875 0 Mabsadd L closepath F
1.26471 0 -1.875 0 Mabsadd m
1.26471 0 0 2.5 Mabsadd L
1.26471 0 1.875 0 Mabsadd L
1.26471 0 0 -2.5 Mabsadd L
1.26471 0 -1.875 0 Mabsadd L closepath F
1.27451 0 -1.875 0 Mabsadd m
1.27451 0 0 2.5 Mabsadd L
1.27451 0 1.875 0 Mabsadd L
1.27451 0 0 -2.5 Mabsadd L
1.27451 0 -1.875 0 Mabsadd L closepath F
1.28431 0 -1.875 0 Mabsadd m
1.28431 0 0 2.5 Mabsadd L
1.28431 0 1.875 0 Mabsadd L
1.28431 0 0 -2.5 Mabsadd L
1.28431 0 -1.875 0 Mabsadd L closepath F
1.29412 0 -1.875 0 Mabsadd m
1.29412 0 0 2.5 Mabsadd L
1.29412 0 1.875 0 Mabsadd L
1.29412 0 0 -2.5 Mabsadd L
1.29412 0 -1.875 0 Mabsadd L closepath F
1.30392 0 -1.875 0 Mabsadd m
1.30392 0 0 2.5 Mabsadd L
1.30392 0 1.875 0 Mabsadd L
1.30392 0 0 -2.5 Mabsadd L
1.30392 0 -1.875 0 Mabsadd L closepath F
1.31373 0 -1.875 0 Mabsadd m
1.31373 0 0 2.5 Mabsadd L
1.31373 0 1.875 0 Mabsadd L
1.31373 0 0 -2.5 Mabsadd L
1.31373 0 -1.875 0 Mabsadd L closepath F
1.32353 0 -1.875 0 Mabsadd m
1.32353 0 0 2.5 Mabsadd L
1.32353 0 1.875 0 Mabsadd L
1.32353 0 0 -2.5 Mabsadd L
1.32353 0 -1.875 0 Mabsadd L closepath F
1.33333 0 -1.875 0 Mabsadd m
1.33333 0 0 2.5 Mabsadd L
1.33333 0 1.875 0 Mabsadd L
1.33333 0 0 -2.5 Mabsadd L
1.33333 0 -1.875 0 Mabsadd L closepath F
1.34314 0 -1.875 0 Mabsadd m
1.34314 0 0 2.5 Mabsadd L
1.34314 0 1.875 0 Mabsadd L
1.34314 0 0 -2.5 Mabsadd L
1.34314 0 -1.875 0 Mabsadd L closepath F
1.35294 0 -1.875 0 Mabsadd m
1.35294 0 0 2.5 Mabsadd L
1.35294 0 1.875 0 Mabsadd L
1.35294 0 0 -2.5 Mabsadd L
1.35294 0 -1.875 0 Mabsadd L closepath F
1.36275 0 -1.875 0 Mabsadd m
1.36275 0 0 2.5 Mabsadd L
1.36275 0 1.875 0 Mabsadd L
1.36275 0 0 -2.5 Mabsadd L
1.36275 0 -1.875 0 Mabsadd L closepath F
1.37255 0 -1.875 0 Mabsadd m
1.37255 0 0 2.5 Mabsadd L
1.37255 0 1.875 0 Mabsadd L
1.37255 0 0 -2.5 Mabsadd L
1.37255 0 -1.875 0 Mabsadd L closepath F
1.38235 0 -1.875 0 Mabsadd m
1.38235 0 0 2.5 Mabsadd L
1.38235 0 1.875 0 Mabsadd L
1.38235 0 0 -2.5 Mabsadd L
1.38235 0 -1.875 0 Mabsadd L closepath F
1.39216 0 -1.875 0 Mabsadd m
1.39216 0 0 2.5 Mabsadd L
1.39216 0 1.875 0 Mabsadd L
1.39216 0 0 -2.5 Mabsadd L
1.39216 0 -1.875 0 Mabsadd L closepath F
1.40196 0 -1.875 0 Mabsadd m
1.40196 0 0 2.5 Mabsadd L
1.40196 0 1.875 0 Mabsadd L
1.40196 0 0 -2.5 Mabsadd L
1.40196 0 -1.875 0 Mabsadd L closepath F
1.41176 0 -1.875 0 Mabsadd m
1.41176 0 0 2.5 Mabsadd L
1.41176 0 1.875 0 Mabsadd L
1.41176 0 0 -2.5 Mabsadd L
1.41176 0 -1.875 0 Mabsadd L closepath F
1.42157 0 -1.875 0 Mabsadd m
1.42157 0 0 2.5 Mabsadd L
1.42157 0 1.875 0 Mabsadd L
1.42157 0 0 -2.5 Mabsadd L
1.42157 0 -1.875 0 Mabsadd L closepath F
1.43137 0 -1.875 0 Mabsadd m
1.43137 0 0 2.5 Mabsadd L
1.43137 0 1.875 0 Mabsadd L
1.43137 0 0 -2.5 Mabsadd L
1.43137 0 -1.875 0 Mabsadd L closepath F
1.44118 0 -1.875 0 Mabsadd m
1.44118 0 0 2.5 Mabsadd L
1.44118 0 1.875 0 Mabsadd L
1.44118 0 0 -2.5 Mabsadd L
1.44118 0 -1.875 0 Mabsadd L closepath F
1.45098 0 -1.875 0 Mabsadd m
1.45098 0 0 2.5 Mabsadd L
1.45098 0 1.875 0 Mabsadd L
1.45098 0 0 -2.5 Mabsadd L
1.45098 0 -1.875 0 Mabsadd L closepath F
1.46078 0 -1.875 0 Mabsadd m
1.46078 0 0 2.5 Mabsadd L
1.46078 0 1.875 0 Mabsadd L
1.46078 0 0 -2.5 Mabsadd L
1.46078 0 -1.875 0 Mabsadd L closepath F
1.47059 0 -1.875 0 Mabsadd m
1.47059 0 0 2.5 Mabsadd L
1.47059 0 1.875 0 Mabsadd L
1.47059 0 0 -2.5 Mabsadd L
1.47059 0 -1.875 0 Mabsadd L closepath F
1.48039 0 -1.875 0 Mabsadd m
1.48039 0 0 2.5 Mabsadd L
1.48039 0 1.875 0 Mabsadd L
1.48039 0 0 -2.5 Mabsadd L
1.48039 0 -1.875 0 Mabsadd L closepath F
1.4902 0 -1.875 0 Mabsadd m
1.4902 0 0 2.5 Mabsadd L
1.4902 0 1.875 0 Mabsadd L
1.4902 0 0 -2.5 Mabsadd L
1.4902 0 -1.875 0 Mabsadd L closepath F
1.5 0 -1.875 0 Mabsadd m
1.5 0 0 2.5 Mabsadd L
1.5 0 1.875 0 Mabsadd L
1.5 0 0 -2.5 Mabsadd L
1.5 0 -1.875 0 Mabsadd L closepath F
1.5098 0 -1.875 0 Mabsadd m
1.5098 0 0 2.5 Mabsadd L
1.5098 0 1.875 0 Mabsadd L
1.5098 0 0 -2.5 Mabsadd L
1.5098 0 -1.875 0 Mabsadd L closepath F
1.51961 0 -1.875 0 Mabsadd m
1.51961 0 0 2.5 Mabsadd L
1.51961 0 1.875 0 Mabsadd L
1.51961 0 0 -2.5 Mabsadd L
1.51961 0 -1.875 0 Mabsadd L closepath F
1.52941 0 -1.875 0 Mabsadd m
1.52941 0 0 2.5 Mabsadd L
1.52941 0 1.875 0 Mabsadd L
1.52941 0 0 -2.5 Mabsadd L
1.52941 0 -1.875 0 Mabsadd L closepath F
1.53922 0 -1.875 0 Mabsadd m
1.53922 0 0 2.5 Mabsadd L
1.53922 0 1.875 0 Mabsadd L
1.53922 0 0 -2.5 Mabsadd L
1.53922 0 -1.875 0 Mabsadd L closepath F
1.54902 0 -1.875 0 Mabsadd m
1.54902 0 0 2.5 Mabsadd L
1.54902 0 1.875 0 Mabsadd L
1.54902 0 0 -2.5 Mabsadd L
1.54902 0 -1.875 0 Mabsadd L closepath F
1.55882 0 -1.875 0 Mabsadd m
1.55882 0 0 2.5 Mabsadd L
1.55882 0 1.875 0 Mabsadd L
1.55882 0 0 -2.5 Mabsadd L
1.55882 0 -1.875 0 Mabsadd L closepath F
1.56863 0 -1.875 0 Mabsadd m
1.56863 0 0 2.5 Mabsadd L
1.56863 0 1.875 0 Mabsadd L
1.56863 0 0 -2.5 Mabsadd L
1.56863 0 -1.875 0 Mabsadd L closepath F
1.57843 0 -1.875 0 Mabsadd m
1.57843 0 0 2.5 Mabsadd L
1.57843 0 1.875 0 Mabsadd L
1.57843 0 0 -2.5 Mabsadd L
1.57843 0 -1.875 0 Mabsadd L closepath F
1.58824 0 -1.875 0 Mabsadd m
1.58824 0 0 2.5 Mabsadd L
1.58824 0 1.875 0 Mabsadd L
1.58824 0 0 -2.5 Mabsadd L
1.58824 0 -1.875 0 Mabsadd L closepath F
1.59804 0 -1.875 0 Mabsadd m
1.59804 0 0 2.5 Mabsadd L
1.59804 0 1.875 0 Mabsadd L
1.59804 0 0 -2.5 Mabsadd L
1.59804 0 -1.875 0 Mabsadd L closepath F
1.60784 0 -1.875 0 Mabsadd m
1.60784 0 0 2.5 Mabsadd L
1.60784 0 1.875 0 Mabsadd L
1.60784 0 0 -2.5 Mabsadd L
1.60784 0 -1.875 0 Mabsadd L closepath F
1.61765 0 -1.875 0 Mabsadd m
1.61765 0 0 2.5 Mabsadd L
1.61765 0 1.875 0 Mabsadd L
1.61765 0 0 -2.5 Mabsadd L
1.61765 0 -1.875 0 Mabsadd L closepath F
1.62745 0 -1.875 0 Mabsadd m
1.62745 0 0 2.5 Mabsadd L
1.62745 0 1.875 0 Mabsadd L
1.62745 0 0 -2.5 Mabsadd L
1.62745 0 -1.875 0 Mabsadd L closepath F
1.63725 0 -1.875 0 Mabsadd m
1.63725 0 0 2.5 Mabsadd L
1.63725 0 1.875 0 Mabsadd L
1.63725 0 0 -2.5 Mabsadd L
1.63725 0 -1.875 0 Mabsadd L closepath F
1.64706 0 -1.875 0 Mabsadd m
1.64706 0 0 2.5 Mabsadd L
1.64706 0 1.875 0 Mabsadd L
1.64706 0 0 -2.5 Mabsadd L
1.64706 0 -1.875 0 Mabsadd L closepath F
1.65686 0 -1.875 0 Mabsadd m
1.65686 0 0 2.5 Mabsadd L
1.65686 0 1.875 0 Mabsadd L
1.65686 0 0 -2.5 Mabsadd L
1.65686 0 -1.875 0 Mabsadd L closepath F
1.66667 0 -1.875 0 Mabsadd m
1.66667 0 0 2.5 Mabsadd L
1.66667 0 1.875 0 Mabsadd L
1.66667 0 0 -2.5 Mabsadd L
1.66667 0 -1.875 0 Mabsadd L closepath F
1.67647 0 -1.875 0 Mabsadd m
1.67647 0 0 2.5 Mabsadd L
1.67647 0 1.875 0 Mabsadd L
1.67647 0 0 -2.5 Mabsadd L
1.67647 0 -1.875 0 Mabsadd L closepath F
1.68627 0 -1.875 0 Mabsadd m
1.68627 0 0 2.5 Mabsadd L
1.68627 0 1.875 0 Mabsadd L
1.68627 0 0 -2.5 Mabsadd L
1.68627 0 -1.875 0 Mabsadd L closepath F
1.69608 0 -1.875 0 Mabsadd m
1.69608 0 0 2.5 Mabsadd L
1.69608 0 1.875 0 Mabsadd L
1.69608 0 0 -2.5 Mabsadd L
1.69608 0 -1.875 0 Mabsadd L closepath F
1.70588 0 -1.875 0 Mabsadd m
1.70588 0 0 2.5 Mabsadd L
1.70588 0 1.875 0 Mabsadd L
1.70588 0 0 -2.5 Mabsadd L
1.70588 0 -1.875 0 Mabsadd L closepath F
1.71569 0 -1.875 0 Mabsadd m
1.71569 0 0 2.5 Mabsadd L
1.71569 0 1.875 0 Mabsadd L
1.71569 0 0 -2.5 Mabsadd L
1.71569 0 -1.875 0 Mabsadd L closepath F
1.72549 0 -1.875 0 Mabsadd m
1.72549 0 0 2.5 Mabsadd L
1.72549 0 1.875 0 Mabsadd L
1.72549 0 0 -2.5 Mabsadd L
1.72549 0 -1.875 0 Mabsadd L closepath F
1.73529 0 -1.875 0 Mabsadd m
1.73529 0 0 2.5 Mabsadd L
1.73529 0 1.875 0 Mabsadd L
1.73529 0 0 -2.5 Mabsadd L
1.73529 0 -1.875 0 Mabsadd L closepath F
1.7451 0 -1.875 0 Mabsadd m
1.7451 0 0 2.5 Mabsadd L
1.7451 0 1.875 0 Mabsadd L
1.7451 0 0 -2.5 Mabsadd L
1.7451 0 -1.875 0 Mabsadd L closepath F
1.7549 0 -1.875 0 Mabsadd m
1.7549 0 0 2.5 Mabsadd L
1.7549 0 1.875 0 Mabsadd L
1.7549 0 0 -2.5 Mabsadd L
1.7549 0 -1.875 0 Mabsadd L closepath F
1.76471 0 -1.875 0 Mabsadd m
1.76471 0 0 2.5 Mabsadd L
1.76471 0 1.875 0 Mabsadd L
1.76471 0 0 -2.5 Mabsadd L
1.76471 0 -1.875 0 Mabsadd L closepath F
1.77451 0 -1.875 0 Mabsadd m
1.77451 0 0 2.5 Mabsadd L
1.77451 0 1.875 0 Mabsadd L
1.77451 0 0 -2.5 Mabsadd L
1.77451 0 -1.875 0 Mabsadd L closepath F
1.78431 0 -1.875 0 Mabsadd m
1.78431 0 0 2.5 Mabsadd L
1.78431 0 1.875 0 Mabsadd L
1.78431 0 0 -2.5 Mabsadd L
1.78431 0 -1.875 0 Mabsadd L closepath F
1.79412 0 -1.875 0 Mabsadd m
1.79412 0 0 2.5 Mabsadd L
1.79412 0 1.875 0 Mabsadd L
1.79412 0 0 -2.5 Mabsadd L
1.79412 0 -1.875 0 Mabsadd L closepath F
1.80392 0 -1.875 0 Mabsadd m
1.80392 0 0 2.5 Mabsadd L
1.80392 0 1.875 0 Mabsadd L
1.80392 0 0 -2.5 Mabsadd L
1.80392 0 -1.875 0 Mabsadd L closepath F
1.81373 0 -1.875 0 Mabsadd m
1.81373 0 0 2.5 Mabsadd L
1.81373 0 1.875 0 Mabsadd L
1.81373 0 0 -2.5 Mabsadd L
1.81373 0 -1.875 0 Mabsadd L closepath F
1.82353 0 -1.875 0 Mabsadd m
1.82353 0 0 2.5 Mabsadd L
1.82353 0 1.875 0 Mabsadd L
1.82353 0 0 -2.5 Mabsadd L
1.82353 0 -1.875 0 Mabsadd L closepath F
1.83333 0 -1.875 0 Mabsadd m
1.83333 0 0 2.5 Mabsadd L
1.83333 0 1.875 0 Mabsadd L
1.83333 0 0 -2.5 Mabsadd L
1.83333 0 -1.875 0 Mabsadd L closepath F
1.84314 0 -1.875 0 Mabsadd m
1.84314 0 0 2.5 Mabsadd L
1.84314 0 1.875 0 Mabsadd L
1.84314 0 0 -2.5 Mabsadd L
1.84314 0 -1.875 0 Mabsadd L closepath F
1.85294 0 -1.875 0 Mabsadd m
1.85294 0 0 2.5 Mabsadd L
1.85294 0 1.875 0 Mabsadd L
1.85294 0 0 -2.5 Mabsadd L
1.85294 0 -1.875 0 Mabsadd L closepath F
1.86275 0 -1.875 0 Mabsadd m
1.86275 0 0 2.5 Mabsadd L
1.86275 0 1.875 0 Mabsadd L
1.86275 0 0 -2.5 Mabsadd L
1.86275 0 -1.875 0 Mabsadd L closepath F
1.87255 0 -1.875 0 Mabsadd m
1.87255 0 0 2.5 Mabsadd L
1.87255 0 1.875 0 Mabsadd L
1.87255 0 0 -2.5 Mabsadd L
1.87255 0 -1.875 0 Mabsadd L closepath F
1.88235 0 -1.875 0 Mabsadd m
1.88235 0 0 2.5 Mabsadd L
1.88235 0 1.875 0 Mabsadd L
1.88235 0 0 -2.5 Mabsadd L
1.88235 0 -1.875 0 Mabsadd L closepath F
1.89216 0 -1.875 0 Mabsadd m
1.89216 0 0 2.5 Mabsadd L
1.89216 0 1.875 0 Mabsadd L
1.89216 0 0 -2.5 Mabsadd L
1.89216 0 -1.875 0 Mabsadd L closepath F
1.90196 0 -1.875 0 Mabsadd m
1.90196 0 0 2.5 Mabsadd L
1.90196 0 1.875 0 Mabsadd L
1.90196 0 0 -2.5 Mabsadd L
1.90196 0 -1.875 0 Mabsadd L closepath F
1.91176 0 -1.875 0 Mabsadd m
1.91176 0 0 2.5 Mabsadd L
1.91176 0 1.875 0 Mabsadd L
1.91176 0 0 -2.5 Mabsadd L
1.91176 0 -1.875 0 Mabsadd L closepath F
1.92157 0 -1.875 0 Mabsadd m
1.92157 0 0 2.5 Mabsadd L
1.92157 0 1.875 0 Mabsadd L
1.92157 0 0 -2.5 Mabsadd L
1.92157 0 -1.875 0 Mabsadd L closepath F
1.93137 0 -1.875 0 Mabsadd m
1.93137 0 0 2.5 Mabsadd L
1.93137 0 1.875 0 Mabsadd L
1.93137 0 0 -2.5 Mabsadd L
1.93137 0 -1.875 0 Mabsadd L closepath F
1.94118 0 -1.875 0 Mabsadd m
1.94118 0 0 2.5 Mabsadd L
1.94118 0 1.875 0 Mabsadd L
1.94118 0 0 -2.5 Mabsadd L
1.94118 0 -1.875 0 Mabsadd L closepath F
1.95098 0 -1.875 0 Mabsadd m
1.95098 0 0 2.5 Mabsadd L
1.95098 0 1.875 0 Mabsadd L
1.95098 0 0 -2.5 Mabsadd L
1.95098 0 -1.875 0 Mabsadd L closepath F
1.96078 0 -1.875 0 Mabsadd m
1.96078 0 0 2.5 Mabsadd L
1.96078 0 1.875 0 Mabsadd L
1.96078 0 0 -2.5 Mabsadd L
1.96078 0 -1.875 0 Mabsadd L closepath F
1.97059 0 -1.875 0 Mabsadd m
1.97059 0 0 2.5 Mabsadd L
1.97059 0 1.875 0 Mabsadd L
1.97059 0 0 -2.5 Mabsadd L
1.97059 0 -1.875 0 Mabsadd L closepath F
1.98039 0 -1.875 0 Mabsadd m
1.98039 0 0 2.5 Mabsadd L
1.98039 0 1.875 0 Mabsadd L
1.98039 0 0 -2.5 Mabsadd L
1.98039 0 -1.875 0 Mabsadd L closepath F
1.9902 0 -1.875 0 Mabsadd m
1.9902 0 0 2.5 Mabsadd L
1.9902 0 1.875 0 Mabsadd L
1.9902 0 0 -2.5 Mabsadd L
1.9902 0 -1.875 0 Mabsadd L closepath F
2 0 -1.875 0 Mabsadd m
2 0 0 2.5 Mabsadd L
2 0 1.875 0 Mabsadd L
2 0 0 -2.5 Mabsadd L
2 0 -1.875 0 Mabsadd L closepath F
2.0098 0 -1.875 0 Mabsadd m
2.0098 0 0 2.5 Mabsadd L
2.0098 0 1.875 0 Mabsadd L
2.0098 0 0 -2.5 Mabsadd L
2.0098 0 -1.875 0 Mabsadd L closepath F
2.01961 0 -1.875 0 Mabsadd m
2.01961 0 0 2.5 Mabsadd L
2.01961 0 1.875 0 Mabsadd L
2.01961 0 0 -2.5 Mabsadd L
2.01961 0 -1.875 0 Mabsadd L closepath F
2.02941 0 -1.875 0 Mabsadd m
2.02941 0 0 2.5 Mabsadd L
2.02941 0 1.875 0 Mabsadd L
2.02941 0 0 -2.5 Mabsadd L
2.02941 0 -1.875 0 Mabsadd L closepath F
2.03922 0 -1.875 0 Mabsadd m
2.03922 0 0 2.5 Mabsadd L
2.03922 0 1.875 0 Mabsadd L
2.03922 0 0 -2.5 Mabsadd L
2.03922 0 -1.875 0 Mabsadd L closepath F
2.04902 0 -1.875 0 Mabsadd m
2.04902 0 0 2.5 Mabsadd L
2.04902 0 1.875 0 Mabsadd L
2.04902 0 0 -2.5 Mabsadd L
2.04902 0 -1.875 0 Mabsadd L closepath F
2.05882 0 -1.875 0 Mabsadd m
2.05882 0 0 2.5 Mabsadd L
2.05882 0 1.875 0 Mabsadd L
2.05882 0 0 -2.5 Mabsadd L
2.05882 0 -1.875 0 Mabsadd L closepath F
2.06863 0 -1.875 0 Mabsadd m
2.06863 0 0 2.5 Mabsadd L
2.06863 0 1.875 0 Mabsadd L
2.06863 0 0 -2.5 Mabsadd L
2.06863 0 -1.875 0 Mabsadd L closepath F
2.07843 0 -1.875 0 Mabsadd m
2.07843 0 0 2.5 Mabsadd L
2.07843 0 1.875 0 Mabsadd L
2.07843 0 0 -2.5 Mabsadd L
2.07843 0 -1.875 0 Mabsadd L closepath F
2.08824 0 -1.875 0 Mabsadd m
2.08824 0 0 2.5 Mabsadd L
2.08824 0 1.875 0 Mabsadd L
2.08824 0 0 -2.5 Mabsadd L
2.08824 0 -1.875 0 Mabsadd L closepath F
2.09804 0 -1.875 0 Mabsadd m
2.09804 0 0 2.5 Mabsadd L
2.09804 0 1.875 0 Mabsadd L
2.09804 0 0 -2.5 Mabsadd L
2.09804 0 -1.875 0 Mabsadd L closepath F
2.10784 0 -1.875 0 Mabsadd m
2.10784 0 0 2.5 Mabsadd L
2.10784 0 1.875 0 Mabsadd L
2.10784 0 0 -2.5 Mabsadd L
2.10784 0 -1.875 0 Mabsadd L closepath F
2.11765 0 -1.875 0 Mabsadd m
2.11765 0 0 2.5 Mabsadd L
2.11765 0 1.875 0 Mabsadd L
2.11765 0 0 -2.5 Mabsadd L
2.11765 0 -1.875 0 Mabsadd L closepath F
2.12745 0 -1.875 0 Mabsadd m
2.12745 0 0 2.5 Mabsadd L
2.12745 0 1.875 0 Mabsadd L
2.12745 0 0 -2.5 Mabsadd L
2.12745 0 -1.875 0 Mabsadd L closepath F
2.13725 0 -1.875 0 Mabsadd m
2.13725 0 0 2.5 Mabsadd L
2.13725 0 1.875 0 Mabsadd L
2.13725 0 0 -2.5 Mabsadd L
2.13725 0 -1.875 0 Mabsadd L closepath F
2.14706 0 -1.875 0 Mabsadd m
2.14706 0 0 2.5 Mabsadd L
2.14706 0 1.875 0 Mabsadd L
2.14706 0 0 -2.5 Mabsadd L
2.14706 0 -1.875 0 Mabsadd L closepath F
2.15686 0 -1.875 0 Mabsadd m
2.15686 0 0 2.5 Mabsadd L
2.15686 0 1.875 0 Mabsadd L
2.15686 0 0 -2.5 Mabsadd L
2.15686 0 -1.875 0 Mabsadd L closepath F
2.16667 0 -1.875 0 Mabsadd m
2.16667 0 0 2.5 Mabsadd L
2.16667 0 1.875 0 Mabsadd L
2.16667 0 0 -2.5 Mabsadd L
2.16667 0 -1.875 0 Mabsadd L closepath F
2.17647 0 -1.875 0 Mabsadd m
2.17647 0 0 2.5 Mabsadd L
2.17647 0 1.875 0 Mabsadd L
2.17647 0 0 -2.5 Mabsadd L
2.17647 0 -1.875 0 Mabsadd L closepath F
2.18627 0 -1.875 0 Mabsadd m
2.18627 0 0 2.5 Mabsadd L
2.18627 0 1.875 0 Mabsadd L
2.18627 0 0 -2.5 Mabsadd L
2.18627 0 -1.875 0 Mabsadd L closepath F
2.19608 0 -1.875 0 Mabsadd m
2.19608 0 0 2.5 Mabsadd L
2.19608 0 1.875 0 Mabsadd L
2.19608 0 0 -2.5 Mabsadd L
2.19608 0 -1.875 0 Mabsadd L closepath F
2.20588 0 -1.875 0 Mabsadd m
2.20588 0 0 2.5 Mabsadd L
2.20588 0 1.875 0 Mabsadd L
2.20588 0 0 -2.5 Mabsadd L
2.20588 0 -1.875 0 Mabsadd L closepath F
2.21569 0 -1.875 0 Mabsadd m
2.21569 0 0 2.5 Mabsadd L
2.21569 0 1.875 0 Mabsadd L
2.21569 0 0 -2.5 Mabsadd L
2.21569 0 -1.875 0 Mabsadd L closepath F
2.22549 0 -1.875 0 Mabsadd m
2.22549 0 0 2.5 Mabsadd L
2.22549 0 1.875 0 Mabsadd L
2.22549 0 0 -2.5 Mabsadd L
2.22549 0 -1.875 0 Mabsadd L closepath F
2.23529 0 -1.875 0 Mabsadd m
2.23529 0 0 2.5 Mabsadd L
2.23529 0 1.875 0 Mabsadd L
2.23529 0 0 -2.5 Mabsadd L
2.23529 0 -1.875 0 Mabsadd L closepath F
2.2451 0 -1.875 0 Mabsadd m
2.2451 0 0 2.5 Mabsadd L
2.2451 0 1.875 0 Mabsadd L
2.2451 0 0 -2.5 Mabsadd L
2.2451 0 -1.875 0 Mabsadd L closepath F
2.2549 0 -1.875 0 Mabsadd m
2.2549 0 0 2.5 Mabsadd L
2.2549 0 1.875 0 Mabsadd L
2.2549 0 0 -2.5 Mabsadd L
2.2549 0 -1.875 0 Mabsadd L closepath F
2.26471 0 -1.875 0 Mabsadd m
2.26471 0 0 2.5 Mabsadd L
2.26471 0 1.875 0 Mabsadd L
2.26471 0 0 -2.5 Mabsadd L
2.26471 0 -1.875 0 Mabsadd L closepath F
2.27451 0 -1.875 0 Mabsadd m
2.27451 0 0 2.5 Mabsadd L
2.27451 0 1.875 0 Mabsadd L
2.27451 0 0 -2.5 Mabsadd L
2.27451 0 -1.875 0 Mabsadd L closepath F
2.28431 0 -1.875 0 Mabsadd m
2.28431 0 0 2.5 Mabsadd L
2.28431 0 1.875 0 Mabsadd L
2.28431 0 0 -2.5 Mabsadd L
2.28431 0 -1.875 0 Mabsadd L closepath F
2.29412 0 -1.875 0 Mabsadd m
2.29412 0 0 2.5 Mabsadd L
2.29412 0 1.875 0 Mabsadd L
2.29412 0 0 -2.5 Mabsadd L
2.29412 0 -1.875 0 Mabsadd L closepath F
2.30392 0 -1.875 0 Mabsadd m
2.30392 0 0 2.5 Mabsadd L
2.30392 0 1.875 0 Mabsadd L
2.30392 0 0 -2.5 Mabsadd L
2.30392 0 -1.875 0 Mabsadd L closepath F
2.31373 0 -1.875 0 Mabsadd m
2.31373 0 0 2.5 Mabsadd L
2.31373 0 1.875 0 Mabsadd L
2.31373 0 0 -2.5 Mabsadd L
2.31373 0 -1.875 0 Mabsadd L closepath F
2.32353 0 -1.875 0 Mabsadd m
2.32353 0 0 2.5 Mabsadd L
2.32353 0 1.875 0 Mabsadd L
2.32353 0 0 -2.5 Mabsadd L
2.32353 0 -1.875 0 Mabsadd L closepath F
2.33333 0 -1.875 0 Mabsadd m
2.33333 0 0 2.5 Mabsadd L
2.33333 0 1.875 0 Mabsadd L
2.33333 0 0 -2.5 Mabsadd L
2.33333 0 -1.875 0 Mabsadd L closepath F
2.34314 0 -1.875 0 Mabsadd m
2.34314 0 0 2.5 Mabsadd L
2.34314 0 1.875 0 Mabsadd L
2.34314 0 0 -2.5 Mabsadd L
2.34314 0 -1.875 0 Mabsadd L closepath F
2.35294 0 -1.875 0 Mabsadd m
2.35294 0 0 2.5 Mabsadd L
2.35294 0 1.875 0 Mabsadd L
2.35294 0 0 -2.5 Mabsadd L
2.35294 0 -1.875 0 Mabsadd L closepath F
2.36275 0 -1.875 0 Mabsadd m
2.36275 0 0 2.5 Mabsadd L
2.36275 0 1.875 0 Mabsadd L
2.36275 0 0 -2.5 Mabsadd L
2.36275 0 -1.875 0 Mabsadd L closepath F
2.37255 0 -1.875 0 Mabsadd m
2.37255 0 0 2.5 Mabsadd L
2.37255 0 1.875 0 Mabsadd L
2.37255 0 0 -2.5 Mabsadd L
2.37255 0 -1.875 0 Mabsadd L closepath F
2.38235 0 -1.875 0 Mabsadd m
2.38235 0 0 2.5 Mabsadd L
2.38235 0 1.875 0 Mabsadd L
2.38235 0 0 -2.5 Mabsadd L
2.38235 0 -1.875 0 Mabsadd L closepath F
2.39216 0 -1.875 0 Mabsadd m
2.39216 0 0 2.5 Mabsadd L
2.39216 0 1.875 0 Mabsadd L
2.39216 0 0 -2.5 Mabsadd L
2.39216 0 -1.875 0 Mabsadd L closepath F
2.40196 0 -1.875 0 Mabsadd m
2.40196 0 0 2.5 Mabsadd L
2.40196 0 1.875 0 Mabsadd L
2.40196 0 0 -2.5 Mabsadd L
2.40196 0 -1.875 0 Mabsadd L closepath F
2.41176 0 -1.875 0 Mabsadd m
2.41176 0 0 2.5 Mabsadd L
2.41176 0 1.875 0 Mabsadd L
2.41176 0 0 -2.5 Mabsadd L
2.41176 0 -1.875 0 Mabsadd L closepath F
2.42157 0 -1.875 0 Mabsadd m
2.42157 0 0 2.5 Mabsadd L
2.42157 0 1.875 0 Mabsadd L
2.42157 0 0 -2.5 Mabsadd L
2.42157 0 -1.875 0 Mabsadd L closepath F
2.43137 0 -1.875 0 Mabsadd m
2.43137 0 0 2.5 Mabsadd L
2.43137 0 1.875 0 Mabsadd L
2.43137 0 0 -2.5 Mabsadd L
2.43137 0 -1.875 0 Mabsadd L closepath F
2.44118 0 -1.875 0 Mabsadd m
2.44118 0 0 2.5 Mabsadd L
2.44118 0 1.875 0 Mabsadd L
2.44118 0 0 -2.5 Mabsadd L
2.44118 0 -1.875 0 Mabsadd L closepath F
2.45098 0 -1.875 0 Mabsadd m
2.45098 0 0 2.5 Mabsadd L
2.45098 0 1.875 0 Mabsadd L
2.45098 0 0 -2.5 Mabsadd L
2.45098 0 -1.875 0 Mabsadd L closepath F
2.46078 0 -1.875 0 Mabsadd m
2.46078 0 0 2.5 Mabsadd L
2.46078 0 1.875 0 Mabsadd L
2.46078 0 0 -2.5 Mabsadd L
2.46078 0 -1.875 0 Mabsadd L closepath F
2.47059 0 -1.875 0 Mabsadd m
2.47059 0 0 2.5 Mabsadd L
2.47059 0 1.875 0 Mabsadd L
2.47059 0 0 -2.5 Mabsadd L
2.47059 0 -1.875 0 Mabsadd L closepath F
2.48039 0 -1.875 0 Mabsadd m
2.48039 0 0 2.5 Mabsadd L
2.48039 0 1.875 0 Mabsadd L
2.48039 0 0 -2.5 Mabsadd L
2.48039 0 -1.875 0 Mabsadd L closepath F
2.4902 0 -1.875 0 Mabsadd m
2.4902 0 0 2.5 Mabsadd L
2.4902 0 1.875 0 Mabsadd L
2.4902 0 0 -2.5 Mabsadd L
2.4902 0 -1.875 0 Mabsadd L closepath F
2.5 0 -1.875 0 Mabsadd m
2.5 0 0 2.5 Mabsadd L
2.5 0 1.875 0 Mabsadd L
2.5 0 0 -2.5 Mabsadd L
2.5 0 -1.875 0 Mabsadd L closepath F
0 1 1 r
.001 w
0 .61803 m
.0098 .61756 L
.01961 .61614 L
.02941 .61377 L
.03922 .61048 L
.04902 .60627 L
.05882 .60116 L
.06863 .59518 L
.07843 .58836 L
.08824 .58071 L
.09804 .57229 L
.10784 .56313 L
.11765 .55325 L
.12745 .54272 L
.13725 .53157 L
.14706 .51985 L
.15686 .5076 L
.16667 .49488 L
.17647 .48174 L
.18627 .46823 L
.19608 .4544 L
.20588 .44029 L
.21569 .42597 L
.22549 .41149 L
.23529 .39688 L
.2451 .38221 L
.2549 .36751 L
.26471 .35283 L
.27451 .33822 L
.28431 .32372 L
.29412 .30936 L
.30392 .29518 L
.31373 .28122 L
.32353 .26751 L
.33333 .25408 L
.34314 .24095 L
.35294 .22815 L
.36275 .2157 L
.37255 .20361 L
.38235 .1919 L
.39216 .18059 L
.40196 .16969 L
.41176 .1592 L
.42157 .14912 L
.43137 .13947 L
.44118 .13025 L
.45098 .12145 L
.46078 .11307 L
.47059 .1051 L
.48039 .09755 L
Mistroke
.4902 .0904 L
.5 .08364 L
.5098 .07727 L
.51961 .07128 L
.52941 .06565 L
.53922 .06037 L
.54902 .05543 L
.55882 .05082 L
.56863 .04652 L
.57843 .04252 L
.58824 .0388 L
.59804 .03535 L
.60784 .03216 L
.61765 .02921 L
.62745 .0265 L
.63725 .02399 L
.64706 .02169 L
.65686 .01959 L
.66667 .01765 L
.67647 .01589 L
.68627 .01428 L
.69608 .01281 L
.70588 .01148 L
.71569 .01027 L
.72549 .00917 L
.73529 .00818 L
.7451 .00728 L
.7549 .00647 L
.76471 .00575 L
.77451 .00509 L
.78431 .00451 L
.79412 .00398 L
.80392 .00351 L
.81373 .00309 L
.82353 .00272 L
.83333 .00239 L
.84314 .00209 L
.85294 .00183 L
.86275 .0016 L
.87255 .0014 L
.88235 .00122 L
.89216 .00106 L
.90196 .00092 L
.91176 .0008 L
.92157 .00069 L
.93137 .0006 L
.94118 .00052 L
.95098 .00045 L
.96078 .00038 L
.97059 .00033 L
Mistroke
.98039 .00028 L
.9902 .00024 L
1 .00021 L
Mfstroke
1 .00021 m
1 .00021 L
s
0 g
.0001 w
0 .61803 0 2.5 Mabsadd m
0 .61803 -0.56518 .7779 Mabsadd L
0 .61803 -2.37764 .77254 Mabsadd L
0 .61803 -0.91448 -0.29713 Mabsadd L
0 .61803 -1.46946 -2.02254 Mabsadd L
0 .61803 0 -0.96154 Mabsadd L
0 .61803 1.46946 -2.02254 Mabsadd L
0 .61803 .91448 -0.29713 Mabsadd L
0 .61803 2.37764 .77254 Mabsadd L
0 .61803 .56518 .7779 Mabsadd L
0 .61803 0 2.5 Mabsadd L closepath F
.0098 .61756 0 2.5 Mabsadd m
.0098 .61756 -0.56518 .7779 Mabsadd L
.0098 .61756 -2.37764 .77254 Mabsadd L
.0098 .61756 -0.91448 -0.29713 Mabsadd L
.0098 .61756 -1.46946 -2.02254 Mabsadd L
.0098 .61756 0 -0.96154 Mabsadd L
.0098 .61756 1.46946 -2.02254 Mabsadd L
.0098 .61756 .91448 -0.29713 Mabsadd L
.0098 .61756 2.37764 .77254 Mabsadd L
.0098 .61756 .56518 .7779 Mabsadd L
.0098 .61756 0 2.5 Mabsadd L closepath F
.01961 .61614 0 2.5 Mabsadd m
.01961 .61614 -0.56518 .7779 Mabsadd L
.01961 .61614 -2.37764 .77254 Mabsadd L
.01961 .61614 -0.91448 -0.29713 Mabsadd L
.01961 .61614 -1.46946 -2.02254 Mabsadd L
.01961 .61614 0 -0.96154 Mabsadd L
.01961 .61614 1.46946 -2.02254 Mabsadd L
.01961 .61614 .91448 -0.29713 Mabsadd L
.01961 .61614 2.37764 .77254 Mabsadd L
.01961 .61614 .56518 .7779 Mabsadd L
.01961 .61614 0 2.5 Mabsadd L closepath F
.02941 .61377 0 2.5 Mabsadd m
.02941 .61377 -0.56518 .7779 Mabsadd L
.02941 .61377 -2.37764 .77254 Mabsadd L
.02941 .61377 -0.91448 -0.29713 Mabsadd L
.02941 .61377 -1.46946 -2.02254 Mabsadd L
.02941 .61377 0 -0.96154 Mabsadd L
.02941 .61377 1.46946 -2.02254 Mabsadd L
.02941 .61377 .91448 -0.29713 Mabsadd L
.02941 .61377 2.37764 .77254 Mabsadd L
.02941 .61377 .56518 .7779 Mabsadd L
.02941 .61377 0 2.5 Mabsadd L closepath F
.03922 .61048 0 2.5 Mabsadd m
.03922 .61048 -0.56518 .7779 Mabsadd L
.03922 .61048 -2.37764 .77254 Mabsadd L
.03922 .61048 -0.91448 -0.29713 Mabsadd L
.03922 .61048 -1.46946 -2.02254 Mabsadd L
.03922 .61048 0 -0.96154 Mabsadd L
.03922 .61048 1.46946 -2.02254 Mabsadd L
.03922 .61048 .91448 -0.29713 Mabsadd L
.03922 .61048 2.37764 .77254 Mabsadd L
.03922 .61048 .56518 .7779 Mabsadd L
.03922 .61048 0 2.5 Mabsadd L closepath F
.04902 .60627 0 2.5 Mabsadd m
.04902 .60627 -0.56518 .7779 Mabsadd L
.04902 .60627 -2.37764 .77254 Mabsadd L
.04902 .60627 -0.91448 -0.29713 Mabsadd L
.04902 .60627 -1.46946 -2.02254 Mabsadd L
.04902 .60627 0 -0.96154 Mabsadd L
.04902 .60627 1.46946 -2.02254 Mabsadd L
.04902 .60627 .91448 -0.29713 Mabsadd L
.04902 .60627 2.37764 .77254 Mabsadd L
.04902 .60627 .56518 .7779 Mabsadd L
.04902 .60627 0 2.5 Mabsadd L closepath F
.05882 .60116 0 2.5 Mabsadd m
.05882 .60116 -0.56518 .7779 Mabsadd L
.05882 .60116 -2.37764 .77254 Mabsadd L
.05882 .60116 -0.91448 -0.29713 Mabsadd L
.05882 .60116 -1.46946 -2.02254 Mabsadd L
.05882 .60116 0 -0.96154 Mabsadd L
.05882 .60116 1.46946 -2.02254 Mabsadd L
.05882 .60116 .91448 -0.29713 Mabsadd L
.05882 .60116 2.37764 .77254 Mabsadd L
.05882 .60116 .56518 .7779 Mabsadd L
.05882 .60116 0 2.5 Mabsadd L closepath F
.06863 .59518 0 2.5 Mabsadd m
.06863 .59518 -0.56518 .7779 Mabsadd L
.06863 .59518 -2.37764 .77254 Mabsadd L
.06863 .59518 -0.91448 -0.29713 Mabsadd L
.06863 .59518 -1.46946 -2.02254 Mabsadd L
.06863 .59518 0 -0.96154 Mabsadd L
.06863 .59518 1.46946 -2.02254 Mabsadd L
.06863 .59518 .91448 -0.29713 Mabsadd L
.06863 .59518 2.37764 .77254 Mabsadd L
.06863 .59518 .56518 .7779 Mabsadd L
.06863 .59518 0 2.5 Mabsadd L closepath F
.07843 .58836 0 2.5 Mabsadd m
.07843 .58836 -0.56518 .7779 Mabsadd L
.07843 .58836 -2.37764 .77254 Mabsadd L
.07843 .58836 -0.91448 -0.29713 Mabsadd L
.07843 .58836 -1.46946 -2.02254 Mabsadd L
.07843 .58836 0 -0.96154 Mabsadd L
.07843 .58836 1.46946 -2.02254 Mabsadd L
.07843 .58836 .91448 -0.29713 Mabsadd L
.07843 .58836 2.37764 .77254 Mabsadd L
.07843 .58836 .56518 .7779 Mabsadd L
.07843 .58836 0 2.5 Mabsadd L closepath F
.08824 .58071 0 2.5 Mabsadd m
.08824 .58071 -0.56518 .7779 Mabsadd L
.08824 .58071 -2.37764 .77254 Mabsadd L
.08824 .58071 -0.91448 -0.29713 Mabsadd L
.08824 .58071 -1.46946 -2.02254 Mabsadd L
.08824 .58071 0 -0.96154 Mabsadd L
.08824 .58071 1.46946 -2.02254 Mabsadd L
.08824 .58071 .91448 -0.29713 Mabsadd L
.08824 .58071 2.37764 .77254 Mabsadd L
.08824 .58071 .56518 .7779 Mabsadd L
.08824 .58071 0 2.5 Mabsadd L closepath F
.09804 .57229 0 2.5 Mabsadd m
.09804 .57229 -0.56518 .7779 Mabsadd L
.09804 .57229 -2.37764 .77254 Mabsadd L
.09804 .57229 -0.91448 -0.29713 Mabsadd L
.09804 .57229 -1.46946 -2.02254 Mabsadd L
.09804 .57229 0 -0.96154 Mabsadd L
.09804 .57229 1.46946 -2.02254 Mabsadd L
.09804 .57229 .91448 -0.29713 Mabsadd L
.09804 .57229 2.37764 .77254 Mabsadd L
.09804 .57229 .56518 .7779 Mabsadd L
.09804 .57229 0 2.5 Mabsadd L closepath F
.10784 .56313 0 2.5 Mabsadd m
.10784 .56313 -0.56518 .7779 Mabsadd L
.10784 .56313 -2.37764 .77254 Mabsadd L
.10784 .56313 -0.91448 -0.29713 Mabsadd L
.10784 .56313 -1.46946 -2.02254 Mabsadd L
.10784 .56313 0 -0.96154 Mabsadd L
.10784 .56313 1.46946 -2.02254 Mabsadd L
.10784 .56313 .91448 -0.29713 Mabsadd L
.10784 .56313 2.37764 .77254 Mabsadd L
.10784 .56313 .56518 .7779 Mabsadd L
.10784 .56313 0 2.5 Mabsadd L closepath F
.11765 .55325 0 2.5 Mabsadd m
.11765 .55325 -0.56518 .7779 Mabsadd L
.11765 .55325 -2.37764 .77254 Mabsadd L
.11765 .55325 -0.91448 -0.29713 Mabsadd L
.11765 .55325 -1.46946 -2.02254 Mabsadd L
.11765 .55325 0 -0.96154 Mabsadd L
.11765 .55325 1.46946 -2.02254 Mabsadd L
.11765 .55325 .91448 -0.29713 Mabsadd L
.11765 .55325 2.37764 .77254 Mabsadd L
.11765 .55325 .56518 .7779 Mabsadd L
.11765 .55325 0 2.5 Mabsadd L closepath F
.12745 .54272 0 2.5 Mabsadd m
.12745 .54272 -0.56518 .7779 Mabsadd L
.12745 .54272 -2.37764 .77254 Mabsadd L
.12745 .54272 -0.91448 -0.29713 Mabsadd L
.12745 .54272 -1.46946 -2.02254 Mabsadd L
.12745 .54272 0 -0.96154 Mabsadd L
.12745 .54272 1.46946 -2.02254 Mabsadd L
.12745 .54272 .91448 -0.29713 Mabsadd L
.12745 .54272 2.37764 .77254 Mabsadd L
.12745 .54272 .56518 .7779 Mabsadd L
.12745 .54272 0 2.5 Mabsadd L closepath F
.13725 .53157 0 2.5 Mabsadd m
.13725 .53157 -0.56518 .7779 Mabsadd L
.13725 .53157 -2.37764 .77254 Mabsadd L
.13725 .53157 -0.91448 -0.29713 Mabsadd L
.13725 .53157 -1.46946 -2.02254 Mabsadd L
.13725 .53157 0 -0.96154 Mabsadd L
.13725 .53157 1.46946 -2.02254 Mabsadd L
.13725 .53157 .91448 -0.29713 Mabsadd L
.13725 .53157 2.37764 .77254 Mabsadd L
.13725 .53157 .56518 .7779 Mabsadd L
.13725 .53157 0 2.5 Mabsadd L closepath F
.14706 .51985 0 2.5 Mabsadd m
.14706 .51985 -0.56518 .7779 Mabsadd L
.14706 .51985 -2.37764 .77254 Mabsadd L
.14706 .51985 -0.91448 -0.29713 Mabsadd L
.14706 .51985 -1.46946 -2.02254 Mabsadd L
.14706 .51985 0 -0.96154 Mabsadd L
.14706 .51985 1.46946 -2.02254 Mabsadd L
.14706 .51985 .91448 -0.29713 Mabsadd L
.14706 .51985 2.37764 .77254 Mabsadd L
.14706 .51985 .56518 .7779 Mabsadd L
.14706 .51985 0 2.5 Mabsadd L closepath F
.15686 .5076 0 2.5 Mabsadd m
.15686 .5076 -0.56518 .7779 Mabsadd L
.15686 .5076 -2.37764 .77254 Mabsadd L
.15686 .5076 -0.91448 -0.29713 Mabsadd L
.15686 .5076 -1.46946 -2.02254 Mabsadd L
.15686 .5076 0 -0.96154 Mabsadd L
.15686 .5076 1.46946 -2.02254 Mabsadd L
.15686 .5076 .91448 -0.29713 Mabsadd L
.15686 .5076 2.37764 .77254 Mabsadd L
.15686 .5076 .56518 .7779 Mabsadd L
.15686 .5076 0 2.5 Mabsadd L closepath F
.16667 .49488 0 2.5 Mabsadd m
.16667 .49488 -0.56518 .7779 Mabsadd L
.16667 .49488 -2.37764 .77254 Mabsadd L
.16667 .49488 -0.91448 -0.29713 Mabsadd L
.16667 .49488 -1.46946 -2.02254 Mabsadd L
.16667 .49488 0 -0.96154 Mabsadd L
.16667 .49488 1.46946 -2.02254 Mabsadd L
.16667 .49488 .91448 -0.29713 Mabsadd L
.16667 .49488 2.37764 .77254 Mabsadd L
.16667 .49488 .56518 .7779 Mabsadd L
.16667 .49488 0 2.5 Mabsadd L closepath F
.17647 .48174 0 2.5 Mabsadd m
.17647 .48174 -0.56518 .7779 Mabsadd L
.17647 .48174 -2.37764 .77254 Mabsadd L
.17647 .48174 -0.91448 -0.29713 Mabsadd L
.17647 .48174 -1.46946 -2.02254 Mabsadd L
.17647 .48174 0 -0.96154 Mabsadd L
.17647 .48174 1.46946 -2.02254 Mabsadd L
.17647 .48174 .91448 -0.29713 Mabsadd L
.17647 .48174 2.37764 .77254 Mabsadd L
.17647 .48174 .56518 .7779 Mabsadd L
.17647 .48174 0 2.5 Mabsadd L closepath F
.18627 .46823 0 2.5 Mabsadd m
.18627 .46823 -0.56518 .7779 Mabsadd L
.18627 .46823 -2.37764 .77254 Mabsadd L
.18627 .46823 -0.91448 -0.29713 Mabsadd L
.18627 .46823 -1.46946 -2.02254 Mabsadd L
.18627 .46823 0 -0.96154 Mabsadd L
.18627 .46823 1.46946 -2.02254 Mabsadd L
.18627 .46823 .91448 -0.29713 Mabsadd L
.18627 .46823 2.37764 .77254 Mabsadd L
.18627 .46823 .56518 .7779 Mabsadd L
.18627 .46823 0 2.5 Mabsadd L closepath F
.19608 .4544 0 2.5 Mabsadd m
.19608 .4544 -0.56518 .7779 Mabsadd L
.19608 .4544 -2.37764 .77254 Mabsadd L
.19608 .4544 -0.91448 -0.29713 Mabsadd L
.19608 .4544 -1.46946 -2.02254 Mabsadd L
.19608 .4544 0 -0.96154 Mabsadd L
.19608 .4544 1.46946 -2.02254 Mabsadd L
.19608 .4544 .91448 -0.29713 Mabsadd L
.19608 .4544 2.37764 .77254 Mabsadd L
.19608 .4544 .56518 .7779 Mabsadd L
.19608 .4544 0 2.5 Mabsadd L closepath F
.20588 .44029 0 2.5 Mabsadd m
.20588 .44029 -0.56518 .7779 Mabsadd L
.20588 .44029 -2.37764 .77254 Mabsadd L
.20588 .44029 -0.91448 -0.29713 Mabsadd L
.20588 .44029 -1.46946 -2.02254 Mabsadd L
.20588 .44029 0 -0.96154 Mabsadd L
.20588 .44029 1.46946 -2.02254 Mabsadd L
.20588 .44029 .91448 -0.29713 Mabsadd L
.20588 .44029 2.37764 .77254 Mabsadd L
.20588 .44029 .56518 .7779 Mabsadd L
.20588 .44029 0 2.5 Mabsadd L closepath F
.21569 .42597 0 2.5 Mabsadd m
.21569 .42597 -0.56518 .7779 Mabsadd L
.21569 .42597 -2.37764 .77254 Mabsadd L
.21569 .42597 -0.91448 -0.29713 Mabsadd L
.21569 .42597 -1.46946 -2.02254 Mabsadd L
.21569 .42597 0 -0.96154 Mabsadd L
.21569 .42597 1.46946 -2.02254 Mabsadd L
.21569 .42597 .91448 -0.29713 Mabsadd L
.21569 .42597 2.37764 .77254 Mabsadd L
.21569 .42597 .56518 .7779 Mabsadd L
.21569 .42597 0 2.5 Mabsadd L closepath F
.22549 .41149 0 2.5 Mabsadd m
.22549 .41149 -0.56518 .7779 Mabsadd L
.22549 .41149 -2.37764 .77254 Mabsadd L
.22549 .41149 -0.91448 -0.29713 Mabsadd L
.22549 .41149 -1.46946 -2.02254 Mabsadd L
.22549 .41149 0 -0.96154 Mabsadd L
.22549 .41149 1.46946 -2.02254 Mabsadd L
.22549 .41149 .91448 -0.29713 Mabsadd L
.22549 .41149 2.37764 .77254 Mabsadd L
.22549 .41149 .56518 .7779 Mabsadd L
.22549 .41149 0 2.5 Mabsadd L closepath F
.23529 .39688 0 2.5 Mabsadd m
.23529 .39688 -0.56518 .7779 Mabsadd L
.23529 .39688 -2.37764 .77254 Mabsadd L
.23529 .39688 -0.91448 -0.29713 Mabsadd L
.23529 .39688 -1.46946 -2.02254 Mabsadd L
.23529 .39688 0 -0.96154 Mabsadd L
.23529 .39688 1.46946 -2.02254 Mabsadd L
.23529 .39688 .91448 -0.29713 Mabsadd L
.23529 .39688 2.37764 .77254 Mabsadd L
.23529 .39688 .56518 .7779 Mabsadd L
.23529 .39688 0 2.5 Mabsadd L closepath F
.2451 .38221 0 2.5 Mabsadd m
.2451 .38221 -0.56518 .7779 Mabsadd L
.2451 .38221 -2.37764 .77254 Mabsadd L
.2451 .38221 -0.91448 -0.29713 Mabsadd L
.2451 .38221 -1.46946 -2.02254 Mabsadd L
.2451 .38221 0 -0.96154 Mabsadd L
.2451 .38221 1.46946 -2.02254 Mabsadd L
.2451 .38221 .91448 -0.29713 Mabsadd L
.2451 .38221 2.37764 .77254 Mabsadd L
.2451 .38221 .56518 .7779 Mabsadd L
.2451 .38221 0 2.5 Mabsadd L closepath F
.2549 .36751 0 2.5 Mabsadd m
.2549 .36751 -0.56518 .7779 Mabsadd L
.2549 .36751 -2.37764 .77254 Mabsadd L
.2549 .36751 -0.91448 -0.29713 Mabsadd L
.2549 .36751 -1.46946 -2.02254 Mabsadd L
.2549 .36751 0 -0.96154 Mabsadd L
.2549 .36751 1.46946 -2.02254 Mabsadd L
.2549 .36751 .91448 -0.29713 Mabsadd L
.2549 .36751 2.37764 .77254 Mabsadd L
.2549 .36751 .56518 .7779 Mabsadd L
.2549 .36751 0 2.5 Mabsadd L closepath F
.26471 .35283 0 2.5 Mabsadd m
.26471 .35283 -0.56518 .7779 Mabsadd L
.26471 .35283 -2.37764 .77254 Mabsadd L
.26471 .35283 -0.91448 -0.29713 Mabsadd L
.26471 .35283 -1.46946 -2.02254 Mabsadd L
.26471 .35283 0 -0.96154 Mabsadd L
.26471 .35283 1.46946 -2.02254 Mabsadd L
.26471 .35283 .91448 -0.29713 Mabsadd L
.26471 .35283 2.37764 .77254 Mabsadd L
.26471 .35283 .56518 .7779 Mabsadd L
.26471 .35283 0 2.5 Mabsadd L closepath F
.27451 .33822 0 2.5 Mabsadd m
.27451 .33822 -0.56518 .7779 Mabsadd L
.27451 .33822 -2.37764 .77254 Mabsadd L
.27451 .33822 -0.91448 -0.29713 Mabsadd L
.27451 .33822 -1.46946 -2.02254 Mabsadd L
.27451 .33822 0 -0.96154 Mabsadd L
.27451 .33822 1.46946 -2.02254 Mabsadd L
.27451 .33822 .91448 -0.29713 Mabsadd L
.27451 .33822 2.37764 .77254 Mabsadd L
.27451 .33822 .56518 .7779 Mabsadd L
.27451 .33822 0 2.5 Mabsadd L closepath F
.28431 .32372 0 2.5 Mabsadd m
.28431 .32372 -0.56518 .7779 Mabsadd L
.28431 .32372 -2.37764 .77254 Mabsadd L
.28431 .32372 -0.91448 -0.29713 Mabsadd L
.28431 .32372 -1.46946 -2.02254 Mabsadd L
.28431 .32372 0 -0.96154 Mabsadd L
.28431 .32372 1.46946 -2.02254 Mabsadd L
.28431 .32372 .91448 -0.29713 Mabsadd L
.28431 .32372 2.37764 .77254 Mabsadd L
.28431 .32372 .56518 .7779 Mabsadd L
.28431 .32372 0 2.5 Mabsadd L closepath F
.29412 .30936 0 2.5 Mabsadd m
.29412 .30936 -0.56518 .7779 Mabsadd L
.29412 .30936 -2.37764 .77254 Mabsadd L
.29412 .30936 -0.91448 -0.29713 Mabsadd L
.29412 .30936 -1.46946 -2.02254 Mabsadd L
.29412 .30936 0 -0.96154 Mabsadd L
.29412 .30936 1.46946 -2.02254 Mabsadd L
.29412 .30936 .91448 -0.29713 Mabsadd L
.29412 .30936 2.37764 .77254 Mabsadd L
.29412 .30936 .56518 .7779 Mabsadd L
.29412 .30936 0 2.5 Mabsadd L closepath F
.30392 .29518 0 2.5 Mabsadd m
.30392 .29518 -0.56518 .7779 Mabsadd L
.30392 .29518 -2.37764 .77254 Mabsadd L
.30392 .29518 -0.91448 -0.29713 Mabsadd L
.30392 .29518 -1.46946 -2.02254 Mabsadd L
.30392 .29518 0 -0.96154 Mabsadd L
.30392 .29518 1.46946 -2.02254 Mabsadd L
.30392 .29518 .91448 -0.29713 Mabsadd L
.30392 .29518 2.37764 .77254 Mabsadd L
.30392 .29518 .56518 .7779 Mabsadd L
.30392 .29518 0 2.5 Mabsadd L closepath F
.31373 .28122 0 2.5 Mabsadd m
.31373 .28122 -0.56518 .7779 Mabsadd L
.31373 .28122 -2.37764 .77254 Mabsadd L
.31373 .28122 -0.91448 -0.29713 Mabsadd L
.31373 .28122 -1.46946 -2.02254 Mabsadd L
.31373 .28122 0 -0.96154 Mabsadd L
.31373 .28122 1.46946 -2.02254 Mabsadd L
.31373 .28122 .91448 -0.29713 Mabsadd L
.31373 .28122 2.37764 .77254 Mabsadd L
.31373 .28122 .56518 .7779 Mabsadd L
.31373 .28122 0 2.5 Mabsadd L closepath F
.32353 .26751 0 2.5 Mabsadd m
.32353 .26751 -0.56518 .7779 Mabsadd L
.32353 .26751 -2.37764 .77254 Mabsadd L
.32353 .26751 -0.91448 -0.29713 Mabsadd L
.32353 .26751 -1.46946 -2.02254 Mabsadd L
.32353 .26751 0 -0.96154 Mabsadd L
.32353 .26751 1.46946 -2.02254 Mabsadd L
.32353 .26751 .91448 -0.29713 Mabsadd L
.32353 .26751 2.37764 .77254 Mabsadd L
.32353 .26751 .56518 .7779 Mabsadd L
.32353 .26751 0 2.5 Mabsadd L closepath F
.33333 .25408 0 2.5 Mabsadd m
.33333 .25408 -0.56518 .7779 Mabsadd L
.33333 .25408 -2.37764 .77254 Mabsadd L
.33333 .25408 -0.91448 -0.29713 Mabsadd L
.33333 .25408 -1.46946 -2.02254 Mabsadd L
.33333 .25408 0 -0.96154 Mabsadd L
.33333 .25408 1.46946 -2.02254 Mabsadd L
.33333 .25408 .91448 -0.29713 Mabsadd L
.33333 .25408 2.37764 .77254 Mabsadd L
.33333 .25408 .56518 .7779 Mabsadd L
.33333 .25408 0 2.5 Mabsadd L closepath F
.34314 .24095 0 2.5 Mabsadd m
.34314 .24095 -0.56518 .7779 Mabsadd L
.34314 .24095 -2.37764 .77254 Mabsadd L
.34314 .24095 -0.91448 -0.29713 Mabsadd L
.34314 .24095 -1.46946 -2.02254 Mabsadd L
.34314 .24095 0 -0.96154 Mabsadd L
.34314 .24095 1.46946 -2.02254 Mabsadd L
.34314 .24095 .91448 -0.29713 Mabsadd L
.34314 .24095 2.37764 .77254 Mabsadd L
.34314 .24095 .56518 .7779 Mabsadd L
.34314 .24095 0 2.5 Mabsadd L closepath F
.35294 .22815 0 2.5 Mabsadd m
.35294 .22815 -0.56518 .7779 Mabsadd L
.35294 .22815 -2.37764 .77254 Mabsadd L
.35294 .22815 -0.91448 -0.29713 Mabsadd L
.35294 .22815 -1.46946 -2.02254 Mabsadd L
.35294 .22815 0 -0.96154 Mabsadd L
.35294 .22815 1.46946 -2.02254 Mabsadd L
.35294 .22815 .91448 -0.29713 Mabsadd L
.35294 .22815 2.37764 .77254 Mabsadd L
.35294 .22815 .56518 .7779 Mabsadd L
.35294 .22815 0 2.5 Mabsadd L closepath F
.36275 .2157 0 2.5 Mabsadd m
.36275 .2157 -0.56518 .7779 Mabsadd L
.36275 .2157 -2.37764 .77254 Mabsadd L
.36275 .2157 -0.91448 -0.29713 Mabsadd L
.36275 .2157 -1.46946 -2.02254 Mabsadd L
.36275 .2157 0 -0.96154 Mabsadd L
.36275 .2157 1.46946 -2.02254 Mabsadd L
.36275 .2157 .91448 -0.29713 Mabsadd L
.36275 .2157 2.37764 .77254 Mabsadd L
.36275 .2157 .56518 .7779 Mabsadd L
.36275 .2157 0 2.5 Mabsadd L closepath F
.37255 .20361 0 2.5 Mabsadd m
.37255 .20361 -0.56518 .7779 Mabsadd L
.37255 .20361 -2.37764 .77254 Mabsadd L
.37255 .20361 -0.91448 -0.29713 Mabsadd L
.37255 .20361 -1.46946 -2.02254 Mabsadd L
.37255 .20361 0 -0.96154 Mabsadd L
.37255 .20361 1.46946 -2.02254 Mabsadd L
.37255 .20361 .91448 -0.29713 Mabsadd L
.37255 .20361 2.37764 .77254 Mabsadd L
.37255 .20361 .56518 .7779 Mabsadd L
.37255 .20361 0 2.5 Mabsadd L closepath F
.38235 .1919 0 2.5 Mabsadd m
.38235 .1919 -0.56518 .7779 Mabsadd L
.38235 .1919 -2.37764 .77254 Mabsadd L
.38235 .1919 -0.91448 -0.29713 Mabsadd L
.38235 .1919 -1.46946 -2.02254 Mabsadd L
.38235 .1919 0 -0.96154 Mabsadd L
.38235 .1919 1.46946 -2.02254 Mabsadd L
.38235 .1919 .91448 -0.29713 Mabsadd L
.38235 .1919 2.37764 .77254 Mabsadd L
.38235 .1919 .56518 .7779 Mabsadd L
.38235 .1919 0 2.5 Mabsadd L closepath F
.39216 .18059 0 2.5 Mabsadd m
.39216 .18059 -0.56518 .7779 Mabsadd L
.39216 .18059 -2.37764 .77254 Mabsadd L
.39216 .18059 -0.91448 -0.29713 Mabsadd L
.39216 .18059 -1.46946 -2.02254 Mabsadd L
.39216 .18059 0 -0.96154 Mabsadd L
.39216 .18059 1.46946 -2.02254 Mabsadd L
.39216 .18059 .91448 -0.29713 Mabsadd L
.39216 .18059 2.37764 .77254 Mabsadd L
.39216 .18059 .56518 .7779 Mabsadd L
.39216 .18059 0 2.5 Mabsadd L closepath F
.40196 .16969 0 2.5 Mabsadd m
.40196 .16969 -0.56518 .7779 Mabsadd L
.40196 .16969 -2.37764 .77254 Mabsadd L
.40196 .16969 -0.91448 -0.29713 Mabsadd L
.40196 .16969 -1.46946 -2.02254 Mabsadd L
.40196 .16969 0 -0.96154 Mabsadd L
.40196 .16969 1.46946 -2.02254 Mabsadd L
.40196 .16969 .91448 -0.29713 Mabsadd L
.40196 .16969 2.37764 .77254 Mabsadd L
.40196 .16969 .56518 .7779 Mabsadd L
.40196 .16969 0 2.5 Mabsadd L closepath F
.41176 .1592 0 2.5 Mabsadd m
.41176 .1592 -0.56518 .7779 Mabsadd L
.41176 .1592 -2.37764 .77254 Mabsadd L
.41176 .1592 -0.91448 -0.29713 Mabsadd L
.41176 .1592 -1.46946 -2.02254 Mabsadd L
.41176 .1592 0 -0.96154 Mabsadd L
.41176 .1592 1.46946 -2.02254 Mabsadd L
.41176 .1592 .91448 -0.29713 Mabsadd L
.41176 .1592 2.37764 .77254 Mabsadd L
.41176 .1592 .56518 .7779 Mabsadd L
.41176 .1592 0 2.5 Mabsadd L closepath F
.42157 .14912 0 2.5 Mabsadd m
.42157 .14912 -0.56518 .7779 Mabsadd L
.42157 .14912 -2.37764 .77254 Mabsadd L
.42157 .14912 -0.91448 -0.29713 Mabsadd L
.42157 .14912 -1.46946 -2.02254 Mabsadd L
.42157 .14912 0 -0.96154 Mabsadd L
.42157 .14912 1.46946 -2.02254 Mabsadd L
.42157 .14912 .91448 -0.29713 Mabsadd L
.42157 .14912 2.37764 .77254 Mabsadd L
.42157 .14912 .56518 .7779 Mabsadd L
.42157 .14912 0 2.5 Mabsadd L closepath F
.43137 .13947 0 2.5 Mabsadd m
.43137 .13947 -0.56518 .7779 Mabsadd L
.43137 .13947 -2.37764 .77254 Mabsadd L
.43137 .13947 -0.91448 -0.29713 Mabsadd L
.43137 .13947 -1.46946 -2.02254 Mabsadd L
.43137 .13947 0 -0.96154 Mabsadd L
.43137 .13947 1.46946 -2.02254 Mabsadd L
.43137 .13947 .91448 -0.29713 Mabsadd L
.43137 .13947 2.37764 .77254 Mabsadd L
.43137 .13947 .56518 .7779 Mabsadd L
.43137 .13947 0 2.5 Mabsadd L closepath F
.44118 .13025 0 2.5 Mabsadd m
.44118 .13025 -0.56518 .7779 Mabsadd L
.44118 .13025 -2.37764 .77254 Mabsadd L
.44118 .13025 -0.91448 -0.29713 Mabsadd L
.44118 .13025 -1.46946 -2.02254 Mabsadd L
.44118 .13025 0 -0.96154 Mabsadd L
.44118 .13025 1.46946 -2.02254 Mabsadd L
.44118 .13025 .91448 -0.29713 Mabsadd L
.44118 .13025 2.37764 .77254 Mabsadd L
.44118 .13025 .56518 .7779 Mabsadd L
.44118 .13025 0 2.5 Mabsadd L closepath F
.45098 .12145 0 2.5 Mabsadd m
.45098 .12145 -0.56518 .7779 Mabsadd L
.45098 .12145 -2.37764 .77254 Mabsadd L
.45098 .12145 -0.91448 -0.29713 Mabsadd L
.45098 .12145 -1.46946 -2.02254 Mabsadd L
.45098 .12145 0 -0.96154 Mabsadd L
.45098 .12145 1.46946 -2.02254 Mabsadd L
.45098 .12145 .91448 -0.29713 Mabsadd L
.45098 .12145 2.37764 .77254 Mabsadd L
.45098 .12145 .56518 .7779 Mabsadd L
.45098 .12145 0 2.5 Mabsadd L closepath F
.46078 .11307 0 2.5 Mabsadd m
.46078 .11307 -0.56518 .7779 Mabsadd L
.46078 .11307 -2.37764 .77254 Mabsadd L
.46078 .11307 -0.91448 -0.29713 Mabsadd L
.46078 .11307 -1.46946 -2.02254 Mabsadd L
.46078 .11307 0 -0.96154 Mabsadd L
.46078 .11307 1.46946 -2.02254 Mabsadd L
.46078 .11307 .91448 -0.29713 Mabsadd L
.46078 .11307 2.37764 .77254 Mabsadd L
.46078 .11307 .56518 .7779 Mabsadd L
.46078 .11307 0 2.5 Mabsadd L closepath F
.47059 .1051 0 2.5 Mabsadd m
.47059 .1051 -0.56518 .7779 Mabsadd L
.47059 .1051 -2.37764 .77254 Mabsadd L
.47059 .1051 -0.91448 -0.29713 Mabsadd L
.47059 .1051 -1.46946 -2.02254 Mabsadd L
.47059 .1051 0 -0.96154 Mabsadd L
.47059 .1051 1.46946 -2.02254 Mabsadd L
.47059 .1051 .91448 -0.29713 Mabsadd L
.47059 .1051 2.37764 .77254 Mabsadd L
.47059 .1051 .56518 .7779 Mabsadd L
.47059 .1051 0 2.5 Mabsadd L closepath F
.48039 .09755 0 2.5 Mabsadd m
.48039 .09755 -0.56518 .7779 Mabsadd L
.48039 .09755 -2.37764 .77254 Mabsadd L
.48039 .09755 -0.91448 -0.29713 Mabsadd L
.48039 .09755 -1.46946 -2.02254 Mabsadd L
.48039 .09755 0 -0.96154 Mabsadd L
.48039 .09755 1.46946 -2.02254 Mabsadd L
.48039 .09755 .91448 -0.29713 Mabsadd L
.48039 .09755 2.37764 .77254 Mabsadd L
.48039 .09755 .56518 .7779 Mabsadd L
.48039 .09755 0 2.5 Mabsadd L closepath F
.4902 .0904 0 2.5 Mabsadd m
.4902 .0904 -0.56518 .7779 Mabsadd L
.4902 .0904 -2.37764 .77254 Mabsadd L
.4902 .0904 -0.91448 -0.29713 Mabsadd L
.4902 .0904 -1.46946 -2.02254 Mabsadd L
.4902 .0904 0 -0.96154 Mabsadd L
.4902 .0904 1.46946 -2.02254 Mabsadd L
.4902 .0904 .91448 -0.29713 Mabsadd L
.4902 .0904 2.37764 .77254 Mabsadd L
.4902 .0904 .56518 .7779 Mabsadd L
.4902 .0904 0 2.5 Mabsadd L closepath F
.5 .08364 0 2.5 Mabsadd m
.5 .08364 -0.56518 .7779 Mabsadd L
.5 .08364 -2.37764 .77254 Mabsadd L
.5 .08364 -0.91448 -0.29713 Mabsadd L
.5 .08364 -1.46946 -2.02254 Mabsadd L
.5 .08364 0 -0.96154 Mabsadd L
.5 .08364 1.46946 -2.02254 Mabsadd L
.5 .08364 .91448 -0.29713 Mabsadd L
.5 .08364 2.37764 .77254 Mabsadd L
.5 .08364 .56518 .7779 Mabsadd L
.5 .08364 0 2.5 Mabsadd L closepath F
.5098 .07727 0 2.5 Mabsadd m
.5098 .07727 -0.56518 .7779 Mabsadd L
.5098 .07727 -2.37764 .77254 Mabsadd L
.5098 .07727 -0.91448 -0.29713 Mabsadd L
.5098 .07727 -1.46946 -2.02254 Mabsadd L
.5098 .07727 0 -0.96154 Mabsadd L
.5098 .07727 1.46946 -2.02254 Mabsadd L
.5098 .07727 .91448 -0.29713 Mabsadd L
.5098 .07727 2.37764 .77254 Mabsadd L
.5098 .07727 .56518 .7779 Mabsadd L
.5098 .07727 0 2.5 Mabsadd L closepath F
.51961 .07128 0 2.5 Mabsadd m
.51961 .07128 -0.56518 .7779 Mabsadd L
.51961 .07128 -2.37764 .77254 Mabsadd L
.51961 .07128 -0.91448 -0.29713 Mabsadd L
.51961 .07128 -1.46946 -2.02254 Mabsadd L
.51961 .07128 0 -0.96154 Mabsadd L
.51961 .07128 1.46946 -2.02254 Mabsadd L
.51961 .07128 .91448 -0.29713 Mabsadd L
.51961 .07128 2.37764 .77254 Mabsadd L
.51961 .07128 .56518 .7779 Mabsadd L
.51961 .07128 0 2.5 Mabsadd L closepath F
.52941 .06565 0 2.5 Mabsadd m
.52941 .06565 -0.56518 .7779 Mabsadd L
.52941 .06565 -2.37764 .77254 Mabsadd L
.52941 .06565 -0.91448 -0.29713 Mabsadd L
.52941 .06565 -1.46946 -2.02254 Mabsadd L
.52941 .06565 0 -0.96154 Mabsadd L
.52941 .06565 1.46946 -2.02254 Mabsadd L
.52941 .06565 .91448 -0.29713 Mabsadd L
.52941 .06565 2.37764 .77254 Mabsadd L
.52941 .06565 .56518 .7779 Mabsadd L
.52941 .06565 0 2.5 Mabsadd L closepath F
.53922 .06037 0 2.5 Mabsadd m
.53922 .06037 -0.56518 .7779 Mabsadd L
.53922 .06037 -2.37764 .77254 Mabsadd L
.53922 .06037 -0.91448 -0.29713 Mabsadd L
.53922 .06037 -1.46946 -2.02254 Mabsadd L
.53922 .06037 0 -0.96154 Mabsadd L
.53922 .06037 1.46946 -2.02254 Mabsadd L
.53922 .06037 .91448 -0.29713 Mabsadd L
.53922 .06037 2.37764 .77254 Mabsadd L
.53922 .06037 .56518 .7779 Mabsadd L
.53922 .06037 0 2.5 Mabsadd L closepath F
.54902 .05543 0 2.5 Mabsadd m
.54902 .05543 -0.56518 .7779 Mabsadd L
.54902 .05543 -2.37764 .77254 Mabsadd L
.54902 .05543 -0.91448 -0.29713 Mabsadd L
.54902 .05543 -1.46946 -2.02254 Mabsadd L
.54902 .05543 0 -0.96154 Mabsadd L
.54902 .05543 1.46946 -2.02254 Mabsadd L
.54902 .05543 .91448 -0.29713 Mabsadd L
.54902 .05543 2.37764 .77254 Mabsadd L
.54902 .05543 .56518 .7779 Mabsadd L
.54902 .05543 0 2.5 Mabsadd L closepath F
.55882 .05082 0 2.5 Mabsadd m
.55882 .05082 -0.56518 .7779 Mabsadd L
.55882 .05082 -2.37764 .77254 Mabsadd L
.55882 .05082 -0.91448 -0.29713 Mabsadd L
.55882 .05082 -1.46946 -2.02254 Mabsadd L
.55882 .05082 0 -0.96154 Mabsadd L
.55882 .05082 1.46946 -2.02254 Mabsadd L
.55882 .05082 .91448 -0.29713 Mabsadd L
.55882 .05082 2.37764 .77254 Mabsadd L
.55882 .05082 .56518 .7779 Mabsadd L
.55882 .05082 0 2.5 Mabsadd L closepath F
.56863 .04652 0 2.5 Mabsadd m
.56863 .04652 -0.56518 .7779 Mabsadd L
.56863 .04652 -2.37764 .77254 Mabsadd L
.56863 .04652 -0.91448 -0.29713 Mabsadd L
.56863 .04652 -1.46946 -2.02254 Mabsadd L
.56863 .04652 0 -0.96154 Mabsadd L
.56863 .04652 1.46946 -2.02254 Mabsadd L
.56863 .04652 .91448 -0.29713 Mabsadd L
.56863 .04652 2.37764 .77254 Mabsadd L
.56863 .04652 .56518 .7779 Mabsadd L
.56863 .04652 0 2.5 Mabsadd L closepath F
.57843 .04252 0 2.5 Mabsadd m
.57843 .04252 -0.56518 .7779 Mabsadd L
.57843 .04252 -2.37764 .77254 Mabsadd L
.57843 .04252 -0.91448 -0.29713 Mabsadd L
.57843 .04252 -1.46946 -2.02254 Mabsadd L
.57843 .04252 0 -0.96154 Mabsadd L
.57843 .04252 1.46946 -2.02254 Mabsadd L
.57843 .04252 .91448 -0.29713 Mabsadd L
.57843 .04252 2.37764 .77254 Mabsadd L
.57843 .04252 .56518 .7779 Mabsadd L
.57843 .04252 0 2.5 Mabsadd L closepath F
.58824 .0388 0 2.5 Mabsadd m
.58824 .0388 -0.56518 .7779 Mabsadd L
.58824 .0388 -2.37764 .77254 Mabsadd L
.58824 .0388 -0.91448 -0.29713 Mabsadd L
.58824 .0388 -1.46946 -2.02254 Mabsadd L
.58824 .0388 0 -0.96154 Mabsadd L
.58824 .0388 1.46946 -2.02254 Mabsadd L
.58824 .0388 .91448 -0.29713 Mabsadd L
.58824 .0388 2.37764 .77254 Mabsadd L
.58824 .0388 .56518 .7779 Mabsadd L
.58824 .0388 0 2.5 Mabsadd L closepath F
.59804 .03535 0 2.5 Mabsadd m
.59804 .03535 -0.56518 .7779 Mabsadd L
.59804 .03535 -2.37764 .77254 Mabsadd L
.59804 .03535 -0.91448 -0.29713 Mabsadd L
.59804 .03535 -1.46946 -2.02254 Mabsadd L
.59804 .03535 0 -0.96154 Mabsadd L
.59804 .03535 1.46946 -2.02254 Mabsadd L
.59804 .03535 .91448 -0.29713 Mabsadd L
.59804 .03535 2.37764 .77254 Mabsadd L
.59804 .03535 .56518 .7779 Mabsadd L
.59804 .03535 0 2.5 Mabsadd L closepath F
.60784 .03216 0 2.5 Mabsadd m
.60784 .03216 -0.56518 .7779 Mabsadd L
.60784 .03216 -2.37764 .77254 Mabsadd L
.60784 .03216 -0.91448 -0.29713 Mabsadd L
.60784 .03216 -1.46946 -2.02254 Mabsadd L
.60784 .03216 0 -0.96154 Mabsadd L
.60784 .03216 1.46946 -2.02254 Mabsadd L
.60784 .03216 .91448 -0.29713 Mabsadd L
.60784 .03216 2.37764 .77254 Mabsadd L
.60784 .03216 .56518 .7779 Mabsadd L
.60784 .03216 0 2.5 Mabsadd L closepath F
.61765 .02921 0 2.5 Mabsadd m
.61765 .02921 -0.56518 .7779 Mabsadd L
.61765 .02921 -2.37764 .77254 Mabsadd L
.61765 .02921 -0.91448 -0.29713 Mabsadd L
.61765 .02921 -1.46946 -2.02254 Mabsadd L
.61765 .02921 0 -0.96154 Mabsadd L
.61765 .02921 1.46946 -2.02254 Mabsadd L
.61765 .02921 .91448 -0.29713 Mabsadd L
.61765 .02921 2.37764 .77254 Mabsadd L
.61765 .02921 .56518 .7779 Mabsadd L
.61765 .02921 0 2.5 Mabsadd L closepath F
.62745 .0265 0 2.5 Mabsadd m
.62745 .0265 -0.56518 .7779 Mabsadd L
.62745 .0265 -2.37764 .77254 Mabsadd L
.62745 .0265 -0.91448 -0.29713 Mabsadd L
.62745 .0265 -1.46946 -2.02254 Mabsadd L
.62745 .0265 0 -0.96154 Mabsadd L
.62745 .0265 1.46946 -2.02254 Mabsadd L
.62745 .0265 .91448 -0.29713 Mabsadd L
.62745 .0265 2.37764 .77254 Mabsadd L
.62745 .0265 .56518 .7779 Mabsadd L
.62745 .0265 0 2.5 Mabsadd L closepath F
.63725 .02399 0 2.5 Mabsadd m
.63725 .02399 -0.56518 .7779 Mabsadd L
.63725 .02399 -2.37764 .77254 Mabsadd L
.63725 .02399 -0.91448 -0.29713 Mabsadd L
.63725 .02399 -1.46946 -2.02254 Mabsadd L
.63725 .02399 0 -0.96154 Mabsadd L
.63725 .02399 1.46946 -2.02254 Mabsadd L
.63725 .02399 .91448 -0.29713 Mabsadd L
.63725 .02399 2.37764 .77254 Mabsadd L
.63725 .02399 .56518 .7779 Mabsadd L
.63725 .02399 0 2.5 Mabsadd L closepath F
.64706 .02169 0 2.5 Mabsadd m
.64706 .02169 -0.56518 .7779 Mabsadd L
.64706 .02169 -2.37764 .77254 Mabsadd L
.64706 .02169 -0.91448 -0.29713 Mabsadd L
.64706 .02169 -1.46946 -2.02254 Mabsadd L
.64706 .02169 0 -0.96154 Mabsadd L
.64706 .02169 1.46946 -2.02254 Mabsadd L
.64706 .02169 .91448 -0.29713 Mabsadd L
.64706 .02169 2.37764 .77254 Mabsadd L
.64706 .02169 .56518 .7779 Mabsadd L
.64706 .02169 0 2.5 Mabsadd L closepath F
.65686 .01959 0 2.5 Mabsadd m
.65686 .01959 -0.56518 .7779 Mabsadd L
.65686 .01959 -2.37764 .77254 Mabsadd L
.65686 .01959 -0.91448 -0.29713 Mabsadd L
.65686 .01959 -1.46946 -2.02254 Mabsadd L
.65686 .01959 0 -0.96154 Mabsadd L
.65686 .01959 1.46946 -2.02254 Mabsadd L
.65686 .01959 .91448 -0.29713 Mabsadd L
.65686 .01959 2.37764 .77254 Mabsadd L
.65686 .01959 .56518 .7779 Mabsadd L
.65686 .01959 0 2.5 Mabsadd L closepath F
.66667 .01765 0 2.5 Mabsadd m
.66667 .01765 -0.56518 .7779 Mabsadd L
.66667 .01765 -2.37764 .77254 Mabsadd L
.66667 .01765 -0.91448 -0.29713 Mabsadd L
.66667 .01765 -1.46946 -2.02254 Mabsadd L
.66667 .01765 0 -0.96154 Mabsadd L
.66667 .01765 1.46946 -2.02254 Mabsadd L
.66667 .01765 .91448 -0.29713 Mabsadd L
.66667 .01765 2.37764 .77254 Mabsadd L
.66667 .01765 .56518 .7779 Mabsadd L
.66667 .01765 0 2.5 Mabsadd L closepath F
.67647 .01589 0 2.5 Mabsadd m
.67647 .01589 -0.56518 .7779 Mabsadd L
.67647 .01589 -2.37764 .77254 Mabsadd L
.67647 .01589 -0.91448 -0.29713 Mabsadd L
.67647 .01589 -1.46946 -2.02254 Mabsadd L
.67647 .01589 0 -0.96154 Mabsadd L
.67647 .01589 1.46946 -2.02254 Mabsadd L
.67647 .01589 .91448 -0.29713 Mabsadd L
.67647 .01589 2.37764 .77254 Mabsadd L
.67647 .01589 .56518 .7779 Mabsadd L
.67647 .01589 0 2.5 Mabsadd L closepath F
.68627 .01428 0 2.5 Mabsadd m
.68627 .01428 -0.56518 .7779 Mabsadd L
.68627 .01428 -2.37764 .77254 Mabsadd L
.68627 .01428 -0.91448 -0.29713 Mabsadd L
.68627 .01428 -1.46946 -2.02254 Mabsadd L
.68627 .01428 0 -0.96154 Mabsadd L
.68627 .01428 1.46946 -2.02254 Mabsadd L
.68627 .01428 .91448 -0.29713 Mabsadd L
.68627 .01428 2.37764 .77254 Mabsadd L
.68627 .01428 .56518 .7779 Mabsadd L
.68627 .01428 0 2.5 Mabsadd L closepath F
.69608 .01281 0 2.5 Mabsadd m
.69608 .01281 -0.56518 .7779 Mabsadd L
.69608 .01281 -2.37764 .77254 Mabsadd L
.69608 .01281 -0.91448 -0.29713 Mabsadd L
.69608 .01281 -1.46946 -2.02254 Mabsadd L
.69608 .01281 0 -0.96154 Mabsadd L
.69608 .01281 1.46946 -2.02254 Mabsadd L
.69608 .01281 .91448 -0.29713 Mabsadd L
.69608 .01281 2.37764 .77254 Mabsadd L
.69608 .01281 .56518 .7779 Mabsadd L
.69608 .01281 0 2.5 Mabsadd L closepath F
.70588 .01148 0 2.5 Mabsadd m
.70588 .01148 -0.56518 .7779 Mabsadd L
.70588 .01148 -2.37764 .77254 Mabsadd L
.70588 .01148 -0.91448 -0.29713 Mabsadd L
.70588 .01148 -1.46946 -2.02254 Mabsadd L
.70588 .01148 0 -0.96154 Mabsadd L
.70588 .01148 1.46946 -2.02254 Mabsadd L
.70588 .01148 .91448 -0.29713 Mabsadd L
.70588 .01148 2.37764 .77254 Mabsadd L
.70588 .01148 .56518 .7779 Mabsadd L
.70588 .01148 0 2.5 Mabsadd L closepath F
.71569 .01027 0 2.5 Mabsadd m
.71569 .01027 -0.56518 .7779 Mabsadd L
.71569 .01027 -2.37764 .77254 Mabsadd L
.71569 .01027 -0.91448 -0.29713 Mabsadd L
.71569 .01027 -1.46946 -2.02254 Mabsadd L
.71569 .01027 0 -0.96154 Mabsadd L
.71569 .01027 1.46946 -2.02254 Mabsadd L
.71569 .01027 .91448 -0.29713 Mabsadd L
.71569 .01027 2.37764 .77254 Mabsadd L
.71569 .01027 .56518 .7779 Mabsadd L
.71569 .01027 0 2.5 Mabsadd L closepath F
.72549 .00917 0 2.5 Mabsadd m
.72549 .00917 -0.56518 .7779 Mabsadd L
.72549 .00917 -2.37764 .77254 Mabsadd L
.72549 .00917 -0.91448 -0.29713 Mabsadd L
.72549 .00917 -1.46946 -2.02254 Mabsadd L
.72549 .00917 0 -0.96154 Mabsadd L
.72549 .00917 1.46946 -2.02254 Mabsadd L
.72549 .00917 .91448 -0.29713 Mabsadd L
.72549 .00917 2.37764 .77254 Mabsadd L
.72549 .00917 .56518 .7779 Mabsadd L
.72549 .00917 0 2.5 Mabsadd L closepath F
.73529 .00818 0 2.5 Mabsadd m
.73529 .00818 -0.56518 .7779 Mabsadd L
.73529 .00818 -2.37764 .77254 Mabsadd L
.73529 .00818 -0.91448 -0.29713 Mabsadd L
.73529 .00818 -1.46946 -2.02254 Mabsadd L
.73529 .00818 0 -0.96154 Mabsadd L
.73529 .00818 1.46946 -2.02254 Mabsadd L
.73529 .00818 .91448 -0.29713 Mabsadd L
.73529 .00818 2.37764 .77254 Mabsadd L
.73529 .00818 .56518 .7779 Mabsadd L
.73529 .00818 0 2.5 Mabsadd L closepath F
.7451 .00728 0 2.5 Mabsadd m
.7451 .00728 -0.56518 .7779 Mabsadd L
.7451 .00728 -2.37764 .77254 Mabsadd L
.7451 .00728 -0.91448 -0.29713 Mabsadd L
.7451 .00728 -1.46946 -2.02254 Mabsadd L
.7451 .00728 0 -0.96154 Mabsadd L
.7451 .00728 1.46946 -2.02254 Mabsadd L
.7451 .00728 .91448 -0.29713 Mabsadd L
.7451 .00728 2.37764 .77254 Mabsadd L
.7451 .00728 .56518 .7779 Mabsadd L
.7451 .00728 0 2.5 Mabsadd L closepath F
.7549 .00647 0 2.5 Mabsadd m
.7549 .00647 -0.56518 .7779 Mabsadd L
.7549 .00647 -2.37764 .77254 Mabsadd L
.7549 .00647 -0.91448 -0.29713 Mabsadd L
.7549 .00647 -1.46946 -2.02254 Mabsadd L
.7549 .00647 0 -0.96154 Mabsadd L
.7549 .00647 1.46946 -2.02254 Mabsadd L
.7549 .00647 .91448 -0.29713 Mabsadd L
.7549 .00647 2.37764 .77254 Mabsadd L
.7549 .00647 .56518 .7779 Mabsadd L
.7549 .00647 0 2.5 Mabsadd L closepath F
.76471 .00575 0 2.5 Mabsadd m
.76471 .00575 -0.56518 .7779 Mabsadd L
.76471 .00575 -2.37764 .77254 Mabsadd L
.76471 .00575 -0.91448 -0.29713 Mabsadd L
.76471 .00575 -1.46946 -2.02254 Mabsadd L
.76471 .00575 0 -0.96154 Mabsadd L
.76471 .00575 1.46946 -2.02254 Mabsadd L
.76471 .00575 .91448 -0.29713 Mabsadd L
.76471 .00575 2.37764 .77254 Mabsadd L
.76471 .00575 .56518 .7779 Mabsadd L
.76471 .00575 0 2.5 Mabsadd L closepath F
.77451 .00509 0 2.5 Mabsadd m
.77451 .00509 -0.56518 .7779 Mabsadd L
.77451 .00509 -2.37764 .77254 Mabsadd L
.77451 .00509 -0.91448 -0.29713 Mabsadd L
.77451 .00509 -1.46946 -2.02254 Mabsadd L
.77451 .00509 0 -0.96154 Mabsadd L
.77451 .00509 1.46946 -2.02254 Mabsadd L
.77451 .00509 .91448 -0.29713 Mabsadd L
.77451 .00509 2.37764 .77254 Mabsadd L
.77451 .00509 .56518 .7779 Mabsadd L
.77451 .00509 0 2.5 Mabsadd L closepath F
.78431 .00451 0 2.5 Mabsadd m
.78431 .00451 -0.56518 .7779 Mabsadd L
.78431 .00451 -2.37764 .77254 Mabsadd L
.78431 .00451 -0.91448 -0.29713 Mabsadd L
.78431 .00451 -1.46946 -2.02254 Mabsadd L
.78431 .00451 0 -0.96154 Mabsadd L
.78431 .00451 1.46946 -2.02254 Mabsadd L
.78431 .00451 .91448 -0.29713 Mabsadd L
.78431 .00451 2.37764 .77254 Mabsadd L
.78431 .00451 .56518 .7779 Mabsadd L
.78431 .00451 0 2.5 Mabsadd L closepath F
.79412 .00398 0 2.5 Mabsadd m
.79412 .00398 -0.56518 .7779 Mabsadd L
.79412 .00398 -2.37764 .77254 Mabsadd L
.79412 .00398 -0.91448 -0.29713 Mabsadd L
.79412 .00398 -1.46946 -2.02254 Mabsadd L
.79412 .00398 0 -0.96154 Mabsadd L
.79412 .00398 1.46946 -2.02254 Mabsadd L
.79412 .00398 .91448 -0.29713 Mabsadd L
.79412 .00398 2.37764 .77254 Mabsadd L
.79412 .00398 .56518 .7779 Mabsadd L
.79412 .00398 0 2.5 Mabsadd L closepath F
.80392 .00351 0 2.5 Mabsadd m
.80392 .00351 -0.56518 .7779 Mabsadd L
.80392 .00351 -2.37764 .77254 Mabsadd L
.80392 .00351 -0.91448 -0.29713 Mabsadd L
.80392 .00351 -1.46946 -2.02254 Mabsadd L
.80392 .00351 0 -0.96154 Mabsadd L
.80392 .00351 1.46946 -2.02254 Mabsadd L
.80392 .00351 .91448 -0.29713 Mabsadd L
.80392 .00351 2.37764 .77254 Mabsadd L
.80392 .00351 .56518 .7779 Mabsadd L
.80392 .00351 0 2.5 Mabsadd L closepath F
.81373 .00309 0 2.5 Mabsadd m
.81373 .00309 -0.56518 .7779 Mabsadd L
.81373 .00309 -2.37764 .77254 Mabsadd L
.81373 .00309 -0.91448 -0.29713 Mabsadd L
.81373 .00309 -1.46946 -2.02254 Mabsadd L
.81373 .00309 0 -0.96154 Mabsadd L
.81373 .00309 1.46946 -2.02254 Mabsadd L
.81373 .00309 .91448 -0.29713 Mabsadd L
.81373 .00309 2.37764 .77254 Mabsadd L
.81373 .00309 .56518 .7779 Mabsadd L
.81373 .00309 0 2.5 Mabsadd L closepath F
.82353 .00272 0 2.5 Mabsadd m
.82353 .00272 -0.56518 .7779 Mabsadd L
.82353 .00272 -2.37764 .77254 Mabsadd L
.82353 .00272 -0.91448 -0.29713 Mabsadd L
.82353 .00272 -1.46946 -2.02254 Mabsadd L
.82353 .00272 0 -0.96154 Mabsadd L
.82353 .00272 1.46946 -2.02254 Mabsadd L
.82353 .00272 .91448 -0.29713 Mabsadd L
.82353 .00272 2.37764 .77254 Mabsadd L
.82353 .00272 .56518 .7779 Mabsadd L
.82353 .00272 0 2.5 Mabsadd L closepath F
.83333 .00239 0 2.5 Mabsadd m
.83333 .00239 -0.56518 .7779 Mabsadd L
.83333 .00239 -2.37764 .77254 Mabsadd L
.83333 .00239 -0.91448 -0.29713 Mabsadd L
.83333 .00239 -1.46946 -2.02254 Mabsadd L
.83333 .00239 0 -0.96154 Mabsadd L
.83333 .00239 1.46946 -2.02254 Mabsadd L
.83333 .00239 .91448 -0.29713 Mabsadd L
.83333 .00239 2.37764 .77254 Mabsadd L
.83333 .00239 .56518 .7779 Mabsadd L
.83333 .00239 0 2.5 Mabsadd L closepath F
.84314 .00209 0 2.5 Mabsadd m
.84314 .00209 -0.56518 .7779 Mabsadd L
.84314 .00209 -2.37764 .77254 Mabsadd L
.84314 .00209 -0.91448 -0.29713 Mabsadd L
.84314 .00209 -1.46946 -2.02254 Mabsadd L
.84314 .00209 0 -0.96154 Mabsadd L
.84314 .00209 1.46946 -2.02254 Mabsadd L
.84314 .00209 .91448 -0.29713 Mabsadd L
.84314 .00209 2.37764 .77254 Mabsadd L
.84314 .00209 .56518 .7779 Mabsadd L
.84314 .00209 0 2.5 Mabsadd L closepath F
.85294 .00183 0 2.5 Mabsadd m
.85294 .00183 -0.56518 .7779 Mabsadd L
.85294 .00183 -2.37764 .77254 Mabsadd L
.85294 .00183 -0.91448 -0.29713 Mabsadd L
.85294 .00183 -1.46946 -2.02254 Mabsadd L
.85294 .00183 0 -0.96154 Mabsadd L
.85294 .00183 1.46946 -2.02254 Mabsadd L
.85294 .00183 .91448 -0.29713 Mabsadd L
.85294 .00183 2.37764 .77254 Mabsadd L
.85294 .00183 .56518 .7779 Mabsadd L
.85294 .00183 0 2.5 Mabsadd L closepath F
.86275 .0016 0 2.5 Mabsadd m
.86275 .0016 -0.56518 .7779 Mabsadd L
.86275 .0016 -2.37764 .77254 Mabsadd L
.86275 .0016 -0.91448 -0.29713 Mabsadd L
.86275 .0016 -1.46946 -2.02254 Mabsadd L
.86275 .0016 0 -0.96154 Mabsadd L
.86275 .0016 1.46946 -2.02254 Mabsadd L
.86275 .0016 .91448 -0.29713 Mabsadd L
.86275 .0016 2.37764 .77254 Mabsadd L
.86275 .0016 .56518 .7779 Mabsadd L
.86275 .0016 0 2.5 Mabsadd L closepath F
.87255 .0014 0 2.5 Mabsadd m
.87255 .0014 -0.56518 .7779 Mabsadd L
.87255 .0014 -2.37764 .77254 Mabsadd L
.87255 .0014 -0.91448 -0.29713 Mabsadd L
.87255 .0014 -1.46946 -2.02254 Mabsadd L
.87255 .0014 0 -0.96154 Mabsadd L
.87255 .0014 1.46946 -2.02254 Mabsadd L
.87255 .0014 .91448 -0.29713 Mabsadd L
.87255 .0014 2.37764 .77254 Mabsadd L
.87255 .0014 .56518 .7779 Mabsadd L
.87255 .0014 0 2.5 Mabsadd L closepath F
.88235 .00122 0 2.5 Mabsadd m
.88235 .00122 -0.56518 .7779 Mabsadd L
.88235 .00122 -2.37764 .77254 Mabsadd L
.88235 .00122 -0.91448 -0.29713 Mabsadd L
.88235 .00122 -1.46946 -2.02254 Mabsadd L
.88235 .00122 0 -0.96154 Mabsadd L
.88235 .00122 1.46946 -2.02254 Mabsadd L
.88235 .00122 .91448 -0.29713 Mabsadd L
.88235 .00122 2.37764 .77254 Mabsadd L
.88235 .00122 .56518 .7779 Mabsadd L
.88235 .00122 0 2.5 Mabsadd L closepath F
.89216 .00106 0 2.5 Mabsadd m
.89216 .00106 -0.56518 .7779 Mabsadd L
.89216 .00106 -2.37764 .77254 Mabsadd L
.89216 .00106 -0.91448 -0.29713 Mabsadd L
.89216 .00106 -1.46946 -2.02254 Mabsadd L
.89216 .00106 0 -0.96154 Mabsadd L
.89216 .00106 1.46946 -2.02254 Mabsadd L
.89216 .00106 .91448 -0.29713 Mabsadd L
.89216 .00106 2.37764 .77254 Mabsadd L
.89216 .00106 .56518 .7779 Mabsadd L
.89216 .00106 0 2.5 Mabsadd L closepath F
.90196 .00092 0 2.5 Mabsadd m
.90196 .00092 -0.56518 .7779 Mabsadd L
.90196 .00092 -2.37764 .77254 Mabsadd L
.90196 .00092 -0.91448 -0.29713 Mabsadd L
.90196 .00092 -1.46946 -2.02254 Mabsadd L
.90196 .00092 0 -0.96154 Mabsadd L
.90196 .00092 1.46946 -2.02254 Mabsadd L
.90196 .00092 .91448 -0.29713 Mabsadd L
.90196 .00092 2.37764 .77254 Mabsadd L
.90196 .00092 .56518 .7779 Mabsadd L
.90196 .00092 0 2.5 Mabsadd L closepath F
.91176 .0008 0 2.5 Mabsadd m
.91176 .0008 -0.56518 .7779 Mabsadd L
.91176 .0008 -2.37764 .77254 Mabsadd L
.91176 .0008 -0.91448 -0.29713 Mabsadd L
.91176 .0008 -1.46946 -2.02254 Mabsadd L
.91176 .0008 0 -0.96154 Mabsadd L
.91176 .0008 1.46946 -2.02254 Mabsadd L
.91176 .0008 .91448 -0.29713 Mabsadd L
.91176 .0008 2.37764 .77254 Mabsadd L
.91176 .0008 .56518 .7779 Mabsadd L
.91176 .0008 0 2.5 Mabsadd L closepath F
.92157 .00069 0 2.5 Mabsadd m
.92157 .00069 -0.56518 .7779 Mabsadd L
.92157 .00069 -2.37764 .77254 Mabsadd L
.92157 .00069 -0.91448 -0.29713 Mabsadd L
.92157 .00069 -1.46946 -2.02254 Mabsadd L
.92157 .00069 0 -0.96154 Mabsadd L
.92157 .00069 1.46946 -2.02254 Mabsadd L
.92157 .00069 .91448 -0.29713 Mabsadd L
.92157 .00069 2.37764 .77254 Mabsadd L
.92157 .00069 .56518 .7779 Mabsadd L
.92157 .00069 0 2.5 Mabsadd L closepath F
.93137 .0006 0 2.5 Mabsadd m
.93137 .0006 -0.56518 .7779 Mabsadd L
.93137 .0006 -2.37764 .77254 Mabsadd L
.93137 .0006 -0.91448 -0.29713 Mabsadd L
.93137 .0006 -1.46946 -2.02254 Mabsadd L
.93137 .0006 0 -0.96154 Mabsadd L
.93137 .0006 1.46946 -2.02254 Mabsadd L
.93137 .0006 .91448 -0.29713 Mabsadd L
.93137 .0006 2.37764 .77254 Mabsadd L
.93137 .0006 .56518 .7779 Mabsadd L
.93137 .0006 0 2.5 Mabsadd L closepath F
.94118 .00052 0 2.5 Mabsadd m
.94118 .00052 -0.56518 .7779 Mabsadd L
.94118 .00052 -2.37764 .77254 Mabsadd L
.94118 .00052 -0.91448 -0.29713 Mabsadd L
.94118 .00052 -1.46946 -2.02254 Mabsadd L
.94118 .00052 0 -0.96154 Mabsadd L
.94118 .00052 1.46946 -2.02254 Mabsadd L
.94118 .00052 .91448 -0.29713 Mabsadd L
.94118 .00052 2.37764 .77254 Mabsadd L
.94118 .00052 .56518 .7779 Mabsadd L
.94118 .00052 0 2.5 Mabsadd L closepath F
.95098 .00045 0 2.5 Mabsadd m
.95098 .00045 -0.56518 .7779 Mabsadd L
.95098 .00045 -2.37764 .77254 Mabsadd L
.95098 .00045 -0.91448 -0.29713 Mabsadd L
.95098 .00045 -1.46946 -2.02254 Mabsadd L
.95098 .00045 0 -0.96154 Mabsadd L
.95098 .00045 1.46946 -2.02254 Mabsadd L
.95098 .00045 .91448 -0.29713 Mabsadd L
.95098 .00045 2.37764 .77254 Mabsadd L
.95098 .00045 .56518 .7779 Mabsadd L
.95098 .00045 0 2.5 Mabsadd L closepath F
.96078 .00038 0 2.5 Mabsadd m
.96078 .00038 -0.56518 .7779 Mabsadd L
.96078 .00038 -2.37764 .77254 Mabsadd L
.96078 .00038 -0.91448 -0.29713 Mabsadd L
.96078 .00038 -1.46946 -2.02254 Mabsadd L
.96078 .00038 0 -0.96154 Mabsadd L
.96078 .00038 1.46946 -2.02254 Mabsadd L
.96078 .00038 .91448 -0.29713 Mabsadd L
.96078 .00038 2.37764 .77254 Mabsadd L
.96078 .00038 .56518 .7779 Mabsadd L
.96078 .00038 0 2.5 Mabsadd L closepath F
.97059 .00033 0 2.5 Mabsadd m
.97059 .00033 -0.56518 .7779 Mabsadd L
.97059 .00033 -2.37764 .77254 Mabsadd L
.97059 .00033 -0.91448 -0.29713 Mabsadd L
.97059 .00033 -1.46946 -2.02254 Mabsadd L
.97059 .00033 0 -0.96154 Mabsadd L
.97059 .00033 1.46946 -2.02254 Mabsadd L
.97059 .00033 .91448 -0.29713 Mabsadd L
.97059 .00033 2.37764 .77254 Mabsadd L
.97059 .00033 .56518 .7779 Mabsadd L
.97059 .00033 0 2.5 Mabsadd L closepath F
.98039 .00028 0 2.5 Mabsadd m
.98039 .00028 -0.56518 .7779 Mabsadd L
.98039 .00028 -2.37764 .77254 Mabsadd L
.98039 .00028 -0.91448 -0.29713 Mabsadd L
.98039 .00028 -1.46946 -2.02254 Mabsadd L
.98039 .00028 0 -0.96154 Mabsadd L
.98039 .00028 1.46946 -2.02254 Mabsadd L
.98039 .00028 .91448 -0.29713 Mabsadd L
.98039 .00028 2.37764 .77254 Mabsadd L
.98039 .00028 .56518 .7779 Mabsadd L
.98039 .00028 0 2.5 Mabsadd L closepath F
.9902 .00024 0 2.5 Mabsadd m
.9902 .00024 -0.56518 .7779 Mabsadd L
.9902 .00024 -2.37764 .77254 Mabsadd L
.9902 .00024 -0.91448 -0.29713 Mabsadd L
.9902 .00024 -1.46946 -2.02254 Mabsadd L
.9902 .00024 0 -0.96154 Mabsadd L
.9902 .00024 1.46946 -2.02254 Mabsadd L
.9902 .00024 .91448 -0.29713 Mabsadd L
.9902 .00024 2.37764 .77254 Mabsadd L
.9902 .00024 .56518 .7779 Mabsadd L
.9902 .00024 0 2.5 Mabsadd L closepath F
1 .00021 0 2.5 Mabsadd m
1 .00021 -0.56518 .7779 Mabsadd L
1 .00021 -2.37764 .77254 Mabsadd L
1 .00021 -0.91448 -0.29713 Mabsadd L
1 .00021 -1.46946 -2.02254 Mabsadd L
1 .00021 0 -0.96154 Mabsadd L
1 .00021 1.46946 -2.02254 Mabsadd L
1 .00021 .91448 -0.29713 Mabsadd L
1 .00021 2.37764 .77254 Mabsadd L
1 .00021 .56518 .7779 Mabsadd L
1 .00021 0 2.5 Mabsadd L closepath F
1.0098 .00018 0 2.5 Mabsadd m
1.0098 .00018 -0.56518 .7779 Mabsadd L
1.0098 .00018 -2.37764 .77254 Mabsadd L
1.0098 .00018 -0.91448 -0.29713 Mabsadd L
1.0098 .00018 -1.46946 -2.02254 Mabsadd L
1.0098 .00018 0 -0.96154 Mabsadd L
1.0098 .00018 1.46946 -2.02254 Mabsadd L
1.0098 .00018 .91448 -0.29713 Mabsadd L
1.0098 .00018 2.37764 .77254 Mabsadd L
1.0098 .00018 .56518 .7779 Mabsadd L
1.0098 .00018 0 2.5 Mabsadd L closepath F
1.01961 .00015 0 2.5 Mabsadd m
1.01961 .00015 -0.56518 .7779 Mabsadd L
1.01961 .00015 -2.37764 .77254 Mabsadd L
1.01961 .00015 -0.91448 -0.29713 Mabsadd L
1.01961 .00015 -1.46946 -2.02254 Mabsadd L
1.01961 .00015 0 -0.96154 Mabsadd L
1.01961 .00015 1.46946 -2.02254 Mabsadd L
1.01961 .00015 .91448 -0.29713 Mabsadd L
1.01961 .00015 2.37764 .77254 Mabsadd L
1.01961 .00015 .56518 .7779 Mabsadd L
1.01961 .00015 0 2.5 Mabsadd L closepath F
1.02941 .00013 0 2.5 Mabsadd m
1.02941 .00013 -0.56518 .7779 Mabsadd L
1.02941 .00013 -2.37764 .77254 Mabsadd L
1.02941 .00013 -0.91448 -0.29713 Mabsadd L
1.02941 .00013 -1.46946 -2.02254 Mabsadd L
1.02941 .00013 0 -0.96154 Mabsadd L
1.02941 .00013 1.46946 -2.02254 Mabsadd L
1.02941 .00013 .91448 -0.29713 Mabsadd L
1.02941 .00013 2.37764 .77254 Mabsadd L
1.02941 .00013 .56518 .7779 Mabsadd L
1.02941 .00013 0 2.5 Mabsadd L closepath F
1.03922 .00011 0 2.5 Mabsadd m
1.03922 .00011 -0.56518 .7779 Mabsadd L
1.03922 .00011 -2.37764 .77254 Mabsadd L
1.03922 .00011 -0.91448 -0.29713 Mabsadd L
1.03922 .00011 -1.46946 -2.02254 Mabsadd L
1.03922 .00011 0 -0.96154 Mabsadd L
1.03922 .00011 1.46946 -2.02254 Mabsadd L
1.03922 .00011 .91448 -0.29713 Mabsadd L
1.03922 .00011 2.37764 .77254 Mabsadd L
1.03922 .00011 .56518 .7779 Mabsadd L
1.03922 .00011 0 2.5 Mabsadd L closepath F
1.04902 9e-005 0 2.5 Mabsadd m
1.04902 9e-005 -0.56518 .7779 Mabsadd L
1.04902 9e-005 -2.37764 .77254 Mabsadd L
1.04902 9e-005 -0.91448 -0.29713 Mabsadd L
1.04902 9e-005 -1.46946 -2.02254 Mabsadd L
1.04902 9e-005 0 -0.96154 Mabsadd L
1.04902 9e-005 1.46946 -2.02254 Mabsadd L
1.04902 9e-005 .91448 -0.29713 Mabsadd L
1.04902 9e-005 2.37764 .77254 Mabsadd L
1.04902 9e-005 .56518 .7779 Mabsadd L
1.04902 9e-005 0 2.5 Mabsadd L closepath F
1.05882 8e-005 0 2.5 Mabsadd m
1.05882 8e-005 -0.56518 .7779 Mabsadd L
1.05882 8e-005 -2.37764 .77254 Mabsadd L
1.05882 8e-005 -0.91448 -0.29713 Mabsadd L
1.05882 8e-005 -1.46946 -2.02254 Mabsadd L
1.05882 8e-005 0 -0.96154 Mabsadd L
1.05882 8e-005 1.46946 -2.02254 Mabsadd L
1.05882 8e-005 .91448 -0.29713 Mabsadd L
1.05882 8e-005 2.37764 .77254 Mabsadd L
1.05882 8e-005 .56518 .7779 Mabsadd L
1.05882 8e-005 0 2.5 Mabsadd L closepath F
1.06863 7e-005 0 2.5 Mabsadd m
1.06863 7e-005 -0.56518 .7779 Mabsadd L
1.06863 7e-005 -2.37764 .77254 Mabsadd L
1.06863 7e-005 -0.91448 -0.29713 Mabsadd L
1.06863 7e-005 -1.46946 -2.02254 Mabsadd L
1.06863 7e-005 0 -0.96154 Mabsadd L
1.06863 7e-005 1.46946 -2.02254 Mabsadd L
1.06863 7e-005 .91448 -0.29713 Mabsadd L
1.06863 7e-005 2.37764 .77254 Mabsadd L
1.06863 7e-005 .56518 .7779 Mabsadd L
1.06863 7e-005 0 2.5 Mabsadd L closepath F
1.07843 6e-005 0 2.5 Mabsadd m
1.07843 6e-005 -0.56518 .7779 Mabsadd L
1.07843 6e-005 -2.37764 .77254 Mabsadd L
1.07843 6e-005 -0.91448 -0.29713 Mabsadd L
1.07843 6e-005 -1.46946 -2.02254 Mabsadd L
1.07843 6e-005 0 -0.96154 Mabsadd L
1.07843 6e-005 1.46946 -2.02254 Mabsadd L
1.07843 6e-005 .91448 -0.29713 Mabsadd L
1.07843 6e-005 2.37764 .77254 Mabsadd L
1.07843 6e-005 .56518 .7779 Mabsadd L
1.07843 6e-005 0 2.5 Mabsadd L closepath F
1.08824 5e-005 0 2.5 Mabsadd m
1.08824 5e-005 -0.56518 .7779 Mabsadd L
1.08824 5e-005 -2.37764 .77254 Mabsadd L
1.08824 5e-005 -0.91448 -0.29713 Mabsadd L
1.08824 5e-005 -1.46946 -2.02254 Mabsadd L
1.08824 5e-005 0 -0.96154 Mabsadd L
1.08824 5e-005 1.46946 -2.02254 Mabsadd L
1.08824 5e-005 .91448 -0.29713 Mabsadd L
1.08824 5e-005 2.37764 .77254 Mabsadd L
1.08824 5e-005 .56518 .7779 Mabsadd L
1.08824 5e-005 0 2.5 Mabsadd L closepath F
1.09804 4e-005 0 2.5 Mabsadd m
1.09804 4e-005 -0.56518 .7779 Mabsadd L
1.09804 4e-005 -2.37764 .77254 Mabsadd L
1.09804 4e-005 -0.91448 -0.29713 Mabsadd L
1.09804 4e-005 -1.46946 -2.02254 Mabsadd L
1.09804 4e-005 0 -0.96154 Mabsadd L
1.09804 4e-005 1.46946 -2.02254 Mabsadd L
1.09804 4e-005 .91448 -0.29713 Mabsadd L
1.09804 4e-005 2.37764 .77254 Mabsadd L
1.09804 4e-005 .56518 .7779 Mabsadd L
1.09804 4e-005 0 2.5 Mabsadd L closepath F
1.10784 3e-005 0 2.5 Mabsadd m
1.10784 3e-005 -0.56518 .7779 Mabsadd L
1.10784 3e-005 -2.37764 .77254 Mabsadd L
1.10784 3e-005 -0.91448 -0.29713 Mabsadd L
1.10784 3e-005 -1.46946 -2.02254 Mabsadd L
1.10784 3e-005 0 -0.96154 Mabsadd L
1.10784 3e-005 1.46946 -2.02254 Mabsadd L
1.10784 3e-005 .91448 -0.29713 Mabsadd L
1.10784 3e-005 2.37764 .77254 Mabsadd L
1.10784 3e-005 .56518 .7779 Mabsadd L
1.10784 3e-005 0 2.5 Mabsadd L closepath F
1.11765 3e-005 0 2.5 Mabsadd m
1.11765 3e-005 -0.56518 .7779 Mabsadd L
1.11765 3e-005 -2.37764 .77254 Mabsadd L
1.11765 3e-005 -0.91448 -0.29713 Mabsadd L
1.11765 3e-005 -1.46946 -2.02254 Mabsadd L
1.11765 3e-005 0 -0.96154 Mabsadd L
1.11765 3e-005 1.46946 -2.02254 Mabsadd L
1.11765 3e-005 .91448 -0.29713 Mabsadd L
1.11765 3e-005 2.37764 .77254 Mabsadd L
1.11765 3e-005 .56518 .7779 Mabsadd L
1.11765 3e-005 0 2.5 Mabsadd L closepath F
1.12745 2e-005 0 2.5 Mabsadd m
1.12745 2e-005 -0.56518 .7779 Mabsadd L
1.12745 2e-005 -2.37764 .77254 Mabsadd L
1.12745 2e-005 -0.91448 -0.29713 Mabsadd L
1.12745 2e-005 -1.46946 -2.02254 Mabsadd L
1.12745 2e-005 0 -0.96154 Mabsadd L
1.12745 2e-005 1.46946 -2.02254 Mabsadd L
1.12745 2e-005 .91448 -0.29713 Mabsadd L
1.12745 2e-005 2.37764 .77254 Mabsadd L
1.12745 2e-005 .56518 .7779 Mabsadd L
1.12745 2e-005 0 2.5 Mabsadd L closepath F
1.13725 2e-005 0 2.5 Mabsadd m
1.13725 2e-005 -0.56518 .7779 Mabsadd L
1.13725 2e-005 -2.37764 .77254 Mabsadd L
1.13725 2e-005 -0.91448 -0.29713 Mabsadd L
1.13725 2e-005 -1.46946 -2.02254 Mabsadd L
1.13725 2e-005 0 -0.96154 Mabsadd L
1.13725 2e-005 1.46946 -2.02254 Mabsadd L
1.13725 2e-005 .91448 -0.29713 Mabsadd L
1.13725 2e-005 2.37764 .77254 Mabsadd L
1.13725 2e-005 .56518 .7779 Mabsadd L
1.13725 2e-005 0 2.5 Mabsadd L closepath F
1.14706 2e-005 0 2.5 Mabsadd m
1.14706 2e-005 -0.56518 .7779 Mabsadd L
1.14706 2e-005 -2.37764 .77254 Mabsadd L
1.14706 2e-005 -0.91448 -0.29713 Mabsadd L
1.14706 2e-005 -1.46946 -2.02254 Mabsadd L
1.14706 2e-005 0 -0.96154 Mabsadd L
1.14706 2e-005 1.46946 -2.02254 Mabsadd L
1.14706 2e-005 .91448 -0.29713 Mabsadd L
1.14706 2e-005 2.37764 .77254 Mabsadd L
1.14706 2e-005 .56518 .7779 Mabsadd L
1.14706 2e-005 0 2.5 Mabsadd L closepath F
1.15686 1e-005 0 2.5 Mabsadd m
1.15686 1e-005 -0.56518 .7779 Mabsadd L
1.15686 1e-005 -2.37764 .77254 Mabsadd L
1.15686 1e-005 -0.91448 -0.29713 Mabsadd L
1.15686 1e-005 -1.46946 -2.02254 Mabsadd L
1.15686 1e-005 0 -0.96154 Mabsadd L
1.15686 1e-005 1.46946 -2.02254 Mabsadd L
1.15686 1e-005 .91448 -0.29713 Mabsadd L
1.15686 1e-005 2.37764 .77254 Mabsadd L
1.15686 1e-005 .56518 .7779 Mabsadd L
1.15686 1e-005 0 2.5 Mabsadd L closepath F
1.16667 1e-005 0 2.5 Mabsadd m
1.16667 1e-005 -0.56518 .7779 Mabsadd L
1.16667 1e-005 -2.37764 .77254 Mabsadd L
1.16667 1e-005 -0.91448 -0.29713 Mabsadd L
1.16667 1e-005 -1.46946 -2.02254 Mabsadd L
1.16667 1e-005 0 -0.96154 Mabsadd L
1.16667 1e-005 1.46946 -2.02254 Mabsadd L
1.16667 1e-005 .91448 -0.29713 Mabsadd L
1.16667 1e-005 2.37764 .77254 Mabsadd L
1.16667 1e-005 .56518 .7779 Mabsadd L
1.16667 1e-005 0 2.5 Mabsadd L closepath F
1.17647 1e-005 0 2.5 Mabsadd m
1.17647 1e-005 -0.56518 .7779 Mabsadd L
1.17647 1e-005 -2.37764 .77254 Mabsadd L
1.17647 1e-005 -0.91448 -0.29713 Mabsadd L
1.17647 1e-005 -1.46946 -2.02254 Mabsadd L
1.17647 1e-005 0 -0.96154 Mabsadd L
1.17647 1e-005 1.46946 -2.02254 Mabsadd L
1.17647 1e-005 .91448 -0.29713 Mabsadd L
1.17647 1e-005 2.37764 .77254 Mabsadd L
1.17647 1e-005 .56518 .7779 Mabsadd L
1.17647 1e-005 0 2.5 Mabsadd L closepath F
1.18627 1e-005 0 2.5 Mabsadd m
1.18627 1e-005 -0.56518 .7779 Mabsadd L
1.18627 1e-005 -2.37764 .77254 Mabsadd L
1.18627 1e-005 -0.91448 -0.29713 Mabsadd L
1.18627 1e-005 -1.46946 -2.02254 Mabsadd L
1.18627 1e-005 0 -0.96154 Mabsadd L
1.18627 1e-005 1.46946 -2.02254 Mabsadd L
1.18627 1e-005 .91448 -0.29713 Mabsadd L
1.18627 1e-005 2.37764 .77254 Mabsadd L
1.18627 1e-005 .56518 .7779 Mabsadd L
1.18627 1e-005 0 2.5 Mabsadd L closepath F
1.19608 1e-005 0 2.5 Mabsadd m
1.19608 1e-005 -0.56518 .7779 Mabsadd L
1.19608 1e-005 -2.37764 .77254 Mabsadd L
1.19608 1e-005 -0.91448 -0.29713 Mabsadd L
1.19608 1e-005 -1.46946 -2.02254 Mabsadd L
1.19608 1e-005 0 -0.96154 Mabsadd L
1.19608 1e-005 1.46946 -2.02254 Mabsadd L
1.19608 1e-005 .91448 -0.29713 Mabsadd L
1.19608 1e-005 2.37764 .77254 Mabsadd L
1.19608 1e-005 .56518 .7779 Mabsadd L
1.19608 1e-005 0 2.5 Mabsadd L closepath F
1.20588 1e-005 0 2.5 Mabsadd m
1.20588 1e-005 -0.56518 .7779 Mabsadd L
1.20588 1e-005 -2.37764 .77254 Mabsadd L
1.20588 1e-005 -0.91448 -0.29713 Mabsadd L
1.20588 1e-005 -1.46946 -2.02254 Mabsadd L
1.20588 1e-005 0 -0.96154 Mabsadd L
1.20588 1e-005 1.46946 -2.02254 Mabsadd L
1.20588 1e-005 .91448 -0.29713 Mabsadd L
1.20588 1e-005 2.37764 .77254 Mabsadd L
1.20588 1e-005 .56518 .7779 Mabsadd L
1.20588 1e-005 0 2.5 Mabsadd L closepath F
1.21569 0 0 2.5 Mabsadd m
1.21569 0 -0.56518 .7779 Mabsadd L
1.21569 0 -2.37764 .77254 Mabsadd L
1.21569 0 -0.91448 -0.29713 Mabsadd L
1.21569 0 -1.46946 -2.02254 Mabsadd L
1.21569 0 0 -0.96154 Mabsadd L
1.21569 0 1.46946 -2.02254 Mabsadd L
1.21569 0 .91448 -0.29713 Mabsadd L
1.21569 0 2.37764 .77254 Mabsadd L
1.21569 0 .56518 .7779 Mabsadd L
1.21569 0 0 2.5 Mabsadd L closepath F
1.22549 0 0 2.5 Mabsadd m
1.22549 0 -0.56518 .7779 Mabsadd L
1.22549 0 -2.37764 .77254 Mabsadd L
1.22549 0 -0.91448 -0.29713 Mabsadd L
1.22549 0 -1.46946 -2.02254 Mabsadd L
1.22549 0 0 -0.96154 Mabsadd L
1.22549 0 1.46946 -2.02254 Mabsadd L
1.22549 0 .91448 -0.29713 Mabsadd L
1.22549 0 2.37764 .77254 Mabsadd L
1.22549 0 .56518 .7779 Mabsadd L
1.22549 0 0 2.5 Mabsadd L closepath F
1.23529 0 0 2.5 Mabsadd m
1.23529 0 -0.56518 .7779 Mabsadd L
1.23529 0 -2.37764 .77254 Mabsadd L
1.23529 0 -0.91448 -0.29713 Mabsadd L
1.23529 0 -1.46946 -2.02254 Mabsadd L
1.23529 0 0 -0.96154 Mabsadd L
1.23529 0 1.46946 -2.02254 Mabsadd L
1.23529 0 .91448 -0.29713 Mabsadd L
1.23529 0 2.37764 .77254 Mabsadd L
1.23529 0 .56518 .7779 Mabsadd L
1.23529 0 0 2.5 Mabsadd L closepath F
1.2451 0 0 2.5 Mabsadd m
1.2451 0 -0.56518 .7779 Mabsadd L
1.2451 0 -2.37764 .77254 Mabsadd L
1.2451 0 -0.91448 -0.29713 Mabsadd L
1.2451 0 -1.46946 -2.02254 Mabsadd L
1.2451 0 0 -0.96154 Mabsadd L
1.2451 0 1.46946 -2.02254 Mabsadd L
1.2451 0 .91448 -0.29713 Mabsadd L
1.2451 0 2.37764 .77254 Mabsadd L
1.2451 0 .56518 .7779 Mabsadd L
1.2451 0 0 2.5 Mabsadd L closepath F
1.2549 0 0 2.5 Mabsadd m
1.2549 0 -0.56518 .7779 Mabsadd L
1.2549 0 -2.37764 .77254 Mabsadd L
1.2549 0 -0.91448 -0.29713 Mabsadd L
1.2549 0 -1.46946 -2.02254 Mabsadd L
1.2549 0 0 -0.96154 Mabsadd L
1.2549 0 1.46946 -2.02254 Mabsadd L
1.2549 0 .91448 -0.29713 Mabsadd L
1.2549 0 2.37764 .77254 Mabsadd L
1.2549 0 .56518 .7779 Mabsadd L
1.2549 0 0 2.5 Mabsadd L closepath F
1.26471 0 0 2.5 Mabsadd m
1.26471 0 -0.56518 .7779 Mabsadd L
1.26471 0 -2.37764 .77254 Mabsadd L
1.26471 0 -0.91448 -0.29713 Mabsadd L
1.26471 0 -1.46946 -2.02254 Mabsadd L
1.26471 0 0 -0.96154 Mabsadd L
1.26471 0 1.46946 -2.02254 Mabsadd L
1.26471 0 .91448 -0.29713 Mabsadd L
1.26471 0 2.37764 .77254 Mabsadd L
1.26471 0 .56518 .7779 Mabsadd L
1.26471 0 0 2.5 Mabsadd L closepath F
1.27451 0 0 2.5 Mabsadd m
1.27451 0 -0.56518 .7779 Mabsadd L
1.27451 0 -2.37764 .77254 Mabsadd L
1.27451 0 -0.91448 -0.29713 Mabsadd L
1.27451 0 -1.46946 -2.02254 Mabsadd L
1.27451 0 0 -0.96154 Mabsadd L
1.27451 0 1.46946 -2.02254 Mabsadd L
1.27451 0 .91448 -0.29713 Mabsadd L
1.27451 0 2.37764 .77254 Mabsadd L
1.27451 0 .56518 .7779 Mabsadd L
1.27451 0 0 2.5 Mabsadd L closepath F
1.28431 0 0 2.5 Mabsadd m
1.28431 0 -0.56518 .7779 Mabsadd L
1.28431 0 -2.37764 .77254 Mabsadd L
1.28431 0 -0.91448 -0.29713 Mabsadd L
1.28431 0 -1.46946 -2.02254 Mabsadd L
1.28431 0 0 -0.96154 Mabsadd L
1.28431 0 1.46946 -2.02254 Mabsadd L
1.28431 0 .91448 -0.29713 Mabsadd L
1.28431 0 2.37764 .77254 Mabsadd L
1.28431 0 .56518 .7779 Mabsadd L
1.28431 0 0 2.5 Mabsadd L closepath F
1.29412 0 0 2.5 Mabsadd m
1.29412 0 -0.56518 .7779 Mabsadd L
1.29412 0 -2.37764 .77254 Mabsadd L
1.29412 0 -0.91448 -0.29713 Mabsadd L
1.29412 0 -1.46946 -2.02254 Mabsadd L
1.29412 0 0 -0.96154 Mabsadd L
1.29412 0 1.46946 -2.02254 Mabsadd L
1.29412 0 .91448 -0.29713 Mabsadd L
1.29412 0 2.37764 .77254 Mabsadd L
1.29412 0 .56518 .7779 Mabsadd L
1.29412 0 0 2.5 Mabsadd L closepath F
1.30392 0 0 2.5 Mabsadd m
1.30392 0 -0.56518 .7779 Mabsadd L
1.30392 0 -2.37764 .77254 Mabsadd L
1.30392 0 -0.91448 -0.29713 Mabsadd L
1.30392 0 -1.46946 -2.02254 Mabsadd L
1.30392 0 0 -0.96154 Mabsadd L
1.30392 0 1.46946 -2.02254 Mabsadd L
1.30392 0 .91448 -0.29713 Mabsadd L
1.30392 0 2.37764 .77254 Mabsadd L
1.30392 0 .56518 .7779 Mabsadd L
1.30392 0 0 2.5 Mabsadd L closepath F
1.31373 0 0 2.5 Mabsadd m
1.31373 0 -0.56518 .7779 Mabsadd L
1.31373 0 -2.37764 .77254 Mabsadd L
1.31373 0 -0.91448 -0.29713 Mabsadd L
1.31373 0 -1.46946 -2.02254 Mabsadd L
1.31373 0 0 -0.96154 Mabsadd L
1.31373 0 1.46946 -2.02254 Mabsadd L
1.31373 0 .91448 -0.29713 Mabsadd L
1.31373 0 2.37764 .77254 Mabsadd L
1.31373 0 .56518 .7779 Mabsadd L
1.31373 0 0 2.5 Mabsadd L closepath F
1.32353 0 0 2.5 Mabsadd m
1.32353 0 -0.56518 .7779 Mabsadd L
1.32353 0 -2.37764 .77254 Mabsadd L
1.32353 0 -0.91448 -0.29713 Mabsadd L
1.32353 0 -1.46946 -2.02254 Mabsadd L
1.32353 0 0 -0.96154 Mabsadd L
1.32353 0 1.46946 -2.02254 Mabsadd L
1.32353 0 .91448 -0.29713 Mabsadd L
1.32353 0 2.37764 .77254 Mabsadd L
1.32353 0 .56518 .7779 Mabsadd L
1.32353 0 0 2.5 Mabsadd L closepath F
1.33333 0 0 2.5 Mabsadd m
1.33333 0 -0.56518 .7779 Mabsadd L
1.33333 0 -2.37764 .77254 Mabsadd L
1.33333 0 -0.91448 -0.29713 Mabsadd L
1.33333 0 -1.46946 -2.02254 Mabsadd L
1.33333 0 0 -0.96154 Mabsadd L
1.33333 0 1.46946 -2.02254 Mabsadd L
1.33333 0 .91448 -0.29713 Mabsadd L
1.33333 0 2.37764 .77254 Mabsadd L
1.33333 0 .56518 .7779 Mabsadd L
1.33333 0 0 2.5 Mabsadd L closepath F
1.34314 0 0 2.5 Mabsadd m
1.34314 0 -0.56518 .7779 Mabsadd L
1.34314 0 -2.37764 .77254 Mabsadd L
1.34314 0 -0.91448 -0.29713 Mabsadd L
1.34314 0 -1.46946 -2.02254 Mabsadd L
1.34314 0 0 -0.96154 Mabsadd L
1.34314 0 1.46946 -2.02254 Mabsadd L
1.34314 0 .91448 -0.29713 Mabsadd L
1.34314 0 2.37764 .77254 Mabsadd L
1.34314 0 .56518 .7779 Mabsadd L
1.34314 0 0 2.5 Mabsadd L closepath F
1.35294 0 0 2.5 Mabsadd m
1.35294 0 -0.56518 .7779 Mabsadd L
1.35294 0 -2.37764 .77254 Mabsadd L
1.35294 0 -0.91448 -0.29713 Mabsadd L
1.35294 0 -1.46946 -2.02254 Mabsadd L
1.35294 0 0 -0.96154 Mabsadd L
1.35294 0 1.46946 -2.02254 Mabsadd L
1.35294 0 .91448 -0.29713 Mabsadd L
1.35294 0 2.37764 .77254 Mabsadd L
1.35294 0 .56518 .7779 Mabsadd L
1.35294 0 0 2.5 Mabsadd L closepath F
1.36275 0 0 2.5 Mabsadd m
1.36275 0 -0.56518 .7779 Mabsadd L
1.36275 0 -2.37764 .77254 Mabsadd L
1.36275 0 -0.91448 -0.29713 Mabsadd L
1.36275 0 -1.46946 -2.02254 Mabsadd L
1.36275 0 0 -0.96154 Mabsadd L
1.36275 0 1.46946 -2.02254 Mabsadd L
1.36275 0 .91448 -0.29713 Mabsadd L
1.36275 0 2.37764 .77254 Mabsadd L
1.36275 0 .56518 .7779 Mabsadd L
1.36275 0 0 2.5 Mabsadd L closepath F
1.37255 0 0 2.5 Mabsadd m
1.37255 0 -0.56518 .7779 Mabsadd L
1.37255 0 -2.37764 .77254 Mabsadd L
1.37255 0 -0.91448 -0.29713 Mabsadd L
1.37255 0 -1.46946 -2.02254 Mabsadd L
1.37255 0 0 -0.96154 Mabsadd L
1.37255 0 1.46946 -2.02254 Mabsadd L
1.37255 0 .91448 -0.29713 Mabsadd L
1.37255 0 2.37764 .77254 Mabsadd L
1.37255 0 .56518 .7779 Mabsadd L
1.37255 0 0 2.5 Mabsadd L closepath F
1.38235 0 0 2.5 Mabsadd m
1.38235 0 -0.56518 .7779 Mabsadd L
1.38235 0 -2.37764 .77254 Mabsadd L
1.38235 0 -0.91448 -0.29713 Mabsadd L
1.38235 0 -1.46946 -2.02254 Mabsadd L
1.38235 0 0 -0.96154 Mabsadd L
1.38235 0 1.46946 -2.02254 Mabsadd L
1.38235 0 .91448 -0.29713 Mabsadd L
1.38235 0 2.37764 .77254 Mabsadd L
1.38235 0 .56518 .7779 Mabsadd L
1.38235 0 0 2.5 Mabsadd L closepath F
1.39216 0 0 2.5 Mabsadd m
1.39216 0 -0.56518 .7779 Mabsadd L
1.39216 0 -2.37764 .77254 Mabsadd L
1.39216 0 -0.91448 -0.29713 Mabsadd L
1.39216 0 -1.46946 -2.02254 Mabsadd L
1.39216 0 0 -0.96154 Mabsadd L
1.39216 0 1.46946 -2.02254 Mabsadd L
1.39216 0 .91448 -0.29713 Mabsadd L
1.39216 0 2.37764 .77254 Mabsadd L
1.39216 0 .56518 .7779 Mabsadd L
1.39216 0 0 2.5 Mabsadd L closepath F
1.40196 0 0 2.5 Mabsadd m
1.40196 0 -0.56518 .7779 Mabsadd L
1.40196 0 -2.37764 .77254 Mabsadd L
1.40196 0 -0.91448 -0.29713 Mabsadd L
1.40196 0 -1.46946 -2.02254 Mabsadd L
1.40196 0 0 -0.96154 Mabsadd L
1.40196 0 1.46946 -2.02254 Mabsadd L
1.40196 0 .91448 -0.29713 Mabsadd L
1.40196 0 2.37764 .77254 Mabsadd L
1.40196 0 .56518 .7779 Mabsadd L
1.40196 0 0 2.5 Mabsadd L closepath F
1.41176 0 0 2.5 Mabsadd m
1.41176 0 -0.56518 .7779 Mabsadd L
1.41176 0 -2.37764 .77254 Mabsadd L
1.41176 0 -0.91448 -0.29713 Mabsadd L
1.41176 0 -1.46946 -2.02254 Mabsadd L
1.41176 0 0 -0.96154 Mabsadd L
1.41176 0 1.46946 -2.02254 Mabsadd L
1.41176 0 .91448 -0.29713 Mabsadd L
1.41176 0 2.37764 .77254 Mabsadd L
1.41176 0 .56518 .7779 Mabsadd L
1.41176 0 0 2.5 Mabsadd L closepath F
1.42157 0 0 2.5 Mabsadd m
1.42157 0 -0.56518 .7779 Mabsadd L
1.42157 0 -2.37764 .77254 Mabsadd L
1.42157 0 -0.91448 -0.29713 Mabsadd L
1.42157 0 -1.46946 -2.02254 Mabsadd L
1.42157 0 0 -0.96154 Mabsadd L
1.42157 0 1.46946 -2.02254 Mabsadd L
1.42157 0 .91448 -0.29713 Mabsadd L
1.42157 0 2.37764 .77254 Mabsadd L
1.42157 0 .56518 .7779 Mabsadd L
1.42157 0 0 2.5 Mabsadd L closepath F
1.43137 0 0 2.5 Mabsadd m
1.43137 0 -0.56518 .7779 Mabsadd L
1.43137 0 -2.37764 .77254 Mabsadd L
1.43137 0 -0.91448 -0.29713 Mabsadd L
1.43137 0 -1.46946 -2.02254 Mabsadd L
1.43137 0 0 -0.96154 Mabsadd L
1.43137 0 1.46946 -2.02254 Mabsadd L
1.43137 0 .91448 -0.29713 Mabsadd L
1.43137 0 2.37764 .77254 Mabsadd L
1.43137 0 .56518 .7779 Mabsadd L
1.43137 0 0 2.5 Mabsadd L closepath F
1.44118 0 0 2.5 Mabsadd m
1.44118 0 -0.56518 .7779 Mabsadd L
1.44118 0 -2.37764 .77254 Mabsadd L
1.44118 0 -0.91448 -0.29713 Mabsadd L
1.44118 0 -1.46946 -2.02254 Mabsadd L
1.44118 0 0 -0.96154 Mabsadd L
1.44118 0 1.46946 -2.02254 Mabsadd L
1.44118 0 .91448 -0.29713 Mabsadd L
1.44118 0 2.37764 .77254 Mabsadd L
1.44118 0 .56518 .7779 Mabsadd L
1.44118 0 0 2.5 Mabsadd L closepath F
1.45098 0 0 2.5 Mabsadd m
1.45098 0 -0.56518 .7779 Mabsadd L
1.45098 0 -2.37764 .77254 Mabsadd L
1.45098 0 -0.91448 -0.29713 Mabsadd L
1.45098 0 -1.46946 -2.02254 Mabsadd L
1.45098 0 0 -0.96154 Mabsadd L
1.45098 0 1.46946 -2.02254 Mabsadd L
1.45098 0 .91448 -0.29713 Mabsadd L
1.45098 0 2.37764 .77254 Mabsadd L
1.45098 0 .56518 .7779 Mabsadd L
1.45098 0 0 2.5 Mabsadd L closepath F
1.46078 0 0 2.5 Mabsadd m
1.46078 0 -0.56518 .7779 Mabsadd L
1.46078 0 -2.37764 .77254 Mabsadd L
1.46078 0 -0.91448 -0.29713 Mabsadd L
1.46078 0 -1.46946 -2.02254 Mabsadd L
1.46078 0 0 -0.96154 Mabsadd L
1.46078 0 1.46946 -2.02254 Mabsadd L
1.46078 0 .91448 -0.29713 Mabsadd L
1.46078 0 2.37764 .77254 Mabsadd L
1.46078 0 .56518 .7779 Mabsadd L
1.46078 0 0 2.5 Mabsadd L closepath F
1.47059 0 0 2.5 Mabsadd m
1.47059 0 -0.56518 .7779 Mabsadd L
1.47059 0 -2.37764 .77254 Mabsadd L
1.47059 0 -0.91448 -0.29713 Mabsadd L
1.47059 0 -1.46946 -2.02254 Mabsadd L
1.47059 0 0 -0.96154 Mabsadd L
1.47059 0 1.46946 -2.02254 Mabsadd L
1.47059 0 .91448 -0.29713 Mabsadd L
1.47059 0 2.37764 .77254 Mabsadd L
1.47059 0 .56518 .7779 Mabsadd L
1.47059 0 0 2.5 Mabsadd L closepath F
1.48039 0 0 2.5 Mabsadd m
1.48039 0 -0.56518 .7779 Mabsadd L
1.48039 0 -2.37764 .77254 Mabsadd L
1.48039 0 -0.91448 -0.29713 Mabsadd L
1.48039 0 -1.46946 -2.02254 Mabsadd L
1.48039 0 0 -0.96154 Mabsadd L
1.48039 0 1.46946 -2.02254 Mabsadd L
1.48039 0 .91448 -0.29713 Mabsadd L
1.48039 0 2.37764 .77254 Mabsadd L
1.48039 0 .56518 .7779 Mabsadd L
1.48039 0 0 2.5 Mabsadd L closepath F
1.4902 0 0 2.5 Mabsadd m
1.4902 0 -0.56518 .7779 Mabsadd L
1.4902 0 -2.37764 .77254 Mabsadd L
1.4902 0 -0.91448 -0.29713 Mabsadd L
1.4902 0 -1.46946 -2.02254 Mabsadd L
1.4902 0 0 -0.96154 Mabsadd L
1.4902 0 1.46946 -2.02254 Mabsadd L
1.4902 0 .91448 -0.29713 Mabsadd L
1.4902 0 2.37764 .77254 Mabsadd L
1.4902 0 .56518 .7779 Mabsadd L
1.4902 0 0 2.5 Mabsadd L closepath F
1.5 0 0 2.5 Mabsadd m
1.5 0 -0.56518 .7779 Mabsadd L
1.5 0 -2.37764 .77254 Mabsadd L
1.5 0 -0.91448 -0.29713 Mabsadd L
1.5 0 -1.46946 -2.02254 Mabsadd L
1.5 0 0 -0.96154 Mabsadd L
1.5 0 1.46946 -2.02254 Mabsadd L
1.5 0 .91448 -0.29713 Mabsadd L
1.5 0 2.37764 .77254 Mabsadd L
1.5 0 .56518 .7779 Mabsadd L
1.5 0 0 2.5 Mabsadd L closepath F
1.5098 0 0 2.5 Mabsadd m
1.5098 0 -0.56518 .7779 Mabsadd L
1.5098 0 -2.37764 .77254 Mabsadd L
1.5098 0 -0.91448 -0.29713 Mabsadd L
1.5098 0 -1.46946 -2.02254 Mabsadd L
1.5098 0 0 -0.96154 Mabsadd L
1.5098 0 1.46946 -2.02254 Mabsadd L
1.5098 0 .91448 -0.29713 Mabsadd L
1.5098 0 2.37764 .77254 Mabsadd L
1.5098 0 .56518 .7779 Mabsadd L
1.5098 0 0 2.5 Mabsadd L closepath F
1.51961 0 0 2.5 Mabsadd m
1.51961 0 -0.56518 .7779 Mabsadd L
1.51961 0 -2.37764 .77254 Mabsadd L
1.51961 0 -0.91448 -0.29713 Mabsadd L
1.51961 0 -1.46946 -2.02254 Mabsadd L
1.51961 0 0 -0.96154 Mabsadd L
1.51961 0 1.46946 -2.02254 Mabsadd L
1.51961 0 .91448 -0.29713 Mabsadd L
1.51961 0 2.37764 .77254 Mabsadd L
1.51961 0 .56518 .7779 Mabsadd L
1.51961 0 0 2.5 Mabsadd L closepath F
1.52941 0 0 2.5 Mabsadd m
1.52941 0 -0.56518 .7779 Mabsadd L
1.52941 0 -2.37764 .77254 Mabsadd L
1.52941 0 -0.91448 -0.29713 Mabsadd L
1.52941 0 -1.46946 -2.02254 Mabsadd L
1.52941 0 0 -0.96154 Mabsadd L
1.52941 0 1.46946 -2.02254 Mabsadd L
1.52941 0 .91448 -0.29713 Mabsadd L
1.52941 0 2.37764 .77254 Mabsadd L
1.52941 0 .56518 .7779 Mabsadd L
1.52941 0 0 2.5 Mabsadd L closepath F
1.53922 0 0 2.5 Mabsadd m
1.53922 0 -0.56518 .7779 Mabsadd L
1.53922 0 -2.37764 .77254 Mabsadd L
1.53922 0 -0.91448 -0.29713 Mabsadd L
1.53922 0 -1.46946 -2.02254 Mabsadd L
1.53922 0 0 -0.96154 Mabsadd L
1.53922 0 1.46946 -2.02254 Mabsadd L
1.53922 0 .91448 -0.29713 Mabsadd L
1.53922 0 2.37764 .77254 Mabsadd L
1.53922 0 .56518 .7779 Mabsadd L
1.53922 0 0 2.5 Mabsadd L closepath F
1.54902 0 0 2.5 Mabsadd m
1.54902 0 -0.56518 .7779 Mabsadd L
1.54902 0 -2.37764 .77254 Mabsadd L
1.54902 0 -0.91448 -0.29713 Mabsadd L
1.54902 0 -1.46946 -2.02254 Mabsadd L
1.54902 0 0 -0.96154 Mabsadd L
1.54902 0 1.46946 -2.02254 Mabsadd L
1.54902 0 .91448 -0.29713 Mabsadd L
1.54902 0 2.37764 .77254 Mabsadd L
1.54902 0 .56518 .7779 Mabsadd L
1.54902 0 0 2.5 Mabsadd L closepath F
1.55882 0 0 2.5 Mabsadd m
1.55882 0 -0.56518 .7779 Mabsadd L
1.55882 0 -2.37764 .77254 Mabsadd L
1.55882 0 -0.91448 -0.29713 Mabsadd L
1.55882 0 -1.46946 -2.02254 Mabsadd L
1.55882 0 0 -0.96154 Mabsadd L
1.55882 0 1.46946 -2.02254 Mabsadd L
1.55882 0 .91448 -0.29713 Mabsadd L
1.55882 0 2.37764 .77254 Mabsadd L
1.55882 0 .56518 .7779 Mabsadd L
1.55882 0 0 2.5 Mabsadd L closepath F
1.56863 0 0 2.5 Mabsadd m
1.56863 0 -0.56518 .7779 Mabsadd L
1.56863 0 -2.37764 .77254 Mabsadd L
1.56863 0 -0.91448 -0.29713 Mabsadd L
1.56863 0 -1.46946 -2.02254 Mabsadd L
1.56863 0 0 -0.96154 Mabsadd L
1.56863 0 1.46946 -2.02254 Mabsadd L
1.56863 0 .91448 -0.29713 Mabsadd L
1.56863 0 2.37764 .77254 Mabsadd L
1.56863 0 .56518 .7779 Mabsadd L
1.56863 0 0 2.5 Mabsadd L closepath F
1.57843 0 0 2.5 Mabsadd m
1.57843 0 -0.56518 .7779 Mabsadd L
1.57843 0 -2.37764 .77254 Mabsadd L
1.57843 0 -0.91448 -0.29713 Mabsadd L
1.57843 0 -1.46946 -2.02254 Mabsadd L
1.57843 0 0 -0.96154 Mabsadd L
1.57843 0 1.46946 -2.02254 Mabsadd L
1.57843 0 .91448 -0.29713 Mabsadd L
1.57843 0 2.37764 .77254 Mabsadd L
1.57843 0 .56518 .7779 Mabsadd L
1.57843 0 0 2.5 Mabsadd L closepath F
1.58824 0 0 2.5 Mabsadd m
1.58824 0 -0.56518 .7779 Mabsadd L
1.58824 0 -2.37764 .77254 Mabsadd L
1.58824 0 -0.91448 -0.29713 Mabsadd L
1.58824 0 -1.46946 -2.02254 Mabsadd L
1.58824 0 0 -0.96154 Mabsadd L
1.58824 0 1.46946 -2.02254 Mabsadd L
1.58824 0 .91448 -0.29713 Mabsadd L
1.58824 0 2.37764 .77254 Mabsadd L
1.58824 0 .56518 .7779 Mabsadd L
1.58824 0 0 2.5 Mabsadd L closepath F
1.59804 0 0 2.5 Mabsadd m
1.59804 0 -0.56518 .7779 Mabsadd L
1.59804 0 -2.37764 .77254 Mabsadd L
1.59804 0 -0.91448 -0.29713 Mabsadd L
1.59804 0 -1.46946 -2.02254 Mabsadd L
1.59804 0 0 -0.96154 Mabsadd L
1.59804 0 1.46946 -2.02254 Mabsadd L
1.59804 0 .91448 -0.29713 Mabsadd L
1.59804 0 2.37764 .77254 Mabsadd L
1.59804 0 .56518 .7779 Mabsadd L
1.59804 0 0 2.5 Mabsadd L closepath F
1.60784 0 0 2.5 Mabsadd m
1.60784 0 -0.56518 .7779 Mabsadd L
1.60784 0 -2.37764 .77254 Mabsadd L
1.60784 0 -0.91448 -0.29713 Mabsadd L
1.60784 0 -1.46946 -2.02254 Mabsadd L
1.60784 0 0 -0.96154 Mabsadd L
1.60784 0 1.46946 -2.02254 Mabsadd L
1.60784 0 .91448 -0.29713 Mabsadd L
1.60784 0 2.37764 .77254 Mabsadd L
1.60784 0 .56518 .7779 Mabsadd L
1.60784 0 0 2.5 Mabsadd L closepath F
1.61765 0 0 2.5 Mabsadd m
1.61765 0 -0.56518 .7779 Mabsadd L
1.61765 0 -2.37764 .77254 Mabsadd L
1.61765 0 -0.91448 -0.29713 Mabsadd L
1.61765 0 -1.46946 -2.02254 Mabsadd L
1.61765 0 0 -0.96154 Mabsadd L
1.61765 0 1.46946 -2.02254 Mabsadd L
1.61765 0 .91448 -0.29713 Mabsadd L
1.61765 0 2.37764 .77254 Mabsadd L
1.61765 0 .56518 .7779 Mabsadd L
1.61765 0 0 2.5 Mabsadd L closepath F
1.62745 0 0 2.5 Mabsadd m
1.62745 0 -0.56518 .7779 Mabsadd L
1.62745 0 -2.37764 .77254 Mabsadd L
1.62745 0 -0.91448 -0.29713 Mabsadd L
1.62745 0 -1.46946 -2.02254 Mabsadd L
1.62745 0 0 -0.96154 Mabsadd L
1.62745 0 1.46946 -2.02254 Mabsadd L
1.62745 0 .91448 -0.29713 Mabsadd L
1.62745 0 2.37764 .77254 Mabsadd L
1.62745 0 .56518 .7779 Mabsadd L
1.62745 0 0 2.5 Mabsadd L closepath F
1.63725 0 0 2.5 Mabsadd m
1.63725 0 -0.56518 .7779 Mabsadd L
1.63725 0 -2.37764 .77254 Mabsadd L
1.63725 0 -0.91448 -0.29713 Mabsadd L
1.63725 0 -1.46946 -2.02254 Mabsadd L
1.63725 0 0 -0.96154 Mabsadd L
1.63725 0 1.46946 -2.02254 Mabsadd L
1.63725 0 .91448 -0.29713 Mabsadd L
1.63725 0 2.37764 .77254 Mabsadd L
1.63725 0 .56518 .7779 Mabsadd L
1.63725 0 0 2.5 Mabsadd L closepath F
1.64706 0 0 2.5 Mabsadd m
1.64706 0 -0.56518 .7779 Mabsadd L
1.64706 0 -2.37764 .77254 Mabsadd L
1.64706 0 -0.91448 -0.29713 Mabsadd L
1.64706 0 -1.46946 -2.02254 Mabsadd L
1.64706 0 0 -0.96154 Mabsadd L
1.64706 0 1.46946 -2.02254 Mabsadd L
1.64706 0 .91448 -0.29713 Mabsadd L
1.64706 0 2.37764 .77254 Mabsadd L
1.64706 0 .56518 .7779 Mabsadd L
1.64706 0 0 2.5 Mabsadd L closepath F
1.65686 0 0 2.5 Mabsadd m
1.65686 0 -0.56518 .7779 Mabsadd L
1.65686 0 -2.37764 .77254 Mabsadd L
1.65686 0 -0.91448 -0.29713 Mabsadd L
1.65686 0 -1.46946 -2.02254 Mabsadd L
1.65686 0 0 -0.96154 Mabsadd L
1.65686 0 1.46946 -2.02254 Mabsadd L
1.65686 0 .91448 -0.29713 Mabsadd L
1.65686 0 2.37764 .77254 Mabsadd L
1.65686 0 .56518 .7779 Mabsadd L
1.65686 0 0 2.5 Mabsadd L closepath F
1.66667 0 0 2.5 Mabsadd m
1.66667 0 -0.56518 .7779 Mabsadd L
1.66667 0 -2.37764 .77254 Mabsadd L
1.66667 0 -0.91448 -0.29713 Mabsadd L
1.66667 0 -1.46946 -2.02254 Mabsadd L
1.66667 0 0 -0.96154 Mabsadd L
1.66667 0 1.46946 -2.02254 Mabsadd L
1.66667 0 .91448 -0.29713 Mabsadd L
1.66667 0 2.37764 .77254 Mabsadd L
1.66667 0 .56518 .7779 Mabsadd L
1.66667 0 0 2.5 Mabsadd L closepath F
1.67647 0 0 2.5 Mabsadd m
1.67647 0 -0.56518 .7779 Mabsadd L
1.67647 0 -2.37764 .77254 Mabsadd L
1.67647 0 -0.91448 -0.29713 Mabsadd L
1.67647 0 -1.46946 -2.02254 Mabsadd L
1.67647 0 0 -0.96154 Mabsadd L
1.67647 0 1.46946 -2.02254 Mabsadd L
1.67647 0 .91448 -0.29713 Mabsadd L
1.67647 0 2.37764 .77254 Mabsadd L
1.67647 0 .56518 .7779 Mabsadd L
1.67647 0 0 2.5 Mabsadd L closepath F
1.68627 0 0 2.5 Mabsadd m
1.68627 0 -0.56518 .7779 Mabsadd L
1.68627 0 -2.37764 .77254 Mabsadd L
1.68627 0 -0.91448 -0.29713 Mabsadd L
1.68627 0 -1.46946 -2.02254 Mabsadd L
1.68627 0 0 -0.96154 Mabsadd L
1.68627 0 1.46946 -2.02254 Mabsadd L
1.68627 0 .91448 -0.29713 Mabsadd L
1.68627 0 2.37764 .77254 Mabsadd L
1.68627 0 .56518 .7779 Mabsadd L
1.68627 0 0 2.5 Mabsadd L closepath F
1.69608 0 0 2.5 Mabsadd m
1.69608 0 -0.56518 .7779 Mabsadd L
1.69608 0 -2.37764 .77254 Mabsadd L
1.69608 0 -0.91448 -0.29713 Mabsadd L
1.69608 0 -1.46946 -2.02254 Mabsadd L
1.69608 0 0 -0.96154 Mabsadd L
1.69608 0 1.46946 -2.02254 Mabsadd L
1.69608 0 .91448 -0.29713 Mabsadd L
1.69608 0 2.37764 .77254 Mabsadd L
1.69608 0 .56518 .7779 Mabsadd L
1.69608 0 0 2.5 Mabsadd L closepath F
1.70588 0 0 2.5 Mabsadd m
1.70588 0 -0.56518 .7779 Mabsadd L
1.70588 0 -2.37764 .77254 Mabsadd L
1.70588 0 -0.91448 -0.29713 Mabsadd L
1.70588 0 -1.46946 -2.02254 Mabsadd L
1.70588 0 0 -0.96154 Mabsadd L
1.70588 0 1.46946 -2.02254 Mabsadd L
1.70588 0 .91448 -0.29713 Mabsadd L
1.70588 0 2.37764 .77254 Mabsadd L
1.70588 0 .56518 .7779 Mabsadd L
1.70588 0 0 2.5 Mabsadd L closepath F
1.71569 0 0 2.5 Mabsadd m
1.71569 0 -0.56518 .7779 Mabsadd L
1.71569 0 -2.37764 .77254 Mabsadd L
1.71569 0 -0.91448 -0.29713 Mabsadd L
1.71569 0 -1.46946 -2.02254 Mabsadd L
1.71569 0 0 -0.96154 Mabsadd L
1.71569 0 1.46946 -2.02254 Mabsadd L
1.71569 0 .91448 -0.29713 Mabsadd L
1.71569 0 2.37764 .77254 Mabsadd L
1.71569 0 .56518 .7779 Mabsadd L
1.71569 0 0 2.5 Mabsadd L closepath F
1.72549 0 0 2.5 Mabsadd m
1.72549 0 -0.56518 .7779 Mabsadd L
1.72549 0 -2.37764 .77254 Mabsadd L
1.72549 0 -0.91448 -0.29713 Mabsadd L
1.72549 0 -1.46946 -2.02254 Mabsadd L
1.72549 0 0 -0.96154 Mabsadd L
1.72549 0 1.46946 -2.02254 Mabsadd L
1.72549 0 .91448 -0.29713 Mabsadd L
1.72549 0 2.37764 .77254 Mabsadd L
1.72549 0 .56518 .7779 Mabsadd L
1.72549 0 0 2.5 Mabsadd L closepath F
1.73529 0 0 2.5 Mabsadd m
1.73529 0 -0.56518 .7779 Mabsadd L
1.73529 0 -2.37764 .77254 Mabsadd L
1.73529 0 -0.91448 -0.29713 Mabsadd L
1.73529 0 -1.46946 -2.02254 Mabsadd L
1.73529 0 0 -0.96154 Mabsadd L
1.73529 0 1.46946 -2.02254 Mabsadd L
1.73529 0 .91448 -0.29713 Mabsadd L
1.73529 0 2.37764 .77254 Mabsadd L
1.73529 0 .56518 .7779 Mabsadd L
1.73529 0 0 2.5 Mabsadd L closepath F
1.7451 0 0 2.5 Mabsadd m
1.7451 0 -0.56518 .7779 Mabsadd L
1.7451 0 -2.37764 .77254 Mabsadd L
1.7451 0 -0.91448 -0.29713 Mabsadd L
1.7451 0 -1.46946 -2.02254 Mabsadd L
1.7451 0 0 -0.96154 Mabsadd L
1.7451 0 1.46946 -2.02254 Mabsadd L
1.7451 0 .91448 -0.29713 Mabsadd L
1.7451 0 2.37764 .77254 Mabsadd L
1.7451 0 .56518 .7779 Mabsadd L
1.7451 0 0 2.5 Mabsadd L closepath F
1.7549 0 0 2.5 Mabsadd m
1.7549 0 -0.56518 .7779 Mabsadd L
1.7549 0 -2.37764 .77254 Mabsadd L
1.7549 0 -0.91448 -0.29713 Mabsadd L
1.7549 0 -1.46946 -2.02254 Mabsadd L
1.7549 0 0 -0.96154 Mabsadd L
1.7549 0 1.46946 -2.02254 Mabsadd L
1.7549 0 .91448 -0.29713 Mabsadd L
1.7549 0 2.37764 .77254 Mabsadd L
1.7549 0 .56518 .7779 Mabsadd L
1.7549 0 0 2.5 Mabsadd L closepath F
1.76471 0 0 2.5 Mabsadd m
1.76471 0 -0.56518 .7779 Mabsadd L
1.76471 0 -2.37764 .77254 Mabsadd L
1.76471 0 -0.91448 -0.29713 Mabsadd L
1.76471 0 -1.46946 -2.02254 Mabsadd L
1.76471 0 0 -0.96154 Mabsadd L
1.76471 0 1.46946 -2.02254 Mabsadd L
1.76471 0 .91448 -0.29713 Mabsadd L
1.76471 0 2.37764 .77254 Mabsadd L
1.76471 0 .56518 .7779 Mabsadd L
1.76471 0 0 2.5 Mabsadd L closepath F
1.77451 0 0 2.5 Mabsadd m
1.77451 0 -0.56518 .7779 Mabsadd L
1.77451 0 -2.37764 .77254 Mabsadd L
1.77451 0 -0.91448 -0.29713 Mabsadd L
1.77451 0 -1.46946 -2.02254 Mabsadd L
1.77451 0 0 -0.96154 Mabsadd L
1.77451 0 1.46946 -2.02254 Mabsadd L
1.77451 0 .91448 -0.29713 Mabsadd L
1.77451 0 2.37764 .77254 Mabsadd L
1.77451 0 .56518 .7779 Mabsadd L
1.77451 0 0 2.5 Mabsadd L closepath F
1.78431 0 0 2.5 Mabsadd m
1.78431 0 -0.56518 .7779 Mabsadd L
1.78431 0 -2.37764 .77254 Mabsadd L
1.78431 0 -0.91448 -0.29713 Mabsadd L
1.78431 0 -1.46946 -2.02254 Mabsadd L
1.78431 0 0 -0.96154 Mabsadd L
1.78431 0 1.46946 -2.02254 Mabsadd L
1.78431 0 .91448 -0.29713 Mabsadd L
1.78431 0 2.37764 .77254 Mabsadd L
1.78431 0 .56518 .7779 Mabsadd L
1.78431 0 0 2.5 Mabsadd L closepath F
1.79412 0 0 2.5 Mabsadd m
1.79412 0 -0.56518 .7779 Mabsadd L
1.79412 0 -2.37764 .77254 Mabsadd L
1.79412 0 -0.91448 -0.29713 Mabsadd L
1.79412 0 -1.46946 -2.02254 Mabsadd L
1.79412 0 0 -0.96154 Mabsadd L
1.79412 0 1.46946 -2.02254 Mabsadd L
1.79412 0 .91448 -0.29713 Mabsadd L
1.79412 0 2.37764 .77254 Mabsadd L
1.79412 0 .56518 .7779 Mabsadd L
1.79412 0 0 2.5 Mabsadd L closepath F
1.80392 0 0 2.5 Mabsadd m
1.80392 0 -0.56518 .7779 Mabsadd L
1.80392 0 -2.37764 .77254 Mabsadd L
1.80392 0 -0.91448 -0.29713 Mabsadd L
1.80392 0 -1.46946 -2.02254 Mabsadd L
1.80392 0 0 -0.96154 Mabsadd L
1.80392 0 1.46946 -2.02254 Mabsadd L
1.80392 0 .91448 -0.29713 Mabsadd L
1.80392 0 2.37764 .77254 Mabsadd L
1.80392 0 .56518 .7779 Mabsadd L
1.80392 0 0 2.5 Mabsadd L closepath F
1.81373 0 0 2.5 Mabsadd m
1.81373 0 -0.56518 .7779 Mabsadd L
1.81373 0 -2.37764 .77254 Mabsadd L
1.81373 0 -0.91448 -0.29713 Mabsadd L
1.81373 0 -1.46946 -2.02254 Mabsadd L
1.81373 0 0 -0.96154 Mabsadd L
1.81373 0 1.46946 -2.02254 Mabsadd L
1.81373 0 .91448 -0.29713 Mabsadd L
1.81373 0 2.37764 .77254 Mabsadd L
1.81373 0 .56518 .7779 Mabsadd L
1.81373 0 0 2.5 Mabsadd L closepath F
1.82353 0 0 2.5 Mabsadd m
1.82353 0 -0.56518 .7779 Mabsadd L
1.82353 0 -2.37764 .77254 Mabsadd L
1.82353 0 -0.91448 -0.29713 Mabsadd L
1.82353 0 -1.46946 -2.02254 Mabsadd L
1.82353 0 0 -0.96154 Mabsadd L
1.82353 0 1.46946 -2.02254 Mabsadd L
1.82353 0 .91448 -0.29713 Mabsadd L
1.82353 0 2.37764 .77254 Mabsadd L
1.82353 0 .56518 .7779 Mabsadd L
1.82353 0 0 2.5 Mabsadd L closepath F
1.83333 0 0 2.5 Mabsadd m
1.83333 0 -0.56518 .7779 Mabsadd L
1.83333 0 -2.37764 .77254 Mabsadd L
1.83333 0 -0.91448 -0.29713 Mabsadd L
1.83333 0 -1.46946 -2.02254 Mabsadd L
1.83333 0 0 -0.96154 Mabsadd L
1.83333 0 1.46946 -2.02254 Mabsadd L
1.83333 0 .91448 -0.29713 Mabsadd L
1.83333 0 2.37764 .77254 Mabsadd L
1.83333 0 .56518 .7779 Mabsadd L
1.83333 0 0 2.5 Mabsadd L closepath F
1.84314 0 0 2.5 Mabsadd m
1.84314 0 -0.56518 .7779 Mabsadd L
1.84314 0 -2.37764 .77254 Mabsadd L
1.84314 0 -0.91448 -0.29713 Mabsadd L
1.84314 0 -1.46946 -2.02254 Mabsadd L
1.84314 0 0 -0.96154 Mabsadd L
1.84314 0 1.46946 -2.02254 Mabsadd L
1.84314 0 .91448 -0.29713 Mabsadd L
1.84314 0 2.37764 .77254 Mabsadd L
1.84314 0 .56518 .7779 Mabsadd L
1.84314 0 0 2.5 Mabsadd L closepath F
1.85294 0 0 2.5 Mabsadd m
1.85294 0 -0.56518 .7779 Mabsadd L
1.85294 0 -2.37764 .77254 Mabsadd L
1.85294 0 -0.91448 -0.29713 Mabsadd L
1.85294 0 -1.46946 -2.02254 Mabsadd L
1.85294 0 0 -0.96154 Mabsadd L
1.85294 0 1.46946 -2.02254 Mabsadd L
1.85294 0 .91448 -0.29713 Mabsadd L
1.85294 0 2.37764 .77254 Mabsadd L
1.85294 0 .56518 .7779 Mabsadd L
1.85294 0 0 2.5 Mabsadd L closepath F
1.86275 0 0 2.5 Mabsadd m
1.86275 0 -0.56518 .7779 Mabsadd L
1.86275 0 -2.37764 .77254 Mabsadd L
1.86275 0 -0.91448 -0.29713 Mabsadd L
1.86275 0 -1.46946 -2.02254 Mabsadd L
1.86275 0 0 -0.96154 Mabsadd L
1.86275 0 1.46946 -2.02254 Mabsadd L
1.86275 0 .91448 -0.29713 Mabsadd L
1.86275 0 2.37764 .77254 Mabsadd L
1.86275 0 .56518 .7779 Mabsadd L
1.86275 0 0 2.5 Mabsadd L closepath F
1.87255 0 0 2.5 Mabsadd m
1.87255 0 -0.56518 .7779 Mabsadd L
1.87255 0 -2.37764 .77254 Mabsadd L
1.87255 0 -0.91448 -0.29713 Mabsadd L
1.87255 0 -1.46946 -2.02254 Mabsadd L
1.87255 0 0 -0.96154 Mabsadd L
1.87255 0 1.46946 -2.02254 Mabsadd L
1.87255 0 .91448 -0.29713 Mabsadd L
1.87255 0 2.37764 .77254 Mabsadd L
1.87255 0 .56518 .7779 Mabsadd L
1.87255 0 0 2.5 Mabsadd L closepath F
1.88235 0 0 2.5 Mabsadd m
1.88235 0 -0.56518 .7779 Mabsadd L
1.88235 0 -2.37764 .77254 Mabsadd L
1.88235 0 -0.91448 -0.29713 Mabsadd L
1.88235 0 -1.46946 -2.02254 Mabsadd L
1.88235 0 0 -0.96154 Mabsadd L
1.88235 0 1.46946 -2.02254 Mabsadd L
1.88235 0 .91448 -0.29713 Mabsadd L
1.88235 0 2.37764 .77254 Mabsadd L
1.88235 0 .56518 .7779 Mabsadd L
1.88235 0 0 2.5 Mabsadd L closepath F
1.89216 0 0 2.5 Mabsadd m
1.89216 0 -0.56518 .7779 Mabsadd L
1.89216 0 -2.37764 .77254 Mabsadd L
1.89216 0 -0.91448 -0.29713 Mabsadd L
1.89216 0 -1.46946 -2.02254 Mabsadd L
1.89216 0 0 -0.96154 Mabsadd L
1.89216 0 1.46946 -2.02254 Mabsadd L
1.89216 0 .91448 -0.29713 Mabsadd L
1.89216 0 2.37764 .77254 Mabsadd L
1.89216 0 .56518 .7779 Mabsadd L
1.89216 0 0 2.5 Mabsadd L closepath F
1.90196 0 0 2.5 Mabsadd m
1.90196 0 -0.56518 .7779 Mabsadd L
1.90196 0 -2.37764 .77254 Mabsadd L
1.90196 0 -0.91448 -0.29713 Mabsadd L
1.90196 0 -1.46946 -2.02254 Mabsadd L
1.90196 0 0 -0.96154 Mabsadd L
1.90196 0 1.46946 -2.02254 Mabsadd L
1.90196 0 .91448 -0.29713 Mabsadd L
1.90196 0 2.37764 .77254 Mabsadd L
1.90196 0 .56518 .7779 Mabsadd L
1.90196 0 0 2.5 Mabsadd L closepath F
1.91176 0 0 2.5 Mabsadd m
1.91176 0 -0.56518 .7779 Mabsadd L
1.91176 0 -2.37764 .77254 Mabsadd L
1.91176 0 -0.91448 -0.29713 Mabsadd L
1.91176 0 -1.46946 -2.02254 Mabsadd L
1.91176 0 0 -0.96154 Mabsadd L
1.91176 0 1.46946 -2.02254 Mabsadd L
1.91176 0 .91448 -0.29713 Mabsadd L
1.91176 0 2.37764 .77254 Mabsadd L
1.91176 0 .56518 .7779 Mabsadd L
1.91176 0 0 2.5 Mabsadd L closepath F
1.92157 0 0 2.5 Mabsadd m
1.92157 0 -0.56518 .7779 Mabsadd L
1.92157 0 -2.37764 .77254 Mabsadd L
1.92157 0 -0.91448 -0.29713 Mabsadd L
1.92157 0 -1.46946 -2.02254 Mabsadd L
1.92157 0 0 -0.96154 Mabsadd L
1.92157 0 1.46946 -2.02254 Mabsadd L
1.92157 0 .91448 -0.29713 Mabsadd L
1.92157 0 2.37764 .77254 Mabsadd L
1.92157 0 .56518 .7779 Mabsadd L
1.92157 0 0 2.5 Mabsadd L closepath F
1.93137 0 0 2.5 Mabsadd m
1.93137 0 -0.56518 .7779 Mabsadd L
1.93137 0 -2.37764 .77254 Mabsadd L
1.93137 0 -0.91448 -0.29713 Mabsadd L
1.93137 0 -1.46946 -2.02254 Mabsadd L
1.93137 0 0 -0.96154 Mabsadd L
1.93137 0 1.46946 -2.02254 Mabsadd L
1.93137 0 .91448 -0.29713 Mabsadd L
1.93137 0 2.37764 .77254 Mabsadd L
1.93137 0 .56518 .7779 Mabsadd L
1.93137 0 0 2.5 Mabsadd L closepath F
1.94118 0 0 2.5 Mabsadd m
1.94118 0 -0.56518 .7779 Mabsadd L
1.94118 0 -2.37764 .77254 Mabsadd L
1.94118 0 -0.91448 -0.29713 Mabsadd L
1.94118 0 -1.46946 -2.02254 Mabsadd L
1.94118 0 0 -0.96154 Mabsadd L
1.94118 0 1.46946 -2.02254 Mabsadd L
1.94118 0 .91448 -0.29713 Mabsadd L
1.94118 0 2.37764 .77254 Mabsadd L
1.94118 0 .56518 .7779 Mabsadd L
1.94118 0 0 2.5 Mabsadd L closepath F
1.95098 0 0 2.5 Mabsadd m
1.95098 0 -0.56518 .7779 Mabsadd L
1.95098 0 -2.37764 .77254 Mabsadd L
1.95098 0 -0.91448 -0.29713 Mabsadd L
1.95098 0 -1.46946 -2.02254 Mabsadd L
1.95098 0 0 -0.96154 Mabsadd L
1.95098 0 1.46946 -2.02254 Mabsadd L
1.95098 0 .91448 -0.29713 Mabsadd L
1.95098 0 2.37764 .77254 Mabsadd L
1.95098 0 .56518 .7779 Mabsadd L
1.95098 0 0 2.5 Mabsadd L closepath F
1.96078 0 0 2.5 Mabsadd m
1.96078 0 -0.56518 .7779 Mabsadd L
1.96078 0 -2.37764 .77254 Mabsadd L
1.96078 0 -0.91448 -0.29713 Mabsadd L
1.96078 0 -1.46946 -2.02254 Mabsadd L
1.96078 0 0 -0.96154 Mabsadd L
1.96078 0 1.46946 -2.02254 Mabsadd L
1.96078 0 .91448 -0.29713 Mabsadd L
1.96078 0 2.37764 .77254 Mabsadd L
1.96078 0 .56518 .7779 Mabsadd L
1.96078 0 0 2.5 Mabsadd L closepath F
1.97059 0 0 2.5 Mabsadd m
1.97059 0 -0.56518 .7779 Mabsadd L
1.97059 0 -2.37764 .77254 Mabsadd L
1.97059 0 -0.91448 -0.29713 Mabsadd L
1.97059 0 -1.46946 -2.02254 Mabsadd L
1.97059 0 0 -0.96154 Mabsadd L
1.97059 0 1.46946 -2.02254 Mabsadd L
1.97059 0 .91448 -0.29713 Mabsadd L
1.97059 0 2.37764 .77254 Mabsadd L
1.97059 0 .56518 .7779 Mabsadd L
1.97059 0 0 2.5 Mabsadd L closepath F
1.98039 0 0 2.5 Mabsadd m
1.98039 0 -0.56518 .7779 Mabsadd L
1.98039 0 -2.37764 .77254 Mabsadd L
1.98039 0 -0.91448 -0.29713 Mabsadd L
1.98039 0 -1.46946 -2.02254 Mabsadd L
1.98039 0 0 -0.96154 Mabsadd L
1.98039 0 1.46946 -2.02254 Mabsadd L
1.98039 0 .91448 -0.29713 Mabsadd L
1.98039 0 2.37764 .77254 Mabsadd L
1.98039 0 .56518 .7779 Mabsadd L
1.98039 0 0 2.5 Mabsadd L closepath F
1.9902 0 0 2.5 Mabsadd m
1.9902 0 -0.56518 .7779 Mabsadd L
1.9902 0 -2.37764 .77254 Mabsadd L
1.9902 0 -0.91448 -0.29713 Mabsadd L
1.9902 0 -1.46946 -2.02254 Mabsadd L
1.9902 0 0 -0.96154 Mabsadd L
1.9902 0 1.46946 -2.02254 Mabsadd L
1.9902 0 .91448 -0.29713 Mabsadd L
1.9902 0 2.37764 .77254 Mabsadd L
1.9902 0 .56518 .7779 Mabsadd L
1.9902 0 0 2.5 Mabsadd L closepath F
2 0 0 2.5 Mabsadd m
2 0 -0.56518 .7779 Mabsadd L
2 0 -2.37764 .77254 Mabsadd L
2 0 -0.91448 -0.29713 Mabsadd L
2 0 -1.46946 -2.02254 Mabsadd L
2 0 0 -0.96154 Mabsadd L
2 0 1.46946 -2.02254 Mabsadd L
2 0 .91448 -0.29713 Mabsadd L
2 0 2.37764 .77254 Mabsadd L
2 0 .56518 .7779 Mabsadd L
2 0 0 2.5 Mabsadd L closepath F
2.0098 0 0 2.5 Mabsadd m
2.0098 0 -0.56518 .7779 Mabsadd L
2.0098 0 -2.37764 .77254 Mabsadd L
2.0098 0 -0.91448 -0.29713 Mabsadd L
2.0098 0 -1.46946 -2.02254 Mabsadd L
2.0098 0 0 -0.96154 Mabsadd L
2.0098 0 1.46946 -2.02254 Mabsadd L
2.0098 0 .91448 -0.29713 Mabsadd L
2.0098 0 2.37764 .77254 Mabsadd L
2.0098 0 .56518 .7779 Mabsadd L
2.0098 0 0 2.5 Mabsadd L closepath F
2.01961 0 0 2.5 Mabsadd m
2.01961 0 -0.56518 .7779 Mabsadd L
2.01961 0 -2.37764 .77254 Mabsadd L
2.01961 0 -0.91448 -0.29713 Mabsadd L
2.01961 0 -1.46946 -2.02254 Mabsadd L
2.01961 0 0 -0.96154 Mabsadd L
2.01961 0 1.46946 -2.02254 Mabsadd L
2.01961 0 .91448 -0.29713 Mabsadd L
2.01961 0 2.37764 .77254 Mabsadd L
2.01961 0 .56518 .7779 Mabsadd L
2.01961 0 0 2.5 Mabsadd L closepath F
2.02941 0 0 2.5 Mabsadd m
2.02941 0 -0.56518 .7779 Mabsadd L
2.02941 0 -2.37764 .77254 Mabsadd L
2.02941 0 -0.91448 -0.29713 Mabsadd L
2.02941 0 -1.46946 -2.02254 Mabsadd L
2.02941 0 0 -0.96154 Mabsadd L
2.02941 0 1.46946 -2.02254 Mabsadd L
2.02941 0 .91448 -0.29713 Mabsadd L
2.02941 0 2.37764 .77254 Mabsadd L
2.02941 0 .56518 .7779 Mabsadd L
2.02941 0 0 2.5 Mabsadd L closepath F
2.03922 0 0 2.5 Mabsadd m
2.03922 0 -0.56518 .7779 Mabsadd L
2.03922 0 -2.37764 .77254 Mabsadd L
2.03922 0 -0.91448 -0.29713 Mabsadd L
2.03922 0 -1.46946 -2.02254 Mabsadd L
2.03922 0 0 -0.96154 Mabsadd L
2.03922 0 1.46946 -2.02254 Mabsadd L
2.03922 0 .91448 -0.29713 Mabsadd L
2.03922 0 2.37764 .77254 Mabsadd L
2.03922 0 .56518 .7779 Mabsadd L
2.03922 0 0 2.5 Mabsadd L closepath F
2.04902 0 0 2.5 Mabsadd m
2.04902 0 -0.56518 .7779 Mabsadd L
2.04902 0 -2.37764 .77254 Mabsadd L
2.04902 0 -0.91448 -0.29713 Mabsadd L
2.04902 0 -1.46946 -2.02254 Mabsadd L
2.04902 0 0 -0.96154 Mabsadd L
2.04902 0 1.46946 -2.02254 Mabsadd L
2.04902 0 .91448 -0.29713 Mabsadd L
2.04902 0 2.37764 .77254 Mabsadd L
2.04902 0 .56518 .7779 Mabsadd L
2.04902 0 0 2.5 Mabsadd L closepath F
2.05882 0 0 2.5 Mabsadd m
2.05882 0 -0.56518 .7779 Mabsadd L
2.05882 0 -2.37764 .77254 Mabsadd L
2.05882 0 -0.91448 -0.29713 Mabsadd L
2.05882 0 -1.46946 -2.02254 Mabsadd L
2.05882 0 0 -0.96154 Mabsadd L
2.05882 0 1.46946 -2.02254 Mabsadd L
2.05882 0 .91448 -0.29713 Mabsadd L
2.05882 0 2.37764 .77254 Mabsadd L
2.05882 0 .56518 .7779 Mabsadd L
2.05882 0 0 2.5 Mabsadd L closepath F
2.06863 0 0 2.5 Mabsadd m
2.06863 0 -0.56518 .7779 Mabsadd L
2.06863 0 -2.37764 .77254 Mabsadd L
2.06863 0 -0.91448 -0.29713 Mabsadd L
2.06863 0 -1.46946 -2.02254 Mabsadd L
2.06863 0 0 -0.96154 Mabsadd L
2.06863 0 1.46946 -2.02254 Mabsadd L
2.06863 0 .91448 -0.29713 Mabsadd L
2.06863 0 2.37764 .77254 Mabsadd L
2.06863 0 .56518 .7779 Mabsadd L
2.06863 0 0 2.5 Mabsadd L closepath F
2.07843 0 0 2.5 Mabsadd m
2.07843 0 -0.56518 .7779 Mabsadd L
2.07843 0 -2.37764 .77254 Mabsadd L
2.07843 0 -0.91448 -0.29713 Mabsadd L
2.07843 0 -1.46946 -2.02254 Mabsadd L
2.07843 0 0 -0.96154 Mabsadd L
2.07843 0 1.46946 -2.02254 Mabsadd L
2.07843 0 .91448 -0.29713 Mabsadd L
2.07843 0 2.37764 .77254 Mabsadd L
2.07843 0 .56518 .7779 Mabsadd L
2.07843 0 0 2.5 Mabsadd L closepath F
2.08824 0 0 2.5 Mabsadd m
2.08824 0 -0.56518 .7779 Mabsadd L
2.08824 0 -2.37764 .77254 Mabsadd L
2.08824 0 -0.91448 -0.29713 Mabsadd L
2.08824 0 -1.46946 -2.02254 Mabsadd L
2.08824 0 0 -0.96154 Mabsadd L
2.08824 0 1.46946 -2.02254 Mabsadd L
2.08824 0 .91448 -0.29713 Mabsadd L
2.08824 0 2.37764 .77254 Mabsadd L
2.08824 0 .56518 .7779 Mabsadd L
2.08824 0 0 2.5 Mabsadd L closepath F
2.09804 0 0 2.5 Mabsadd m
2.09804 0 -0.56518 .7779 Mabsadd L
2.09804 0 -2.37764 .77254 Mabsadd L
2.09804 0 -0.91448 -0.29713 Mabsadd L
2.09804 0 -1.46946 -2.02254 Mabsadd L
2.09804 0 0 -0.96154 Mabsadd L
2.09804 0 1.46946 -2.02254 Mabsadd L
2.09804 0 .91448 -0.29713 Mabsadd L
2.09804 0 2.37764 .77254 Mabsadd L
2.09804 0 .56518 .7779 Mabsadd L
2.09804 0 0 2.5 Mabsadd L closepath F
2.10784 0 0 2.5 Mabsadd m
2.10784 0 -0.56518 .7779 Mabsadd L
2.10784 0 -2.37764 .77254 Mabsadd L
2.10784 0 -0.91448 -0.29713 Mabsadd L
2.10784 0 -1.46946 -2.02254 Mabsadd L
2.10784 0 0 -0.96154 Mabsadd L
2.10784 0 1.46946 -2.02254 Mabsadd L
2.10784 0 .91448 -0.29713 Mabsadd L
2.10784 0 2.37764 .77254 Mabsadd L
2.10784 0 .56518 .7779 Mabsadd L
2.10784 0 0 2.5 Mabsadd L closepath F
2.11765 0 0 2.5 Mabsadd m
2.11765 0 -0.56518 .7779 Mabsadd L
2.11765 0 -2.37764 .77254 Mabsadd L
2.11765 0 -0.91448 -0.29713 Mabsadd L
2.11765 0 -1.46946 -2.02254 Mabsadd L
2.11765 0 0 -0.96154 Mabsadd L
2.11765 0 1.46946 -2.02254 Mabsadd L
2.11765 0 .91448 -0.29713 Mabsadd L
2.11765 0 2.37764 .77254 Mabsadd L
2.11765 0 .56518 .7779 Mabsadd L
2.11765 0 0 2.5 Mabsadd L closepath F
2.12745 0 0 2.5 Mabsadd m
2.12745 0 -0.56518 .7779 Mabsadd L
2.12745 0 -2.37764 .77254 Mabsadd L
2.12745 0 -0.91448 -0.29713 Mabsadd L
2.12745 0 -1.46946 -2.02254 Mabsadd L
2.12745 0 0 -0.96154 Mabsadd L
2.12745 0 1.46946 -2.02254 Mabsadd L
2.12745 0 .91448 -0.29713 Mabsadd L
2.12745 0 2.37764 .77254 Mabsadd L
2.12745 0 .56518 .7779 Mabsadd L
2.12745 0 0 2.5 Mabsadd L closepath F
2.13725 0 0 2.5 Mabsadd m
2.13725 0 -0.56518 .7779 Mabsadd L
2.13725 0 -2.37764 .77254 Mabsadd L
2.13725 0 -0.91448 -0.29713 Mabsadd L
2.13725 0 -1.46946 -2.02254 Mabsadd L
2.13725 0 0 -0.96154 Mabsadd L
2.13725 0 1.46946 -2.02254 Mabsadd L
2.13725 0 .91448 -0.29713 Mabsadd L
2.13725 0 2.37764 .77254 Mabsadd L
2.13725 0 .56518 .7779 Mabsadd L
2.13725 0 0 2.5 Mabsadd L closepath F
2.14706 0 0 2.5 Mabsadd m
2.14706 0 -0.56518 .7779 Mabsadd L
2.14706 0 -2.37764 .77254 Mabsadd L
2.14706 0 -0.91448 -0.29713 Mabsadd L
2.14706 0 -1.46946 -2.02254 Mabsadd L
2.14706 0 0 -0.96154 Mabsadd L
2.14706 0 1.46946 -2.02254 Mabsadd L
2.14706 0 .91448 -0.29713 Mabsadd L
2.14706 0 2.37764 .77254 Mabsadd L
2.14706 0 .56518 .7779 Mabsadd L
2.14706 0 0 2.5 Mabsadd L closepath F
2.15686 0 0 2.5 Mabsadd m
2.15686 0 -0.56518 .7779 Mabsadd L
2.15686 0 -2.37764 .77254 Mabsadd L
2.15686 0 -0.91448 -0.29713 Mabsadd L
2.15686 0 -1.46946 -2.02254 Mabsadd L
2.15686 0 0 -0.96154 Mabsadd L
2.15686 0 1.46946 -2.02254 Mabsadd L
2.15686 0 .91448 -0.29713 Mabsadd L
2.15686 0 2.37764 .77254 Mabsadd L
2.15686 0 .56518 .7779 Mabsadd L
2.15686 0 0 2.5 Mabsadd L closepath F
2.16667 0 0 2.5 Mabsadd m
2.16667 0 -0.56518 .7779 Mabsadd L
2.16667 0 -2.37764 .77254 Mabsadd L
2.16667 0 -0.91448 -0.29713 Mabsadd L
2.16667 0 -1.46946 -2.02254 Mabsadd L
2.16667 0 0 -0.96154 Mabsadd L
2.16667 0 1.46946 -2.02254 Mabsadd L
2.16667 0 .91448 -0.29713 Mabsadd L
2.16667 0 2.37764 .77254 Mabsadd L
2.16667 0 .56518 .7779 Mabsadd L
2.16667 0 0 2.5 Mabsadd L closepath F
2.17647 0 0 2.5 Mabsadd m
2.17647 0 -0.56518 .7779 Mabsadd L
2.17647 0 -2.37764 .77254 Mabsadd L
2.17647 0 -0.91448 -0.29713 Mabsadd L
2.17647 0 -1.46946 -2.02254 Mabsadd L
2.17647 0 0 -0.96154 Mabsadd L
2.17647 0 1.46946 -2.02254 Mabsadd L
2.17647 0 .91448 -0.29713 Mabsadd L
2.17647 0 2.37764 .77254 Mabsadd L
2.17647 0 .56518 .7779 Mabsadd L
2.17647 0 0 2.5 Mabsadd L closepath F
2.18627 0 0 2.5 Mabsadd m
2.18627 0 -0.56518 .7779 Mabsadd L
2.18627 0 -2.37764 .77254 Mabsadd L
2.18627 0 -0.91448 -0.29713 Mabsadd L
2.18627 0 -1.46946 -2.02254 Mabsadd L
2.18627 0 0 -0.96154 Mabsadd L
2.18627 0 1.46946 -2.02254 Mabsadd L
2.18627 0 .91448 -0.29713 Mabsadd L
2.18627 0 2.37764 .77254 Mabsadd L
2.18627 0 .56518 .7779 Mabsadd L
2.18627 0 0 2.5 Mabsadd L closepath F
2.19608 0 0 2.5 Mabsadd m
2.19608 0 -0.56518 .7779 Mabsadd L
2.19608 0 -2.37764 .77254 Mabsadd L
2.19608 0 -0.91448 -0.29713 Mabsadd L
2.19608 0 -1.46946 -2.02254 Mabsadd L
2.19608 0 0 -0.96154 Mabsadd L
2.19608 0 1.46946 -2.02254 Mabsadd L
2.19608 0 .91448 -0.29713 Mabsadd L
2.19608 0 2.37764 .77254 Mabsadd L
2.19608 0 .56518 .7779 Mabsadd L
2.19608 0 0 2.5 Mabsadd L closepath F
2.20588 0 0 2.5 Mabsadd m
2.20588 0 -0.56518 .7779 Mabsadd L
2.20588 0 -2.37764 .77254 Mabsadd L
2.20588 0 -0.91448 -0.29713 Mabsadd L
2.20588 0 -1.46946 -2.02254 Mabsadd L
2.20588 0 0 -0.96154 Mabsadd L
2.20588 0 1.46946 -2.02254 Mabsadd L
2.20588 0 .91448 -0.29713 Mabsadd L
2.20588 0 2.37764 .77254 Mabsadd L
2.20588 0 .56518 .7779 Mabsadd L
2.20588 0 0 2.5 Mabsadd L closepath F
2.21569 0 0 2.5 Mabsadd m
2.21569 0 -0.56518 .7779 Mabsadd L
2.21569 0 -2.37764 .77254 Mabsadd L
2.21569 0 -0.91448 -0.29713 Mabsadd L
2.21569 0 -1.46946 -2.02254 Mabsadd L
2.21569 0 0 -0.96154 Mabsadd L
2.21569 0 1.46946 -2.02254 Mabsadd L
2.21569 0 .91448 -0.29713 Mabsadd L
2.21569 0 2.37764 .77254 Mabsadd L
2.21569 0 .56518 .7779 Mabsadd L
2.21569 0 0 2.5 Mabsadd L closepath F
2.22549 0 0 2.5 Mabsadd m
2.22549 0 -0.56518 .7779 Mabsadd L
2.22549 0 -2.37764 .77254 Mabsadd L
2.22549 0 -0.91448 -0.29713 Mabsadd L
2.22549 0 -1.46946 -2.02254 Mabsadd L
2.22549 0 0 -0.96154 Mabsadd L
2.22549 0 1.46946 -2.02254 Mabsadd L
2.22549 0 .91448 -0.29713 Mabsadd L
2.22549 0 2.37764 .77254 Mabsadd L
2.22549 0 .56518 .7779 Mabsadd L
2.22549 0 0 2.5 Mabsadd L closepath F
2.23529 0 0 2.5 Mabsadd m
2.23529 0 -0.56518 .7779 Mabsadd L
2.23529 0 -2.37764 .77254 Mabsadd L
2.23529 0 -0.91448 -0.29713 Mabsadd L
2.23529 0 -1.46946 -2.02254 Mabsadd L
2.23529 0 0 -0.96154 Mabsadd L
2.23529 0 1.46946 -2.02254 Mabsadd L
2.23529 0 .91448 -0.29713 Mabsadd L
2.23529 0 2.37764 .77254 Mabsadd L
2.23529 0 .56518 .7779 Mabsadd L
2.23529 0 0 2.5 Mabsadd L closepath F
2.2451 0 0 2.5 Mabsadd m
2.2451 0 -0.56518 .7779 Mabsadd L
2.2451 0 -2.37764 .77254 Mabsadd L
2.2451 0 -0.91448 -0.29713 Mabsadd L
2.2451 0 -1.46946 -2.02254 Mabsadd L
2.2451 0 0 -0.96154 Mabsadd L
2.2451 0 1.46946 -2.02254 Mabsadd L
2.2451 0 .91448 -0.29713 Mabsadd L
2.2451 0 2.37764 .77254 Mabsadd L
2.2451 0 .56518 .7779 Mabsadd L
2.2451 0 0 2.5 Mabsadd L closepath F
2.2549 0 0 2.5 Mabsadd m
2.2549 0 -0.56518 .7779 Mabsadd L
2.2549 0 -2.37764 .77254 Mabsadd L
2.2549 0 -0.91448 -0.29713 Mabsadd L
2.2549 0 -1.46946 -2.02254 Mabsadd L
2.2549 0 0 -0.96154 Mabsadd L
2.2549 0 1.46946 -2.02254 Mabsadd L
2.2549 0 .91448 -0.29713 Mabsadd L
2.2549 0 2.37764 .77254 Mabsadd L
2.2549 0 .56518 .7779 Mabsadd L
2.2549 0 0 2.5 Mabsadd L closepath F
2.26471 0 0 2.5 Mabsadd m
2.26471 0 -0.56518 .7779 Mabsadd L
2.26471 0 -2.37764 .77254 Mabsadd L
2.26471 0 -0.91448 -0.29713 Mabsadd L
2.26471 0 -1.46946 -2.02254 Mabsadd L
2.26471 0 0 -0.96154 Mabsadd L
2.26471 0 1.46946 -2.02254 Mabsadd L
2.26471 0 .91448 -0.29713 Mabsadd L
2.26471 0 2.37764 .77254 Mabsadd L
2.26471 0 .56518 .7779 Mabsadd L
2.26471 0 0 2.5 Mabsadd L closepath F
2.27451 0 0 2.5 Mabsadd m
2.27451 0 -0.56518 .7779 Mabsadd L
2.27451 0 -2.37764 .77254 Mabsadd L
2.27451 0 -0.91448 -0.29713 Mabsadd L
2.27451 0 -1.46946 -2.02254 Mabsadd L
2.27451 0 0 -0.96154 Mabsadd L
2.27451 0 1.46946 -2.02254 Mabsadd L
2.27451 0 .91448 -0.29713 Mabsadd L
2.27451 0 2.37764 .77254 Mabsadd L
2.27451 0 .56518 .7779 Mabsadd L
2.27451 0 0 2.5 Mabsadd L closepath F
2.28431 0 0 2.5 Mabsadd m
2.28431 0 -0.56518 .7779 Mabsadd L
2.28431 0 -2.37764 .77254 Mabsadd L
2.28431 0 -0.91448 -0.29713 Mabsadd L
2.28431 0 -1.46946 -2.02254 Mabsadd L
2.28431 0 0 -0.96154 Mabsadd L
2.28431 0 1.46946 -2.02254 Mabsadd L
2.28431 0 .91448 -0.29713 Mabsadd L
2.28431 0 2.37764 .77254 Mabsadd L
2.28431 0 .56518 .7779 Mabsadd L
2.28431 0 0 2.5 Mabsadd L closepath F
2.29412 0 0 2.5 Mabsadd m
2.29412 0 -0.56518 .7779 Mabsadd L
2.29412 0 -2.37764 .77254 Mabsadd L
2.29412 0 -0.91448 -0.29713 Mabsadd L
2.29412 0 -1.46946 -2.02254 Mabsadd L
2.29412 0 0 -0.96154 Mabsadd L
2.29412 0 1.46946 -2.02254 Mabsadd L
2.29412 0 .91448 -0.29713 Mabsadd L
2.29412 0 2.37764 .77254 Mabsadd L
2.29412 0 .56518 .7779 Mabsadd L
2.29412 0 0 2.5 Mabsadd L closepath F
2.30392 0 0 2.5 Mabsadd m
2.30392 0 -0.56518 .7779 Mabsadd L
2.30392 0 -2.37764 .77254 Mabsadd L
2.30392 0 -0.91448 -0.29713 Mabsadd L
2.30392 0 -1.46946 -2.02254 Mabsadd L
2.30392 0 0 -0.96154 Mabsadd L
2.30392 0 1.46946 -2.02254 Mabsadd L
2.30392 0 .91448 -0.29713 Mabsadd L
2.30392 0 2.37764 .77254 Mabsadd L
2.30392 0 .56518 .7779 Mabsadd L
2.30392 0 0 2.5 Mabsadd L closepath F
2.31373 0 0 2.5 Mabsadd m
2.31373 0 -0.56518 .7779 Mabsadd L
2.31373 0 -2.37764 .77254 Mabsadd L
2.31373 0 -0.91448 -0.29713 Mabsadd L
2.31373 0 -1.46946 -2.02254 Mabsadd L
2.31373 0 0 -0.96154 Mabsadd L
2.31373 0 1.46946 -2.02254 Mabsadd L
2.31373 0 .91448 -0.29713 Mabsadd L
2.31373 0 2.37764 .77254 Mabsadd L
2.31373 0 .56518 .7779 Mabsadd L
2.31373 0 0 2.5 Mabsadd L closepath F
2.32353 0 0 2.5 Mabsadd m
2.32353 0 -0.56518 .7779 Mabsadd L
2.32353 0 -2.37764 .77254 Mabsadd L
2.32353 0 -0.91448 -0.29713 Mabsadd L
2.32353 0 -1.46946 -2.02254 Mabsadd L
2.32353 0 0 -0.96154 Mabsadd L
2.32353 0 1.46946 -2.02254 Mabsadd L
2.32353 0 .91448 -0.29713 Mabsadd L
2.32353 0 2.37764 .77254 Mabsadd L
2.32353 0 .56518 .7779 Mabsadd L
2.32353 0 0 2.5 Mabsadd L closepath F
2.33333 0 0 2.5 Mabsadd m
2.33333 0 -0.56518 .7779 Mabsadd L
2.33333 0 -2.37764 .77254 Mabsadd L
2.33333 0 -0.91448 -0.29713 Mabsadd L
2.33333 0 -1.46946 -2.02254 Mabsadd L
2.33333 0 0 -0.96154 Mabsadd L
2.33333 0 1.46946 -2.02254 Mabsadd L
2.33333 0 .91448 -0.29713 Mabsadd L
2.33333 0 2.37764 .77254 Mabsadd L
2.33333 0 .56518 .7779 Mabsadd L
2.33333 0 0 2.5 Mabsadd L closepath F
2.34314 0 0 2.5 Mabsadd m
2.34314 0 -0.56518 .7779 Mabsadd L
2.34314 0 -2.37764 .77254 Mabsadd L
2.34314 0 -0.91448 -0.29713 Mabsadd L
2.34314 0 -1.46946 -2.02254 Mabsadd L
2.34314 0 0 -0.96154 Mabsadd L
2.34314 0 1.46946 -2.02254 Mabsadd L
2.34314 0 .91448 -0.29713 Mabsadd L
2.34314 0 2.37764 .77254 Mabsadd L
2.34314 0 .56518 .7779 Mabsadd L
2.34314 0 0 2.5 Mabsadd L closepath F
2.35294 0 0 2.5 Mabsadd m
2.35294 0 -0.56518 .7779 Mabsadd L
2.35294 0 -2.37764 .77254 Mabsadd L
2.35294 0 -0.91448 -0.29713 Mabsadd L
2.35294 0 -1.46946 -2.02254 Mabsadd L
2.35294 0 0 -0.96154 Mabsadd L
2.35294 0 1.46946 -2.02254 Mabsadd L
2.35294 0 .91448 -0.29713 Mabsadd L
2.35294 0 2.37764 .77254 Mabsadd L
2.35294 0 .56518 .7779 Mabsadd L
2.35294 0 0 2.5 Mabsadd L closepath F
2.36275 0 0 2.5 Mabsadd m
2.36275 0 -0.56518 .7779 Mabsadd L
2.36275 0 -2.37764 .77254 Mabsadd L
2.36275 0 -0.91448 -0.29713 Mabsadd L
2.36275 0 -1.46946 -2.02254 Mabsadd L
2.36275 0 0 -0.96154 Mabsadd L
2.36275 0 1.46946 -2.02254 Mabsadd L
2.36275 0 .91448 -0.29713 Mabsadd L
2.36275 0 2.37764 .77254 Mabsadd L
2.36275 0 .56518 .7779 Mabsadd L
2.36275 0 0 2.5 Mabsadd L closepath F
2.37255 0 0 2.5 Mabsadd m
2.37255 0 -0.56518 .7779 Mabsadd L
2.37255 0 -2.37764 .77254 Mabsadd L
2.37255 0 -0.91448 -0.29713 Mabsadd L
2.37255 0 -1.46946 -2.02254 Mabsadd L
2.37255 0 0 -0.96154 Mabsadd L
2.37255 0 1.46946 -2.02254 Mabsadd L
2.37255 0 .91448 -0.29713 Mabsadd L
2.37255 0 2.37764 .77254 Mabsadd L
2.37255 0 .56518 .7779 Mabsadd L
2.37255 0 0 2.5 Mabsadd L closepath F
2.38235 0 0 2.5 Mabsadd m
2.38235 0 -0.56518 .7779 Mabsadd L
2.38235 0 -2.37764 .77254 Mabsadd L
2.38235 0 -0.91448 -0.29713 Mabsadd L
2.38235 0 -1.46946 -2.02254 Mabsadd L
2.38235 0 0 -0.96154 Mabsadd L
2.38235 0 1.46946 -2.02254 Mabsadd L
2.38235 0 .91448 -0.29713 Mabsadd L
2.38235 0 2.37764 .77254 Mabsadd L
2.38235 0 .56518 .7779 Mabsadd L
2.38235 0 0 2.5 Mabsadd L closepath F
2.39216 0 0 2.5 Mabsadd m
2.39216 0 -0.56518 .7779 Mabsadd L
2.39216 0 -2.37764 .77254 Mabsadd L
2.39216 0 -0.91448 -0.29713 Mabsadd L
2.39216 0 -1.46946 -2.02254 Mabsadd L
2.39216 0 0 -0.96154 Mabsadd L
2.39216 0 1.46946 -2.02254 Mabsadd L
2.39216 0 .91448 -0.29713 Mabsadd L
2.39216 0 2.37764 .77254 Mabsadd L
2.39216 0 .56518 .7779 Mabsadd L
2.39216 0 0 2.5 Mabsadd L closepath F
2.40196 0 0 2.5 Mabsadd m
2.40196 0 -0.56518 .7779 Mabsadd L
2.40196 0 -2.37764 .77254 Mabsadd L
2.40196 0 -0.91448 -0.29713 Mabsadd L
2.40196 0 -1.46946 -2.02254 Mabsadd L
2.40196 0 0 -0.96154 Mabsadd L
2.40196 0 1.46946 -2.02254 Mabsadd L
2.40196 0 .91448 -0.29713 Mabsadd L
2.40196 0 2.37764 .77254 Mabsadd L
2.40196 0 .56518 .7779 Mabsadd L
2.40196 0 0 2.5 Mabsadd L closepath F
2.41176 0 0 2.5 Mabsadd m
2.41176 0 -0.56518 .7779 Mabsadd L
2.41176 0 -2.37764 .77254 Mabsadd L
2.41176 0 -0.91448 -0.29713 Mabsadd L
2.41176 0 -1.46946 -2.02254 Mabsadd L
2.41176 0 0 -0.96154 Mabsadd L
2.41176 0 1.46946 -2.02254 Mabsadd L
2.41176 0 .91448 -0.29713 Mabsadd L
2.41176 0 2.37764 .77254 Mabsadd L
2.41176 0 .56518 .7779 Mabsadd L
2.41176 0 0 2.5 Mabsadd L closepath F
2.42157 0 0 2.5 Mabsadd m
2.42157 0 -0.56518 .7779 Mabsadd L
2.42157 0 -2.37764 .77254 Mabsadd L
2.42157 0 -0.91448 -0.29713 Mabsadd L
2.42157 0 -1.46946 -2.02254 Mabsadd L
2.42157 0 0 -0.96154 Mabsadd L
2.42157 0 1.46946 -2.02254 Mabsadd L
2.42157 0 .91448 -0.29713 Mabsadd L
2.42157 0 2.37764 .77254 Mabsadd L
2.42157 0 .56518 .7779 Mabsadd L
2.42157 0 0 2.5 Mabsadd L closepath F
2.43137 0 0 2.5 Mabsadd m
2.43137 0 -0.56518 .7779 Mabsadd L
2.43137 0 -2.37764 .77254 Mabsadd L
2.43137 0 -0.91448 -0.29713 Mabsadd L
2.43137 0 -1.46946 -2.02254 Mabsadd L
2.43137 0 0 -0.96154 Mabsadd L
2.43137 0 1.46946 -2.02254 Mabsadd L
2.43137 0 .91448 -0.29713 Mabsadd L
2.43137 0 2.37764 .77254 Mabsadd L
2.43137 0 .56518 .7779 Mabsadd L
2.43137 0 0 2.5 Mabsadd L closepath F
2.44118 0 0 2.5 Mabsadd m
2.44118 0 -0.56518 .7779 Mabsadd L
2.44118 0 -2.37764 .77254 Mabsadd L
2.44118 0 -0.91448 -0.29713 Mabsadd L
2.44118 0 -1.46946 -2.02254 Mabsadd L
2.44118 0 0 -0.96154 Mabsadd L
2.44118 0 1.46946 -2.02254 Mabsadd L
2.44118 0 .91448 -0.29713 Mabsadd L
2.44118 0 2.37764 .77254 Mabsadd L
2.44118 0 .56518 .7779 Mabsadd L
2.44118 0 0 2.5 Mabsadd L closepath F
2.45098 0 0 2.5 Mabsadd m
2.45098 0 -0.56518 .7779 Mabsadd L
2.45098 0 -2.37764 .77254 Mabsadd L
2.45098 0 -0.91448 -0.29713 Mabsadd L
2.45098 0 -1.46946 -2.02254 Mabsadd L
2.45098 0 0 -0.96154 Mabsadd L
2.45098 0 1.46946 -2.02254 Mabsadd L
2.45098 0 .91448 -0.29713 Mabsadd L
2.45098 0 2.37764 .77254 Mabsadd L
2.45098 0 .56518 .7779 Mabsadd L
2.45098 0 0 2.5 Mabsadd L closepath F
2.46078 0 0 2.5 Mabsadd m
2.46078 0 -0.56518 .7779 Mabsadd L
2.46078 0 -2.37764 .77254 Mabsadd L
2.46078 0 -0.91448 -0.29713 Mabsadd L
2.46078 0 -1.46946 -2.02254 Mabsadd L
2.46078 0 0 -0.96154 Mabsadd L
2.46078 0 1.46946 -2.02254 Mabsadd L
2.46078 0 .91448 -0.29713 Mabsadd L
2.46078 0 2.37764 .77254 Mabsadd L
2.46078 0 .56518 .7779 Mabsadd L
2.46078 0 0 2.5 Mabsadd L closepath F
2.47059 0 0 2.5 Mabsadd m
2.47059 0 -0.56518 .7779 Mabsadd L
2.47059 0 -2.37764 .77254 Mabsadd L
2.47059 0 -0.91448 -0.29713 Mabsadd L
2.47059 0 -1.46946 -2.02254 Mabsadd L
2.47059 0 0 -0.96154 Mabsadd L
2.47059 0 1.46946 -2.02254 Mabsadd L
2.47059 0 .91448 -0.29713 Mabsadd L
2.47059 0 2.37764 .77254 Mabsadd L
2.47059 0 .56518 .7779 Mabsadd L
2.47059 0 0 2.5 Mabsadd L closepath F
2.48039 0 0 2.5 Mabsadd m
2.48039 0 -0.56518 .7779 Mabsadd L
2.48039 0 -2.37764 .77254 Mabsadd L
2.48039 0 -0.91448 -0.29713 Mabsadd L
2.48039 0 -1.46946 -2.02254 Mabsadd L
2.48039 0 0 -0.96154 Mabsadd L
2.48039 0 1.46946 -2.02254 Mabsadd L
2.48039 0 .91448 -0.29713 Mabsadd L
2.48039 0 2.37764 .77254 Mabsadd L
2.48039 0 .56518 .7779 Mabsadd L
2.48039 0 0 2.5 Mabsadd L closepath F
2.4902 0 0 2.5 Mabsadd m
2.4902 0 -0.56518 .7779 Mabsadd L
2.4902 0 -2.37764 .77254 Mabsadd L
2.4902 0 -0.91448 -0.29713 Mabsadd L
2.4902 0 -1.46946 -2.02254 Mabsadd L
2.4902 0 0 -0.96154 Mabsadd L
2.4902 0 1.46946 -2.02254 Mabsadd L
2.4902 0 .91448 -0.29713 Mabsadd L
2.4902 0 2.37764 .77254 Mabsadd L
2.4902 0 .56518 .7779 Mabsadd L
2.4902 0 0 2.5 Mabsadd L closepath F
2.5 0 0 2.5 Mabsadd m
2.5 0 -0.56518 .7779 Mabsadd L
2.5 0 -2.37764 .77254 Mabsadd L
2.5 0 -0.91448 -0.29713 Mabsadd L
2.5 0 -1.46946 -2.02254 Mabsadd L
2.5 0 0 -0.96154 Mabsadd L
2.5 0 1.46946 -2.02254 Mabsadd L
2.5 0 .91448 -0.29713 Mabsadd L
2.5 0 2.37764 .77254 Mabsadd L
2.5 0 .56518 .7779 Mabsadd L
2.5 0 0 2.5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .38707 L
.97619 .38707 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .40321 L
.96005 .40321 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .40321 L
.70178 .40321 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.403208 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
0 1 1 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(zf2) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 0 r
.05357 .39881 m
.05357 .69643 L
.35119 .69643 L
.35119 .39881 L
F
0 g
gsave
.38988 .54762 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(zf1) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00<`3oool2000000@0oooo0P00
00030?ooo`D00000403oool2000000@0oooo0P0000030?ooo`@000004@3oool2000000@0oooo0P00
00040?ooo`8000004P3oool2000000@0oooo0P0000050?ooo`<00000O@3oool00380oooo00@00000
0?ooo`3oool000002P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo000000P0oooo
00<000000?ooo`3oool04@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0100oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`1l0?ooo`00<P3oool01000
0000oooo0?ooo`00000:0?ooo`030000003oool0oooo00l0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0@0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
3`3oool010000000oooo0?ooo`0000080?ooo`D00000O@3oool00380oooo00@000000?ooo`3oool0
00002P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool03`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00h0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00001n0?ooo`00<P3oool010000000oooo0?oo
o`00000:0?ooo`030000003oool0oooo00l0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`00000@0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000403o
ool010000000oooo0?ooo`0000090?ooo`030000003oool0000007h0oooo000c0?ooo`8000002P3o
ool200000180oooo0P00000:0?ooo`8000004P3oool2000000X0oooo0P00000B0?ooo`8000002`3o
ool2000007h0oooo003o0?ooob40oooo002V0?ooo`030000003oool0oooo07L0oooo001Q0?ooo`@0
000000<0oooo000000000000^000000001/0ooooo`000006000000006`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool2000000030?ooo`00
000000000<L00000000K0?ooo`030000003oool0oooo03D0oooo5`0000000`3oool000000000000K
000000030?ooo`00000000000080000000<0oooo0000000000000P0000000`3oool0000000000002
000000030?ooo`00000000000080000000<0oooo0000000000001`0000000`3oool0000000000002
000000030?ooo`00000000000080000000<0oooo0000000000000P0000000`3oool0000000000007
000000030?ooo`00000000000080000000<0oooo0000000000000P0000000`3oool0000000000002
000000030?ooo`00000000000080000000<0oooo0000000000000P0000000`3oool0000000000002
000000030?ooo`00000000000080000000<0oooo0000000000000P0000000`3oool0000000000002
000000030?ooo`00000000000080000000D0oooo00000000000000000?ooo`04000000030?ooo`00
000000000080000000<0oooo0000000000000P0000000`3oool0000000000002000000030?ooo`00
000000000080000000<0oooo0000000000000P0000000`3oool0000000000002000000030?ooo`00
00000000008000000@3oool1000000400000000K0?ooo`030000003oool0oooo0380oooo40000007
0?oooa8000000`3oool00`000000oooo0?ooo`0Y0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0I03oool001/0oooo00<0
00000?ooo`3oool0<@3oool;000000/0oooo300000000`3oool000000?ooo`0^0?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`<000000`3oool3000006@0oooo
000K0?ooo`030000003oool0oooo02l0oooo2000000=0?ooo`X0000000<0oooo0000003oool0/@3o
ool001/0oooo00<000000?ooo`3oool0;@3oool6000000030?ooo`000000oooo00`0oooo2P00002f
0?ooo`006`3oool00`000000oooo0?ooo`0/0?ooo`H000003P3oool900000;T0oooo000K0?ooo`03
0000003oool0oooo02/0oooo1P00000=0?ooo`P00000_03oool001/0oooo00<000000?ooo`3oool0
:P3oool4000000030?ooo`000000oooo00`0oooo1`00002n0?ooo`006`3oool00`000000oooo0?oo
o`0Y0?ooo`@000003P3oool700000<00oooo000K0?ooo`030000003oool0oooo02P0oooo1000000>
0?ooo`H00000`P3oool001/0oooo00<000000?ooo`3oool09`3oool5000000d0oooo1P0000330?oo
o`006`3oool00`000000oooo0?ooo`0V0?ooo`D000003@3oool600000<@0oooo00090?ooo`800000
103oool2000000<0oooo100000030?ooo`030000003oool0oooo02D0oooo1000000=0?ooo`H00000
aP3oool000P0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo02@0oooo1000000=0?ooo`H00000a`3oool000P0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo1000000<0?ooo`H00000
b03oool000P0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0280oooo1@00000<0?ooo`H00000b@3oool000P0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0240oooo1@00000;0?ooo`H0
0000b`3oool000T0oooo0P00000:0?ooo`800000103oool00`000000oooo0?ooo`0Q0?ooo`@00000
303oool500000<`0oooo000K0?ooo`030000003oool0oooo0200oooo1000000<0?ooo`D00000c@3o
ool001/0oooo00<000000?ooo`3oool0803oool4000000/0oooo1@00003>0?ooo`006`3oool00`00
0000oooo0?ooo`0O0?ooo`@000002`3oool400000=00oooo000K0?ooo`030000003oool0oooo01l0
oooo0`00000<0?ooo`@00000d03oool001/0oooo00<000000?ooo`3oool07P3oool3000000/0oooo
1@00003A0?ooo`006`3oool00`000000oooo0?ooo`0M0?ooo`@000002P3oool300000=@0oooo000K
0?ooo`030000003oool0oooo01`0oooo1000000;0?ooo`D00000dP3oool001/0oooo00<000000?oo
o`3oool0703oool4000000X0oooo1@00003C0?ooo`006`3oool00`000000oooo0?ooo`0K0?ooo`@0
00002P3oool400000=D0oooo000K0?ooo`030000003oool0oooo01/0oooo1000000:0?ooo`@00000
e@3oool000T0oooo0P0000040?ooo`8000001@3oool300000080oooo00<000000?ooo`3oool06P3o
ool4000000T0oooo1@00003F0?ooo`00203oool010000000oooo0?ooo`00000;0?ooo`050000003o
ool0oooo0?ooo`0000007@3oool3000000T0oooo0P00003I0?ooo`00203oool010000000oooo0?oo
o`0000080?ooo`D000000P3oool00`000000oooo0?ooo`0J0?ooo`<000002@3oool500000=L0oooo
00080?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`0I0?ooo`<000002P3oool3000008H0ooooBP0000090?ooo`00203oool010000000oooo
0?ooo`0000090?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0603oool4000000T0
oooo1@0000250?ooodX000002@3oool000T0oooo0P00000;0?ooo`8000000`3oool00`000000oooo
0?ooo`0G0?ooo`@00000203oool5000008L0ooooBP0000090?ooo`006`3oool00`000000oooo0?oo
o`0H0?ooo`<000002@3oool2000008T0ooooBP0000090?ooo`006`3oool00`000000oooo0?ooo`0G
0?ooo`<00000203oool5000008@0ooooCP0000090?ooo`006`3oool00`000000oooo0?ooo`0F0?oo
o`@00000203oool2000008L0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo000K0?ooo`03
0000003oool0oooo01H0oooo0`0000080?ooo`D00000Q@3oool00`000000oooo0?ooo`160?ooo`D0
00002@3oool001/0oooo00<000000?ooo`3oool05@3oool4000000P0oooo0P0000280?ooo`030000
003oool0oooo04H0oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`0F0?ooo`<000001`3o
ool5000008H0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo000K0?ooo`030000003oool0
oooo01D0oooo0`0000060?ooo`D00000R03oool010000000oooo0?ooo`3ooolE003ooc00oooo1@00
00090?ooo`006`3oool00`000000oooo0?ooo`0D0?ooo`<00000203oool2000008X0oooo00@00000
0?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0503oool3
000000H0oooo1@0000290?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo000K
0?ooo`030000003oool0oooo01<0oooo0`0000070?ooo`800000S03oool010000000oooo0?ooo`3o
oolE003ooc00oooo1@0000090?ooo`002@3oool2000000@0oooo0P0000030?ooo`<00000103oool0
0`000000oooo0?ooo`0B0?ooo`@000001P3oool5000008X0oooo00@000000?ooo`3oool0oooo5@00
ool`0?ooo`D000002@3oool000P0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0180oooo0`0000070?ooo`<00000S03oool010000000oooo
0?ooo`3ooolE003ooc00oooo1@0000090?ooo`00203oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool04@3oool4000000H0oooo1000002<0?oo
o`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo00080?ooo`040000003oool0oooo
000000P0oooo0`0000040?ooo`030000003oool0oooo0180oooo0`0000060?ooo`<00000S@3oool0
10000000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`00203oool010000000oooo0?ooo`00
00090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool3000000D0oooo1@00
002=0?ooo`040000003oool0oooo0?oooaD00?oo1P3oool400000080oooo100000020?ooo`@00000
6P3oool5000000T0oooo00090?ooo`8000002P3oool3000000<0oooo00<000000?ooo`3oool0403o
ool4000000H0oooo0P00002?0?ooo`040000003oool0oooo0?oooaD00?oo1`3oool00`000000oooo
000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06`3oool5000000T0oooo
000K0?ooo`030000003oool0oooo0140oooo0P0000050?ooo`D00000SP3oool010000000oooo0?oo
o`3ooolE003oo`H0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01X0oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`0@0?ooo`8000001P3o
ool200000940oooo00@000000?ooo`3oool0oooo5@00ool60?ooo`@000000P3oool4000000@0oooo
00<000000?ooo`3oool06@3oool5000000T0oooo000K0?ooo`030000003oool0oooo00l0oooo0`00
00050?ooo`D00000S`3oool010000000oooo0?ooo`3ooolE003oo`d0oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`00000J0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0
3P3oool4000000@0oooo1000002A0?ooo`040000003oool0oooo0?oooaD00?oo3P3oool2000000<0
oooo0P00000K0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool03@3oool4000000D0oooo
0`00002B0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo000K0?ooo`030000
003oool0oooo00h0oooo0`0000030?ooo`D00000TP3oool010000000oooo0?ooo`3ooolE003ooc00
oooo1@0000090?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`<000001@3oool2000009@0oooo
00@000000?ooo`3oool0oooo5@00ool`0?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool0
303oool4000000<0oooo1@00002C0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0
oooo000K0?ooo`030000003oool0oooo00`0oooo0`0000040?ooo`800000UP3oool010000000oooo
0?ooo`3ooolE003ooc00oooo1@0000090?ooo`002@3oool2000000@0oooo0P0000040?ooo`800000
103oool00`000000oooo0?ooo`0;0?ooo`@000000`3oool5000009@0oooo00@000000?ooo`3oool0
oooo5@00ool`0?ooo`D000002@3oool000P0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00`0oooo0`0000030?ooo`<00000UP3oool01000
0000oooo0?ooo`3ooolE003ooc00oooo1@0000090?ooo`00203oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool02`3oool3000000<0oooo1000
002F0?ooo`040000003oool0oooo0?oooaD00?oo<03oool5000000T0oooo00080?ooo`040000003o
ool0oooo000000T0oooo0P0000040?ooo`030000003oool0oooo00X0oooo0`0000020?ooo`D00000
U`3oool00`000000oooo0?ooo`160?ooo`D000002@3oool000P0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00T0oooo100000030?ooo`80
0000V@3oool00`000000oooo0?ooo`160?ooo`D000002@3oool000T0oooo0P00000:0?ooo`800000
103oool00`000000oooo0?ooo`080?ooo`@000000P3oool5000009P0oooo00<000000?ooo`3oool0
AP3oool5000000T0oooo000K0?ooo`030000003oool0oooo00P0oooo0`0000020?ooo`D00000V@3o
ool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`006`3oool00`000000oooo0?oo
o`070?ooo`@000000P3oool3000009/0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D00000
2@3oool001/0oooo00<000000?ooo`3oool01`3oool300000080oooo1000002K0?ooo`040000003o
ool0oooo0?oooaD0o`00<03oool5000000T0oooo000K0?ooo`030000003oool0oooo00H0oooo2@00
002L0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000K0?ooo`030000003o
ool0oooo00H0oooo1`00002N0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo
000K0?ooo`030000003oool0oooo00@0oooo2P00002M0?ooo`040000003oool0oooo0?oooaD0o`00
<03oool5000000T0oooo000K0?ooo`030000003oool0oooo00<0oooo2P00002N0?ooo`040000003o
ool0oooo0?oooaD0o`00<03oool5000000T0oooo000K0?ooo`030000003oool0oooo00<0oooo2000
002P0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000K0?ooo`030000003o
ool0oooo0080oooo2000002Q0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo
000K0?ooo`040000003oool0oooo0?ooo`P00000XP3oool010000000oooo0?ooo`3ooolE0?l000H0
oooo100000020?ooo`@000000P3oool5000001T0oooo1@0000090?ooo`00503oool500000080oooo
00<000000?ooo`0000002000002S0?ooo`040000003oool0oooo0?oooaD0o`001`3oool00`000000
oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool5000000T0
oooo000F0?ooo`040000003oool0oooo0?ooo`X00000Y@3oool010000000oooo0?ooo`3ooolE0?l0
00H0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01T0oooo1@0000090?ooo`005P3oool00`000000oooo0?ooo`0:00000:H0oooo00@000000?ooo`3o
ool0oooo5@3o00060?ooo`@000000P3oool4000000@0oooo00<000000?ooo`3oool06@3oool50000
00T0oooo000F0?ooo`030000003oool0000000H00000ZP3oool010000000oooo0?ooo`3ooolE0?l0
00d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`D000002@3oool001H0
oooo00<000000?ooo`3oool00P3oool200000:`0oooo00@000000?ooo`3oool0oooo5@3o000>0?oo
o`8000000`3oool2000001/0oooo1@0000090?ooo`005@3oool200000;80oooo00@000000?ooo`3o
ool0oooo5@3o000`0?ooo`D000002@3oool00<T0oooo00@000000?ooo`3oool0oooo5@3o000`0?oo
o`D000002@3oool00<T0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool00<T0
oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool00<T0oooo00@000000?ooo`3o
ool0oooo5@3o000`0?ooo`D000002@3oool00<T0oooo00@000000?ooo`3oool0oooo5@3o000`0?oo
o`D000002@3oool00<T0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`030000003oool0oooo
00/0oooo00390?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool02`3oool00<T0oooo
00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0;0?ooo`00b@3oool00`000000oooo0?oo
o`160?ooo`030000003oool0oooo00/0oooo00390?ooodX000003@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-0.0849462, \
-0.297564, 0.00313506, 0.0126816}, {{201.063, 274.813}, {59.8125, 4.5}} -> \
{-9.26038, -2.82506, 0.0455598, 0.0455598}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{1272, 924},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 3046, 58, 702, "Input"],

Cell[CellGroupData[{
Cell[4798, 114, 166521, 5228, 129, 154041, 5070, "GraphicsData", \
"PostScript", "Graphics"],
Cell[171322, 5344, 178022, 5280, 129, 164456, 5108, "GraphicsData", \
"PostScript", "Graphics"],
Cell[349347, 10626, 165822, 4872, 129, 152640, 4705, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

