/**
    \file Chamfer2D_7x7.h
    Header file for Chamfer2D_7x7 distance transform class which, given and
    input binary image, calculates the corresponding distance transform.

    \author George J. Grevera, Ph.D., ggrevera@sju.edu

    Copyright (C) 2002, George J. Grevera

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA or from http://www.gnu.org/licenses/gpl.txt.

    This General Public License does not permit incorporating this
    code into proprietary programs.  (So a hypothetical company such
    as GH (Generally Hectic) should NOT incorporate this code into
    their proprietary programs.)
 */
#ifndef Chamfer2D_7x7_h
#define Chamfer2D_7x7_h

#include "DistanceTransform.h"
//----------------------------------------------------------------------
/// Borgefors' Chamfer distance using a 7x7 window
class Chamfer2D_7x7 : public DistanceTransform {

public:
    Chamfer2D_7x7 ( const int xSize, const int ySize, const bool unload=true )
        : DistanceTransform(xSize, ySize, unload)
    {
    }

    /**
        this method simply calls the other doTransform method with the
        following arguments: doTransform(I, 12, 17, 27, 38, 43, true).
     */
    void doTransform ( const unsigned char* const I ) {
        doTransform(I, 12, 17, 27, 38, 43, true);
    }

    void doTransform ( const unsigned char* const I,
        const int A, const int B, const int C, const int D, const int E,
        const bool halfIsZero );

private:
    void borderCheck ( const unsigned char* const I );

};

#endif
//----------------------------------------------------------------------

