(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4177,        104]*)
(*NotebookOutlinePosition[      4824,        126]*)
(*  CellTagsIndexPosition[      4780,        122]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{
            StyleBox["G19MICNP",
              "Outline1"], 
            StyleBox[" ",
              "Outline1"], 
            StyleBox["\[IndentingNewLine]",
              "Outline1"], 
            "\[IndentingNewLine]", \(Microscope . \ Configuration\), " ", 
            "for", " ", \(Magnifier : \ 
              Near\ Point . \[IndentingNewLine]In\ most\ microscopes\ the\ \
"\<tube length\>"\ is\ 16\ cm . \ 
                  We\ have\ for\ the\[IndentingNewLine]image\ distance\ of\ \
the\ first\ lens\ xi1\)}], " ", "=", " ", \(16\  + \ f1\)}], "    ", "*)"}], 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*1. \ \(Lens : \ 
            Objective\ lens . \ Calculation\ to\ get\ xo1\)\ *) \), 
      "\[IndentingNewLine]", \(\(f1\  = \ 2;\)\[IndentingNewLine]
      \(xi1\  = \ 16\  + \ f1;\)\[IndentingNewLine]
      "\<xo1 = \>"\[IndentingNewLine]
      xo1 = \(-1\)/\((1/fl - 1/xi1)\)\[IndentingNewLine] (*2.  
            Magnifier\ Lens\ \((Ocular)\) . \ 
              In\ the\ "\<Near Point Configuration\>"\[IndentingNewLine]The\ \
image\ should\ be\ virtual\ and\ at\  - 
          25\ cm\ from\ the\ \(\(lens\)\(.\)\)*) \[IndentingNewLine]
      \(f2\  = \ 6;\)\[IndentingNewLine]
      \(xi2\  = 25;\)\[IndentingNewLine]
      "\<xo2 = \>"\[IndentingNewLine]
      xo2\  = \ \(-1\)/\((1/f2 - 1/xi2)\)\[IndentingNewLine] (*\ 
        We\ can\ calculate\ the\ distance\ between\ the\ objective\ lens\ \
\((L1)\)\ \[IndentingNewLine]and\ ocular\ lens\ \((L2)\)\ as\ \
*) \[IndentingNewLine]
      "\<a = \>"\[IndentingNewLine]
      a\  = \ 
        16\ \  + \ f1\  - \ xo2\[IndentingNewLine]\[IndentingNewLine] (*\ 
        Magnification\ \((the\ eye\ is\ not\ \
involved)\)*) \[IndentingNewLine]
      "\<M1 = \>"\[IndentingNewLine]
      M1 = \ \((xi1/xo1)\)*\((xi2/
              xo2)\)\[IndentingNewLine] (*Calculation\ using\ the\ angular\ \
magnification\ or\ magnifying\ power\ of\ the\ \
magnifier*) \[IndentingNewLine]
      "\<MM1 = \>"\[IndentingNewLine]
      MM1\  = \ \((1 - xi1/f1)\)*\((1 + 
              25/f2)\)\[IndentingNewLine] (*Neglecting\ f1\ with\ respect\ to\
\ 16\ we\ have\ *) \[IndentingNewLine]
      \(xxi1\  = \ 16;\)\[IndentingNewLine]
      "\<MM2 = \>"\[IndentingNewLine]
      MM2\  = \ \((1 - xxi1/f1)\)*\((1 + 25/f2)\)\)}]], "Input"]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 693}},
WindowSize->{1016, 666},
WindowMargins->{{-19, Automatic}, {Automatic, -7}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 2419, 51, 670, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

