(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3803,         97]*)
(*NotebookOutlinePosition[      4481,        120]*)
(*  CellTagsIndexPosition[      4437,        116]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{Cell[""], 
      RowBox[{"(*", " ", 
        RowBox[{
        Cell[TextData[StyleBox["G1FERMAT", "Program"]]], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
Fermat's Principle

Graph of total travel time\
\>"], "\[IndentingNewLine]", Cell["\<\
t1 is the time to go from the initial position (0,0) to point (xq,y) in \
medium
with velocity v1
t2 is the time to go from point (xq,y) to the final position (xf,yf) in \
medium
with velocity v2
There is a y value for minimum total time from (0,0) to(xf,yf)\
\>"]}], "                     ", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xq = 
        20;\), "\n", \(xf = 40;\), "\n", 
    RowBox[{\(yf = 40;\), 
      "\[IndentingNewLine]", \( (*\ 
        v1\ and\ v2\ are\ at\ the\ graph\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{Cell[TextData[StyleBox["y = Range[0,40,0.1];", "Program"]]], 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Time\ in\ medium\ 1\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[Cell["t1[y_]:=(1/v1)*Sqrt[xq^2+y^2];"],
        "InlineFormula"], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Time\ in\ medium\ 2\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{Cell["t2[y_]:=(1/v2)*Sqrt[xq^2+(yf-y)^2];"], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{Cell["T[y_]:= t1[y] + t2[y];"], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Changing\ the\ parameters\ v1\ and\ v2\ changes\ the\ minimum\ time\ \
for\ total\ travel\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(v1 = 1;\), "\n", 
    RowBox[{\(v2 = 2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[\ Transpose[{y, T[y]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<y\>", "\<T[y]\>"}], {{{Hue[1], "\<T[y]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowSize->{768, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2094, 45, 780, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

