(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4576,        105]*)
(*NotebookOutlinePosition[      5220,        127]*)
(*  CellTagsIndexPosition[      5176,        123]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{Cell["G8SINGCV"], "\[IndentingNewLine]", Cell["\<\
Concave single refracting surface
r is negative, light from left propagating from medium with n1 to medium with \
n2
xo on left of surface (negative)
Calculation of graph for xi as function of xo over the total range of xo.
graph for xi as function of xo over the range of xo to the left of xof.
graph for xi as function of xo over the range of xo to the right of xof.\
\>"]}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(r = \(-10\);\), "\
\[IndentingNewLine]", \(n1\  = \ 1;\), "\[IndentingNewLine]", 
    RowBox[{\(n2\  = \ 1.5;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]",
   
    RowBox[{Cell["\<\
(* Image focus *)
xif=n2*r/(n2-n1); (*xif=30*)\
\>"], "\[IndentingNewLine]"}], "\[IndentingNewLine]", Cell["\<\
(* Object focus *)
xof=n1*r/(n1-n2); (*xof=-20*)\
\>"], "\[IndentingNewLine]", 
  Cell[""], "\[IndentingNewLine]", \(xo = 
        Range[\(-100.001\), 100, 0.07];\), "\n", \(xi[xo_] := 
        n2/\((\((n2 - n1)\)/r + n1/xo)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{xo, xi[xo]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<xo\>", "\<xi[xo]\>"}, 
            PlotRange \[Rule] {{\(-150\), 100}, {\(-1500\), 1500}}], {{{Hue[
                  1], "\<xi[xo]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xxo = 
        Range[\(-100.001\), 15, 0.07];\), "\n", \(xxi[xxo_] = 
        n2/\((\((n2 - n1)\)/r + n1/xxo)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{xxo, xxi[xxo]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<xxo\>", "\<xxi[xxo]\>"}, 
            PlotRange \[Rule] {{\(-120\), 20}, {\(-50\), 100}}], {{{Hue[
                  1], "\<xxi[xxo]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xxxo\  = \ 
        Range[22.001, 50, 1.3];\), "\[IndentingNewLine]", \(xxxi[xxxo_]\  = \ 
        n2/\((\((n2 - n1)\)/r + 
              n1/xxxo)\);\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{xxxo, xxxi[xxxo]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<xxxo\>", "\<xxxi[xxxo]\>"}, 
          PlotRange \[Rule] {{20, 50}, {\(-400\), 0}}], {{{Hue[
                1], "\<xxxi[xxxo]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2867, 53, 791, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

