(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4647,        109]*)
(*NotebookOutlinePosition[      5292,        131]*)
(*  CellTagsIndexPosition[      5248,        127]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W10BES3DS
  
1. Rayleigh distance corresponding to \"resolution\" is determined for two \
round apertures at distance d between them.
2. 3D graph of pattern of two round apertures at distance d.Radius of \
apertures is a,coordinate on the observation screen R,wavelength l and \
distance from aperture to screen is X.
    

1. Determination of Rayleigh distance.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(a\  = \ 
        0.05;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(d\  = \ 
        24.5;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", 
    RowBox[{\(n\  = \ 60;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(R\  = \ 
        Range[0.00001, 50, 0.1];\), "\[IndentingNewLine]", \(g1[
          R_] := \ \((BesselJ[1, 2*Pi*a*R\/\(X*\[Lambda]\)]\/\(2*Pi*a*R\/\(X*\
\[Lambda]\)\))\)\^2;\), "\[IndentingNewLine]", 
    RowBox[{\(gg1[
            R_] := \ \((BesselJ[1, 2*Pi*a*\((R - \
d)\)\/\(X*\[Lambda]\)]\/\(2*Pi*a*\((R - d)\)\/\(X*\[Lambda]\)\))\)\^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{R, g1[R]}], Transpose[{R, gg1[R]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<R\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 50}, {0, 0.25}}], {{{Hue[
                  1], "\<g1[R]\>"}, {Hue[0.5], "\<gg1[R]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2. \ 3  D\ Graph\ \ Distance\ d\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xi[
          i_] := \ \(-40\)\  + \ 2.0001*i;\), "\[IndentingNewLine]", 
    RowBox[{\(yj[j_] := \ \(-40\)\  + \ 2.0001*j;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(RR[x_, 
          y_] := \@\(x\^2 + y\^2\);\), "\[IndentingNewLine]", \(g2[x_, 
          y_] := \((BesselJ[1, 2*Pi*a*RR[x, \
y]\/\(X*\[Lambda]\)]\/\(2*Pi*a*RR[x, y]\/\(X*\[Lambda]\)\))\)\^2;\), "\
\[IndentingNewLine]", 
    RowBox[{\(gg2[x_, 
            y_] := \((BesselJ[1, 2*Pi*a*RR[x, y - \
d]\/\(X*\[Lambda]\)]\/\(2*Pi*a*RR[x, y - d]\/\(X*\[Lambda]\)\))\)\^2;\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(M = \ 
          Table[g2[xi[i], yj[j]] + gg2[xi[i], yj[j]], {i, 0, n, 1}, {j, 0, n, 
              1}];\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", \
\(ListPlot3D[M, PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.3}}, 
        PlotLabel -> "\<M\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{452, 532},
WindowMargins->{{Automatic, 23}, {Automatic, -3}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2938, 57, 1284, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

