(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4558,        108]*)
(*NotebookOutlinePosition[      5203,        130]*)
(*  CellTagsIndexPosition[      5159,        126]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W12TWOROCOHS
Imaging with coherent light:Two round apertures at Rayleigh distance,round \
lens,and Y is used for R'.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\), 
      "\[IndentingNewLine]", \( (*\ 
        Integration\ limits\ *) \)}], "\[IndentingNewLine]", \(b1\  = \ \
\(-0.00025\);\), "\[IndentingNewLine]", \(b2\  = \ 
        0.00025;\), "\[IndentingNewLine]", \(b3\  = \ 
        0.00585;\), "\[IndentingNewLine]", 
    RowBox[{\(b4\  = \ 0.00635;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]\  = \ 0.0005;\), 
      "\[IndentingNewLine]", \( (*\ 
        f/10 = f/2  a\ *) \)}], "\[IndentingNewLine]", \(f\  = \ 
        500;\), "\[IndentingNewLine]", \(a\  = \ 25;\), "\[IndentingNewLine]",
   
    RowBox[{\(k\  = \ \(2*Pi\)\/\[Lambda];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(Y = \ Range[\(-0.01\), 0.02, 0.0001];\), 
      "\[IndentingNewLine]", \( (*\ 
        Object\ \(\(Amplitudes\)\(:\)\)\ *) \)}], "\[IndentingNewLine]", \
\(iob1[Y_] := \ \((UnitStep[b2 - Y] - 
            UnitStep[b1 - Y])\);\), "\[IndentingNewLine]", 
    RowBox[{\(iob2[Y_] := \ \((UnitStep[b4 - Y] - UnitStep[b3 - Y])\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Image\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(iob[Y_] := \ iob1[Y]\  + \ iob2[Y];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(IIm[
            Y_] := \ \((NIntegrate[Evaluate[4*a\^2*\((BesselJ[1, \(k*a*\((Y - \
YY)\)\)\/f]\/\(k*a*\(Y - YY\)\/f\))\)], {YY, b1, b2}] + \
NIntegrate[Evaluate[4*a\^2*\((BesselJ[1, \(k*a*\((Y - YY)\)\)\/f]\/\(k*a*\(Y \
- YY\)\/f\))\)], {YY, b3, b4}])\)\^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{Y, iob[Y]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<Y\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.01\), 0.02}, {0, 2}}], {{{Hue[
                  1], "\<iob[Y]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{Y, IIm[Y]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.01\), 0.02}, {0, 1}}], {{{Hue[
                1], "\<IIm[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
(b4-b3)/2 + b3 = 6.1 * 10^-3
Resolution is obtained for 
b3 = 0.00795
b4 = 0.00845\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{-7, Automatic}, {29, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2849, 56, 1150, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

