(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5696,        125]*)
(*NotebookOutlinePosition[      6340,        147]*)
(*  CellTagsIndexPosition[      6296,        143]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W17HOGRPERS
  
The object is a periodic structure.The FT of the object is multiplied by a \
blocking function.A blocking function has been chosen blocking certain \
frequencies such that there are twice as many peaks in the image.
    
The FT (inverse) of (FT of object)*(Blocking Function) is the \" new\" \
image.The \"new\" image is compared to the original,that is the FT of (FT of \
object)
The blocking function removes certain high frequencies of the FT.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(i\  = \ 
        Range[1, 127, 1];\), "\[IndentingNewLine]", \(b\  = \ 
        2;\), "\[IndentingNewLine]", \(q\  = \ 7;\), "\[IndentingNewLine]", 
    RowBox[{\(y\_i = \[Sum]\+\(n = 0\)\%q\((UnitStep[
                  i - \((4*\((2*n + 1)\) + 2)\)*b] - 
                UnitStep[i - \((4*\((2*n + 1)\) + 4)\)*b])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 150}, {0, 2}}], {{{Hue[
                  1], \*"\"\<\!\(y\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        FT\ of\ the\ object\ yy\ is\ \[Omega]\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Omega]\  = \ 
        Fourier[y\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Omega]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 150}, {\(-1\), 2}}], {{{Hue[
                  1], "\<Re[\[Omega]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Blocking\ Function\ *) \)}], "\[IndentingNewLine]", \(q\  = \ 
        5;\), "\[IndentingNewLine]", \(a\  = \ 5;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Tau] = \ \[Sum]\+\(n = 0\)\%q\((UnitStep[
                  i - \((4*n + 2)\)*a] - UnitStep[i - \((4*n + 4)\)*a])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, \[Tau]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 150}, {0, 2}}], {{{Hue[1], "\<\[Tau]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Product : 
          FT\ \((inverse)\)\ of\ object\n
            and\ Blocking\ Function\ *) \)}], "\[IndentingNewLine]", \(\[Phi] \
= \[Omega]*\[Tau];\), "\[IndentingNewLine]", \(yy = 
        InverseFourier[\[Phi]];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, yy}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 150}, {\(-1\), 2}}], {{{Hue[
                  1], "\<yy\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        For\ \(comparison : 
            Original\ Object\)\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 150}, {0, 2}}], {{{Hue[
                1], \*"\"\<\!\(y\_i\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{-4, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3987, 73, 1338, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

