(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5094,        116]*)
(*NotebookOutlinePosition[      5738,        138]*)
(*  CellTagsIndexPosition[      5694,        134]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W1FTSERIS
Fourier series of spatial wavelength \[Lambda] for the interval from-1 to \
1(shown to 2).
        
For N=0 the only term is a sine wave from-1 to 1,of wavelength \[Lambda]=2.
For N=1 a sine-term with 1/3 of \[Lambda] and smaller amplitude is added.
For N=2 a term with 1/5 of \[Lambda] and smaller amplitude,and so on.
If N is large,we see a perfect step function.
    
For smaller N (in the 20th) we see \"Gibb's phenomenon\",the corners are not \
round and there is \"overshooting\".
For large N it disappears.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(x\  = \ 
        Range[\(-1\), 1.9, 0.01];\), "\[IndentingNewLine]", \(n\  = \ 
        Range[0, 1, 200];\), "\[IndentingNewLine]", \(\[CapitalLambda]\  = \ 
        1;\), "\[IndentingNewLine]", \(NN\  = \ 
        100;\), "\[IndentingNewLine]", \(f[
          n_] := \ \(2*n + 1\)\/\(2*\[CapitalLambda]\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(g[
            x_] := \[Sum]\+\(n = 0\)\%NN\((\(4*Sin[2*Pi*x*f[n]]\)\/\(\((2*n + \
1)\)*Pi\))\);\), 
      "\[IndentingNewLine]", \( (*\ 
        For\ larger\ and\ larger\ N\ one\ can\ see\ how\ more\ and\ more\n
          waves\ with\ shorter\ and\ shorter\ wavelength\ are\ used\ to\ \
build\ the\ step\ \(\(function\)\(.\)\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(g0[
          x_] := \ \(4*Sin[Pi*x*1\/\[CapitalLambda]]\)\/Pi;\), "\
\[IndentingNewLine]", \(g1[
          x_] := \ \(4*Sin[Pi*x*\(2*1 + 1\)\/\[CapitalLambda]]\)\/\(\((2*1 + \
1)\)*Pi\);\), "\[IndentingNewLine]", 
    RowBox[{\(g2[
            x_] := \ \(4*Sin[Pi*x*\(2*2 + 1\)\/\[CapitalLambda]]\)\/\(\((2*2 \
+ 1)\)*Pi\);\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{x, g0[x]}], Transpose[{x, g1[x]}], 
            Transpose[{x, g2[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-1\), 2}, {\(-2\), 2}}], {{{Hue[
                  1], "\<g0[x]\>"}, {Hue[0.5], "\<g1[x]\>"}, {Hue[
                  0.25], "\<g2[x]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, g0[x] + g1[x] + g2[x]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-1\), 2}, {\(-2\), 2}}], {{{Hue[
                  1], "\<g0[x]+g1[x]+g2[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{x, g[x]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-1\), 2}, {\(-2\), 2}}], {{{Hue[
                1], "\<g[x]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{479, 599},
WindowMargins->{{9, Automatic}, {28, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3385, 64, 1345, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

