(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7309,        156]*)
(*NotebookOutlinePosition[      7952,        178]*)
(*  CellTagsIndexPosition[      7908,        174]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W2FTCFTS
Example of real fft and complex cfft on a real object function.
    
1. The real FT fft\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(i\  = \ Range[0, 255, 1];\), 
      " ", \( (*\ The\ Object\ *) \)}], "\[IndentingNewLine]", \(A\_1\  = \ 
        33;\), "\[IndentingNewLine]", \(A\_2\  = \ 
        80;\), "\[IndentingNewLine]", \(A\_3 = \ 
        80;\), "\[IndentingNewLine]", \(A\_4 = \ 
        50;\), "\[IndentingNewLine]", \(A\_5\  = \ 
        20;\), "\[IndentingNewLine]", \(A\_6\  = \ 
        99;\), "\[IndentingNewLine]", \(A\_7\  = \ 
        160;\), "\[IndentingNewLine]", \(A\_8\  = \ 
        200;\), "\[IndentingNewLine]", 
    RowBox[{\(y\_i = \[Sum]\+\(n = 1\)\%3\((\(-UnitStep[
                    A\_n - i]\))\) + \[Sum]\+\(n = 4\)\%8\((UnitStep[
                    A\_n - i]*\((\(-1\))\)\^n)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-2\), 2}}], {{{Hue[
                  1], \*"\"\<\!\(y\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ real\ Fourier\ Transformation\ *) \)}], "\[IndentingNewLine]", \
\(c = \ Fourier[y\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[c]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 150}, {\(-5\), 5}}], {{{Hue[
                  1], "\<Re[c]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ Inverse\ Fourier\ Transformation\ *) \)}], \
"\[IndentingNewLine]", \(x = \ InverseFourier[c];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, x}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-4\), 2}}], {{{Hue[1], "\<x\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ The\ complex\ Fourier\ \(\(Transformation\)\(.\)\)\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Range[0, 255, 1];\), 
      " ", \( (*\ The\ Object\ *) \)}], "\[IndentingNewLine]", \(A\_1\  = \ 
        33;\), "\[IndentingNewLine]", \(A\_2\  = \ 
        80;\), "\[IndentingNewLine]", \(A\_3 = \ 
        80;\), "\[IndentingNewLine]", \(A\_4 = \ 
        50;\), "\[IndentingNewLine]", \(A\_5\  = \ 
        20;\), "\[IndentingNewLine]", \(A\_6\  = \ 
        99;\), "\[IndentingNewLine]", \(A\_7\  = \ 
        160;\), "\[IndentingNewLine]", \(A\_8\  = \ 
        200;\), "\[IndentingNewLine]", \(y\_i = \[Sum]\+\(n = \
1\)\%3\((\(-UnitStep[A\_n - i]\))\) + \[Sum]\+\(n = 4\)\%8\((UnitStep[
                  A\_n - i]*\((\(-1\))\)\^n)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-2\), 2}}], {{{Hue[
                  1], \*"\"\<\!\(y\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ complex\ Fourier\ Transformation\ *) \)}], "\[IndentingNewLine]",
   
    RowBox[{\(cc\  = \ Fourier[y\_i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[cc]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-5\), 5}}], {{{Hue[
                  1], "\<Re[cc]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ Inverse\ Fourier\ Transformation\ *) \)}], \
"\[IndentingNewLine]", \(xx = \ InverseFourier[cc];\), "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[xx]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-4\), 2}}], {{{Hue[
                  1], "\<Re[xx]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Application\ of\ cfft\ the\ second\ time, 
        instead\ of\ the\ invers\ icfft\ *) \)}], "\[IndentingNewLine]", \
\(xxx\  = \ Fourier[cc];\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{i, Re[xxx]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {\(-4\), 2}}], {{{Hue[
                1], "\<Re[xxx]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{555, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5600, 104, 1580, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

