(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4234,        101]*)
(*NotebookOutlinePosition[      4879,        123]*)
(*  CellTagsIndexPosition[      4835,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W4IMTWOBS
Imaging:Object is \"Two bars\" and cylindrical lens is used.
f/10=f/2a    a is \"radius\" of cylindrical lens\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(b1\  = \ \
\(-0.008\);\), "\[IndentingNewLine]", \(b2\  = \ \(-0.005\);\), "\
\[IndentingNewLine]", \(b3\  = \ 0.005;\), "\[IndentingNewLine]", \(b4\  = \ 
        0.008;\), "\[IndentingNewLine]", \(\[Lambda] = \ 
        0.0005;\), "\[IndentingNewLine]", \(f\  = \ 
        500;\), "\[IndentingNewLine]", \(a\  = \ 25;\), "\[IndentingNewLine]",
   
    RowBox[{\(k\  = \ \(2*Pi\)\/\[Lambda];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(Y = \ Range[\(-0.02\), 0.02, 0.001];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(Io1[
          Y_] := \((UnitStep[b2 - Y] - 
            UnitStep[b1 - Y])\);\), "\[IndentingNewLine]", \(Io2[
          Y_] := \((UnitStep[b4 - Y] - 
            UnitStep[b3 - Y])\);\), "\[IndentingNewLine]", 
    RowBox[{\(Io[Y_] := \ Io1[Y] + Io2[Y];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{Y, Io[Y]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<Y\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.02\), 0.02}, {0, 2}}], {{{Hue[
                  1], "\<Io[Y]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(Iim1[Y_] := 
        NIntegrate[
          Evaluate[
            4*a\^2*\((Sin[\(k*a*\((Y - YY)\)\)\/f]\/\(\(k*a*\((Y - YY)\)\)\/f\
\))\)\^2, {YY, b1, b2}]];\), "\[IndentingNewLine]", 
    RowBox[{\(Iim2[Y_] := 
          NIntegrate[
            Evaluate[
              4*a\^2*\((Sin[\(k*a*\((Y - YY)\)\)\/f]\/\(\(k*a*\((Y - \
YY)\)\)\/f\))\)\^2, {YY, b3, b4}]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(Iim[Y_] := \ 
        Iim1[Y] + Iim2[Y];\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{Y, Iim[Y]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.02\), 0.02}, {0, 10}}], {{{Hue[
                1], "\<Iim[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{65, Automatic}, {Automatic, 11}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2525, 49, 938, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

