(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5968,        132]*)
(*NotebookOutlinePosition[      6613,        154]*)
(*  CellTagsIndexPosition[      6569,        150]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W7PUTRAS
Incoherent case,one dimensional.
Object is a pulse presented by y.Lens is cylindrical with spread function \
(sinx/x)^2. FT of spread function=transfer function.
The image is FT of (FT of spread function (transfer function) times FT of \
object).\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(b\  = \ 
        2;\), "\[IndentingNewLine]", \(b1\  = \ 
        100;\), "\[IndentingNewLine]", \(b2\  = \ 
        140;\), "\[IndentingNewLine]", \(qq\  = \ 
        14;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", 
    RowBox[{\(fn\  = \ 10;\), 
      "\[IndentingNewLine]", \( (*\ 
        Object : 
          Sum\ of\ step\ functions\ *) \)}], "\[IndentingNewLine]", \(k\  = \ 
        Range[1, 255, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(y\_k = \ UnitStep[b2 - k] - UnitStep[b1 - k];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k, y\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {0, 1.5}}], {{{Hue[
                  1], \*"\"\<\!\(y\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        FT\ of\ the\ Object\ y\ is\ \[Omega]\ *) \)}], "\[IndentingNewLine]", \
\(\[Omega]\  = \ Fourier[y\_k];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k, Re[\[Omega]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 255}, {\(-4\), 4}}], {{{Hue[
                  1], "\<Re[\[Omega]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
The spread function is (sinz/z)^2 because of cylindrica 
FT of spread function is transfer function \[Tau] 
f#=f/2a=fn\
\>"], " ", 
        "*)"}]}], "\[IndentingNewLine]", \(S\_k = \((Sin[\(Pi*k\)\/\(fn*\
\[Lambda]*255\)]\/\(\(Pi*k\)\/\(fn*\[Lambda]*255\)\))\)\^2;\), "\
\[IndentingNewLine]", 
    RowBox[{\(\[Tau]\  = \ Fourier[S\_k];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k, Re[\[Tau]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.005\), 0.01}}], {{{Hue[
                  1], "\<Re[\[Tau]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Product\ of\ FT\ of\ object\ and\ FT\ of\ spread\ function \
\((transfer\ function)\)\ is\ \[Phi]\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Phi] = \((\[Tau]*\[Omega])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{k, Re[\[Phi]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.2\), 0.1}}], {{{Hue[
                  1], "\<Re[\[Phi]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Image\ *) \), 
      "\[IndentingNewLine]", \( (*\ 
        FT\ \((inverse)\)\ of\ the\ Product\ of\ FT\ of\ object\ and\ FT\ of\ \
transfer\ function\ *) \)}], "\[IndentingNewLine]", \(yy = \ 
        InverseFourier[\[Phi]];\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{k, yy}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<k\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {0, 0.02}}], {{{Hue[1], "\<yy\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 59}, {Automatic, 10}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4259, 80, 1378, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

