(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5519,        124]*)
(*NotebookOutlinePosition[      6164,        146]*)
(*  CellTagsIndexPosition[      6120,        142]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W9TRAJ1S
Incoherent case.Fourier transformation of a periodic structure using the \
transfer function:(Bessel)\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\n", \(b = 
        2;\), "\n", \(qq = 14;\), "\n", \(\[Lambda] = 0.0005;\), "\n", \(fn = 
        10;\), "\n", 
    RowBox[{\(i = Range[0, 255, 1];\), 
      "\[IndentingNewLine]", \( (*\ 
        Object : Sum\ of\ step\ functions\ *) \)}], "\n", 
    RowBox[{\(y\_i = \[Sum]\+\(n = 0\)\%qq\((UnitStep[
                  i - \((4\ \((2\ n + 1)\) + 2)\)\ b] - 
                UnitStep[i - \((4\ \((2\ n + 1)\) + 4)\)\ b])\);\), 
      "\[IndentingNewLine]"}], "\n", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {0, 1.5}}], {{{Hue[
                  1], "\<\!\(y\_i\)\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\n", 
      "\[IndentingNewLine]", \( (*\ 
        FT\ of\ the\ Object\ y\ is\ \[Omega]\ *) \)}], "\[IndentingNewLine]", \
\(\[Omega] = Fourier[y\_i];\), "\n", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Omega]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 255}, {\(-2\), 4}}], {{{Hue[
                  1], "\<Re[\[Omega] ]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\n", \( (*\ 
        Ft\ of\ spread\ function\ is\n
          transfer\ function\ \[Tau]\ *) \)}], "\[IndentingNewLine]", \(ii = 
        Range[1, 255, 1];\), "\n", 
    RowBox[{\(S\_ii = 
          4\ \((BesselJ[1, \(\[Pi]\ ii\)\/\(fn\ \[Lambda]\ 255\)]\/\(\(\[Pi]\ \
ii\)\/\(fn\ \[Lambda]\ 255\)\))\)\^2;\), 
      "\[IndentingNewLine]", \( (*\ error\ correction, \ 
        division\ by\ zero\ at\ the\ first\ element\ *) \)}], "\n", \(S\_i = 
        PadLeft[S\_ii, 256];\), "\n", 
    RowBox[{\(\[Tau] = Fourier[S\_i];\), "\[IndentingNewLine]"}], "\n", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Tau]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.01\), 0.02}}], {{{Hue[
                  1], "\<Re[\[Tau]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\n", 
      "\[IndentingNewLine]", \( (*\ 
        Product\ of\ FT\ of\ object\ and\ transfer\ function\ is\ \[Phi]\ *) \
\)}], "\[IndentingNewLine]", \(\[Phi] = \[Tau]\ \[Omega];\), "\n", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Phi]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.02\), 0.06}}], {{{Hue[
                  1], "\<Re[\[Phi]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
Image
Product of FT of object and transfer function is f\
\>"], "\[IndentingNewLine]", "*)"}]}], "\n", \(yy = 
        InverseFourier[\[Phi]];\), "\n", \(ShowLegend[
        ListPlot[Transpose[{i, yy}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {0, 0.02}}], {{{Hue[1], "\<yy\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{508, 599},
WindowMargins->{{Automatic, 212}, {Automatic, 6}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3810, 72, 1296, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

