(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6186,        134]*)
(*NotebookOutlinePosition[      6833,        156]*)
(*  CellTagsIndexPosition[      6789,        152]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
A2SPASSS
Spherical aberration of single refracting surface.
Definition:Longitudinal spherical Aberration L.S.A. =xi-xiisph
Calculation of image point xi and corrected image point xiisph
All lengths in cm.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", 
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]", \( (*\ 
        1. \ Calculation\ of\ xi \((xo)\)\ for\ negative\ values\ of\ xo\ *) \
\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Input\ Data\ *) \)}], "\[IndentingNewLine]", \(ro\  = \ 
        2;\), "\[IndentingNewLine]", \(n\  = \ 
        1.5;\), "\[IndentingNewLine]", \(r\  = \ 
        10;\), "\[IndentingNewLine]", \(xo\  = \ 
        Range[\(-20.000001\), \(-100\), \(-1\)];\), "\[IndentingNewLine]", 
    RowBox[{\(xi[xo_] := \ 1\/\(\(n - 1\)\/\(n*r\) + 1\/\(n*xo\)\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Calculation\ of\ xiisph \((xo)\)\ depending\ on\ xo\ for\ the\ \
corrected\ case\ of\ L . S . A . \ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(xiisph[xo_] := \ 
          n\/\(\((\(n - 1\)\/r)\) + 1\/xo + \(n - \
1\)\/n\^2*ro\^2\/2*\((\((1\/r - 1\/xo)\)\^2*\((1\/r - \(n + \
1\)\/xo)\))\)\);\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{xo, xi[xo]}], 
            Transpose[{xo, xiisph[xo]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<xo\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-100\), 0}, {0, 100}}], {{{Hue[
                  1], "\<xi[xo]\>"}, {Hue[0.5], "\<xiisph[xo]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{xo, \((xi[xo] - xiisph[xo])\)}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, AxesLabel \[Rule] {"\<xo\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-100\), 0}, {\(-10\), 20}}], {{{Hue[
                  1], "\<(xi[xo]-xiisph[xo])\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Calculation\ of\ xiisph \((nn)\)\ depending\ on\ the\ refractive\
\ index\ nn\ *) \)}], "\[IndentingNewLine]", \(nn\  = \ 
        Range[1.40, 4, 
          0.01];\), "\[IndentingNewLine]", \(xxo\  = \ \(-30\);\), "\
\[IndentingNewLine]", \(rr\  = \ 10;\), "\[IndentingNewLine]", \(xi[nn_] := \ 
        1\/\(\(nn - 1\)\/\(nn*rr\) + 1\/\(nn*xxo\)\);\), \
"\[IndentingNewLine]", 
    RowBox[{\(xiisph[nn_] := \ 
          n\/\(\((\(nn - 1\)\/rr)\) + 1\/xxo + \(nn - 1\)\/nn\^2*ro\^2\/2*\((\
\((1\/rr - 1\/xxo)\)\^2*\((1\/r - \(nn + 1\)\/xxo)\))\)\);\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn, xi[nn]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<nn\>", "\<\>"}, 
            PlotRange \[Rule] {{1, 4}, {0, 300}}], {{{Hue[1], "\<xi[nn]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn, xiisph[nn]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<nn\>", "\<\>"}, 
            PlotRange \[Rule] {{1, 4}, {0, 200}}], {{{Hue[
                  1], "\<xiisph[nn]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn, xi[nn] - xiisph[nn]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, AxesLabel \[Rule] {"\<nn\>", "\<\>"}, 
            PlotRange \[Rule] {{1, 4}, {0, 100}}], {{{Hue[
                  1], "\<xi[nn]-xiisph[nn]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \( (*\ 
      There\ is\ no\ value\ for\ which\ LSA\  = \ 0\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{507, 603},
WindowMargins->{{Automatic, 190}, {-12, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4477, 82, 1526, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

