(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5650,        126]*)
(*NotebookOutlinePosition[      6296,        148]*)
(*  CellTagsIndexPosition[      6252,        144]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
A6COMPLANS

Aplanantic Lens
For the aplanatic lens,both,spherical aberration and coma are zero.For the \
calculation of coma,the incident light is assumed to be parallel.
    
    
1. The aplanatic lens\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(xo\  = \ \(-30\);\), "\[IndentingNewLine]", \(n\  = \ 
        1.5;\), "\[IndentingNewLine]", \(\[Rho]\  = \ 
        1;\), "\[IndentingNewLine]", \(\[Beta]\  = \ 
        0.05;\), "\[IndentingNewLine]", \(r2\  = \ \(xo*n\)\/\(n + 1\);\), "\
\[IndentingNewLine]", \(xi = \ 
        n*xo;\), "\[IndentingNewLine]", \(r1\  = \ \(-30\);\), "\
\[IndentingNewLine]", \(xo\  = \ r1;\), "\[IndentingNewLine]", 
    RowBox[{\(f\  = \ \(n + 1\)\/\(n - 1\)*r2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ and\ for\ \[Pi]\[Pi], \ \[Rho], \ W, \ 
        G\ *) \), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\[Pi]\[Pi]\  = \ \(xi + xo\)\/\(xi - xo\);\), 
      " ", \( (*\ \[Pi]\[Pi]\  = \ 5\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Sigma]\  = \ \(r2 + xo\)\/\(r2 - xo\);\), 
      " ", \( (*\ \[Sigma]\  = \ \(-4\)\ *) \), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(W[
          n_] := \ \(3*\((n + 1)\)\)\/\(4*n*\((n - 1)\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(G[n_] := \ \(3*\((2*n + 1)\)\)\/\(4*n\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ The\ correction\ for\ coma\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(Co[\[Rho]_] := \ \(\[Rho]\^2*Tan[\[Beta]]\)\/f\^2*\((W[
                    n]*\[Sigma] + G[n]*\[Pi]\[Pi])\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Coma\ is\ eliminated\ if\ Co = 0, 
        that\ is\ \((W \((n)\) \[Sigma] + G \((n)\) \[Pi]\[Pi])\)\ is\ 0, 
        or\ \[Sigma] = \(-p\) \((G \((n)\)/W \((n)\))\)\ *) \), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Graph\ of\ y \((n)\)\  = \ \((W \((n)\)*\[Sigma]\  + \ 
              G \((n)\)*\[Pi]\[Pi])\)\ *) \), 
      "\[IndentingNewLine]", \( (*\ We\ double\ up\ and\ use\ nn, xxo, pp, 
        ss\ *) \)}], "\[IndentingNewLine]", \(nn\  = \ 
        Range[1.01, 4, 0.01];\), "\[IndentingNewLine]", \(rr2[nn_] := \ 
        xo*nn\/\(nn + 1\);\), "\[IndentingNewLine]", \(W[
          nn_] := \ \(3*\((nn + 1)\)\)\/\(4*nn*\((nn - 1)\)\);\), "\
\[IndentingNewLine]", \(G[
          nn_] := \ \(3*\((2*nn + 1)\)\)\/\(4*nn\);\), "\[IndentingNewLine]", \
\(W[nn_] := \ \(3*\((nn + 1)\)\)\/\(4*nn*\((nn - 1)\)\);\), "\
\[IndentingNewLine]", \(pp[
          nn_] := \ \(nn*xo + xo\)\/\((nn*xo - xo)\);\), \
"\[IndentingNewLine]", \(ss[
          nn_] := \ \(rr2[nn] + r1\)\/\(rr2[nn] - r1\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(y[nn_] := \ W[nn]*ss[nn] + G[nn]*pp[nn];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn, y[nn]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<nn\>", "\<\>"}, 
            PlotRange \[Rule] {{1, 4}, {\(-1\)*10\^\(-12\), 
                  5*10\^\(-13\)}}], {{{Hue[1], "\<y[nn]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Coma\ is\ zero\ for\ most\ values\ of\ nn\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{nn, ss[nn]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<nn\>", "\<\>"}, 
          PlotRange \[Rule] {{1, 4}, {\(-10\), 0}}], {{{Hue[
                1], "\<ss[nn]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{492, 599},
WindowMargins->{{Automatic, 87}, {Automatic, -30}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3941, 74, 1468, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

