(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4126,         97]*)
(*NotebookOutlinePosition[      4773,        119]*)
(*  CellTagsIndexPosition[      4729,        115]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
A7ASTSINS
Astigmatism on a single surface.
We have for the horizontal and vertical direction each an imaging equation \
that looks like the imaging equation for the single spherical surface,but \
where the expressions depend on angles.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\), 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
1. The vertical and horizontal imaging equations.
We have for horizontal-1/xo+n/xih=(n cos\[Phi]'-cos\[Phi])/r
and for vertical-cos\[Phi]^2/xo+ncos\[Phi]'^2/xiv=(ncos\[Phi]'-cos\[Phi])/r
        
using the law of refraction we can replace \[Phi]' by \[Phi].
We call cos(\[Phi]')=c(\[Phi])\
\>"], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ \ 2. \ For\ fixed\ n\ we\ calculate\ xih \
\((\[Phi])\)\ as\ function\ of\ \[Phi]\ *) \)}], "\[IndentingNewLine]", \(xo\ \
 = \ \(-100\);\), "\[IndentingNewLine]", \(r\  = \ 
        10;\), "\[IndentingNewLine]", \(n\  = \ 
        1.2;\), "\[IndentingNewLine]", \(\[Phi]\  = \ 
        Range[0.1, 0.5, 
          0.01];\), "\[IndentingNewLine]", \(c[\[Phi]_] := \ \@\(1 - \
Sin[2*Pi*\[Phi]\/360]\^2\/n\^2\);\), "\[IndentingNewLine]", 
    RowBox[{\(xih[\[Phi]_] := \ 
          n\/\((\(n*c[\[Phi]] - Cos[2*\[Phi]*Pi\/360]\)\/r + 1\/xo)\);\), 
      "\[IndentingNewLine]", \( (*\ 
        3. \ For\ fixed\ n\ we\ calculate\ xiv \((\[Phi])\)\ as\ function\ of\
\ \[Phi]\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(xiv[\[Phi]_] := \ \(n*c[\[Phi]]\^2\)\/\((\((\(n*c[\[Phi]] - \
Cos[2*\[Phi]*Pi\/360]\)\/r)\) + Cos[2*Pi*\[Phi]\/360]\^2\/xo)\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        4. \ Graph\ of\ the\ difference\ ASD\ for\ fixed\ n\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(ASD[\[Phi]_] := \ xih[\[Phi]] - xiv[\[Phi]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Phi], ASD[\[Phi]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Phi]\>", "\<\>"}, 
          PlotRange \[Rule] {{0.1, 0.5}, {0, 0.02}}], {{{Hue[
                1], "\<ASD[\[Phi]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{-11, Automatic}, {Automatic, -33}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2417, 45, 985, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

