(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4838,        108]*)
(*NotebookOutlinePosition[      5482,        130]*)
(*  CellTagsIndexPosition[      5438,        126]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
A8ASTISMS
Astigmatism of a thin lens.

 We have for the horizontal and vertical direction each an imaging equation \
that looks like the imaging equation for the thin lens,but where the \
expressions depend on angles.

We have for horizontal \
-1/xo+1/xih=(cos\[Phi])(cos\[Phi]'/cos\[Phi]-1)(1/r1-1/r2)
and for vertical -1/xo+1/xiv=(1/cos\[Phi])(cos\[Phi]'/cos\[Phi]-1)(1/r1-1/r2)
      
using the law of refraction we can replace \[Phi]' by \[Phi] and make a plot \
of the difference xih-xiv as function of \[Phi].\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\), 
      "\[IndentingNewLine]", \( (*\ 
        1. \ Graph\ of\ ASD\ for\ fixed\ n\ and\ dependence\ on\ \[Phi]\ *) \
\)}], "\[IndentingNewLine]", \(xoo\  = \ \(-400\);\), "\[IndentingNewLine]", \
\(r1\  = \ 
        10;\), "\[IndentingNewLine]", \(r2 = \ \(-12\);\), "\
\[IndentingNewLine]", \(n\  = \ 1.3;\), "\[IndentingNewLine]", \(\[Phi]\  = \ 
        Range[1, 10, 
          1];\), "\[IndentingNewLine]", \(c[\[Phi]_] := \@\(1 - Sin[2*Pi*\
\[Phi]\/360]\^2\/n\^2\);\), "\[IndentingNewLine]", \(xih[\[Phi]_] := 
        1\/\((\((\((Cos[2*Pi*\[Phi]\/360])\)*\((c[\[Phi]]\/Cos[2*Pi*\[Phi]\/\
360] - 1)\)*\((1\/r1 - 1\/r2)\))\) + 1\/xoo)\);\), "\[IndentingNewLine]", \
\(xiv[\[Phi]_] := 
        1\/\((\((1\/Cos[2*Pi*\[Phi]\/360]*\((c[\[Phi]]\/Cos[2*Pi*\[Phi]\/360] \
- 1)\)*\((1\/r1 - 1\/r2)\))\) + 1\/xoo)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ASD[\[Phi]_] := \ xih[\[Phi]] - xiv[\[Phi]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Phi], ASD[\[Phi]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Phi]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 10}, {0, 20}}], {{{Hue[
                  1], "\<ASD[\[Phi]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Graph\ of\ ASD\ for\ fixed\ f\ and\ dependence\ on\ n\ *) \)}], \
"\[IndentingNewLine]", \(\[Phi]\  = \ 5;\), "\[IndentingNewLine]", \(n\  = \ 
        Range[1.3, 3, 0.001];\), "\[IndentingNewLine]", \(c[
          n_] := \@\(1 - Sin[2*Pi*\[Phi]\/360]\^2\/n\^2\);\), "\
\[IndentingNewLine]", \(xih[n_] := 
        1\/\((\((\((Cos[2*Pi*\[Phi]\/360])\)*\((c[n]\/Cos[2*Pi*\[Phi]\/360] - \
1)\)*\((1\/r1 - 1\/r2)\))\) + 1\/xoo)\);\), "\[IndentingNewLine]", \(xiv[n_] := 
        1\/\((\((1\/Cos[2*Pi*\[Phi]\/360]*\((c[n]\/Cos[2*Pi*\[Phi]\/360] - 1)\
\)*\((1\/r1 - 1\/r2)\))\) + 1\/xoo)\);\), "\[IndentingNewLine]", \(ASD[
          n_] := \ xih[n] - xiv[n];\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{n, ASD[n]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<n\>", "\<\>"}, 
          PlotRange \[Rule] {{1, 3}, {0, 2}}], {{{Hue[1], "\<ASD[n]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 19}, {Automatic, 1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3129, 56, 1344, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

