(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3815,         95]*)
(*NotebookOutlinePosition[      4460,        117]*)
(*  CellTagsIndexPosition[      4416,        113]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I12MICHDLS
Michelson interferometer
    
Beamsplitter is assumed to be a plane parallel plate
Fringe pattern depending on D for wavelength \[Lambda] = 0.0005, and \
depending on wavelength \[Lambda] for D = 0.003.
The angle \[Theta] = 0.
All length in mm.
        
1. Dependence on D\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        0;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(DD\  = \ 
        Range[0.027, 0.0325, 0.00001];\), "\[IndentingNewLine]", \(I1[
          DD_]\  = \ 
        Cos[\((2*Pi*DD*
                  Cos[\[Theta]])\)/\[Lambda]]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{DD, I1[DD]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<DD\>", "\<I1[DD]\>"}, 
            PlotRange \[Rule] {{0.026, 0.033}, {0, 1}}], {{{Hue[
                  1], "\<I1[DD]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ Dependence\ on\ \[Lambda]\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        Range[0.0004, \ 0.0008, 
          0.000001];\), "\[IndentingNewLine]", \(DD\  = \ 
        0.003;\), "\[IndentingNewLine]", 
    RowBox[{\(I2[\[Lambda]_]\  = \ 
          Cos[\((2*Pi*DD*Cos[\[Theta]])\)/\[Lambda]]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Lambda], I2[\[Lambda]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Lambda]\>", "\<I2[\[Lambda]]\>"}, 
          PlotRange \[Rule] {{3*10\^\(-4\), 8*10\^\(-4\)}, {0, 1}}], {{{Hue[
                1], "\<I2[\[Lambda]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{453, 553},
WindowMargins->{{43, Automatic}, {Automatic, 19}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2106, 43, 763, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

